/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.normal;
import DistLib.uniform;

public class lognormal {
    public static double density(double x2, double logmean, double logsd) {
        if (Double.isNaN(x2) || Double.isNaN(logmean) || Double.isNaN(logsd)) {
            return x2 + logmean + logsd;
        }
        if (logsd <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        double y = (Math.log(x2) - logmean) / logsd;
        return 0.3989422804014327 * Math.exp(-0.5 * y * y) / (x2 * logsd);
    }

    public static double cumulative(double x2, double logmean, double logsd) {
        if (Double.isNaN(x2) || Double.isNaN(logmean) || Double.isNaN(logsd)) {
            return x2 + logmean + logsd;
        }
        if (logsd <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 > 0.0) {
            return normal.cumulative(Math.log(x2), logmean, logsd);
        }
        return 0.0;
    }

    public static double quantile(double x2, double logmean, double logsd) {
        if (Double.isNaN(x2) || Double.isNaN(logmean) || Double.isNaN(logsd)) {
            return x2 + logmean + logsd;
        }
        if (x2 < 0.0 || x2 > 1.0 || logsd <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x2 > 0.0) {
            return Math.exp(normal.quantile(x2, logmean, logsd));
        }
        return 0.0;
    }

    public static double random(double logmean, double logsd, uniform PRNG) {
        if (Double.isInfinite(logmean) || Double.isInfinite(logsd) || logsd <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return Math.exp(normal.random(logmean, logsd, PRNG));
    }
}

