/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.uniform;

public class logistic {
    public static double density(double x2, double location, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x2 + location + scale;
        }
        if (scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double e = Math.exp(-(x2 - location) / scale);
        double f2 = 1.0 + e;
        return e / (scale * f2 * f2);
    }

    public static double cumulative(double x2, double location, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x2 + location + scale;
        }
        if (scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(x2)) {
            if (x2 > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        return 1.0 / (1.0 + Math.exp(-(x2 - location) / scale));
    }

    public static double quantile(double x2, double location, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x2 + location + scale;
        }
        if (scale <= 0.0 || x2 < 0.0 || x2 > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return location + scale * Math.log(x2 / (1.0 - x2));
    }

    public static double random(double location, double scale, uniform PRNG) {
        if (Double.isInfinite(location) || Double.isInfinite(scale)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double u = uniform.random();
        return location + scale * Math.log(u / (1.0 - u));
    }
}

