/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.beta;
import DistLib.misc;
import DistLib.normal;
import DistLib.uniform;

public class binomial {
    public static double density(double x2, double n, double p) {
        if (Double.isNaN(x2) || Double.isNaN(n) || Double.isNaN(p)) {
            return x2 + n + p;
        }
        if ((n = Math.floor(n + 0.5)) <= 0.0 || p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if ((x2 = Math.floor(x2 + 0.5)) < 0.0 || x2 > n) {
            return 0.0;
        }
        if (p == 0.0) {
            return x2 == 0.0 ? 1 : 0;
        }
        if (p == 1.0) {
            return x2 == n ? 1 : 0;
        }
        return Math.exp(misc.lfastchoose(n, x2) + Math.log(p) * x2 + (n - x2) * Math.log(1.0 - p));
    }

    public static double cumulative(double x2, double n, double p) {
        if (Double.isNaN(x2) || Double.isNaN(n) || Double.isNaN(p)) {
            return x2 + n + p;
        }
        if (Double.isInfinite(n) || Double.isInfinite(p)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if ((n = Math.floor(n + 0.5)) <= 0.0 || p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if ((x2 = Math.floor(x2)) < 0.0) {
            return 0.0;
        }
        if (n <= x2) {
            return 1.0;
        }
        return beta.cumulative(1.0 - p, n - x2, x2 + 1.0);
    }

    public static double quantile(double x2, double n, double p) {
        if (Double.isNaN(x2) || Double.isNaN(n) || Double.isNaN(p)) {
            return x2 + n + p;
        }
        if (Double.isInfinite(x2) || Double.isInfinite(n) || Double.isInfinite(p)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        n = Math.floor(n + 0.5);
        if (x2 < 0.0 || x2 > 1.0 || p <= 0.0 || p >= 1.0 || n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        if (x2 == 1.0) {
            return n;
        }
        double q = 1.0 - p;
        double mu = n * p;
        double sigma = Math.sqrt(n * p * q);
        double gamma2 = (q - p) / sigma;
        double z = normal.quantile(x2, 0.0, 1.0);
        double y = Math.floor(mu + sigma * (z + gamma2 * (z * z - 1.0) / 6.0) + 0.5);
        if ((z = binomial.cumulative(y, n, p)) >= x2) {
            while (true) {
                double d;
                z = binomial.cumulative(y - 1.0, n, p);
                if (d < x2) {
                    return y;
                }
                y -= 1.0;
            }
        }
        while (true) {
            double d;
            z = binomial.cumulative(y + 1.0, n, p);
            if (d >= x2) {
                return y + 1.0;
            }
            y += 1.0;
        }
    }

    public static double random(double nin, double pp, uniform PRNG) {
        double psave;
        int n;
        int ix;
        block18: {
            double u;
            double r;
            double qn;
            double g;
            double f2;
            block22: {
                double q;
                double p;
                int mp;
                int m;
                int k;
                int ix1;
                int i;
                double z2;
                double z;
                double ynorm;
                double xr;
                double xnpq;
                double xm;
                double xlr;
                double xll;
                double xl;
                double x2;
                double x1;
                double x3;
                double w2;
                double w;
                double v;
                double p4;
                double p3;
                double p2;
                double p1;
                double fm;
                double f22;
                double f1;
                double c;
                double amaxp;
                double alv;
                block21: {
                    double xnp;
                    double ffm;
                    double al;
                    block23: {
                        int nsave;
                        block20: {
                            block19: {
                                al = 0.0;
                                alv = 0.0;
                                amaxp = 0.0;
                                c = 0.0;
                                f2 = 0.0;
                                f1 = 0.0;
                                f22 = 0.0;
                                ffm = 0.0;
                                fm = 0.0;
                                g = 0.0;
                                p1 = 0.0;
                                p2 = 0.0;
                                p3 = 0.0;
                                p4 = 0.0;
                                qn = 0.0;
                                r = 0.0;
                                u = 0.0;
                                v = 0.0;
                                w = 0.0;
                                w2 = 0.0;
                                x3 = 0.0;
                                x1 = 0.0;
                                x2 = 0.0;
                                xl = 0.0;
                                xll = 0.0;
                                xlr = 0.0;
                                xm = 0.0;
                                xnp = 0.0;
                                xnpq = 0.0;
                                xr = 0.0;
                                ynorm = 0.0;
                                z = 0.0;
                                z2 = 0.0;
                                i = 0;
                                ix = 0;
                                ix1 = 0;
                                k = 0;
                                m = 0;
                                mp = 0;
                                n = 0;
                                p = 0.0;
                                q = 0.0;
                                psave = -1.0;
                                nsave = -1;
                                n = (int)Math.floor(nin + 0.5);
                                if (Double.isInfinite(n) || Double.isInfinite(pp) || (double)n < 0.0 || pp < 0.0 || pp > 1.0) {
                                    throw new ArithmeticException("Math Error: DOMAIN");
                                }
                                if ((double)n == 0.0 || pp == 0.0) {
                                    return 0.0;
                                }
                                if (pp == 1.0) {
                                    return n;
                                }
                                if (pp == psave) break block19;
                                psave = pp;
                                p = Math.min(psave, 1.0 - psave);
                                q = 1.0 - p;
                                break block20;
                            }
                            if (n != nsave) break block20;
                            if (!(xnp < 30.0)) break block21;
                            break block22;
                        }
                        xnp = (double)n * p;
                        nsave = n;
                        if (!(xnp < 30.0)) break block23;
                        qn = Math.pow(q, n);
                        r = p / q;
                        g = r * (double)(n + 1);
                        break block22;
                    }
                    ffm = xnp + p;
                    m = (int)ffm;
                    fm = m;
                    xnpq = xnp * q;
                    p1 = (double)((int)(2.195 * Math.sqrt(xnpq) - 4.6 * q)) + 0.5;
                    xm = fm + 0.5;
                    xl = xm - p1;
                    xr = xm + p1;
                    c = 0.134 + 20.5 / (15.3 + fm);
                    al = (ffm - xl) / (ffm - xl * p);
                    xll = al * (1.0 + 0.5 * al);
                    al = (xr - ffm) / (xr * q);
                    xlr = al * (1.0 + 0.5 * al);
                    p2 = p1 * (1.0 + c + c);
                    p3 = p2 + c / xll;
                    p4 = p3 + c / xlr;
                }
                while (true) {
                    u = uniform.random() * p4;
                    v = uniform.random();
                    if (u <= p1) {
                        ix = (int)(xm - p1 * v + u);
                        break block18;
                    }
                    if (u <= p2) {
                        x3 = xl + (u - p1) / c;
                        if ((v = v * c + 1.0 - Math.abs(xm - x3) / p1) > 1.0 || v <= 0.0) continue;
                        ix = (int)x3;
                    } else if (u > p3) {
                        ix = (int)(xr - Math.log(v) / xlr);
                        if (ix > n) continue;
                        v = v * (u - p3) * xlr;
                    } else {
                        ix = (int)(xl + Math.log(v) / xll);
                        if (ix < 0) continue;
                        v = v * (u - p2) * xll;
                    }
                    k = Math.abs(ix - m);
                    if (k <= 20 || (double)k >= xnpq / 2.0 - 1.0) {
                        f2 = 1.0;
                        r = p / q;
                        g = (double)(n + 1) * r;
                        if (m < ix) {
                            i = mp = m + 1;
                            while (i <= ix) {
                                f2 *= g / (double)i - r;
                                ++i;
                            }
                        } else if (m != ix) {
                            i = ix1 = ix + 1;
                            while (i <= m) {
                                f2 /= g / (double)i - r;
                                ++i;
                            }
                        }
                        if (!(v <= f2)) continue;
                        break block18;
                    }
                    amaxp = (double)k / xnpq * (((double)k * ((double)k / 3.0 + 0.625) + 0.1666666666666) / xnpq + 0.5);
                    ynorm = (double)(-k * k) / (2.0 * xnpq);
                    alv = Math.log(v);
                    if (alv < ynorm - amaxp) break block18;
                    if (!(alv <= ynorm + amaxp)) continue;
                    x1 = ix + 1;
                    f1 = fm + 1.0;
                    z = (double)(n + 1) - fm;
                    w = (double)(n - ix) + 1.0;
                    z2 = z * z;
                    x2 = x1 * x1;
                    f22 = f1 * f1;
                    w2 = w * w;
                    if (alv <= xm * Math.log(f1 / x1) + ((double)(n - m) + 0.5) * Math.log(z / w) + (double)(ix - m) * Math.log(w * p / x1 * q) + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / f22) / f22) / f22) / f22) / f1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / z2) / z2) / z2) / z2) / z / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / x2) / x2) / x2) / x2) / x1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / w2) / w2) / w2) / w2) / w / 166320.0) break;
                }
                break block18;
            }
            block3: while (true) {
                ix = 0;
                f2 = qn;
                for (u = uniform.random(); !(u < f2); u -= f2, f2 *= g / (double)(++ix) - r) {
                    if (ix > 110) continue block3;
                }
                break;
            }
        }
        if (psave > 0.5) {
            ix = n - ix;
        }
        return ix;
    }
}

