/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.GraphMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGraphMapping<V, E>
implements GraphMapping<V, E> {
    private Map<V, V> graphMappingForward;
    private Map<V, V> graphMappingReverse;
    private Graph<V, E> graph1;
    private Graph<V, E> graph2;

    public DefaultGraphMapping(Map<V, V> map, Map<V, V> map2, Graph<V, E> graph, Graph<V, E> graph2) {
        this.graph1 = graph;
        this.graph2 = graph2;
        this.graphMappingForward = map;
        this.graphMappingReverse = map2;
    }

    @Override
    public E getEdgeCorrespondence(E e, boolean bl) {
        Graph<V, E> graph;
        Graph<V, E> graph2;
        if (bl) {
            graph2 = this.graph1;
            graph = this.graph2;
        } else {
            graph2 = this.graph2;
            graph = this.graph1;
        }
        V v = this.getVertexCorrespondence(graph2.getEdgeSource(e), bl);
        V v2 = this.getVertexCorrespondence(graph2.getEdgeTarget(e), bl);
        if (v == null || v2 == null) {
            return null;
        }
        return graph.getEdge(v, v2);
    }

    @Override
    public V getVertexCorrespondence(V v, boolean bl) {
        Map<V, V> map = bl ? this.graphMappingForward : this.graphMappingReverse;
        return map.get(v);
    }
}

