/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.LongMatrix;
import org.apfloat.internal.LongModConstants;
import org.apfloat.internal.LongParallelFNTStrategy;
import org.apfloat.internal.Scramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class LongSixStepFNTStrategy
extends LongParallelFNTStrategy {
    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (length > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + length + " > " + 0x1800000000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        if (length < 2L) {
            return;
        }
        assert (length == (length & -length));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.transform(arrayAccess, modulus);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (Math.max(length, totalTransformLength) > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(length, totalTransformLength) + " > " + 0x1800000000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        if (length < 2L) {
            return;
        }
        assert (length == (length & -length));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.inverseTransform(arrayAccess, modulus, totalTransformLength);
        arrayAccess.close();
    }

    void transform(ArrayAccess arrayAccess, int modulus) throws ApfloatRuntimeException {
        int length = arrayAccess.getLength();
        if (length < 2) {
            return;
        }
        assert (length == (length & -length));
        int logLength = Util.log2down(length);
        int n1 = logLength >> 1;
        int n2 = logLength - n1;
        n1 = 1 << n1;
        n2 = 1 << n2;
        this.setModulus(LongModConstants.MODULUS[modulus]);
        long w = this.getForwardNthRoot(LongModConstants.PRIMITIVE_ROOT[modulus], length);
        long w1 = this.modPow(w, n2);
        long[] wTable = this.createWTable(w1, n1);
        int[] permutationTable = Scramble.createScrambleTable(n1);
        LongMatrix.transpose(arrayAccess, n1, n2);
        this.transformRows(n1, n2, false, arrayAccess, wTable, permutationTable);
        LongMatrix.transpose(arrayAccess, n2, n1);
        this.multiplyElements(arrayAccess, 0, n1, n2, w, 1L);
        if (n1 != n2) {
            long w2 = this.modPow(w, n1);
            wTable = this.createWTable(w2, n2);
        }
        this.transformRows(n2, n1, false, arrayAccess, wTable, null);
    }

    void inverseTransform(ArrayAccess arrayAccess, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        int length = arrayAccess.getLength();
        if (length < 2) {
            return;
        }
        assert (length == (length & -length));
        int logLength = Util.log2down(length);
        int n1 = logLength >> 1;
        int n2 = logLength - n1;
        n1 = 1 << n1;
        n2 = 1 << n2;
        this.setModulus(LongModConstants.MODULUS[modulus]);
        long w = this.getInverseNthRoot(LongModConstants.PRIMITIVE_ROOT[modulus], length);
        long w2 = this.modPow(w, n1);
        long inverseTotalTransformLength = this.modDivide(1L, totalTransformLength);
        long[] wTable = this.createWTable(w2, n2);
        int[] permutationTable = Scramble.createScrambleTable(n1);
        this.transformRows(n2, n1, true, arrayAccess, wTable, null);
        this.multiplyElements(arrayAccess, 0, n1, n2, w, inverseTotalTransformLength);
        LongMatrix.transpose(arrayAccess, n1, n2);
        if (n1 != n2) {
            for (int i = 1; i < n1; ++i) {
                wTable[i] = wTable[2 * i];
            }
        }
        this.transformRows(n1, n2, true, arrayAccess, wTable, permutationTable);
        LongMatrix.transpose(arrayAccess, n2, n1);
    }
}

