/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleParallelFNTStrategy;
import org.apfloat.internal.Scramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class DoubleTwoPassFNTStrategy
extends DoubleParallelFNTStrategy {
    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess;
        int i;
        long length = dataStorage.getSize();
        if (length > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + length + " > " + 0x180000000000L);
        }
        if (length < 2L) {
            return;
        }
        assert (length == (length & -length));
        int logLength = Util.log2down(length);
        int n1 = logLength >> 1;
        int n2 = logLength - n1;
        n1 = 1 << n1;
        n2 = 1 << n2;
        this.setModulus(DoubleModConstants.MODULUS[modulus]);
        double w = this.getForwardNthRoot(DoubleModConstants.PRIMITIVE_ROOT[modulus], length);
        double w1 = this.modPow(w, n2);
        double[] wTable = this.createWTable(w1, n1);
        int[] permutationTable = Scramble.createScrambleTable(n1);
        int maxBlockSize = this.getMaxMemoryBlockSize(length);
        if (n1 > maxBlockSize || n2 > maxBlockSize) {
            throw new ApfloatInternalException("Not enough memory available to fit one row or column of matrix to memory; n1=" + n1 + ", n2=" + n2 + ", available=" + maxBlockSize);
        }
        int b = maxBlockSize / n1;
        for (i = 0; i < n2; i += b) {
            arrayAccess = dataStorage.getTransposedArray(3, i, b, n1);
            this.transformRows(n1, b, false, arrayAccess, wTable, permutationTable);
            arrayAccess.close();
        }
        if (n1 != n2) {
            double w2 = this.modPow(w, n1);
            wTable = this.createWTable(w2, n2);
        }
        b = maxBlockSize / n2;
        for (i = 0; i < n1; i += b) {
            arrayAccess = dataStorage.getArray(3, i * n2, b * n2);
            this.multiplyElements(arrayAccess, i, b, n2, w, 1.0);
            this.transformRows(n2, b, false, arrayAccess, wTable, null);
            arrayAccess.close();
        }
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess;
        int i;
        long length = dataStorage.getSize();
        if (Math.max(length, totalTransformLength) > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(length, totalTransformLength) + " > " + 0x180000000000L);
        }
        if (length < 2L) {
            return;
        }
        assert (length == (length & -length));
        int logLength = Util.log2down(length);
        int n1 = logLength >> 1;
        int n2 = logLength - n1;
        n1 = 1 << n1;
        n2 = 1 << n2;
        this.setModulus(DoubleModConstants.MODULUS[modulus]);
        double w = this.getInverseNthRoot(DoubleModConstants.PRIMITIVE_ROOT[modulus], length);
        double w2 = this.modPow(w, n1);
        double inverseTotalTransformLength = this.modDivide(1.0, totalTransformLength);
        double[] wTable = this.createWTable(w2, n2);
        int[] permutationTable = Scramble.createScrambleTable(n1);
        int maxBlockSize = this.getMaxMemoryBlockSize(length);
        if (n1 > maxBlockSize || n2 > maxBlockSize) {
            throw new ApfloatInternalException("Not enough memory available to fit one row or column of matrix to memory; n1=" + n1 + ", n2=" + n2 + ", available=" + maxBlockSize);
        }
        int b = maxBlockSize / n2;
        for (i = 0; i < n1; i += b) {
            arrayAccess = dataStorage.getArray(3, i * n2, b * n2);
            this.transformRows(n2, b, true, arrayAccess, wTable, null);
            this.multiplyElements(arrayAccess, i, b, n2, w, inverseTotalTransformLength);
            arrayAccess.close();
        }
        if (n1 != n2) {
            for (i = 1; i < n1; ++i) {
                wTable[i] = wTable[2 * i];
            }
        }
        b = maxBlockSize / n1;
        for (i = 0; i < n2; i += b) {
            arrayAccess = dataStorage.getTransposedArray(3, i, b, n1);
            this.transformRows(n1, b, true, arrayAccess, wTable, permutationTable);
            arrayAccess.close();
        }
    }

    private int getMaxMemoryBlockSize(long length) {
        ApfloatContext ctx = ApfloatContext.getContext();
        long maxMemoryBlockSize = Util.round2down(Math.min(ctx.getMaxMemoryBlockSize() / 8L, Integer.MAX_VALUE));
        int maxBlockSize = (int)Math.min(length, maxMemoryBlockSize);
        return maxBlockSize;
    }
}

