/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Formatter;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.AprationalMath;
import org.apfloat.FormattingHelper;
import org.apfloat.spi.ApfloatImpl;
import org.apfloat.spi.RadixConstants;

public class Aprational
extends Apfloat {
    private static final long serialVersionUID = -224128535732558313L;
    private static final long UNDEFINED = Long.MIN_VALUE;
    private Apint numerator;
    private Apint denominator;
    private long scale = Long.MIN_VALUE;
    private transient Apfloat inverseDen = null;
    private transient Apfloat approx = null;

    protected Aprational() {
    }

    public Aprational(Apint value2) throws ApfloatRuntimeException {
        this(value2, ONE);
    }

    public Aprational(Apint numerator, Apint denominator) throws IllegalArgumentException, ApfloatRuntimeException {
        this.numerator = numerator;
        this.denominator = denominator;
        this.checkDenominator();
        this.reduce();
    }

    public Aprational(String value2) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(value2, ApfloatContext.getContext().getDefaultRadix());
    }

    public Aprational(String value2, int radix) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int index = value2.indexOf(47);
        if (index < 0) {
            this.numerator = new Apint(value2, radix);
            this.denominator = ONE;
            return;
        }
        this.numerator = new Apint(value2.substring(0, index).trim(), radix);
        this.denominator = new Apint(value2.substring(index + 1).trim(), radix);
        this.checkDenominator();
        this.reduce();
    }

    public Aprational(PushbackReader in) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(in, ApfloatContext.getContext().getDefaultRadix());
    }

    public Aprational(PushbackReader in, int radix) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this.numerator = new Apint(in, radix);
        ApfloatHelper.extractWhitespace(in);
        if (!ApfloatHelper.readMatch(in, 47)) {
            this.denominator = ONE;
            return;
        }
        ApfloatHelper.extractWhitespace(in);
        this.denominator = new Apint(in, radix);
        this.checkDenominator();
        this.reduce();
    }

    public Aprational(BigInteger value2) throws ApfloatRuntimeException {
        this.numerator = new Apint(value2);
        this.denominator = ONE;
    }

    public Aprational(BigInteger value2, int radix) throws ApfloatRuntimeException {
        this.numerator = new Apint(value2, radix);
        this.denominator = ONE;
    }

    public Apint numerator() {
        return this.numerator;
    }

    public Apint denominator() {
        return this.denominator;
    }

    public int radix() {
        return this.numerator() == ONE ? this.denominator().radix() : this.numerator().radix();
    }

    public long precision() throws ApfloatRuntimeException {
        return Long.MAX_VALUE;
    }

    public synchronized long scale() throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return -9223372036854775807L;
        }
        if (this.scale == Long.MIN_VALUE) {
            long scale = this.numerator().scale() - this.denominator().scale();
            scale = scale > 0L ? this.truncate().scale() : AprationalMath.scale(this, 1L - scale).truncate().scale() + scale - 1L;
            this.scale = scale;
        }
        return this.scale;
    }

    public long size() throws ApfloatRuntimeException {
        Apint dividend = this.denominator();
        for (int i = 0; i < RadixConstants.RADIX_FACTORS[this.radix()].length; ++i) {
            Apint[] quotientAndRemainder;
            Apint factor = new Apint((long)RadixConstants.RADIX_FACTORS[this.radix()][i], this.radix());
            while ((quotientAndRemainder = ApintMath.div(dividend, factor))[1].signum() == 0) {
                dividend = quotientAndRemainder[0];
            }
        }
        long size2 = !dividend.equals(ONE) ? Long.MAX_VALUE : ApintMath.scale(this.numerator(), this.denominator().scale() * 5L).divide(this.denominator()).size();
        return size2;
    }

    public int signum() {
        return this.numerator().signum();
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.numerator().isShort() && this.denominator().equals(ONE);
    }

    public Aprational negate() throws ApfloatRuntimeException {
        return new Aprational(this.numerator().negate(), this.denominator());
    }

    public Aprational add(Aprational x2) throws ApfloatRuntimeException {
        return new Aprational(this.numerator().multiply(x2.denominator()).add(this.denominator().multiply(x2.numerator())), this.denominator().multiply(x2.denominator())).reduce();
    }

    public Aprational subtract(Aprational x2) throws ApfloatRuntimeException {
        return new Aprational(this.numerator().multiply(x2.denominator()).subtract(this.denominator().multiply(x2.numerator())), this.denominator().multiply(x2.denominator())).reduce();
    }

    public Aprational multiply(Aprational x2) throws ApfloatRuntimeException {
        Aprational result2 = new Aprational(this.numerator().multiply(x2.numerator()), this.denominator().multiply(x2.denominator()));
        if (this == x2) {
            return result2;
        }
        return result2.reduce();
    }

    public Aprational divide(Aprational x2) throws ArithmeticException, ApfloatRuntimeException {
        if (x2.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.signum() == 0) {
            return this;
        }
        return new Aprational(this.numerator().multiply(x2.denominator()), this.denominator().multiply(x2.numerator())).reduce();
    }

    public Aprational mod(Aprational x2) throws ApfloatRuntimeException {
        if (x2.signum() == 0) {
            return x2;
        }
        if (this.signum() == 0) {
            return this;
        }
        return this.subtract(this.divide(x2).truncate().multiply(x2));
    }

    public Apint floor() throws ApfloatRuntimeException {
        if (this.signum() >= 0) {
            return this.truncate();
        }
        return this.roundAway();
    }

    public Apint ceil() throws ApfloatRuntimeException {
        if (this.signum() <= 0) {
            return this.truncate();
        }
        return this.roundAway();
    }

    public Apint truncate() throws ApfloatRuntimeException {
        return this.numerator().divide(this.denominator());
    }

    private Apint roundAway() throws ApfloatRuntimeException {
        Apint[] div2 = ApintMath.div(this.numerator(), this.denominator());
        if (div2[1].signum() == 0) {
            return div2[0];
        }
        return div2[0].add(new Apint((long)this.signum(), div2[0].radix()));
    }

    public Aprational toRadix(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return new Aprational(this.numerator().toRadix(radix), this.denominator().toRadix(radix));
    }

    public int compareTo(Aprational x2) {
        Apint a = this.numerator().multiply(x2.denominator());
        Apint b = x2.numerator().multiply(this.denominator());
        return a.compareTo(b);
    }

    public int compareTo(Apfloat x2) {
        if (x2 instanceof Aprational) {
            return this.compareTo((Aprational)x2);
        }
        Apfloat a = this.numerator().precision(Long.MAX_VALUE);
        Apfloat b = x2.multiply(this.denominator()).precision(Long.MAX_VALUE);
        return a.compareTo(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Aprational) {
            Aprational that = (Aprational)obj;
            return this.numerator().equals(that.numerator()) && this.denominator().equals(that.denominator());
        }
        if (obj instanceof Apfloat) {
            Apfloat that = (Apfloat)obj;
            Apfloat a = this.numerator().precision(Long.MAX_VALUE);
            Apfloat b = that.multiply(this.denominator()).precision(Long.MAX_VALUE);
            return a.equals(b);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.numerator().hashCode() * 3 + this.denominator().hashCode();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean pretty) throws ApfloatRuntimeException {
        return this.numerator().toString(pretty) + (this.denominator().equals(ONE) ? "" : '/' + this.denominator().toString(pretty));
    }

    public void writeTo(Writer out) throws IOException, ApfloatRuntimeException {
        this.writeTo(out, true);
    }

    public void writeTo(Writer out, boolean pretty) throws IOException, ApfloatRuntimeException {
        this.numerator().writeTo(out, pretty);
        if (!this.denominator().equals(ONE)) {
            out.write(47);
            this.denominator().writeTo(out, pretty);
        }
    }

    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.denominator().equals(ONE)) {
            this.numerator().formatTo(formatter, flags, width, precision);
        } else if (width == -1) {
            this.numerator().formatTo(formatter, flags, width, precision);
            formatter.format("/", new Object[0]);
            this.denominator().formatTo(formatter, flags, width, precision);
        } else {
            try {
                Writer out = FormattingHelper.wrapAppendableWriter(formatter.out());
                out = FormattingHelper.wrapPadWriter(out, (flags & 1) == 1);
                formatter = new Formatter(out, formatter.locale());
                this.numerator().formatTo(formatter, flags, -1, precision);
                formatter.format("/", new Object[0]);
                this.denominator().formatTo(formatter, flags, -1, precision);
                FormattingHelper.finishPad(out, width);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    protected ApfloatImpl getImpl(long precision) throws ApfloatRuntimeException {
        return this.ensureApprox(precision).getImpl(precision);
    }

    private void checkDenominator() throws IllegalArgumentException {
        if (this.denominator.signum() == 0) {
            throw new IllegalArgumentException("Denominator is zero");
        }
    }

    private Aprational reduce() throws IllegalArgumentException, ApfloatRuntimeException {
        if (this.numerator.signum() == 0) {
            this.denominator = ONE;
        } else {
            if (!this.numerator.equals(ONE) && !this.denominator.equals(ONE)) {
                if (this.numerator.radix() != this.denominator.radix()) {
                    throw new IllegalArgumentException("Numerator and denominator must have the same radix");
                }
                Apint gcd = ApintMath.gcd(this.numerator, this.denominator);
                this.numerator = this.numerator.divide(gcd);
                this.denominator = this.denominator.divide(gcd);
            }
            int sign2 = this.numerator.signum() * this.denominator.signum();
            this.denominator = ApintMath.abs(this.denominator);
            if (sign2 != this.numerator.signum()) {
                this.numerator = this.numerator.negate();
            }
        }
        return this;
    }

    private synchronized Apfloat ensureApprox(long precision) throws ApfloatRuntimeException {
        if (!this.hasApprox(precision)) {
            if (this.denominator().equals(ONE)) {
                this.approx = this.numerator();
            } else {
                precision = Math.max(precision, 1L);
                if (this.denominator().isShort()) {
                    this.approx = this.numerator().precision(precision).divide(this.denominator());
                } else {
                    this.inverseDen = ApfloatMath.inverseRoot(this.denominator(), 1L, precision, this.inverseDen);
                    this.approx = this.numerator().multiply(this.inverseDen);
                }
            }
        }
        return this.approx;
    }

    private boolean hasApprox(long precision) throws ApfloatRuntimeException {
        return this.approx != null && this.approx.precision() >= precision;
    }
}

