/*
 * Decompiled with CFR 0.152.
 */
package flanagan.plot;

import flanagan.plot.Plot;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PlotGraph
extends Plot
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected int graphWidth = 800;
    protected int graphHeight = 600;
    protected int closeChoice = 1;
    protected JFrame window = new JFrame("Michael T Flanagan's plotting program - PlotGraph");

    public PlotGraph(double[][] data2) {
        super(data2);
    }

    public PlotGraph(double[] xData, double[] yData) {
        super(xData, yData);
    }

    public void rescaleY(double yScaleFactor) {
        this.graphHeight = (int)Math.round((double)this.graphHeight * yScaleFactor);
        this.yLen = (int)Math.round((double)this.yLen * yScaleFactor);
        this.yTop = (int)Math.round((double)this.yTop * yScaleFactor);
        this.yBot = this.yTop + this.yLen;
    }

    public void rescaleX(double xScaleFactor) {
        this.graphWidth = (int)Math.round((double)this.graphWidth * xScaleFactor);
        this.xLen = (int)Math.round((double)this.xLen * xScaleFactor);
        this.xBot = (int)Math.round((double)this.xBot * xScaleFactor);
        this.xTop = this.xBot + this.xLen;
    }

    public int getGraphWidth() {
        return this.graphWidth;
    }

    public int getGraphHeight() {
        return this.graphHeight;
    }

    public void setGraphHeight(int graphHeight) {
        this.graphHeight = graphHeight;
    }

    public void setGraphWidth(int graphWidth) {
        this.graphWidth = graphWidth;
    }

    public int getCloseChoice() {
        return this.closeChoice;
    }

    public void setCloseChoice(int choice) {
        this.closeChoice = choice;
    }

    @Override
    public void paint(Graphics g) {
        double newGraphWidth = this.getSize().width;
        double newGraphHeight = this.getSize().height;
        double xScale = newGraphWidth / (double)this.graphWidth;
        double yScale = newGraphHeight / (double)this.graphHeight;
        this.rescaleX(xScale);
        this.rescaleY(yScale);
        this.graph(g);
    }

    public void plot() {
        this.setSize(this.graphWidth, this.graphHeight);
        this.window.getContentPane().setBackground(Color.white);
        if (this.closeChoice == 1) {
            this.window.setDefaultCloseOperation(3);
        } else {
            this.window.setDefaultCloseOperation(1);
        }
        this.window.getContentPane().add("Center", this);
        this.window.pack();
        this.window.setResizable(true);
        this.window.toFront();
        this.window.setVisible(true);
    }

    public void endProgram() {
        int ans = JOptionPane.showConfirmDialog(null, "Do you wish to end the program\nThis will also close the graph window or windows", "End Program", 0, 3);
        if (ans == 0) {
            System.exit(0);
        } else {
            String message = "Now you must press the appropriate escape key/s, e.g. Ctrl C, to exit this program\n";
            if (this.closeChoice == 1) {
                message = String.valueOf(message) + "or close a graph window";
            }
            JOptionPane.showMessageDialog(null, message);
        }
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

