/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physprop;

import javax.swing.JOptionPane;

public class IonicRadii {
    private static String[] ions1 = new String[]{"Ag+", "Al+++", "Au+", "Au+++", "Ba++", "Be++", "Bi+++", "Ca++", "Cd++", "Ce+++", "Ce++++", "Co++ ls", "Co++ hs", "Co+++ ls", "Co+++ hs", "Cr++ ls", "Cr++ hs", "Cr+++", "Cs+", "Cu+", "Cu++", "Dy+++", "Er+++", "Eu++", "Eu+++", "Fe++ ls", "Fe++ hs", "Fe+++ ls", "Fe+++ hs", "Ga+++", "Gd+++", "Hf++++", "Hg+", "Hg++", "Ho+++", "In+++", "Ir+++", "K+", "La+++", "Li+", "Lu+++", "Mg++", "Mn++ ls", "Mn++ hs", "Mn+++ ls", "Mn+++ hs", "Mo+++", "Na+", "Nb+++", "Nd+++", "Ni++", "Pb++", "Pd++", "Pm+++", "Pr+++", "Pt++", "Rb+", "Rh+++", "Ru+++", "Sb+++", "Sc+++", "Sm+++", "Sr++", "Ta+++", "Tb+++", "Th++++", "Ti++", "Ti+++", "Ti++++", "Tl+", "Tl+++", "Tm+++", "U+++", "U++++", "V++", "V+++", "Y+++", "Yb++", "Yb+++", "Zn++", "Zr++++", "Br-", "Cl-", "F-", "H-", "I-", "O--", "S--", "Se--", "Te--", "OH-"};
    private static String[] ions2 = new String[]{"Ag1+", "Al3+", "Au1+", "Au3+", "Ba2+", "Be2+", "Bi3+", "Ca2+", "Cd2+", "Ce3+", "Ce4+", "Co2+ ls", "Co2+ hs", "Co3+ ls", "Co3+ hs", "Cr2+ ls", "Cr2+ hs", "Cr3+", "Cs1+", "Cu1+", "Cu2+", "Dy3+", "Er3+", "Eu2+", "Eu3+", "Fe2+ ls", "Fe2+ hs", "Fe3+ ls", "Fe3+ hs", "Ga3+", "Gd3+", "Hf4+", "Hg1+", "Hg2+", "Ho3+", "In3+", "Ir3+", "K1+", "La3+", "Li1+", "Lu3+", "Mg2+", "Mn2+ ls", "Mn2+ hs", "Mn3+ ls", "Mn3+ hs", "Mo3+", "Na1+", "Nb3+", "Nd3+", "Ni2+", "Pb2+", "Pd2+", "Pm3+", "Pr3+", "Pt2+", "Rb1+", "Rh3+", "Ru3+", "Sb3+", "Sc3+", "Sm3+", "Sr2+", "Ta3+", "Tb3+", "Th4+", "Ti2+", "Ti3+", "Ti4+", "Tl1+", "Tl3+", "Tm3+", "U3+", "U4+", "V2+", "V3+", "Y3+", "Yb2+", "Yb3+", "Zn2+", "Zr4+", "Br1-", "Cl1-", "F1-", "H1-", "I1-", "O2-", "S2-", "Se2-", "Te2-", "OH1-"};
    private static String[] ions3 = new String[]{"Ag+1", "Al+3", "Au+1", "Au+3", "Ba+2", "Be+2", "Bi+3", "Ca+2", "Cd+2", "Ce+3", "Ce+4", "Co+2 ls", "Co+2 hs", "Co+3 ls", "Co+3 hs", "Cr+2 ls", "Cr+2 hs", "Cr+3", "Cs+1", "Cu+1", "Cu+2", "Dy+3", "Er+3", "Eu+2", "Eu+3", "Fe+2 ls", "Fe+2 hs", "Fe+3 ls", "Fe+3 hs", "Ga+3", "Gd+3", "Hf+4", "Hg+1", "Hg+2", "Ho+3", "In+3", "Ir+3", "K+1", "La+3", "Li+1", "Lu+3", "Mg+2", "Mn+2 ls", "Mn+2 hs", "Mn+3 ls", "Mn+3 hs", "Mo+3", "Na+1", "Nb+3", "Nd+3", "Ni+2", "Pb+2", "Pd+2", "Pm+3", "Pr+3", "Pt+2", "Rb+1", "Rh+3", "Ru+3", "Sb+3", "Sc+3", "Sm+3", "Sr+2", "Ta+3", "Tb+3", "Th+4", "Ti+2", "Ti+3", "Ti+4", "Tl+1", "Tl+3", "Tm+3", "U+3", "U+4", "V+2", "V+3", "Y+3", "Yb+2", "Yb+3", "Zn+2", "Zr+4", "Br-1", "Cl-1", "F-1", "H-1", "I-1", "O-2", "S-2", "Se-2", "Te-2", "OH-1"};
    private static String[] ions4 = new String[]{"Ag(+)", "Al(+++)", "Au(+)", "Au(+++)", "Ba(++)", "Be(++)", "Bi(+++)", "Ca(++)", "Cd(++)", "Ce(+++)", "Ce(++++)", "Co(++) ls", "Co(++) hs", "Co(+++) ls", "Co(+++) hs", "Cr(++) ls", "Cr(++) hs", "Cr(+++)", "Cs(+)", "Cu(+)", "Cu(++)", "Dy(+++)", "Er(+++)", "Eu(++)", "Eu(+++)", "Fe(++) ls", "Fe(++) hs", "Fe(+++) ls", "Fe(+++) hs", "Ga(+++)", "Gd(+++)", "Hf(++++)", "Hg(+)", "Hg(++)", "Ho(+++)", "In(+++)", "Ir(+++)", "K(+)", "La(+++)", "Li(+)", "Lu(+++)", "Mg(++)", "Mn(++) ls", "Mn(++) hs", "Mn(+++) ls", "Mn(+++) hs", "Mo(+++)", "Na(+)", "Nb(+++)", "Nd(+++)", "Ni(++)", "Pb(++)", "Pd(++)", "Pm(+++)", "Pr(+++)", "Pt(++)", "Rb(+)", "Rh(+++)", "Ru(+++)", "Sb(+++)", "Sc(+++)", "Sm(+++)", "Sr(++)", "Ta(+++)", "Tb(+++)", "Th(++++)", "Ti(++)", "Ti(+++)", "Ti(++++)", "Tl(+)", "Tl(+++)", "Tm(+++)", "U(+++)", "U(++++)", "V(++)", "V(+++)", "Y(+++)", "Yb(++)", "Yb(+++)", "Zn(++)", "Zr(++++)", "Br(-)", "Cl(-)", "F(-)", "H(-)", "I(-)", "O(--)", "S(--)", "Se(--)", "Te(--)", "OH(-)"};
    private static String[] ions5 = new String[]{"Ag(1+)", "Al(3+)", "Au(1+)", "Au(3+)", "Ba(2+)", "Be(2+)", "Bi(3+)", "Ca(2+)", "Cd(2+)", "Ce(3+)", "Ce(4+)", "Co(2+) ls", "Co(2+) hs", "Co(3+) ls", "Co(3+) hs", "Cr(2+) ls", "Cr(2+) hs", "Cr(3+)", "Cs(1+)", "Cu(1+)", "Cu(2+)", "Dy(3+)", "Er(3+)", "Eu(2+)", "Eu(3+)", "Fe(2+) ls", "Fe(2+) hs", "Fe(3+) ls", "Fe(3+) hs", "Ga(3+)", "Gd(3+)", "Hf(4+)", "Hg(1+)", "Hg(2+)", "Ho(3+)", "In(3+)", "Ir(3+)", "K(1+)", "La(3+)", "Li(1+)", "Lu(3+)", "Mg(2+)", "Mn(2+) ls", "Mn(2+) hs", "Mn(3+) ls", "Mn(3+) hs", "Mo(3+)", "Na(1+)", "Nb(3+)", "Nd(3+)", "Ni(2+)", "Pb(2+)", "Pd(2+)", "Pm(3+)", "Pr(3+)", "Pt(2+)", "Rb(1+)", "Rh(3+)", "Ru(3+)", "Sb(3+)", "Sc(3+)", "Sm(3+)", "Sr(2+)", "Ta(3+)", "Tb(3+)", "Th(4+)", "Ti(2+)", "Ti(3+)", "Ti(4+)", "Tl(1+)", "Tl(3+)", "Tm(3+)", "U(3+)", "U(4+)", "V(2+)", "V(3+)", "Y(3+)", "Yb(2+)", "Yb(3+)", "Zn(2+)", "Zr(4+)", "Br(1-)", "Cl(1-)", "F(1-)", "H(1-)", "I(1-)", "O(2-)", "S(2-)", "Se(2-)", "Te(2-)", "OH(1-)"};
    private static String[] ions6 = new String[]{"Ag(+1)", "Al(+3)", "Au(+1)", "Au(+3)", "Ba(+2)", "Be(+2)", "Bi(+3)", "Ca(+2)", "Cd(+2)", "Ce(+3)", "Ce(+4)", "Co(+2) ls", "Co(+2) hs", "Co(+3) ls", "Co(+3) hs", "Cr(+2) ls", "Cr(+2) hs", "Cr(+3)", "Cs(+1)", "Cu(+1)", "Cu(+2)", "Dy(+3)", "Er(+3)", "Eu(+2)", "Eu(+3)", "Fe(+2) ls", "Fe(+2) hs", "Fe(+3) ls", "Fe(+3) hs", "Ga(+3)", "Gd(+3)", "Hf(+4)", "Hg(+1)", "Hg(+2)", "Ho(+3)", "In(+3)", "Ir(+3)", "K(+1)", "La(+3)", "Li(+1)", "Lu(+3)", "Mg(+2)", "Mn(+2) ls", "Mn(+2) hs", "Mn(+3) ls", "Mn(+3) hs", "Mo(+3)", "Na(+1)", "Nb(+3)", "Nd(+3)", "Ni(+2)", "Pb(+2)", "Pd(+2)", "Pm(+3)", "Pr(+3)", "Pt(+2)", "Rb(+1)", "Rh(+3)", "Ru(+3)", "Sb(+3)", "Sc(+3)", "Sm(+3)", "Sr(+2)", "Ta(+3)", "Tb(+3)", "Th(+4)", "Ti(+2)", "Ti(+3)", "Ti(+4)", "Tl(+1)", "Tl(+3)", "Tm(+3)", "U(+3)", "U(+4)", "V(+2)", "V(+3)", "Y(+3)", "Yb(+2)", "Yb(+3)", "Zn(+2)", "Zr(+4)", "Br(-1)", "Cl(-1)", "F(-1)", "H(-1)", "I(-1)", "O(-2)", "S(-2)", "Se(-2)", "Te(-2)", "OH(-1)"};
    private static boolean[] spins;
    private static int[] ionCharge;
    private static double[] radii;
    private static String[] hydratedIons1;
    private static String[] hydratedIons2;
    private static String[] hydratedIons3;
    private static String[] hydratedIons4;
    private static String[] hydratedIons5;
    private static String[] hydratedIons6;
    private static double[] hydratedRadii;
    private static int nIons;
    private static int nHydratedIons;

    static {
        boolean[] blArray = new boolean[91];
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[25] = true;
        blArray[26] = true;
        blArray[27] = true;
        blArray[28] = true;
        blArray[42] = true;
        blArray[43] = true;
        blArray[44] = true;
        blArray[45] = true;
        spins = blArray;
        ionCharge = new int[]{1, 3, 1, 3, 2, 2, 3, 2, 2, 3, 4, 2, 2, 3, 3, 2, 2, 3, 1, 1, 2, 3, 3, 2, 3, 2, 2, 3, 3, 3, 3, 4, 1, 2, 3, 3, 3, 1, 3, 1, 3, 2, 2, 2, 3, 3, 3, 1, 3, 3, 2, 2, 2, 3, 3, 2, 1, 3, 3, 3, 3, 3, 2, 3, 3, 4, 2, 3, 4, 1, 3, 3, 3, 4, 2, 3, 3, 2, 3, 2, 4, -1, -1, -1, -1, -1, -2, -2, -2, -2, -1};
        radii = new double[]{129.0, 67.5, 151.0, 99.0, 149.0, 59.0, 117.0, 114.0, 109.0, 115.0, 101.0, 79.0, 88.5, 68.5, 75.0, 87.0, 94.0, 75.5, 181.0, 91.0, 87.0, 105.2, 103.0, 131.0, 108.7, 75.0, 92.0, 69.0, 78.5, 76.0, 107.8, 85.0, 133.0, 116.0, 104.1, 94.0, 82.0, 152.0, 117.2, 90.0, 100.1, 86.0, 81.0, 97.0, 72.0, 78.5, 83.0, 116.0, 86.0, 112.3, 83.0, 133.0, 100.0, 111.0, 113.0, 94.0, 166.0, 80.5, 82.0, 90.0, 88.5, 109.8, 132.0, 86.0, 106.3, 108.0, 100.0, 81.0, 74.5, 164.0, 102.5, 102.0, 116.5, 103.0, 93.0, 78.0, 104.0, 116.0, 100.8, 88.0, 86.0, 167.0, 182.0, 119.0, 139.0, 206.0, 126.0, 170.0, 184.0, 207.0, 120.0};
        hydratedIons1 = new String[]{"Ag+", "Al+++", "Be++", "Ca++", "Cd++", "Cs+", "K+", "Li+", "Mg++", "Na+", "Pb++", "Rb+", "Tl+", "Zn++", "H30+", "NH4+", "Cl-", "Br-", "F-", "I-", "NO3-", "OH-"};
        hydratedIons2 = new String[]{"Ag1+", "Al3+", "Be2+", "Ca2+", "Cd2+", "Cs1+", "K1+", "Li1+", "Mg2+", "Na1+", "Pb2+", "Rb1+", "Tl1+", "Zn2+", "H301+", "NH41+", "Cl1-", "Br1-", "F1-", "I1-", "NO31-", "OH1-"};
        hydratedIons3 = new String[]{"Ag+1", "Al+3", "Be+2", "Ca+2", "Cd+2", "Cs+1", "K+1", "Li+1", "Mg+2", "Na+1", "Pb+2", "Rb+1", "Tl+1", "Zn+2", "H30+1", "NH4+1", "Cl-1", "Br-1", "F-1", "I-1", "NO3-1", "OH-1"};
        hydratedIons4 = new String[]{"Ag(+)", "Al(+++)", "Be(++)", "Ca(++)", "Cd(++)", "Cs(+)", "K(+)", "Li(+)", "Mg(++)", "Na(+)", "Pb(++)", "Rb(+)", "Tl(+)", "Zn(++)", "H30(+)", "NH4(+)", "Cl(-)", "Br(-)", "F(-)", "I(-)", "NO3(-)", "OH(-)"};
        hydratedIons5 = new String[]{"Ag(1+)", "Al(3+)", "Be(2+)", "Ca(2+)", "Cd(2+)", "Cs(1+)", "K(1+)", "Li(1+)", "Mg(2+)", "Na(1+)", "Pb(2+)", "Rb(1+)", "Tl(1+)", "Zn(2+)", "H30(1+)", "NH4(1+)", "Cl(1-)", "Br(1-)", "F(1-)", "I(1-)", "NO3(1-)", "OH(1-)"};
        hydratedIons6 = new String[]{"Ag(+1)", "Al(+3)", "Be(+2)", "Ca(+2)", "Cd(+2)", "Cs(+1)", "K(+1)", "Li(+1)", "Mg(+2)", "Na(+1)", "Pb(+2)", "Rb(+1)", "Tl(+1)", "Zn(+2)", "H30(+1)", "NH4(+1)", "Cl(-1)", "Br(-1)", "F(-1)", "I(-1)", "NO3(-1)", "OH(-1)"};
        hydratedRadii = new double[]{341.0, 480.0, 459.0, 412.0, 426.0, 329.0, 331.0, 382.0, 428.0, 358.0, 401.0, 329.0, 330.0, 430.0, 280.0, 331.0, 332.0, 332.0, 330.0, 352.0, 340.0, 300.0};
        nIons = 91;
        nHydratedIons = 22;
    }

    public static double radius(String ion, String spin) {
        boolean spinSet = false;
        if ((spin = spin.trim()).equals("ls") || spin.equals("low") || spin.equals("low spin") || spin.equals("LS")) {
            spin = "ls";
        } else if (spin.equals("hs") || spin.equals("high") || spin.equals("high spin") || spin.equals("HS")) {
            spin = "hs";
        } else {
            throw new IllegalArgumentException("spin state must be entered as ls or hs not as " + spin);
        }
        spinSet = true;
        ion = ion.trim();
        String fullIon = String.valueOf(ion) + " " + spin;
        return IonicRadii.radiusCalc(fullIon, spinSet);
    }

    public static double radius(String ion) {
        boolean spinSet = false;
        return IonicRadii.radiusCalc(ion, spinSet);
    }

    private static double radiusCalc(String ion, boolean spinSet) {
        String fullIon = ion.trim();
        if (!spinSet) {
            ion = fullIon;
        }
        boolean test0 = true;
        boolean test1 = false;
        int ii = 0;
        double radius = 0.0;
        while (test0) {
            if (IonicRadii.compareBare(fullIon, ii)) {
                test0 = false;
                test1 = true;
                radius = radii[ii] * 1.0E-12;
                continue;
            }
            if (++ii < nIons) continue;
            test0 = false;
        }
        if (!test1 && !spinSet) {
            test0 = true;
            ii = 0;
            while (test0) {
                if (IonicRadii.compareSubstringBare(ion, ii) && spins[ii]) {
                    test0 = false;
                    test1 = true;
                    boolean test2 = true;
                    String enqTitle = String.valueOf(ion) + " may be low spin or high spin";
                    Object[] options = new Object[]{"low spin", "high spin"};
                    while (test2) {
                        int opt2 = JOptionPane.showOptionDialog(null, "Click appropriate box", enqTitle, 1, 3, null, options, options[0]);
                        if (opt2 == 0) {
                            radius = radii[ii] * 1.0E-12;
                            test2 = false;
                            continue;
                        }
                        if (opt2 == 1) {
                            radius = radii[ii + 1] * 1.0E-12;
                            test2 = false;
                            continue;
                        }
                        System.out.println("You must click either low spin or high spin");
                    }
                    continue;
                }
                if (++ii < nIons) continue;
                test0 = false;
            }
        }
        if (!test1 && spinSet) {
            test0 = true;
            ii = 0;
            while (test0) {
                if (IonicRadii.compareBare(ion, ii)) {
                    test0 = false;
                    test1 = true;
                    radius = radii[ii] * 1.0E-12;
                    System.out.println(String.valueOf(ion) + " does not have low and high spin states listed");
                    System.out.println("Single availabe listed radius was used");
                    continue;
                }
                if (++ii < nIons) continue;
                test0 = false;
            }
        }
        if (!test1) {
            System.out.println("Class: IonicRadii\nMethod: radius\n" + fullIon + " was not found in the lists of non-hydrated radii");
            System.out.println("0.0D returned");
        }
        spinSet = false;
        return radius;
    }

    public static boolean compareBare(String ion, int ii) {
        boolean test2 = false;
        if (ion.equals(ions1[ii]) || ion.equals(ions2[ii]) || ion.equals(ions3[ii]) || ion.equals(ions4[ii]) || ion.equals(ions5[ii]) || ion.equals(ions6[ii])) {
            test2 = true;
        }
        return test2;
    }

    public static boolean compareSubstringBare(String ion, int ii) {
        boolean test2 = false;
        if (ions1[ii].indexOf(ion) > -1 || ions2[ii].indexOf(ion) > -1 || ions3[ii].indexOf(ion) > -1 || ions4[ii].indexOf(ion) > -1 || ions5[ii].indexOf(ion) > -1 || ions6[ii].indexOf(ion) > -1) {
            test2 = true;
        }
        return test2;
    }

    public static double hydratedRadius(String ion) {
        ion = ion.trim();
        boolean test0 = true;
        boolean test1 = false;
        int i = 0;
        double radius = 0.0;
        while (test0) {
            if (IonicRadii.compareHydrated(ion, i)) {
                test0 = false;
                test1 = true;
                radius = hydratedRadii[i] * 1.0E-12;
                continue;
            }
            if (++i < nHydratedIons) continue;
            test0 = false;
        }
        if (!test1) {
            System.out.println("Class: IonicRadii\nMethod: hydratedRadius\n" + ion + " was not found in the lists of hydrated radii");
            System.out.println("0.0D returned");
        }
        return radius;
    }

    public static boolean compareHydrated(String ion, int ii) {
        boolean test2 = false;
        if (ion.equals(hydratedIons1[ii]) || ion.equals(hydratedIons2[ii]) || ion.equals(hydratedIons3[ii]) || ion.equals(hydratedIons4[ii]) || ion.equals(hydratedIons5[ii]) || ion.equals(hydratedIons6[ii])) {
            test2 = true;
        }
        return test2;
    }

    public static boolean compareSubstringHydrated(String ion, int ii) {
        boolean test2 = false;
        if (hydratedIons1[ii].indexOf(ion) > -1 || hydratedIons2[ii].indexOf(ion) > -1 || hydratedIons3[ii].indexOf(ion) > -1 || hydratedIons4[ii].indexOf(ion) > -1 || hydratedIons5[ii].indexOf(ion) > -1 || hydratedIons6[ii].indexOf(ion) > -1) {
            test2 = true;
        }
        return test2;
    }

    public static int charge(String ion) {
        ion = ion.trim();
        boolean test0 = true;
        boolean test1 = false;
        int i = 0;
        int charge = 0;
        while (test0) {
            if (IonicRadii.compareBare(ion, i)) {
                test0 = false;
                test1 = true;
                charge = ionCharge[i];
                continue;
            }
            if (++i < nIons) continue;
            test0 = false;
        }
        if (!test1) {
            System.out.println("Class: IonicRadii\nMethod: charge\n" + ion + " was not found in the lists of non-hydrated ions");
            System.out.println("0 returned");
        }
        return charge;
    }
}

