/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.MinimisationFunction;

class DonnanConcn
implements MinimisationFunction {
    public int numOfIons = 0;
    public double[] concnA = null;
    public double[] concnB = null;
    public double[] molesT = null;
    public double[] complex = null;
    public double[] excessConcnA = null;
    public double[] excessConcnB = null;
    public double[] excessComplex = null;
    public double[] assocConsts = null;
    public double[] partCoeffPot = null;
    public int[] indexK = null;
    public int nonZeroAssocK = 0;
    public double[] radii = null;
    public double[] charges = null;
    public double ionophoreConcn = 0.0;
    public double ionophoreRad = 0.0;
    public double volumeA = 0.0;
    public double volumeB = 0.0;
    public double interfacialArea = 0.0;
    public double epsilonA = 0.0;
    public double epsilonB = 0.0;
    public double epsilonSternA = 0.0;
    public double epsilonSternB = 0.0;
    public double temp = 298.15;
    public double diffPotentialA = 0.0;
    public double diffPotentialB = 0.0;
    public double sternPotential = 0.0;
    public double sternCap = 0.0;
    public double sternDeltaA = 0.0;
    public double sternDeltaB = 0.0;
    public double chargeValue = 0.0;
    public boolean chargeSame = true;
    public double interfacialChargeDensity = 0.0;
    public double interfacialCharge = 0.0;
    public boolean includeIc = true;
    public double potential = 0.0;
    private double penalty = 1.0E50;

    DonnanConcn() {
    }

    @Override
    public double function(double[] x2) {
        double sumOfSquares = 0.0;
        if (this.nonZeroAssocK > 0 && this.ionophoreConcn > 0.0) {
            if (this.nonZeroAssocK == 1) {
                this.complex[this.indexK[0]] = this.assocConsts[this.indexK[0]] * x2[this.indexK[0]] * this.ionophoreConcn / (1.0 + this.assocConsts[this.indexK[0]] * x2[this.indexK[0]]);
            } else {
                double[] vec = new double[this.nonZeroAssocK];
                double[][] mat = new double[this.nonZeroAssocK][this.nonZeroAssocK];
                int i = 0;
                while (i < this.nonZeroAssocK) {
                    vec[i] = this.assocConsts[this.indexK[i]] * x2[this.indexK[i]] * this.ionophoreConcn;
                    int j = 0;
                    while (j < this.nonZeroAssocK) {
                        mat[i][j] = this.assocConsts[this.indexK[i]] * x2[this.indexK[i]];
                        if (i == j) {
                            double[] dArray = mat[i];
                            int n = j;
                            dArray[n] = dArray[n] + 1.0;
                        }
                        ++j;
                    }
                    ++i;
                }
                Matrix matrix = new Matrix(mat);
                vec = matrix.solveLinearSet(vec);
                int i2 = 0;
                while (i2 < this.nonZeroAssocK) {
                    this.complex[this.indexK[i2]] = vec[i2];
                    ++i2;
                }
            }
        }
        if (this.includeIc) {
            double excess = Math.abs(this.interfaceCharge(x2, this.potential));
            this.excessConcentrations(x2, excess, this.potential);
            int i = 0;
            while (i < this.numOfIons) {
                double aa = x2[i] * (this.volumeB + this.partCoeffPot[i] * this.volumeA) + this.excessConcnA[i] * this.volumeA + (this.excessConcnB[i] + this.complex[i] + this.excessComplex[i]) * this.volumeB - this.molesT[i];
                sumOfSquares += aa * aa;
                if (x2[i] < 0.0) {
                    sumOfSquares += x2[i] * x2[i] * this.penalty;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.numOfIons) {
                double aa = x2[i] * (this.volumeB + this.partCoeffPot[i] * this.volumeA) + this.complex[i] * this.volumeB - this.molesT[i];
                sumOfSquares += aa * aa;
                if (x2[i] < 0.0) {
                    sumOfSquares += x2[i] * x2[i] * this.penalty;
                }
                ++i;
            }
        }
        return sumOfSquares;
    }

    public void excessConcentrations(double[] x2, double excess, double potential) {
        if (potential == 0.0) {
            int i = 0;
            while (i < this.numOfIons) {
                this.excessConcnA[i] = 0.0;
                this.excessConcnB[i] = 0.0;
                this.excessComplex[i] = 0.0;
                ++i;
            }
        } else {
            double sumA = 0.0;
            double sumB = 0.0;
            double sumC = 0.0;
            int i = 0;
            while (i < this.numOfIons) {
                if (potential > 0.0) {
                    if (this.charges[i] > 0.0) {
                        sumB += x2[i] * Math.abs(this.charges[i]);
                        sumC += this.complex[i] * Math.abs(this.charges[i]);
                    } else {
                        sumA += x2[i] * this.partCoeffPot[i] * Math.abs(this.charges[i]);
                    }
                } else if (this.charges[i] < 0.0) {
                    sumB += x2[i] * Math.abs(this.charges[i]);
                    sumC += this.complex[i] * Math.abs(this.charges[i]);
                } else {
                    sumA += x2[i] * this.partCoeffPot[i] * Math.abs(this.charges[i]);
                }
                ++i;
            }
            double factorA = excess / (sumA * this.volumeA);
            double factorB = excess / ((sumB + sumC) * this.volumeB);
            int i2 = 0;
            while (i2 < this.numOfIons) {
                if (potential > 0.0) {
                    if (this.charges[i2] > 0.0) {
                        this.excessConcnB[i2] = Math.abs(this.concnB[i2] * factorB);
                        this.excessComplex[i2] = Math.abs(this.complex[i2] * factorB);
                    } else {
                        this.excessConcnA[i2] = Math.abs(this.concnA[i2] * factorA);
                    }
                } else if (this.charges[i2] < 0.0) {
                    this.excessConcnB[i2] = Math.abs(this.concnB[i2] * factorB);
                    this.excessComplex[i2] = Math.abs(this.complex[i2] * factorB);
                } else {
                    this.excessConcnA[i2] = Math.abs(this.concnA[i2] * factorA);
                }
                ++i2;
            }
        }
    }

    public double interfaceCharge(double[] ions, double potential) {
        if (potential == 0.0) {
            this.interfacialCharge = 0.0;
            this.interfacialChargeDensity = 0.0;
            this.diffPotentialA = 0.0;
            this.diffPotentialB = 0.0;
            this.sternPotential = 0.0;
        } else {
            double maxQ;
            double sigmaM = 0.0;
            double funcM = 0.0;
            double sigmaL = 0.0;
            double funcL = 0.0;
            double sumAions = 0.0;
            double sumBions = 0.0;
            double aveCharge = 0.0;
            int i = 0;
            while (i < this.numOfIons) {
                sumBions += Math.abs(ions[i] * this.charges[i]);
                sumAions += Math.abs(ions[i] * this.charges[i] * this.partCoeffPot[i]);
                aveCharge += Math.abs(this.charges[i]);
                ++i;
            }
            sumAions /= 2.0 * aveCharge;
            double sigmaH = maxQ = 1.2 * Math.sqrt(4.81771359576E24 * (sumBions /= 2.0 * (aveCharge /= (double)this.numOfIons)) * 1.380650324E-23 * this.temp * 8.854187817E-12 * this.epsilonB) * Fmath.sinh(-aveCharge * -1.60217646263E-19 * Math.abs(potential) / (2.761300648E-23 * this.temp));
            double funcH = 0.0;
            double tolQ = Math.abs(potential) * 1.0E-8;
            int nIterQ = 10000;
            boolean testQ = true;
            int iExpandQ = 0;
            int iBisectQ = 0;
            double diffQ = 0.0;
            while (testQ) {
                funcL = this.icFunct(sigmaL, potential, ions);
                funcH = this.icFunct(sigmaH, potential, ions);
                if (funcH * funcL > 0.0) {
                    if (++iExpandQ > 10) {
                        throw new IllegalArgumentException("iExpandQ has reached its limit");
                    }
                    diffQ = sigmaH - sigmaL;
                    sigmaH += diffQ;
                    continue;
                }
                testQ = false;
            }
            if (Math.abs(funcL) <= tolQ) {
                sigmaM = sigmaL;
            } else if (Math.abs(funcH) <= tolQ) {
                sigmaM = sigmaH;
            } else {
                testQ = true;
                while (testQ) {
                    sigmaM = (sigmaL + sigmaH) / 2.0;
                    funcM = this.icFunct(sigmaM, potential, ions);
                    if (Math.abs(funcM) <= tolQ) {
                        testQ = false;
                    } else if (funcL * funcM > 0.0) {
                        funcL = funcM;
                        sigmaL = sigmaM;
                    } else {
                        funcH = funcM;
                        sigmaH = sigmaM;
                    }
                    if (++iBisectQ <= nIterQ) continue;
                    System.out.println("Class: DonnanConcn\nMethod: interfaceCharge");
                    System.out.println("Maximum iterations in bisection procedure exceeded\nCurrent value of interface charge returned");
                    testQ = false;
                }
            }
            this.interfacialCharge = sigmaM;
            this.interfacialChargeDensity = sigmaM / this.interfacialArea;
        }
        return this.interfacialCharge / 96485.34158524018;
    }

    public double icFunct(double sigma, double potential, double[] ions) {
        double sigmaAbs = Math.abs(sigma);
        double sgn = Fmath.sign(potential);
        if (this.chargeSame) {
            double NtotalA = 0.0;
            double NtotalB = 0.0;
            int i = 0;
            while (i < this.numOfIons) {
                NtotalA += this.concnA[i];
                NtotalB += this.concnB[i] + this.complex[i];
                ++i;
            }
            double preterm = 2.761300648E-23 * this.temp / (-this.chargeValue * -1.60217646263E-19);
            this.diffPotentialA = sgn * preterm * Fmath.asinh(sigmaAbs / Math.sqrt(4.81771359576E24 * (NtotalA /= 2.0) * 1.380650324E-23 * this.temp * 8.854187817E-12 * this.epsilonA));
            this.diffPotentialB = sgn * preterm * Fmath.asinh(sigmaAbs / Math.sqrt(4.81771359576E24 * (NtotalB /= 2.0) * 1.380650324E-23 * this.temp * 8.854187817E-12 * this.epsilonB));
        } else {
            double maxPhiB;
            double maxPhiA;
            double phiAm = 0.0;
            double funcM = 0.0;
            double phiAl = 0.0;
            double funcL = 0.0;
            double phiAh = maxPhiA = 1.1 * potential;
            double funcH = 0.0;
            double tolP = Math.abs(sigma) * 0.1;
            int nIterP = 1000;
            boolean testP = true;
            int iExpandP = 0;
            int iBisectP = 0;
            double diffP = 0.0;
            while (testP) {
                funcL = this.phiAfunct(sigma, phiAl, ions);
                funcH = this.phiAfunct(sigma, phiAh, ions);
                if (funcH * funcL > 0.0) {
                    if (++iExpandP > 10) {
                        throw new IllegalArgumentException("iExpandP (partition A) has reached its limit");
                    }
                    diffP = phiAh - phiAl;
                    phiAh += diffP;
                    continue;
                }
                testP = false;
            }
            testP = true;
            while (testP) {
                phiAm = (phiAl + phiAh) / 2.0;
                funcM = this.phiAfunct(sigma, phiAm, ions);
                if (Math.abs(funcM) <= tolP) {
                    this.diffPotentialA = sgn * phiAm;
                    testP = false;
                } else if (funcL * funcM > 0.0) {
                    funcL = funcM;
                    phiAl = phiAm;
                } else {
                    funcH = funcM;
                    phiAh = phiAm;
                }
                if (++iBisectP <= nIterP) continue;
                System.out.println("phiA = " + phiAm + " sigma = " + sigma + " funcM = " + funcM + " tol = " + tolP);
                this.diffPotentialA = sgn * phiAm;
                testP = false;
            }
            double phiBm = 0.0;
            double phiBl = 0.0;
            double phiBh = maxPhiB = -1.1 * potential;
            tolP = Math.abs(potential) * 1.0E-5;
            if (tolP == 0.0) {
                tolP = 1.0E-6;
            }
            nIterP = 100000;
            testP = true;
            iExpandP = 0;
            iBisectP = 0;
            diffP = 0.0;
            while (testP) {
                funcL = this.phiAfunct(sigma, phiBl, ions);
                funcH = this.phiAfunct(sigma, phiBh, ions);
                if (funcH * funcL > 0.0) {
                    if (++iExpandP > 10) {
                        throw new IllegalArgumentException("iExpandP (partition B) has reached its limit");
                    }
                    diffP = phiBh - phiBl;
                    phiBh += diffP;
                    continue;
                }
                testP = false;
            }
            if (Math.abs(funcH) <= tolP) {
                phiBm = phiBh;
            } else {
                testP = true;
                while (testP) {
                    phiBm = (phiBl + phiBh) / 2.0;
                    funcM = this.phiAfunct(sigma, phiBm, ions);
                    if (Math.abs(funcM) <= tolP) {
                        testP = false;
                    } else if (funcL * funcM > 0.0) {
                        funcL = funcM;
                        phiBl = phiBm;
                    } else {
                        funcH = funcM;
                        phiBh = phiBm;
                    }
                    if (++iBisectP <= nIterP) continue;
                    System.out.println("Class: DonnanConcn\nMethod: icFunct");
                    System.out.println("Maximum iterations in bisection B procedure exceeded\nCurrent value of interface charge returned");
                    System.out.println("phiB = " + phiBm + " maxPhiB = " + maxPhiB + " funcM = " + funcM + " tol = " + tolP);
                    testP = false;
                }
            }
            this.diffPotentialB = sgn * phiBm;
        }
        this.sternCapacitance(ions, sigma, this.diffPotentialA, -this.diffPotentialB);
        this.sternPotential = sgn * sigmaAbs / this.sternCap;
        return potential - (this.diffPotentialA + this.diffPotentialB + this.sternPotential);
    }

    public double phiAfunct(double sigma, double potential, double[] ions) {
        double sumAsigma = 0.0;
        double sgns = Fmath.sign(sigma);
        double preterm1 = 1.7708375634E-11 * this.epsilonA * 1.380650324E-23 * this.temp * 6.0221419947E23;
        double preterm2 = potential * -1.60217646263E-19 / (1.380650324E-23 * this.temp);
        int i = 0;
        while (i < this.numOfIons) {
            sumAsigma += preterm1 * ions[i] * this.partCoeffPot[i] * (Math.exp(this.charges[i] * preterm2) - 1.0);
            ++i;
        }
        if (sumAsigma < 0.0) {
            sgns = -sgns;
            sumAsigma = -sumAsigma;
        }
        double diffSigma = sigma - sgns * Math.sqrt(sumAsigma);
        return diffSigma;
    }

    public double phiBfunct(double sigma, double potential, double[] ions) {
        double sumBsigma = 0.0;
        double sgns = Fmath.sign(sigma);
        double preterm1 = 1.7708375634E-11 * this.epsilonB * 1.380650324E-23 * this.temp * 6.0221419947E23;
        double preterm2 = potential * -1.60217646263E-19 / (1.380650324E-23 * this.temp);
        int i = 0;
        while (i < this.numOfIons) {
            sumBsigma += preterm1 * (ions[i] + this.complex[i]) * (Math.exp(this.charges[i] * preterm2) - 1.0);
            ++i;
        }
        if (sumBsigma < 0.0) {
            sgns = -sgns;
            sumBsigma = -sumBsigma;
        }
        double diffSigma = sigma - sgns * Math.sqrt(sumBsigma);
        return diffSigma;
    }

    public void sternCapacitance(double[] ions, double sigma, double psiA, double psiB) {
        double denomA = 0.0;
        double denomB = 0.0;
        this.sternDeltaA = 0.0;
        this.sternDeltaB = 0.0;
        double preterm = 1.60217646263E-19 / (1.380650324E-23 * this.temp);
        int i = 0;
        while (i < this.numOfIons) {
            this.sternDeltaA += this.radii[i] * ions[i] * this.partCoeffPot[i] * Math.exp(preterm * psiA * this.charges[i]);
            this.sternDeltaB += (this.radii[i] * ions[i] + this.ionophoreRad * this.complex[i]) * Math.exp(-preterm * psiB * this.charges[i]);
            denomA += ions[i] * this.partCoeffPot[i] * Math.exp(preterm * psiA * this.charges[i]);
            denomB += (ions[i] + this.complex[i]) * Math.exp(-preterm * psiB * this.charges[i]);
            ++i;
        }
        this.sternDeltaA /= denomA;
        this.sternDeltaB /= denomB;
        this.sternCap = 8.854187817E-12 * this.epsilonSternA * this.epsilonSternB / (this.sternDeltaA * this.epsilonSternB + this.sternDeltaB * this.epsilonSternA);
    }
}

