/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.RegressionFunction;
import flanagan.complex.Complex;
import flanagan.optics.Reflectivity;

class RegressFunct
implements RegressionFunction {
    public int numberOfLayers = 0;
    public String mode = null;
    public double eVectorAngleDeg = 0.0;
    public double[] thicknesses = null;
    public double[] incidentAnglesDeg = null;
    public Complex[][] refractiveIndices = null;
    public Complex[][] relativeMagneticPermeabilities = null;
    public int regressionOption = 0;
    public int[] thicknessEstimateIndices = null;
    public int[] refractIndexRealEstimateIndices = null;
    public int[] refractIndexImagEstimateIndices = null;
    public int[] magneticPermRealEstimateIndices = null;
    public int[] magneticPermImagEstimateIndices = null;

    RegressFunct() {
    }

    @Override
    public double function(double[] p, double[] x2) {
        Reflectivity refl = new Reflectivity(this.numberOfLayers);
        if (this.mode.equals("mixed")) {
            refl.setMode(this.eVectorAngleDeg);
        } else {
            refl.setMode(this.mode);
        }
        int pIndex = 0;
        int n = this.thicknessEstimateIndices.length;
        int i = 0;
        while (i < n) {
            this.thicknesses[this.thicknessEstimateIndices[i]] = p[pIndex];
            ++pIndex;
            ++i;
        }
        refl.setThicknesses(this.thicknesses);
        n = this.refractIndexRealEstimateIndices.length;
        i = 0;
        while (i < n) {
            this.refractiveIndices[0][this.refractIndexRealEstimateIndices[i]].setReal(p[pIndex]);
            ++pIndex;
            ++i;
        }
        n = this.refractIndexImagEstimateIndices.length;
        i = 0;
        while (i < n) {
            this.refractiveIndices[0][this.refractIndexImagEstimateIndices[i]].setImag(p[pIndex]);
            ++pIndex;
            ++i;
        }
        refl.setRefractiveIndices(this.refractiveIndices);
        n = this.magneticPermRealEstimateIndices.length;
        i = 0;
        while (i < n) {
            this.relativeMagneticPermeabilities[0][this.magneticPermRealEstimateIndices[i]].setReal(p[pIndex]);
            ++pIndex;
            ++i;
        }
        n = this.magneticPermImagEstimateIndices.length;
        i = 0;
        while (i < n) {
            this.relativeMagneticPermeabilities[0][this.magneticPermImagEstimateIndices[i]].setImag(p[pIndex]);
            ++pIndex;
            ++i;
        }
        refl.setRelativeMagneticPermeabilities(this.relativeMagneticPermeabilities);
        refl.setIncidentAngle(x2[0]);
        double returnValue = 0.0;
        switch (this.regressionOption) {
            case 1: {
                returnValue = ((double[])refl.getReflectivities())[0];
                break;
            }
            case 2: {
                returnValue = ((double[])refl.getTransmissivities())[0];
                break;
            }
            case 3: {
                returnValue = p[pIndex] * ((double[])refl.getEvanescentFields())[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Regresion option " + this.regressionOption + " does not exist");
            }
        }
        return returnValue;
    }
}

