/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.complex.Complex;
import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.physprop.Saline;
import flanagan.physprop.Sucrose;
import flanagan.physprop.Water;

public class RefractiveIndex {
    private static double imagPlusMinus = -1.0;

    public static void setComlexImagAsPositive() {
        imagPlusMinus = 1.0;
    }

    public static void setComlexImagAsNegative() {
        imagPlusMinus = -1.0;
    }

    public static Complex absToComplex(double riReal, double extCoeff, double concn, double wavl) {
        Complex ri = new Complex();
        ri.reset(riReal, extCoeff * concn * wavl / (Math.PI * 4));
        return ri;
    }

    public static double imagToAbs(double riImag, double wavl) {
        return 4.0 * riImag * Math.PI / wavl;
    }

    public static Complex gold(double wavelength) {
        double[] wavl = new double[]{1.87855E-7, 1.91629E-7, 1.9525E-7, 1.99331E-7, 2.03253E-7, 2.07331E-7, 2.11939E-7, 2.16377E-7, 2.214E-7, 2.26248E-7, 2.31314E-7, 2.37063E-7, 2.4263E-7, 2.48964E-7, 2.55111E-7, 2.6157E-7, 2.68946E-7, 2.76134E-7, 2.84367E-7, 2.92415E-7, 3.00932E-7, 3.10737E-7, 3.20372E-7, 3.31508E-7, 3.42497E-7, 3.5424E-7, 3.67905E-7, 3.81489E-7, 3.97385E-7, 4.1328E-7, 4.305E-7, 4.50851E-7, 4.71422E-7, 4.95936E-7, 5.20941E-7, 5.48602E-7, 5.82085E-7, 6.16836E-7, 6.5949E-7, 7.04455E-7, 7.56E-7, 8.21086E-7, 8.91972E-7, 9.84E-7, 1.08758E-6, 1.21553E-6, 1.39308E-6, 1.61018E-6, 1.93725E-6};
        double[] rfInRe = new double[]{1.28, 1.32, 1.34, 1.33, 1.33, 1.3, 1.3, 1.3, 1.3, 1.31, 1.3, 1.32, 1.32, 1.33, 1.33, 1.35, 1.38, 1.43, 1.47, 1.49, 1.53, 1.53, 1.54, 1.48, 1.48, 1.5, 1.48, 1.46, 1.47, 1.46, 1.45, 1.38, 1.31, 1.04, 0.62, 0.43, 0.29, 0.21, 0.14, 0.13, 0.14, 0.16, 0.17, 0.22, 0.27, 0.35, 0.43, 0.56, 0.92};
        double[] rfInIm = new double[]{1.188, 1.203, 1.226, 1.251, 1.277, 1.304, 1.35, 1.387, 1.427, 1.46, 1.497, 1.536, 1.577, 1.631, 1.688, 1.749, 1.803, 1.847, 1.869, 1.878, 1.889, 1.893, 1.898, 1.883, 1.871, 1.866, 1.895, 1.933, 1.952, 1.958, 1.948, 1.914, 1.849, 1.833, 2.081, 2.455, 2.863, 3.272, 3.697, 4.103, 4.542, 5.083, 5.663, 6.35, 7.15, 8.145, 9.519, 11.21, 13.78};
        double[] derivRe = new double[]{0.0, -1.17631E15, -3.60547E15, 2.92961E15, -4.45568E15, 3.84052E15, -9.56586E14, -8.80015E13, 1.17669E15, -2.14766E15, 2.49889E15, -1.81842E15, 1.06253E15, -8.99034E14, 1.01496E15, -2.29767E14, 7.62849E14, -4.44179E14, -5.30697E14, 8.3214E14, -1.17757E15, 8.04127E14, -1.40022E15, 1.06549E15, 7.02889E13, -3.99E14, 3.29142E13, 2.65475E14, -2.19619E14, 1.38062E14, -3.11414E14, 1.90132E14, -4.37649E14, -4.12661E14, 6.75965E14, -4.75615E13, 9.68919E13, -1.02252E13, 5.115E13, -3.33214E11, 5.09764E12, -7.56272E12, 1.02639E13, -4.28914E12, 3.57066E12, -2.76676E12, 1.04546E12, 2.55831E12, 0.0};
        double[] derivIm = new double[]{0.0, 1.07557E15, -4.54022E14, 4.27299E14, -5.01416E14, 1.54402E15, -9.99891E14, 2.48281E14, -4.98264E14, 3.40549E14, -2.67834E14, 1.65108E14, 2.31595E14, 8.3984E13, 1.49838E14, -5.0561E14, 3.84443E13, -6.38396E14, -1.55687E14, 1.24515E14, -2.15188E14, 1.55368E14, -3.38857E14, 1.24305E14, -1.79372E13, 2.93519E14, 4.26729E13, -1.68238E14, -1.7188E13, -7.16957E13, -4.22518E13, -1.04677E14, 2.39351E13, 6.13432E14, 8.33595E13, -9.04645E13, 2.22081E13, -7.1846E13, -1.13135E13, -1.24725E13, -3.07173E12, 2.01135E12, -1.58933E13, 7.97278E12, -1.02502E12, -2.60397E11, 3.57043E11, 3.07012E11, 0.0};
        int n = wavl.length;
        Complex ri = new Complex();
        if (!(wavelength >= wavl[0]) || !(wavelength <= wavl[n - 1])) {
            throw new IllegalArgumentException("Wavelength is outside the limits (187.86nm - 1937.2nm) of the tabulated data");
        }
        double yRe = CubicSpline.interpolate(wavelength, wavl, rfInRe, derivRe);
        double yIm = CubicSpline.interpolate(wavelength, wavl, rfInIm, derivIm);
        ri.reset(yRe, imagPlusMinus * yIm);
        return ri;
    }

    public static Complex silver(double wavelength) {
        double[] wavl = new double[]{1.87855E-7, 1.91629E-7, 1.9525E-7, 1.99331E-7, 2.03253E-7, 2.07331E-7, 2.11939E-7, 2.16377E-7, 2.214E-7, 2.26248E-7, 2.31314E-7, 2.37063E-7, 2.4263E-7, 2.48964E-7, 2.55111E-7, 2.6157E-7, 2.68946E-7, 2.76134E-7, 2.84367E-7, 2.92415E-7, 3.00932E-7, 3.10737E-7, 3.20372E-7, 3.31508E-7, 3.42497E-7, 3.5424E-7, 3.67905E-7, 3.81489E-7, 3.97385E-7, 4.1328E-7, 4.305E-7, 4.50851E-7, 4.71422E-7, 4.95936E-7, 5.20941E-7, 5.48602E-7, 5.82085E-7, 6.16836E-7, 6.5949E-7, 7.04455E-7, 7.56E-7, 8.21086E-7, 8.91972E-7, 9.84E-7, 1.08758E-6, 1.21553E-6, 1.39308E-6, 1.61018E-6, 1.93725E-6};
        double[] rfInRe = new double[]{1.07, 1.1, 1.12, 1.14, 1.15, 1.18, 1.2, 1.22, 1.25, 1.26, 1.28, 1.28, 1.3, 1.31, 1.33, 1.35, 1.38, 1.41, 1.41, 1.39, 1.34, 1.13, 0.81, 0.17, 0.14, 0.1, 0.07, 0.05, 0.05, 0.05, 0.04, 0.04, 0.05, 0.05, 0.05, 0.06, 0.05, 0.06, 0.05, 0.04, 0.03, 0.04, 0.04, 0.04, 0.04, 0.09, 0.13, 0.15, 0.24};
        double[] rfInIm = new double[]{1.212, 1.232, 1.255, 1.277, 1.296, 1.312, 1.325, 1.336, 1.342, 1.344, 1.357, 1.367, 1.378, 1.389, 1.393, 1.387, 1.372, 1.331, 1.264, 1.161, 0.964, 0.616, 0.392, 0.829, 1.142, 1.419, 1.657, 1.864, 2.07, 2.275, 2.462, 2.657, 2.869, 3.093, 3.324, 3.586, 3.858, 4.152, 4.483, 4.838, 5.242, 5.727, 6.312, 6.992, 7.795, 8.828, 10.1, 11.85, 14.08};
        double[] derivRe = new double[]{0.0, -1.09443E15, 4.50671E14, -1.64535E15, 2.64916E15, -1.73921E15, 2.84877E14, 8.69272E14, -1.77518E15, 1.48932E15, -1.89758E15, 1.70681E15, -1.10717E15, 7.52799E14, -2.81357E14, 2.35816E14, 1.51436E14, -7.66855E14, -3.01095E14, 1.50003E14, -2.68399E15, 3.86776E14, -6.17426E15, 9.62736E15, -2.62139E15, 7.94178E14, -1.68944E14, 1.98255E14, -3.52453E13, -5.72818E13, 5.05039E13, 3.32047E13, -4.0284E13, 1.33103E12, 3.42212E13, -5.30981E13, 4.73552E13, -3.35549E13, 9.74718E12, -4.54863E12, 1.1835E13, -6.76495E12, 2.08137E12, -2.15834E12, 6.30268E12, -2.73772E12, -7.13134E11, 1.15139E12, 0.0};
        double[] derivIm = new double[]{0.0, 5.49257E14, -4.99584E14, -1.45243E13, -2.5674E14, -3.33755E14, 5.01553E13, -3.21087E14, -3.68608E14, 8.65942E14, -4.85862E14, 2.02151E14, -6.51859E13, -1.59369E14, -3.45625E14, 3.33754E13, -7.21153E14, -1.75627E14, -4.86315E14, -1.32704E15, -1.65707E15, -2.19007E14, 1.01945E16, -4.17064E15, 5.88854E14, -8.77761E14, 4.82107E13, -2.72544E14, 1.09375E14, -1.88393E14, -8.63708E13, 1.01638E14, -1.07779E14, 2.5244E13, 2.97971E13, -8.56009E13, 4.64112E13, -4.16531E13, 1.48883E13, -5.07977E11, -1.77458E13, 2.84057E13, -2.4881E13, 9.90519E12, 5.74546E12, -1.37589E13, 1.24799E13, -9.3404E12, 0.0};
        int n = wavl.length;
        Complex ri = new Complex();
        if (!(wavelength >= wavl[0]) || !(wavelength <= wavl[n - 1])) {
            throw new IllegalArgumentException("Wavelength is outside the limits (187.86nm - 1937.2nm) of the tabulated data");
        }
        double yRe = CubicSpline.interpolate(wavelength, wavl, rfInRe, derivRe);
        double yIm = CubicSpline.interpolate(wavelength, wavl, rfInIm, derivIm);
        ri.reset(yRe, imagPlusMinus * yIm);
        return ri;
    }

    public static double quartz(double wavelength) {
        double yRe;
        double[] wavl = new double[]{1.85E-7, 2.14E-7, 2.75E-7, 3.61E-7, 5.09E-7, 5.89E-7, 6.56E-7};
        double[] rfInRe = new double[]{1.57464, 1.53386, 1.49634, 1.47503, 1.4619, 1.4583, 1.4564};
        double[] derivRe = new double[]{0.0, 2.58206E13, 1.62375E12, 1.75944E12, -5.81947E10, 3.55464E11, 0.0};
        double a1 = 0.444046;
        double b1 = 9.677366E-15;
        int n = wavl.length;
        if (wavelength >= wavl[0] && wavelength <= wavl[n - 1]) {
            yRe = CubicSpline.interpolate(wavelength, wavl, rfInRe, derivRe);
        } else {
            System.out.println("Wavelength passed (" + wavelength * 1.0E7 + "nm) to RefractiveIndex.quartz() is outside");
            System.out.println("the experimental data limits (185.0 nm - 656.0 nm).   Extrapolation used");
            System.out.println("the Caunchy equation which may not be valid at the wavelength requested,");
            System.out.println(" especially if the wavelength is within an absorption band");
            yRe = 1.0 + a1 * (1.0 + b1 / Math.pow(wavelength, 2.0));
        }
        return yRe;
    }

    public static double crownGlass(double wavelength) {
        double yRe;
        double[] wavl = new double[]{3.6502E-7, 4.0466E-7, 4.3584E-7, 4.7999E-7, 4.8613E-7, 5.4607E-7, 5.8756E-7, 6.4385E-7, 6.5628E-7, 7.0652E-7, 8.5211E-7, 1.014E-6};
        double[] rfInRe = new double[]{1.83028, 1.8169, 1.80916, 1.8009, 1.79994, 1.79227, 1.78831, 1.7841, 1.7833, 1.78048, 1.7746, 1.77018};
        double[] derivRe = new double[]{0.0, 3.48108E12, 1.37108E12, 1.17265E12, 9.68655E11, 5.86009E11, 4.3771E11, 2.48861E11, 3.01116E11, 1.7006E11, 8.74046E10, 0.0};
        double a1 = 0.762002;
        double b1 = 1.18516E-14;
        int n = wavl.length;
        if (wavelength >= wavl[0] && wavelength <= wavl[n - 1]) {
            yRe = CubicSpline.interpolate(wavelength, wavl, rfInRe, derivRe);
        } else {
            System.out.println("Wavelength passed (" + wavelength * 1.0E7 + "nm) to RefractiveIndex.crownGlass() is outside");
            System.out.println("the experimental data limits (365.02 nm - 1014.0 nm).   Extrapolation used");
            System.out.println("the Caunchy equation which may not be valid at the wavelength requested,");
            System.out.println(" especially if the wavelength is within an absorption band");
            yRe = 1.0 + a1 * (1.0 + b1 / Math.pow(wavelength, 2.0));
        }
        return yRe;
    }

    public static double floatGlass(double wavelength) {
        double yRe;
        double[] wavl = new double[]{5.435E-7, 5.941E-7, 6.04E-7, 6.119E-7, 6.328E-7};
        double[] rfInRe = new double[]{1.51958, 1.51707, 1.51671, 1.5163, 1.51553};
        double[] derivRe = new double[]{0.0, 9.28695E11, -3.3258E12, 2.02454E12, 0.0};
        double a1 = 0.504167;
        double b1 = 9.03525E-15;
        int n = wavl.length;
        if (wavelength >= wavl[0] && wavelength <= wavl[n - 1]) {
            yRe = CubicSpline.interpolate(wavelength, wavl, rfInRe, derivRe);
        } else {
            System.out.println("Wavelength passed (" + wavelength * 1.0E7 + "nm) to RefractiveIndex.floatGlass() is outside");
            System.out.println("the experimental data limits (543.5 nm - 632.8 nm).   Extrapolation used");
            System.out.println("the Caunchy equation which may not be valid at the wavelength requested,");
            System.out.println(" especially if the wavelength is within an absorption band");
            yRe = 1.0 + a1 * (1.0 + b1 / Math.pow(wavelength, 2.0));
        }
        return yRe;
    }

    public static double microscopeSlideGlass(double wavelength) {
        double yRe;
        double[] wavl = new double[]{5.435E-7, 5.941E-7, 6.04E-7, 6.119E-7, 6.328E-7};
        double[] rfInRe = new double[]{1.51436, 1.51184, 1.51144, 1.51111, 1.51027};
        double[] derivRe = new double[]{0.0, 5.00315E11, -4.19006E11, 2.22131E11, 0.0};
        double a1 = 0.498854;
        double b1 = 9.18748E-15;
        int n = wavl.length;
        if (wavelength >= wavl[0] && wavelength <= wavl[n - 1]) {
            yRe = CubicSpline.interpolate(wavelength, wavl, rfInRe, derivRe);
        } else {
            System.out.println("Wavelength passed (" + wavelength * 1.0E7 + "nm) to RefractiveIndex.microSlideGlass() is outside");
            System.out.println("the experimental data limits (543.5 nm - 632.8 nm).   Extrapolation used");
            System.out.println("the Caunchy equation which may not be valid at the wavelength requested,");
            System.out.println(" especially if the wavelength is within an absorption band");
            yRe = 1.0 + a1 * (1.0 + b1 / Math.pow(wavelength, 2.0));
        }
        return yRe;
    }

    public static double polymethacrylate(double wavelength) {
        double yRe;
        double[] wavl = new double[]{4.358E-7, 5.461E-7, 5.893E-7};
        double[] rfInRe = new double[]{1.502, 1.494, 1.492};
        double[] derivRe = new double[]{0.0, 5.127E11, 0.0};
        double a1 = 0.498854;
        double b1 = 9.18748E-15;
        int n = wavl.length;
        if (wavelength >= wavl[0] && wavelength <= wavl[n - 1]) {
            yRe = CubicSpline.interpolate(wavelength, wavl, rfInRe, derivRe);
        } else {
            System.out.println("Wavelength passed (" + wavelength * 1.0E7 + "nm) to RefrIndex.polymethacrylate() is outside");
            System.out.println("the experimental data limits (435.8 nm - 589.3 nm).   Extrapolation used");
            System.out.println("the Caunchy equation which may not be valid at the wavelength requested,");
            System.out.println(" especially if the wavelength is within an absorption band");
            yRe = 1.0 + a1 * (1.0 + b1 / Math.pow(wavelength, 2.0));
        }
        return yRe;
    }

    public static double air(double wavelength) {
        double a1 = 2.879E-4;
        double b1 = 5.67E-11;
        if ((wavelength *= 100.0) < 2.498E-5 || wavelength > 7.594E-5) {
            System.out.println("Wavelength passed (" + wavelength * 1.0E7 + "nm) to RefractiveIndex.air() is outside");
            System.out.println("the experimental data limits (249.8 nm - 759.4 nm).   Extrapolation using");
            System.out.println("the Caunchy equation may not be valid at the wavelength requested,");
            System.out.println(" especially if the wavelength is within an absorption band");
        }
        double ri = 1.0 + a1 * (1.0 + b1 / Math.pow(wavelength, 2.0));
        return ri;
    }

    public static double water(double wavelength, double temperature) {
        double[] wavl = new double[]{4.046E-7, 5.8932E-7, 7.0652E-7};
        double[] temp = new double[]{0.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0};
        double[] rfInRe1 = new double[]{1.34359, 1.34351, 1.34287, 1.3418, 1.34039, 1.33867, 1.33669, 1.33447, 1.33204, 1.32942, 1.32663};
        double[] rfInRe2 = new double[]{1.33346, 1.33341, 1.33283, 1.33184, 1.33052, 1.32892, 1.32707, 1.325, 1.32274, 1.32029, 1.31766};
        double[] rfInRe3 = new double[]{1.33086, 1.33073, 1.33007, 1.32903, 1.32766, 1.32603, 1.32417, 1.32209, 1.31983, 1.31739, 1.31481};
        double[] derivRe1 = new double[]{0.0, -7.46454E-6, -3.74183E-6, -3.36815E-6, -3.18559E-6, -2.4895E-6, -2.4564E-6, -2.08489E-6, -1.80403E-6, -2.09899E-6, 0.0};
        double[] derivRe2 = new double[]{0.0, -7.06563E-6, -3.53749E-6, -3.3844E-6, -2.72489E-6, -2.51602E-6, -2.21102E-6, -1.83991E-6, -1.82936E-6, -2.24266E-6, 0.0};
        double[] derivRe3 = new double[]{0.0, -7.19933E-6, -3.00268E-6, -3.58995E-6, -2.43753E-6, -2.25994E-6, -2.32269E-6, -1.64928E-6, -1.88019E-6, -1.62995E-6, 0.0};
        int n = wavl.length;
        int m = temp.length;
        double[] yt = new double[n];
        if (wavelength < wavl[0] || wavelength > wavl[n - 1]) {
            throw new IllegalArgumentException("Wavelength " + wavelength + " is out of experimental data bounds: " + wavl[0] + " to " + wavl[n - 1]);
        }
        if (temperature < temp[0] || temperature > temp[m - 1]) {
            throw new IllegalArgumentException("Temperature " + temperature + " is out of experimental data bounds; " + temp[0] + " to " + temp[m - 1]);
        }
        yt[0] = CubicSpline.interpolate(temperature, temp, rfInRe1, derivRe1);
        yt[1] = CubicSpline.interpolate(temperature, temp, rfInRe2, derivRe2);
        yt[2] = CubicSpline.interpolate(temperature, temp, rfInRe3, derivRe3);
        CubicSpline cs = new CubicSpline(wavl, yt);
        cs.calcDeriv();
        double yRe = cs.interpolate(wavelength);
        return yRe;
    }

    public static double pva(double concn, double wavl, double temp) {
        double a1 = -0.998419;
        double b1 = -1.87778E-17;
        double rfwater = RefractiveIndex.water(wavl, temp);
        double rfincr = 1.0 + a1 * (1.0 + b1 / Math.pow(wavl, 2.0));
        double refind = rfwater + rfincr * concn / 10.0;
        return refind;
    }

    public static double saline(double concentration, double wavelength, double temperature) {
        double refrInd;
        double[] naclConcRi = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.1, 11.1, 12.1, 13.1, 14.1, 15.1, 16.2, 17.2, 18.2, 19.2, 20.2, 21.3, 22.3, 23.3, 24.4, 25.4, 26.4, 27.5, 28.5, 29.5, 30.6, 31.6, 32.7, 33.7, 34.8, 35.8, 36.9, 37.9, 39.0, 40.0, 41.1, 42.1, 43.2, 44.2, 45.3, 46.4, 47.4, 48.5, 49.6, 50.6, 51.7, 53.8, 56.0, 58.1, 60.3, 62.5, 64.6, 66.8, 69.0, 71.2, 73.4, 75.6, 77.8, 80.0, 82.2, 84.5, 86.7, 88.9, 91.2, 93.4, 95.7, 98.0, 100.2, 102.5, 104.8, 107.1, 112.8, 118.6, 124.4, 130.3, 136.2, 142.1, 148.1, 154.1, 160.2, 166.3, 178.6, 191.1, 203.7, 216.6, 229.6, 247.2, 256.1, 269.6, 283.3, 297.2, 311.3};
        double[] rfIn = new double[]{1.333, 1.3332, 1.3333, 1.3335, 1.3337, 1.3339, 1.334, 1.3342, 1.3344, 1.3346, 1.3347, 1.3349, 1.3351, 1.3353, 1.3354, 1.3356, 1.3358, 1.336, 1.3362, 1.3363, 1.3365, 1.3367, 1.3369, 1.337, 1.3372, 1.3374, 1.3376, 1.3377, 1.3379, 1.3381, 1.3383, 1.3384, 1.3386, 1.3388, 1.339, 1.3391, 1.3393, 1.3395, 1.3397, 1.3398, 1.34, 1.3402, 1.3404, 1.3405, 1.3407, 1.3409, 1.3411, 1.3412, 1.3414, 1.3416, 1.3418, 1.3421, 1.3425, 1.3428, 1.3432, 1.3435, 1.3439, 1.3442, 1.3446, 1.3449, 1.3453, 1.3456, 1.346, 1.3463, 1.3467, 1.347, 1.3474, 1.3477, 1.3481, 1.3484, 1.3488, 1.3491, 1.3495, 1.3498, 1.3502, 1.3505, 1.3514, 1.3523, 1.3532, 1.3541, 1.3549, 1.3558, 1.3567, 1.3576, 1.3585, 1.3594, 1.3612, 1.363, 1.3648, 1.3666, 1.3684, 1.3702, 1.3721, 1.3739, 1.3757, 1.3776, 1.3795};
        double[] deriv = new double[]{0.0, -2.04904E-4, 2.19616E-4, -7.35613E-5, 7.4629E-5, -2.24955E-4, 2.2519E-4, -7.58054E-5, 7.80315E-5, -2.36321E-4, 2.36336E-4, -7.81129E-5, 7.61157E-5, -2.2635E-4, 2.29284E-4, -9.07847E-5, 3.90193E-5, 4.50731E-5, -2.19312E-4, 2.32174E-4, -1.09384E-4, 1.07407E-4, -2.21696E-4, 1.79377E-4, -3.70715E-5, 6.74765E-5, -2.32834E-4, 2.32621E-4, -6.63432E-5, 3.27522E-5, -1.63915E-4, 1.61508E-4, -2.13737E-5, 2.12013E-5, -1.60693E-4, 1.60681E-4, -2.11441E-5, 2.11468E-5, -1.60694E-4, 1.60744E-4, -2.1382E-5, 2.20772E-5, -1.6403E-4, 1.73733E-4, -6.79449E-5, 9.80467E-5, -2.27966E-4, 1.8624E-4, -2.11277E-5, -7.03714E-6, -5.30975E-5, 5.41898E-5, -5.48913E-5, 5.67056E-5, -6.30137E-5, 7.13824E-5, -7.17063E-5, 6.45891E-5, -6.26832E-5, 6.21769E-5, -6.20574E-5, 6.20859E-5, -6.23194E-5, 6.32246E-5, -6.66119E-5, 6.61361E-5, -6.07803E-5, 5.30183E-5, -5.13701E-5, 5.23148E-5, -5.76185E-5, 6.47375E-5, -6.44613E-5, 5.62732E-5, -4.721E-5, 1.91454E-5, -5.78664E-6, 1.31552E-6, 5.24579E-7, -6.04837E-6, 6.43247E-6, -2.44509E-6, 8.31233E-7, -8.79838E-7, 2.54193E-7, -1.36934E-7, -3.01506E-7, 2.07215E-7, -1.07068E-6, 2.48527E-6, -9.3358E-6, 1.82903E-5, -1.54847E-5, 3.70622E-6, -3.10434E-7, -1.30682E-7, 0.0};
        double[] wavlRockSalt = new double[]{1.85E-7, 5.89E-7, 8.84E-7, 1.179E-6, 2.357E-6, 3.536E-6, 5.893E-6, 8.84E-6};
        double[] rfInRockSalt = new double[]{1.893, 1.544, 1.534, 1.53, 1.526, 1.523, 1.516, 1.502};
        double[] derivRockSalt = new double[]{0.0, 3.74404E12, -8.62356E11, 1.19054E11, -3.00122E10, 5.3764E9, -2.20178E9, 0.0};
        int nRi = 97;
        int nRockSalt = 8;
        double concen = concentration * 58.45;
        double refInWater = Water.refractIndex(wavelength, temperature);
        if (concentration == 0.0) {
            refrInd = refInWater;
        } else {
            double reInRockSalt;
            if (wavelength < 4.046E-7 || wavelength > 7.0652E-7) {
                throw new IllegalArgumentException("Wavelength outside the experimental data limits (404.6nm - 706.52nm)");
            }
            if (temperature < 0.0 || temperature > 100.0) {
                throw new IllegalArgumentException("Temperature " + temperature + " is outside the experimental data limits (0 C - 100 C)");
            }
            if (concen < naclConcRi[0] || concen > naclConcRi[nRi - 1]) {
                throw new IllegalArgumentException("Concentration" + concen + " is outside the experimental data limits");
            }
            double refrIndNacl20 = CubicSpline.interpolate(concen, naclConcRi, rfIn, deriv);
            double densityNacl = Saline.density(concentration);
            double densityWater20 = Water.density(20.0);
            double densityWater = Water.density(temperature);
            double riWater20_589 = Water.refractIndex(5.893E-7, 20.0);
            double molesWater = (densityNacl * 1000.0 - concen) / 18.02;
            double molesNacl = concentration;
            double moleFractWater = molesWater / (molesWater + molesNacl);
            double moleFractNacl = molesNacl / (molesWater + molesNacl);
            double prelor1 = 18.02 * moleFractWater + 58.45 * moleFractNacl;
            double n2 = refrIndNacl20 * refrIndNacl20;
            double refrIncr = (n2 - 1.0) / (n2 + 2.0) * prelor1 / densityNacl;
            n2 = riWater20_589 * riWater20_589;
            refrIncr -= (n2 - 1.0) / (n2 + 2.0) * (18.02 * moleFractWater) / densityWater20;
            double reInRockSalt5893 = 1.516;
            if (wavelength >= wavlRockSalt[0] && wavelength <= wavlRockSalt[nRockSalt - 1]) {
                reInRockSalt = CubicSpline.interpolate(wavelength, wavlRockSalt, rfInRockSalt, derivRockSalt);
            } else {
                double a1 = 0.515533;
                double b1 = 2.50204E-14;
                reInRockSalt = 1.0 + a1 * (1.0 + b1 / Math.pow(wavelength, 2.0));
            }
            reInRockSalt *= reInRockSalt;
            reInRockSalt5893 *= reInRockSalt5893;
            refrIncr = refrIncr * ((reInRockSalt - 1.0) / (reInRockSalt + 2.0)) / ((reInRockSalt5893 - 1.0) / (reInRockSalt5893 + 2.0));
            n2 = refInWater * refInWater;
            double lor1 = (n2 - 1.0) / (n2 + 2.0) * (18.02 * moleFractWater) / densityWater;
            lor1 += refrIncr;
            double lorDens = (18.02 * moleFractWater * densityWater20 / densityWater + 58.45 * moleFractNacl) * densityNacl / prelor1;
            lor1 = lor1 / prelor1 * lorDens;
            lor1 = (2.0 * lor1 + 1.0) / (1.0 - lor1);
            refrInd = Math.sqrt(lor1);
        }
        return refrInd;
    }

    public static double sucrose(double concentration, double temperature) {
        double refind;
        double[] concnG = new double[]{0.0, 5.0, 10.0, 15.1, 20.1, 25.2, 30.3, 35.4, 40.6, 45.7, 50.9, 56.1, 61.3, 66.5, 71.8, 77.1, 82.4, 87.7, 93.1, 98.4, 103.8, 114.7, 125.6, 136.6, 147.7, 158.9, 170.2, 181.5, 193.0, 204.5, 216.2, 239.8, 263.8, 288.1, 312.9, 338.1, 363.7, 389.8, 416.2, 443.2, 470.6, 498.4, 526.8, 555.6, 584.9, 614.8, 645.1, 676.0, 707.4, 739.3, 771.9, 804.9, 838.6, 872.8, 907.6, 943.1, 979.1, 1015.7, 1053.0, 1090.9, 1129.4, 1168.5, 1208.2};
        double[] refInd = new double[]{1.333, 1.3337, 1.3344, 1.3351, 1.3359, 1.3366, 1.3373, 1.3381, 1.3388, 1.3395, 1.3403, 1.341, 1.3418, 1.3425, 1.3433, 1.344, 1.3448, 1.3455, 1.3463, 1.3471, 1.3478, 1.3494, 1.3509, 1.3525, 1.3541, 1.3557, 1.3573, 1.3589, 1.3606, 1.3622, 1.3639, 1.3672, 1.3706, 1.3741, 1.3776, 1.3812, 1.3848, 1.3885, 1.3922, 1.396, 1.3999, 1.4038, 1.4078, 1.4118, 1.4159, 1.4201, 1.4243, 1.4286, 1.433, 1.4374, 1.4419, 1.4465, 1.4511, 1.4558, 1.4606, 1.4654, 1.4703, 1.4753, 1.4803, 1.4854, 1.4906, 1.4958, 1.501};
        double[] deriv = new double[]{0.0, 8.87219E-7, -3.54887E-6, 9.95698E-6, -9.31221E-6, 3.62993E-7, 7.86024E-6, -8.73591E-6, 1.22853E-6, 7.05021E-6, -9.99082E-6, 1.07237E-5, -1.07147E-5, 9.94585E-6, -1.0411E-5, 1.03381E-5, -9.58168E-6, 6.62868E-6, 9.93569E-7, -7.60108E-6, 5.46568E-6, -3.1357E-6, 2.02704E-6, -6.87809E-7, 2.17409E-8, -9.4373E-8, -3.16995E-7, 1.36235E-6, -1.83846E-6, 1.45463E-6, -7.98314E-7, 2.76693E-7, 1.46498E-7, -2.71393E-7, 2.2853E-7, -2.28325E-7, 1.58047E-7, -1.40698E-7, 3.72197E-8, 1.21286E-7, -1.69002E-7, 1.09589E-7, -1.50555E-7, 8.24317E-8, 3.46254E-8, -1.10233E-7, 3.66531E-8, 6.86736E-8, -1.23453E-7, 9.23933E-9, 1.0371E-7, -1.74702E-7, 7.44894E-8, 3.92428E-8, -1.41903E-7, 6.38698E-8, 3.62013E-8, -1.24325E-7, 4.47083E-8, 2.66887E-8, -7.19672E-8, -5.86665E-8, 0.0};
        double refractsuc = 0.331335;
        double[] weight = new double[]{5.0, 10.0, 15.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 75.0};
        double[][] cf = new double[][]{{-0.25, -0.27, -0.31, -0.31, -0.34, -0.35, -0.36, -0.37, -0.36, -0.36}, {-0.21, -0.23, -0.26, -0.27, -0.29, -0.31, -0.31, -0.32, -0.31, -0.29}, {-0.16, -0.18, -0.2, -0.2, -0.22, -0.23, -0.23, -0.23, -0.2, -0.17}, {-0.11, -0.12, -0.14, -0.14, -0.15, -0.16, -0.16, -0.15, -0.12, -0.09}, {-0.06, -0.07, -0.08, -0.08, -0.08, -0.09, -0.09, -0.08, -0.07, -0.05}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07}, {0.12, 0.14, 0.14, 0.14, 0.14, 0.14, 0.15, 0.14, 0.14, 0.14}, {0.18, 0.2, 0.2, 0.21, 0.21, 0.21, 0.23, 0.21, 0.22, 0.22}, {0.24, 0.26, 0.26, 0.27, 0.28, 0.28, 0.3, 0.28, 0.29, 0.29}, {0.3, 0.32, 0.32, 0.34, 0.36, 0.36, 0.38, 0.36, 0.36, 0.37}, {0.36, 0.39, 0.39, 0.41, 0.43, 0.43, 0.46, 0.44, 0.43, 0.44}, {0.43, 0.46, 0.46, 0.48, 0.5, 0.51, 0.55, 0.52, 0.5, 0.51}, {0.5, 0.53, 0.53, 0.55, 0.58, 0.59, 0.63, 0.6, 0.57, 0.59}, {0.57, 0.6, 0.61, 0.62, 0.66, 0.67, 0.71, 0.68, 0.65, 0.67}, {0.64, 0.67, 0.7, 0.71, 0.74, 0.75, 0.8, 0.76, 0.73, 0.75}};
        double[][] corrfac = new double[16][10];
        double[] tempw = new double[]{15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0};
        double[] corrfac5 = new double[]{-0.25, -0.21, -0.16, -0.11, -0.06, 0.0, 0.06, 0.12, 0.18, 0.24, 0.3, 0.36, 0.43, 0.5, 0.57, 0.64};
        double[] derivcor = new double[]{0.0, 0.0157677, -0.00307078, -0.00348457, 0.017009, -0.00455161, 0.00119739, -2.3797E-4, -2.45514E-4, 0.00122003, -0.0046346, 0.0173184, -0.00463885, 0.00123703, -3.09256E-4, 0.0};
        double wavelength = 5.893E-7;
        int n = 63;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 10) {
                corrfac[i][j] = cf[i][j];
                ++j;
            }
            ++i;
        }
        if (concentration >= concnG[0] && concentration <= concnG[n - 1]) {
            refind = CubicSpline.interpolate(concentration, concnG, refInd, deriv);
        } else {
            double refractwat = (refInd[0] * refInd[0] - 1.0) / (refInd[0] * refInd[0] + 2.0);
            double sucvol = concentration * Sucrose.specificVolume(concentration) * 1000.0;
            double refracttot = (refractsuc * sucvol + refractwat * (1000.0 - sucvol)) / 1000.0;
            refind = (1.0 + 2.0 * refracttot) / (1.0 - refracttot);
        }
        if (temperature != 20.0) {
            double concw = Sucrose.gperlToWeightpercent(concentration, temperature);
            if (concw < 5.0) {
                double refind2 = Water.refractIndex(wavelength, temperature);
                if (concentration == 0.0) {
                    refind = refind2;
                } else {
                    double corrfactor = CubicSpline.interpolate(temperature, tempw, corrfac5, derivcor);
                    double concg = Sucrose.weightpercentToGperl(concw += corrfactor, temperature);
                    double refind3 = CubicSpline.interpolate(concg, concnG, refInd, deriv);
                    refind = refind2 + (refind3 - refind2) * concw / 5.0;
                }
            } else {
                BiCubicSpline bcs = new BiCubicSpline(tempw, weight, corrfac);
                double corrfactor = bcs.interpolate(temperature, concw);
                double concg = Sucrose.weightpercentToGperl(concw += corrfactor, temperature);
                refind = CubicSpline.interpolate(concg, concnG, refInd, deriv);
            }
        }
        return refind;
    }

    public static double lorenzLorentz(double na, double nb, double molwta, double molwtb, double molfracta, double densa, double densb, double densab) {
        double molmassa = molfracta * molwta;
        double molmassb = (1.0 - molfracta) * molwtb;
        double lla = na * na;
        lla = (lla - 1.0) / (lla + 2.0) * molmassa / densa;
        double llb = nb * nb;
        llb = (llb - 1.0) / (llb + 2.0) * molmassb / densb;
        double llab = lla + llb;
        double nab = llab * densab / (molmassa + molmassb);
        nab = (2.0 * nab + 1.0) / (1.0 - nab);
        return Math.sqrt(nab);
    }

    public static double lorenzLorentz(double[] ni, double[] molwt, double[] molfract, double[] dens, double densmix) {
        double sum0 = 0.0;
        double sum1 = 0.0;
        int n = ni.length;
        if (n != molwt.length || n != molfract.length || n != dens.length) {
            throw new IllegalArgumentException("Array lengths differ");
        }
        int i = 0;
        while (i < n) {
            sum0 += molfract[i];
            ++i;
        }
        if (Math.abs(1.0 - sum0) > 1.0E-5) {
            throw new IllegalArgumentException("Mole fractions do not sum to unity");
        }
        sum0 = 0.0;
        i = 0;
        while (i < n) {
            double molmass = molfract[i] * molwt[i];
            double ll = ni[i] * ni[i];
            ll = (ll - 1.0) / (ll + 2.0) * molmass / dens[i];
            sum0 += ll;
            sum1 += molmass;
            ++i;
        }
        double nimix = sum0 * densmix / sum1;
        nimix = (2.0 * nimix + 1.0) / (1.0 - nimix);
        return Math.sqrt(nimix);
    }
}

