/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.Regression;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.optics.RegressFunct;
import flanagan.plot.PlotGraph;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class Reflectivity {
    private int numberOfLayers = 0;
    private int numberOfInterfaces = 0;
    private Complex[][] refractiveIndices = null;
    private Complex[] meanRefractiveIndices = null;
    private boolean refractSet = false;
    private boolean[] refractLayerSet = null;
    private boolean meanRefractUsed = false;
    private Complex[][] relativeMagneticPermeabilities = null;
    private Complex[] meanRelativeMagneticPermeabilities = null;
    private boolean magneticSet = false;
    private boolean meanMagneticUsed = false;
    private double[][] absorptionCoefficients = null;
    private boolean absorbSet = false;
    private double[] thicknesses = null;
    private double[] distances = null;
    private boolean thickSet = false;
    private boolean[] thickLayerSet = null;
    private int numberOfWavelengths = 0;
    private double[] wavelengths = null;
    private double[] frequencies = null;
    private double[] omega = null;
    private int[] origWavelIndices = null;
    private boolean wavelSet = false;
    private boolean freqSet = false;
    private boolean wavelNumberSet = false;
    private double[] incidentAngleDeg = null;
    private double[] incidentAngleRad = null;
    private int[] incidentAngleIndices = null;
    private int numberOfIncidentAngles = 0;
    private boolean incidentAngleSet = false;
    private String mode = null;
    private double eVectorAngleDeg = 0.0;
    private double eVectorAngleRad = 0.0;
    private double teFraction = 0.0;
    private double tmFraction = 0.0;
    private boolean modeSet = false;
    private Complex[][][] koVector = null;
    private Complex[][][] kVector = null;
    private Complex[][][] kxVector = null;
    private Complex[][][] kzVector = null;
    private double[][] reflectivities = null;
    private double[][] transmissivities = null;
    private double[][] powerLosses = null;
    private Complex[][] reflectCoeffTE = null;
    private Complex[][] reflectCoeffTM = null;
    private Complex[][] transmitCoeffTE = null;
    private Complex[][] transmitCoeffTM = null;
    private double[][] reflectPhaseShiftRadTE = null;
    private double[][] reflectPhaseShiftRadTM = null;
    private double[][] transmitPhaseShiftRadTE = null;
    private double[][] transmitPhaseShiftRadTM = null;
    private double[][] reflectPhaseShiftDegTE = null;
    private double[][] reflectPhaseShiftDegTM = null;
    private double[][] transmitPhaseShiftDegTE = null;
    private double[][] transmitPhaseShiftDegTM = null;
    private double[][] evanescentFields = null;
    private double fieldDistance = Double.POSITIVE_INFINITY;
    private boolean fieldIntensityCalc = false;
    private double[][] penetrationDepths = null;
    private double[][] transmitAnglesRad = null;
    private double[][] transmitAnglesDeg = null;
    private boolean singleReflectCalculated = false;
    private boolean angularReflectCalculated = false;
    private boolean wavelengthReflectCalculated = false;
    private boolean wavelengthAndAngularReflectCalculated = false;
    private double mu0overEps0 = 141925.72909094833;
    private double impedance = Math.sqrt(this.mu0overEps0);
    private int wavelengthAxisOption = 1;
    private double[] experimentalData = null;
    private double[] experimentalWeights = null;
    private double[] calculatedData = null;
    private int numberOfDataPoints = 0;
    private boolean experimentalDataSet = false;
    private boolean weightingOption = false;
    private int numberOfEstimatedParameters = 0;
    private int[] thicknessEstimateIndices = null;
    private int[] refractIndexRealEstimateIndices = null;
    private int[] refractIndexImagEstimateIndices = null;
    private int[] absorptionCoeffEstimateIndices = null;
    private int[] magneticPermRealEstimateIndices = null;
    private int[] magneticPermImagEstimateIndices = null;
    private boolean refractIndexImagEstimateSet = false;
    private boolean absorptionCoeffEstimateSet = false;
    private int thicknessEstimateNumber = 0;
    private int refractIndexRealEstimateNumber = 0;
    private int refractIndexImagEstimateNumber = 0;
    private int absorptionCoeffEstimateNumber = 0;
    private int magneticPermRealEstimateNumber = 0;
    private int magneticPermImagEstimateNumber = 0;
    private double fieldScalingFactor = 0.0;
    public int regressionOption = 0;
    public int degreesOfFreedom = 0;

    public Reflectivity(int n) {
        this.numberOfLayers = n;
        this.numberOfInterfaces = n - 1;
        if (n < 2) {
            throw new IllegalArgumentException("There must be at least two layers, i.e. at least one interface");
        }
        this.meanRelativeMagneticPermeabilities = Complex.oneDarray(this.numberOfLayers, 1.0, 0.0);
        this.meanRefractiveIndices = Complex.oneDarray(this.numberOfLayers);
        this.refractLayerSet = new boolean[this.numberOfLayers];
        int i = 0;
        while (i < this.numberOfLayers) {
            this.refractLayerSet[i] = false;
            ++i;
        }
        this.thicknesses = new double[this.numberOfLayers];
        this.thicknesses[0] = Double.NEGATIVE_INFINITY;
        this.thicknesses[this.numberOfLayers - 1] = Double.POSITIVE_INFINITY;
        this.thickLayerSet = new boolean[this.numberOfLayers];
        this.thickLayerSet[0] = true;
        i = 1;
        while (i < this.numberOfLayers - 2) {
            this.thickLayerSet[i] = false;
            ++i;
        }
        this.thickLayerSet[this.numberOfLayers - 1] = true;
        this.distances = new double[this.numberOfInterfaces];
    }

    public void setMode(String mode) {
        if (mode.equalsIgnoreCase("TE") || mode.equalsIgnoreCase("transverse electric")) {
            this.mode = "TE";
            this.teFraction = 1.0;
            this.tmFraction = 0.0;
            this.eVectorAngleDeg = 0.0;
            this.eVectorAngleRad = 0.0;
        } else if (mode.equalsIgnoreCase("TM") || mode.equalsIgnoreCase("transverse magnetic")) {
            this.mode = "TM";
            this.teFraction = 0.0;
            this.tmFraction = 1.0;
            this.eVectorAngleDeg = 90.0;
            this.eVectorAngleRad = 1.5707963267948966;
        } else if (mode.equalsIgnoreCase("unpolarised") || mode.equalsIgnoreCase("unpolarized") || mode.equalsIgnoreCase("none")) {
            this.mode = "unpolarised";
            this.teFraction = 0.5;
            this.tmFraction = 0.5;
            this.eVectorAngleDeg = 45.0;
            this.eVectorAngleRad = 0.7853981633974483;
        } else {
            throw new IllegalArgumentException("mode must be TE, TM or unpolarised; it cannot be " + mode);
        }
        this.modeSet = true;
    }

    public void setMode(double modeAngle) {
        this.mode = "mixed";
        this.eVectorAngleDeg = modeAngle;
        this.eVectorAngleRad = Math.toRadians(modeAngle);
        this.teFraction = Math.sin(this.eVectorAngleRad);
        this.teFraction *= this.teFraction;
        this.tmFraction = 1.0 - this.teFraction;
        this.modeSet = true;
    }

    public double fractionInTEmode() {
        return this.teFraction;
    }

    public double fractionInTMmode() {
        return this.tmFraction;
    }

    public void setIncidentAngle(double incidentAngle) {
        double[] incident = new double[]{incidentAngle};
        this.setIncidentAngle(incident);
    }

    public void setIncidentAngle(double[] incidentAngle) {
        this.numberOfIncidentAngles = incidentAngle.length;
        this.incidentAngleIndices = new int[this.numberOfIncidentAngles];
        this.incidentAngleDeg = new double[this.numberOfIncidentAngles];
        Fmath.selectionSort(incidentAngle, this.incidentAngleDeg, this.incidentAngleIndices);
        if (this.experimentalDataSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental reflectivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] temp = Conv.copy(this.experimentalData);
            int i = 0;
            while (i < this.numberOfIncidentAngles) {
                this.experimentalData[i] = temp[this.incidentAngleIndices[i]];
                ++i;
            }
        }
        this.incidentAngleRad = new double[this.numberOfIncidentAngles];
        int i = 0;
        while (i < this.numberOfIncidentAngles) {
            this.incidentAngleRad[i] = Math.toRadians(this.incidentAngleDeg[i]);
            ++i;
        }
        this.incidentAngleSet = true;
    }

    public void setIncidentAngle(double angleLow, double angleHigh, int nAngles) {
        this.numberOfIncidentAngles = nAngles;
        double increment = (angleHigh - angleLow) / (double)(nAngles - 1);
        double[] incidentAngles = new double[nAngles];
        incidentAngles[0] = angleLow;
        int i = 1;
        while (i < nAngles - 1) {
            incidentAngles[i] = incidentAngles[i - 1] + increment;
            ++i;
        }
        incidentAngles[nAngles - 1] = angleHigh;
        this.setIncidentAngle(incidentAngles);
    }

    public double[] getIncidentAngles() {
        return this.incidentAngleDeg;
    }

    public void setThicknesses(double[] thick) {
        int n = thick.length;
        if (n != this.numberOfLayers - 2) {
            throw new IllegalArgumentException("Number of thicknesses, " + n + ", does not match the number of layers minus the outer two semi-finite layers, " + (this.numberOfLayers - 2));
        }
        int i = 1;
        while (i < this.numberOfLayers - 1) {
            this.thicknesses[i] = thick[i - 1];
            ++i;
        }
        this.distances[0] = 0.0;
        i = 1;
        while (i < this.numberOfInterfaces) {
            this.distances[i] = this.distances[i - 1] + this.thicknesses[i];
            ++i;
        }
        i = 1;
        while (i < this.numberOfLayers - 2) {
            this.thickLayerSet[i] = true;
            ++i;
        }
        this.thickSet = true;
    }

    public void setThicknesses(double thickness, int layerNumber) {
        if (layerNumber < 1 || layerNumber > this.numberOfLayers) {
            throw new IllegalArgumentException("Layer number, " + layerNumber + ", must be in the range 1 to " + this.numberOfLayers);
        }
        this.thicknesses[layerNumber - 1] = thickness;
        this.distances[0] = 0.0;
        int i = 1;
        while (i < this.numberOfInterfaces) {
            this.distances[i] = this.distances[i - 1] + this.thicknesses[i];
            ++i;
        }
        this.thickLayerSet[layerNumber - 1] = true;
        int check2 = 0;
        int i2 = 0;
        while (i2 < this.numberOfLayers - i2) {
            if (this.thickLayerSet[i2]) {
                ++check2;
            }
            ++i2;
        }
        if (check2 == this.numberOfLayers) {
            this.thickSet = true;
        }
    }

    public double[] getThicknesses() {
        return this.thicknesses;
    }

    public void setWavelength(double[] wavelengths) {
        int i;
        int n = wavelengths.length;
        if (this.wavelNumberSet && n != this.numberOfWavelengths) {
            throw new IllegalArgumentException("The number of wavelengths entered, " + n + ", does not equal that previously set," + this.numberOfWavelengths);
        }
        this.numberOfWavelengths = n;
        this.wavelengths = wavelengths;
        this.wavelSet = true;
        if (!this.refractSet) {
            this.refractiveIndices = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
        }
        if (!this.wavelNumberSet) {
            int j;
            if (this.meanRefractUsed) {
                i = 0;
                while (i < this.numberOfLayers) {
                    j = 0;
                    while (j < this.numberOfWavelengths) {
                        this.refractiveIndices[j][i] = this.meanRefractiveIndices[i];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.numberOfLayers) {
                    this.refractLayerSet[i] = true;
                    ++i;
                }
                this.refractSet = true;
            }
            if (this.absorptionCoefficients != null) {
                i = 0;
                while (i < this.numberOfLayers) {
                    j = 0;
                    while (j < this.numberOfWavelengths) {
                        if (this.refractiveIndices[i][j].getImag() == 0.0) {
                            this.refractiveIndices[j][i].setImag(this.absorptionCoefficients[j][i] * this.wavelengths[j] / (Math.PI * 4));
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
            }
            this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            if (this.meanMagneticUsed) {
                i = 0;
                while (i < this.numberOfLayers) {
                    j = 0;
                    while (j < this.numberOfWavelengths) {
                        this.relativeMagneticPermeabilities[j][i] = this.meanRelativeMagneticPermeabilities[i];
                        ++j;
                    }
                    ++i;
                }
                this.magneticSet = true;
            } else {
                i = 0;
                while (i < this.numberOfLayers) {
                    j = 0;
                    while (j < this.numberOfWavelengths) {
                        this.relativeMagneticPermeabilities[j][i] = Complex.plusOne();
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (!this.freqSet) {
            this.frequencies = new double[this.numberOfWavelengths];
            i = 0;
            while (i < this.numberOfWavelengths) {
                this.frequencies[this.numberOfWavelengths - 1 - i] = 2.99792458E8 / wavelengths[i];
                ++i;
            }
        }
        this.omega = new double[this.numberOfWavelengths];
        i = 0;
        while (i < this.numberOfWavelengths) {
            this.omega[i] = Math.PI * 2 * this.frequencies[i];
            ++i;
        }
        this.wavelNumberSet = true;
    }

    public void setFrequency(double[] frequency) {
        int n = frequency.length;
        if (this.wavelNumberSet && n != this.numberOfWavelengths) {
            throw new IllegalArgumentException("The number of frequencies entered, " + n + ", does not equal that previously set," + this.numberOfWavelengths);
        }
        this.frequencies = frequency;
        this.freqSet = true;
        this.wavelengthAxisOption = 2;
        double[] wavelength = new double[n];
        int i = 0;
        while (i < n) {
            wavelength[i] = 2.99792458E8 / this.frequencies[n - 1 - i];
            ++i;
        }
        this.setWavelength(wavelength);
    }

    public void setWavelength(double lambdaLow, double lambdaHigh, int nLambda) {
        double increment = (lambdaHigh - lambdaLow) / (double)(nLambda - 1);
        double[] wavelength = new double[nLambda];
        wavelength[0] = lambdaLow;
        int i = 1;
        while (i < nLambda - 1) {
            wavelength[i] = wavelength[i - 1] + increment;
            ++i;
        }
        wavelength[nLambda - 1] = lambdaHigh;
        this.setWavelength(wavelength);
    }

    public void setFrequency(double freqLow, double freqHigh, int nFreq) {
        double increment = (freqHigh - freqLow) / (double)(nFreq - 1);
        double[] frequency = new double[nFreq];
        frequency[0] = freqLow;
        int i = 1;
        while (i < nFreq - 1) {
            frequency[i] = frequency[i - 1] + increment;
            ++i;
        }
        frequency[nFreq - 1] = freqHigh;
        this.setFrequency(frequency);
    }

    public void setWavelength(double wavelength) {
        double[] wavelengths = new double[]{wavelength};
        this.setWavelength(wavelengths);
    }

    public void setFrequency(double frequency) {
        double[] frequencies = new double[]{frequency};
        this.setFrequency(frequencies);
    }

    public double[] getWavelengths() {
        return this.wavelengths;
    }

    public double[] getRadialFrequencies() {
        return this.omega;
    }

    private void sortWavelengths() {
        this.origWavelIndices = new int[this.numberOfWavelengths];
        int i = 0;
        while (i < this.numberOfWavelengths) {
            this.origWavelIndices[i] = i;
            ++i;
        }
        if (this.numberOfWavelengths > 1) {
            boolean test0 = true;
            boolean test1 = false;
            int ii = 1;
            while (test0) {
                if (this.wavelengths[ii] < this.wavelengths[ii - 1]) {
                    test0 = false;
                    test1 = true;
                    continue;
                }
                if (++ii < this.numberOfWavelengths) continue;
                test0 = false;
            }
            if (test1) {
                int j;
                ArrayList<Object> arrayl = Fmath.selectSortArrayList(this.wavelengths);
                this.wavelengths = (double[])arrayl.get(1);
                this.origWavelIndices = (int[])arrayl.get(2);
                Complex[][] tempC = new Complex[this.numberOfWavelengths][this.numberOfLayers];
                int i2 = 0;
                while (i2 < this.numberOfWavelengths) {
                    j = 0;
                    while (j < this.numberOfLayers) {
                        tempC[i2][j] = this.refractiveIndices[this.origWavelIndices[i2]][j];
                        ++j;
                    }
                    ++i2;
                }
                this.refractiveIndices = Complex.copy(tempC);
                i2 = 0;
                while (i2 < this.numberOfWavelengths) {
                    j = 0;
                    while (j < this.numberOfLayers) {
                        tempC[i2][j] = this.relativeMagneticPermeabilities[this.origWavelIndices[i2]][j];
                        ++j;
                    }
                    ++i2;
                }
                this.relativeMagneticPermeabilities = Complex.copy(tempC);
                double[][] tempD = new double[this.numberOfWavelengths][this.numberOfLayers];
                int i3 = 0;
                while (i3 < this.numberOfWavelengths) {
                    int j2 = 0;
                    while (j2 < this.numberOfLayers) {
                        tempD[i3][j2] = this.absorptionCoefficients[this.origWavelIndices[i3]][j2];
                        ++j2;
                    }
                    ++i3;
                }
                this.absorptionCoefficients = tempD;
            }
        }
    }

    public void setRefractiveIndices(Complex[][] refractiveIndices) {
        int n = refractiveIndices[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refractive indices layers, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int m = refractiveIndices.length;
        if (this.wavelSet && m != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of refractive indices wavelength sets, " + m + ", does not match the number of wavelengths already set, " + this.numberOfWavelengths);
        }
        this.refractiveIndices = refractiveIndices;
        int i = 0;
        while (i < this.numberOfLayers) {
            this.refractLayerSet[i] = true;
            ++i;
        }
        this.refractSet = true;
        this.wavelNumberSet = true;
        i = 0;
        while (i < this.numberOfLayers) {
            Complex sum2 = Complex.zero();
            int j = 0;
            while (j < this.numberOfWavelengths) {
                sum2.plusEquals(this.refractiveIndices[j][i]);
                ++j;
            }
            this.meanRefractiveIndices[i] = sum2.over(this.numberOfWavelengths);
            ++i;
        }
        if (this.wavelSet && this.absorptionCoefficients != null) {
            i = 0;
            while (i < this.numberOfLayers) {
                int j = 0;
                while (j < this.numberOfWavelengths) {
                    if (this.refractiveIndices[j][i].getImag() == 0.0) {
                        this.refractiveIndices[j][i].setImag(this.absorptionCoefficients[j][i] * this.wavelengths[i] / (Math.PI * 4));
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!this.absorbSet) {
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        if (!this.magneticSet) {
            if (this.meanMagneticUsed) {
                i = 0;
                while (i < this.numberOfLayers) {
                    int j = 0;
                    while (j < this.numberOfWavelengths) {
                        this.relativeMagneticPermeabilities[j][i] = this.meanRelativeMagneticPermeabilities[i];
                        ++j;
                    }
                    ++i;
                }
                this.magneticSet = true;
            } else {
                this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers, 1.0, 0.0);
            }
        }
    }

    public void setRefractiveIndices(double[][] refractiveIndices) {
        int n = refractiveIndices[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refractive indices layers, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int m = refractiveIndices.length;
        if (this.wavelSet && m != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of refractive indices wavelength sets, " + m + ", does not match the number of wavelengths already set, " + this.numberOfWavelengths);
        }
        Complex[][] complexRefractiveIndices = Complex.twoDarray(m, n);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                complexRefractiveIndices[i][j].setReal(refractiveIndices[i][j]);
                ++j;
            }
            ++i;
        }
        this.setRefractiveIndices(complexRefractiveIndices);
    }

    public void setRefractiveIndices(Complex[] refractiveIndices) {
        int j;
        int i;
        int n = refractiveIndices.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refrative indices layers, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        this.meanRefractiveIndices = refractiveIndices;
        this.meanRefractUsed = true;
        if (this.wavelNumberSet) {
            i = 0;
            while (i < this.numberOfLayers) {
                j = 0;
                while (j < this.numberOfWavelengths) {
                    this.refractiveIndices[j][i] = this.meanRefractiveIndices[i];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.numberOfLayers) {
                this.refractLayerSet[i] = true;
                ++i;
            }
            this.refractSet = true;
        }
        if (this.absorptionCoefficients != null && this.wavelSet) {
            i = 0;
            while (i < this.numberOfLayers) {
                j = 0;
                while (j < this.numberOfWavelengths) {
                    if (this.refractiveIndices[j][i].getImag() == 0.0) {
                        this.refractiveIndices[j][i].setImag(this.absorptionCoefficients[j][i] * this.wavelengths[j] / (Math.PI * 4));
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.absorptionCoefficients == null) {
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        if (!this.magneticSet) {
            if (!this.meanMagneticUsed) {
                if (this.wavelNumberSet) {
                    this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers, 1.0, 0.0);
                }
            } else {
                this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
                i = 0;
                while (i < this.numberOfLayers) {
                    j = 0;
                    while (j < this.numberOfWavelengths) {
                        this.relativeMagneticPermeabilities[j][i] = this.meanRelativeMagneticPermeabilities[i];
                        ++j;
                    }
                    ++i;
                }
                this.magneticSet = true;
            }
        }
    }

    public void setRefractiveIndices(double[] refractiveIndices) {
        int n = refractiveIndices.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refrative indices, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        Complex[] complexRefractiveIndices = Complex.oneDarray(n);
        int i = 0;
        while (i < n) {
            complexRefractiveIndices[i].setReal(refractiveIndices[i]);
            ++i;
        }
        this.setRefractiveIndices(complexRefractiveIndices);
    }

    public void setRefractiveIndices(Complex[] refractiveIndices, int layerNumber) {
        if (layerNumber < 0 || layerNumber > this.numberOfLayers) {
            throw new IllegalArgumentException("Layer number, " + layerNumber + ", must be in the range 1 to " + this.numberOfLayers);
        }
        int n = refractiveIndices.length;
        if (this.wavelNumberSet) {
            if (n != this.numberOfWavelengths) {
                throw new IllegalArgumentException("The number of refractive index wavelength values, " + n + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
            }
        } else {
            int j;
            int i;
            this.numberOfWavelengths = n;
            this.wavelNumberSet = true;
            this.refractiveIndices = Complex.twoDarray(this.numberOfLayers, this.numberOfWavelengths);
            if (this.meanRefractUsed) {
                i = 0;
                while (i < this.numberOfLayers) {
                    j = 0;
                    while (j < this.numberOfWavelengths) {
                        this.refractiveIndices[j][i] = this.meanRefractiveIndices[i];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.numberOfLayers) {
                    this.refractLayerSet[i] = true;
                    ++i;
                }
                this.refractSet = true;
            }
            this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers, 1.0, 0.0);
            if (this.meanMagneticUsed) {
                i = 0;
                while (i < this.numberOfLayers) {
                    j = 0;
                    while (j < this.numberOfWavelengths) {
                        this.relativeMagneticPermeabilities[j][i] = this.meanRelativeMagneticPermeabilities[i];
                        ++j;
                    }
                    ++i;
                }
                this.magneticSet = true;
            }
        }
        this.refractiveIndices[--layerNumber] = refractiveIndices;
        this.refractLayerSet[layerNumber] = true;
        int check2 = 0;
        int i = 0;
        while (i < this.numberOfLayers) {
            if (this.refractLayerSet[i]) {
                ++check2;
            }
            ++i;
        }
        if (check2 == this.numberOfLayers) {
            this.refractSet = true;
        }
        if (this.absorptionCoefficients != null) {
            i = 0;
            while (i < this.numberOfLayers) {
                int j = 0;
                while (j < this.numberOfWavelengths) {
                    if (this.refractiveIndices[j][i].getImag() == 0.0) {
                        this.refractiveIndices[j][i].setImag(this.absorptionCoefficients[j][i] * this.wavelengths[j] / (Math.PI * 4));
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.absorptionCoefficients == null) {
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
    }

    public void setRefractiveIndices(double[] refractiveIndices, int layerNumber) {
        if (layerNumber < 0 || layerNumber > this.numberOfLayers) {
            throw new IllegalArgumentException("Layer number, " + layerNumber + ", must be in the range 1 to " + this.numberOfLayers);
        }
        int n = refractiveIndices.length;
        if (this.wavelNumberSet && n != this.numberOfWavelengths) {
            throw new IllegalArgumentException("The number of refractive index wavelength values, " + n + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        Complex[] complexRefractiveIndices = Complex.oneDarray(n);
        int i = 0;
        while (i < n) {
            complexRefractiveIndices[i].setReal(refractiveIndices[i]);
            ++i;
        }
        this.setRefractiveIndices(complexRefractiveIndices, layerNumber);
    }

    public void setRefractiveIndices(Complex refractiveIndex, int layerNumber) {
        if (this.wavelNumberSet) {
            Complex[] complexRefractiveIndices = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                complexRefractiveIndices[i] = refractiveIndex;
                ++i;
            }
            this.setRefractiveIndices(complexRefractiveIndices, layerNumber);
        } else {
            this.meanRefractiveIndices[layerNumber - 1] = refractiveIndex;
            this.meanRefractUsed = true;
        }
    }

    public void setRefractiveIndices(double refractiveIndex, int layerNumber) {
        Complex complexRefractiveIndex = new Complex(refractiveIndex, 0.0);
        this.setRefractiveIndices(complexRefractiveIndex, layerNumber);
    }

    public Object getRefractiveIndices() {
        if (this.numberOfWavelengths == 1) {
            Complex[] ret = this.refractiveIndices[0];
            return ret;
        }
        return this.refractiveIndices;
    }

    public void setAbsorptionCoefficients(double[] absorptionCoefficients) {
        int n = absorptionCoefficients.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of absorption coefficients sets, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        this.absorptionCoefficients = new double[1][n];
        this.absorptionCoefficients[0] = absorptionCoefficients;
        this.absorbSet = true;
        if (this.refractSet) {
            int i = 0;
            while (i < this.numberOfLayers) {
                if (this.refractiveIndices[0][i].getImag() == 0.0) {
                    this.refractiveIndices[0][i].setImag(this.absorptionCoefficients[0][i] * this.wavelengths[0] / (Math.PI * 4));
                }
                ++i;
            }
        }
    }

    public void setAbsorptionCoefficients(double[][] absorptionCoefficients) {
        int n = absorptionCoefficients[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of absorption coefficients sets, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int m = absorptionCoefficients.length;
        if (this.wavelNumberSet && m != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of absorption coefficients wavelengths, " + m + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        this.absorptionCoefficients = absorptionCoefficients;
        this.absorbSet = true;
        if (this.refractSet && this.wavelSet) {
            int i = 0;
            while (i < this.numberOfLayers) {
                int j = 0;
                while (j < this.numberOfWavelengths) {
                    if (this.refractiveIndices[j][i].getImag() == 0.0) {
                        this.refractiveIndices[j][i].setImag(absorptionCoefficients[j][i] * this.wavelengths[j] / (Math.PI * 4));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setAbsorptionCoefficients(double[] absorptionCoefficients, int layerNumber) {
        int n = absorptionCoefficients.length;
        if (this.wavelNumberSet) {
            if (n != this.numberOfWavelengths) {
                throw new IllegalArgumentException("Layer " + layerNumber + ": number of absorption coefficients wavelengths, " + n + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
            }
        } else {
            this.numberOfWavelengths = n;
            this.refractiveIndices = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        this.absorptionCoefficients[--layerNumber] = absorptionCoefficients;
        int j = 0;
        while (j < this.numberOfWavelengths) {
            if (this.refractiveIndices[j][layerNumber].getImag() == 0.0) {
                this.refractiveIndices[j][layerNumber].setImag(absorptionCoefficients[j] * this.wavelengths[j] / (Math.PI * 4));
            }
            ++j;
        }
        this.absorbSet = true;
    }

    public void setAbsorptionCoefficients(double absorptionCoefficient, int layerNumber) {
        if (this.wavelNumberSet) {
            if (this.numberOfWavelengths != 1) {
                throw new IllegalArgumentException("Layer " + layerNumber + ": number of absorption coefficients wavelengths, " + 1 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
            }
        } else {
            this.numberOfWavelengths = 1;
            this.refractiveIndices = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        this.absorptionCoefficients[0][--layerNumber] = absorptionCoefficient;
        if (this.refractiveIndices[0][layerNumber].getImag() == 0.0) {
            this.refractiveIndices[0][layerNumber].setImag(absorptionCoefficient * this.wavelengths[0] / (Math.PI * 4));
        }
        this.absorbSet = true;
    }

    public Object getAbsorptionCoefficients() {
        double[][] absC = this.absorptionCoefficients;
        int i = 0;
        while (i < this.numberOfLayers) {
            int j = 0;
            while (j < this.numberOfWavelengths) {
                absC[i][j] = Math.PI * 4 * this.wavelengths[j] * this.refractiveIndices[i][j].getImag();
                ++j;
            }
            ++i;
        }
        if (this.numberOfWavelengths == 1) {
            double[] ret = absC[0];
            return ret;
        }
        return absC;
    }

    public void setRelativeMagneticPermeabilities(Complex[][] relativeMagneticPermeabilities) {
        int n = relativeMagneticPermeabilities[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int m = relativeMagneticPermeabilities.length;
        if (this.wavelNumberSet && m != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities associated wavelengths, " + m + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        this.relativeMagneticPermeabilities = relativeMagneticPermeabilities;
        this.magneticSet = true;
        int i = 0;
        while (i < this.numberOfLayers) {
            Complex sum2 = Complex.zero();
            int j = 0;
            while (j < this.numberOfWavelengths) {
                sum2.plusEquals(this.relativeMagneticPermeabilities[j][i]);
                ++j;
            }
            this.meanRelativeMagneticPermeabilities[i] = sum2.over(this.numberOfWavelengths);
            ++i;
        }
    }

    public void relativeMagneticPermeabilities(double[][] relativeMagneticPermeabilities) {
        int n = relativeMagneticPermeabilities[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int m = relativeMagneticPermeabilities.length;
        if (this.wavelNumberSet && m != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities associated wavelengths, " + m + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        this.relativeMagneticPermeabilities = Complex.twoDarray(m, n);
        int i = 0;
        while (i < this.numberOfLayers) {
            int j = 0;
            while (j < this.numberOfWavelengths) {
                this.relativeMagneticPermeabilities[j][i].setReal(relativeMagneticPermeabilities[j][i]);
                ++j;
            }
            ++i;
        }
        this.magneticSet = true;
        i = 0;
        while (i < this.numberOfLayers) {
            Complex sum2 = Complex.zero();
            int j = 0;
            while (j < this.numberOfWavelengths) {
                sum2.plusEquals(this.relativeMagneticPermeabilities[j][i]);
                ++j;
            }
            this.meanRelativeMagneticPermeabilities[i] = sum2.over(this.numberOfWavelengths);
            ++i;
        }
    }

    public void setRelativeMagneticPermeabilities(Complex[] relativeMagneticPermeabilities) {
        int n = relativeMagneticPermeabilities.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        this.meanRelativeMagneticPermeabilities = relativeMagneticPermeabilities;
        this.meanMagneticUsed = true;
        if (this.wavelNumberSet) {
            int i = 0;
            while (i < this.numberOfWavelengths) {
                this.relativeMagneticPermeabilities[i] = Complex.copy(relativeMagneticPermeabilities);
                ++i;
            }
        }
    }

    public void setRelativeMagneticPermeabilities(double[] relativeMagneticPermeabilities) {
        int n = relativeMagneticPermeabilities.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int i = 0;
        while (i < n) {
            this.meanRelativeMagneticPermeabilities[i].setReal(relativeMagneticPermeabilities[i]);
            ++i;
        }
        this.meanMagneticUsed = true;
        if (this.wavelNumberSet) {
            i = 0;
            while (i < this.numberOfWavelengths) {
                this.relativeMagneticPermeabilities[i] = Complex.copy(this.meanRelativeMagneticPermeabilities);
                ++i;
            }
        }
    }

    public void setRelativeMagneticPermeabilities(Complex[] relativeMagneticPermeabilities, int layerNumber) {
        int n = relativeMagneticPermeabilities.length;
        if (this.wavelNumberSet && n != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Layer " + layerNumber + ": number of relative magnetic permeabilities associated wavelengths, " + n + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        if (this.relativeMagneticPermeabilities == null) {
            this.relativeMagneticPermeabilities = Complex.twoDarray(n, this.numberOfLayers);
        }
        this.relativeMagneticPermeabilities[layerNumber - 1] = relativeMagneticPermeabilities;
        Complex sum2 = Complex.zero();
        int i = 0;
        while (i < n) {
            sum2.plusEquals(this.relativeMagneticPermeabilities[i][layerNumber - 1]);
            ++i;
        }
        this.meanRelativeMagneticPermeabilities[layerNumber - 1] = sum2.over(n);
    }

    public void setRelativeMagneticPermeabilities(double[] relativeMagneticPermeabilities, int layerNumber) {
        int n = relativeMagneticPermeabilities.length;
        if (this.wavelNumberSet && n != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Layer " + layerNumber + ": number of relative magnetic permeabilities associated wavelengths, " + n + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        if (this.relativeMagneticPermeabilities == null) {
            this.relativeMagneticPermeabilities = Complex.twoDarray(n, this.numberOfLayers);
        }
        int i = 0;
        while (i < n) {
            this.relativeMagneticPermeabilities[i][layerNumber - 1].setReal(relativeMagneticPermeabilities[i]);
            ++i;
        }
        Complex sum2 = Complex.zero();
        int i2 = 0;
        while (i2 < n) {
            sum2.plusEquals(this.relativeMagneticPermeabilities[i2][layerNumber - 1]);
            ++i2;
        }
        this.meanRelativeMagneticPermeabilities[layerNumber - 1] = sum2.over(n);
    }

    public void setRelativeMagneticPermeabilities(Complex relativeMagneticPermeability, int layerNumber) {
        this.meanRelativeMagneticPermeabilities[layerNumber - 1] = relativeMagneticPermeability;
        this.meanMagneticUsed = true;
        if (this.relativeMagneticPermeabilities != null) {
            int n = this.relativeMagneticPermeabilities[0].length;
            int i = 0;
            while (i < n) {
                this.relativeMagneticPermeabilities[i][layerNumber - 1] = relativeMagneticPermeability;
                ++i;
            }
        }
    }

    public void setRelativeMagneticPermeabilities(double relativeMagneticPermeability, int layerNumber) {
        this.meanRelativeMagneticPermeabilities[layerNumber - 1].setReal(relativeMagneticPermeability);
        this.meanMagneticUsed = true;
        if (this.relativeMagneticPermeabilities != null) {
            int n = this.relativeMagneticPermeabilities[0].length;
            int i = 0;
            while (i < n) {
                this.relativeMagneticPermeabilities[i][layerNumber - 1] = this.meanRelativeMagneticPermeabilities[layerNumber - 1];
                ++i;
            }
        }
    }

    public Object getRelativeMagneticPermeabilities() {
        if (this.numberOfWavelengths == 1) {
            Complex[] ret = this.relativeMagneticPermeabilities[0];
            return ret;
        }
        return this.relativeMagneticPermeabilities;
    }

    public Object getReflectivities() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectivities[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectivities[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.reflectivities[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectivities;
        }
        return null;
    }

    public Object getTEreflectionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectCoeffTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectCoeffTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.reflectCoeffTE[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectCoeffTE;
        }
        return null;
    }

    public Object getTMreflectionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectCoeffTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectCoeffTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.reflectCoeffTM[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectCoeffTM;
        }
        return null;
    }

    public Object getTransmissivities() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmissivities[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmissivities[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmissivities[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmissivities;
        }
        return null;
    }

    public Object getPowerLoss() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.powerLosses[0];
        }
        if (this.angularReflectCalculated) {
            return this.powerLosses[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.powerLosses[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.powerLosses;
        }
        return null;
    }

    public Object getTransmissionAnglesInRadians() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitAnglesRad[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitAnglesRad[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitAnglesRad[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitAnglesRad;
        }
        return null;
    }

    public Object getTransmissionAnglesInDegrees() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitAnglesDeg[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitAnglesDeg[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitAnglesDeg[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitAnglesDeg;
        }
        return null;
    }

    public Object getTEtransmissionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitCoeffTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitCoeffTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitCoeffTE[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitCoeffTE;
        }
        return null;
    }

    public Object getTMtransmissionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitCoeffTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitCoeffTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitCoeffTM[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitCoeffTM;
        }
        return null;
    }

    public Object getTEreflectionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftDegTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftDegTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.reflectPhaseShiftDegTE[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftDegTE;
        }
        return null;
    }

    public Object getTEreflectionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftRadTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftRadTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.reflectPhaseShiftRadTE[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftRadTE;
        }
        return null;
    }

    public Object getTMreflectionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftDegTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftDegTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.reflectPhaseShiftDegTM[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftDegTM;
        }
        return null;
    }

    public Object getTMreflectionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftRadTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftRadTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.reflectPhaseShiftRadTM[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftRadTM;
        }
        return null;
    }

    public Object getTEtransmissionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftDegTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftDegTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitPhaseShiftDegTE[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftDegTE;
        }
        return null;
    }

    public Object getTEtransmissionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftRadTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftRadTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitPhaseShiftRadTE[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftRadTE;
        }
        return null;
    }

    public Object getTMtransmissionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftDegTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftDegTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitPhaseShiftDegTM[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftDegTM;
        }
        return null;
    }

    public Object getTMtransmissionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftRadTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftRadTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.transmitPhaseShiftRadTM[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftRadTM;
        }
        return null;
    }

    public Object getEvanescentFields(double fieldDistance) {
        this.fieldDistance = fieldDistance;
        return this.getEvanescentFields();
    }

    public Object getEvanescentFields() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.evanescentFields[0];
        }
        if (this.angularReflectCalculated) {
            return this.evanescentFields[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.evanescentFields[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.evanescentFields;
        }
        return null;
    }

    public Object getPenetrationDepths() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.penetrationDepths[0];
        }
        if (this.angularReflectCalculated) {
            return this.penetrationDepths[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] ret = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.penetrationDepths[i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.penetrationDepths;
        }
        return null;
    }

    public Object getKoVectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.koVector[0][0][0];
        }
        if (this.angularReflectCalculated) {
            return this.koVector[0][0][0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.koVector[i][0][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.koVector[i][0][0];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public Object getKzVectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.kzVector[0][0][0];
        }
        if (this.angularReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfIncidentAngles);
            int i = 0;
            while (i < this.numberOfIncidentAngles) {
                ret[i] = this.kzVector[0][i][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] ret = Complex.oneDarray(this.numberOfWavelengths);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                ret[i] = this.kzVector[i][0][0];
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            Complex[][] ret = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (j < this.numberOfIncidentAngles) {
                    ret[i][j] = this.kzVector[i][j][0];
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    public Object getKvectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.kVector[0][0];
        }
        if (this.angularReflectCalculated) {
            return this.kVector[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[][] ret = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (i < this.numberOfLayers) {
                    ret[i][j] = this.kVector[i][0][j];
                    ++i;
                }
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            Complex[][] ret = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (i < this.numberOfLayers) {
                    ret[i][j] = this.kVector[i][0][j];
                    ++i;
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    public Object getKxVectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.kxVector[0][0];
        }
        if (this.angularReflectCalculated) {
            return this.kxVector[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[][] ret = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (i < this.numberOfLayers) {
                    ret[i][j] = this.kxVector[i][0][j];
                    ++i;
                }
                ++i;
            }
            return ret;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.kxVector;
        }
        return null;
    }

    public void resetPlotAxisAsFrequency() {
        this.wavelengthAxisOption = 2;
    }

    public void resetPlotAxisAsRadians() {
        this.wavelengthAxisOption = 3;
    }

    public void resetPlotAxisAsWavelength() {
        this.wavelengthAxisOption = 1;
    }

    public void plotReflectivities() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotReflectivities(legend);
    }

    public void plotReflectivities(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String graphLegendExtra = " Reflectivities";
        String yLegend = "Reflectivity";
        String yUnits = " ";
        this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.reflectivities);
    }

    public void plotTransmissivities() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTransmissivities(legend);
    }

    public void plotTransmissivities(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String graphLegendExtra = " Transmissivities";
        String yLegend = "Transmissivity";
        String yUnits = " ";
        this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.transmissivities);
    }

    public void plotPowerLosses() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotPowerLosses(legend);
    }

    public void plotPowerLosses(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String graphLegendExtra = " Power Losses in decibels relative to an incident power of 1 mW";
        String yLegend = "Power Losses";
        String yUnits = "dBm";
        this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.powerLosses);
    }

    public void plotTransmissionAngles() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTransmissionAngles(legend);
    }

    public void plotTransmissionAngles(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String graphLegendExtra = " Transmission angles (degrees)";
        String yLegend = "Transmission angle";
        String yUnits = "degrees";
        this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.transmitAnglesDeg);
    }

    public void plotAbsTEreflectionCoefficients() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotAbsTEreflectionCoefficients(legend);
    }

    public void plotAbsTEreflectionCoefficients(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE transmission coefficient plot displayed as no light in the TE mode");
        } else {
            double[][] absTEr = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (j < this.numberOfIncidentAngles) {
                    absTEr[i][j] = this.reflectCoeffTE[i][j].abs();
                    ++j;
                }
                ++i;
            }
            String graphLegendExtra = " Absolute values of the TE reflection coefficients";
            String yLegend = "|TE Reflection Coefficient|";
            String yUnits = " ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, absTEr);
        }
    }

    public void plotAbsTMreflectionCoefficients() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotAbsTMreflectionCoefficients(legend);
    }

    public void plotAbsTMreflectionCoefficients(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM transmission coefficient plot displayed as no light in the TM mode");
        } else {
            double[][] absTMr = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (j < this.numberOfIncidentAngles) {
                    absTMr[i][j] = this.reflectCoeffTM[i][j].abs();
                    ++j;
                }
                ++i;
            }
            String graphLegendExtra = " Absolute values of the TM reflection coefficients";
            String yLegend = "|TM Reflection Coefficient|";
            String yUnits = " ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, absTMr);
        }
    }

    public void plotAbsTEtransmissionCoefficients() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotAbsTEtransmissionCoefficients(legend);
    }

    public void plotAbsTEtransmissionCoefficients(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE transmission coefficient plot displayed as no light in the TE mode");
        } else {
            double[][] absTEt = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (j < this.numberOfIncidentAngles) {
                    absTEt[i][j] = this.transmitCoeffTE[i][j].abs();
                    ++j;
                }
                ++i;
            }
            String graphLegendExtra = " Absolute values of the TE transmission coefficients";
            String yLegend = "|TE Transmission Coefficient|";
            String yUnits = " ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, absTEt);
        }
    }

    public void plotAbsTMtransmissionCoefficients() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotAbsTMtransmissionCoefficients(legend);
    }

    public void plotAbsTMtransmissionCoefficients(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM transmission coefficient plot displayed as no light in the TM mode");
        } else {
            double[][] absTMt = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (j < this.numberOfIncidentAngles) {
                    absTMt[i][j] = this.transmitCoeffTM[i][j].abs();
                    ++j;
                }
                ++i;
            }
            String graphLegendExtra = " Absolute values of the TM transmission coefficients";
            String yLegend = "|TM Transmission Coefficient|";
            String yUnits = " ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, absTMt);
        }
    }

    public void plotEvanescentFields() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotEvanescentFields(legend);
    }

    public void plotEvanescentFields(double distanceIntoField) {
        this.fieldDistance = this.fieldDistance;
        String legend = "Polarisation mode: " + this.mode;
        this.plotEvanescentFields(legend);
    }

    public void plotEvanescentFields(double fieldDistance, String legend) {
        this.fieldDistance = fieldDistance;
        this.plotEvanescentFields(legend);
    }

    public void plotEvanescentFields(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String graphLegendExtra = " Integrated Evanescent Field Intensities to a depth of " + this.fieldDistance + " metres";
        String yLegend = "Evanescent Field intensity";
        String yUnits = " ";
        this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.evanescentFields);
    }

    public void plotPenetrationDepths() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotPenetrationDepths(legend);
    }

    public void plotPenetrationDepths(String graphLegend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String graphLegendExtra = " Evanescent Field Penetration Depths";
        String yLegend = "Penetration Depth";
        String yUnits = "metres";
        this.plotSimulation(graphLegend, graphLegendExtra, yLegend, yUnits, this.penetrationDepths);
    }

    public void plotTEreflectionPhaseShiftDeg() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTEreflectionPhaseShiftDeg(legend);
    }

    public void plotTEreflectionPhaseShiftDeg(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String graphLegendExtra = " Phase Shift on Reflection (TE mode)";
            String yLegend = "Phase shift";
            String yUnits = "degrees ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.reflectPhaseShiftDegTE);
        }
    }

    public void plotTMreflectionPhaseShiftDeg() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTMreflectionPhaseShiftDeg(legend);
    }

    public void plotTMreflectionPhaseShiftDeg(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String graphLegendExtra = " Phase Shift on Reflection (TM mode)";
            String yLegend = "Phase shift";
            String yUnits = "degrees ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.reflectPhaseShiftDegTM);
        }
    }

    public void plotTEreflectionPhaseShiftRad() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTEreflectionPhaseShiftRad(legend);
    }

    public void plotTEreflectionPhaseShiftRad(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String graphLegendExtra = " Phase Shift on Reflection (TE mode)";
            String yLegend = "Phase shift";
            String yUnits = "radians ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.reflectPhaseShiftRadTE);
        }
    }

    public void plotTMreflectionPhaseShiftRad() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTMreflectionPhaseShiftRad(legend);
    }

    public void plotTMreflectionPhaseShiftRad(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String graphLegendExtra = " Phase Shift on Reflection (TM mode)";
            String yLegend = "Phase shift";
            String yUnits = "radians ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.reflectPhaseShiftRadTM);
        }
    }

    public void plotTEtransmissionPhaseShiftDeg() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTEtransmissionPhaseShiftDeg(legend);
    }

    public void plotTEtransmissionPhaseShiftDeg(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String graphLegendExtra = " Phase Shift on Transmission (TE mode)";
            String yLegend = "Phase shift";
            String yUnits = "degrees ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.transmitPhaseShiftDegTE);
        }
    }

    public void plotTMtransmissionPhaseShiftDeg() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTMtransmissionPhaseShiftDeg(legend);
    }

    public void plotTMtransmissionPhaseShiftDeg(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String graphLegendExtra = " Phase Shift on Transmission (TM mode)";
            String yLegend = "Phase shift";
            String yUnits = "degrees ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.transmitPhaseShiftDegTM);
        }
    }

    public void plotTEtransmissionPhaseShiftRad() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTEtransmissionPhaseShiftRad(legend);
    }

    public void plotTEtransmissionPhaseShiftRad(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String graphLegendExtra = " Phase Shift on Transmission (TE mode)";
            String yLegend = "Phase shift";
            String yUnits = "radians ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.transmitPhaseShiftRadTE);
        }
    }

    public void plotTMtransmissionPhaseShiftRad() {
        String legend = "Polarisation mode: " + this.mode;
        this.plotTMtransmissionPhaseShiftRad(legend);
    }

    public void plotTMtransmissionPhaseShiftRad(String legend) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String graphLegendExtra = " Phase Shift on Transmission (TM mode)";
            String yLegend = "Phase shift";
            String yUnits = "radians ";
            this.plotSimulation(legend, graphLegendExtra, yLegend, yUnits, this.transmitPhaseShiftRadTM);
        }
    }

    public void plotSimulation(String graphLegend, String graphLegendExtra, String yLegend, String yUnits, Object yValuesObject) {
        Object internalArray = yValuesObject;
        int nCurves = 1;
        while (!((internalArray = Array.get(internalArray, 0)) instanceof Double)) {
            ++nCurves;
        }
        Object yValues = new double[nCurves][];
        if (nCurves == 1) {
            double[] temp;
            yValues[0] = temp = (double[])yValuesObject;
        } else {
            yValues = (double[][])yValuesObject;
        }
        int nPoints = ((double[][])yValues).length;
        int[] pointOptions = null;
        double[][] plotData = null;
        String xLegend = null;
        String xUnits = null;
        if (this.angularReflectCalculated) {
            pointOptions = new int[]{1};
            plotData = new double[2][nPoints];
            plotData[0] = this.incidentAngleDeg;
            plotData[1] = yValues[0];
            xLegend = "Incident Angle";
            xUnits = "degrees";
        }
        if (this.wavelengthReflectCalculated) {
            pointOptions = new int[]{1};
            plotData = new double[2][nPoints];
            plotData[0] = this.wavelengths;
            double[] temp = new double[this.numberOfWavelengths];
            int i = 0;
            while (i < this.numberOfWavelengths) {
                temp[i] = yValues[i][0];
                ++i;
            }
            switch (this.wavelengthAxisOption) {
                case 1: {
                    plotData[0] = this.wavelengths;
                    plotData[1] = temp;
                    xLegend = "Wavelength";
                    xUnits = "metres";
                    break;
                }
                case 2: {
                    plotData[0] = this.frequencies;
                    i = 0;
                    while (i < this.numberOfWavelengths) {
                        plotData[1][this.numberOfWavelengths - 1 - i] = temp[i];
                        ++i;
                    }
                    xLegend = "Frequency";
                    xUnits = "Hz";
                    break;
                }
                case 3: {
                    plotData[0] = this.omega;
                    i = 0;
                    while (i < this.numberOfWavelengths) {
                        plotData[1][this.numberOfWavelengths - 1 - i] = temp[i];
                        ++i;
                    }
                    xLegend = "Radial Frequency";
                    xUnits = "radians";
                }
            }
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            pointOptions = new int[nCurves];
            plotData = new double[2 * nCurves][nPoints];
            int i = 0;
            while (i < nCurves) {
                pointOptions[i] = i + 1;
                plotData[2 * i] = this.incidentAngleDeg;
                plotData[2 * i + 1] = yValues[i];
                ++i;
            }
            xLegend = "Incident Angle";
            xUnits = "degrees";
        }
        PlotGraph pg = new PlotGraph(plotData);
        pg.setGraphTitle("Class Reflectivity: Simulation Plot - " + graphLegendExtra);
        pg.setGraphTitle2(graphLegend);
        pg.setXaxisLegend(xLegend);
        pg.setYaxisLegend(yLegend);
        pg.setXaxisUnitsName(xUnits);
        if (!yUnits.equals(" ")) {
            pg.setYaxisUnitsName(yUnits);
        }
        pg.setLine(3);
        pg.setPoint(pointOptions);
        pg.plot();
    }

    public void checkWhichCalculation() {
        boolean test2 = false;
        if (this.singleReflectCalculated) {
            test2 = true;
        }
        if (this.angularReflectCalculated) {
            test2 = true;
        }
        if (this.wavelengthReflectCalculated) {
            test2 = true;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            test2 = true;
        }
        if (test2) {
            if (this.fieldDistance != Double.POSITIVE_INFINITY && !this.fieldIntensityCalc) {
                int nkouter = this.numberOfLayers - 1;
                double integratedEvanescentField = 0.0;
                int i = 0;
                while (i < this.numberOfWavelengths) {
                    int j = 0;
                    while (j < this.numberOfIncidentAngles) {
                        if (this.kxVector[i][j][nkouter].getReal() == 0.0) {
                            double penetrationDepth = 1.0 / this.kxVector[i][j][nkouter].getImag();
                            integratedEvanescentField += this.teFraction * Fmath.square(this.transmitCoeffTE[i][j].abs()) * (1.0 - Math.exp(-2.0 * this.fieldDistance / penetrationDepth)) * penetrationDepth / 2.0;
                            double refrTerm = this.refractiveIndices[i][0].getReal() / this.refractiveIndices[i][j].getReal();
                            double magnTerm = Math.sqrt(this.relativeMagneticPermeabilities[i][nkouter].getReal() / this.relativeMagneticPermeabilities[i][0].getReal());
                            integratedEvanescentField += this.teFraction * Fmath.square(this.transmitCoeffTM[i][j].abs()) * magnTerm * refrTerm * (1.0 - Math.exp(-2.0 * this.fieldDistance / penetrationDepth)) * penetrationDepth / 2.0;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.fieldIntensityCalc = true;
            }
        } else {
            if (this.numberOfIncidentAngles == 0) {
                throw new IllegalArgumentException("No incident angle/s has/have been entered");
            }
            if (this.numberOfWavelengths == 0) {
                throw new IllegalArgumentException("No wavelength/s has/have been entered");
            }
            if (this.numberOfWavelengths > 1) {
                this.sortWavelengths();
            }
            this.koVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            this.kzVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            this.kVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            this.kxVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            int i = 0;
            while (i < this.numberOfWavelengths) {
                int j = 0;
                while (j < this.numberOfIncidentAngles) {
                    int k = 0;
                    while (k < this.numberOfLayers) {
                        this.koVector[i][j][k].reset(Math.PI * 2 / this.wavelengths[i], 0.0);
                        this.kVector[i][j][k] = this.koVector[i][j][k].times(this.refractiveIndices[i][k]).times(Complex.sqrt(this.relativeMagneticPermeabilities[i][k]));
                        this.kzVector[i][j][k] = this.koVector[i][j][k].times(this.refractiveIndices[i][0]).times(Complex.sqrt(this.relativeMagneticPermeabilities[i][0]));
                        this.kzVector[i][j][k] = this.kzVector[i][j][k].times(Math.sin(this.incidentAngleRad[j]));
                        this.kxVector[i][j][k] = Complex.square(this.kVector[i][j][k]).minus(Complex.square(this.kzVector[i][j][k]));
                        this.kxVector[i][j][k] = Complex.sqrt(this.kxVector[i][j][k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.reflectivities = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmissivities = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.powerLosses = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectCoeffTE = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.reflectCoeffTM = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.transmitCoeffTE = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.transmitCoeffTM = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.evanescentFields = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.penetrationDepths = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitAnglesRad = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitAnglesDeg = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftRadTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftRadTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftDegTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftDegTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftRadTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftRadTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftDegTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftDegTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.scan();
        }
    }

    public void scan() {
        if (!this.wavelSet) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.refractSet) {
            throw new IllegalArgumentException("No, or not all, refractive indices have been entered");
        }
        if (!this.thickSet) {
            throw new IllegalArgumentException("No, or not all, layer thicknesses have been entered");
        }
        if (!this.incidentAngleSet) {
            throw new IllegalArgumentException("No incident angle has been entered");
        }
        if (!this.modeSet) {
            throw new IllegalArgumentException("No polaristaion mode (TE, TM, unpolarised or mixed[angle to be entered]) has been entered");
        }
        this.singleReflectCalculated = false;
        this.angularReflectCalculated = false;
        this.wavelengthReflectCalculated = false;
        this.wavelengthAndAngularReflectCalculated = false;
        int i = 0;
        while (i < this.numberOfWavelengths) {
            int j = 0;
            while (j < this.numberOfIncidentAngles) {
                this.calcReflectivity(i, j);
                ++j;
            }
            ++i;
        }
        if (this.numberOfWavelengths == 1) {
            if (this.numberOfIncidentAngles == 1) {
                this.singleReflectCalculated = true;
            } else {
                this.angularReflectCalculated = true;
            }
        } else if (this.numberOfIncidentAngles == 1) {
            this.wavelengthReflectCalculated = true;
        } else {
            this.wavelengthAndAngularReflectCalculated = true;
        }
    }

    public void calcReflectivity(int wavelengthIndex, int angleIndex) {
        double[] ret1 = new double[6];
        if (this.teFraction > 0.0) {
            ret1 = this.calcTEreflectivity(wavelengthIndex, angleIndex);
        }
        if (this.tmFraction > 0.0) {
            double[] ret2 = this.calcTMreflectivity(wavelengthIndex, angleIndex);
            ret1[0] = this.teFraction * ret1[0] + this.tmFraction * ret2[0];
            ret1[1] = this.teFraction * ret1[1] + this.tmFraction * ret2[1];
            ret1[2] = this.teFraction * ret1[2] + this.tmFraction * ret2[2];
            ret1[3] = this.teFraction * ret1[3] + this.tmFraction * ret2[3];
            ret1[4] = this.teFraction * ret1[4] + this.tmFraction * ret2[4];
            ret1[5] = this.teFraction * ret1[5] + this.tmFraction * ret2[5];
        }
        this.reflectivities[wavelengthIndex][angleIndex] = ret1[0];
        this.transmissivities[wavelengthIndex][angleIndex] = ret1[1];
        this.transmitAnglesRad[wavelengthIndex][angleIndex] = ret1[2];
        this.transmitAnglesDeg[wavelengthIndex][angleIndex] = Math.toDegrees(ret1[2]);
        this.evanescentFields[wavelengthIndex][angleIndex] = ret1[3];
        this.penetrationDepths[wavelengthIndex][angleIndex] = ret1[4];
        this.powerLosses[wavelengthIndex][angleIndex] = ret1[5];
    }

    public double[] calcTEreflectivity(int wavelengthIndex, int angleIndex) {
        Complex tempc1 = Complex.zero();
        Complex tempc2 = Complex.zero();
        Complex tempc3 = Complex.zero();
        Complex tempc4 = Complex.zero();
        double penetrationDepth = 0.0;
        if (this.numberOfLayers == 2) {
            tempc1 = this.relativeMagneticPermeabilities[wavelengthIndex][1].times(this.kxVector[wavelengthIndex][angleIndex][0]);
            tempc2 = this.relativeMagneticPermeabilities[wavelengthIndex][0].times(this.kxVector[wavelengthIndex][angleIndex][1]);
            tempc3 = tempc1.minus(tempc2);
            tempc4 = tempc1.plus(tempc2);
            this.reflectCoeffTE[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
            tempc3 = tempc1.times(2.0);
            this.transmitCoeffTE[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
        } else {
            ComplexMatrix mati = new ComplexMatrix(2, 2);
            Complex[][] matic = Complex.twoDarray(2, 2);
            Complex costheta = this.kxVector[wavelengthIndex][angleIndex][1].over(this.kVector[wavelengthIndex][angleIndex][1]);
            Complex pTerm = this.refractiveIndices[wavelengthIndex][1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][1]));
            pTerm = pTerm.times(costheta);
            Complex beta2 = this.kxVector[wavelengthIndex][angleIndex][1].times(this.thicknesses[1]);
            matic[0][0] = Complex.cos(beta2);
            matic[1][1] = matic[0][0];
            tempc1 = Complex.sin(beta2);
            tempc1 = tempc1.times(Complex.minusJay());
            matic[0][1] = tempc1.over(pTerm);
            matic[1][0] = tempc1.times(pTerm);
            if (this.numberOfLayers > 3) {
                ComplexMatrix mat = new ComplexMatrix(Complex.copy(matic));
                int i = 2;
                while (i < this.numberOfLayers - 1) {
                    costheta = this.kxVector[wavelengthIndex][angleIndex][i].over(this.kVector[wavelengthIndex][angleIndex][i]);
                    pTerm = this.refractiveIndices[wavelengthIndex][i].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][i]));
                    pTerm = pTerm.times(costheta);
                    beta2 = this.kxVector[wavelengthIndex][angleIndex][i].times(this.thicknesses[i]);
                    matic[0][0] = Complex.cos(beta2);
                    matic[1][1] = matic[0][0];
                    tempc1 = Complex.sin(beta2);
                    tempc1 = tempc1.times(Complex.minusJay());
                    matic[0][1] = tempc1.over(pTerm);
                    matic[1][0] = tempc1.times(pTerm);
                    mati.setTwoDarray(Complex.copy(matic));
                    mat = mat.times(mati);
                    matic = mat.getArrayCopy();
                    ++i;
                }
            }
            costheta = this.kxVector[wavelengthIndex][angleIndex][0].over(this.kVector[wavelengthIndex][angleIndex][0]);
            Complex pTerm0 = this.refractiveIndices[wavelengthIndex][0].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][0]));
            pTerm0 = pTerm0.times(costheta);
            costheta = this.kxVector[wavelengthIndex][angleIndex][this.numberOfLayers - 1].over(this.kVector[wavelengthIndex][angleIndex][this.numberOfLayers - 1]);
            Complex pTermN = this.refractiveIndices[wavelengthIndex][this.numberOfLayers - 1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][this.numberOfLayers - 1]));
            pTermN = pTermN.times(costheta);
            tempc1 = matic[0][0].plus(matic[0][1].times(pTermN));
            tempc1 = tempc1.times(pTerm0);
            tempc2 = matic[1][0].plus(matic[1][1].times(pTermN));
            tempc3 = tempc1.minus(tempc2);
            tempc4 = tempc1.plus(tempc2);
            this.reflectCoeffTE[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
            this.reflectPhaseShiftRadTE[wavelengthIndex][angleIndex] = this.reflectCoeffTE[wavelengthIndex][angleIndex].arg();
            this.reflectPhaseShiftDegTE[wavelengthIndex][angleIndex] = Math.toDegrees(this.reflectPhaseShiftRadTE[wavelengthIndex][angleIndex]);
            tempc3 = pTerm0.times(2.0);
            this.transmitCoeffTE[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
            this.transmitPhaseShiftRadTE[wavelengthIndex][angleIndex] = this.transmitCoeffTE[wavelengthIndex][angleIndex].arg();
            this.transmitPhaseShiftDegTE[wavelengthIndex][angleIndex] = Math.toDegrees(this.transmitPhaseShiftRadTE[wavelengthIndex][angleIndex]);
        }
        double reflectivity = Fmath.square(this.reflectCoeffTE[wavelengthIndex][angleIndex].getReal()) + Fmath.square(this.reflectCoeffTE[wavelengthIndex][angleIndex].getImag());
        int nkouter = this.numberOfLayers - 1;
        double tempd1 = Fmath.square(this.transmitCoeffTE[wavelengthIndex][angleIndex].getReal()) + Fmath.square(this.transmitCoeffTE[wavelengthIndex][angleIndex].getImag());
        tempc2 = this.relativeMagneticPermeabilities[wavelengthIndex][0].over(this.relativeMagneticPermeabilities[wavelengthIndex][nkouter]).times(tempd1);
        tempc3 = this.kxVector[wavelengthIndex][angleIndex][nkouter].conjugate().over(this.kxVector[wavelengthIndex][angleIndex][0]);
        Complex complexTransmissivity = tempc2.times(tempc3);
        double transmissivity = 0.0;
        double reflectedAngleRad = 1.5707963267948966;
        double integratedEvanescentField = 0.0;
        if (this.kxVector[wavelengthIndex][angleIndex][nkouter].getReal() == 0.0) {
            penetrationDepth = 1.0 / this.kxVector[wavelengthIndex][angleIndex][nkouter].getImag();
            integratedEvanescentField = Fmath.square(this.transmitCoeffTE[wavelengthIndex][angleIndex].abs()) * (1.0 - Math.exp(-2.0 * this.fieldDistance / penetrationDepth)) * penetrationDepth / 2.0;
            if (this.fieldDistance != Double.POSITIVE_INFINITY) {
                this.fieldIntensityCalc = true;
            }
        } else {
            transmissivity = complexTransmissivity.getReal();
            reflectedAngleRad = Math.atan2(this.kzVector[wavelengthIndex][angleIndex][nkouter].getReal(), this.kxVector[wavelengthIndex][angleIndex][nkouter].getReal());
        }
        double powerLoss = 10.0 * Fmath.log10((1.0 - transmissivity) * 0.001);
        double[] ret = new double[]{reflectivity, transmissivity, reflectedAngleRad, integratedEvanescentField, penetrationDepth, powerLoss};
        return ret;
    }

    public double[] calcTMreflectivity(int wavelengthIndex, int angleIndex) {
        Complex tempc1 = Complex.zero();
        Complex tempc2 = Complex.zero();
        Complex tempc3 = Complex.zero();
        Complex tempc4 = Complex.zero();
        double penetrationDepth = 0.0;
        if (this.numberOfLayers == 2) {
            tempc1 = Complex.square(this.refractiveIndices[wavelengthIndex][1]).times(this.kxVector[wavelengthIndex][angleIndex][0]);
            tempc2 = Complex.square(this.refractiveIndices[wavelengthIndex][0]).times(this.kxVector[wavelengthIndex][angleIndex][1]);
            tempc3 = tempc1.minus(tempc2);
            tempc4 = tempc1.plus(tempc2);
            this.reflectCoeffTM[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
            tempc3 = tempc1.times(2.0);
            this.transmitCoeffTM[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
        } else {
            ComplexMatrix mati = new ComplexMatrix(2, 2);
            Complex[][] matic = Complex.twoDarray(2, 2);
            Complex costheta = this.kxVector[wavelengthIndex][angleIndex][1].over(this.kVector[wavelengthIndex][angleIndex][1]);
            Complex pTerm = this.refractiveIndices[wavelengthIndex][1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][1]));
            pTerm = pTerm.over(costheta);
            Complex beta2 = this.kxVector[wavelengthIndex][angleIndex][1].times(this.thicknesses[1]);
            matic[0][0] = Complex.cos(beta2);
            matic[1][1] = matic[0][0];
            tempc1 = Complex.sin(beta2);
            tempc1 = tempc1.times(Complex.minusJay());
            matic[0][1] = tempc1.over(pTerm);
            matic[1][0] = tempc1.times(pTerm);
            if (this.numberOfLayers > 3) {
                ComplexMatrix mat = new ComplexMatrix(Complex.copy(matic));
                int i = 2;
                while (i < this.numberOfLayers - 1) {
                    costheta = this.kxVector[wavelengthIndex][angleIndex][i].over(this.kVector[wavelengthIndex][angleIndex][i]);
                    pTerm = this.refractiveIndices[wavelengthIndex][i].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][i]));
                    pTerm = pTerm.over(costheta);
                    beta2 = this.kxVector[wavelengthIndex][angleIndex][i].times(this.thicknesses[i]);
                    matic[0][0] = Complex.cos(beta2);
                    matic[1][1] = matic[0][0];
                    tempc1 = Complex.sin(beta2);
                    tempc1 = tempc1.times(Complex.minusJay());
                    matic[0][1] = tempc1.over(pTerm);
                    matic[1][0] = tempc1.times(pTerm);
                    mati.setTwoDarray(Complex.copy(matic));
                    mat = mat.times(mati);
                    matic = mat.getArrayReference();
                    ++i;
                }
            }
            costheta = this.kxVector[wavelengthIndex][angleIndex][0].over(this.kVector[wavelengthIndex][angleIndex][0]);
            Complex pTerm0 = this.refractiveIndices[wavelengthIndex][0].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][0]));
            pTerm0 = pTerm0.over(costheta);
            costheta = this.kxVector[wavelengthIndex][angleIndex][this.numberOfLayers - 1].over(this.kVector[wavelengthIndex][angleIndex][this.numberOfLayers - 1]);
            Complex pTermN = this.refractiveIndices[wavelengthIndex][this.numberOfLayers - 1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][this.numberOfLayers - 1]));
            pTermN = pTermN.over(costheta);
            tempc1 = matic[0][0].plus(matic[0][1].times(pTermN));
            tempc1 = tempc1.times(pTerm0);
            tempc2 = matic[1][0].plus(matic[1][1].times(pTermN));
            tempc3 = tempc1.minus(tempc2);
            tempc4 = tempc1.plus(tempc2);
            this.reflectCoeffTM[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
            this.reflectPhaseShiftRadTM[wavelengthIndex][angleIndex] = this.reflectCoeffTM[wavelengthIndex][angleIndex].arg();
            this.reflectPhaseShiftDegTM[wavelengthIndex][angleIndex] = Math.toDegrees(this.reflectPhaseShiftRadTM[wavelengthIndex][angleIndex]);
            tempc3 = pTerm0.times(2.0);
            this.transmitCoeffTM[wavelengthIndex][angleIndex] = tempc3.over(tempc4);
            this.transmitPhaseShiftRadTM[wavelengthIndex][angleIndex] = this.transmitCoeffTM[wavelengthIndex][angleIndex].arg();
            this.transmitPhaseShiftDegTM[wavelengthIndex][angleIndex] = Math.toDegrees(this.transmitPhaseShiftRadTM[wavelengthIndex][angleIndex]);
        }
        double reflectivity = Fmath.square(this.reflectCoeffTM[wavelengthIndex][angleIndex].getReal()) + Fmath.square(this.reflectCoeffTM[wavelengthIndex][angleIndex].getImag());
        int nkouter = this.numberOfLayers - 1;
        double tempd1 = Fmath.square(this.transmitCoeffTM[wavelengthIndex][angleIndex].getReal()) + Fmath.square(this.transmitCoeffTM[wavelengthIndex][angleIndex].getImag());
        tempc2 = Complex.square(this.refractiveIndices[wavelengthIndex][0].over(this.refractiveIndices[wavelengthIndex][nkouter])).times(tempd1);
        tempc3 = this.kxVector[wavelengthIndex][angleIndex][nkouter].conjugate().over(this.kxVector[wavelengthIndex][angleIndex][0]);
        Complex complexTransmissivity = tempc2.times(tempc3);
        double transmissivity = 0.0;
        double reflectedAngleRad = 1.5707963267948966;
        double integratedEvanescentField = 0.0;
        if (this.kxVector[wavelengthIndex][angleIndex][nkouter].getReal() == 0.0) {
            penetrationDepth = 1.0 / this.kxVector[wavelengthIndex][angleIndex][nkouter].getImag();
            double refrTerm = this.refractiveIndices[wavelengthIndex][0].getReal() / this.refractiveIndices[wavelengthIndex][nkouter].getReal();
            double magnTerm = Math.sqrt(this.relativeMagneticPermeabilities[wavelengthIndex][nkouter].getReal() / this.relativeMagneticPermeabilities[wavelengthIndex][0].getReal());
            integratedEvanescentField = Fmath.square(this.transmitCoeffTM[wavelengthIndex][angleIndex].abs()) * magnTerm * refrTerm * (1.0 - Math.exp(-2.0 * this.fieldDistance / penetrationDepth)) * penetrationDepth / 2.0;
            if (this.fieldDistance != Double.POSITIVE_INFINITY) {
                this.fieldIntensityCalc = true;
            }
        } else {
            transmissivity = complexTransmissivity.getReal();
            reflectedAngleRad = Math.atan2(this.kzVector[wavelengthIndex][angleIndex][nkouter].getReal(), this.kxVector[wavelengthIndex][angleIndex][nkouter].getReal());
        }
        double powerLoss = 10.0 * Fmath.log10((1.0 - transmissivity) * 0.001);
        double[] ret = new double[]{reflectivity, transmissivity, reflectedAngleRad, integratedEvanescentField, penetrationDepth, powerLoss};
        return ret;
    }

    public void setThicknessEstimatesIndices(int[] indices) {
        this.thicknessEstimateIndices = indices;
        this.thicknessEstimateNumber = indices.length;
    }

    public void setRealRefractIndexEstimateIndices(int[] indices) {
        this.refractIndexRealEstimateIndices = indices;
        this.refractIndexRealEstimateNumber = indices.length;
    }

    public void setImagRefractIndexEstimateIndices(int[] indices) {
        this.refractIndexImagEstimateIndices = indices;
        this.refractIndexImagEstimateNumber = indices.length;
        this.refractIndexImagEstimateSet = true;
        if (this.absorptionCoeffEstimateSet) {
            int j;
            int[] temp0 = new int[this.absorptionCoeffEstimateNumber];
            int newIndex = 0;
            int i = 0;
            while (i < this.numberOfLayers) {
                boolean testR = false;
                j = 0;
                while (j < this.refractIndexImagEstimateNumber) {
                    if (i == this.refractIndexImagEstimateIndices[j]) {
                        testR = true;
                    }
                    ++j;
                }
                boolean testA = false;
                int j2 = 0;
                while (j2 < this.absorptionCoeffEstimateNumber) {
                    if (i == this.absorptionCoeffEstimateIndices[j2]) {
                        testA = true;
                    }
                    ++j2;
                }
                if (!testR && testA) {
                    temp0[newIndex] = i;
                    ++newIndex;
                }
                ++i;
            }
            int newRefrNumber = this.refractIndexImagEstimateNumber + newIndex;
            int[] temp1 = new int[newRefrNumber];
            j = 0;
            while (j < this.refractIndexImagEstimateNumber) {
                temp1[j] = this.refractIndexImagEstimateIndices[j];
                ++j;
            }
            j = 0;
            while (j < this.absorptionCoeffEstimateNumber) {
                temp1[this.refractIndexImagEstimateNumber + j] = this.absorptionCoeffEstimateIndices[j];
                ++j;
            }
            this.refractIndexImagEstimateIndices = Fmath.selectionSort(temp1);
        }
    }

    public void setAbsorptionCoefficientEstimateIndices(int[] indices) {
        this.absorptionCoeffEstimateIndices = indices;
        this.absorptionCoeffEstimateNumber = indices.length;
        this.absorptionCoeffEstimateSet = true;
        if (this.refractIndexImagEstimateSet) {
            int j;
            int[] temp0 = new int[this.absorptionCoeffEstimateNumber];
            int newIndex = 0;
            int i = 0;
            while (i < this.numberOfLayers) {
                boolean testR = false;
                j = 0;
                while (j < this.refractIndexImagEstimateNumber) {
                    if (i == this.refractIndexImagEstimateIndices[j]) {
                        testR = true;
                    }
                    ++j;
                }
                boolean testA = false;
                int j2 = 0;
                while (j2 < this.absorptionCoeffEstimateNumber) {
                    if (i == this.absorptionCoeffEstimateIndices[j2]) {
                        testA = true;
                    }
                    ++j2;
                }
                if (!testR && testA) {
                    temp0[newIndex] = i;
                    ++newIndex;
                }
                ++i;
            }
            int newRefrNumber = this.refractIndexImagEstimateNumber + newIndex;
            int[] temp1 = new int[newRefrNumber];
            j = 0;
            while (j < this.refractIndexImagEstimateNumber) {
                temp1[j] = this.refractIndexImagEstimateIndices[j];
                ++j;
            }
            j = 0;
            while (j < this.absorptionCoeffEstimateNumber) {
                temp1[this.refractIndexImagEstimateNumber + j] = this.absorptionCoeffEstimateIndices[j];
                ++j;
            }
            this.refractIndexImagEstimateIndices = Fmath.selectionSort(temp1);
        } else {
            this.refractIndexImagEstimateIndices = this.absorptionCoeffEstimateIndices;
            this.refractIndexImagEstimateNumber = this.absorptionCoeffEstimateNumber;
        }
    }

    public void setRealRelativeMagneticPermeabilityEstimateIndices(int[] indices) {
        this.magneticPermRealEstimateIndices = indices;
        this.magneticPermRealEstimateNumber = indices.length;
    }

    public void setImagRelativeMagneticPermeabilityEstimateIndices(int[] indices) {
        this.magneticPermImagEstimateIndices = indices;
        this.magneticPermImagEstimateNumber = indices.length;
    }

    public void fitReflectivities(double[] experimentalReflectivities) {
        int n = experimentalReflectivities.length;
        double[] errors = new double[n];
        int i = 0;
        while (i < n) {
            errors[i] = 1.0;
            ++i;
        }
        this.fitReflectivities(experimentalReflectivities, errors);
    }

    public void fitReflectivities(double[] experimentalReflectivities, double[] errors) {
        this.numberOfDataPoints = experimentalReflectivities.length;
        if (this.numberOfDataPoints != errors.length) {
            throw new IllegalArgumentException("Number of data points, " + this.numberOfDataPoints + " is not equal to the number of errors (weights), " + errors.length + ".");
        }
        if (this.incidentAngleSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental reflectivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] temp0 = Conv.copy(experimentalReflectivities);
            double[] temp1 = Conv.copy(errors);
            int i = 0;
            while (i < this.numberOfIncidentAngles) {
                this.experimentalData[i] = temp0[this.incidentAngleIndices[i]];
                this.experimentalWeights[i] = temp1[this.incidentAngleIndices[i]];
                ++i;
            }
        }
        this.regressionOption = 1;
        this.experimentalDataSet = true;
        this.nonLinearRegression();
    }

    public void fitAndPlotReflectivities(double[] experimentalReflectivities) {
        this.fitReflectivities(experimentalReflectivities);
        String graphTitle = " ";
        this.plotFit(graphTitle);
    }

    public void fitAndPlotReflectivities(double[] experimentalReflectivities, String graphTitle) {
        this.fitReflectivities(experimentalReflectivities);
        this.plotFit(graphTitle);
    }

    public void fitAndPlotReflectivities(double[] experimentalReflectivities, double[] errors) {
        this.fitReflectivities(experimentalReflectivities, errors);
        String graphTitle = " ";
        this.plotFit(graphTitle);
    }

    public void fitAndPlotReflectivities(double[] experimentalReflectivities, double[] errors, String graphTitle) {
        this.fitReflectivities(experimentalReflectivities, errors);
        this.plotFit(graphTitle);
    }

    public void fitTransmissivities(double[] experimentalTransmissivities) {
        int n = experimentalTransmissivities.length;
        double[] errors = new double[n];
        int i = 0;
        while (i < n) {
            errors[i] = 1.0;
            ++i;
        }
        this.fitTransmissivities(experimentalTransmissivities, errors);
    }

    public void fitTransmissivities(double[] experimentalTransmissivities, double[] errors) {
        this.numberOfDataPoints = experimentalTransmissivities.length;
        if (this.numberOfDataPoints != errors.length) {
            throw new IllegalArgumentException("Number of data points, " + this.numberOfDataPoints + " is not equal to the number of errors (weights), " + errors.length + ".");
        }
        if (this.incidentAngleSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental transmissivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] temp0 = Conv.copy(experimentalTransmissivities);
            double[] temp1 = Conv.copy(errors);
            int i = 0;
            while (i < this.numberOfIncidentAngles) {
                this.experimentalData[i] = temp0[this.incidentAngleIndices[i]];
                this.experimentalWeights[i] = temp1[this.incidentAngleIndices[i]];
                ++i;
            }
        }
        this.regressionOption = 1;
        this.experimentalDataSet = true;
        this.nonLinearRegression();
    }

    public void fitAndPlotTransmissivities(double[] experimentalTransmissivities) {
        this.fitTransmissivities(experimentalTransmissivities);
        String graphTitle = " ";
        this.plotFit(graphTitle);
    }

    public void fitAndPlotTransmissivities(double[] experimentalTransmissivities, String graphTitle) {
        this.fitTransmissivities(experimentalTransmissivities);
        this.plotFit(graphTitle);
    }

    public void fitAndPlotTransmissivities(double[] experimentalTransmissivities, double[] errors) {
        this.fitTransmissivities(experimentalTransmissivities, errors);
        String graphTitle = " ";
        this.plotFit(graphTitle);
    }

    public void fitAndPlotTransmissivities(double[] experimentalTransmissivities, double[] errors, String graphTitle) {
        this.fitTransmissivities(experimentalTransmissivities, errors);
        this.plotFit(graphTitle);
    }

    public void fitEvanescentField(double[] experimentalEvanescentFieldIntensities) {
        int n = experimentalEvanescentFieldIntensities.length;
        double[] errors = new double[n];
        int i = 0;
        while (i < n) {
            errors[i] = 1.0;
            ++i;
        }
        double fieldDistance = Double.POSITIVE_INFINITY;
        this.fitEvanescentField(experimentalEvanescentFieldIntensities, errors, fieldDistance);
    }

    public void fitEvanescentField(double[] experimentalEvanescentFieldIntensities, double[] errors) {
        double fieldDistance = Double.POSITIVE_INFINITY;
        this.fitEvanescentField(experimentalEvanescentFieldIntensities, errors, fieldDistance);
    }

    public void fitEvanescentField(double[] experimentalEvanescentFieldIntensities, double fieldDistance) {
        int n = experimentalEvanescentFieldIntensities.length;
        double[] errors = new double[n];
        int i = 0;
        while (i < n) {
            errors[i] = 1.0;
            ++i;
        }
        this.fitEvanescentField(experimentalEvanescentFieldIntensities, errors, fieldDistance);
    }

    public void fitEvanescentField(double[] experimentalEvanescentFieldIntensities, double[] errors, double fieldDistance) {
        this.numberOfDataPoints = experimentalEvanescentFieldIntensities.length;
        if (this.numberOfDataPoints != errors.length) {
            throw new IllegalArgumentException("Number of data points, " + this.numberOfDataPoints + " is not equal to the number of errors (weights), " + errors.length + ".");
        }
        if (this.incidentAngleSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental transmissivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] temp0 = Conv.copy(experimentalEvanescentFieldIntensities);
            double[] temp1 = Conv.copy(errors);
            int i = 0;
            while (i < this.numberOfIncidentAngles) {
                this.experimentalData[i] = temp0[this.incidentAngleIndices[i]];
                this.experimentalWeights[i] = temp1[this.incidentAngleIndices[i]];
                ++i;
            }
        }
        this.regressionOption = 3;
        this.fieldDistance = fieldDistance;
        this.experimentalDataSet = true;
        this.nonLinearRegression();
    }

    public void nonLinearRegression() {
        int ii = 0;
        boolean test2 = true;
        while (test2) {
            if (this.experimentalWeights[ii] != 1.0) {
                this.weightingOption = true;
                test2 = false;
                continue;
            }
            if (++ii < this.numberOfDataPoints) continue;
            test2 = false;
        }
        Regression regr = null;
        regr = this.weightingOption ? new Regression(this.incidentAngleDeg, this.experimentalData, this.experimentalWeights) : new Regression(this.incidentAngleDeg, this.experimentalData);
        RegressFunct funct0 = new RegressFunct();
        funct0.numberOfLayers = this.numberOfLayers;
        funct0.mode = this.mode;
        funct0.eVectorAngleDeg = this.eVectorAngleDeg;
        funct0.thicknesses = this.thicknesses;
        funct0.refractiveIndices = this.refractiveIndices;
        funct0.relativeMagneticPermeabilities = this.relativeMagneticPermeabilities;
        funct0.regressionOption = this.regressionOption;
        funct0.thicknessEstimateIndices = this.thicknessEstimateIndices;
        funct0.refractIndexRealEstimateIndices = this.refractIndexRealEstimateIndices;
        funct0.refractIndexImagEstimateIndices = this.refractIndexImagEstimateIndices;
        funct0.magneticPermRealEstimateIndices = this.magneticPermRealEstimateIndices;
        funct0.magneticPermImagEstimateIndices = this.magneticPermImagEstimateIndices;
        this.numberOfEstimatedParameters = this.thicknessEstimateNumber;
        this.numberOfEstimatedParameters += this.refractIndexRealEstimateNumber;
        this.numberOfEstimatedParameters += this.refractIndexImagEstimateNumber;
        this.numberOfEstimatedParameters += this.magneticPermRealEstimateNumber;
        this.numberOfEstimatedParameters += this.magneticPermImagEstimateNumber;
        if (this.regressionOption == 3) {
            ++this.numberOfEstimatedParameters;
        }
        this.degreesOfFreedom = this.numberOfDataPoints - this.numberOfEstimatedParameters;
        if (this.degreesOfFreedom < 1) {
            throw new IllegalArgumentException("Number of parameters to be estimated, " + this.numberOfEstimatedParameters + ", is greater than or equal to the number of data points, " + this.numberOfDataPoints + ".");
        }
        double[] start = new double[this.numberOfEstimatedParameters];
        double[] init2 = new double[this.numberOfEstimatedParameters];
        double[] step2 = new double[this.numberOfEstimatedParameters];
        int pIndex = 0;
        int i = 0;
        while (i < this.thicknessEstimateNumber) {
            init2[pIndex] = this.thicknesses[this.thicknessEstimateIndices[pIndex]];
            start[pIndex] = init2[pIndex];
            step2[pIndex] = init2[pIndex] * 0.1;
            if (step2[pIndex] == 0.0) {
                step2[pIndex] = 1.0E-9;
            }
            ++pIndex;
            ++i;
        }
        i = 0;
        while (i < this.refractIndexRealEstimateNumber) {
            init2[pIndex] = this.refractiveIndices[0][this.refractIndexRealEstimateIndices[pIndex]].getReal();
            start[pIndex] = init2[pIndex];
            step2[pIndex] = init2[pIndex] * 0.1;
            if (step2[pIndex] == 0.0) {
                step2[pIndex] = 0.1;
            }
            ++pIndex;
            ++i;
        }
        i = 0;
        while (i < this.refractIndexImagEstimateNumber) {
            init2[pIndex] = this.refractiveIndices[0][this.refractIndexImagEstimateIndices[pIndex]].getImag();
            start[pIndex] = init2[pIndex];
            step2[pIndex] = init2[pIndex] * 0.1;
            if (step2[pIndex] == 0.0) {
                step2[pIndex] = 0.1;
            }
            ++pIndex;
            ++i;
        }
        i = 0;
        while (i < this.magneticPermRealEstimateNumber) {
            init2[pIndex] = this.relativeMagneticPermeabilities[0][this.magneticPermRealEstimateIndices[pIndex]].getReal();
            start[pIndex] = init2[pIndex];
            step2[pIndex] = init2[pIndex] * 0.1;
            if (step2[pIndex] == 0.0) {
                step2[pIndex] = 0.1;
            }
            ++pIndex;
            ++i;
        }
        i = 0;
        while (i < this.magneticPermImagEstimateNumber) {
            init2[pIndex] = this.relativeMagneticPermeabilities[0][this.magneticPermImagEstimateIndices[pIndex]].getImag();
            start[pIndex] = init2[pIndex];
            step2[pIndex] = init2[pIndex] * 0.1;
            if (step2[pIndex] == 0.0) {
                step2[pIndex] = 0.1;
            }
            ++pIndex;
            ++i;
        }
        if (this.regressionOption == 3) {
            double[] evanFields = (double[])this.getEvanescentFields(this.fieldDistance);
            double calcFieldMean = 0.0;
            double explFieldMean = 0.0;
            int i2 = 0;
            while (i2 < this.numberOfDataPoints) {
                if (evanFields[i2] != 0.0) {
                    calcFieldMean += evanFields[i2];
                    explFieldMean += this.experimentalData[i2];
                }
                ++i2;
            }
            if (explFieldMean == 0.0) {
                throw new IllegalArgumentException("All entered field values are zero or sum to zero");
            }
            if (calcFieldMean == 0.0) {
                throw new IllegalArgumentException("All calculated field values are zero or sum to zero");
            }
            init2[pIndex] = explFieldMean / calcFieldMean;
            start[pIndex] = init2[pIndex];
            step2[pIndex] = init2[pIndex] * 0.1;
            if (step2[pIndex] == 0.0) {
                step2[pIndex] = 0.1;
            }
            ++pIndex;
        }
        double ftol = 1.0E-6;
        int nmax = 1000;
        regr.simplex(funct0, start, step2, ftol, nmax);
        double[] bestEstimates = regr.getCoeff();
        pIndex = 0;
        int i3 = 0;
        while (i3 < this.thicknessEstimateNumber) {
            this.thicknesses[this.thicknessEstimateIndices[pIndex]] = bestEstimates[pIndex];
            ++pIndex;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.refractIndexRealEstimateNumber) {
            this.refractiveIndices[0][this.refractIndexRealEstimateIndices[pIndex]].setReal(bestEstimates[pIndex]);
            ++pIndex;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.refractIndexImagEstimateNumber) {
            this.refractiveIndices[0][this.refractIndexImagEstimateIndices[pIndex]].setImag(bestEstimates[pIndex]);
            ++pIndex;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.magneticPermRealEstimateNumber) {
            this.relativeMagneticPermeabilities[0][this.magneticPermRealEstimateIndices[pIndex]].setReal(bestEstimates[pIndex]);
            ++pIndex;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.magneticPermImagEstimateNumber) {
            this.relativeMagneticPermeabilities[0][this.magneticPermImagEstimateIndices[pIndex]].setImag(bestEstimates[pIndex]);
            ++pIndex;
            ++i3;
        }
        if (this.regressionOption == 3) {
            this.fieldScalingFactor = bestEstimates[pIndex];
        }
        switch (this.regressionOption) {
            case 1: {
                this.calculatedData = (double[])this.getReflectivities();
                break;
            }
            case 2: {
                this.calculatedData = (double[])this.getTransmissivities();
                break;
            }
            case 3: {
                this.calculatedData = (double[])this.getEvanescentFields();
                i3 = 0;
                while (i3 < this.numberOfDataPoints) {
                    int n = i3++;
                    this.calculatedData[n] = this.calculatedData[n] * this.fieldScalingFactor;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Regresion option " + this.regressionOption + " does not exist");
            }
        }
    }

    public double[] getCalculatedData() {
        return this.calculatedData;
    }

    public void plotFit(String graphTitle2) {
        int numberOfCalculatedDataPoints = 200;
        double[][] data2 = PlotGraph.data(numberOfCalculatedDataPoints, 2);
        int i = 0;
        while (i < this.numberOfDataPoints) {
            data2[0][i] = this.incidentAngleDeg[i];
            data2[1][i] = this.experimentalData[i];
            ++i;
        }
        double angleIncrement = (this.incidentAngleDeg[this.numberOfIncidentAngles - 1] - this.incidentAngleDeg[0]) / (double)(numberOfCalculatedDataPoints - 1);
        data2[2][0] = this.incidentAngleDeg[0];
        int i2 = 1;
        while (i2 < numberOfCalculatedDataPoints - 1) {
            data2[2][i2] = data2[2][i2 - 1] + angleIncrement;
            ++i2;
        }
        data2[2][numberOfCalculatedDataPoints - 1] = this.incidentAngleDeg[this.numberOfIncidentAngles - 1];
        Reflectivity refl2 = new Reflectivity(this.numberOfLayers);
        if (this.mode.equals("mixed")) {
            refl2.setMode(this.eVectorAngleDeg);
        } else {
            refl2.setMode(this.mode);
        }
        refl2.setThicknesses(this.thicknesses);
        refl2.setRefractiveIndices(this.refractiveIndices);
        refl2.setRelativeMagneticPermeabilities(this.relativeMagneticPermeabilities);
        refl2.setIncidentAngle(data2[2]);
        String titleEnd = null;
        String yAxis = null;
        switch (this.regressionOption) {
            case 1: {
                data2[3] = (double[])refl2.getReflectivities();
                titleEnd = "Plot of reflectivities versus incident angle";
                yAxis = "Reflectivity";
                break;
            }
            case 2: {
                data2[3] = (double[])refl2.getTransmissivities();
                titleEnd = "Plot of transmissivities versus incident angle";
                yAxis = "Transmissivity";
                break;
            }
            case 3: {
                data2[3] = (double[])refl2.getEvanescentFields();
                int i3 = 0;
                while (i3 < numberOfCalculatedDataPoints) {
                    double[] dArray = data2[3];
                    int n = i3++;
                    dArray[n] = dArray[n] * this.fieldScalingFactor;
                }
                titleEnd = "Plot of evanescent fields versus incident angle";
                yAxis = "Evanescent Field";
                break;
            }
            default: {
                throw new IllegalArgumentException("Regresion option " + this.regressionOption + " does not exist");
            }
        }
        PlotGraph pg = new PlotGraph(data2);
        pg.setGraphTitle("Reflectivity class: " + titleEnd);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Incident angle");
        pg.setXaxisUnitsName("degrees");
        pg.setYaxisLegend(yAxis);
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] pointsOptions = nArray;
        pg.setPoint(pointsOptions);
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        int[] lineOptions = nArray2;
        pg.setLine(lineOptions);
        pg.plot();
    }
}

