/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.ErrorProp;
import flanagan.optics.PlanarWaveguide;
import flanagan.optics.RefractiveIndex;

public class PrismCoupler
extends PlanarWaveguide {
    private double[] thicknessesTE = null;
    private double[] anglesDegTE = null;
    private double[] anglesRadTE = null;
    private double[] errorsDegTE = null;
    private double[] errorsRadTE = null;
    private double[] modeNumbersTE = null;
    private double[] effectiveRefractiveIndicesTE = null;
    private double[] effectiveErrorsTE = null;
    private int numberOfTEmeasurementsPrism = 0;
    private boolean setMeasurementsTEprism = false;
    private boolean setTEerrors = false;
    private double[] thicknessesTM = null;
    private double[] anglesDegTM = null;
    private double[] anglesRadTM = null;
    private double[] errorsDegTM = null;
    private double[] errorsRadTM = null;
    private double[] modeNumbersTM = null;
    private double[] effectiveRefractiveIndicesTM = null;
    private double[] effectiveErrorsTM = null;
    private int numberOfTMmeasurementsPrism = 0;
    private boolean setMeasurementsTMprism = false;
    private boolean setTMerrors = false;
    private int numberOfMeasurementsPrism = 0;
    private boolean setMeasurementsPrism = false;
    private boolean setPrismRI = false;
    private double prismAngleAlphaDeg = 0.0;
    private double prismAngleAlphaRad = 0.0;
    private boolean setPrismAlpha = false;

    public void setPrismRefractiveIndex(double refInd) {
        this.prismRefractiveIndex = refInd;
        this.prismRefractiveIndex2 = refInd * refInd;
        this.setPrismRI = true;
        if (this.setMeasurementsPrism && this.setPrismAlpha) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setPrismAngleAlpha(double angle) {
        this.prismAngleAlphaDeg = angle;
        this.prismAngleAlphaRad = Math.toRadians(angle);
        this.setPrismAlpha = true;
        if (this.setMeasurementsPrism && this.setPrismRI) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setPrismToWaveguideGap(double gap) {
        this.prismToWaveguideGap = gap;
        this.setPrismToWaveguideGap = true;
    }

    @Override
    public void enterTEmodeData(double thickness, double angle, double modeNumber) {
        if (this.setMeasurementsTEprism) {
            if (this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsPrism + 1;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.thicknessesTE[i];
                ++i;
            }
            hold[this.numberOfTEmeasurementsPrism] = thickness;
            this.thicknessesTE = hold;
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.anglesDegTE[i];
                ++i;
            }
            hold[this.numberOfTEmeasurementsPrism] = angle;
            this.anglesDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsDegTE = hold;
            this.errorsRadTE = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsDegTE[i] = 0.0;
                this.errorsRadTE[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.modeNumbersTE[i];
                ++i;
            }
            hold[this.numberOfTEmeasurementsPrism] = modeNumber;
            this.numberOfTEmeasurementsPrism = nNew;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = thickness;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = angle;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(angle);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = 0.0;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = 0.0;
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = modeNumber;
            this.numberOfTEmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismAlpha) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double thickness, double angle, double modeNumber) {
        if (this.setMeasurementsTMprism) {
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsPrism + 1;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.thicknessesTM[i];
                ++i;
            }
            hold[this.numberOfTMmeasurementsPrism] = thickness;
            this.thicknessesTM = hold;
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.anglesDegTM[i];
                ++i;
            }
            hold[this.numberOfTMmeasurementsPrism] = angle;
            this.anglesDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsDegTM = hold;
            this.errorsRadTM = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsDegTM[i] = 0.0;
                this.errorsRadTM[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.modeNumbersTM[i];
                ++i;
            }
            hold[this.numberOfTMmeasurementsPrism] = modeNumber;
            this.numberOfTMmeasurementsPrism = nNew;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = thickness;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = angle;
            this.anglesRadTM = new double[1];
            this.anglesRadTM[0] = Math.toRadians(angle);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = 0.0;
            this.errorsRadTM = new double[1];
            this.errorsRadTM[0] = 0.0;
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = modeNumber;
            this.numberOfTMmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] thicknesses, double[] angles, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTEprism) {
            if (this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsPrism + o;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.thicknessesTE[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTEmeasurementsPrism + i] = thicknesses[i];
                ++i;
            }
            this.thicknessesTE = hold;
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.anglesDegTE[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTEmeasurementsPrism + i] = angles[i];
                ++i;
            }
            this.anglesDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsDegTE = hold;
            this.errorsRadTE = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsDegTE[i] = 0.0;
                this.errorsRadTE[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.modeNumbersTE[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTEmeasurementsPrism + i] = modeNumbers[i];
                ++i;
            }
            this.numberOfTEmeasurementsPrism = nNew;
        } else {
            this.numberOfTEmeasurementsPrism = o;
            this.thicknessesTE = thicknesses;
            this.anglesDegTE = angles;
            this.anglesRadTE = new double[o];
            this.errorsDegTE = new double[o];
            this.errorsRadTE = new double[o];
            int i = 0;
            while (i < o) {
                this.anglesRadTE[i] = Math.toRadians(angles[i]);
                this.errorsDegTE[i] = 0.0;
                this.errorsRadTE[i] = 0.0;
                ++i;
            }
            this.modeNumbersTE = modeNumbers;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] thicknesses, double[] angles, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTMprism) {
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsPrism + o;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.thicknessesTM[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTMmeasurementsPrism + i] = thicknesses[i];
                ++i;
            }
            this.thicknessesTM = hold;
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.anglesDegTM[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTMmeasurementsPrism + i] = angles[i];
                ++i;
            }
            this.anglesDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsDegTM = hold;
            this.errorsRadTM = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsDegTM[i] = 0.0;
                this.errorsRadTM[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.modeNumbersTM[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTMmeasurementsPrism + i] = modeNumbers[i];
                ++i;
            }
            this.numberOfTMmeasurementsPrism = nNew;
        } else {
            this.numberOfTMmeasurementsPrism = o;
            this.thicknessesTM = thicknesses;
            this.anglesDegTM = angles;
            this.anglesRadTM = new double[o];
            this.errorsDegTM = new double[o];
            this.errorsRadTM = new double[o];
            int i = 0;
            while (i < o) {
                this.anglesRadTM[i] = Math.toRadians(angles[i]);
                this.errorsDegTM[i] = 0.0;
                this.errorsRadTM[i] = 0.0;
                ++i;
            }
            this.modeNumbersTM = modeNumbers;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double thickness, double angle, double error, double modeNumber) {
        if (this.setMeasurementsTEprism) {
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsPrism + 1;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.thicknessesTE[i];
                ++i;
            }
            hold[this.numberOfTEmeasurementsPrism] = thickness;
            this.thicknessesTE = hold;
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.anglesDegTE[i];
                ++i;
            }
            hold[this.numberOfTEmeasurementsPrism] = angle;
            this.anglesDegTE = hold;
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.errorsDegTE[i];
                ++i;
            }
            hold[this.numberOfTEmeasurementsPrism] = error;
            this.errorsDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsRadTE = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsRadTE[i] = Math.toRadians(this.errorsDegTE[i]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.modeNumbersTE[i];
                ++i;
            }
            hold[this.numberOfTEmeasurementsPrism] = modeNumber;
            this.numberOfTEmeasurementsPrism = nNew;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = thickness;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = angle;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(angle);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = error;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = Math.toRadians(error);
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = modeNumber;
            this.numberOfTEmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setTEerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double thickness, double angle, double error, double modeNumber) {
        if (this.setMeasurementsTMprism) {
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsPrism + 1;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.thicknessesTM[i];
                ++i;
            }
            hold[this.numberOfTMmeasurementsPrism] = thickness;
            this.thicknessesTM = hold;
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.anglesDegTM[i];
                ++i;
            }
            hold[this.numberOfTMmeasurementsPrism] = angle;
            this.anglesDegTM = hold;
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.errorsDegTM[i];
                ++i;
            }
            hold[this.numberOfTMmeasurementsPrism] = error;
            this.errorsDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsRadTM = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsRadTM[i] = Math.toRadians(this.errorsDegTM[i]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.modeNumbersTM[i];
                ++i;
            }
            hold[this.numberOfTMmeasurementsPrism] = modeNumber;
            this.numberOfTMmeasurementsPrism = nNew;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = thickness;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = angle;
            this.anglesRadTM = new double[1];
            this.anglesDegTM[0] = Math.toRadians(angle);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = error;
            this.errorsRadTM = new double[1];
            this.errorsDegTM[0] = Math.toRadians(error);
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = modeNumber;
            this.numberOfTMmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setTMerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] thicknesses, double[] angles, double[] errors, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTEprism) {
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsPrism + o;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.thicknessesTE[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTEmeasurementsPrism + i] = thicknesses[i];
                ++i;
            }
            this.thicknessesTE = hold;
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.anglesDegTE[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTEmeasurementsPrism + i] = angles[i];
                ++i;
            }
            this.anglesDegTE = hold;
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.errorsDegTE[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTEmeasurementsPrism + i] = errors[i];
                ++i;
            }
            this.errorsDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsRadTE = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsRadTE[i] = Math.toRadians(this.errorsDegTE[i]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                hold[i] = this.modeNumbersTE[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTEmeasurementsPrism + i] = modeNumbers[i];
                ++i;
            }
            this.numberOfTEmeasurementsPrism = nNew;
        } else {
            this.numberOfTEmeasurementsPrism = o;
            this.thicknessesTE = thicknesses;
            this.anglesDegTE = angles;
            this.anglesRadTE = new double[o];
            this.errorsDegTE = errors;
            this.errorsRadTE = new double[o];
            int i = 0;
            while (i < o) {
                this.anglesRadTE[i] = Math.toRadians(angles[i]);
                this.errorsRadTE[i] = Math.toRadians(errors[i]);
                ++i;
            }
            this.modeNumbersTE = modeNumbers;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setTEerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] thicknesses, double[] angles, double[] errors, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTMprism) {
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsPrism + o;
            double[] hold = new double[nNew];
            int i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.thicknessesTM[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTMmeasurementsPrism + i] = thicknesses[i];
                ++i;
            }
            this.thicknessesTM = hold;
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.anglesDegTM[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTMmeasurementsPrism + i] = angles[i];
                ++i;
            }
            this.anglesDegTM = hold;
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.errorsDegTM[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTMmeasurementsPrism + i] = errors[i];
                ++i;
            }
            this.errorsDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsRadTM = hold;
            i = 0;
            while (i < nNew) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsRadTM[i] = Math.toRadians(this.errorsDegTM[i]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                hold[i] = this.modeNumbersTM[i];
                ++i;
            }
            i = 0;
            while (i < o) {
                hold[this.numberOfTMmeasurementsPrism + i] = modeNumbers[i];
                ++i;
            }
            this.numberOfTMmeasurementsPrism = nNew;
        } else {
            this.numberOfTMmeasurementsPrism = o;
            this.thicknessesTM = thicknesses;
            this.anglesDegTM = angles;
            this.errorsDegTM = errors;
            this.anglesRadTM = new double[o];
            this.errorsRadTM = new double[o];
            int i = 0;
            while (i < o) {
                this.anglesRadTM[i] = Math.toRadians(angles[i]);
                this.errorsRadTM[i] = Math.toRadians(errors[i]);
                ++i;
            }
            this.modeNumbersTM = modeNumbers;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setTMerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void clearData() {
        this.numberOfTEmeasurementsPrism = 0;
        this.setMeasurementsTEprism = false;
        this.numberOfTMmeasurementsPrism = 0;
        this.setMeasurementsTMprism = false;
        this.numberOfMeasurements = 0;
        this.setMeasurements = false;
        this.setWeights = false;
        this.numberOfTEmeasurements = 0;
        this.setMeasurementsTE = false;
        this.numberOfTMmeasurements = 0;
        this.setMeasurementsTM = false;
    }

    public void calcEffectiveRefractiveIndices() {
        if (this.setMeasurementsTEprism) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
        if (this.setMeasurementsTMprism) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    public void calcTEmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTE = new double[this.numberOfTEmeasurementsPrism];
        this.effectiveErrorsTE = new double[this.numberOfTEmeasurementsPrism];
        if (this.setTEerrors) {
            ErrorProp alpha = new ErrorProp(this.prismAngleAlphaRad, 0.0);
            ErrorProp prismRI = new ErrorProp(this.prismRefractiveIndex, 0.0);
            ErrorProp airRI = new ErrorProp(RefractiveIndex.air(this.wavelength), 0.0);
            ErrorProp phi = new ErrorProp();
            ErrorProp angle = new ErrorProp();
            int i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                angle.reset(this.anglesRadTE[i], this.errorsRadTE[i]);
                phi = angle.over(prismRI).times(airRI);
                phi = ErrorProp.asin(phi);
                phi = alpha.plus(phi);
                phi = prismRI.times(ErrorProp.sin(phi));
                this.effectiveRefractiveIndicesTE[i] = phi.getValue();
                this.effectiveErrorsTE[i] = phi.getError();
                ++i;
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.effectiveErrorsTE, this.modeNumbersTE);
        } else {
            int i = 0;
            while (i < this.numberOfTEmeasurementsPrism) {
                double phi = this.prismAngleAlphaRad + Math.asin(RefractiveIndex.air(this.wavelength) * this.anglesRadTE[i] / this.prismRefractiveIndex);
                this.effectiveRefractiveIndicesTE[i] = this.prismRefractiveIndex * Math.sin(phi);
                ++i;
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.modeNumbersTE);
        }
    }

    public void calcTMmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTM = new double[this.numberOfTMmeasurementsPrism];
        this.effectiveErrorsTM = new double[this.numberOfTMmeasurementsPrism];
        if (this.setTMerrors) {
            ErrorProp alpha = new ErrorProp(this.prismAngleAlphaRad, 0.0);
            ErrorProp prismRI = new ErrorProp(this.prismRefractiveIndex, 0.0);
            ErrorProp airRI = new ErrorProp(RefractiveIndex.air(this.wavelength), 0.0);
            ErrorProp phi = new ErrorProp();
            ErrorProp angle = new ErrorProp();
            int i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                angle.reset(this.anglesRadTM[i], this.errorsRadTM[i]);
                phi = angle.over(prismRI).times(airRI);
                phi = ErrorProp.asin(phi);
                phi = alpha.plus(phi);
                phi = prismRI.times(ErrorProp.sin(phi));
                this.effectiveRefractiveIndicesTM[i] = phi.getValue();
                this.effectiveErrorsTM[i] = phi.getError();
                ++i;
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.effectiveErrorsTM, this.modeNumbersTM);
        } else {
            int i = 0;
            while (i < this.numberOfTMmeasurementsPrism) {
                double phi = this.prismAngleAlphaRad + Math.asin(RefractiveIndex.air(this.wavelength) * this.anglesRadTM[i] / this.prismRefractiveIndex);
                this.effectiveRefractiveIndicesTM[i] = this.prismRefractiveIndex * Math.sin(phi);
                ++i;
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.modeNumbersTM);
        }
    }
}

