/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class Polynomial {
    private int deg = 0;
    private int degwz = 0;
    private double[] coeff;
    private double[] coeffwz;
    private boolean suppressRootsErrorMessages = false;

    public Polynomial(int n) {
        this.deg = n;
        this.coeff = new double[n + 1];
    }

    public Polynomial(double[] aa) {
        this.deg = aa.length - 1;
        this.coeff = new double[this.deg + 1];
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i] = aa[i];
            ++i;
        }
    }

    public Polynomial(float[] aa) {
        this.deg = aa.length - 1;
        this.coeff = new double[this.deg + 1];
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i] = aa[i];
            ++i;
        }
    }

    public Polynomial(long[] aa) {
        this.deg = aa.length - 1;
        this.coeff = new double[this.deg + 1];
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i] = aa[i];
            ++i;
        }
    }

    public Polynomial(int[] aa) {
        this.deg = aa.length - 1;
        this.coeff = new double[this.deg + 1];
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i] = aa[i];
            ++i;
        }
    }

    public Polynomial(ArrayList<Object> aa) {
        this.deg = aa.size() - 1;
        this.coeff = new double[this.deg + 1];
        int i = 0;
        while (i <= this.deg) {
            int code = this.getTypeCode(aa.get(i));
            switch (code) {
                case 1: {
                    this.coeff[i] = ((Byte)aa.get(i)).byteValue();
                    break;
                }
                case 2: {
                    this.coeff[i] = ((Short)aa.get(i)).shortValue();
                    break;
                }
                case 3: {
                    this.coeff[i] = ((Integer)aa.get(i)).intValue();
                    break;
                }
                case 4: {
                    this.coeff[i] = ((Long)aa.get(i)).longValue();
                    break;
                }
                case 5: {
                    this.coeff[i] = ((Float)aa.get(i)).floatValue();
                    break;
                }
                case 6: {
                    this.coeff[i] = (Double)aa.get(i);
                    break;
                }
                case 7: {
                    this.coeff[i] = ((BigInteger)aa.get(i)).doubleValue();
                    break;
                }
                case 8: {
                    this.coeff[i] = ((BigDecimal)aa.get(i)).doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + code + ", not recognised");
                }
            }
            ++i;
        }
    }

    private int getTypeCode(Object obj) {
        int code = 0;
        if (obj instanceof Byte) {
            code = 1;
        } else if (obj instanceof Short) {
            code = 2;
        } else if (obj instanceof Integer) {
            code = 3;
        } else if (obj instanceof Long) {
            code = 4;
        } else if (obj instanceof Float) {
            code = 5;
        } else if (obj instanceof Double) {
            code = 6;
        } else if (obj instanceof BigInteger) {
            code = 7;
        } else if (obj instanceof BigDecimal) {
            code = 8;
        }
        return code;
    }

    public Polynomial(double aa) {
        this.deg = 0;
        this.coeff = new double[1];
        this.coeff[0] = aa;
    }

    public Polynomial(double aa, double bb) {
        this.deg = 1;
        this.coeff = new double[2];
        this.coeff[0] = aa;
        this.coeff[1] = bb;
    }

    public Polynomial(double aa, double bb, double cc) {
        this.deg = 2;
        this.coeff = new double[3];
        this.coeff[0] = aa;
        this.coeff[1] = bb;
        this.coeff[2] = cc;
    }

    public Polynomial(double aa, double bb, double cc, double dd) {
        this.deg = 3;
        this.coeff = new double[4];
        this.coeff[0] = aa;
        this.coeff[1] = bb;
        this.coeff[2] = cc;
        this.coeff[3] = dd;
    }

    public static Polynomial rootsToPoly(double[] roots) {
        if (roots == null) {
            return null;
        }
        int pdeg = roots.length;
        double[] rootCoeff = new double[]{-roots[0], 1.0};
        Polynomial rPoly = new Polynomial(rootCoeff);
        int i = 1;
        while (i < pdeg) {
            rootCoeff[0] = -roots[i];
            Polynomial cRoot = new Polynomial(rootCoeff);
            rPoly = rPoly.times(cRoot);
            ++i;
        }
        return rPoly;
    }

    public void resetPoly(double[] aa) {
        if (this.deg + 1 != aa.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        int i = 0;
        while (i < this.deg) {
            this.coeff[i] = aa[i];
            ++i;
        }
    }

    public void resetPoly(ArrayList<Object> aa) {
        if (this.deg + 1 != aa.size()) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        int i = 0;
        while (i <= this.deg) {
            int code = this.getTypeCode(aa.get(i));
            switch (code) {
                case 1: {
                    this.coeff[i] = ((Byte)aa.get(i)).byteValue();
                    break;
                }
                case 2: {
                    this.coeff[i] = ((Short)aa.get(i)).shortValue();
                    break;
                }
                case 3: {
                    this.coeff[i] = ((Integer)aa.get(i)).intValue();
                    break;
                }
                case 4: {
                    this.coeff[i] = ((Long)aa.get(i)).longValue();
                    break;
                }
                case 5: {
                    this.coeff[i] = ((Float)aa.get(i)).floatValue();
                    break;
                }
                case 6: {
                    this.coeff[i] = (Double)aa.get(i);
                    break;
                }
                case 7: {
                    this.coeff[i] = ((BigInteger)aa.get(i)).doubleValue();
                    break;
                }
                case 8: {
                    this.coeff[i] = ((BigDecimal)aa.get(i)).doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + code + ", not recognised");
                }
            }
            ++i;
        }
    }

    public void resetCoeff(int i, double aa) {
        this.coeff[i] = aa;
    }

    public Polynomial copy() {
        if (this == null) {
            return null;
        }
        Polynomial aa = new Polynomial(this.deg);
        int i = 0;
        while (i <= this.deg) {
            aa.coeff[i] = this.coeff[i];
            ++i;
        }
        aa.deg = this.deg;
        aa.degwz = this.degwz;
        aa.coeffwz = Conv.copy(this.coeffwz);
        return aa;
    }

    public static Polynomial copy(Polynomial bb) {
        if (bb == null) {
            return null;
        }
        Polynomial aa = new Polynomial(bb.deg);
        int i = 0;
        while (i <= bb.deg) {
            aa.coeff[i] = bb.coeff[i];
            ++i;
        }
        aa.deg = bb.deg;
        aa.degwz = bb.degwz;
        aa.coeffwz = Conv.copy(bb.coeffwz);
        return aa;
    }

    public Object clone() {
        return this.copy();
    }

    public double[] coefficientsCopy() {
        double[] aa = new double[this.deg + 1];
        int i = 0;
        while (i <= this.deg) {
            aa[i] = this.coeff[i];
            ++i;
        }
        return aa;
    }

    public double[] coefficientsReference() {
        return this.coeff;
    }

    public double getCoefficient(int i) {
        return this.coeff[i];
    }

    public int getDeg() {
        return this.deg;
    }

    public String toString() {
        String ss = "";
        ss = String.valueOf(ss) + this.coeff[0];
        if (this.deg > 0) {
            ss = String.valueOf(ss) + " + (" + this.coeff[1] + ").x";
        }
        int i = 2;
        while (i <= this.deg) {
            ss = String.valueOf(ss) + " + (" + this.coeff[i] + ").x^" + i;
            ++i;
        }
        return ss;
    }

    public ComplexPoly toComplexPoly() {
        ComplexPoly cp = new ComplexPoly(this);
        return cp;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void printToText(String title) {
        title = String.valueOf(title) + ".txt";
        FileOutput fout = new FileOutput(title, 'n');
        fout.println("Output File for a Polynomial");
        fout.dateAndTimeln();
        fout.println();
        fout.print("Polynomial degree is ");
        fout.println(this.deg);
        fout.println();
        fout.println("The coefficients are ");
        int i = 0;
        while (i <= this.deg) {
            fout.println(this.coeff[i]);
            ++i;
        }
        fout.println();
        fout.println("End of file.");
        fout.close();
    }

    public void printToText() {
        String title = "PolynomialOut";
        this.printToText(title);
    }

    public ArrayList<ComplexPoly> sTransform() {
        return Polynomial.sTransform(this.coeff);
    }

    public static ArrayList<ComplexPoly> sTransform(Polynomial poly) {
        return Polynomial.sTransform(poly.coefficientsCopy());
    }

    public static ArrayList<ComplexPoly> sTransform(double[] coeff) {
        int n = coeff.length;
        ComplexPoly[] sNum = new ComplexPoly[n];
        ComplexPoly[] sDen = new ComplexPoly[n];
        ComplexPoly sNumer = null;
        ComplexPoly sDenom = new ComplexPoly(Complex.plusOne());
        int i = 0;
        while (i < n) {
            sNum[i] = new ComplexPoly(new Complex(coeff[i] * (double)Fmath.factorial(i), 0.0));
            sDen[i] = new ComplexPoly(i + 1);
            sDen[i].resetCoeff(i + 1, Complex.plusOne());
            ++i;
        }
        sDenom = sDen[n - 1];
        i = 0;
        while (i < n - 1) {
            sNum[i] = sNum[i].times(sDen[n - i - 2]);
            ++i;
        }
        sNumer = sNum[0];
        i = 1;
        while (i < n) {
            sNumer = sNumer.plus(sNum[i]);
            ++i;
        }
        ArrayList<ComplexPoly> al = new ArrayList<ComplexPoly>();
        al.add(sNumer);
        al.add(sDenom);
        return al;
    }

    public boolean equals(Polynomial cp) {
        return this.isEqual(cp);
    }

    public boolean isEqual(Polynomial cp) {
        int nDegCp;
        boolean ret = false;
        int nDegThis = this.getDeg();
        if (nDegThis == (nDegCp = cp.getDeg())) {
            boolean test2 = true;
            int i = 0;
            while (test2) {
                if (this.coeff[i] != cp.getCoefficient(i)) {
                    test2 = false;
                    continue;
                }
                if (++i <= nDegCp) continue;
                test2 = false;
                ret = true;
            }
        }
        return ret;
    }

    public static boolean isEqual(Polynomial cp1, Polynomial cp2) {
        int nDegCp2;
        boolean ret = false;
        int nDegCp1 = cp1.getDeg();
        if (nDegCp1 == (nDegCp2 = cp2.getDeg())) {
            boolean test2 = true;
            int i = 0;
            while (test2) {
                if (cp1.getCoefficient(i) != cp2.getCoefficient(i)) {
                    test2 = false;
                    continue;
                }
                if (++i <= nDegCp1) continue;
                test2 = false;
                ret = true;
            }
        }
        return ret;
    }

    public Polynomial plus(Polynomial b) {
        Polynomial c = null;
        if (b.deg <= this.deg) {
            c = new Polynomial(this.deg);
            int i = b.deg + 1;
            while (i <= this.deg) {
                c.coeff[i] = this.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = this.coeff[i] + b.coeff[i];
                ++i;
            }
        } else {
            c = new Polynomial(b.deg);
            int i = this.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = b.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= this.deg) {
                c.coeff[i] = this.coeff[i] + b.coeff[i];
                ++i;
            }
        }
        return c;
    }

    public static Polynomial plus(Polynomial a, Polynomial b) {
        Polynomial c = null;
        if (b.deg <= a.deg) {
            c = new Polynomial(a.deg);
            int i = b.deg + 1;
            while (i <= a.deg) {
                c.coeff[i] = a.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = a.coeff[i] + b.coeff[i];
                ++i;
            }
        } else {
            c = new Polynomial(b.deg);
            int i = a.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = b.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= a.deg) {
                c.coeff[i] = a.coeff[i] + b.coeff[i];
                ++i;
            }
        }
        return c;
    }

    public Polynomial plus(double bb) {
        Polynomial b = new Polynomial(bb);
        return this.plus(b);
    }

    public static Polynomial plus(Polynomial a, double bb) {
        Polynomial b = new Polynomial(bb);
        return Polynomial.plus(a, b);
    }

    public Polynomial plus(int bb) {
        Polynomial b = new Polynomial((double)bb);
        return this.plus(b);
    }

    public static Polynomial plus(Polynomial a, int bb) {
        Polynomial b = new Polynomial((double)bb);
        return Polynomial.plus(a, b);
    }

    public Polynomial minus(Polynomial b) {
        Polynomial c = null;
        if (b.deg <= this.deg) {
            c = new Polynomial(this.deg);
            int i = b.deg + 1;
            while (i <= this.deg) {
                c.coeff[i] = this.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = this.coeff[i] - b.coeff[i];
                ++i;
            }
        } else {
            c = new Polynomial(b.deg);
            int i = this.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = -b.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= this.deg) {
                c.coeff[i] = this.coeff[i] - b.coeff[i];
                ++i;
            }
        }
        return c;
    }

    public Polynomial minus(double bb) {
        Polynomial b = new Polynomial(bb);
        return this.minus(b);
    }

    public Polynomial minus(int bb) {
        Polynomial b = new Polynomial((double)bb);
        return this.minus(b);
    }

    public static Polynomial minus(Polynomial a, Polynomial b) {
        Polynomial c = null;
        if (b.deg <= a.deg) {
            c = new Polynomial(a.deg);
            int i = b.deg + 1;
            while (i <= a.deg) {
                c.coeff[i] = a.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = a.coeff[i] - b.coeff[i];
                ++i;
            }
        } else {
            c = new Polynomial(b.deg);
            int i = a.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = -b.coeff[i];
                ++i;
            }
            i = 0;
            while (i <= a.deg) {
                c.coeff[i] = a.coeff[i] - b.coeff[i];
                ++i;
            }
        }
        return c;
    }

    public static Polynomial minus(Polynomial a, double bb) {
        Polynomial b = new Polynomial(bb);
        return Polynomial.minus(a, b);
    }

    public static Polynomial minus(Polynomial a, int bb) {
        Polynomial b = new Polynomial((double)bb);
        return Polynomial.minus(a, b);
    }

    public Polynomial times(Polynomial b) {
        int n = this.deg + b.deg;
        Polynomial c = new Polynomial(n);
        int i = 0;
        while (i <= this.deg) {
            int j = 0;
            while (j <= b.deg) {
                int n2 = i + j;
                c.coeff[n2] = c.coeff[n2] + this.coeff[i] * b.coeff[j];
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static Polynomial times(Polynomial a, Polynomial b) {
        int n = a.deg + b.deg;
        Polynomial c = new Polynomial(n);
        int i = 0;
        while (i <= a.deg) {
            int j = 0;
            while (j <= b.deg) {
                int n2 = i + j;
                c.coeff[n2] = c.coeff[n2] + a.coeff[i] * b.coeff[j];
                ++j;
            }
            ++i;
        }
        return c;
    }

    public Polynomial times(double bb) {
        Polynomial c = new Polynomial(this.deg);
        int i = 0;
        while (i <= this.deg) {
            c.coeff[i] = this.coeff[i] * bb;
            ++i;
        }
        return c;
    }

    public static Polynomial times(Polynomial a, double bb) {
        Polynomial c = new Polynomial(a.deg);
        int i = 0;
        while (i <= a.deg) {
            c.coeff[i] = a.coeff[i] * bb;
            ++i;
        }
        return c;
    }

    public Polynomial times(int bb) {
        Polynomial c = new Polynomial(this.deg);
        int i = 0;
        while (i <= this.deg) {
            c.coeff[i] = this.coeff[i] * (double)bb;
            ++i;
        }
        return c;
    }

    public static Polynomial times(Polynomial a, int bb) {
        Polynomial c = new Polynomial(a.deg);
        int i = 0;
        while (i <= a.deg) {
            c.coeff[i] = a.coeff[i] * (double)bb;
            ++i;
        }
        return c;
    }

    public Polynomial nthDerivative(int n) {
        Polynomial dnydxn;
        if (n > this.deg) {
            dnydxn = new Polynomial(0.0);
        } else {
            dnydxn = new Polynomial(this.deg - n);
            double[] nc = new double[this.deg - n + 1];
            int k = this.deg - n;
            int i = this.deg;
            while (i > n - 1) {
                nc[k] = this.coeff[i];
                int j = 0;
                while (j < n) {
                    nc[k] = nc[k] * (double)(i - j);
                    ++j;
                }
                --k;
                --i;
            }
            dnydxn = new Polynomial(nc);
        }
        return dnydxn;
    }

    public double evaluate(double x2) {
        double y = 0.0;
        if (this.deg == 0) {
            y = this.coeff[0];
        } else {
            y = this.coeff[this.deg];
            int i = this.deg - 1;
            while (i >= 0) {
                y = y * x2 + this.coeff[i];
                --i;
            }
        }
        return y;
    }

    public double nthDerivEvaluate(int n, double x2) {
        double dnydxn = 0.0;
        double[] nc = new double[this.deg + 1];
        if (n == 0) {
            dnydxn = this.evaluate(x2);
            System.out.println("n = 0 in Polynomial.nthDerivative");
            System.out.println("polynomial itself evaluated and returned");
        } else {
            Polynomial nthderiv = this.nthDerivative(n);
            dnydxn = nthderiv.evaluate(x2);
        }
        return dnydxn;
    }

    public Complex[] roots() {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.roots();
    }

    public Complex[] rootsNoMessages() {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.rootsNoMessages();
    }

    public Complex[] roots(boolean polish) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.roots(polish);
    }

    public Complex[] roots(double estx) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.roots(new Complex(estx, 0.0));
    }

    public Complex[] roots(Complex estx) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.roots(estx);
    }

    public Complex[] roots(boolean polish, double estx) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.roots(new Complex(estx, 0.0));
    }

    public static Complex[] quadratic(double c, double b, double a) {
        return ComplexPoly.quadratic(new Complex(c, 0.0), new Complex(b, 0.0), new Complex(a, 0.0));
    }

    public static Complex[] cubic(double aa, double bb, double cc, double dd) {
        return ComplexPoly.cubic(new Complex(aa, 0.0), new Complex(bb, 0.0), new Complex(cc, 0.0), new Complex(dd, 0.0));
    }

    public static Complex laguerre(double estx, double[] pcoeff, int m) {
        ArrayMaths am = new ArrayMaths(pcoeff);
        return ComplexPoly.laguerre(new Complex(estx, 0.0), am.array_as_Complex(), m);
    }

    public static Complex laguerre(Complex estx, double[] pcoeff, int m) {
        ArrayMaths am = new ArrayMaths(pcoeff);
        return ComplexPoly.laguerre(estx, am.array_as_Complex(), m);
    }

    public Complex[] laguerreAll() {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.laguerreAll();
    }

    public Complex[] laguerreAll(double estx) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.laguerreAll(new Complex(estx, 0.0));
    }

    public Complex[] laguerreAll(Complex estx) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.laguerreAll(estx);
    }

    public Complex[] laguerreAll(boolean polish) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.laguerreAll(polish);
    }

    public Complex[] laguerreAll(boolean polish, double estx) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.laguerreAll(polish, new Complex(estx, 0.0));
    }

    public Complex[] laguerreAll(boolean polish, Complex estx) {
        ComplexPoly cp = new ComplexPoly(this);
        return cp.laguerreAll(polish, estx);
    }
}

