/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.math.ArrayMaths;
import flanagan.math.VectorMaths;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Point {
    private double[] point = null;
    private int nDimensions = 0;

    public Point() {
        this.point = new double[3];
        this.point[0] = 0.0;
        this.point[1] = 0.0;
        this.point[2] = 0.0;
        this.nDimensions = 3;
    }

    public Point(double[] coordinates) {
        this.setPoint(coordinates);
    }

    public Point(float[] coordinates) {
        this.setPoint(coordinates);
    }

    public Point(long[] coordinates) {
        this.setPoint(coordinates);
    }

    public Point(int[] coordinates) {
        this.setPoint(coordinates);
    }

    public Point(short[] coordinates) {
        this.setPoint(coordinates);
    }

    public Point(BigDecimal[] coordinates) {
        this.setPoint(coordinates);
    }

    public Point(BigInteger[] coordinates) {
        this.setPoint(coordinates);
    }

    public Point(double xPoint) {
        this.point = new double[1];
        this.point[0] = xPoint;
        this.nDimensions = 1;
    }

    public Point(double xPoint, double yPoint) {
        this.point = new double[2];
        this.point[0] = xPoint;
        this.point[1] = yPoint;
        this.nDimensions = 2;
    }

    public Point(double xPoint, double yPoint, double zPoint) {
        this.point = new double[3];
        this.point[0] = xPoint;
        this.point[1] = yPoint;
        this.point[2] = zPoint;
        this.nDimensions = 3;
    }

    public final void setPoint(double[] coordinates) {
        this.point = (double[])coordinates.clone();
        this.nDimensions = this.point.length;
    }

    public final void setPoint(float[] coordinates) {
        this.nDimensions = coordinates.length;
        ArrayMaths am = new ArrayMaths(coordinates);
        this.point = am.array_as_double();
    }

    public final void setPoint(long[] coordinates) {
        this.nDimensions = coordinates.length;
        ArrayMaths am = new ArrayMaths(coordinates);
        this.point = am.array_as_double();
    }

    public final void setPoint(int[] coordinates) {
        this.nDimensions = coordinates.length;
        ArrayMaths am = new ArrayMaths(coordinates);
        this.point = am.array_as_double();
    }

    public final void setPoint(short[] coordinates) {
        this.nDimensions = coordinates.length;
        ArrayMaths am = new ArrayMaths(coordinates);
        this.point = am.array_as_double();
    }

    public final void setPoint(BigDecimal[] coordinates) {
        this.nDimensions = coordinates.length;
        ArrayMaths am = new ArrayMaths(coordinates);
        this.point = am.array_as_double();
    }

    public final void setPoint(BigInteger[] coordinates) {
        this.nDimensions = coordinates.length;
        ArrayMaths am = new ArrayMaths(coordinates);
        this.point = am.array_as_double();
    }

    public void setPoint(double xPoint) {
        this.point = new double[1];
        this.point[0] = xPoint;
        this.nDimensions = 1;
    }

    public void setPoint(double xPoint, double yPoint) {
        this.point = new double[2];
        this.point[0] = xPoint;
        this.point[1] = yPoint;
        this.nDimensions = 2;
    }

    public void setPoint(double xPoint, double yPoint, double zPoint) {
        this.point = new double[3];
        this.point[0] = xPoint;
        this.point[1] = yPoint;
        this.point[2] = zPoint;
        this.nDimensions = 3;
    }

    public static Point[] oneDarray(int n) {
        Point[] pa = new Point[n];
        int i = 0;
        while (i < n) {
            pa[i] = new Point(0.0, 0.0, 0.0);
            ++i;
        }
        return pa;
    }

    public static Point[] oneDarray(double[] xx) {
        int n = xx.length;
        Point[] pa = new Point[n];
        int i = 0;
        while (i < n) {
            pa[i] = new Point(xx[i]);
            ++i;
        }
        return pa;
    }

    public static Point[] oneDarray(double[] xx, double[] yy) {
        int m = yy.length;
        int n = xx.length;
        if (m != n) {
            throw new IllegalArgumentException("the length of the xx array, " + n + ", and the lengh of the yy array, " + m + ", must be equal");
        }
        Point[] pa = new Point[n];
        int i = 0;
        while (i < n) {
            pa[i] = new Point(xx[i], yy[i]);
            ++i;
        }
        return pa;
    }

    public static Point[] oneDarray(double[] xx, double[] yy, double[] zz) {
        int n = xx.length;
        int m = yy.length;
        int l = zz.length;
        if (m != n) {
            throw new IllegalArgumentException("the length of the xx array, " + n + ", and the lengh of the yy array, " + m + ", must be equal");
        }
        if (n != l) {
            throw new IllegalArgumentException("the length of the xx array, " + n + ", and the lengh of the zz array, " + l + ", must be equal");
        }
        Point[] pa = new Point[n];
        int i = 0;
        while (i < n) {
            pa[i] = new Point(xx[i], yy[i], zz[i]);
            ++i;
        }
        return pa;
    }

    public static Point[] oneDarray(double[][] points) {
        int n = points.length;
        int m = points[0].length;
        int i = 1;
        while (i < n) {
            if (m != points[i].length) {
                throw new IllegalArgumentException("the dimesions of all the points must be identical");
            }
            ++i;
        }
        Point[] pa = new Point[n];
        double[] cc = new double[m];
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < m) {
                cc[j] = points[i2][j];
                ++j;
            }
            pa[i2] = new Point(cc);
            ++i2;
        }
        return pa;
    }

    public static Point[] oneDarray(float[][] points) {
        int n = points.length;
        int m = points[0].length;
        double[][] hold = new double[n][m];
        ArrayMaths am = null;
        int i = 0;
        while (i < n) {
            am = new ArrayMaths(points[i]);
            hold[i] = am.array_as_double();
            ++i;
        }
        return Point.oneDarray(hold);
    }

    public static Point[] oneDarray(long[][] points) {
        int n = points.length;
        int m = points[0].length;
        double[][] hold = new double[n][m];
        ArrayMaths am = null;
        int i = 0;
        while (i < n) {
            am = new ArrayMaths(points[i]);
            hold[i] = am.array_as_double();
            ++i;
        }
        return Point.oneDarray(hold);
    }

    public static Point[] oneDarray(int[][] points) {
        int n = points.length;
        int m = points[0].length;
        double[][] hold = new double[n][m];
        ArrayMaths am = null;
        int i = 0;
        while (i < n) {
            am = new ArrayMaths(points[i]);
            hold[i] = am.array_as_double();
            ++i;
        }
        return Point.oneDarray(hold);
    }

    public static Point[] oneDarray(short[][] points) {
        int n = points.length;
        int m = points[0].length;
        double[][] hold = new double[n][m];
        ArrayMaths am = null;
        int i = 0;
        while (i < n) {
            am = new ArrayMaths(points[i]);
            hold[i] = am.array_as_double();
            ++i;
        }
        return Point.oneDarray(hold);
    }

    public static Point[] oneDarray(BigDecimal[][] points) {
        int n = points.length;
        int m = points[0].length;
        double[][] hold = new double[n][m];
        ArrayMaths am = null;
        int i = 0;
        while (i < n) {
            am = new ArrayMaths(points[i]);
            hold[i] = am.array_as_double();
            ++i;
        }
        return Point.oneDarray(hold);
    }

    public static Point[] oneDarray(BigInteger[][] points) {
        int n = points.length;
        int m = points[0].length;
        double[][] hold = new double[n][m];
        ArrayMaths am = null;
        int i = 0;
        while (i < n) {
            am = new ArrayMaths(points[i]);
            hold[i] = am.array_as_double();
            ++i;
        }
        return Point.oneDarray(hold);
    }

    public double[] getPointCoordinates() {
        return (double[])this.point.clone();
    }

    public static double[][] getArrayCoordinates(Point[] array) {
        int n = array.length;
        int m = array[0].getPointDimensions();
        double[][] cc = new double[m][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                cc[j][i] = array[i].getPointCoordinates()[j];
                ++j;
            }
            ++i;
        }
        return cc;
    }

    public int getPointDimensions() {
        return this.nDimensions;
    }

    public static int[] getArrayDimensions(Point[] array) {
        int[] n = new int[]{array.length, array[0].getPointDimensions()};
        return n;
    }

    public double distanceSquared(Point p2) {
        int n2 = p2.nDimensions;
        if (n2 != this.nDimensions) {
            throw new IllegalArgumentException("The dimensions of the two points, " + this.nDimensions + " and " + n2 + ", should be equal");
        }
        if (n2 > 3) {
            System.out.println("Methods distance and distanceSquared are only meaningful for dimensions of 3 or less");
        }
        double hold = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < n2) {
            hold = this.point[i] - p2.point[i];
            sum2 += hold * hold;
            ++i;
        }
        return sum2;
    }

    public static double distanceSquared(Point p1, Point p2) {
        int n2 = p2.nDimensions;
        int n1 = p1.nDimensions;
        if (n2 != n1) {
            throw new IllegalArgumentException("The dimensions of the two points, " + n1 + " and " + n2 + ", should be equal");
        }
        if (n2 > 3) {
            System.out.println("Methods distance and distanceSquared are only meaningful for dimensions of 3 or less");
        }
        double hold = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < n2) {
            hold = p1.point[i] - p2.point[i];
            sum2 += hold * hold;
            ++i;
        }
        return sum2;
    }

    public double distance(Point p2) {
        double dist2 = this.distanceSquared(p2);
        return Math.sqrt(dist2);
    }

    public static double distance(Point p1, Point p2) {
        double dist2 = Point.distanceSquared(p1, p2);
        return Math.sqrt(dist2);
    }

    public static Point centre(Point[] pp) {
        int n = pp.length;
        int m = pp[0].nDimensions;
        int l = 0;
        int i = 1;
        while (i < n) {
            l = pp[i].nDimensions;
            if (l != m) {
                throw new IllegalArgumentException("All points must have the same number of dimensions");
            }
            ++i;
        }
        double[] cc = new double[m];
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < m) {
                int n2 = j;
                cc[n2] = cc[n2] + pp[i2].point[j];
                ++j;
            }
            ++i2;
        }
        int j = 0;
        while (j < m) {
            int n3 = j++;
            cc[n3] = cc[n3] / (double)n;
        }
        return new Point(cc);
    }

    public Point shift(double constant) {
        Point pp = new Point();
        int i = 0;
        while (i < this.nDimensions) {
            pp.setPoint(this.point[i] + constant);
            ++i;
        }
        return null;
    }

    public boolean isEqual(Point point2) {
        boolean test2 = true;
        int n1 = point2.getPointDimensions();
        if (n1 != this.nDimensions) {
            test2 = false;
        } else {
            double[] p0 = this.getPointCoordinates();
            double[] p1 = point2.getPointCoordinates();
            int i = 0;
            while (i < this.nDimensions) {
                if (p0[i] != p1[i]) {
                    test2 = false;
                    break;
                }
                ++i;
            }
        }
        return test2;
    }

    public static boolean isEqual(Point point1, Point point2) {
        int n2;
        boolean test2 = true;
        int n1 = point1.getPointDimensions();
        if (n1 != (n2 = point2.getPointDimensions())) {
            test2 = false;
        } else {
            double[] p0 = point1.getPointCoordinates();
            double[] p1 = point2.getPointCoordinates();
            int i = 0;
            while (i < n1) {
                if (p0[i] != p1[i]) {
                    test2 = false;
                    break;
                }
                ++i;
            }
        }
        return test2;
    }

    public Point copy() {
        double[] pc = new double[this.nDimensions];
        int i = 0;
        while (i < this.nDimensions) {
            pc[i] = this.point[i];
            ++i;
        }
        Point pp = new Point(pc);
        return pp;
    }

    public static Point copy(Point p) {
        int n = p.getPointDimensions();
        double[] pc = new double[n];
        int i = 0;
        while (i < n) {
            pc[i] = p.point[i];
            ++i;
        }
        Point pp = new Point(pc);
        return pp;
    }

    public static Point[] copy(Point[] pp) {
        int n = pp.length;
        Point[] pq = Point.oneDarray(n);
        int i = 0;
        while (i < n) {
            pq[i] = pp[i].copy();
            ++i;
        }
        return pq;
    }

    public void toThreeD() {
        double[] hold0 = (double[])this.point.clone();
        double[] hold1 = new double[3];
        if (this.nDimensions > 3) {
            System.out.println("Method toThreeD:  Dimensions are greater than three so instance cannot be convertd to a three D Point");
        } else if (this.nDimensions < 3) {
            int i = 0;
            while (i < this.nDimensions) {
                hold1[i] = hold0[i];
                ++i;
            }
            i = this.nDimensions;
            while (i < 3) {
                hold1[i] = 0.0;
                ++i;
            }
            this.point = hold1;
            this.nDimensions = 3;
        }
    }

    public void toTwoD() {
        double[] hold0 = (double[])this.point.clone();
        double[] hold1 = new double[2];
        boolean test1 = true;
        int i = 2;
        while (i < this.nDimensions) {
            if (hold0[i] != 0.0) {
                test1 = false;
            }
            ++i;
        }
        if (test1) {
            i = 0;
            while (i < 2) {
                hold1[i] = hold0[i];
                ++i;
            }
        } else {
            throw new IllegalArgumentException("There are non-zero values in the coordinate positions greater than 2D");
        }
        this.point = hold1;
        this.nDimensions = 2;
    }

    public VectorMaths toVectorMaths() {
        if (this.nDimensions > 3) {
            throw new IllegalArgumentException("VectorMaths is restricted to 2 or 3-dimensional space");
        }
        VectorMaths vec = new VectorMaths(this.point);
        return vec;
    }
}

