/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.Stat;
import flanagan.circuits.Phasor;
import flanagan.circuits.PhasorMatrix;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.io.PrintToScreen;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.PsRandom;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ArrayMaths {
    protected ArrayList<Object> array = null;
    protected int length = 0;
    protected int type = -1;
    protected int[] originalTypes = null;
    protected String[] typeName = new String[]{"double", "Double", "float", "Float", "long", "Long", "int", "Integer", "short", "Short", "byte", "Byte", "BigDecimal", "BigInteger", "Complex", "Phasor", "char", "Character", "String"};
    protected ArrayList<Object> summ = new ArrayList(1);
    protected ArrayList<Object> productt = new ArrayList(1);
    protected int[] sortedIndices = null;
    protected ArrayList<Object> minmax = new ArrayList(2);
    protected int maxIndex = -1;
    protected int minIndex = -1;
    protected boolean sumDone = false;
    protected boolean productDone = false;
    protected boolean sumlongToDouble = false;
    protected boolean productlongToDouble = false;
    protected boolean suppressMessages = false;
    public String[] words = null;
    public String[] sortedWords = null;
    protected char[][] wordChar = null;
    protected char[][] holdWordChar = null;
    protected int[] wordOrder = null;
    protected int[] holdWordOrder = null;
    protected int nWords = 0;
    protected int nLength = 0;
    protected static final Map<Object, Object> integers = new HashMap<Object, Object>();

    static {
        integers.put(Integer.class, BigDecimal.valueOf(Integer.MAX_VALUE));
        integers.put(Long.class, BigDecimal.valueOf(Long.MAX_VALUE));
        integers.put(Byte.class, BigDecimal.valueOf(127L));
        integers.put(Short.class, BigDecimal.valueOf(32767L));
        integers.put(BigInteger.class, BigDecimal.valueOf(-1L));
    }

    protected ArrayMaths() {
        this.array = new ArrayList();
    }

    public ArrayMaths(double[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 0;
        int i = 0;
        while (i < this.length) {
            this.array.add(new Double(array[i]));
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Double[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 1;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(long[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 4;
        int i = 0;
        while (i < this.length) {
            this.array.add(new Long(array[i]));
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Long[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 5;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(float[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 2;
        int i = 0;
        while (i < this.length) {
            this.array.add(new Float(array[i]));
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Float[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 3;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(int[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 6;
        int i = 0;
        while (i < this.length) {
            this.array.add(new Integer(array[i]));
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Integer[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 7;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(short[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 8;
        int i = 0;
        while (i < this.length) {
            this.array.add(new Short(array[i]));
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Short[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 9;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(byte[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 10;
        int i = 0;
        while (i < this.length) {
            this.array.add(new Byte(array[i]));
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Byte[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 11;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(BigDecimal[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 12;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(BigInteger[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 13;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Complex[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 14;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
    }

    public ArrayMaths(Phasor[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 15;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
    }

    public ArrayMaths(char[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 16;
        int i = 0;
        while (i < this.length) {
            this.array.add(new Character(array[i]));
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Character[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 17;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(String[] array) {
        this.length = array.length;
        this.array = new ArrayList(this.length);
        this.type = 18;
        int i = 0;
        while (i < this.length) {
            this.array.add(array[i]);
            ++i;
        }
        this.originalTypes = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
    }

    public ArrayMaths(Object[] array) {
        this.length = array.length;
        this.originalTypes = new int[this.length];
        ArrayList<Object> arrayl = new ArrayList<Object>(this.length);
        int i = 0;
        while (i < this.length) {
            arrayl.add(array[i]);
            ++i;
        }
        ArrayMaths am = new ArrayMaths(arrayl);
        this.array = am.getArray_as_ArrayList();
        this.minmax = am.minmax;
        this.minIndex = am.minIndex;
        this.maxIndex = am.maxIndex;
        this.originalTypes = am.originalTypes;
    }

    public ArrayMaths(Stat arrayst) {
        this.array = arrayst.getArray_as_ArrayList();
        this.length = this.array.size();
        this.type = arrayst.typeIndex();
        this.originalTypes = new int[this.length];
        int i = 0;
        while (i < this.length) {
            this.originalTypes[i] = this.type;
            ++i;
        }
        this.minmax();
    }

    public ArrayMaths(Vector<Object> arrayv) {
        this.length = arrayv.size();
        this.originalTypes = new int[this.length];
        this.array = new ArrayList(this.length);
        int i = 0;
        while (i < this.length) {
            this.originalTypes[i] = -1;
            if (arrayv.elementAt(i) instanceof Double) {
                this.originalTypes[i] = 1;
            }
            if (arrayv.elementAt(i) instanceof Float) {
                this.originalTypes[i] = 3;
            }
            if (arrayv.elementAt(i) instanceof Long) {
                this.originalTypes[i] = 5;
            }
            if (arrayv.elementAt(i) instanceof Integer) {
                this.originalTypes[i] = 7;
            }
            if (arrayv.elementAt(i) instanceof Short) {
                this.originalTypes[i] = 9;
            }
            if (arrayv.elementAt(i) instanceof Byte) {
                this.originalTypes[i] = 11;
            }
            if (arrayv.elementAt(i) instanceof BigDecimal) {
                this.originalTypes[i] = 12;
            }
            if (arrayv.elementAt(i) instanceof BigInteger) {
                this.originalTypes[i] = 13;
            }
            if (arrayv.elementAt(i) instanceof Complex) {
                this.originalTypes[i] = 14;
            }
            if (arrayv.elementAt(i) instanceof Phasor) {
                this.originalTypes[i] = 15;
            }
            if (arrayv.elementAt(i) instanceof Character) {
                this.originalTypes[i] = 17;
            }
            if (arrayv.elementAt(i) instanceof String) {
                this.originalTypes[i] = 18;
            }
            if (this.originalTypes[i] == -1) {
                throw new IllegalArgumentException("Object at " + i + " not recognised as one allowed by this class");
            }
            ++i;
        }
        int testType = -1;
        int i2 = 0;
        while (i2 < this.length) {
            if (this.originalTypes[i2] == 18) {
                testType = 0;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.length) {
            if (this.originalTypes[i2] == 14) {
                testType = 1;
            }
            ++i2;
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 15) {
                    testType = 2;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 12) {
                    testType = 3;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 13) {
                    testType = 4;
                }
                ++i2;
            }
        }
        if (testType == 4) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] <= 3) {
                    testType = 3;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] <= 3) {
                    testType = 5;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] > 3 && this.originalTypes[i2] < 12) {
                    testType = 6;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 17) {
                    testType = 7;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            throw new IllegalArgumentException("It should not be possible to reach this exception - main Object type not identified");
        }
        switch (testType) {
            case 0: {
                this.type = 18;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayv.elementAt(i2);
                            this.array.add(hold1.toString());
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayv.elementAt(i2);
                            this.array.add(hold3.toString());
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayv.elementAt(i2);
                            this.array.add(hold5.toString());
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayv.elementAt(i2);
                            this.array.add(hold7.toString());
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayv.elementAt(i2);
                            this.array.add(hold9.toString());
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayv.elementAt(i2);
                            this.array.add(hold11.toString());
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayv.elementAt(i2);
                            this.array.add(hold12.toString());
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayv.elementAt(i2);
                            this.array.add(hold13.toString());
                            break;
                        }
                        case 14: {
                            Complex hold14 = (Complex)arrayv.elementAt(i2);
                            this.array.add(hold14.toString());
                            break;
                        }
                        case 15: {
                            Phasor hold15 = (Phasor)arrayv.elementAt(i2);
                            this.array.add(hold15.toString());
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(hold17.toString());
                            break;
                        }
                        case 18: {
                            String hold18 = (String)arrayv.elementAt(i2);
                            this.array.add(hold18);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 1: {
                this.type = 14;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold3.doubleValue()));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold5.doubleValue()));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold7.doubleValue()));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold9.doubleValue()));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold11.doubleValue()));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold12.doubleValue()));
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold13.doubleValue()));
                            break;
                        }
                        case 14: {
                            Complex hold14 = (Complex)arrayv.elementAt(i2);
                            this.array.add(hold14);
                            break;
                        }
                        case 15: {
                            Phasor hold15 = (Phasor)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Phasor_to_Complex(hold15));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(new Complex(hold17.charValue()));
                            break;
                        }
                        case 18: {
                            String hold18 = (String)arrayv.elementAt(i2);
                            this.array.add(new Complex(Double.parseDouble(hold18)));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 2: {
                this.type = 15;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold3.doubleValue()));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold5.doubleValue()));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold7.doubleValue()));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold9.doubleValue()));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold11.doubleValue()));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold12.doubleValue()));
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold13.doubleValue()));
                            break;
                        }
                        case 14: {
                            Complex hold14 = (Complex)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Complex_to_Phasor(hold14));
                            break;
                        }
                        case 15: {
                            Phasor hold15 = (Phasor)arrayv.elementAt(i2);
                            this.array.add(hold15);
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(new Phasor(hold17.charValue()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 3: {
                this.type = 12;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Double_to_BigDecimal(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Float_to_BigDecimal(hold3));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Long_to_BigDecimal(hold5));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Integer_to_BigDecimal(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Short_to_BigDecimal(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Byte_to_BigDecimal(hold11));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayv.elementAt(i2);
                            this.array.add(hold12);
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_BigInteger_to_BigDecimal(hold13));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(new BigDecimal(hold17.toString()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 4: {
                this.type = 13;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Double_to_BigInteger(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Float_to_BigInteger(hold3));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Long_to_BigInteger(hold5));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Integer_to_BigInteger(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Short_to_BigInteger(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Byte_to_BigInteger(hold11));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_BigDecimal_to_BigInteger(hold12));
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayv.elementAt(i2);
                            this.array.add(hold13);
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(new BigInteger(hold17.toString()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 5: {
                this.type = 1;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayv.elementAt(i2);
                            this.array.add(hold1);
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Float_to_Double(hold3));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Long_to_Double(hold5));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Integer_to_Double(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Short_to_Double(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Byte_to_Double(hold11));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(new Double(Double.parseDouble(hold17.toString())));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 6: {
                this.type = 7;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 5: {
                            Long hold5 = (Long)arrayv.elementAt(i2);
                            this.array.add(hold5);
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Integer_to_Long(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Short_to_Long(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayv.elementAt(i2);
                            this.array.add(Conv.convert_Byte_to_Long(hold11));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(new Long(hold17.charValue()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 7: {
                this.type = 7;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 17: {
                            Character hold17 = (Character)arrayv.elementAt(i2);
                            this.array.add(hold17);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Dominant array data type not identified by this method");
            }
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                this.minmax();
            }
        }
    }

    public ArrayMaths(ArrayList<Object> arrayl) {
        this.length = arrayl.size();
        this.originalTypes = new int[this.length];
        this.array = new ArrayList(this.length);
        int i = 0;
        while (i < this.length) {
            this.originalTypes[i] = -1;
            if (arrayl.get(i) instanceof Double) {
                this.originalTypes[i] = 1;
            }
            if (arrayl.get(i) instanceof Float) {
                this.originalTypes[i] = 3;
            }
            if (arrayl.get(i) instanceof Long) {
                this.originalTypes[i] = 5;
            }
            if (arrayl.get(i) instanceof Integer) {
                this.originalTypes[i] = 7;
            }
            if (arrayl.get(i) instanceof Short) {
                this.originalTypes[i] = 9;
            }
            if (arrayl.get(i) instanceof Byte) {
                this.originalTypes[i] = 11;
            }
            if (arrayl.get(i) instanceof BigDecimal) {
                this.originalTypes[i] = 12;
            }
            if (arrayl.get(i) instanceof BigInteger) {
                this.originalTypes[i] = 13;
            }
            if (arrayl.get(i) instanceof Complex) {
                this.originalTypes[i] = 14;
            }
            if (arrayl.get(i) instanceof Phasor) {
                this.originalTypes[i] = 15;
            }
            if (arrayl.get(i) instanceof Character) {
                this.originalTypes[i] = 17;
            }
            if (arrayl.get(i) instanceof String) {
                this.originalTypes[i] = 18;
            }
            if (this.originalTypes[i] == -1) {
                throw new IllegalArgumentException("Object at " + i + " not recognised as one allowed by this class");
            }
            ++i;
        }
        int testType = -1;
        int i2 = 0;
        while (i2 < this.length) {
            if (this.originalTypes[i2] == 18) {
                testType = 0;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.length) {
            if (this.originalTypes[i2] == 14) {
                testType = 1;
            }
            ++i2;
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 15) {
                    testType = 2;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 12) {
                    testType = 3;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 13) {
                    testType = 4;
                }
                ++i2;
            }
        }
        if (testType == 4) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] <= 3) {
                    testType = 3;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] <= 3) {
                    testType = 5;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] > 3 && this.originalTypes[i2] < 12) {
                    testType = 6;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            i2 = 0;
            while (i2 < this.length) {
                if (this.originalTypes[i2] == 17) {
                    testType = 7;
                }
                ++i2;
            }
        }
        if (testType == -1) {
            throw new IllegalArgumentException("It should not be possible to reach this exception - main Object type not identified");
        }
        switch (testType) {
            case 0: {
                this.type = 18;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayl.get(i2);
                            this.array.add(hold1.toString());
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayl.get(i2);
                            this.array.add(hold3.toString());
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayl.get(i2);
                            this.array.add(hold5.toString());
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayl.get(i2);
                            this.array.add(hold7.toString());
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayl.get(i2);
                            this.array.add(hold9.toString());
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayl.get(i2);
                            this.array.add(hold11.toString());
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayl.get(i2);
                            this.array.add(hold12.toString());
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayl.get(i2);
                            this.array.add(hold13.toString());
                            break;
                        }
                        case 14: {
                            Complex hold14 = (Complex)arrayl.get(i2);
                            this.array.add(hold14.toString());
                            break;
                        }
                        case 15: {
                            Phasor hold15 = (Phasor)arrayl.get(i2);
                            this.array.add(hold15.toString());
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(hold17.toString());
                            break;
                        }
                        case 18: {
                            String hold18 = (String)arrayl.get(i2);
                            this.array.add(hold18);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 1: {
                this.type = 14;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayl.get(i2);
                            this.array.add(new Complex(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayl.get(i2);
                            this.array.add(new Complex(hold3.doubleValue()));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayl.get(i2);
                            this.array.add(new Complex(hold5.doubleValue()));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayl.get(i2);
                            this.array.add(new Complex(hold7.doubleValue()));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayl.get(i2);
                            this.array.add(new Complex(hold9.doubleValue()));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayl.get(i2);
                            this.array.add(new Complex(hold11.doubleValue()));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayl.get(i2);
                            this.array.add(new Complex(hold12.doubleValue()));
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayl.get(i2);
                            this.array.add(new Complex(hold13.doubleValue()));
                            break;
                        }
                        case 14: {
                            Complex hold14 = (Complex)arrayl.get(i2);
                            this.array.add(hold14);
                            break;
                        }
                        case 15: {
                            Phasor hold15 = (Phasor)arrayl.get(i2);
                            this.array.add(Conv.convert_Phasor_to_Complex(hold15));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(new Complex(hold17.charValue()));
                            break;
                        }
                        case 18: {
                            String hold18 = (String)arrayl.get(i2);
                            this.array.add(new Complex(Double.parseDouble(hold18)));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 2: {
                this.type = 15;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayl.get(i2);
                            this.array.add(new Phasor(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayl.get(i2);
                            this.array.add(new Phasor(hold3.doubleValue()));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayl.get(i2);
                            this.array.add(new Phasor(hold5.doubleValue()));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayl.get(i2);
                            this.array.add(new Phasor(hold7.doubleValue()));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayl.get(i2);
                            this.array.add(new Phasor(hold9.doubleValue()));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayl.get(i2);
                            this.array.add(new Phasor(hold11.doubleValue()));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayl.get(i2);
                            this.array.add(new Phasor(hold12.doubleValue()));
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayl.get(i2);
                            this.array.add(new Phasor(hold13.doubleValue()));
                            break;
                        }
                        case 14: {
                            Complex hold14 = (Complex)arrayl.get(i2);
                            this.array.add(Conv.convert_Complex_to_Phasor(hold14));
                            break;
                        }
                        case 15: {
                            Phasor hold15 = (Phasor)arrayl.get(i2);
                            this.array.add(hold15);
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(new Phasor(hold17.charValue()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 3: {
                this.type = 12;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayl.get(i2);
                            this.array.add(Conv.convert_Double_to_BigDecimal(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayl.get(i2);
                            this.array.add(Conv.convert_Float_to_BigDecimal(hold3));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayl.get(i2);
                            this.array.add(Conv.convert_Long_to_BigDecimal(hold5));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayl.get(i2);
                            this.array.add(Conv.convert_Integer_to_BigDecimal(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayl.get(i2);
                            this.array.add(Conv.convert_Short_to_BigDecimal(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayl.get(i2);
                            this.array.add(Conv.convert_Byte_to_BigDecimal(hold11));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayl.get(i2);
                            this.array.add(hold12);
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayl.get(i2);
                            this.array.add(Conv.convert_BigInteger_to_BigDecimal(hold13));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(new BigDecimal(hold17.toString()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 4: {
                this.type = 13;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayl.get(i2);
                            this.array.add(Conv.convert_Double_to_BigInteger(hold1));
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayl.get(i2);
                            this.array.add(Conv.convert_Float_to_BigInteger(hold3));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayl.get(i2);
                            this.array.add(Conv.convert_Long_to_BigInteger(hold5));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayl.get(i2);
                            this.array.add(Conv.convert_Integer_to_BigInteger(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayl.get(i2);
                            this.array.add(Conv.convert_Short_to_BigInteger(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayl.get(i2);
                            this.array.add(Conv.convert_Byte_to_BigInteger(hold11));
                            break;
                        }
                        case 12: {
                            BigDecimal hold12 = (BigDecimal)arrayl.get(i2);
                            this.array.add(Conv.convert_BigDecimal_to_BigInteger(hold12));
                            break;
                        }
                        case 13: {
                            BigInteger hold13 = (BigInteger)arrayl.get(i2);
                            this.array.add(hold13);
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(new BigInteger(hold17.toString()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 5: {
                this.type = 1;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 1: {
                            Double hold1 = (Double)arrayl.get(i2);
                            this.array.add(hold1);
                            break;
                        }
                        case 3: {
                            Float hold3 = (Float)arrayl.get(i2);
                            this.array.add(Conv.convert_Float_to_Double(hold3));
                            break;
                        }
                        case 5: {
                            Long hold5 = (Long)arrayl.get(i2);
                            this.array.add(Conv.convert_Long_to_Double(hold5));
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayl.get(i2);
                            this.array.add(Conv.convert_Integer_to_Double(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayl.get(i2);
                            this.array.add(Conv.convert_Short_to_Double(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayl.get(i2);
                            this.array.add(Conv.convert_Byte_to_Double(hold11));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(new Double(Double.parseDouble(hold17.toString())));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 6: {
                this.type = 7;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 5: {
                            Long hold5 = (Long)arrayl.get(i2);
                            this.array.add(hold5);
                            break;
                        }
                        case 7: {
                            Integer hold7 = (Integer)arrayl.get(i2);
                            this.array.add(Conv.convert_Integer_to_Long(hold7));
                            break;
                        }
                        case 9: {
                            Short hold9 = (Short)arrayl.get(i2);
                            this.array.add(Conv.convert_Short_to_Long(hold9));
                            break;
                        }
                        case 11: {
                            Byte hold11 = (Byte)arrayl.get(i2);
                            this.array.add(Conv.convert_Byte_to_Long(hold11));
                            break;
                        }
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(new Long(hold17.charValue()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 7: {
                this.type = 7;
                i2 = 0;
                while (i2 < this.length) {
                    switch (this.originalTypes[i2]) {
                        case 17: {
                            Character hold17 = (Character)arrayl.get(i2);
                            this.array.add(hold17);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                    ++i2;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Dominant array data type not identified by this method");
            }
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                this.minmax();
            }
        }
    }

    public int length() {
        return this.length;
    }

    public int typeIndex() {
        return this.type;
    }

    public String arrayType() {
        return String.valueOf(this.typeName[this.type]) + "[]";
    }

    public String[] originalArrayTypes() {
        String[] ss = new String[this.length];
        int i = 0;
        while (i < this.length) {
            ss[i] = this.typeName[this.originalTypes[i]];
            ++i;
        }
        return ss;
    }

    public ArrayMaths copy() {
        BigInteger bi;
        long ll;
        double dd;
        ArrayMaths am = new ArrayMaths();
        am.length = this.length;
        am.maxIndex = this.maxIndex;
        am.minIndex = this.minIndex;
        am.sumDone = this.sumDone;
        am.productDone = this.productDone;
        am.sumlongToDouble = this.sumlongToDouble;
        am.productlongToDouble = this.productlongToDouble;
        am.type = this.type;
        am.originalTypes = (int[])(this.originalTypes == null ? null : Conv.copy(this.originalTypes));
        am.sortedIndices = (int[])(this.sortedIndices == null ? null : Conv.copy(this.sortedIndices));
        am.suppressMessages = this.suppressMessages;
        am.minmax = new ArrayList();
        if (this.minmax.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: {
                    dd = (Double)this.minmax.get(0);
                    am.minmax.add(new Double(dd));
                    dd = (Double)this.minmax.get(1);
                    am.minmax.add(new Double(dd));
                    break;
                }
                case 4: 
                case 5: {
                    ll = (Long)this.minmax.get(0);
                    am.minmax.add(new Double(ll));
                    ll = (Long)this.minmax.get(1);
                    am.minmax.add(new Long(ll));
                    break;
                }
                case 2: 
                case 3: {
                    float ff = ((Float)this.minmax.get(0)).floatValue();
                    am.minmax.add(new Double(ff));
                    ff = ((Float)this.minmax.get(1)).floatValue();
                    am.minmax.add(new Double(ff));
                    break;
                }
                case 6: 
                case 7: {
                    int ii = (Integer)this.minmax.get(0);
                    am.minmax.add(new Integer(ii));
                    ii = ((Double)this.minmax.get(1)).intValue();
                    am.minmax.add(new Integer(ii));
                    break;
                }
                case 8: 
                case 9: {
                    short ss = (Short)this.minmax.get(0);
                    am.minmax.add(new Short(ss));
                    ss = ((Double)this.minmax.get(1)).shortValue();
                    am.minmax.add(new Short(ss));
                    break;
                }
                case 10: 
                case 11: {
                    byte bb = (Byte)this.minmax.get(0);
                    am.minmax.add(new Byte(bb));
                    short ss = ((Byte)this.minmax.get(1)).byteValue();
                    am.minmax.add(new Byte(bb));
                    break;
                }
                case 12: {
                    BigDecimal bd = (BigDecimal)this.minmax.get(0);
                    am.minmax.add(bd);
                    bd = (BigDecimal)this.minmax.get(1);
                    am.minmax.add(bd);
                    bd = null;
                    break;
                }
                case 13: {
                    BigInteger bi2 = (BigInteger)this.minmax.get(0);
                    am.minmax.add(bi2);
                    bi2 = (BigInteger)this.minmax.get(1);
                    am.minmax.add(bi2);
                    bi2 = null;
                    break;
                }
                case 16: 
                case 17: {
                    int iii = (Integer)this.minmax.get(0);
                    am.minmax.add(new Integer(iii));
                    iii = ((Double)this.minmax.get(1)).intValue();
                    am.minmax.add(new Integer(iii));
                }
            }
        }
        am.summ = new ArrayList();
        if (this.summ.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    dd = (Double)this.summ.get(0);
                    am.summ.add(new Double(dd));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double dd2 = (Double)this.summ.get(0);
                        am.summ.add(new Double(dd2));
                        break;
                    }
                    ll = (Long)this.summ.get(0);
                    am.summ.add(new Long(ll));
                    break;
                }
                case 12: {
                    BigDecimal bd = (BigDecimal)this.summ.get(0);
                    am.summ.add(bd);
                    break;
                }
                case 13: {
                    bi = (BigInteger)this.summ.get(0);
                    am.summ.add(bi);
                    break;
                }
                case 14: {
                    Complex cc = (Complex)this.summ.get(0);
                    am.summ.add(cc);
                    break;
                }
                case 15: {
                    Phasor pp = (Phasor)this.summ.get(0);
                    am.summ.add(pp);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        am.productt = new ArrayList();
        if (this.productt.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    dd = (Double)this.productt.get(0);
                    am.productt.add(new Double(dd));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double dd2 = (Double)this.productt.get(0);
                        am.productt.add(new Double(dd2));
                        break;
                    }
                    long ll2 = (Long)this.productt.get(0);
                    am.productt.add(new Long(ll2));
                    break;
                }
                case 12: {
                    BigDecimal bd = (BigDecimal)this.productt.get(0);
                    am.productt.add(bd);
                    break;
                }
                case 13: {
                    bi = (BigInteger)this.productt.get(0);
                    am.productt.add(bi);
                    break;
                }
                case 14: {
                    Complex cc = (Complex)this.productt.get(0);
                    am.productt.add(cc);
                    break;
                }
                case 15: {
                    Phasor pp = (Phasor)this.productt.get(0);
                    am.productt.add(pp);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd2 = Conv.copy(this.getArray_as_double());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd2[i]));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                float[] ff = Conv.copy(this.getArray_as_float());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(ff[i]));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                long[] ll3 = Conv.copy(this.getArray_as_long());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll3[i]));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int[] ii = Conv.copy(this.getArray_as_int());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Integer(ii[i]));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                short[] ss = Conv.copy(this.getArray_as_short());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short(ss[i]));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = Conv.copy(this.getArray_as_byte());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte(bb[i]));
                    ++i;
                }
                break;
            }
            case 12: {
                BigDecimal[] bd = Conv.copy(this.getArray_as_BigDecimal());
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i]);
                    ++i;
                }
                break;
            }
            case 13: {
                BigInteger[] bi3 = Conv.copy(this.getArray_as_BigInteger());
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi3[i]);
                    ++i;
                }
                break;
            }
            case 14: {
                Complex[] ccc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(ccc[i].copy());
                    ++i;
                }
                break;
            }
            case 15: {
                Phasor[] ppp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(ppp[i].copy());
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                char[] cc = Conv.copy(this.getArray_as_char());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Character(cc[i]));
                    ++i;
                }
                break;
            }
            case 18: {
                String[] sss = Conv.copy(this.getArray_as_String());
                int i = 0;
                while (i < this.length) {
                    am.array.add(sss[i]);
                    ++i;
                }
                break;
            }
        }
        return am;
    }

    public void suppressMessages() {
        this.suppressMessages = true;
    }

    public void restoreMessages() {
        this.suppressMessages = false;
    }

    public static void suppressMessagesTotal() {
        Conv.suppressMessagesAM();
    }

    public static void restoreMessagesTotal() {
        Conv.restoreMessagesAM();
    }

    public double[] array() {
        return this.getArray_as_double();
    }

    public double[] array_as_double() {
        return this.getArray_as_double();
    }

    public double[] getArray_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double[] retArray = new double[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Double)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_double((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_double((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_double((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_double((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_double((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_double((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Double.valueOf((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_double(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Double[] array_as_Double() {
        return this.getArray_as_Double();
    }

    public Double[] getArray_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double[] retArray = new Double[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Double)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_Double((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_Double((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_Double((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_Double((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_Double((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_Double((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_Double((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Double((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_Double(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Float[] array_as_Float() {
        return this.getArray_as_Float();
    }

    public Float[] getArray_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float[] retArray = new Float[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_Float((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Float)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_Float((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_Float((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_Float((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_Float((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_Float((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_Float((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Float((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_Float(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public float[] array_as_float() {
        return this.getArray_as_float();
    }

    public float[] getArray_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float[] retArray = new float[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_float((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Float)this.array.get(i)).floatValue();
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_float((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_float((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_float((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_float((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_float((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_float((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Float((String)this.array.get(i)).floatValue();
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_float(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public long[] array_as_long() {
        return this.getArray_as_long();
    }

    public long[] getArray_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long[] retArray = new long[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_long((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_long((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Long)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_long((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_long((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_long((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_long((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_long((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Long((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_long(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Long[] array_as_Long() {
        return this.getArray_as_Long();
    }

    public Long[] getArray_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long[] retArray = new Long[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_Long((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_Long((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Long)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_Long((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_Long((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_Long((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_Long((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_Long((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Long((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_Long(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Integer[] array_as_Integer() {
        return this.getArray_as_Integer();
    }

    public Integer[] getArray_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer[] retArray = new Integer[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_Integer((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_Integer((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_Integer((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Integer)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_Integer((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_Integer((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_Integer((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Integer((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Integer(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public int[] array_as_int() {
        return this.getArray_as_int();
    }

    public int[] getArray_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] retArray = new int[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_int((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_int((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_int((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Integer)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_int((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_int((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_int((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_int((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Integer((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Character)this.array.get(i)).charValue();
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public short[] array_as_short() {
        return this.getArray_as_short();
    }

    public short[] getArray_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short[] retArray = new short[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_short((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_short((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_short((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_short((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Short)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_short((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_short((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_short((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Short((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_short(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Short[] array_as_Short() {
        return this.getArray_as_Short();
    }

    public Short[] getArray_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short[] retArray = new Short[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_Short((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_Short((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_Short((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_Short((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Short)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_Short((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_Short((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_Short((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Short((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_Short(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public byte[] array_as_byte() {
        return this.getArray_as_byte();
    }

    public byte[] getArray_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte[] retArray = new byte[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_byte((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_byte((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_byte((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_byte((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_byte((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Byte)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_byte((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_byte((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Byte((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_byte(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Byte[] array_as_Byte() {
        return this.getArray_as_Byte();
    }

    public Byte[] getArray_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte[] retArray = new Byte[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_Byte((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_Byte((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_Byte((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_Byte((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_Byte((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Byte)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_Byte((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Byte((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_Byte(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public BigDecimal[] array_as_BigDecimal() {
        return this.getArray_as_BigDecimal();
    }

    public BigDecimal[] getArray_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal[] retArray = new BigDecimal[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_BigDecimal((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_BigDecimal((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_BigDecimal((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_BigDecimal((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_BigDecimal((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_BigDecimal((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (BigDecimal)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new BigDecimal((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_BigDecimal(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public BigInteger[] array_as_BigInteger() {
        return this.getArray_as_BigInteger();
    }

    public BigInteger[] getArray_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger[] retArray = new BigInteger[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Double_to_BigInteger((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Float_to_BigInteger((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Long_to_BigInteger((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Integer_to_BigInteger((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Short_to_BigInteger((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Byte_to_BigInteger((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (BigInteger)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new BigInteger((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_int_to_BigInteger(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Complex[] array_as_Complex() {
        return this.getArray_as_Complex();
    }

    public Complex[] getArray_as_Complex() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Complex[] retArray = Complex.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(((Float)this.array.get(i)).doubleValue());
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(Conv.convert_Long_to_double((Long)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(Conv.convert_Integer_to_double((Integer)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(Conv.convert_Short_to_double((Short)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(Conv.convert_Byte_to_double((Byte)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Complex)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Phasor_to_Complex((Phasor)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    String ss = (String)this.array.get(i);
                    retArray[i] = ss.indexOf(105) != -1 || ss.indexOf(106) != -1 ? Complex.valueOf(ss) : new Complex(Double.valueOf(ss));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Complex(Conv.convert_int_to_double(((Character)this.array.get(i)).charValue()));
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Phasor[] array_as_Phasor() {
        return this.getArray_as_Phasor();
    }

    public Phasor[] getArray_as_Phasor() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Phasor[] retArray = Phasor.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(((Float)this.array.get(i)).doubleValue());
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(Conv.convert_Long_to_double((Long)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(Conv.convert_Integer_to_double((Integer)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(Conv.convert_Short_to_double((Short)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(Conv.convert_Byte_to_double((Byte)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = Conv.convert_Complex_to_Phasor((Complex)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Phasor)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    String ss = ((String)this.array.get(i)).trim();
                    retArray[i] = ss.indexOf(60) != -1 || ss.indexOf(76) != -1 ? Phasor.valueOf(ss) : new Phasor(Double.valueOf(ss));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Phasor(Conv.convert_int_to_double(((Character)this.array.get(i)).charValue()));
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Character[] array_as_Character() {
        return this.getArray_as_Character();
    }

    public Character[] getArray_as_Character() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character[] retArray = new Character[this.length];
        switch (this.type) {
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = new Character((char)((Integer)this.array.get(i)).intValue());
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (Character)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 18: {
                boolean test2 = true;
                String[] ss = new String[this.length];
                int i = 0;
                while (i < this.length) {
                    ss[i] = ((String)this.array.get(i)).trim();
                    if (ss[i].length() > 1) {
                        test2 = false;
                        break;
                    }
                    ++i;
                }
                if (test2) {
                    i = 0;
                    while (i < this.length) {
                        retArray[i] = new Character(ss[i].charAt(0));
                        ++i;
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to Character");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public char[] array_as_char() {
        return this.getArray_as_char();
    }

    public char[] getArray_as_char() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char[] retArray = new char[this.length];
        switch (this.type) {
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (char)((Integer)this.array.get(i)).intValue();
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Character)this.array.get(i)).charValue();
                    ++i;
                }
                break;
            }
            case 18: {
                boolean test2 = true;
                String[] ss = new String[this.length];
                int i = 0;
                while (i < this.length) {
                    ss[i] = ((String)this.array.get(i)).trim();
                    if (ss[i].length() > 1) {
                        test2 = false;
                        break;
                    }
                    ++i;
                }
                if (test2) {
                    i = 0;
                    while (i < this.length) {
                        retArray[i] = ss[i].charAt(0);
                        ++i;
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to char");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public String[] array_as_String() {
        return this.getArray_as_String();
    }

    public String[] getArray_as_String() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        String[] retArray = new String[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Double)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Float)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Long)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Integer)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Short)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Byte)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((BigDecimal)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((BigInteger)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Complex)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Phasor)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = ((Character)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    retArray[i] = (String)this.array.get(i);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Object[] array_as_Object() {
        return this.getArray_as_Object();
    }

    public Object[] getArray_as_Object() {
        Object[] arrayo = new Object[this.length];
        int i = 0;
        while (i < this.length) {
            arrayo[i] = this.array.get(i);
            ++i;
        }
        return arrayo;
    }

    public Vector array_as_Vector() {
        return this.getArray_as_Vector();
    }

    public Vector<Object> getArray_as_Vector() {
        Vector<Object> vec = new Vector<Object>(this.length);
        int i = 0;
        while (i < this.length) {
            vec.addElement(this.array.get(i));
            ++i;
        }
        return vec;
    }

    public ArrayList array_as_ArrayList() {
        return this.getArray_as_ArrayList();
    }

    public ArrayList<Object> getArray_as_ArrayList() {
        ArrayList<Object> arrayl = new ArrayList<Object>(this.length);
        int i = 0;
        while (i < this.length) {
            arrayl.add(this.array.get(i));
            ++i;
        }
        return arrayl;
    }

    public Matrix array_as_Matrix_rowMatrix() {
        return this.getArray_as_Matrix_rowMatrix();
    }

    public Matrix getArray_as_Matrix_rowMatrix() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix mat = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                mat = Matrix.rowMatrix(dd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.rowMatrix - use method getArray_as_Complex_rowMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.rowMatrix - use method getArray_as_Phasor_rowMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return mat;
    }

    public Matrix array_as_Matrix_columnMatrix() {
        return this.getArray_as_Matrix_columnMatrix();
    }

    public Matrix getArray_as_Matrix_columnMatrix() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix mat = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                mat = Matrix.columnMatrix(dd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.columnMatrix - use method getArray_as_Complex_columnMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.columnMatrix - use method getArray_as_Phasor_columnMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return mat;
    }

    public ComplexMatrix array_as_Complex_rowMatrix() {
        return this.getArray_as_Complex_rowMatrix();
    }

    public ComplexMatrix getArray_as_Complex_rowMatrix() {
        Complex[] cc = this.getArray_as_Complex();
        ComplexMatrix mat = ComplexMatrix.rowMatrix(cc);
        return mat;
    }

    public ComplexMatrix array_as_Complex_columnMatrix() {
        return this.getArray_as_Complex_columnMatrix();
    }

    public ComplexMatrix getArray_as_Complex_columnMatrix() {
        Complex[] cc = this.getArray_as_Complex();
        ComplexMatrix mat = ComplexMatrix.columnMatrix(cc);
        return mat;
    }

    public PhasorMatrix array_as_Phasor_rowMatrix() {
        return this.getArray_as_Phasor_rowMatrix();
    }

    public PhasorMatrix getArray_as_Phasor_rowMatrix() {
        Phasor[] cc = this.getArray_as_Phasor();
        PhasorMatrix mat = PhasorMatrix.rowMatrix(cc);
        return mat;
    }

    public PhasorMatrix array_as_Phasor_columnMatrix() {
        return this.getArray_as_Phasor_columnMatrix();
    }

    public PhasorMatrix getArray_as_Phasor_columnMatrix() {
        Phasor[] cc = this.getArray_as_Phasor();
        PhasorMatrix mat = PhasorMatrix.columnMatrix(cc);
        return mat;
    }

    public double[] array_as_modulus_of_Complex() {
        Complex[] cc = this.getArray_as_Complex();
        double[] mod = new double[this.length];
        int i = 0;
        while (i < this.length) {
            mod[i] = cc[i].abs();
            ++i;
        }
        return mod;
    }

    public double[] array_as_real_part_of_Complex() {
        return this.getArray_as_real_part_of_Complex();
    }

    public double[] getArray_as_real_part_of_Complex() {
        Complex[] cc = this.getArray_as_Complex();
        double[] real = new double[this.length];
        int i = 0;
        while (i < this.length) {
            real[i] = cc[i].getReal();
            ++i;
        }
        return real;
    }

    public double[] array_as_imaginary_part_of_Complex() {
        return this.getArray_as_imaginay_part_of_Complex();
    }

    public double[] getArray_as_imaginay_part_of_Complex() {
        Complex[] cc = this.getArray_as_Complex();
        double[] imag = new double[this.length];
        int i = 0;
        while (i < this.length) {
            imag[i] = cc[i].getImag();
            ++i;
        }
        return imag;
    }

    public double[] array_as_magnitude_of_Phasor() {
        return this.getArray_as_magnitude_of_Phasor();
    }

    public double[] getArray_as_magnitude_of_Phasor() {
        Phasor[] pp = this.getArray_as_Phasor();
        double[] magn = new double[this.length];
        int i = 0;
        while (i < this.length) {
            magn[i] = pp[i].getMagnitude();
            ++i;
        }
        return magn;
    }

    public double[] array_as_degrees_phase_of_Phasor() {
        return this.getArray_as_degrees_phase_of_Phasor();
    }

    public double[] getArray_as_degrees_phase_of_Phasor() {
        Phasor[] pp = this.getArray_as_Phasor();
        double[] phased = new double[this.length];
        int i = 0;
        while (i < this.length) {
            phased[i] = pp[i].getPhaseInDegrees();
            ++i;
        }
        return phased;
    }

    public double[] array_as_radians_phase_of_Phasor() {
        return this.getArray_as_radians_phase_of_Phasor();
    }

    public double[] getArray_as_radians_phase_of_Phasor() {
        Phasor[] pp = this.getArray_as_Phasor();
        double[] phaser = new double[this.length];
        int i = 0;
        while (i < this.length) {
            phaser[i] = pp[i].getPhaseInRadians();
            ++i;
        }
        return phaser;
    }

    public double[] subarray_as_double(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double[] retArray = new double[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Double)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_double((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_double((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_double((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_double((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_double((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_double((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Double.valueOf((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_double(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Double[] subarray_as_Double(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double[] retArray = new Double[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Double)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_Double((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_Double((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_Double((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_Double((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_Double((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_Double((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_Double((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Double((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_Double(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Float[] subarray_as_Float(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float[] retArray = new Float[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_Float((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Float)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_Float((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_Float((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_Float((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_Float((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_Float((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_Float((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Float((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_Float(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public float[] subarray_as_float(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float[] retArray = new float[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_float((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Float)this.array.get(i)).floatValue();
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_float((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_float((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_float((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_float((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_float((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_float((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Float((String)this.array.get(i)).floatValue();
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_float(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public long[] subarray_as_long(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long[] retArray = new long[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_long((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_long((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Long)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_long((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_long((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_long((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_long((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_long((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Long((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_long(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Long[] subarray_as_Long(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long[] retArray = new Long[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_Long((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_Long((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Long)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_Long((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_Long((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_Long((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_Long((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_Long((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Long((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_Long(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Integer[] subarray_as_Integer(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer[] retArray = new Integer[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_Integer((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_Integer((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_Integer((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Integer)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_Integer((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_Integer((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_Integer((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Integer((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Integer(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public int[] subarray_as_int(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] retArray = new int[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_int((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_int((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_int((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Integer)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_int((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_int((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_int((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_int((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Integer((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Character)this.array.get(i)).charValue();
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public short[] subarray_as_short(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short[] retArray = new short[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_short((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_short((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_short((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_short((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Short)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_short((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_short((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_short((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Short((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_short(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Short[] subarray_as_Short(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short[] retArray = new Short[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_Short((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_Short((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_Short((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_Short((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Short)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_Short((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_Short((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_Short((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Short((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_Short(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public byte[] subarray_as_byte(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte[] retArray = new byte[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_byte((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_byte((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_byte((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_byte((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_byte((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Byte)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_byte((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_byte((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Byte((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_byte(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Byte[] subarray_as_Byte(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte[] retArray = new Byte[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_Byte((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_Byte((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_Byte((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_Byte((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_Byte((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Byte)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_Byte((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Byte((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_Byte(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public BigDecimal[] subarray_as_BigDecimal(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal[] retArray = new BigDecimal[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_BigDecimal((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_BigDecimal((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_BigDecimal((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_BigDecimal((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_BigDecimal((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_BigDecimal((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (BigDecimal)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new BigDecimal((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_BigDecimal(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public BigInteger[] subarray_as_BigInteger(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger[] retArray = new BigInteger[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Double_to_BigInteger((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Float_to_BigInteger((Float)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Long_to_BigInteger((Long)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Integer_to_BigInteger((Integer)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Short_to_BigInteger((Short)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Byte_to_BigInteger((Byte)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (BigInteger)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new BigInteger((String)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_int_to_BigInteger(((Character)this.array.get(i)).charValue());
                    ++i;
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Complex[] subarray_as_Complex(int start, int end) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Complex[] retArray = Complex.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(((Float)this.array.get(i)).doubleValue());
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(Conv.convert_Long_to_double((Long)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(Conv.convert_Integer_to_double((Integer)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(Conv.convert_Short_to_double((Short)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(Conv.convert_Byte_to_double((Byte)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 14: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Complex)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 15: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Phasor_to_Complex((Phasor)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    String ss = (String)this.array.get(i);
                    retArray[i - start] = ss.indexOf(105) != -1 || ss.indexOf(106) != -1 ? Complex.valueOf(ss) : new Complex(Double.valueOf(ss));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Complex(Conv.convert_int_to_double(((Character)this.array.get(i)).charValue()));
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Phasor[] subarray_as_Phasor(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Phasor[] retArray = Phasor.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor((Double)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(((Float)this.array.get(i)).doubleValue());
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(Conv.convert_Long_to_double((Long)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(Conv.convert_Integer_to_double((Integer)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(Conv.convert_Short_to_double((Short)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(Conv.convert_Byte_to_double((Byte)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(i)));
                    ++i;
                }
                break;
            }
            case 14: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = Conv.convert_Complex_to_Phasor((Complex)this.array.get(i));
                    ++i;
                }
                break;
            }
            case 15: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Phasor)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    String ss = ((String)this.array.get(i)).trim();
                    retArray[i - start] = ss.indexOf(60) != -1 || ss.indexOf(76) != -1 ? Phasor.valueOf(ss) : new Phasor(Double.valueOf(ss));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Phasor(Conv.convert_int_to_double(((Character)this.array.get(i)).charValue()));
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Character[] subarray_as_Character(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character[] retArray = new Character[end - start + 1];
        switch (this.type) {
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = new Character((char)((Integer)this.array.get(i)).intValue());
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (Character)this.array.get(i);
                    ++i;
                }
                break;
            }
            case 18: {
                boolean test2 = true;
                String[] ss = new String[end - start + 1];
                int i = start;
                while (i <= end) {
                    ss[i - start] = ((String)this.array.get(i)).trim();
                    if (ss[i - start].length() > 1) {
                        test2 = false;
                        break;
                    }
                    ++i;
                }
                if (test2) {
                    i = start;
                    while (i <= end) {
                        retArray[i - start] = new Character(ss[i - start].charAt(0));
                        ++i;
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to Character");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public char[] subarray_as_char(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char[] retArray = new char[end - start + 1];
        switch (this.type) {
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (char)((Integer)this.array.get(i)).intValue();
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Character)this.array.get(i)).charValue();
                    ++i;
                }
                break;
            }
            case 18: {
                boolean test2 = true;
                String[] ss = new String[end - start + 1];
                int i = start;
                while (i <= end) {
                    ss[i - start] = ((String)this.array.get(i)).trim();
                    if (ss[i - start].length() > 1) {
                        test2 = false;
                        break;
                    }
                    ++i;
                }
                if (test2) {
                    i = start;
                    while (i <= end) {
                        retArray[i - start] = ss[i - start].charAt(0);
                        ++i;
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to char");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public String[] subarray_as_String(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        String[] retArray = new String[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Double)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Float)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Long)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Integer)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Short)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Byte)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 12: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((BigDecimal)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 13: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((BigInteger)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 14: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Complex)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 15: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Phasor)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = ((Character)this.array.get(i)).toString();
                    ++i;
                }
                break;
            }
            case 18: {
                int i = start;
                while (i <= end) {
                    retArray[i - start] = (String)this.array.get(i);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return retArray;
    }

    public Object[] subarray_as_Object(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Object[] arrayo = new Object[end - start + 1];
        int i = start;
        while (i <= end) {
            arrayo[i - start] = this.array.get(i);
            ++i;
        }
        return arrayo;
    }

    public Vector<Object> subarray_as_Vector(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Vector<Object> vec = new Vector<Object>(end - start + 1);
        int i = start;
        while (i <= end) {
            vec.addElement(this.array.get(i));
            ++i;
        }
        return vec;
    }

    public ArrayList<Object> subarray_as_ArrayList(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        ArrayList<Object> arrayl = new ArrayList<Object>(end - start + 1);
        int i = start;
        while (i <= end) {
            arrayl.add(this.array.get(i));
            ++i;
        }
        return arrayl;
    }

    public Matrix subarray_as_Matrix_rowMatrix(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix mat = null;
        double[] retArray = new double[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = start;
                while (i <= end) {
                    retArray[i - start] = dd[i];
                    ++i;
                }
                mat = Matrix.rowMatrix(retArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.rowMatrix - use method subarray_as_Complex_rowMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.rowMatrix - use method subarray_as_Phasor_rowMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return mat;
    }

    public Matrix subarray_as_Matrix_columnMatrix(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix mat = null;
        double[] retArray = new double[end - start + 1];
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = start;
                while (i <= end) {
                    retArray[i - start] = dd[i];
                    ++i;
                }
                mat = Matrix.columnMatrix(retArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.columnMatrix - use method subarray_as_Complex_columnMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.columnMatrix - use method subarray_as_Phasor_columnMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return mat;
    }

    public ComplexMatrix subarray_as_Complex_rowMatrix(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] cc = this.getArray_as_Complex();
        Complex[] retArray = new Complex[end - start + 1];
        int i = start;
        while (i <= end) {
            retArray[i - start] = cc[i];
            ++i;
        }
        ComplexMatrix mat = ComplexMatrix.rowMatrix(retArray);
        return mat;
    }

    public ComplexMatrix subarray_as_Complex_columnMatrix(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] cc = this.getArray_as_Complex();
        Complex[] retArray = new Complex[end - start + 1];
        int i = start;
        while (i <= end) {
            retArray[i - start] = cc[i];
            ++i;
        }
        ComplexMatrix mat = ComplexMatrix.columnMatrix(retArray);
        return mat;
    }

    public PhasorMatrix subarray_as_Phasor_rowMatrix(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] pp = this.getArray_as_Phasor();
        Phasor[] retArray = new Phasor[end - start + 1];
        int i = start;
        while (i <= end) {
            retArray[i - start] = pp[i];
            ++i;
        }
        PhasorMatrix mat = PhasorMatrix.rowMatrix(retArray);
        return mat;
    }

    public PhasorMatrix subarray_as_Phasor_columnMatrix(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] pp = this.getArray_as_Phasor();
        Phasor[] retArray = new Phasor[end - start + 1];
        int i = start;
        while (i <= end) {
            retArray[i - start] = pp[i];
            ++i;
        }
        PhasorMatrix mat = PhasorMatrix.columnMatrix(retArray);
        return mat;
    }

    public double[] subarray_as_modulus_of_Complex(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] cc = this.getArray_as_Complex();
        double[] real = new double[end - start + 1];
        int i = start;
        while (i <= end) {
            real[i - start] = cc[i].abs();
            ++i;
        }
        return real;
    }

    public double[] subarray_as_real_part_of_Complex(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] cc = this.getArray_as_Complex();
        double[] real = new double[end - start + 1];
        int i = start;
        while (i <= end) {
            real[i - start] = cc[i].getReal();
            ++i;
        }
        return real;
    }

    public double[] subarray_as_imaginay_part_of_Complex(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] cc = this.getArray_as_Complex();
        double[] imag = new double[end - start + 1];
        int i = start;
        while (i <= end) {
            imag[i - start] = cc[i].getImag();
            ++i;
        }
        return imag;
    }

    public double[] subarray_as_magnitude_of_Phasor(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] pp = this.getArray_as_Phasor();
        double[] magn = new double[end - start + 1];
        int i = start;
        while (i <= end) {
            magn[i - start] = pp[i].getMagnitude();
            ++i;
        }
        return magn;
    }

    public double[] subarray_as_degrees_phase_of_Phasor(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] pp = this.getArray_as_Phasor();
        double[] phased = new double[end - start + 1];
        int i = start;
        while (i <= end) {
            phased[i - start] = pp[i].getPhaseInDegrees();
            ++i;
        }
        return phased;
    }

    public double[] subarray_as_radians_phase_of_Phasor(int start, int end) {
        if (end >= this.length) {
            throw new IllegalArgumentException("end, " + end + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] pp = this.getArray_as_Phasor();
        double[] phaser = new double[end - start + 1];
        int i = start;
        while (i <= end) {
            phaser[i - start] = pp[i].getPhaseInRadians();
            ++i;
        }
        return phaser;
    }

    protected void minmax() {
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(this.getArray_as_Object(), this.minmax, maxminIndices, this.typeName, this.type);
        this.maxIndex = maxminIndices[0];
        this.minIndex = maxminIndices[1];
    }

    protected static void findMinMax(Object[] arrayo, ArrayList<Object> minmaxx, int[] maxminIndices, String[] aTypeName, int aType) {
        int maxIndexx = 0;
        int minIndexx = 0;
        int arraylength = arrayo.length;
        switch (aType) {
            case 0: 
            case 1: {
                double[] arrayD = new double[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayD[i] = (Double)arrayo[i];
                    ++i;
                }
                double amaxD = arrayD[0];
                double aminD = arrayD[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i2 = 1;
                while (i2 < arraylength) {
                    if (arrayD[i2] > amaxD) {
                        amaxD = arrayD[i2];
                        maxIndexx = i2;
                    }
                    if (arrayD[i2] < aminD) {
                        aminD = arrayD[i2];
                        minIndexx = i2;
                    }
                    ++i2;
                }
                minmaxx.add(new Double(amaxD));
                minmaxx.add(new Double(aminD));
                break;
            }
            case 4: 
            case 5: {
                long[] arrayL = new long[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayL[i] = (Long)arrayo[i];
                    ++i;
                }
                long amaxL = arrayL[0];
                long aminL = arrayL[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i3 = 1;
                while (i3 < arraylength) {
                    if (arrayL[i3] > amaxL) {
                        amaxL = arrayL[i3];
                        maxIndexx = i3;
                    }
                    if (arrayL[i3] < aminL) {
                        aminL = arrayL[i3];
                        minIndexx = i3;
                    }
                    ++i3;
                }
                minmaxx.add(new Long(amaxL));
                minmaxx.add(new Long(aminL));
                break;
            }
            case 2: 
            case 3: {
                float[] arrayF = new float[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayF[i] = ((Float)arrayo[i]).floatValue();
                    ++i;
                }
                float amaxF = arrayF[0];
                float aminF = arrayF[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i4 = 1;
                while (i4 < arraylength) {
                    if (arrayF[i4] > amaxF) {
                        amaxF = arrayF[i4];
                        maxIndexx = i4;
                    }
                    if (arrayF[i4] < aminF) {
                        aminF = arrayF[i4];
                        minIndexx = i4;
                    }
                    ++i4;
                }
                minmaxx.add(new Float(amaxF));
                minmaxx.add(new Float(aminF));
                break;
            }
            case 6: 
            case 7: {
                int[] arrayI = new int[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayI[i] = (Integer)arrayo[i];
                    ++i;
                }
                int amaxI = arrayI[0];
                int aminI = arrayI[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i5 = 1;
                while (i5 < arraylength) {
                    if (arrayI[i5] > amaxI) {
                        amaxI = arrayI[i5];
                        maxIndexx = i5;
                    }
                    if (arrayI[i5] < aminI) {
                        aminI = arrayI[i5];
                        minIndexx = i5;
                    }
                    ++i5;
                }
                minmaxx.add(new Integer(amaxI));
                minmaxx.add(new Integer(aminI));
                break;
            }
            case 8: 
            case 9: {
                short[] arrayS = new short[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayS[i] = (Short)arrayo[i];
                    ++i;
                }
                short amaxS = arrayS[0];
                short aminS = arrayS[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i6 = 1;
                while (i6 < arraylength) {
                    if (arrayS[i6] > amaxS) {
                        amaxS = arrayS[i6];
                        maxIndexx = i6;
                    }
                    if (arrayS[i6] < aminS) {
                        aminS = arrayS[i6];
                        minIndexx = i6;
                    }
                    ++i6;
                }
                minmaxx.add(new Short(amaxS));
                minmaxx.add(new Short(aminS));
                break;
            }
            case 10: 
            case 11: {
                byte[] arrayB = new byte[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayB[i] = (Byte)arrayo[i];
                    ++i;
                }
                byte amaxB = arrayB[0];
                byte aminB = arrayB[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i7 = 1;
                while (i7 < arraylength) {
                    if (arrayB[i7] > amaxB) {
                        amaxB = arrayB[i7];
                        maxIndexx = i7;
                    }
                    if (arrayB[i7] < aminB) {
                        aminB = arrayB[i7];
                        minIndexx = i7;
                    }
                    ++i7;
                }
                minmaxx.add(new Byte(amaxB));
                minmaxx.add(new Byte(aminB));
                break;
            }
            case 12: {
                BigDecimal[] arrayBD = new BigDecimal[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayBD[i] = (BigDecimal)arrayo[i];
                    ++i;
                }
                BigDecimal amaxBD = arrayBD[0];
                BigDecimal aminBD = arrayBD[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i8 = 1;
                while (i8 < arraylength) {
                    if (arrayBD[i8].compareTo(amaxBD) == 1) {
                        amaxBD = arrayBD[i8];
                        maxIndexx = i8;
                    }
                    if (arrayBD[i8].compareTo(aminBD) == -1) {
                        aminBD = arrayBD[i8];
                        minIndexx = i8;
                    }
                    ++i8;
                }
                minmaxx.add(amaxBD);
                minmaxx.add(aminBD);
                break;
            }
            case 13: {
                BigInteger[] arrayBI = new BigInteger[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayBI[i] = (BigInteger)arrayo[i];
                    ++i;
                }
                BigInteger amaxBI = arrayBI[0];
                BigInteger aminBI = arrayBI[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i9 = 1;
                while (i9 < arraylength) {
                    if (arrayBI[i9].compareTo(amaxBI) == 1) {
                        amaxBI = arrayBI[i9];
                        maxIndexx = i9;
                    }
                    if (arrayBI[i9].compareTo(aminBI) == -1) {
                        aminBI = arrayBI[i9];
                        minIndexx = i9;
                    }
                    ++i9;
                }
                minmaxx.add(amaxBI);
                minmaxx.add(aminBI);
                break;
            }
            case 16: 
            case 17: {
                int[] arrayInt = new int[arraylength];
                int i = 0;
                while (i < arraylength) {
                    arrayInt[i] = ((Character)arrayo[i]).charValue();
                    ++i;
                }
                int amaxInt = arrayInt[0];
                int aminInt = arrayInt[0];
                maxIndexx = 0;
                minIndexx = 0;
                int i10 = 1;
                while (i10 < arraylength) {
                    if (arrayInt[i10] > amaxInt) {
                        amaxInt = arrayInt[i10];
                        maxIndexx = i10;
                    }
                    if (arrayInt[i10] < aminInt) {
                        aminInt = arrayInt[i10];
                        minIndexx = i10;
                    }
                    ++i10;
                }
                minmaxx.add(new Character((char)amaxInt));
                minmaxx.add(new Character((char)aminInt));
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                System.out.println("ArrayMaths:  getMaximum_... or getMinimum_... (findMinMax): the " + aTypeName[aType] + " is not a numerical type for which a maximum or a minimum is meaningful/supported");
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        maxminIndices[0] = maxIndexx;
        maxminIndices[1] = minIndexx;
    }

    public double maximum() {
        return this.getMaximum_as_double();
    }

    public double maximum_as_double() {
        return this.getMaximum_as_double();
    }

    public double getMaximum() {
        return this.getMaximum_as_double();
    }

    public double getMaximum_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double max2 = 0.0;
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = (Double)this.minmax.get(0);
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_double((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_double((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_double((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_double((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_double((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_double((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_double((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public Double maximum_as_Double() {
        return this.getMaximum_as_Double();
    }

    public Double getMaximum_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double max2 = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = (Double)this.minmax.get(0);
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_Double((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_Double((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_Double((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_Double((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_Double((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_Double((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_Double((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public Float maximum_as_Float() {
        return this.getMaximum_as_Float();
    }

    public Float getMaximum_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float max2 = new Float(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_Float((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = (Float)this.minmax.get(0);
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_Float((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_Float((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_Float((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_Float((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_Float((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_Float((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public float maximum_as_float() {
        return this.getMaximum_as_float();
    }

    public float getMaximum_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float max2 = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_float((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = ((Float)this.minmax.get(0)).floatValue();
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_float((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_float((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_float((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_float((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_float((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_float((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public long maximum_as_long() {
        return this.getMaximum_as_long();
    }

    public long getMaximum_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long max2 = 0L;
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_long((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_long((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = (Long)this.minmax.get(0);
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_long((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_long((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_long((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_long((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_long((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public Long maximum_as_Long() {
        return this.getMaximum_as_Long();
    }

    public Long getMaximum_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long max2 = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_Long((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_Long((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = (Long)this.minmax.get(0);
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_Long((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_Long((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_Long((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_Long((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_Long((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public int maximum_as_int() {
        return this.getMaximum_as_int();
    }

    public int getMaximum_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int max2 = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_int((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_int((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_int((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = (Integer)this.minmax.get(0);
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_int((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_int((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_int((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_int((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public Integer maximum_as_Integer() {
        return this.getMaximum_as_Integer();
    }

    public Integer getMaximum_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer max2 = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_Integer((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_Integer((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_Integer((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = (Integer)this.minmax.get(0);
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_Integer((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_Integer((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_Integer((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public short maximum_as_short() {
        return this.getMaximum_as_short();
    }

    public short getMaximum_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short max2 = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_short((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_short((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_short((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_short((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = (Short)this.minmax.get(0);
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_short((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_short((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_short((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public Short maximum_as_Short() {
        return this.getMaximum_as_Short();
    }

    public Short getMaximum_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short max2 = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_Short((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_Short((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_Short((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_Short((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = (Short)this.minmax.get(0);
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_Short((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_Short((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_Short((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public byte maximum_as_byte() {
        return this.getMaximum_as_byte();
    }

    public byte getMaximum_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte max2 = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_byte((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_byte((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_byte((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_byte((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_byte((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = (Byte)this.minmax.get(0);
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_byte((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_byte((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public Byte maximum_as_Byte() {
        return this.getMaximum_as_Byte();
    }

    public Byte getMaximum_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte max2 = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_Byte((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_Byte((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_Byte((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_Byte((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_Byte((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = (Byte)this.minmax.get(0);
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_Byte((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public BigDecimal maximum_as_BigDecimal() {
        return this.getMaximum_as_BigDecimal();
    }

    public BigDecimal getMaximum_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal max2 = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_BigDecimal((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_BigDecimal((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_BigDecimal((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_BigDecimal((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_BigDecimal((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_BigDecimal((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = (BigDecimal)this.minmax.get(0);
                break;
            }
            case 13: {
                max2 = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public BigInteger maximum_as_BigInteger() {
        return this.getMaximum_as_BigInteger();
    }

    public BigInteger getMaximum_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger max2 = new BigInteger("0");
        switch (this.type) {
            case 0: 
            case 1: {
                max2 = Conv.convert_Double_to_BigInteger((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                max2 = Conv.convert_Float_to_BigInteger((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                max2 = Conv.convert_Long_to_BigInteger((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                max2 = Conv.convert_Integer_to_BigInteger((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                max2 = Conv.convert_Short_to_BigInteger((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                max2 = Conv.convert_Byte_to_BigInteger((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                max2 = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                max2 = (BigInteger)this.minmax.get(0);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public char maximum_as_char() {
        return this.getMaximum_as_char();
    }

    public char getMaximum_as_char() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char max2 = '\u0000';
        switch (this.type) {
            case 6: 
            case 7: {
                max2 = (char)((Integer)this.minmax.get(1)).intValue();
                break;
            }
            case 16: 
            case 17: {
                max2 = ((Character)this.minmax.get(1)).charValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a char type maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public Character maximum_as_Character() {
        return this.getMaximum_as_Character();
    }

    public Character getMaximum_as_Character() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character max2 = new Character('\u0000');
        switch (this.type) {
            case 6: 
            case 7: {
                max2 = new Character((char)((Integer)this.minmax.get(1)).intValue());
                break;
            }
            case 16: 
            case 17: {
                max2 = (Character)this.minmax.get(1);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a Character type maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return max2;
    }

    public double minimum() {
        return this.getMinimum_as_double();
    }

    public double minimum_as_double() {
        return this.getMinimum_as_double();
    }

    public double getMinimum() {
        return this.getMinimum_as_double();
    }

    public double getMinimum_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double min2 = 0.0;
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = (Double)this.minmax.get(1);
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_double((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_double((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_double((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_double((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_double((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_double((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_double((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public Double minimum_as_Double() {
        return this.getMinimum_as_Double();
    }

    public Double getMinimum_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double min2 = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = (Double)this.minmax.get(1);
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_Double((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_Double((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_Double((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_Double((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_Double((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_Double((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_Double((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public Float minimum_as_Float() {
        return this.getMinimum_as_Float();
    }

    public Float getMinimum_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float min2 = new Float(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_Float((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = (Float)this.minmax.get(1);
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_Float((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_Float((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_Float((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_Float((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_Float((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_Float((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public float minimum_as_float() {
        return this.getMinimum_as_float();
    }

    public float getMinimum_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float min2 = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_float((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = ((Float)this.minmax.get(1)).floatValue();
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_float((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_float((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_float((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_float((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_float((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_float((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public long minimum_as_long() {
        return this.getMinimum_as_long();
    }

    public long getMinimum_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long min2 = 0L;
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_long((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_long((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = (Long)this.minmax.get(1);
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_long((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_long((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_long((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_long((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_long((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public Long minimum_as_Long() {
        return this.getMinimum_as_Long();
    }

    public Long getMinimum_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long min2 = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_Long((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_Long((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = (Long)this.minmax.get(1);
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_Long((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_Long((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_Long((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_Long((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_Long((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public int minimum_as_int() {
        return this.getMinimum_as_int();
    }

    public int getMinimum_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int min2 = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_int((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_int((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_int((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = (Integer)this.minmax.get(1);
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_int((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_int((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_int((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_int((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public Integer minimum_as_Integer() {
        return this.getMinimum_as_Integer();
    }

    public Integer getMinimum_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer min2 = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_Integer((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_Integer((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_Integer((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = (Integer)this.minmax.get(1);
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_Integer((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_Integer((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_Integer((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public short minimum_as_short() {
        return this.getMinimum_as_short();
    }

    public short getMinimum_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short min2 = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_short((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_short((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_short((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_short((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = (Short)this.minmax.get(1);
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_short((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_short((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_short((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public Short minimum_as_Short() {
        return this.getMinimum_as_Short();
    }

    public Short getMinimum_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short min2 = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_Short((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_Short((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_Short((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_Short((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = (Short)this.minmax.get(1);
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_Short((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_Short((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_Short((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public byte minimum_as_byte() {
        return this.getMinimum_as_byte();
    }

    public byte getMinimum_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte min2 = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_byte((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_byte((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_byte((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_byte((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_byte((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = (Byte)this.minmax.get(1);
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_byte((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_byte((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public Byte minimum_as_Byte() {
        return this.getMinimum_as_Byte();
    }

    public Byte getMinimum_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte min2 = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_Byte((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_Byte((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_Byte((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_Byte((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_Byte((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = (Byte)this.minmax.get(1);
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_Byte((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public BigDecimal minimum_as_BigDecimal() {
        return this.getMinimum_as_BigDecimal();
    }

    public BigDecimal getMinimum_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal min2 = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_BigDecimal((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_BigDecimal((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_BigDecimal((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_BigDecimal((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_BigDecimal((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_BigDecimal((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = (BigDecimal)this.minmax.get(1);
                break;
            }
            case 13: {
                min2 = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public BigInteger minimum_as_BigInteger() {
        return this.getMinimum_as_BigInteger();
    }

    public BigInteger getMinimum_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger min2 = new BigInteger("0");
        switch (this.type) {
            case 0: 
            case 1: {
                min2 = Conv.convert_Double_to_BigInteger((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                min2 = Conv.convert_Float_to_BigInteger((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                min2 = Conv.convert_Long_to_BigInteger((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                min2 = Conv.convert_Integer_to_BigInteger((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                min2 = Conv.convert_Short_to_BigInteger((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                min2 = Conv.convert_Byte_to_BigInteger((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                min2 = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                min2 = (BigInteger)this.minmax.get(1);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public char minimum_as_char() {
        return this.getMinimum_as_char();
    }

    public char getMinimum_as_char() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char min2 = '\u0000';
        switch (this.type) {
            case 6: 
            case 7: {
                min2 = (char)((Integer)this.minmax.get(1)).intValue();
                break;
            }
            case 16: 
            case 17: {
                min2 = ((Character)this.minmax.get(1)).charValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a char type minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public Character minimum_as_Character() {
        return this.getMinimum_as_Character();
    }

    public Character getMinimum_as_Character() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character min2 = new Character('\u0000');
        switch (this.type) {
            case 6: 
            case 7: {
                min2 = new Character((char)((Integer)this.minmax.get(1)).intValue());
                break;
            }
            case 16: 
            case 17: {
                min2 = (Character)this.minmax.get(1);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a Character type minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return min2;
    }

    public int maximumIndex() {
        return this.maxIndex;
    }

    public int getMaximumIndex() {
        return this.maxIndex;
    }

    public int minimumIndex() {
        return this.minIndex;
    }

    public int getMinimumIndex() {
        return this.minIndex;
    }

    public boolean isInteger() {
        boolean test2 = false;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                double[] arrayd = this.getArray_as_double();
                test2 = Fmath.isInteger(arrayd);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                test2 = true;
                break;
            }
            case 12: {
                Number[] arraybd = this.getArray_as_BigDecimal();
                test2 = Fmath.isInteger(arraybd);
                break;
            }
            case 14: 
            case 15: {
                test2 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        return test2;
    }

    public ArrayMaths plus(double constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal(constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigDecimal hold2 = new BigDecimal(hold1).add(new BigDecimal(constant));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Double.toString(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Double constant) {
        return this.plus((double)constant);
    }

    public ArrayMaths plus(double[] arrayD) {
        if (this.length != arrayD.length) {
            throw new IllegalArgumentException("The length of the argument array, " + arrayD.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + arrayD[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal(arrayD[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigDecimal hold2 = new BigDecimal(hold1).add(new BigDecimal(arrayD[i]));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(arrayD[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(arrayD[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Double.toString(arrayD[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Double[] arrayD) {
        int nArg = arrayD.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] arrayd = new double[this.length];
        int i = 0;
        while (i < this.length) {
            arrayd[i] = arrayD[i];
            ++i;
        }
        return this.plus(arrayd);
    }

    public ArrayMaths plus(float constant) {
        double constantd = constant;
        return this.plus(constantd);
    }

    public ArrayMaths plus(Float constant) {
        return this.plus(constant.floatValue());
    }

    public ArrayMaths plus(float[] arrayF) {
        if (this.length != arrayF.length) {
            throw new IllegalArgumentException("The length of the argument array, " + arrayF.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        double[] arrayD = new double[this.length];
        int i = 0;
        while (i < this.length) {
            arrayD[i] = arrayF[i];
            ++i;
        }
        return this.plus(arrayD);
    }

    public ArrayMaths plus(Float[] arrayF) {
        int nArg = arrayF.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] arrayd = new double[this.length];
        int i = 0;
        while (i < this.length) {
            arrayd[i] = arrayF[i].doubleValue();
            ++i;
        }
        return this.plus(arrayd);
    }

    public ArrayMaths plus(long constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Long.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Long.toString(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Long constant) {
        long constantl = constant;
        return this.plus(constantl);
    }

    public ArrayMaths plus(long[] arrayL) {
        int nArg = arrayL.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)arrayL[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long max1 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayL);
                long max2 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max1 >= max2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + arrayL[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)arrayL[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)arrayL[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Long.toString(arrayL[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(arrayL[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(arrayL[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Long.toString(arrayL[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Long[] arrayL) {
        int nArg = arrayL.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        long[] arrayl = new long[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayL[i];
            ++i;
        }
        return this.plus(arrayl);
    }

    public ArrayMaths plus(int constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int maxi = this.getMaximum_as_int();
                int[] lll = this.getArray_as_int();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] + constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Integer.toString(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Integer constant) {
        int constantl = constant;
        return this.plus(constantl);
    }

    public ArrayMaths plus(int[] arrayI) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayI);
                long max22 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= max22) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + (long)arrayI[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int maxi = this.getMaximum_as_int();
                ArrayMaths am22 = new ArrayMaths(arrayI);
                int maxi2 = am22.getMaximum_as_int();
                int[] lll = this.getArray_as_int();
                if (Integer.MAX_VALUE - maxi >= maxi2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] + arrayI[i]));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)arrayI[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Integer.toString(arrayI[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(arrayI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Integer.toString(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Integer[] arrayI) {
        int nArg = arrayI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        int[] arrayl = new int[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayI[i];
            ++i;
        }
        return this.plus(arrayl);
    }

    public ArrayMaths plus(short constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short maxi = this.getMaximum_as_short();
                short[] lll = this.getArray_as_short();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] + constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Integer.toString(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Short constant) {
        short constantl = constant;
        return this.plus(constantl);
    }

    public ArrayMaths plus(short[] arrayI) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayI);
                long max22 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= max22) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + (long)arrayI[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short maxi = this.getMaximum_as_short();
                ArrayMaths am22 = new ArrayMaths(arrayI);
                short maxi2 = am22.getMaximum_as_short();
                short[] lll = this.getArray_as_short();
                if (Integer.MAX_VALUE - maxi >= maxi2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] + arrayI[i]));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)arrayI[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Integer.toString(arrayI[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(arrayI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Integer.toString(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Short[] arrayI) {
        int nArg = arrayI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        short[] arrayl = new short[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayI[i];
            ++i;
        }
        return this.plus(arrayl);
    }

    public ArrayMaths plus(BigDecimal constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(constant));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(constant.doubleValue()));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(new Phasor(constant.doubleValue())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + constant.toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(byte constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte maxi = this.getMaximum_as_byte();
                byte[] lll = this.getArray_as_byte();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] + constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] + (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Integer.toString(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Byte constant) {
        byte constantl = constant;
        return this.plus(constantl);
    }

    public ArrayMaths plus(byte[] arrayI) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayI);
                long max22 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= max22) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] + (long)arrayI[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte maxi = this.getMaximum_as_byte();
                ArrayMaths am22 = new ArrayMaths(arrayI);
                byte maxi2 = am22.getMaximum_as_byte();
                byte[] lll = this.getArray_as_byte();
                if (Integer.MAX_VALUE - maxi >= maxi2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] + arrayI[i]));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] + (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.add(new BigDecimal((double)arrayI[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.add(new BigInteger(Integer.toString(arrayI[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).plus(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).plus(new Phasor(arrayI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + Integer.toString(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Byte[] arrayI) {
        int nArg = arrayI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        byte[] arrayl = new byte[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayI[i];
            ++i;
        }
        return this.plus(arrayl);
    }

    public ArrayMaths plus(BigDecimal[] arrayBD) {
        int nArg = arrayBD.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(arrayBD[i]));
                    ++i;
                }
                Conv.restoreMessages();
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(arrayBD[i].doubleValue()));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(new Phasor(arrayBD[i].doubleValue())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + arrayBD[i].toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(BigInteger constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                BigDecimal constantBD = Conv.convert_BigInteger_to_BigDecimal(constant);
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(constantBD));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].add(constant));
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(Conv.convert_BigInteger_to_double(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(new Phasor(Conv.convert_BigInteger_to_double(constant))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + constant.toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(BigInteger[] arrayBI) {
        int nArg = arrayBI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(Conv.convert_BigInteger_to_BigDecimal(arrayBI[i])));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].add(arrayBI[i]));
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(Conv.convert_BigInteger_to_double(arrayBI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(new Phasor(Conv.convert_BigInteger_to_double(arrayBI[i]))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + arrayBI[i].toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Complex constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(constant));
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(Conv.convert_Complex_to_Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + constant.toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Complex[] arrayC) {
        int nArg = arrayC.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(arrayC[i]));
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(Conv.convert_Complex_to_Phasor(arrayC[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + arrayC[i].toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Phasor constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(constant));
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(Conv.convert_Phasor_to_Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + constant.toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Phasor[] arrayP) {
        int nArg = arrayP.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].plus(arrayP[i]));
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].plus(Conv.convert_Phasor_to_Complex(arrayP[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf((String)this.array.get(i)) + arrayP[i].toString());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(String constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] ss = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf(ss[i]) + constant);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(String[] arraySt) {
        int nArg = arraySt.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] ss = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf(ss[i]) + arraySt[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(char constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] ss = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf(ss[i]) + constant);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(char[] arrayCh) {
        int nArg = arrayCh.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] ss = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf(ss[i]) + arrayCh[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Character constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] ss = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf(ss[i]) + constant);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths plus(Character[] arrayCh) {
        int nArg = arrayCh.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] ss = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(String.valueOf(ss[i]) + arrayCh[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        return am;
    }

    public ArrayMaths plus(Vector<Object> vec) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am1 = new ArrayMaths();
        ArrayMaths am2 = new ArrayMaths(vec);
        switch (am2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = am2.getArray_as_double();
                am1 = this.plus(dd);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] ll = am2.getArray_as_long();
                am1 = this.plus(ll);
                break;
            }
            case 12: {
                BigDecimal[] bd = am2.getArray_as_BigDecimal();
                am1 = this.plus(bd);
                break;
            }
            case 13: {
                BigInteger[] bi = am2.getArray_as_BigInteger();
                am1 = this.plus(bi);
                break;
            }
            case 14: {
                Complex[] cc = am2.getArray_as_Complex();
                am1 = this.plus(cc);
                break;
            }
            case 15: {
                Phasor[] pp = am2.getArray_as_Phasor();
                am1 = this.plus(pp);
                break;
            }
            case 16: 
            case 17: {
                Character[] ct = am2.getArray_as_Character();
                am1 = this.plus(ct);
                break;
            }
            case 18: {
                String[] st = am2.getArray_as_String();
                am1 = this.plus(st);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am1.getArray_as_Object(), am1.minmax, maxminIndices, am1.typeName, am1.type);
        am1.maxIndex = maxminIndices[0];
        am1.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am1;
    }

    public ArrayMaths plus(ArrayList<Object> list2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am1 = new ArrayMaths();
        ArrayMaths am2 = new ArrayMaths(list2);
        switch (am2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = am2.getArray_as_double();
                am1 = this.plus(dd);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] ll = am2.getArray_as_long();
                am1 = this.plus(ll);
                break;
            }
            case 12: {
                BigDecimal[] bd = am2.getArray_as_BigDecimal();
                am1 = this.plus(bd);
                break;
            }
            case 13: {
                BigInteger[] bi = am2.getArray_as_BigInteger();
                am1 = this.plus(bi);
                break;
            }
            case 14: {
                Complex[] cc = am2.getArray_as_Complex();
                am1 = this.plus(cc);
                break;
            }
            case 15: {
                Phasor[] pp = am2.getArray_as_Phasor();
                am1 = this.plus(pp);
                break;
            }
            case 16: 
            case 17: {
                Character[] ct = am2.getArray_as_Character();
                am1 = this.plus(ct);
                break;
            }
            case 18: {
                String[] st = am2.getArray_as_String();
                am1 = this.plus(st);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am1.getArray_as_Object(), am1.minmax, maxminIndices, am1.typeName, am1.type);
        am1.maxIndex = maxminIndices[0];
        am1.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am1;
    }

    public ArrayMaths plus(ArrayMaths arrayM) {
        ArrayList<Object> arrayl = arrayM.getArray_as_ArrayList();
        return this.plus(arrayl);
    }

    public ArrayMaths plus(Stat arrayS) {
        ArrayList<Object> arrayl = arrayS.getArray_as_ArrayList();
        return this.plus(arrayl);
    }

    public ArrayMaths minus(double constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal(constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigDecimal hold2 = new BigDecimal(hold1).subtract(new BigDecimal(constant));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Double constant) {
        return this.minus((double)constant);
    }

    public ArrayMaths minus(double[] arrayD) {
        if (this.length != arrayD.length) {
            throw new IllegalArgumentException("The length of the argument array, " + arrayD.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - arrayD[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal(arrayD[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigDecimal hold2 = new BigDecimal(hold1).subtract(new BigDecimal(arrayD[i]));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(arrayD[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(arrayD[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Double[] arrayD) {
        int nArg = arrayD.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] arrayd = new double[this.length];
        int i = 0;
        while (i < this.length) {
            arrayd[i] = arrayD[i];
            ++i;
        }
        return this.minus(arrayd);
    }

    public ArrayMaths minus(float constant) {
        double constantd = constant;
        return this.minus(constantd);
    }

    public ArrayMaths minus(Float constant) {
        return this.minus(constant.floatValue());
    }

    public ArrayMaths minus(float[] arrayF) {
        if (this.length != arrayF.length) {
            throw new IllegalArgumentException("The length of the argument array, " + arrayF.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        double[] arrayD = new double[this.length];
        int i = 0;
        while (i < this.length) {
            arrayD[i] = arrayF[i];
            ++i;
        }
        return this.minus(arrayD);
    }

    public ArrayMaths minus(Float[] arrayF) {
        int nArg = arrayF.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] arrayd = new double[this.length];
        int i = 0;
        while (i < this.length) {
            arrayd[i] = arrayF[i].doubleValue();
            ++i;
        }
        return this.minus(arrayd);
    }

    public ArrayMaths minus(long constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Long.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Long constant) {
        long constantl = constant;
        return this.minus(constantl);
    }

    public ArrayMaths minus(long[] arrayL) {
        int nArg = arrayL.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)arrayL[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long max1 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayL);
                long max2 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max1 >= max2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - arrayL[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)arrayL[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)arrayL[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Long.toString(arrayL[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(arrayL[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(arrayL[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Long[] arrayL) {
        int nArg = arrayL.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        long[] arrayl = new long[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayL[i];
            ++i;
        }
        return this.minus(arrayl);
    }

    public ArrayMaths minus(int constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int maxi = this.getMaximum_as_int();
                int[] lll = this.getArray_as_int();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] - constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Integer constant) {
        int constantl = constant;
        return this.minus(constantl);
    }

    public ArrayMaths minus(int[] arrayI) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayI);
                long max22 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= max22) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - (long)arrayI[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int maxi = this.getMaximum_as_int();
                ArrayMaths am22 = new ArrayMaths(arrayI);
                int maxi2 = am22.getMaximum_as_int();
                int[] lll = this.getArray_as_int();
                if (Integer.MAX_VALUE - maxi >= maxi2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] - arrayI[i]));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)arrayI[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Integer.toString(arrayI[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(arrayI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Integer[] arrayI) {
        int nArg = arrayI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        int[] arrayl = new int[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayI[i];
            ++i;
        }
        return this.minus(arrayl);
    }

    public ArrayMaths minus(short constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short maxi = this.getMaximum_as_short();
                short[] lll = this.getArray_as_short();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] - constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Short constant) {
        short constantl = constant;
        return this.minus(constantl);
    }

    public ArrayMaths minus(short[] arrayI) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayI);
                long max22 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= max22) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - (long)arrayI[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short maxi = this.getMaximum_as_short();
                ArrayMaths am22 = new ArrayMaths(arrayI);
                short maxi2 = am22.getMaximum_as_short();
                short[] lll = this.getArray_as_short();
                if (Integer.MAX_VALUE - maxi >= maxi2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] - arrayI[i]));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)arrayI[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Integer.toString(arrayI[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(arrayI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Short[] arrayI) {
        int nArg = arrayI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        short[] arrayl = new short[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayI[i];
            ++i;
        }
        return this.minus(arrayl);
    }

    public ArrayMaths minus(BigDecimal constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].subtract(constant));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(constant.doubleValue()));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(new Phasor(constant.doubleValue())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(byte constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte maxi = this.getMaximum_as_byte();
                byte[] lll = this.getArray_as_byte();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] - constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] - (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Byte constant) {
        byte constantl = constant;
        return this.minus(constantl);
    }

    public ArrayMaths minus(byte[] arrayI) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                ArrayMaths am2 = new ArrayMaths(arrayI);
                long max22 = am2.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= max22) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] - (long)arrayI[i]));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte maxi = this.getMaximum_as_byte();
                ArrayMaths am22 = new ArrayMaths(arrayI);
                byte maxi2 = am22.getMaximum_as_byte();
                byte[] lll = this.getArray_as_byte();
                if (Integer.MAX_VALUE - maxi >= maxi2) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] - arrayI[i]));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] - (double)arrayI[i]));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.subtract(new BigDecimal((double)arrayI[i]));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.subtract(new BigInteger(Integer.toString(arrayI[i])));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).minus(arrayI[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).minus(new Phasor(arrayI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Byte[] arrayI) {
        int nArg = arrayI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        byte[] arrayl = new byte[this.length];
        int i = 0;
        while (i < this.length) {
            arrayl[i] = arrayI[i];
            ++i;
        }
        return this.minus(arrayl);
    }

    public ArrayMaths minus(BigDecimal[] arrayBD) {
        int nArg = arrayBD.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(arrayBD[i]));
                    ++i;
                }
                Conv.restoreMessages();
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(arrayBD[i].doubleValue()));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(new Phasor(arrayBD[i].doubleValue())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimalcannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(BigInteger constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                BigDecimal constantBD = Conv.convert_BigInteger_to_BigDecimal(constant);
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(constantBD));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].subtract(constant));
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(Conv.convert_BigInteger_to_double(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(new Phasor(Conv.convert_BigInteger_to_double(constant))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(BigInteger[] arrayBI) {
        int nArg = arrayBI.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(Conv.convert_BigInteger_to_BigDecimal(arrayBI[i])));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].add(arrayBI[i]));
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(Conv.convert_BigInteger_to_double(arrayBI[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(new Phasor(Conv.convert_BigInteger_to_double(arrayBI[i]))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Complex constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(constant));
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(Conv.convert_Complex_to_Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Complex[] arrayC) {
        int nArg = arrayC.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(arrayC[i]));
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(Conv.convert_Complex_to_Phasor(arrayC[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Phasor constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(constant));
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(Conv.convert_Phasor_to_Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Phasor[] arrayP) {
        int nArg = arrayP.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].minus(arrayP[i]));
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].minus(Conv.convert_Phasor_to_Complex(arrayP[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minus(Vector<Object> vec) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am1 = new ArrayMaths();
        ArrayMaths am2 = new ArrayMaths(vec);
        switch (am2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = am2.getArray_as_double();
                am1 = this.minus(dd);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] ll = am2.getArray_as_long();
                am1 = this.minus(ll);
                break;
            }
            case 12: {
                BigDecimal[] bd = am2.getArray_as_BigDecimal();
                am1 = this.minus(bd);
                break;
            }
            case 13: {
                BigInteger[] bi = am2.getArray_as_BigInteger();
                am1 = this.minus(bi);
                break;
            }
            case 14: {
                Complex[] cc = am2.getArray_as_Complex();
                am1 = this.minus(cc);
                break;
            }
            case 15: {
                Phasor[] pp = am2.getArray_as_Phasor();
                am1 = this.minus(pp);
                break;
            }
            case 16: {
                throw new IllegalArgumentException("ArrayList/char subtraction not allowed");
            }
            case 17: {
                throw new IllegalArgumentException("ArrayList/Character subtraction not allowed");
            }
            case 18: {
                throw new IllegalArgumentException("ArrayList/String subtraction not allowed");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am1.getArray_as_Object(), am1.minmax, maxminIndices, am1.typeName, am1.type);
        am1.maxIndex = maxminIndices[0];
        am1.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am1;
    }

    public ArrayMaths minus(ArrayList<Object> list2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am1 = new ArrayMaths();
        ArrayMaths am2 = new ArrayMaths(list2);
        switch (am2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = am2.getArray_as_double();
                am1 = this.minus(dd);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] ll = am2.getArray_as_long();
                am1 = this.minus(ll);
                break;
            }
            case 12: {
                BigDecimal[] bd = am2.getArray_as_BigDecimal();
                am1 = this.minus(bd);
                break;
            }
            case 13: {
                BigInteger[] bi = am2.getArray_as_BigInteger();
                am1 = this.minus(bi);
                break;
            }
            case 14: {
                Complex[] cc = am2.getArray_as_Complex();
                am1 = this.minus(cc);
                break;
            }
            case 15: {
                Phasor[] pp = am2.getArray_as_Phasor();
                am1 = this.minus(pp);
                break;
            }
            case 16: {
                throw new IllegalArgumentException("ArrayList/char subtraction not allowed");
            }
            case 17: {
                throw new IllegalArgumentException("ArrayList/Character subtraction not allowed");
            }
            case 18: {
                throw new IllegalArgumentException("ArrayList/String subtraction not allowed");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am1.getArray_as_Object(), am1.minmax, maxminIndices, am1.typeName, am1.type);
        am1.maxIndex = maxminIndices[0];
        am1.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am1;
    }

    public ArrayMaths minus(ArrayMaths arrayM) {
        ArrayList<Object> arrayl = arrayM.getArray_as_ArrayList();
        return this.minus(arrayl);
    }

    public ArrayMaths minus(Stat arrayS) {
        ArrayList<Object> arrayl = arrayS.getArray_as_ArrayList();
        return this.minus(arrayl);
    }

    public ArrayMaths times(double constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.multiply(new BigDecimal(constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigDecimal hold2 = new BigDecimal(hold1).multiply(new BigDecimal(constant));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).times(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).times(new Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(Double constant) {
        return this.times((double)constant);
    }

    public ArrayMaths times(float constant) {
        double constantd = constant;
        return this.times(constantd);
    }

    public ArrayMaths times(Float constant) {
        return this.times(constant.floatValue());
    }

    public ArrayMaths times(long constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] * constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.multiply(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.multiply(new BigInteger(Long.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).times(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).times(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(Long constant) {
        long constantl = constant;
        return this.times(constantl);
    }

    public ArrayMaths times(int constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] * (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int maxi = this.getMaximum_as_int();
                int[] lll = this.getArray_as_int();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] * constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.multiply(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.multiply(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).times(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).times(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(Integer constant) {
        int constantl = constant;
        return this.times(constantl);
    }

    public ArrayMaths times(short constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] * (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short maxi = this.getMaximum_as_short();
                short[] lll = this.getArray_as_short();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] * constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.multiply(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.multiply(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).times(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).times(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(Short constant) {
        short constantl = constant;
        return this.times(constantl);
    }

    public ArrayMaths times(BigDecimal constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].multiply(constant));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].times(constant.doubleValue()));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].times(new Phasor(constant.doubleValue())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimal cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(byte constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= (long)constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] * (long)constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte maxi = this.getMaximum_as_byte();
                byte[] lll = this.getArray_as_byte();
                if (Integer.MAX_VALUE - maxi >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Integer(lll[i] * constant));
                        ++i;
                    }
                    am.type = 6;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] * (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.multiply(new BigDecimal((double)constant));
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.multiply(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).times(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).times(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(Byte constant) {
        byte constantl = constant;
        return this.times(constantl);
    }

    public ArrayMaths times(BigInteger constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                BigDecimal constantBD = Conv.convert_BigInteger_to_BigDecimal(constant);
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(constantBD));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].multiply(constant));
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].times(Conv.convert_BigInteger_to_double(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].times(new Phasor(Conv.convert_BigInteger_to_double(constant))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(Complex constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].times(constant));
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].times(Conv.convert_Complex_to_Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths times(Phasor constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].times(constant));
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].times(Conv.convert_Phasor_to_Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(double constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] / constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.divide(new BigDecimal(constant), 4);
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigDecimal hold2 = new BigDecimal(hold1).divide(new BigDecimal(constant), 4);
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).over(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).over(new Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(Double constant) {
        return this.over((double)constant);
    }

    public ArrayMaths over(float constant) {
        double constantd = constant;
        return this.over(constantd);
    }

    public ArrayMaths over(Float constant) {
        return this.over(constant.floatValue());
    }

    public ArrayMaths over(long constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] / (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                if (Long.MAX_VALUE - max2 >= constant) {
                    int i = 0;
                    while (i < this.length) {
                        am.array.add(new Long(ll[i] / constant));
                        ++i;
                    }
                    am.type = 4;
                    break;
                }
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)ll[i] / (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.divide(new BigDecimal((double)constant), 4);
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.divide(new BigInteger(Long.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).over(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).over(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(Long constant) {
        long constantl = constant;
        return this.over(constantl);
    }

    public ArrayMaths over(int constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] / (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll[i] / (long)constant));
                    ++i;
                }
                am.type = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int maxi = this.getMaximum_as_int();
                int[] lll = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Integer(lll[i] / constant));
                    ++i;
                }
                am.type = 6;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.divide(new BigDecimal((double)constant), 4);
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.divide(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).over(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).over(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(Integer constant) {
        int constantl = constant;
        return this.over(constantl);
    }

    public ArrayMaths over(short constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] / (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll[i] / (long)constant));
                    ++i;
                }
                am.type = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short maxi = this.getMaximum_as_short();
                short[] lll = this.getArray_as_short();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Integer(lll[i] / constant));
                    ++i;
                }
                am.type = 6;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.divide(new BigDecimal((double)constant), 4);
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.divide(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).over(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).over(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(Short constant) {
        short constantl = constant;
        return this.over(constantl);
    }

    public ArrayMaths over(BigDecimal constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].divide(constant, 4));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].over(constant.doubleValue()));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].over(new Phasor(constant.doubleValue())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimal cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(byte constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] / (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 4: {
                long max2 = this.getMaximum_as_long();
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll[i] / (long)constant));
                    ++i;
                }
                am.type = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte maxi = this.getMaximum_as_byte();
                byte[] lll = this.getArray_as_byte();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double((double)lll[i] / (double)constant));
                    ++i;
                }
                am.type = 0;
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    BigDecimal hold1 = (BigDecimal)this.array.get(i);
                    hold1 = hold1.divide(new BigDecimal((double)constant), 4);
                    am.array.add(hold1);
                    hold1 = null;
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    BigInteger hold1 = (BigInteger)this.array.get(i);
                    BigInteger hold2 = hold1.divide(new BigInteger(Integer.toString(constant)));
                    am.array.add(hold2);
                    hold1 = null;
                    hold2 = null;
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Complex)this.array.get(i)).over(constant));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add(((Phasor)this.array.get(i)).over(new Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(Byte constant) {
        byte constantl = constant;
        return this.over(constantl);
    }

    public ArrayMaths over(BigInteger constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                BigDecimal constantBD = Conv.convert_BigInteger_to_BigDecimal(constant);
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].add(constantBD));
                    ++i;
                }
                am.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].divide(constant));
                    ++i;
                }
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].over(Conv.convert_BigInteger_to_double(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].over(new Phasor(Conv.convert_BigInteger_to_double(constant))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(Complex constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].over(constant));
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].over(Conv.convert_Complex_to_Phasor(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths over(Phasor constant) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].over(constant));
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].over(Conv.convert_Phasor_to_Complex(constant)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths truncate(int n) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Fmath.truncate(dd[i], n)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] ff = this.getArray_as_float();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(Fmath.truncate(ff[i], n)));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] ii = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ii[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] ss = this.getArray_as_short();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short(ss[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = this.getArray_as_byte();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte(bb[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].setScale(n, 4));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 14: {
                Complex[] co = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.truncate(co[i], n));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] ph = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.truncate(ph[i], n));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] ch = this.getArray_as_char();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Character(ch[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(st[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths floor() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.floor(dd[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] ff = this.getArray_as_float();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(Math.floor(ff[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] ii = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ii[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] ss = this.getArray_as_short();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short(ss[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = this.getArray_as_byte();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte(bb[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].setScale(0, 1));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 14: {
                Complex[] co = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Complex(Math.floor(co[i].getReal()), Math.floor(co[i].getImag())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] ph = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Phasor(Math.floor(ph[i].getMagnitude()), Math.floor(ph[i].getPhaseInDegrees())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] ch = this.getArray_as_char();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Character(ch[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(st[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths ceil() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.ceil(dd[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] ff = this.getArray_as_float();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(Math.ceil(ff[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] ii = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ii[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] ss = this.getArray_as_short();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short(ss[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = this.getArray_as_byte();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte(bb[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].setScale(0, 0));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 14: {
                Complex[] co = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Complex(Math.ceil(co[i].getReal()), Math.ceil(co[i].getImag())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] ph = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Phasor(Math.ceil(ph[i].getMagnitude()), Math.ceil(ph[i].getPhaseInDegrees())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] ch = this.getArray_as_char();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Character(ch[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(st[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths rint() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.rint(dd[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] ff = this.getArray_as_float();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(Math.rint(ff[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] ii = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ii[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] ss = this.getArray_as_short();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short(ss[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = this.getArray_as_byte();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte(bb[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].setScale(0, 6));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 14: {
                Complex[] co = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Complex(Math.rint(co[i].getReal()), Math.rint(co[i].getImag())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] ph = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Phasor(Math.rint(ph[i].getMagnitude()), Math.rint(ph[i].getPhaseInDegrees())));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] ch = this.getArray_as_char();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Character(ch[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                int i = 0;
                while (i < this.length) {
                    am.array.add(st[i]);
                    ++i;
                }
                am.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths reverse() {
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        am.type = this.type;
        am.sortedIndices = new int[this.length];
        int i = 0;
        while (i < this.length) {
            am.array.add(this.array.get(this.length - i - 1));
            am.sortedIndices[i] = this.length - i - 1;
            ++i;
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        return am;
    }

    public ArrayMaths log() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.log(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.log(cc[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.log(pp[i]));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths log2() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Fmath.log2(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.log(cc[i].over(Math.log(2.0))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.log(pp[i].over(Math.log(2.0))));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths log10() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.log10(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.log(cc[i].over(Math.log(10.0))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.log(pp[i].over(Math.log(10.0))));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths antilog10() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.pow(10.0, dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.pow(10.0, cc[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Complex[] pp = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Conv.convert_Complex_to_Phasor(Complex.pow(10.0, pp[i])));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths xLog2x() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * Fmath.log2(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].times(Complex.log(cc[i].over(Math.log(2.0)))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].times(Phasor.log(pp[i].over(Math.log(2.0)))));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths xLogEx() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * Math.log(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].times(Complex.log(cc[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].times(Phasor.log(pp[i])));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths xLog10x() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i] * Math.log10(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].times(Complex.log(cc[i].over(Math.log(10.0)))));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].times(Phasor.log(pp[i].over(Math.log(10.0)))));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths minusxLog2x() {
        ArrayMaths am = this.xLog2x();
        return am.negate();
    }

    public ArrayMaths minusxLogEx() {
        ArrayMaths am = this.xLogEx();
        return am.negate();
    }

    public ArrayMaths minusxLog10x() {
        ArrayMaths am = this.xLog10x();
        return am.negate();
    }

    public ArrayMaths sqrt() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.sqrt(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.sqrt(cc[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.sqrt(pp[i]));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths oneOverSqrt() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(1.0 / Math.sqrt(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.sqrt(cc[i]).inverse());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.sqrt(pp[i]).inverse());
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths abs() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.abs(dd[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] ff = this.getArray_as_float();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(Math.abs(ff[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(Math.abs(ll[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] ii1 = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Integer(Math.abs(ii1[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                int[] ii2 = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short((short)Math.abs(ii2[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                int[] ii3 = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte((byte)Math.abs(ii3[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].abs());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].abs());
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.abs(cc[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].abs());
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 16: 
            case 17: {
                int[] ii4 = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Integer(Math.abs(ii4[i])));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 18: {
                double[] dd2 = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.abs(dd2[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths exp() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.exp(dd[i])));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.exp(cc[i]));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.exp(pp[i]));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths invert() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(1.0 / dd[i]));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(BigDecimal.ONE.divide(bd[i], 4));
                    ++i;
                }
                am.type = 12;
                bd = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.plusOne().over(cc[i]));
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.plusOne().over(pp[i]));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths pow(int n) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.pow(dd[i], n)));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal bdpow = BigDecimal.ONE;
                int i = 0;
                while (i < this.length) {
                    int j = 0;
                    while (j < n) {
                        bdpow = bdpow.multiply(bd[i]);
                        ++j;
                    }
                    am.array.add(bdpow);
                    ++i;
                }
                bd = null;
                bdpow = null;
                am.type = 12;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].pow(n));
                    ++i;
                }
                am.type = 13;
                bi = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.pow(cc[i], n));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.pow(pp[i], n));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths pow(double n) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.pow(dd[i], n)));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.pow(cc[i], n));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.pow(pp[i], n));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths pow(float n) {
        double nn = n;
        return this.pow(nn);
    }

    public ArrayMaths pow(long n) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(Math.pow(dd[i], n)));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal bdpow = BigDecimal.ONE;
                int i = 0;
                while (i < this.length) {
                    long j = 0L;
                    while (j < n) {
                        bdpow = bdpow.multiply(bd[i]);
                    }
                    am.array.add(bdpow);
                    ++i;
                }
                bd = null;
                bdpow = null;
                am.type = 12;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                BigInteger bipow = BigInteger.ONE;
                int i = 0;
                while (i < this.length) {
                    long j = 0L;
                    while (j < n) {
                        bipow = bipow.multiply(bi[i]);
                    }
                    am.array.add(bipow);
                    ++i;
                }
                bi = null;
                bipow = null;
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Complex.pow(cc[i], n));
                    ++i;
                }
                am.type = this.type;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(Phasor.pow(pp[i], n));
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths pow(short n) {
        short ii = n;
        return this.pow((int)ii);
    }

    public ArrayMaths pow(byte n) {
        byte ii = n;
        return this.pow((int)ii);
    }

    public ArrayMaths pow(Number n) {
        boolean test2 = integers.containsKey(n.getClass());
        if (test2) {
            if (n instanceof Long) {
                return this.pow(n.longValue());
            }
            if (n instanceof BigInteger) {
                return this.pow(n.doubleValue());
            }
            return this.pow(n.intValue());
        }
        return this.pow(n.doubleValue());
    }

    public ArrayMaths negate() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(-dd[i]));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 2: 
            case 3: {
                float[] ff = this.getArray_as_float();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(-ff[i]));
                    ++i;
                }
                am.type = 3;
                break;
            }
            case 4: 
            case 5: {
                long[] ll = this.getArray_as_long();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(-ll[i]));
                    ++i;
                }
                am.type = 5;
                break;
            }
            case 6: 
            case 7: {
                int[] ii = this.getArray_as_int();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Integer(-ii[i]));
                    ++i;
                }
                am.type = 7;
                break;
            }
            case 8: 
            case 9: {
                short[] ss = this.getArray_as_short();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short(-ss[i]));
                    ++i;
                }
                am.type = 9;
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = this.getArray_as_byte();
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte(-bb[i]));
                    ++i;
                }
                am.type = 11;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i].negate());
                    ++i;
                }
                am.type = 12;
                bd = null;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi[i].negate());
                    ++i;
                }
                am.type = 13;
                bi = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(cc[i].negate());
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(pp[i].negate());
                    ++i;
                }
                am.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    protected void calcSum() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                double[] dd = this.getArray_as_double();
                double sum2 = 0.0;
                int i = 0;
                while (i < this.length) {
                    sum2 += dd[i];
                    ++i;
                }
                this.summ.add(new Double(sum2));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                long[] ll = this.getArray_as_long();
                long suml = 0L;
                boolean test2 = false;
                int i = 0;
                while (i < this.length) {
                    if (Long.MAX_VALUE - suml < ll[i]) {
                        test2 = true;
                    }
                    suml += ll[i];
                    ++i;
                }
                if (test2) {
                    double[] dd2 = this.getArray_as_double();
                    double sum2 = 0.0;
                    int i2 = 0;
                    while (i2 < this.length) {
                        sum2 += dd2[i2];
                        ++i2;
                    }
                    this.summ.add(new Double(sum2));
                    this.sumlongToDouble = true;
                    break;
                }
                this.summ.add(new Long(suml));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal sumbd = new BigDecimal(0.0);
                int i = 0;
                while (i < this.length) {
                    sumbd.add(bd[i]);
                    ++i;
                }
                this.summ.add(sumbd);
                bd = null;
                sumbd = null;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                BigInteger sumbi = BigInteger.ZERO;
                int i = 0;
                while (i < this.length) {
                    sumbi.add(bi[i]);
                    ++i;
                }
                this.summ.add(sumbi);
                bi = null;
                sumbi = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                Complex sumcc = Complex.zero();
                int i = 0;
                while (i < this.length) {
                    sumcc.plus(cc[i]);
                    ++i;
                }
                this.summ.add(sumcc);
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                Phasor sumpp = Phasor.zero();
                int i = 0;
                while (i < this.length) {
                    sumpp.plus(pp[i]);
                    ++i;
                }
                this.summ.add(sumpp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        this.sumDone = true;
        Conv.restoreMessages();
    }

    public double sum() {
        return this.getSum_as_double();
    }

    public double sum_as_double() {
        return this.getSum_as_double();
    }

    public double getSum() {
        return this.getSum_as_double();
    }

    public double getSum_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        double sum2 = 0.0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = (Double)this.summ.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = (Double)this.summ.get(0);
                    break;
                }
                sum2 = Conv.convert_Long_to_double((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_double((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_double((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Double sum_as_Double() {
        return this.getSum_as_Double();
    }

    public Double getSum_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Double sum2 = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = (Double)this.summ.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = (Double)this.summ.get(0);
                    break;
                }
                sum2 = Conv.convert_Long_to_Double((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_Double((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_Double((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public float sum_as_float() {
        return this.getSum_as_float();
    }

    public float getSum_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        float sum2 = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_float((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_float((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_float((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_float((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_float((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Float sum_as_Float() {
        return this.getSum_as_Float();
    }

    public Float getSum_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Float sum2 = new Float(0.0f);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_Float((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_Float((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_Float((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_Float((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_Float((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public long sum_as_long() {
        return this.getSum_as_long();
    }

    public long getSum_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        long sum2 = 0L;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_long((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_long((Double)this.summ.get(0));
                    break;
                }
                sum2 = (Long)this.summ.get(0);
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_long((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_long((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Long sum_as_Long() {
        return this.getSum_as_Long();
    }

    public Long getSum_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Long sum2 = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_Long((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_Long((Double)this.summ.get(0));
                    break;
                }
                sum2 = (Long)this.summ.get(0);
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_Long((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_Long((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public int sum_as_int() {
        return this.getSum_as_int();
    }

    public int getSum_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        int sum2 = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_int((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_int((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_int((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_int((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_int((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Integer sum_as_Integer() {
        return this.getSum_as_Integer();
    }

    public Integer getSum_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Integer sum2 = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_Integer((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_Integer((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_Integer((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_Integer((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public short sum_as_short() {
        return this.getSum_as_short();
    }

    public short getSum_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        short sum2 = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_short((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_short((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_short((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_short((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_short((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Short sum_as_Short() {
        return this.getSum_as_Short();
    }

    public Short getSum_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Short sum2 = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_Short((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_Short((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_Short((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_Short((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_Short((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public byte sum_as_byte() {
        return this.getSum_as_byte();
    }

    public byte getSum_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        byte sum2 = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_byte((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_byte((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_byte((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_byte((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_byte((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Byte sum_as_Byte() {
        return this.getSum_as_Byte();
    }

    public Byte getSum_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Byte sum2 = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_Byte((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_Byte((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_Byte((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_Byte((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public BigDecimal sum_as_BigDecimal() {
        return this.getSum_as_BigDecimal();
    }

    public BigDecimal getSum_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        BigDecimal sum2 = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_BigDecimal((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_BigDecimal((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_BigDecimal((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = (BigDecimal)this.summ.get(0);
                break;
            }
            case 13: {
                sum2 = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public BigInteger sum_as_BigInteger() {
        return this.getSum_as_BigInteger();
    }

    public BigInteger getSum_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        BigInteger sum2 = BigInteger.ZERO;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Conv.convert_Double_to_BigInteger((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Conv.convert_Double_to_BigInteger((Double)this.summ.get(0));
                    break;
                }
                sum2 = Conv.convert_Long_to_BigInteger((Long)this.summ.get(0));
                break;
            }
            case 12: {
                sum2 = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                sum2 = (BigInteger)this.summ.get(0);
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Complex sum_as_Complex() {
        return this.getSum_as_Complex();
    }

    public Complex getSum_as_Complex() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Complex sum2 = Complex.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = new Complex((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = new Complex((Double)this.summ.get(0));
                    break;
                }
                sum2 = new Complex(((Long)this.summ.get(0)).doubleValue());
                break;
            }
            case 12: {
                sum2 = new Complex(((BigDecimal)this.summ.get(0)).doubleValue());
                break;
            }
            case 13: {
                sum2 = new Complex(((BigInteger)this.summ.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Complex is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public Phasor sum_as_Phasor() {
        return this.getSum_as_Phasor();
    }

    public Phasor getSum_as_Phasor() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Phasor sum2 = Phasor.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = new Phasor((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = new Phasor((Double)this.summ.get(0));
                    break;
                }
                sum2 = new Phasor(((Long)this.summ.get(0)).doubleValue());
                break;
            }
            case 12: {
                sum2 = new Phasor(((BigDecimal)this.summ.get(0)).doubleValue());
                break;
            }
            case 13: {
                sum2 = new Phasor(((BigInteger)this.summ.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Phasor is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    public String sum_as_String() {
        return this.getSum_as_String();
    }

    public String getSum_as_String() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        String sum2 = " ";
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                sum2 = Double.toString((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    sum2 = Double.toString((Double)this.summ.get(0));
                    break;
                }
                sum2 = Double.toString(((Long)this.summ.get(0)).doubleValue());
                break;
            }
            case 12: {
                sum2 = ((BigDecimal)this.summ.get(0)).toString();
                break;
            }
            case 13: {
                sum2 = ((BigInteger)this.summ.get(0)).toString();
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as String is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sum2;
    }

    protected void calcProduct() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                double[] dd = this.getArray_as_double();
                double product2 = 1.0;
                int i = 0;
                while (i < this.length) {
                    product2 *= dd[i];
                    ++i;
                }
                this.productt.add(new Double(product2));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                long[] ll = this.getArray_as_long();
                long productl = 1L;
                boolean test2 = false;
                int i = 0;
                while (i < this.length) {
                    if (Long.MAX_VALUE / productl < ll[i]) {
                        test2 = true;
                    }
                    productl += ll[i];
                    ++i;
                }
                if (test2) {
                    double[] dd2 = this.getArray_as_double();
                    double product2 = 1.0;
                    int i2 = 0;
                    while (i2 < this.length) {
                        product2 *= dd2[i2];
                        ++i2;
                    }
                    this.productt.add(new Double(product2));
                    this.sumlongToDouble = true;
                    break;
                }
                this.productt.add(new Long(productl));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal productbd = new BigDecimal(1.0);
                int i = 0;
                while (i < this.length) {
                    productbd.multiply(bd[i]);
                    ++i;
                }
                this.productt.add(productbd);
                bd = null;
                productbd = null;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                BigInteger productbi = BigInteger.ONE;
                int i = 0;
                while (i < this.length) {
                    productbi.multiply(bi[i]);
                    ++i;
                }
                this.productt.add(productbi);
                bi = null;
                productbi = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                Complex productcc = Complex.plusOne();
                int i = 0;
                while (i < this.length) {
                    productcc.times(cc[i]);
                    ++i;
                }
                this.productt.add(productcc);
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                Phasor productpp = Phasor.plusOne();
                int i = 0;
                while (i < this.length) {
                    productpp.times(pp[i]);
                    ++i;
                }
                this.productt.add(productpp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        this.productDone = true;
        Conv.restoreMessages();
    }

    public double product() {
        return this.getProduct_as_double();
    }

    public double product_as_double() {
        return this.getProduct_as_double();
    }

    public double getProduct() {
        return this.getProduct_as_double();
    }

    public double getProduct_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        double product2 = 0.0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = (Double)this.productt.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = (Double)this.productt.get(0);
                    break;
                }
                product2 = Conv.convert_Long_to_double((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_double((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_double((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Double product_as_Double() {
        return this.getProduct_as_Double();
    }

    public Double getProduct_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Double product2 = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = (Double)this.productt.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = (Double)this.productt.get(0);
                    break;
                }
                product2 = Conv.convert_Long_to_Double((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_Double((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_Double((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public float product_as_float() {
        return this.getProduct_as_float();
    }

    public float getProduct_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        float product2 = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_float((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_float((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_float((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_float((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_float((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Float product_as_Float() {
        return this.getProduct_as_Float();
    }

    public Float getProduct_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Float product2 = new Float(0.0f);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_Float((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_Float((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_Float((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_Float((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_Float((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public long product_as_long() {
        return this.getProduct_as_long();
    }

    public long getProduct_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        long product2 = 0L;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_long((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_long((Double)this.productt.get(0));
                    break;
                }
                product2 = (Long)this.productt.get(0);
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_long((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_long((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Long product_as_Long() {
        return this.getProduct_as_Long();
    }

    public Long getProduct_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Long product2 = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_Long((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_Long((Double)this.productt.get(0));
                    break;
                }
                product2 = (Long)this.productt.get(0);
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_Long((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_Long((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public int product_as_int() {
        return this.getProduct_as_int();
    }

    public int getProduct_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        int product2 = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_int((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_int((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_int((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_int((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_int((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Integer product_as_Integer() {
        return this.getProduct_as_Integer();
    }

    public Integer getProduct_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Integer product2 = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_Integer((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_Integer((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_Integer((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_Integer((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public short product_as_short() {
        return this.getProduct_as_short();
    }

    public short getProduct_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        short product2 = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_short((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_short((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_short((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_short((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_short((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Short product_as_Short() {
        return this.getProduct_as_Short();
    }

    public Short getProduct_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Short product2 = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_Short((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_Short((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_Short((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_Short((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_Short((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public byte product_as_byte() {
        return this.getProduct_as_byte();
    }

    public byte getProduct_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        byte product2 = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_byte((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_byte((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_byte((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_byte((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_byte((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Byte product_as_Byte() {
        return this.getProduct_as_Byte();
    }

    public Byte getProduct_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Byte product2 = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_Byte((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_Byte((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_Byte((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_Byte((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public BigDecimal product_as_BigDecimal() {
        return this.getProduct_as_BigDecimal();
    }

    public BigDecimal getProduct_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        BigDecimal product2 = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_BigDecimal((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_BigDecimal((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_BigDecimal((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = (BigDecimal)this.productt.get(0);
                break;
            }
            case 13: {
                product2 = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public BigInteger product_as_BigInteger() {
        return this.getProduct_as_BigInteger();
    }

    public BigInteger getProduct_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        BigInteger product2 = BigInteger.ZERO;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Conv.convert_Double_to_BigInteger((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Conv.convert_Double_to_BigInteger((Double)this.productt.get(0));
                    break;
                }
                product2 = Conv.convert_Long_to_BigInteger((Long)this.productt.get(0));
                break;
            }
            case 12: {
                product2 = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                product2 = (BigInteger)this.productt.get(0);
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Complex product_as_Complex() {
        return this.getProduct_as_Complex();
    }

    public Complex getProduct_as_Complex() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Complex product2 = Complex.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = new Complex((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = new Complex((Double)this.productt.get(0));
                    break;
                }
                product2 = new Complex(((Long)this.productt.get(0)).doubleValue());
                break;
            }
            case 12: {
                product2 = new Complex(((BigDecimal)this.productt.get(0)).doubleValue());
                break;
            }
            case 13: {
                product2 = new Complex(((BigInteger)this.productt.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Complex is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public Phasor product_as_Phasor() {
        return this.getProduct_as_Phasor();
    }

    public Phasor getProduct_as_Phasor() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Phasor product2 = Phasor.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = new Phasor((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = new Phasor((Double)this.productt.get(0));
                    break;
                }
                product2 = new Phasor(((Long)this.productt.get(0)).doubleValue());
                break;
            }
            case 12: {
                product2 = new Phasor(((BigDecimal)this.productt.get(0)).doubleValue());
                break;
            }
            case 13: {
                product2 = new Phasor(((BigInteger)this.productt.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Phasor is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public String product_as_String() {
        return this.getProduct_as_String();
    }

    public String getProduct_as_String() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        String product2 = " ";
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                product2 = Double.toString((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    product2 = Double.toString((Double)this.productt.get(0));
                    break;
                }
                product2 = Double.toString(((Long)this.productt.get(0)).doubleValue());
                break;
            }
            case 12: {
                product2 = ((BigDecimal)this.productt.get(0)).toString();
                break;
            }
            case 13: {
                product2 = ((BigInteger)this.productt.get(0)).toString();
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas String is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return product2;
    }

    public ArrayMaths randomize() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        am.type = this.type;
        PsRandom ran = new PsRandom();
        am.sortedIndices = ran.uniqueIntegerArray(this.length - 1);
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Double)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Float)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Long)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Integer)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Short)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Byte)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((BigDecimal)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((BigInteger)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Complex)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Phasor)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Character)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((String)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths randomise() {
        return this.randomize();
    }

    public void sortEquals() {
        ArrayMaths am = this.sort();
        this.array = am.array;
        this.sortedIndices = am.sortedIndices;
        this.maxIndex = am.maxIndex;
        this.minIndex = am.minIndex;
    }

    public ArrayMaths sort() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        am.type = this.type;
        am.sortedIndices = new int[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd1 = this.getArray_as_double();
                am.sortedIndices = this.sortWithIndices(dd1);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Double)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                double[] dd2 = this.getArray_as_double();
                am.sortedIndices = this.sortWithIndices(dd2);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Float)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                long[] ll1 = this.getArray_as_long();
                am.sortedIndices = this.sortWithIndices(ll1);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Long)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                long[] ll2 = this.getArray_as_long();
                am.sortedIndices = this.sortWithIndices(ll2);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Integer)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                long[] ll3 = this.getArray_as_long();
                am.sortedIndices = this.sortWithIndices(ll3);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Short)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                long[] ll4 = this.getArray_as_long();
                am.sortedIndices = this.sortWithIndices(ll4);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Byte)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                am.sortedIndices = this.sortWithIndices(bd);
                int i = 0;
                while (i < this.length) {
                    am.array.add((BigDecimal)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                am.sortedIndices = this.sortWithIndices(bi);
                int i = 0;
                while (i < this.length) {
                    am.array.add((BigInteger)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 14: {
                ArrayMaths am2 = this.abs();
                double[] cc = am2.getArray_as_double();
                am.sortedIndices = this.sortWithIndices(cc);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Complex)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 15: {
                ArrayMaths am3 = this.abs();
                double[] pp = am3.getArray_as_double();
                am.sortedIndices = this.sortWithIndices(pp);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Phasor)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                long[] ii = this.getArray_as_long();
                am.sortedIndices = this.sortWithIndices(ii);
                int i = 0;
                while (i < this.length) {
                    am.array.add((Character)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 18: {
                String[] ww = this.getArray_as_String();
                ArrayList<Object> al = this.alphabeticSort(ww);
                String[] www = (String[])al.get(0);
                int i = 0;
                while (i < this.length) {
                    am.array.add(www[i]);
                    ++i;
                }
                am.sortedIndices = (int[])al.get(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        if (this.type != 18) {
            int[] maxminIndices = new int[2];
            ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
            am.maxIndex = maxminIndices[0];
            am.minIndex = maxminIndices[1];
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayList<Object> alphabeticSort(String[] words) {
        this.words = words;
        this.nWords = words.length;
        this.sortedWords = new String[this.nWords];
        int i = 0;
        while (i < this.nWords) {
            this.sortedWords[i] = this.words[i];
            ++i;
        }
        this.alphabeticSortIndices(words);
        i = 0;
        while (i < this.nWords) {
            this.sortedWords[i] = words[this.wordOrder[i]];
            ++i;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(this.sortedWords);
        ret.add(this.wordOrder);
        return ret;
    }

    public void alphabeticSortIndices(String[] words) {
        String[] copy = new String[this.nWords];
        this.nLength = 0;
        int nn = 0;
        int i = 0;
        while (i < this.nWords) {
            nn = words[i].length();
            if (nn > this.nLength) {
                this.nLength = nn;
            }
            copy[i] = words[i].toLowerCase();
            ++i;
        }
        this.wordChar = new char[this.nWords][this.nLength];
        this.holdWordChar = new char[this.nWords][this.nLength];
        i = 0;
        while (i < this.nWords) {
            char[] holdc = copy[i].toCharArray();
            int j = 0;
            while (j < copy[i].length()) {
                this.wordChar[i][j] = holdc[j];
                this.holdWordChar[i][j] = holdc[j];
                ++j;
            }
            j = copy[i].length();
            while (j < this.nLength) {
                this.wordChar[i][j] = 32;
                this.holdWordChar[i][j] = 32;
                ++j;
            }
            ++i;
        }
        this.wordOrder = new int[this.nWords];
        this.holdWordOrder = new int[this.nWords];
        i = 0;
        while (i < this.nWords) {
            this.wordOrder[i] = i;
            this.holdWordOrder[i] = i;
            ++i;
        }
        if (this.nWords > 1) {
            this.indexSort(0, 0, this.nWords - 1);
        }
    }

    public void indexSort(int ii, int iStart, int iEnd) {
        int n = iEnd - iStart + 1;
        char[] colChar = new char[n];
        int[] colInt = new int[n];
        int i = 0;
        while (i < n) {
            colChar[i] = this.wordChar[i + iStart][ii];
            colInt[i] = this.wordOrder[i + iStart];
            ++i;
        }
        int[] indChar = this.sortByColumnInitial(colChar);
        int[] holdi = new int[n];
        int i2 = 0;
        while (i2 < n) {
            holdi[i2] = colInt[indChar[i2]];
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            this.holdWordOrder[i2 + iStart] = holdi[i2];
            this.holdWordChar[i2 + iStart] = this.wordChar[indChar[i2] + iStart];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.nWords) {
            this.wordChar[i2] = this.holdWordChar[i2];
            this.wordOrder[i2] = this.holdWordOrder[i2];
            ++i2;
        }
        ArrayList<Integer> al = null;
        if (ii < this.nLength - 1) {
            int one;
            int[] test2 = new int[n + 1];
            test2[0] = one = 1;
            int jj = 1;
            int i3 = iStart + 1;
            while (i3 <= iEnd) {
                test2[jj] = this.wordChar[i3][ii] == this.wordChar[i3 - 1][ii] ? one : (one = -one);
                ++jj;
                ++i3;
            }
            al = new ArrayList<Integer>();
            jj = iStart;
            al.add(new Integer(jj));
            i3 = 1;
            while (i3 <= n) {
                ++jj;
                if (test2[i3] != test2[i3 - 1]) {
                    al.add(new Integer(jj - 1));
                    al.add(new Integer(jj));
                }
                ++i3;
            }
            al.add(new Integer(iEnd));
            int nSub = al.size();
            int i4 = 0;
            while (i4 < nSub) {
                int vs = (Integer)al.get(i4);
                int ve = (Integer)al.get(i4 + 1);
                if (ve - vs + 1 > 1) {
                    this.indexSort(ii + 1, vs, ve);
                }
                i4 += 2;
            }
        }
    }

    public int[] sortByColumnInitial(char[] initials) {
        int n = initials.length;
        int[] intChar = new int[n];
        int i = 0;
        while (i < n) {
            intChar[i] = initials[i];
            ++i;
        }
        ArrayMaths ami = new ArrayMaths(intChar);
        ArrayMaths isorted = ami.sort();
        int[] iarraysorted = isorted.array_as_int();
        int[] iindices = isorted.originalIndices();
        return iindices;
    }

    public void sortEquals(int[] indices) {
        ArrayMaths am = this.sort(indices);
        this.array = am.array;
        this.sortedIndices = am.sortedIndices;
        this.maxIndex = am.maxIndex;
        this.minIndex = am.minIndex;
    }

    public ArrayMaths sort(int[] indices) {
        int nArg = indices.length;
        if (this.length != nArg) {
            throw new IllegalArgumentException("The argument array [length = " + nArg + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = this.length;
        am.type = this.type;
        am.sortedIndices = indices;
        switch (this.type) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Double)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Float)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Long)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Integer)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Short)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Byte)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((BigDecimal)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((BigInteger)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Complex)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Phasor)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((Character)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.length) {
                    am.array.add((String)this.array.get(am.sortedIndices[i]));
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        if (this.type != 18) {
            ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        }
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    protected int[] sortWithIndices(double[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        double holdb = 0.0;
        int holdi = 0;
        double[] bb = new double[this.length];
        int[] indices = new int[this.length];
        int i = 0;
        while (i < this.length) {
            bb[i] = aa[i];
            indices[i] = i;
            ++i;
        }
        while (lastIndex != this.length - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < this.length) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdb = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index2];
            indices[index2] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
        return indices;
    }

    protected int[] sortWithIndices(long[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        long holdb = 0L;
        int holdi = 0;
        long[] bb = new long[this.length];
        int[] indices = new int[this.length];
        int i = 0;
        while (i < this.length) {
            bb[i] = aa[i];
            indices[i] = i;
            ++i;
        }
        while (lastIndex != this.length - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < this.length) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdb = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index2];
            indices[index2] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
        return indices;
    }

    protected int[] sortWithIndices(BigDecimal[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        BigDecimal holdb = BigDecimal.ZERO;
        int holdi = 0;
        BigDecimal[] bb = new BigDecimal[this.length];
        int[] indices = new int[this.length];
        int i = 0;
        while (i < this.length) {
            bb[i] = aa[i];
            indices[i] = i;
            ++i;
        }
        while (lastIndex != this.length - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < this.length) {
                if (bb[i].compareTo(bb[index2]) == -1) {
                    index2 = i;
                }
                ++i;
            }
            holdb = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index2];
            indices[index2] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
        holdb = null;
        return indices;
    }

    protected int[] sortWithIndices(BigInteger[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        BigInteger holdb = BigInteger.ZERO;
        int holdi = 0;
        BigInteger[] bb = new BigInteger[this.length];
        int[] indices = new int[this.length];
        int i = 0;
        while (i < this.length) {
            bb[i] = aa[i];
            indices[i] = i;
            ++i;
        }
        while (lastIndex != this.length - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < this.length) {
                if (bb[i].compareTo(bb[index2]) == -1) {
                    index2 = i;
                }
                ++i;
            }
            holdb = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index2];
            indices[index2] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
        holdb = null;
        return indices;
    }

    public int[] originalIndices() {
        if (this.sortedIndices == null) {
            System.out.println("method: originalIndices: array has not been sorted: null returned");
        }
        return this.sortedIndices;
    }

    public ArrayMaths concatenate(double[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                double[] yy = this.getArray_as_double();
                double[] zz = new double[am.length];
                int i = 0;
                while (i < this.length) {
                    zz[i] = yy[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    zz[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Double(zz[i]));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bd1 = this.getArray_as_BigDecimal();
                am2 = new ArrayMaths(xx);
                BigDecimal[] bd2 = am2.getArray_as_BigDecimal();
                BigDecimal[] bda = new BigDecimal[am.length];
                int i = 0;
                while (i < this.length) {
                    bda[i] = bd1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bda[i + this.length] = bd2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bda[i]);
                    ++i;
                }
                bd1 = null;
                bd2 = null;
                bda = null;
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc1 = this.getArray_as_Complex();
                am2 = new ArrayMaths(xx);
                Complex[] cc2 = am2.getArray_as_Complex();
                Complex[] cca = new Complex[am.length];
                int i = 0;
                while (i < this.length) {
                    cca[i] = cc1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    cca[i + this.length] = cc2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(cca[i]);
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp1 = this.getArray_as_Phasor();
                am2 = new ArrayMaths(xx);
                Phasor[] pp2 = am2.getArray_as_Phasor();
                Phasor[] ppa = new Phasor[am.length];
                int i = 0;
                while (i < this.length) {
                    ppa[i] = pp1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ppa[i + this.length] = pp2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ppa[i]);
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(Double[] xx) {
        double[] dd = new double[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(float[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] yy = this.getArray_as_double();
                double[] zz = new double[am.length];
                int i = 0;
                while (i < this.length) {
                    zz[i] = yy[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    zz[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Double(zz[i]));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                float[] ff = this.getArray_as_float();
                float[] gg = new float[am.length];
                int i = 0;
                while (i < this.length) {
                    gg[i] = ff[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    gg[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Float(gg[i]));
                    ++i;
                }
                am.type = 3;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bd1 = this.getArray_as_BigDecimal();
                am2 = new ArrayMaths(xx);
                BigDecimal[] bd2 = am2.getArray_as_BigDecimal();
                BigDecimal[] bda = new BigDecimal[am.length];
                int i = 0;
                while (i < this.length) {
                    bda[i] = bd1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bda[i + this.length] = bd2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bda[i]);
                    ++i;
                }
                bd1 = null;
                bd2 = null;
                bda = null;
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc1 = this.getArray_as_Complex();
                am2 = new ArrayMaths(xx);
                Complex[] cc2 = am2.getArray_as_Complex();
                Complex[] cca = new Complex[am.length];
                int i = 0;
                while (i < this.length) {
                    cca[i] = cc1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    cca[i + this.length] = cc2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(cca[i]);
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp1 = this.getArray_as_Phasor();
                am2 = new ArrayMaths(xx);
                Phasor[] pp2 = am2.getArray_as_Phasor();
                Phasor[] ppa = new Phasor[am.length];
                int i = 0;
                while (i < this.length) {
                    ppa[i] = pp1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ppa[i + this.length] = pp2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ppa[i]);
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(Float[] xx) {
        float[] dd = new float[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i].floatValue();
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(long[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] yy = this.getArray_as_double();
                double[] zz = new double[am.length];
                int i = 0;
                while (i < this.length) {
                    zz[i] = yy[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    zz[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Double(zz[i]));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                long[] ll = this.getArray_as_long();
                long[] mm = new long[am.length];
                int i = 0;
                while (i < this.length) {
                    mm[i] = ll[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    mm[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Long(mm[i]));
                    ++i;
                }
                am.type = 3;
                break;
            }
            case 12: {
                BigDecimal[] bd1 = this.getArray_as_BigDecimal();
                am2 = new ArrayMaths(xx);
                BigDecimal[] bd2 = am2.getArray_as_BigDecimal();
                BigDecimal[] bda = new BigDecimal[am.length];
                int i = 0;
                while (i < this.length) {
                    bda[i] = bd1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bda[i + this.length] = bd2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bda[i]);
                    ++i;
                }
                bd1 = null;
                bd2 = null;
                bda = null;
                am.type = 12;
                break;
            }
            case 13: {
                BigInteger[] bi1 = this.getArray_as_BigInteger();
                am2 = new ArrayMaths(xx);
                BigInteger[] bi2 = am2.getArray_as_BigInteger();
                BigInteger[] bia = new BigInteger[am.length];
                int i = 0;
                while (i < this.length) {
                    bia[i] = bi1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bia[i + this.length] = bi2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bia[i]);
                    ++i;
                }
                bi1 = null;
                bi2 = null;
                bia = null;
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc1 = this.getArray_as_Complex();
                am2 = new ArrayMaths(xx);
                Complex[] cc2 = am2.getArray_as_Complex();
                Complex[] cca = new Complex[am.length];
                int i = 0;
                while (i < this.length) {
                    cca[i] = cc1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    cca[i + this.length] = cc2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(cca[i]);
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp1 = this.getArray_as_Phasor();
                am2 = new ArrayMaths(xx);
                Phasor[] pp2 = am2.getArray_as_Phasor();
                Phasor[] ppa = new Phasor[am.length];
                int i = 0;
                while (i < this.length) {
                    ppa[i] = pp1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ppa[i + this.length] = pp2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ppa[i]);
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(Long[] xx) {
        long[] dd = new long[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(int[] xx) {
        long[] dd = new long[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(Integer[] xx) {
        int[] dd = new int[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(short[] xx) {
        long[] dd = new long[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(Short[] xx) {
        short[] dd = new short[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(byte[] xx) {
        long[] dd = new long[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(Byte[] xx) {
        byte[] dd = new byte[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i];
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(BigDecimal[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                BigDecimal[] bd1 = this.getArray_as_BigDecimal();
                am2 = new ArrayMaths(xx);
                BigDecimal[] bd2 = am2.getArray_as_BigDecimal();
                BigDecimal[] bda = new BigDecimal[am.length];
                int i = 0;
                while (i < this.length) {
                    bda[i] = bd1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bda[i + this.length] = bd2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bda[i]);
                    ++i;
                }
                bd1 = null;
                bd2 = null;
                bda = null;
                am.type = 12;
                break;
            }
            case 14: {
                Complex[] cc1 = this.getArray_as_Complex();
                am2 = new ArrayMaths(xx);
                Complex[] cc2 = am2.getArray_as_Complex();
                Complex[] cca = new Complex[am.length];
                int i = 0;
                while (i < this.length) {
                    cca[i] = cc1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    cca[i + this.length] = cc2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(cca[i]);
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp1 = this.getArray_as_Phasor();
                am2 = new ArrayMaths(xx);
                Phasor[] pp2 = am2.getArray_as_Phasor();
                Phasor[] ppa = new Phasor[am.length];
                int i = 0;
                while (i < this.length) {
                    ppa[i] = pp1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ppa[i + this.length] = pp2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ppa[i]);
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(BigInteger[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                BigDecimal[] bd1 = this.getArray_as_BigDecimal();
                am2 = new ArrayMaths(xx);
                BigDecimal[] bd2 = am2.getArray_as_BigDecimal();
                BigDecimal[] bda = new BigDecimal[am.length];
                int i = 0;
                while (i < this.length) {
                    bda[i] = bd1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bda[i + this.length] = bd2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bda[i]);
                    ++i;
                }
                bd1 = null;
                bd2 = null;
                bda = null;
                am.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                BigInteger[] bi1 = this.getArray_as_BigInteger();
                am2 = new ArrayMaths(xx);
                BigInteger[] bi2 = am2.getArray_as_BigInteger();
                BigInteger[] bia = new BigInteger[am.length];
                int i = 0;
                while (i < this.length) {
                    bia[i] = bi1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bia[i + this.length] = bi2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bia[i]);
                    ++i;
                }
                bi1 = null;
                bi2 = null;
                bia = null;
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc1 = this.getArray_as_Complex();
                am2 = new ArrayMaths(xx);
                Complex[] cc2 = am2.getArray_as_Complex();
                Complex[] cca = new Complex[am.length];
                int i = 0;
                while (i < this.length) {
                    cca[i] = cc1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    cca[i + this.length] = cc2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(cca[i]);
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp1 = this.getArray_as_Phasor();
                am2 = new ArrayMaths(xx);
                Phasor[] pp2 = am2.getArray_as_Phasor();
                Phasor[] ppa = new Phasor[am.length];
                int i = 0;
                while (i < this.length) {
                    ppa[i] = pp1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ppa[i + this.length] = pp2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ppa[i]);
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(Complex[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                Complex[] cc1 = this.getArray_as_Complex();
                am2 = new ArrayMaths(xx);
                Complex[] cc2 = am2.getArray_as_Complex();
                Complex[] cca = new Complex[am.length];
                int i = 0;
                while (i < this.length) {
                    cca[i] = cc1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    cca[i + this.length] = cc2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(cca[i]);
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(Phasor[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                Phasor[] pp1 = this.getArray_as_Phasor();
                am2 = new ArrayMaths(xx);
                Phasor[] pp2 = am2.getArray_as_Phasor();
                Phasor[] ppa = new Phasor[am.length];
                int i = 0;
                while (i < this.length) {
                    ppa[i] = pp1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ppa[i + this.length] = pp2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ppa[i]);
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(String[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(char[] xx) {
        int xlength = xx.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths am = new ArrayMaths();
        am.array = new ArrayList();
        am.length = xx.length + this.length;
        ArrayMaths am2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double[] yy = this.getArray_as_double();
                double[] zz = new double[am.length];
                int i = 0;
                while (i < this.length) {
                    zz[i] = yy[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    zz[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Double(zz[i]));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] ll = this.getArray_as_long();
                long[] mm = new long[am.length];
                int i = 0;
                while (i < this.length) {
                    mm[i] = ll[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    mm[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Long(mm[i]));
                    ++i;
                }
                am.type = 3;
                break;
            }
            case 12: {
                BigDecimal[] bd1 = this.getArray_as_BigDecimal();
                am2 = new ArrayMaths(xx);
                BigDecimal[] bd2 = am2.getArray_as_BigDecimal();
                BigDecimal[] bda = new BigDecimal[am.length];
                int i = 0;
                while (i < this.length) {
                    bda[i] = bd1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bda[i + this.length] = bd2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bda[i]);
                    ++i;
                }
                bd1 = null;
                bd2 = null;
                bda = null;
                am.type = 12;
                break;
            }
            case 13: {
                BigInteger[] bi1 = this.getArray_as_BigInteger();
                am2 = new ArrayMaths(xx);
                BigInteger[] bi2 = am2.getArray_as_BigInteger();
                BigInteger[] bia = new BigInteger[am.length];
                int i = 0;
                while (i < this.length) {
                    bia[i] = bi1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    bia[i + this.length] = bi2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(bia[i]);
                    ++i;
                }
                bi1 = null;
                bi2 = null;
                bia = null;
                am.type = 13;
                break;
            }
            case 14: {
                Complex[] cc1 = this.getArray_as_Complex();
                am2 = new ArrayMaths(xx);
                Complex[] cc2 = am2.getArray_as_Complex();
                Complex[] cca = new Complex[am.length];
                int i = 0;
                while (i < this.length) {
                    cca[i] = cc1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    cca[i + this.length] = cc2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(cca[i]);
                    ++i;
                }
                am.type = 14;
                break;
            }
            case 15: {
                Phasor[] pp1 = this.getArray_as_Phasor();
                am2 = new ArrayMaths(xx);
                Phasor[] pp2 = am2.getArray_as_Phasor();
                Phasor[] ppa = new Phasor[am.length];
                int i = 0;
                while (i < this.length) {
                    ppa[i] = pp1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ppa[i + this.length] = pp2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ppa[i]);
                    ++i;
                }
                am.type = 15;
                break;
            }
            case 16: 
            case 17: {
                char[] ch = this.getArray_as_char();
                char[] dh = new char[am.length];
                int i = 0;
                while (i < this.length) {
                    dh[i] = ch[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    dh[i + this.length] = xx[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(new Character(dh[i]));
                    ++i;
                }
                am.type = 1;
                break;
            }
            case 18: {
                String[] ss1 = this.getArray_as_String();
                am2 = new ArrayMaths(xx);
                String[] ss2 = am2.getArray_as_String();
                String[] ssa = new String[am.length];
                int i = 0;
                while (i < this.length) {
                    ssa[i] = ss1[i];
                    ++i;
                }
                i = 0;
                while (i < xlength) {
                    ssa[i + this.length] = ss2[i];
                    ++i;
                }
                i = 0;
                while (i < am.length) {
                    am.array.add(ssa[i]);
                    ++i;
                }
                am.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(Character[] xx) {
        char[] dd = new char[xx.length];
        int i = 0;
        while (i < xx.length) {
            dd[i] = xx[i].charValue();
            ++i;
        }
        return this.concatenate(dd);
    }

    public ArrayMaths concatenate(ArrayMaths xx) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int type = xx.type;
        ArrayMaths am = new ArrayMaths();
        switch (xx.type) {
            case 0: 
            case 1: {
                double[] dd = xx.getArray_as_double();
                am = this.concatenate(dd);
                break;
            }
            case 2: 
            case 3: {
                float[] ff = xx.getArray_as_float();
                am = this.concatenate(ff);
                break;
            }
            case 4: 
            case 5: {
                long[] ll = xx.getArray_as_long();
                am = this.concatenate(ll);
                break;
            }
            case 6: 
            case 7: {
                int[] ii = xx.getArray_as_int();
                am = this.concatenate(ii);
                break;
            }
            case 8: 
            case 9: {
                short[] ss = xx.getArray_as_short();
                am = this.concatenate(ss);
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = xx.getArray_as_byte();
                am = this.concatenate(bb);
                break;
            }
            case 12: {
                BigDecimal[] bd = xx.getArray_as_BigDecimal();
                am = this.concatenate(bd);
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                am = this.concatenate(bi);
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                am = this.concatenate(cc);
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                am = this.concatenate(pp);
                break;
            }
            case 16: 
            case 17: {
                char[] ct = this.getArray_as_char();
                am = this.concatenate(ct);
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                am = this.concatenate(st);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public ArrayMaths concatenate(Stat xx) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int type = xx.type;
        ArrayMaths am = new ArrayMaths();
        switch (xx.type) {
            case 0: 
            case 1: {
                double[] dd = xx.getArray_as_double();
                am = this.concatenate(dd);
                break;
            }
            case 2: 
            case 3: {
                float[] ff = xx.getArray_as_float();
                am = this.concatenate(ff);
                break;
            }
            case 4: 
            case 5: {
                long[] ll = xx.getArray_as_long();
                am = this.concatenate(ll);
                break;
            }
            case 6: 
            case 7: {
                int[] ii = xx.getArray_as_int();
                am = this.concatenate(ii);
                break;
            }
            case 8: 
            case 9: {
                short[] ss = xx.getArray_as_short();
                am = this.concatenate(ss);
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = xx.getArray_as_byte();
                am = this.concatenate(bb);
                break;
            }
            case 12: {
                BigDecimal[] bd = xx.getArray_as_BigDecimal();
                am = this.concatenate(bd);
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                am = this.concatenate(bi);
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                am = this.concatenate(cc);
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                am = this.concatenate(pp);
                break;
            }
            case 16: 
            case 17: {
                char[] ct = this.getArray_as_char();
                am = this.concatenate(ct);
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                am = this.concatenate(st);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] maxminIndices = new int[2];
        ArrayMaths.findMinMax(am.getArray_as_Object(), am.minmax, maxminIndices, am.typeName, am.type);
        am.maxIndex = maxminIndices[0];
        am.minIndex = maxminIndices[1];
        Conv.restoreMessages();
        return am;
    }

    public int indexOf(double value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 0 || this.type == 1) {
            double[] arrayc = this.getArray_as_double();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter] == value2) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare double or Double with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Double value2) {
        double val = value2;
        return this.indexOf(val);
    }

    public int indexOf(float value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 2 || this.type == 3) {
            float[] arrayc = this.getArray_as_float();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter] == value2) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare float or Float with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Float value2) {
        float val = value2.floatValue();
        return this.indexOf(val);
    }

    public int indexOf(long value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 4 || this.type == 5) {
            long[] arrayc = this.getArray_as_long();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter] == value2) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare long or Long with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Long value2) {
        long val = value2;
        return this.indexOf(val);
    }

    public int indexOf(int value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 6 || this.type == 7) {
            int[] arrayc = this.getArray_as_int();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter] == value2) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare int or Integer with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Integer value2) {
        int val = value2;
        return this.indexOf(val);
    }

    public int indexOf(short value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 8 || this.type == 9) {
            short[] arrayc = this.getArray_as_short();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter] == value2) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare short or Short with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Short value2) {
        short val = value2;
        return this.indexOf(val);
    }

    public int indexOf(byte value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 10 || this.type == 11) {
            byte[] arrayc = this.getArray_as_byte();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter] == value2) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare byte or Byte with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Byte value2) {
        byte val = value2;
        return this.indexOf(val);
    }

    public int indexOf(char value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 16 || this.type == 17) {
            char[] arrayc = this.getArray_as_char();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter] == value2) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare char or Character with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Character value2) {
        char val = value2.charValue();
        return this.indexOf(val);
    }

    public int indexOf(String value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 18) {
            String[] arrayc = this.getArray_as_String();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter].equals(value2)) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare String with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Complex value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 14) {
            Complex[] arrayc = this.getArray_as_Complex();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter].equals(value2)) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Complex with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(Phasor value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 15) {
            Phasor[] arrayc = this.getArray_as_Phasor();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter].equals(value2)) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Phasor with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(BigDecimal value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 12) {
            BigDecimal[] arrayc = this.getArray_as_BigDecimal();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter].compareTo(value2) == 0) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigDecimal with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int indexOf(BigInteger value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = -1;
        if (this.type == 13) {
            BigInteger[] arrayc = this.getArray_as_BigInteger();
            boolean test2 = true;
            int counter = 0;
            while (test2) {
                if (arrayc[counter].compareTo(value2) == 0) {
                    index2 = counter;
                    test2 = false;
                    continue;
                }
                if (++counter < arrayc.length) continue;
                test2 = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigInteger with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int[] indicesOf(double value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 0 || this.type == 1) {
            double[] arrayc = this.getArray_as_double();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i] == value2) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare double or Double with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Double value2) {
        double val = value2;
        return this.indicesOf(val);
    }

    public int[] indicesOf(float value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 2 || this.type == 3) {
            float[] arrayc = this.getArray_as_float();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i] == value2) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare float or Float with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Float value2) {
        float val = value2.floatValue();
        return this.indicesOf(val);
    }

    public int[] indicesOf(long value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 4 || this.type == 5) {
            long[] arrayc = this.getArray_as_long();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i] == value2) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare long or Long with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Long value2) {
        long val = value2;
        return this.indicesOf(val);
    }

    public int[] indicesOf(int value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 6 || this.type == 7) {
            int[] arrayc = this.getArray_as_int();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i] == value2) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare int or Integer with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Integer value2) {
        int val = value2;
        return this.indicesOf(val);
    }

    public int[] indicesOf(short value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 8 || this.type == 9) {
            short[] arrayc = this.getArray_as_short();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i] == value2) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare short or Short with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Short value2) {
        short val = value2;
        return this.indicesOf(val);
    }

    public int[] indicesOf(byte value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 10 || this.type == 11) {
            byte[] arrayc = this.getArray_as_byte();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i] == value2) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare byte or Byte with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Byte value2) {
        byte val = value2;
        return this.indicesOf(val);
    }

    public int[] indicesOf(char value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 16 || this.type == 17) {
            char[] arrayc = this.getArray_as_char();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i] == value2) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare char or Character with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Character value2) {
        char val = value2.charValue();
        return this.indicesOf(val);
    }

    public int[] indicesOf(String value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 18) {
            String[] arrayc = this.getArray_as_String();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i].equals(value2)) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare String with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Complex value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 14) {
            Complex[] arrayc = this.getArray_as_Complex();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i].equals(value2)) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Complex with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(Phasor value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 15) {
            Phasor[] arrayc = this.getArray_as_Phasor();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i].equals(value2)) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Phasor with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(BigDecimal value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 12) {
            BigDecimal[] arrayc = this.getArray_as_BigDecimal();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i].compareTo(value2) == 0) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigDecimal with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int[] indicesOf(BigInteger value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] indices = null;
        int numberOfIndices = 0;
        if (this.type == 13) {
            BigInteger[] arrayc = this.getArray_as_BigInteger();
            ArrayList<Integer> arrayl = new ArrayList<Integer>();
            int i = 0;
            while (i < this.length) {
                if (arrayc[i].compareTo(value2) == 0) {
                    ++numberOfIndices;
                    arrayl.add(new Integer(i));
                }
                ++i;
            }
            if (numberOfIndices != 0) {
                indices = new int[numberOfIndices];
                i = 0;
                while (i < numberOfIndices) {
                    indices[i] = (Integer)arrayl.get(i);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigInteger with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return indices;
    }

    public int nearestIndex(double value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 0 || this.type == 1) {
            double[] arrayc = this.getArray_as_double();
            double diff2 = Math.abs(arrayc[0] - value2);
            double nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (Math.abs(arrayc[i] - value2) < diff2) {
                    diff2 = Math.abs(arrayc[i] - value2);
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare double or Double with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(Double value2) {
        double val = value2;
        return this.nearestIndex(val);
    }

    public int nearestIndex(float value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 2 || this.type == 3) {
            float[] arrayc = this.getArray_as_float();
            float diff2 = Math.abs(arrayc[0] - value2);
            float nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (Math.abs(arrayc[i] - value2) < diff2) {
                    diff2 = Math.abs(arrayc[i] - value2);
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare float or Float with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(Float value2) {
        float val = value2.floatValue();
        return this.nearestIndex(val);
    }

    public int nearestIndex(long value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 4 || this.type == 5) {
            long[] arrayc = this.getArray_as_long();
            long diff2 = Math.abs(arrayc[0] - value2);
            long nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (Math.abs(arrayc[i] - value2) < diff2) {
                    diff2 = Math.abs(arrayc[i] - value2);
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare long or Long with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(Long value2) {
        long val = value2;
        return this.nearestIndex(val);
    }

    public int nearestIndex(int value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 6 || this.type == 7) {
            int[] arrayc = this.getArray_as_int();
            int diff2 = Math.abs(arrayc[0] - value2);
            int nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (Math.abs(arrayc[i] - value2) < diff2) {
                    diff2 = Math.abs(arrayc[i] - value2);
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare int or Integer with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(Integer value2) {
        int val = value2;
        return this.nearestIndex(val);
    }

    public int nearestIndex(short value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 8 || this.type == 9) {
            short[] arrayc = this.getArray_as_short();
            short diff2 = (short)Math.abs(arrayc[0] - value2);
            short nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (Math.abs(arrayc[i] - value2) < diff2) {
                    diff2 = (short)Math.abs(arrayc[i] - value2);
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare short or Short with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(Short value2) {
        short val = value2;
        return this.nearestIndex(val);
    }

    public int nearestIndex(byte value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 10 || this.type == 11) {
            byte[] arrayc = this.getArray_as_byte();
            byte diff2 = (byte)Math.abs(arrayc[0] - value2);
            byte nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (Math.abs(arrayc[i] - value2) < diff2) {
                    diff2 = (byte)Math.abs(arrayc[i] - value2);
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare byte or Byte with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(Byte value2) {
        byte val = value2;
        return this.nearestIndex(val);
    }

    public int nearestIndex(char value2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 16 || this.type == 17) {
            int[] arrayc = this.getArray_as_int();
            int diff2 = Math.abs(arrayc[0] - value2);
            int nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (Math.abs(arrayc[i] - value2) < diff2) {
                    diff2 = Math.abs(arrayc[i] - value2);
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare char or Character with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(Character value2) {
        char val = value2.charValue();
        return this.nearestIndex(val);
    }

    public int nearestIndex(BigDecimal value2) {
        BigDecimal nearest;
        BigDecimal diff2;
        BigDecimal[] arrayc;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 12) {
            arrayc = this.getArray_as_BigDecimal();
            diff2 = arrayc[0].subtract(value2).abs();
            nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (arrayc[i].subtract(value2).abs().compareTo(diff2) == -1) {
                    diff2 = arrayc[i].subtract(value2).abs();
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigDecimal with " + this.typeName[this.type]);
        }
        arrayc = null;
        diff2 = null;
        nearest = null;
        Conv.restoreMessages();
        return index2;
    }

    public int nearestIndex(BigInteger value2) {
        BigInteger nearest;
        BigInteger diff2;
        BigInteger[] arrayc;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int index2 = 0;
        if (this.type == 12) {
            arrayc = this.getArray_as_BigInteger();
            diff2 = arrayc[0].subtract(value2).abs();
            nearest = arrayc[0];
            int i = 1;
            while (i < arrayc.length) {
                if (arrayc[i].subtract(value2).abs().compareTo(diff2) == -1) {
                    diff2 = arrayc[i].subtract(value2).abs();
                    index2 = i;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigInteger with " + this.typeName[this.type]);
        }
        arrayc = null;
        diff2 = null;
        nearest = null;
        Conv.restoreMessages();
        return index2;
    }

    public double nearestValue(double value2) {
        int index2 = this.nearestIndex(value2);
        double ret = (Double)this.array.get(index2);
        return ret;
    }

    public Double nearestValue(Double value2) {
        int index2 = this.nearestIndex(value2);
        Double ret = (Double)this.array.get(index2);
        return ret;
    }

    public float nearestValue(float value2) {
        int index2 = this.nearestIndex(value2);
        float ret = ((Float)this.array.get(index2)).floatValue();
        return ret;
    }

    public Float nearestValue(Float value2) {
        int index2 = this.nearestIndex(value2);
        Float ret = (Float)this.array.get(index2);
        return ret;
    }

    public long nearestValue(long value2) {
        int index2 = this.nearestIndex(value2);
        long ret = (Long)this.array.get(index2);
        return ret;
    }

    public Long nearestValue(Long value2) {
        int index2 = this.nearestIndex(value2);
        Long ret = (Long)this.array.get(index2);
        return ret;
    }

    public int nearestValue(int value2) {
        int index2 = this.nearestIndex(value2);
        int ret = (Integer)this.array.get(index2);
        return ret;
    }

    public Integer nearestValue(Integer value2) {
        int index2 = this.nearestIndex(value2);
        Integer ret = (Integer)this.array.get(index2);
        return ret;
    }

    public short nearestValue(short value2) {
        int index2 = this.nearestIndex(value2);
        short ret = (Short)this.array.get(index2);
        return ret;
    }

    public Short nearestValue(Short value2) {
        int index2 = this.nearestIndex(value2);
        Short ret = (Short)this.array.get(index2);
        return ret;
    }

    public byte nearestValue(byte value2) {
        int index2 = this.nearestIndex(value2);
        byte ret = (Byte)this.array.get(index2);
        return ret;
    }

    public Byte nearestValue(Byte value2) {
        int index2 = this.nearestIndex(value2);
        Byte ret = (Byte)this.array.get(index2);
        return ret;
    }

    public char nearestValue(char value2) {
        int index2 = this.nearestIndex(value2);
        char ret = ((Character)this.array.get(index2)).charValue();
        return ret;
    }

    public Character nearestValue(Character value2) {
        int index2 = this.nearestIndex(value2);
        Character ret = (Character)this.array.get(index2);
        return ret;
    }

    public BigDecimal nearestValue(BigDecimal value2) {
        int index2 = this.nearestIndex(value2);
        BigDecimal ret = (BigDecimal)this.array.get(index2);
        return ret;
    }

    public BigInteger nearestValue(BigInteger value2) {
        int index2 = this.nearestIndex(value2);
        BigInteger ret = (BigInteger)this.array.get(index2);
        return ret;
    }

    public double maximumDifference() {
        return this.getMaximumDifference_as_double();
    }

    public double maximumDifference_as_double() {
        return this.getMaximumDifference_as_double();
    }

    public double getMaximumDifference() {
        return this.getMaximumDifference_as_double();
    }

    public double getMaximumDifference_as_double() {
        double diff2 = 0.0;
        if (this.type != 0 && this.type != 1) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as double or Double the difference for a " + this.typeName[this.type] + "[] array");
        }
        double max2 = this.getMaximum_as_double();
        double min2 = this.getMinimum_as_double();
        diff2 = max2 - min2;
        return diff2;
    }

    public Double maximumDifference_as_Double() {
        return this.getMaximumDifference_as_Double();
    }

    public Double getMaximumDifference_as_Double() {
        return new Double(this.getMaximumDifference_as_double());
    }

    public float maximumDifference_as_float() {
        return this.getMaximumDifference_as_float();
    }

    public float getMaximumDifference_as_float() {
        float diff2 = 0.0f;
        if (this.type != 2 && this.type != 3) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as float or Float the difference for a " + this.typeName[this.type] + "[] array");
        }
        float max2 = this.getMaximum_as_float();
        float min2 = this.getMinimum_as_float();
        diff2 = max2 - min2;
        return diff2;
    }

    public Float maximumDifference_as_Float() {
        return this.getMaximumDifference_as_Float();
    }

    public Float getMaximumDifference_as_Float() {
        return new Float(this.getMaximumDifference_as_float());
    }

    public long maximumDifference_as_long() {
        return this.getMaximumDifference_as_long();
    }

    public long getMaximumDifference_as_long() {
        long diff2 = 0L;
        if (this.type != 4 && this.type != 5) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as long or Long the difference for a " + this.typeName[this.type] + "[] array");
        }
        long max2 = this.getMaximum_as_long();
        long min2 = this.getMinimum_as_long();
        diff2 = max2 - min2;
        return diff2;
    }

    public Long maximumDifference_as_Long() {
        return this.getMaximumDifference_as_Long();
    }

    public Long getMaximumDifference_as_Long() {
        return new Long(this.getMaximumDifference_as_long());
    }

    public int maximumDifference_as_int() {
        return this.getMaximumDifference_as_int();
    }

    public int getMaximumDifference_as_int() {
        int diff2 = 0;
        if (this.type != 6 && this.type != 7) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as int or Integer the difference for a " + this.typeName[this.type] + "[] array");
        }
        int max2 = this.getMaximum_as_int();
        int min2 = this.getMinimum_as_int();
        diff2 = max2 - min2;
        return diff2;
    }

    public Integer maximumDifference_as_Integer() {
        return this.getMaximumDifference_as_Integer();
    }

    public Integer getMaximumDifference_as_Integer() {
        return new Integer(this.getMaximumDifference_as_int());
    }

    public short maximumDifference_as_short() {
        return this.getMaximumDifference_as_short();
    }

    public short getMaximumDifference_as_short() {
        short diff2 = 0;
        if (this.type != 8 && this.type != 9) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as short or Short the difference for a " + this.typeName[this.type] + "[] array");
        }
        short max2 = this.getMaximum_as_short();
        short min2 = this.getMinimum_as_short();
        diff2 = (short)(max2 - min2);
        return diff2;
    }

    public Short maximumDifference_as_Short() {
        return this.getMaximumDifference_as_Short();
    }

    public Short getMaximumDifference_as_Short() {
        return new Short(this.getMaximumDifference_as_short());
    }

    public byte maximumDifference_as_byte() {
        return this.getMaximumDifference_as_byte();
    }

    public byte getMaximumDifference_as_byte() {
        byte diff2 = 0;
        if (this.type != 10 && this.type != 11) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as byte or Byte the difference for a " + this.typeName[this.type] + "[] array");
        }
        byte max2 = this.getMaximum_as_byte();
        byte min2 = this.getMinimum_as_byte();
        diff2 = (byte)(max2 - min2);
        return diff2;
    }

    public Byte maximumDifference_as_Byte() {
        return this.getMaximumDifference_as_Byte();
    }

    public Byte getMaximumDifference_as_Byte() {
        return new Byte(this.getMaximumDifference_as_byte());
    }

    public BigDecimal maximumDifference_as_BigDecimal() {
        return this.getMaximumDifference_as_BigDecimal();
    }

    public BigDecimal getMaximumDifference_as_BigDecimal() {
        BigDecimal diff2 = BigDecimal.ZERO;
        if (this.type != 12) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigDecimal the difference for a " + this.typeName[this.type] + "[] array");
        }
        BigDecimal max2 = this.getMaximum_as_BigDecimal();
        BigDecimal min2 = this.getMinimum_as_BigDecimal();
        diff2 = max2.subtract(min2);
        max2 = null;
        min2 = null;
        return diff2;
    }

    public BigInteger maximumDifference_as_BigInteger() {
        return this.getMaximumDifference_as_BigInteger();
    }

    public BigInteger getMaximumDifference_as_BigInteger() {
        BigInteger diff2 = BigInteger.ZERO;
        if (this.type != 13) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigInteger the difference for a " + this.typeName[this.type] + "[] array");
        }
        BigInteger max2 = this.getMaximum_as_BigInteger();
        BigInteger min2 = this.getMinimum_as_BigInteger();
        diff2 = max2.subtract(min2);
        max2 = null;
        min2 = null;
        return diff2;
    }

    public double minimumDifference() {
        return this.getMinimumDifference_as_double();
    }

    public double minimumDifference_as_double() {
        return this.getMinimumDifference_as_double();
    }

    public double getMinimumDifference() {
        return this.getMinimumDifference_as_double();
    }

    public double getMinimumDifference_as_double() {
        double diff2 = 0.0;
        if (this.type == 0 || this.type == 1) {
            ArrayMaths am = this.sort();
            double[] sorted2 = am.getArray_as_double();
            double minDiff = diff2 = sorted2[1] - sorted2[0];
            int i = 1;
            while (i < this.length - 1) {
                diff2 = sorted2[i + 1] - sorted2[i];
                if (diff2 < minDiff) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as double or Double the difference for a " + this.typeName[this.type] + "[] array");
        }
        return diff2;
    }

    public Double minimumDifference_as_Double() {
        return this.getMinimumDifference_as_Double();
    }

    public Double getMinimumDifference_as_Double() {
        return new Double(this.getMinimumDifference_as_double());
    }

    public float minimumDifference_as_float() {
        return this.getMinimumDifference_as_float();
    }

    public float getMinimumDifference_as_float() {
        float diff2 = 0.0f;
        if (this.type == 2 || this.type == 3) {
            ArrayMaths am = this.sort();
            float[] sorted2 = am.getArray_as_float();
            float minDiff = diff2 = sorted2[1] - sorted2[0];
            int i = 1;
            while (i < this.length - 1) {
                diff2 = sorted2[i + 1] - sorted2[i];
                if (diff2 < minDiff) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as float or Float the difference for a " + this.typeName[this.type] + "[] array");
        }
        return diff2;
    }

    public Float minimumDifference_as_Float() {
        return this.getMinimumDifference_as_Float();
    }

    public Float getMinimumDifference_as_Float() {
        return new Float(this.getMinimumDifference_as_float());
    }

    public long minimumDifference_as_long() {
        return this.getMinimumDifference_as_long();
    }

    public long getMinimumDifference_as_long() {
        long diff2 = 0L;
        if (this.type == 4 || this.type == 5) {
            ArrayMaths am = this.sort();
            long[] sorted2 = am.getArray_as_long();
            long minDiff = diff2 = sorted2[1] - sorted2[0];
            int i = 1;
            while (i < this.length - 1) {
                diff2 = sorted2[i + 1] - sorted2[i];
                if (diff2 < minDiff) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as long or Long the difference for a " + this.typeName[this.type] + "[] array");
        }
        return diff2;
    }

    public Long minimumDifference_as_Long() {
        return this.getMinimumDifference_as_Long();
    }

    public Long getMinimumDifference_as_Long() {
        return new Long(this.getMinimumDifference_as_long());
    }

    public int minimumDifference_as_int() {
        return this.getMinimumDifference_as_int();
    }

    public int getMinimumDifference_as_int() {
        int diff2 = 0;
        if (this.type == 6 || this.type == 7) {
            ArrayMaths am = this.sort();
            int[] sorted2 = am.getArray_as_int();
            int minDiff = diff2 = sorted2[1] - sorted2[0];
            int i = 1;
            while (i < this.length - 1) {
                diff2 = sorted2[i + 1] - sorted2[i];
                if (diff2 < minDiff) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as int or Integer the difference for a " + this.typeName[this.type] + "[] array");
        }
        return diff2;
    }

    public Integer minimumDifference_as_Integer() {
        return this.getMinimumDifference_as_Integer();
    }

    public Integer getMinimumDifference_as_Integer() {
        return new Integer(this.getMinimumDifference_as_int());
    }

    public short minimumDifference_as_short() {
        return this.getMinimumDifference_as_short();
    }

    public short getMinimumDifference_as_short() {
        short diff2 = 0;
        if (this.type == 8 || this.type == 9) {
            ArrayMaths am = this.sort();
            short[] sorted2 = am.getArray_as_short();
            short minDiff = diff2 = (short)(sorted2[1] - sorted2[0]);
            int i = 1;
            while (i < this.length - 1) {
                diff2 = (short)(sorted2[i + 1] - sorted2[i]);
                if (diff2 < minDiff) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as short or Short the difference for a " + this.typeName[this.type] + "[] array");
        }
        return diff2;
    }

    public Short minimumDifference_as_Short() {
        return this.getMinimumDifference_as_Short();
    }

    public Short getMinimumDifference_as_Short() {
        return new Short(this.getMinimumDifference_as_short());
    }

    public byte minimumDifference_as_byte() {
        return this.getMinimumDifference_as_byte();
    }

    public byte getMinimumDifference_as_byte() {
        byte diff2 = 0;
        if (this.type == 10 || this.type == 11) {
            ArrayMaths am = this.sort();
            byte[] sorted2 = am.getArray_as_byte();
            byte minDiff = diff2 = (byte)(sorted2[1] - sorted2[0]);
            int i = 1;
            while (i < this.length - 1) {
                diff2 = (byte)(sorted2[i + 1] - sorted2[i]);
                if (diff2 < minDiff) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as byte or Byte the difference for a " + this.typeName[this.type] + "[] array");
        }
        return diff2;
    }

    public Byte minimumDifference_as_Byte() {
        return this.getMinimumDifference_as_Byte();
    }

    public Byte getMinimumDifference_as_Byte() {
        return new Byte(this.getMinimumDifference_as_byte());
    }

    public BigDecimal minimumDifference_as_BigDecimal() {
        return this.getMinimumDifference_as_BigDecimal();
    }

    public BigDecimal getMinimumDifference_as_BigDecimal() {
        BigDecimal minDiff;
        BigDecimal[] sorted2;
        BigDecimal diff2 = BigDecimal.ZERO;
        if (this.type == 12) {
            ArrayMaths am = this.sort();
            sorted2 = am.getArray_as_BigDecimal();
            minDiff = diff2 = sorted2[1].subtract(sorted2[0]);
            int i = 1;
            while (i < this.length - 1) {
                diff2 = sorted2[i + 1].subtract(sorted2[i]);
                if (diff2.compareTo(minDiff) == -1) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigDecimal the difference for a " + this.typeName[this.type] + "[] array");
        }
        sorted2 = null;
        minDiff = null;
        return diff2;
    }

    public BigInteger minimumDifference_as_BigInteger() {
        return this.getMinimumDifference_as_BigInteger();
    }

    public BigInteger getMinimumDifference_as_BigInteger() {
        BigInteger minDiff;
        BigInteger[] sorted2;
        BigInteger diff2 = BigInteger.ZERO;
        if (this.type == 12) {
            ArrayMaths am = this.sort();
            sorted2 = am.getArray_as_BigInteger();
            minDiff = diff2 = sorted2[1].subtract(sorted2[0]);
            int i = 1;
            while (i < this.length - 1) {
                diff2 = sorted2[i + 1].subtract(sorted2[i]);
                if (diff2.compareTo(minDiff) == -1) {
                    minDiff = diff2;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigInteger the difference for a " + this.typeName[this.type] + "[] array");
        }
        sorted2 = null;
        minDiff = null;
        return diff2;
    }

    public void print() {
        switch (this.type) {
            case 0: 
            case 1: {
                Double[] dd = this.getArray_as_Double();
                PrintToScreen.print(dd);
                break;
            }
            case 2: 
            case 3: {
                Float[] ff = this.getArray_as_Float();
                PrintToScreen.print(ff);
                break;
            }
            case 4: 
            case 5: {
                Long[] ll = this.getArray_as_Long();
                PrintToScreen.print(ll);
                break;
            }
            case 6: 
            case 7: {
                Integer[] ii = this.getArray_as_Integer();
                PrintToScreen.print(ii);
                break;
            }
            case 8: 
            case 9: {
                Short[] ss = this.getArray_as_Short();
                PrintToScreen.print(ss);
                break;
            }
            case 10: 
            case 11: {
                Byte[] bb = this.getArray_as_Byte();
                PrintToScreen.print(bb);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                PrintToScreen.print(bd);
                bd = null;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                PrintToScreen.print(bi);
                bi = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                PrintToScreen.print(cc);
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                PrintToScreen.print(pp);
                break;
            }
            case 16: 
            case 17: {
                Character[] ct = this.getArray_as_Character();
                PrintToScreen.print(ct);
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                PrintToScreen.print(st);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
    }

    public void println() {
        switch (this.type) {
            case 0: 
            case 1: {
                Double[] dd = this.getArray_as_Double();
                PrintToScreen.println(dd);
                break;
            }
            case 2: 
            case 3: {
                Float[] ff = this.getArray_as_Float();
                PrintToScreen.println(ff);
                break;
            }
            case 4: 
            case 5: {
                Long[] ll = this.getArray_as_Long();
                PrintToScreen.println(ll);
                break;
            }
            case 6: 
            case 7: {
                Integer[] ii = this.getArray_as_Integer();
                PrintToScreen.println(ii);
                break;
            }
            case 8: 
            case 9: {
                Short[] ss = this.getArray_as_Short();
                PrintToScreen.println(ss);
                break;
            }
            case 10: 
            case 11: {
                Byte[] bb = this.getArray_as_Byte();
                PrintToScreen.println(bb);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                PrintToScreen.println(bd);
                bd = null;
                break;
            }
            case 13: {
                BigInteger[] bi = this.getArray_as_BigInteger();
                PrintToScreen.println(bi);
                bi = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                PrintToScreen.println(cc);
                break;
            }
            case 15: {
                Phasor[] pp = this.getArray_as_Phasor();
                PrintToScreen.println(pp);
                break;
            }
            case 16: 
            case 17: {
                Character[] ct = this.getArray_as_Character();
                PrintToScreen.println(ct);
                break;
            }
            case 18: {
                String[] st = this.getArray_as_String();
                PrintToScreen.println(st);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
    }

    public void convertToHighest() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                Double[] dd = this.getArray_as_Double();
                this.array.clear();
                int i = 0;
                while (i < this.length) {
                    this.array.add(dd[i]);
                    ++i;
                }
                this.type = 1;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                this.array.clear();
                int i = 0;
                while (i < this.length) {
                    this.array.add(bd[i]);
                    ++i;
                }
                this.type = 12;
                bd = null;
                break;
            }
            case 14: 
            case 15: {
                Complex[] cc = this.getArray_as_Complex();
                this.array.clear();
                int i = 0;
                while (i < this.length) {
                    this.array.add(cc[i]);
                    ++i;
                }
                this.type = 14;
            }
        }
    }

    public void plot(int n) {
        if (n > 2) {
            throw new IllegalArgumentException("Argument n, " + n + ", must be less than 3");
        }
        double[] xAxis = new double[this.length];
        int i = 0;
        while (i < this.length) {
            xAxis[i] = i;
            ++i;
        }
        double[] yAxis = this.getArray_as_double();
        PlotGraph pg = new PlotGraph(xAxis, yAxis);
        pg.setGraphTitle("ArrayMaths plot method");
        pg.setXaxisLegend("Array element index");
        pg.setYaxisLegend("Array element value");
        pg.setPoint(1);
        switch (n) {
            case 0: {
                pg.setLine(0);
                pg.setGraphTitle2("Points only - no line");
                break;
            }
            case 1: {
                pg.setLine(3);
                pg.setGraphTitle2("Points joined by straight lines");
                break;
            }
            case 2: {
                pg.setLine(1);
                pg.setGraphTitle2("Points joined by cubic spline interpolated line");
                break;
            }
            default: {
                throw new IllegalArgumentException("Should not be possible to get here!!!");
            }
        }
        pg.plot();
    }
}

