/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.interpolation.TriCubicSpline;
import flanagan.math.Fmath;

public class QuadriCubicSpline {
    private int nPoints = 0;
    private int mPoints = 0;
    private int lPoints = 0;
    private int kPoints = 0;
    private double[][][][] y = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] x3 = null;
    private double[] x4 = null;
    private double[] xMin = new double[4];
    private double[] xMax = new double[4];
    private TriCubicSpline[] tcsn = null;
    private CubicSpline csm = null;
    private double[][][][] d2ydx2inner = null;
    private boolean derivCalculated = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public QuadriCubicSpline(double[] x1, double[] x2, double[] x3, double[] x4, double[][][][] y) {
        this.nPoints = x1.length;
        this.mPoints = x2.length;
        this.lPoints = x3.length;
        this.kPoints = x4.length;
        if (this.nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + y.length);
        }
        if (this.mPoints != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + y[0].length);
        }
        if (this.lPoints != y[0][0].length) {
            throw new IllegalArgumentException("Arrays x3 and y-column are of different length " + this.mPoints + " " + y[0][0].length);
        }
        if (this.kPoints != y[0][0][0].length) {
            throw new IllegalArgumentException("Arrays x4 and y-column are of different length " + this.kPoints + " " + y[0][0][0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3 || this.lPoints < 3 || this.kPoints < 3) {
            throw new IllegalArgumentException("The tabulated 4D array must have a minimum size of 3 X 3 X 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.tcsn = TriCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints, this.kPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.lPoints];
        this.x4 = new double[this.kPoints];
        this.y = new double[this.nPoints][this.mPoints][this.lPoints][this.kPoints];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints][this.lPoints][this.kPoints];
        int i = 0;
        while (i < this.nPoints) {
            this.x1[i] = x1[i];
            ++i;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        int j = 0;
        while (j < this.mPoints) {
            this.x2[j] = x2[j];
            ++j;
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        j = 0;
        while (j < this.lPoints) {
            this.x3[j] = x3[j];
            ++j;
        }
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        j = 0;
        while (j < this.kPoints) {
            this.x4[j] = x4[j];
            ++j;
        }
        this.xMin[3] = Fmath.minimum(this.x4);
        this.xMax[3] = Fmath.maximum(this.x4);
        i = 0;
        while (i < this.nPoints) {
            int j2 = 0;
            while (j2 < this.mPoints) {
                int k = 0;
                while (k < this.lPoints) {
                    int l = 0;
                    while (l < this.kPoints) {
                        this.y[i][j2][k][l] = y[i][j2][k][l];
                        ++l;
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        double[][][] yTempml = new double[this.mPoints][this.lPoints][this.kPoints];
        int i2 = 0;
        while (i2 < this.nPoints) {
            int j3 = 0;
            while (j3 < this.mPoints) {
                int k = 0;
                while (k < this.lPoints) {
                    int l = 0;
                    while (l < this.kPoints) {
                        yTempml[j3][k][l] = y[i2][j3][k][l];
                        ++l;
                    }
                    ++k;
                }
                ++j3;
            }
            this.tcsn[i2].resetData(x2, x3, x4, yTempml);
            this.d2ydx2inner[i2] = this.tcsn[i2].getDeriv();
            ++i2;
        }
        double[] yTempm = new double[this.nPoints];
        this.derivCalculated = true;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        TriCubicSpline.noRoundingErrorCheck();
        BiCubicSpline.noRoundingErrorCheck();
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        QuadriCubicSpline.potentialRoundingError = potentialRoundingError;
        TriCubicSpline.potentialRoundingError(potentialRoundingError);
        BiCubicSpline.potentialRoundingError(potentialRoundingError);
        CubicSpline.potentialRoundingError(potentialRoundingError);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        int i = 0;
        while (i < this.tcsn.length) {
            this.tcsn[i].averageIdenticalAbscissae();
            ++i;
        }
        CubicSpline.averageIdenticalAbscissae();
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1], this.xMin[2], this.xMax[2], this.xMin[3], this.xMax[3]};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        int i = 0;
        while (i < 2) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
            ++i;
        }
        System.out.println(" ");
    }

    public double interpolate(double xx1, double xx2, double xx3, double xx4) {
        double[] yTempm = new double[this.nPoints];
        int i = 0;
        while (i < this.nPoints) {
            yTempm[i] = this.tcsn[i].interpolate(xx2, xx3, xx4);
            ++i;
        }
        this.csm.resetData(this.x1, yTempm);
        return this.csm.interpolate(xx1);
    }

    public double[][][][] getDeriv() {
        return this.d2ydx2inner;
    }

    public void setDeriv(double[][][][] d2ydx2) {
        this.d2ydx2inner = d2ydx2;
        this.derivCalculated = true;
    }
}

