/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.math.Fmath;
import flanagan.math.Point;
import flanagan.math.VectorMaths;
import flanagan.plot.PlotGraph;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class PolylineSimplification {
    private Point[] originalPoints = null;
    private int nPoints = 0;
    private Point[] simplifiedPoints = null;
    private int[] simplifiedIndices = null;
    private int nSimplifiedPoints = 0;
    private int pointDimension = 0;
    private double tolerance = 0.0;
    private double toleranceSquared = 0.0;
    private boolean tolerenceEntered = false;
    private boolean simplifyDone = false;

    public PolylineSimplification(Point[] points) {
        this.originalPoints = points;
        int[] n = Point.getArrayDimensions(points);
        this.nPoints = n[0];
        this.pointDimension = n[1];
        if (this.pointDimension > 3 || this.pointDimension < 2) {
            throw new IllegalArgumentException("This method will not operate on dimensions greater than 3");
        }
        this.simplifyDone = false;
    }

    public PolylineSimplification(double[] xpoints, double[] ypoints) {
        this.pointDimension = 2;
        this.nPoints = xpoints.length;
        if (this.nPoints != ypoints.length) {
            throw new IllegalArgumentException("The number of x-coordinate points, " + this.nPoints + ", must equal the number of y-coordinate points, " + ypoints.length);
        }
        this.originalPoints = Point.oneDarray(xpoints, ypoints);
        this.simplifyDone = false;
    }

    public PolylineSimplification(double[] xpoints, double[] ypoints, double[] zpoints) {
        this.pointDimension = 3;
        this.nPoints = xpoints.length;
        if (this.nPoints != ypoints.length) {
            throw new IllegalArgumentException("The number of x-coordinate points, " + this.nPoints + ", must equal the number of y-coordinate points, " + ypoints.length);
        }
        if (this.nPoints != zpoints.length) {
            throw new IllegalArgumentException("The number of x-coordinate points, " + this.nPoints + ", must equal the number of z-coordinate points, " + zpoints.length);
        }
        this.originalPoints = Point.oneDarray(xpoints, ypoints, zpoints);
        this.simplifyDone = false;
    }

    public PolylineSimplification(double[][] points) {
        this.pointDimension = points.length;
        this.nPoints = points[0].length;
        this.originalPoints = Point.oneDarray(points);
        if (this.pointDimension > 3 || this.pointDimension < 2) {
            throw new IllegalArgumentException("This method will not operate on dimensions greater than 3");
        }
        this.simplifyDone = false;
    }

    public PolylineSimplification(Object points) {
        Object internalArrays = Fmath.copyObject(points);
        this.nPoints = 1;
        while (!((internalArrays = Array.get(internalArrays, 0)) instanceof Double)) {
            ++this.nPoints;
        }
        double[][] hold = (double[][])points;
        this.pointDimension = hold.length;
        this.originalPoints = Point.oneDarray(hold);
        if (this.pointDimension > 3 || this.pointDimension < 2) {
            throw new IllegalArgumentException("This method will not operate on dimensions greater than 3 or less than 2");
        }
        this.simplifyDone = false;
    }

    public Point[] douglasPeucker(double tolerance) {
        this.tolerance = tolerance;
        this.toleranceSquared = tolerance * tolerance;
        this.tolerenceEntered = true;
        return this.douglasPeucker();
    }

    public Point[] douglasPeucker() {
        int i = 0;
        int k = 0;
        int toleratedCounter = 0;
        Point[] buffer = Point.oneDarray(this.nPoints);
        int[] indicesBuffer = new int[this.nPoints];
        boolean[] pointMarker = new boolean[this.nPoints];
        if (this.pointDimension == 2) {
            this.toThreeDimO();
        }
        buffer[0] = this.originalPoints[0].copy();
        indicesBuffer[0] = 0;
        k = 1;
        i = 1;
        while (i < this.nPoints) {
            if (!(Point.distanceSquared(this.originalPoints[i], this.originalPoints[toleratedCounter]) < this.toleranceSquared)) {
                buffer[k] = this.originalPoints[i].copy();
                indicesBuffer[k] = i;
                toleratedCounter = i;
                ++k;
            }
            ++i;
        }
        if (toleratedCounter < this.nPoints - 1) {
            buffer[k] = this.originalPoints[this.nPoints - 1].copy();
            indicesBuffer[k] = this.nPoints - 1;
            ++k;
        }
        pointMarker[0] = true;
        pointMarker[k - 1] = true;
        this.douglasPeuckerSimplificationRoutine(buffer, 0, k - 1, pointMarker);
        ArrayList<Point> results = new ArrayList<Point>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        i = 0;
        while (i < k) {
            if (pointMarker[i]) {
                results.add(buffer[i]);
                indices.add(new Integer(indicesBuffer[i]));
            }
            ++i;
        }
        this.nSimplifiedPoints = results.size();
        this.simplifiedPoints = Point.oneDarray(this.nSimplifiedPoints);
        this.simplifiedIndices = new int[this.nSimplifiedPoints];
        i = 0;
        while (i < this.nSimplifiedPoints) {
            this.simplifiedPoints[i] = (Point)results.get(i);
            this.simplifiedIndices[i] = (Integer)indices.get(i);
            ++i;
        }
        Point[] hold0 = Point.copy(this.simplifiedPoints);
        int[] hold1 = (int[])this.simplifiedIndices.clone();
        i = 0;
        while (i < this.nSimplifiedPoints - 1) {
            int j = i + 1;
            while (j < this.nSimplifiedPoints) {
                if (Point.isEqual(hold0[i], hold0[j])) {
                    int p = j;
                    while (p < this.nSimplifiedPoints - 1) {
                        hold0[p] = hold0[p + 1];
                        hold1[p] = hold1[p + 1];
                        ++p;
                    }
                    --this.nSimplifiedPoints;
                }
                ++j;
            }
            ++i;
        }
        this.simplifiedPoints = Point.oneDarray(this.nSimplifiedPoints);
        i = 0;
        while (i < this.nSimplifiedPoints) {
            this.simplifiedPoints[i] = hold0[i];
            this.simplifiedIndices[i] = hold1[i];
            ++i;
        }
        if (this.pointDimension == 2) {
            this.toTwoDimO();
            this.toTwoDimS();
        }
        this.simplifyDone = true;
        return this.simplifiedPoints;
    }

    private void douglasPeuckerSimplificationRoutine(Point[] bpoints, int j, int k, boolean[] pointMarker) {
        if (k <= j + 1) {
            return;
        }
        int farthesti = j;
        double farthestDistance2 = 0.0;
        Point[] segment = Point.oneDarray(2);
        segment[0] = bpoints[j];
        segment[1] = bpoints[k];
        VectorMaths vjk = new VectorMaths(bpoints[j], bpoints[k]);
        double dist2jk = bpoints[j].distanceSquared(bpoints[k]);
        VectorMaths seg0i = null;
        Point perplBase = null;
        double lratio = 0.0;
        double svang = 0.0;
        double dist2ps = 0.0;
        int i = j + 1;
        while (i < k) {
            seg0i = new VectorMaths(segment[0], bpoints[i]);
            svang = seg0i.dot(vjk);
            if (svang <= 0.0) {
                dist2ps = Point.distanceSquared(bpoints[i], segment[0]);
            } else if (dist2jk <= svang) {
                dist2ps = Point.distanceSquared(bpoints[i], segment[1]);
            } else {
                lratio = svang / dist2jk;
                VectorMaths vlr = vjk.times(lratio);
                VectorMaths s0vlr = new VectorMaths(segment[0]).plus(vlr);
                perplBase = s0vlr.getFinalPoint();
                dist2ps = Point.distanceSquared(bpoints[i], perplBase);
            }
            if (!(dist2ps <= farthestDistance2)) {
                farthesti = i;
                farthestDistance2 = dist2ps;
            }
            ++i;
        }
        if (farthestDistance2 > this.toleranceSquared) {
            pointMarker[farthesti] = true;
            this.douglasPeuckerSimplificationRoutine(bpoints, j, farthesti, pointMarker);
            this.douglasPeuckerSimplificationRoutine(bpoints, farthesti, k, pointMarker);
        }
    }

    private void toThreeDimO() {
        int i = 0;
        while (i < this.nPoints) {
            this.originalPoints[i].toThreeD();
            ++i;
        }
    }

    private void toTwoDimO() {
        int i = 0;
        while (i < this.nPoints) {
            this.originalPoints[i].toTwoD();
            ++i;
        }
    }

    private void toTwoDimS() {
        int i = 0;
        while (i < this.nSimplifiedPoints) {
            this.simplifiedPoints[i].toTwoD();
            ++i;
        }
    }

    public double[][] simplifiedCurveCoordinates() {
        if (!this.simplifyDone) {
            if (!this.tolerenceEntered) {
                throw new IllegalArgumentException("No tolerance has been entered");
            }
            this.douglasPeucker();
        }
        return Point.getArrayCoordinates(this.simplifiedPoints);
    }

    public Point[] simplifiedCurve() {
        if (!this.simplifyDone) {
            if (!this.tolerenceEntered) {
                throw new IllegalArgumentException("No tolerance has been entered");
            }
            this.douglasPeucker();
        }
        return this.simplifiedPoints;
    }

    public int numberOfSimplifiedCurvePoints() {
        return this.nSimplifiedPoints;
    }

    public int[] simplifiedCurveIndices() {
        return this.simplifiedIndices;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
        this.toleranceSquared = tolerance * tolerance;
        this.tolerenceEntered = true;
    }

    public double getTolerance() {
        if (!this.tolerenceEntered) {
            System.out.println("No tolerance has been entered; 0.0 returned");
        }
        return this.tolerance;
    }

    public void plot() {
        if (this.pointDimension != 2) {
            throw new IllegalArgumentException("Plot will only function for an array of 2D points");
        }
        double[][] cc0 = Point.getArrayCoordinates(this.originalPoints);
        double[][] cc1 = this.simplifiedCurveCoordinates();
        double[][] data2 = new double[][]{cc0[0], cc0[1], cc1[0], cc1[1]};
        PlotGraph pg = new PlotGraph(data2);
        int[] lineOpt = new int[]{3, 3};
        pg.setLine(lineOpt);
        pg.setXaxisLegend("x-coordinate");
        pg.setYaxisLegend("y-coordinate");
        pg.setGraphTitle("Polyline Simplification: tolerance = " + this.tolerance);
        pg.setGraphTitle2("circles = original data, squares = simplified curve");
        pg.plot();
    }
}

