/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

public class CubicSplineFast {
    private int nPoints = 0;
    private double[] y = null;
    private double[] x = null;
    private double[] d2ydx2 = null;
    private boolean derivCalculated = false;

    public CubicSplineFast(double[] x2, double[] y) {
        this.nPoints = x2.length;
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        this.d2ydx2 = new double[this.nPoints];
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = x2[i];
            this.y[i] = y[i];
            ++i;
        }
        this.calcDeriv();
    }

    public CubicSplineFast(int nPoints) {
        this.nPoints = nPoints;
        this.x = new double[nPoints];
        this.y = new double[nPoints];
        this.d2ydx2 = new double[nPoints];
    }

    public void resetData(double[] x2, double[] y) {
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = x2[i];
            this.y[i] = y[i];
            ++i;
        }
    }

    public static CubicSplineFast zero(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        CubicSplineFast aa = new CubicSplineFast(n);
        return aa;
    }

    public static CubicSplineFast[] oneDarray(int n, int m) {
        CubicSplineFast[] a = new CubicSplineFast[n];
        int i = 0;
        while (i < n) {
            a[i] = CubicSplineFast.zero(m);
            ++i;
        }
        return a;
    }

    public void calcDeriv() {
        double p = 0.0;
        double qn = 0.0;
        double sig = 0.0;
        double un = 0.0;
        double[] u = new double[this.nPoints];
        u[0] = 0.0;
        this.d2ydx2[0] = 0.0;
        int i = 1;
        while (i <= this.nPoints - 2) {
            sig = (this.x[i] - this.x[i - 1]) / (this.x[i + 1] - this.x[i - 1]);
            p = sig * this.d2ydx2[i - 1] + 2.0;
            this.d2ydx2[i] = (sig - 1.0) / p;
            u[i] = (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i]) - (this.y[i] - this.y[i - 1]) / (this.x[i] - this.x[i - 1]);
            u[i] = (6.0 * u[i] / (this.x[i + 1] - this.x[i - 1]) - sig * u[i - 1]) / p;
            ++i;
        }
        un = 0.0;
        qn = 0.0;
        this.d2ydx2[this.nPoints - 1] = (un - qn * u[this.nPoints - 2]) / (qn * this.d2ydx2[this.nPoints - 2] + 1.0);
        int k = this.nPoints - 2;
        while (k >= 0) {
            this.d2ydx2[k] = this.d2ydx2[k] * this.d2ydx2[k + 1] + u[k];
            --k;
        }
        this.derivCalculated = true;
    }

    public double interpolate(double xx) {
        double h = 0.0;
        double b = 0.0;
        double a = 0.0;
        double yy = 0.0;
        int k = 0;
        int klo = 0;
        int khi = this.nPoints - 1;
        while (khi - klo > 1) {
            k = khi + klo >> 1;
            if (this.x[k] > xx) {
                khi = k;
                continue;
            }
            klo = k;
        }
        h = this.x[khi] - this.x[klo];
        if (h == 0.0) {
            throw new IllegalArgumentException("Two values of x are identical: point " + klo + " (" + this.x[klo] + ") and point " + khi + " (" + this.x[khi] + ")");
        }
        a = (this.x[khi] - xx) / h;
        b = (xx - this.x[klo]) / h;
        yy = a * this.y[klo] + b * this.y[khi] + ((a * a * a - a) * this.d2ydx2[klo] + (b * b * b - b) * this.d2ydx2[khi]) * (h * h) / 6.0;
        return yy;
    }
}

