/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.CubicSpline;
import flanagan.math.Fmath;

public class BiCubicSpline {
    private int nPoints = 0;
    private int mPoints = 0;
    private int nPointsT = 0;
    private int mPointsT = 0;
    private double[][] y = null;
    private double[][] yT = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double xx1 = Double.NaN;
    private double xx2 = Double.NaN;
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private double[][] d2ydx2inner = null;
    private double[][] d2ydx2innerT = null;
    private CubicSpline[] csn = null;
    private CubicSpline csm = null;
    private CubicSpline[] csnT = null;
    private CubicSpline csmT = null;
    private double interpolatedValue = Double.NaN;
    private double interpolatedValueTranspose = Double.NaN;
    private double interpolatedValueMean = Double.NaN;
    private boolean derivCalculated = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public BiCubicSpline(double[] x1, double[] x2, double[][] y) {
        int j;
        this.nPoints = x1.length;
        this.nPointsT = this.mPoints = x2.length;
        this.mPointsT = this.nPoints;
        if (this.nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + y.length);
        }
        if (this.mPoints != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + y[0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.csn = CubicSpline.oneDarray(this.nPoints, this.mPoints);
        this.csmT = new CubicSpline(this.mPoints);
        this.csnT = CubicSpline.oneDarray(this.nPointsT, this.mPointsT);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.yT = new double[this.nPointsT][this.mPointsT];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints];
        this.d2ydx2innerT = new double[this.nPointsT][this.mPointsT];
        int i = 0;
        while (i < this.nPoints) {
            this.x1[i] = x1[i];
            ++i;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        int j2 = 0;
        while (j2 < this.mPoints) {
            this.x2[j2] = x2[j2];
            ++j2;
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        i = 0;
        while (i < this.nPoints) {
            j = 0;
            while (j < this.mPoints) {
                this.y[i][j] = y[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nPointsT) {
            j = 0;
            while (j < this.mPointsT) {
                this.yT[i][j] = y[j][i];
                ++j;
            }
            ++i;
        }
        double[] yTempn = new double[this.mPoints];
        int i2 = 0;
        while (i2 < this.nPoints) {
            int j3 = 0;
            while (j3 < this.mPoints) {
                yTempn[j3] = y[i2][j3];
                ++j3;
            }
            this.csn[i2].resetData(x2, yTempn);
            this.csn[i2].calcDeriv();
            this.d2ydx2inner[i2] = this.csn[i2].getDeriv();
            ++i2;
        }
        double[] yTempnT = new double[this.mPointsT];
        int i3 = 0;
        while (i3 < this.nPointsT) {
            int j4 = 0;
            while (j4 < this.mPointsT) {
                yTempnT[j4] = this.yT[i3][j4];
                ++j4;
            }
            this.csnT[i3].resetData(x1, yTempnT);
            this.csnT[i3].calcDeriv();
            this.d2ydx2innerT[i3] = this.csnT[i3].getDeriv();
            ++i3;
        }
        this.derivCalculated = true;
    }

    public BiCubicSpline(int nP, int mP) {
        this.nPoints = nP;
        this.mPoints = mP;
        if (this.nPoints < 3 || this.mPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3");
        }
        this.nPointsT = mP;
        this.mPointsT = nP;
        this.csm = new CubicSpline(this.nPoints);
        this.csmT = new CubicSpline(this.nPointsT);
        if (!roundingCheck) {
            CubicSpline.noRoundingErrorCheck();
        }
        this.csn = CubicSpline.oneDarray(this.nPoints, this.mPoints);
        this.csnT = CubicSpline.oneDarray(this.nPointsT, this.mPointsT);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.yT = new double[this.nPointsT][this.mPointsT];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints];
        this.d2ydx2innerT = new double[this.nPointsT][this.mPointsT];
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        BiCubicSpline.potentialRoundingError = potentialRoundingError;
        CubicSpline.potentialRoundingError(potentialRoundingError);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        int i = 0;
        while (i < this.csn.length) {
            CubicSpline cfr_ignored_0 = this.csn[i];
            CubicSpline.averageIdenticalAbscissae();
            ++i;
        }
        CubicSpline.averageIdenticalAbscissae();
    }

    public void resetData(double[] x1, double[] x2, double[][] y) {
        if (x1.length != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y row are of different length");
        }
        if (x2.length != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y column are of different length");
        }
        if (this.nPoints != x1.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        if (this.mPoints != x2.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        int i = 0;
        while (i < this.nPoints) {
            this.x1[i] = x1[i];
            ++i;
        }
        i = 0;
        while (i < this.mPoints) {
            this.x2[i] = x2[i];
            ++i;
        }
        i = 0;
        while (i < this.nPoints) {
            int j = 0;
            while (j < this.mPoints) {
                this.y[i][j] = y[i][j];
                this.yT[j][i] = y[i][j];
                ++j;
            }
            ++i;
        }
        this.csm = new CubicSpline(this.nPoints);
        this.csn = CubicSpline.oneDarray(this.nPoints, this.mPoints);
        double[] yTempn = new double[this.mPoints];
        int i2 = 0;
        while (i2 < this.nPoints) {
            int j = 0;
            while (j < this.mPoints) {
                yTempn[j] = y[i2][j];
                ++j;
            }
            this.csn[i2].resetData(x2, yTempn);
            this.csn[i2].calcDeriv();
            this.d2ydx2inner[i2] = this.csn[i2].getDeriv();
            ++i2;
        }
        this.csmT = new CubicSpline(this.nPointsT);
        this.csnT = CubicSpline.oneDarray(this.nPointsT, this.mPointsT);
        double[] yTempnT = new double[this.mPointsT];
        int i3 = 0;
        while (i3 < this.nPointsT) {
            int j = 0;
            while (j < this.mPointsT) {
                yTempnT[j] = this.yT[i3][j];
                ++j;
            }
            this.csnT[i3].resetData(x1, yTempnT);
            this.csnT[i3].calcDeriv();
            this.d2ydx2innerT[i3] = this.csnT[i3].getDeriv();
            ++i3;
        }
        this.derivCalculated = true;
    }

    public static BiCubicSpline zero(int nP, int mP) {
        if (nP < 3 || mP < 3) {
            throw new IllegalArgumentException("A minimum of three x three data points is needed");
        }
        BiCubicSpline aa = new BiCubicSpline(nP, mP);
        return aa;
    }

    public static BiCubicSpline[] oneDarray(int nP, int mP, int lP) {
        if (mP < 3 || lP < 3) {
            throw new IllegalArgumentException("A minimum of three x three data points is needed");
        }
        BiCubicSpline[] a = new BiCubicSpline[nP];
        int i = 0;
        while (i < nP) {
            a[i] = BiCubicSpline.zero(mP, lP);
            ++i;
        }
        return a;
    }

    public double[][] getDeriv() {
        return this.d2ydx2inner;
    }

    public double[][] getDerivTranspose() {
        return this.d2ydx2innerT;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1]};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        int i = 0;
        while (i < 2) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
            ++i;
        }
        System.out.println(" ");
    }

    public void setDeriv(double[][] d2ydx2) {
        this.d2ydx2inner = d2ydx2;
        this.derivCalculated = true;
    }

    public void setDerivTranspose(double[][] d2ydx2) {
        this.d2ydx2innerT = d2ydx2;
        this.derivCalculated = true;
    }

    public double interpolate(double xx1, double xx2) {
        this.xx1 = xx1;
        this.xx2 = xx2;
        double[] yTempm = new double[this.nPoints];
        int i = 0;
        while (i < this.nPoints) {
            yTempm[i] = this.csn[i].interpolate(xx2);
            ++i;
        }
        this.csm.resetData(this.x1, yTempm);
        this.interpolatedValue = this.csm.interpolate(xx1);
        double[] yTempmT = new double[this.nPointsT];
        int i2 = 0;
        while (i2 < this.nPointsT) {
            yTempmT[i2] = this.csnT[i2].interpolate(xx1);
            ++i2;
        }
        this.csmT.resetData(this.x2, yTempmT);
        this.interpolatedValueTranspose = this.csmT.interpolate(xx2);
        this.interpolatedValueMean = (this.interpolatedValue + this.interpolatedValueTranspose) / 2.0;
        return this.interpolatedValueMean;
    }

    public double[] getInterpolatedValues() {
        double[] ret = new double[]{this.interpolatedValueMean, this.interpolatedValue, this.interpolatedValueTranspose, this.xx1, this.xx2};
        return ret;
    }
}

