/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class Prop
extends BlackBox {
    private double kp = 1.0;

    public Prop() {
        super("Prop");
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
        this.sNumerScaleFactor = Complex.plusOne();
        this.sDenomScaleFactor = Complex.plusOne();
    }

    public Prop(double kp) {
        super("Prop");
        this.kp = kp;
        super.setSnumer(new ComplexPoly(this.kp));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
        this.sNumerScaleFactor = new Complex(kp, 0.0);
        this.sDenomScaleFactor = Complex.plusOne();
    }

    public void setKp(double kp) {
        this.kp = kp;
        Complex num = new Complex(this.kp, 0.0);
        this.sNumer.resetCoeff(0, num);
        super.addDeadTimeExtras();
        this.sNumerScaleFactor = new Complex(kp, 0.0);
    }

    public double getKp() {
        return this.kp;
    }

    @Override
    public void zTransform() {
        this.zNumerDeg = 0;
        this.zDenomDeg = 0;
        this.zNumer = new ComplexPoly(this.kp);
        this.zDenom = new ComplexPoly(1.0);
    }

    @Override
    public void zTransform(double deltaT) {
        super.setDeltaT(deltaT);
        this.zTransform();
    }

    @Override
    public void stepInput(double stepMag, double finalTime) {
        int n = 51;
        double incrT = finalTime / (double)(n - 2);
        double[][] cdata = new double[2][n];
        cdata[0][0] = 0.0;
        cdata[0][1] = 0.0;
        int i = 2;
        while (i < n) {
            cdata[0][i] = cdata[0][i - 1] + incrT;
            ++i;
        }
        double kpterm = this.kp * stepMag;
        cdata[1][0] = 0.0;
        int i2 = 1;
        while (i2 < n) {
            cdata[1][i2] = kpterm;
            ++i2;
        }
        if (this.deadTime != 0.0) {
            i2 = 0;
            while (i2 < n) {
                double[] dArray = cdata[0];
                int n2 = i2++;
                dArray[n2] = dArray[n2] + this.deadTime;
            }
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
        pg.setGraphTitle2(this.getName());
        pg.setXaxisLegend("Time");
        pg.setXaxisUnitsName("s");
        pg.setYaxisLegend("Output");
        pg.setPoint(0);
        pg.setLine(3);
        pg.plot();
    }

    @Override
    public void stepInput(double finalTime) {
        this.stepInput(1.0, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, int rampOrder, double finalTime) {
        if (rampOrder == 0) {
            this.stepInput(rampGradient, finalTime);
        } else {
            int n = 50;
            double incrT = finalTime / (double)(n - 1);
            double[][] cdata = new double[2][n];
            double sum2 = 0.0;
            cdata[0][0] = 0.0;
            cdata[1][0] = 0.0;
            int i = 1;
            while (i < n) {
                cdata[0][i] = cdata[0][i - 1] + incrT;
                cdata[1][i] = rampGradient * Math.pow(cdata[0][i], rampOrder) * this.kp;
                ++i;
            }
            if (this.deadTime != 0.0) {
                i = 0;
                while (i < n) {
                    double[] dArray = cdata[0];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] + this.deadTime;
                }
            }
            PlotGraph pg = new PlotGraph(cdata);
            pg.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + rampGradient + " ramp order (n) = " + rampOrder);
            pg.setGraphTitle2(this.getName());
            pg.setXaxisLegend("Time");
            pg.setXaxisUnitsName("s");
            pg.setYaxisLegend("Output");
            pg.setPoint(0);
            pg.plot();
        }
    }

    @Override
    public void rampInput(int rampOrder, double finalTime) {
        double rampGradient = 1.0;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, double finalTime) {
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double finalTime) {
        double rampGradient = 1.0;
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public Complex getOutputS(Complex sValue, Complex iinput) {
        this.sValue = sValue;
        this.inputS = iinput;
        this.outputS = this.inputS.times(this.kp);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        this.outputS = this.inputS.times(this.kp);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double ttime, double inp) {
        super.setInputT(ttime, inp);
        this.calcOutputT();
    }

    public void calcOutputT() {
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
    }

    @Override
    public Complex[] getZerosS() {
        System.out.println("Proportional gain controller has no s-domain zeros");
        return null;
    }

    @Override
    public Complex[] getPolesS() {
        System.out.println("Proportional gain controller has no s-domain poles");
        return null;
    }

    @Override
    public Prop copy() {
        if (this == null) {
            return null;
        }
        Prop bb = new Prop();
        this.copyBBvariables(bb);
        bb.kp = this.kp;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

