/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.complex.ComplexPoly;
import flanagan.interpolation.CubicSpline;
import flanagan.io.Db;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import flanagan.plot.PlotPoleZero;

public class BlackBox {
    protected int sampLen = 0;
    protected double[] inputT = null;
    protected double[] outputT = null;
    protected double[] time = null;
    protected double forgetFactor = 1.0;
    protected double deltaT = 0.0;
    protected double sampFreq = 0.0;
    protected Complex inputS = new Complex();
    protected Complex outputS = new Complex();
    protected Complex sValue = new Complex();
    protected Complex zValue = new Complex();
    protected ComplexPoly sNumer = new ComplexPoly(1.0);
    protected ComplexPoly sDenom = new ComplexPoly(1.0);
    protected ComplexPoly zNumer = new ComplexPoly(1.0);
    protected ComplexPoly zDenom = new ComplexPoly(1.0);
    protected boolean sNumerSet = false;
    protected boolean sDenomSet = false;
    protected Complex sNumerScaleFactor = Complex.plusOne();
    protected Complex sDenomScaleFactor = Complex.plusOne();
    protected Complex sNumerWorkingFactor = Complex.plusOne();
    protected Complex sDenomWorkingFactor = Complex.plusOne();
    protected Complex[] sPoles = null;
    protected Complex[] sZeros = null;
    protected Complex[] zPoles = null;
    protected Complex[] zZeros = null;
    protected int sNumerDeg = 0;
    protected int sDenomDeg = 0;
    protected int zNumerDeg = 0;
    protected int zDenomDeg = 0;
    protected double deadTime = 0.0;
    protected int orderPade = 2;
    protected ComplexPoly sNumerPade = new ComplexPoly(1.0);
    protected ComplexPoly sDenomPade = new ComplexPoly(1.0);
    protected Complex[] sPolesPade = null;
    protected Complex[] sZerosPade = null;
    protected int sNumerDegPade = 0;
    protected int sDenomDegPade = 0;
    protected boolean maptozero = true;
    protected boolean padeAdded = false;
    protected double integrationSum = 0.0;
    protected int integMethod = 1;
    protected int ztransMethod = 0;
    protected String name = "BlackBox";
    protected String fixedName = "BlackBox";
    protected int nPlotPoints = 400;
    protected String[] subclassName = new String[]{"BlackBox", "OpenLoop", "ClosedLoop", "Prop", "PropDeriv", "PropInt", "PropIntDeriv", "FirstOrder", "SecondOrder", "Compensator", "LowPassPassive", "HighPassPassive", "Transducer", "DelayLine", "ZeroOrderHold", "AtoD", "DtoA"};
    protected int nSubclasses = this.subclassName.length;
    protected int subclassIndex = 0;

    public BlackBox() {
    }

    public BlackBox(String name) {
        this.name = name;
        this.fixedName = name;
        this.setSubclassIndex();
    }

    protected void setSubclassIndex() {
        boolean test2 = true;
        int i = 0;
        while (test2) {
            if (this.fixedName.equals(this.subclassName[i])) {
                this.subclassIndex = i;
                test2 = false;
                continue;
            }
            if (++i < this.nSubclasses) continue;
            System.out.println("Subclass name, " + this.fixedName + ", not recognised as a recorder subclass");
            System.out.println("Subclass, " + this.fixedName + ", handled as BlackBox");
            this.subclassIndex = i;
            test2 = false;
        }
    }

    public void setSnumer(double[] coeff) {
        this.sNumerDeg = coeff.length - 1;
        this.sNumer = new ComplexPoly(coeff);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    protected void addDeadTimeExtras() {
        this.sNumerDegPade = this.sNumerDeg;
        this.sNumerPade = this.sNumer.copy();
        this.sDenomDegPade = this.sDenomDeg;
        this.sDenomPade = this.sDenom.copy();
        if (this.deadTime == 0.0) {
            this.transferPolesZeros();
        } else {
            this.pade();
        }
    }

    public void setSnumer(Complex[] coeff) {
        this.sNumerDeg = coeff.length - 1;
        this.sNumer = new ComplexPoly(coeff);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSnumer(ComplexPoly coeff) {
        this.sNumerDeg = coeff.getDeg();
        this.sNumer = ComplexPoly.copy(coeff);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(double[] coeff) {
        this.sDenomDeg = coeff.length - 1;
        this.sDenom = new ComplexPoly(coeff);
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(Complex[] coeff) {
        this.sDenomDeg = coeff.length - 1;
        this.sDenom = new ComplexPoly(coeff);
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(ComplexPoly coeff) {
        this.sDenomDeg = coeff.getDeg();
        this.sDenom = coeff.copy();
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public static Complex scaleFactor(ComplexPoly poly, Complex[] roots) {
        int nRoots = roots.length;
        Complex mean = new Complex(0.0, 0.0);
        int i = 0;
        while (i < nRoots) {
            mean = mean.plus(roots[i]);
            ++i;
        }
        mean = mean.over(nRoots);
        boolean test2 = true;
        int ii = 0;
        while (test2) {
            if (mean.isEqual(roots[ii])) {
                if (mean.isEqual(Complex.zero())) {
                    int i2 = 0;
                    while (i2 < nRoots) {
                        mean = mean.plus(roots[i2].abs());
                        ++i2;
                    }
                    if (mean.isEqual(Complex.zero())) {
                        mean = Complex.plusOne();
                    }
                } else {
                    mean = mean.times(1.5);
                }
                ii = 0;
                continue;
            }
            if (++ii <= nRoots - 1) continue;
            test2 = false;
        }
        Complex product2 = new Complex(1.0, 0.0);
        int i3 = 0;
        while (i3 < nRoots) {
            product2 = product2.times(mean.minus(roots[i3]));
            ++i3;
        }
        Complex eval = poly.evaluate(mean);
        return eval.over(product2);
    }

    public Complex getSnumerScaleFactor() {
        if (this.sNumerScaleFactor == null) {
            this.calcPolesZerosS();
        }
        return this.sNumerScaleFactor;
    }

    public Complex getSdenomScaleFactor() {
        if (this.sDenomScaleFactor == null) {
            this.calcPolesZerosS();
        }
        return this.sDenomScaleFactor;
    }

    public void setDeadTime(double deadtime) {
        this.deadTime = deadtime;
        this.pade();
    }

    public void setDeadTime(double deadtime, int orderPade) {
        this.deadTime = deadtime;
        if (orderPade > 5) {
            orderPade = 4;
            System.out.println("BlackBox does not support Pade approximations above an order of 4");
            System.out.println("The order has been set to 4");
        }
        if (orderPade < 1) {
            orderPade = 1;
            System.out.println("Pade approximation order was less than 1");
            System.out.println("The order has been set to 1");
        }
        this.orderPade = orderPade;
        this.pade();
    }

    public void setPadeOrder(int orderPade) {
        if (orderPade > 5) {
            orderPade = 4;
            System.out.println("BlackBox does not support Pade approximations above an order of 4");
            System.out.println("The order has been set to 4");
        }
        if (orderPade < 1) {
            orderPade = 2;
            System.out.println("Pade approximation order was less than 1");
            System.out.println("The order has been set to 2");
        }
        this.orderPade = orderPade;
        this.pade();
    }

    public double getDeadTime() {
        return this.deadTime;
    }

    public int getPadeOrder() {
        return this.orderPade;
    }

    protected void pade() {
        ComplexPoly sNumerExtra = null;
        ComplexPoly sDenomExtra = null;
        Complex[] newZeros = null;
        Complex[] newPoles = null;
        switch (this.orderPade) {
            case 1: {
                this.sNumerDegPade = this.sNumerDeg + 1;
                this.sDenomDegPade = this.sDenomDeg + 1;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                sNumerExtra = new ComplexPoly(1.0, -this.deadTime / 2.0);
                sDenomExtra = new ComplexPoly(1.0, this.deadTime / 2.0);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newZeros = Complex.oneDarray(1);
                newZeros[0].reset(2.0 / this.deadTime, 0.0);
                newPoles = Complex.oneDarray(1);
                newPoles[0].reset(-2.0 / this.deadTime, 0.0);
                break;
            }
            case 2: {
                this.sNumerDegPade = this.sNumerDeg + 2;
                this.sDenomDegPade = this.sDenomDeg + 2;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                sNumerExtra = new ComplexPoly(1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                sDenomExtra = new ComplexPoly(1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                newPoles = sDenomExtra.rootsNoMessages();
                break;
            }
            case 3: {
                this.sNumerDegPade = this.sNumerDeg + 3;
                this.sDenomDegPade = this.sDenomDeg + 3;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                double[] termn3 = new double[]{1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 10.0, -Math.pow(this.deadTime, 3.0) / 120.0};
                sNumerExtra = new ComplexPoly(termn3);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                double[] termd3 = new double[]{1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 10.0, Math.pow(this.deadTime, 3.0) / 120.0};
                sDenomExtra = new ComplexPoly(termd3);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newPoles = sDenomExtra.rootsNoMessages();
                break;
            }
            case 4: {
                this.sNumerDegPade = this.sNumerDeg + 4;
                this.sDenomDegPade = this.sDenomDeg + 4;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                double[] termn4 = new double[]{1.0, -this.deadTime / 2.0, 3.0 * Math.pow(this.deadTime, 2.0) / 28.0, -Math.pow(this.deadTime, 3.0) / 84.0, Math.pow(this.deadTime, 4.0) / 1680.0};
                sNumerExtra = new ComplexPoly(termn4);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                double[] termd4 = new double[]{1.0, this.deadTime / 2.0, 3.0 * Math.pow(this.deadTime, 2.0) / 28.0, Math.pow(this.deadTime, 3.0) / 84.0, Math.pow(this.deadTime, 4.0) / 1680.0};
                sDenomExtra = new ComplexPoly(termd4);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newPoles = sDenomExtra.rootsNoMessages();
                break;
            }
            default: {
                this.orderPade = 2;
                this.sNumerDegPade = this.sNumerDeg + 2;
                this.sDenomDegPade = this.sDenomDeg + 2;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                sNumerExtra = new ComplexPoly(1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                sDenomExtra = new ComplexPoly(1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                newPoles = sDenomExtra.rootsNoMessages();
            }
        }
        if (this.sNumerPade != null && this.sNumerDegPade > 0) {
            this.sZerosPade = Complex.oneDarray(this.sNumerDegPade);
            int i = 0;
            while (i < this.sNumerDeg) {
                this.sZerosPade[i] = this.sZeros[i].copy();
                ++i;
            }
            i = 0;
            while (i < this.orderPade) {
                this.sZerosPade[i + this.sNumerDeg] = newZeros[i].copy();
                ++i;
            }
        }
        if (this.sDenomPade != null && this.sDenomDegPade > 0) {
            this.sPolesPade = Complex.oneDarray(this.sDenomDegPade);
            int i = 0;
            while (i < this.sDenomDeg) {
                this.sPolesPade[i] = this.sPoles[i].copy();
                ++i;
            }
            i = 0;
            while (i < this.orderPade) {
                this.sPolesPade[i + this.sDenomDeg] = newPoles[i].copy();
                ++i;
            }
        }
        this.zeroPoleCancellation();
        this.padeAdded = true;
    }

    protected void transferPolesZeros() {
        int i;
        this.sNumerDegPade = this.sNumerDeg;
        this.sNumerPade = this.sNumer.copy();
        if (this.sNumerDeg > 0 && this.sZeros != null) {
            this.sZerosPade = Complex.oneDarray(this.sNumerDeg);
            i = 0;
            while (i < this.sNumerDeg) {
                this.sZerosPade[i] = this.sZeros[i].copy();
                ++i;
            }
        }
        this.sDenomDegPade = this.sDenomDeg;
        this.sDenomPade = this.sDenom.copy();
        if (this.sDenomDeg > 0 && this.sPoles != null) {
            this.sPolesPade = Complex.oneDarray(this.sDenomDeg);
            i = 0;
            while (i < this.sDenomDeg) {
                this.sPolesPade[i] = this.sPoles[i].copy();
                ++i;
            }
        }
        this.zeroPoleCancellation();
        this.padeAdded = true;
    }

    public int orderPade() {
        return this.orderPade;
    }

    protected boolean deadTimeWarning(String method) {
        boolean warning = false;
        if (this.deadTime > this.deltaT) {
            System.out.println(String.valueOf(this.name) + "." + method + ": The dead time is greater than the sampling period");
            System.out.println("Dead time:       " + this.deadTime);
            System.out.println("Sampling period: " + this.deltaT);
            System.out.println("!!! The results of this program may not be physically meaningful !!!");
            warning = true;
        }
        return warning;
    }

    public void zTransform(double deltat) {
        this.mapstozAdHoc(deltat);
    }

    public void zTransform() {
        this.mapstozAdHoc();
    }

    public void mapstozAdHoc(double deltaT) {
        this.deltaT = deltaT;
        this.mapstozAdHoc();
    }

    public void mapstozAdHoc() {
        int infZeros;
        this.deadTimeWarning("mapstozAdHoc");
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.zDenomDeg = this.sDenomDegPade;
        ComplexPoly root2 = new ComplexPoly(1);
        this.zDenom = new ComplexPoly(this.zDenomDeg);
        if (this.zDenomDeg > 0) {
            this.zPoles = Complex.oneDarray(this.zDenomDeg);
            int i = 0;
            while (i < this.zDenomDeg) {
                this.zPoles[i] = Complex.exp(this.sPolesPade[i].times(this.deltaT));
                ++i;
            }
            this.zDenom = ComplexPoly.rootsToPoly(this.zPoles);
        }
        if ((infZeros = this.sDenomDegPade) + this.sNumerDegPade > this.sDenomDegPade) {
            infZeros = this.sDenomDegPade - this.sNumerDegPade;
        }
        this.zNumerDeg = this.sNumerDegPade + infZeros;
        this.zNumer = new ComplexPoly(this.zNumerDeg);
        this.zZeros = Complex.oneDarray(this.zNumerDeg);
        if (this.zNumerDeg > 0) {
            int i = 0;
            while (i < this.sNumerDegPade) {
                this.zZeros[i] = Complex.exp(this.sZerosPade[i].times(this.deltaT));
                ++i;
            }
            if (infZeros > 0) {
                if (this.maptozero) {
                    i = this.sNumerDegPade;
                    while (i < this.zNumerDeg) {
                        this.zZeros[i] = Complex.zero();
                        ++i;
                    }
                } else {
                    i = this.sNumerDegPade;
                    while (i < this.zNumerDeg) {
                        this.zZeros[i] = Complex.minusOne();
                        ++i;
                    }
                }
            }
            this.zNumer = ComplexPoly.rootsToPoly(this.zZeros);
        }
        this.sValue = Complex.zero();
        this.zValue = Complex.plusOne();
        boolean testzeros = true;
        while (testzeros) {
            int i;
            testzeros = false;
            if (this.sDenomDegPade > 0) {
                i = 0;
                while (i < this.sDenomDegPade) {
                    if (this.sPolesPade[i].truncate(3).equals(this.sValue.truncate(3))) {
                        testzeros = true;
                    }
                    ++i;
                }
            }
            if (!testzeros && this.sNumerDegPade > 0) {
                i = 0;
                while (i < this.sDenomDegPade) {
                    if (this.sZerosPade[i].truncate(3).equals(this.sValue.truncate(3))) {
                        testzeros = true;
                    }
                    ++i;
                }
            }
            if (!testzeros && this.zDenomDeg > 0) {
                i = 0;
                while (i < this.zDenomDeg) {
                    if (this.zPoles[i].truncate(3).equals(this.zValue.truncate(3))) {
                        testzeros = true;
                    }
                    ++i;
                }
            }
            if (!testzeros && this.zNumerDeg > 0) {
                i = 0;
                while (i < this.zDenomDeg) {
                    if (this.zZeros[i].truncate(3).equals(this.zValue.truncate(3))) {
                        testzeros = true;
                    }
                    ++i;
                }
            }
            if (!testzeros) continue;
            this.sValue = this.sValue.plus(Complex.plusJay()).truncate(3);
            this.zValue = Complex.exp(this.sValue.times(this.deltaT).truncate(3));
        }
        Complex gs = this.evalTransFunctS(this.sValue);
        Complex gz = this.evalTransFunctZ(this.zValue);
        Complex constant = gs.over(gz);
        ComplexPoly constantPoly = new ComplexPoly(constant);
        this.zNumer = this.zNumer.times(constantPoly);
    }

    public void setMaptozero(boolean maptozero) {
        this.maptozero = maptozero;
    }

    public void setZnumer(double[] coeff) {
        this.zNumerDeg = coeff.length - 1;
        this.zNumer = new ComplexPoly(coeff);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZnumer(Complex[] coeff) {
        this.zNumerDeg = coeff.length - 1;
        this.zNumer = new ComplexPoly(coeff);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZnumer(ComplexPoly coeff) {
        this.zNumerDeg = coeff.getDeg();
        this.zNumer = ComplexPoly.copy(coeff);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZdenom(double[] coeff) {
        this.zDenomDeg = coeff.length - 1;
        this.zDenom = new ComplexPoly(coeff);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setZdenom(Complex[] coeff) {
        this.zDenomDeg = coeff.length - 1;
        this.zDenom = new ComplexPoly(coeff);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setZdenom(ComplexPoly coeff) {
        this.zDenomDeg = coeff.getDeg();
        this.zDenom = ComplexPoly.copy(coeff);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setDeltaT(double deltaT) {
        if (this.deltaT == 0.0) {
            this.deltaT = deltaT;
            this.sampFreq = 1.0 / this.deltaT;
            this.deadTimeWarning("setDeltaT");
        } else {
            String question = "BlackBox setDeltaT: Do you wish to replace the deltaT value, " + this.deltaT + " with " + deltaT;
            if (Db.yesNo(question)) {
                this.deltaT = deltaT;
                this.sampFreq = 1.0 / this.deltaT;
                this.deadTimeWarning("setDeltaT");
                if (this.time != null) {
                    int holdS = this.sampLen;
                    this.sampLen = (int)Math.round(this.time[this.sampLen - 1] / this.deltaT);
                    double[] holdT = Conv.copy(this.time);
                    double[] holdI = Conv.copy(this.inputT);
                    this.time = new double[this.sampLen];
                    this.inputT = new double[this.sampLen];
                    CubicSpline cs = new CubicSpline(holdT, holdI);
                    this.time[0] = holdT[0];
                    this.inputT[0] = holdI[0];
                    int i = 1;
                    while (i < this.sampLen - 1) {
                        double d = this.deltaT;
                        this.time[i - 1] = d;
                        this.time[i] = d;
                        this.inputT[i] = cs.interpolate(this.time[i]);
                        ++i;
                    }
                    this.time[this.sampLen - 1] = holdT[holdS];
                    this.inputT[this.sampLen - 1] = holdI[holdS];
                }
            }
        }
    }

    public void setForgetFactor(double forget) {
        this.forgetFactor = forget;
    }

    public void setSampFreq(double sfreq) {
        this.sampFreq = sfreq;
        this.setDeltaT(1.0 / sfreq);
    }

    public void setS(Complex s) {
        this.sValue = Complex.copy(s);
    }

    public void setS(double sr, double si) {
        this.sValue.reset(sr, si);
    }

    public void setS(double si) {
        this.sValue.reset(0.0, si);
    }

    public void setZ(Complex z) {
        this.zValue = Complex.copy(z);
    }

    public void setZ(double zr, double zi) {
        this.zValue.reset(zr, zi);
    }

    public void setZtransformMethod(int ztransMethod) {
        if (ztransMethod < 0 || ztransMethod > 1) {
            System.out.println("z transform method option number " + ztransMethod + " not recognised");
            System.out.println("z tr methodansform option number set in BlackBox to the default value of 0 (s -> z ad hoc mapping)");
            this.integMethod = 0;
        } else {
            this.ztransMethod = ztransMethod;
        }
    }

    public void setIntegrateOption(int integMethod) {
        if (integMethod < 0 || integMethod > 2) {
            System.out.println("integration method option number " + integMethod + " not recognised");
            System.out.println("integration method option number set in BlackBox to the default value of 0 (trapezium rule)");
            this.integMethod = 0;
        } else {
            this.integMethod = integMethod;
        }
    }

    public void setIntegrateOption(String integMethodS) {
        if (integMethodS.equals("trapezium") || integMethodS.equals("Trapezium") || integMethodS.equals("tutin") || integMethodS.equals("Tutin")) {
            this.integMethod = 0;
        } else if (integMethodS.equals("backward") || integMethodS.equals("Backward") || integMethodS.equals("back") || integMethodS.equals("Back")) {
            this.integMethod = 1;
        } else if (integMethodS.equals("foreward") || integMethodS.equals("Foreward") || integMethodS.equals("fore") || integMethodS.equals("Fore")) {
            this.integMethod = 2;
        } else {
            System.out.println("integration method option  " + integMethodS + " not recognised");
            System.out.println("integration method option number set in PID to the default value of 0 (trapezium rule)");
            this.integMethod = 0;
        }
    }

    public void setSampleLength(int samplen) {
        if (samplen == 0) {
            throw new IllegalArgumentException("Entered sample length must be greater than zero");
        }
        if (samplen == 1) {
            samplen = 2;
        }
        if (this.sampLen == 0) {
            this.sampLen = samplen;
            this.time = new double[samplen];
            this.inputT = new double[samplen];
            this.outputT = new double[samplen];
        } else {
            String question = "BlackBox setSampleLength: Do you wish to replace the sample length, " + this.sampLen + " with " + samplen;
            if (Db.yesNo(question)) {
                int holdS = this.sampLen;
                this.sampLen = samplen;
                if (this.time != null) {
                    this.deltaT = this.time[holdS - 1] / (double)(samplen - 1);
                    double[] holdT = Conv.copy(this.time);
                    double[] holdI = Conv.copy(this.inputT);
                    this.time = new double[this.sampLen];
                    this.inputT = new double[this.sampLen];
                    CubicSpline cs = new CubicSpline(holdT, holdI);
                    this.time[0] = holdT[0];
                    this.inputT[0] = holdI[0];
                    int i = 1;
                    while (i < this.sampLen - 1) {
                        double d = this.deltaT;
                        this.time[i - 1] = d;
                        this.time[i] = d;
                        this.inputT[i] = cs.interpolate(this.time[i]);
                        ++i;
                    }
                    this.time[this.sampLen - 1] = holdT[holdS];
                    this.inputT[this.sampLen - 1] = holdI[holdS];
                }
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInputT(double ttime, double inputt) {
        if (this.deltaT == 0.0) {
            this.time = new double[2];
            this.time[0] = 0.0;
            this.time[1] = ttime;
            this.inputT = new double[2];
            this.inputT[0] = inputt;
            this.inputT[1] = inputt;
            this.outputT = new double[2];
            this.sampLen = 2;
        } else {
            double delta = this.deltaT;
            this.sampLen = (int)Math.round(ttime / delta);
            this.deltaT = ttime / (double)this.sampLen;
            if (!Fmath.isEqualWithinLimits(this.deltaT, delta, delta * 0.001)) {
                System.out.println("BlackBox setInputT method; deltaT has been reset from " + delta + " to " + this.deltaT);
            }
            this.sampFreq = 1.0 / this.deltaT;
            this.time = new double[this.sampLen];
            this.time[this.sampLen - 1] = ttime;
            this.inputT = new double[this.sampLen];
            this.inputT[this.sampLen - 1] = inputt;
            this.outputT = new double[this.sampLen];
            int i = this.sampLen - 2;
            while (i > 0) {
                this.time[i] = this.time[i + 1] - this.deltaT;
                this.inputT[i] = inputt;
                --i;
            }
            this.time[0] = 0.0;
            this.inputT[0] = inputt;
        }
    }

    public void setInputT(double[] ttime, double[] inputt) {
        int samplen = ttime.length;
        if (samplen != inputt.length) {
            throw new IllegalArgumentException("time and input arrays are of different lengths: " + samplen + ", " + inputt.length);
        }
        if (samplen == 1) {
            this.setInputT(ttime[0], inputt[0]);
        } else {
            this.sampLen = samplen;
            this.time = ttime;
            this.inputT = inputt;
            this.outputT = new double[this.sampLen];
            this.deltaT = ttime[this.sampLen] / (double)(this.sampLen - 1);
            this.sampFreq = 1.0 / this.deltaT;
        }
    }

    public void setInputS(Complex input2) {
        this.inputS = input2;
    }

    public void resetZero() {
        int i = 0;
        while (i < this.sampLen - 1) {
            this.outputT[i] = 0.0;
            this.inputT[i] = 0.0;
            this.time[i] = 0.0;
            ++i;
        }
        this.outputS = Complex.zero();
        this.inputS = Complex.zero();
        this.deltaT = 0.0;
        this.sampLen = 0;
    }

    protected void calcPolesZerosS() {
        if (this.sNumer != null) {
            if (this.sNumer.getDeg() > 0) {
                this.sZeros = this.sNumer.rootsNoMessages();
            }
            this.sNumerScaleFactor = this.sZeros != null ? BlackBox.scaleFactor(this.sNumer, this.sZeros) : this.sNumer.coeffCopy(0);
        }
        if (this.sDenom != null) {
            if (this.sDenom.getDeg() > 0) {
                this.sPoles = this.sDenom.rootsNoMessages();
            }
            this.sDenomScaleFactor = this.sPoles != null ? BlackBox.scaleFactor(this.sDenom, this.sPoles) : this.sDenom.coeffCopy(0);
        }
        if (this.sNumerPade != null && this.sNumerPade.getDeg() > 0) {
            this.sZerosPade = this.sNumerPade.rootsNoMessages();
        }
        if (this.sDenomPade != null && this.sDenomPade.getDeg() > 0) {
            this.sPolesPade = this.sDenomPade.rootsNoMessages();
        }
    }

    protected void zeroPoleCancellation() {
        int ii;
        boolean check2 = false;
        boolean testI = true;
        boolean testJ = true;
        int i = 0;
        int j = 0;
        if (this.sNumerDegPade == 0 || this.sDenomDegPade == 0) {
            testI = false;
        }
        if (this.sZerosPade == null || this.sPolesPade == null) {
            testI = false;
        }
        while (testI) {
            j = 0;
            while (testJ) {
                if (this.sZerosPade[i].isEqual(this.sPolesPade[j])) {
                    int k = j + 1;
                    while (k < this.sDenomDegPade) {
                        this.sPolesPade[k - 1] = this.sPolesPade[k].copy();
                        ++k;
                    }
                    --this.sDenomDegPade;
                    k = i + 1;
                    while (k < this.sNumerDegPade) {
                        this.sZerosPade[k - 1] = this.sZerosPade[k].copy();
                        ++k;
                    }
                    --this.sNumerDegPade;
                    check2 = true;
                    testJ = false;
                    --i;
                    continue;
                }
                if (++j <= this.sDenomDegPade - 1) continue;
                testJ = false;
            }
            if (++i <= this.sNumerDegPade - 1) continue;
            testI = false;
        }
        if (check2) {
            if (this.sNumerDegPade == 0) {
                this.sNumerPade = new ComplexPoly(1.0);
            } else {
                Complex[] holdn = Complex.oneDarray(this.sNumerDegPade);
                ii = 0;
                while (ii < this.sNumerDegPade) {
                    holdn[i] = this.sZerosPade[ii].copy();
                    ++ii;
                }
                this.sZerosPade = holdn;
                this.sNumerPade = ComplexPoly.rootsToPoly(this.sZerosPade);
            }
            if (this.sDenomDegPade == 0) {
                this.sDenomPade = new ComplexPoly(1.0);
            } else {
                Complex[] holdd = Complex.oneDarray(this.sDenomDegPade);
                ii = 0;
                while (ii < this.sDenomDegPade) {
                    holdd[i] = this.sPolesPade[ii].copy();
                    ++ii;
                }
                this.sPolesPade = holdd;
                this.sDenomPade = ComplexPoly.rootsToPoly(this.sPolesPade);
            }
        }
        check2 = false;
        testI = true;
        testJ = true;
        i = 0;
        j = 0;
        if (this.sNumerDeg == 0 || this.sDenomDeg == 0) {
            testI = false;
        }
        if (this.sZeros == null || this.sPoles == null) {
            testI = false;
        }
        while (testI) {
            j = 0;
            while (testJ) {
                if (this.sZeros[i].isEqual(this.sPoles[j])) {
                    int k = j + 1;
                    while (k < this.sDenomDeg) {
                        this.sPoles[k - 1] = this.sPoles[k].copy();
                        ++k;
                    }
                    --this.sDenomDeg;
                    k = i + 1;
                    while (k < this.sNumerDeg) {
                        this.sZeros[k - 1] = this.sZeros[k].copy();
                        ++k;
                    }
                    --this.sNumerDeg;
                    check2 = true;
                    testJ = false;
                    --i;
                    continue;
                }
                if (++j <= this.sDenomDeg - 1) continue;
                testJ = false;
            }
            if (++i <= this.sNumerDeg - 1) continue;
            testI = false;
        }
        if (check2) {
            if (this.sNumerDeg == 0) {
                this.sNumer = new ComplexPoly(1.0);
            } else {
                Complex[] holdn = Complex.oneDarray(this.sNumerDeg);
                ii = 0;
                while (ii < this.sNumerDeg) {
                    holdn[i] = this.sZeros[ii].copy();
                    ++ii;
                }
                this.sZeros = holdn;
                this.sNumer = ComplexPoly.rootsToPoly(this.sZeros);
                this.sNumerWorkingFactor = this.sNumerScaleFactor;
            }
            if (this.sDenomDeg == 0) {
                this.sDenom = new ComplexPoly(1.0);
            } else {
                Complex[] holdd = Complex.oneDarray(this.sDenomDeg);
                ii = 0;
                while (ii < this.sDenomDeg) {
                    holdd[i] = this.sPoles[ii].copy();
                    ++ii;
                }
                this.sPoles = holdd;
                this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
                this.sDenomWorkingFactor = this.sDenomScaleFactor;
            }
        }
    }

    public double getSeadyStateValue() {
        Complex num = this.sNumer.evaluate(Complex.zero());
        Complex den = this.sDenom.evaluate(Complex.zero());
        Complex ssc = num.over(den);
        double ssdr = ssc.getReal();
        double ssdi = ssc.getImag();
        if (Math.abs(ssdi) > Math.abs(ssdr) * 0.01) {
            System.out.println("method getSteadyStateValue: The imaginary part, " + ssdi + ", is greater than 1 per cent of the the real part, " + ssdr);
            System.out.println("Magnitude has  been returned");
        }
        return ssc.abs();
    }

    public double getSeadyStateValue(double mag) {
        Complex num = this.sNumer.evaluate(Complex.zero());
        Complex den = this.sDenom.evaluate(Complex.zero());
        Complex ssc = num.over(den);
        double ssdr = ssc.getReal();
        double ssdi = ssc.getImag();
        if (Math.abs(ssdi) > Math.abs(ssdr) * 0.01) {
            System.out.println("method getSteadyStateValue: The imaginary part, " + ssdi + ", is greater than 1 per cent of the the real part, " + ssdr);
            System.out.println("Magnitude has  been returned");
        }
        return mag * ssc.abs();
    }

    public Complex evalTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm);
    }

    public Complex evalTransFunctS(Complex sValue) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(sValue);
        Complex num = this.sNumer.evaluate(sValue);
        Complex den = this.sDenom.evaluate(sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm);
    }

    public Complex evalTransFunctS(double freq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * freq);
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm);
    }

    public double evalMagTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).abs();
    }

    public double evalMagTransFunctS(Complex sValue) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(sValue);
        Complex num = this.sNumer.evaluate(sValue);
        Complex den = this.sDenom.evaluate(sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).abs();
    }

    public double evalMagTransFunctS(double freq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * freq);
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).abs();
    }

    public double evalPhaseTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).arg();
    }

    public double evalPhaseTransFunctS(Complex sValue) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(sValue);
        Complex num = this.sNumer.evaluate(sValue);
        Complex den = this.sDenom.evaluate(sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).arg();
    }

    public double evalPhaseTransFunctS(double freq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * freq);
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).arg();
    }

    public Complex evalTransFunctZ() {
        Complex num = this.zNumer.evaluate(this.zValue);
        Complex den = this.zDenom.evaluate(this.zValue);
        return num.over(den);
    }

    public Complex evalTransFunctZ(Complex zValue) {
        this.zValue = Complex.copy(zValue);
        Complex num = this.zNumer.evaluate(zValue);
        Complex den = this.zDenom.evaluate(zValue);
        return num.over(den);
    }

    public double evalMagTransFunctZ() {
        Complex num = this.zNumer.evaluate(this.zValue);
        Complex den = this.zDenom.evaluate(this.zValue);
        return num.over(den).abs();
    }

    public double evalMagTransFunctZ(Complex zValue) {
        this.zValue = Complex.copy(zValue);
        Complex num = this.zNumer.evaluate(zValue);
        Complex den = this.zDenom.evaluate(zValue);
        return num.over(den).abs();
    }

    public double evalPhaseTransFunctZ() {
        Complex num = this.zNumer.evaluate(this.zValue);
        Complex den = this.zDenom.evaluate(this.zValue);
        return num.over(den).arg();
    }

    public double evalPhaseTransFunctZ(Complex zValue) {
        this.zValue = Complex.copy(zValue);
        Complex num = this.zNumer.evaluate(zValue);
        Complex den = this.zDenom.evaluate(zValue);
        return num.over(den).arg();
    }

    public int getIntegMethod() {
        return this.integMethod;
    }

    public int getZtransformMethod() {
        return this.ztransMethod;
    }

    public int getSampleLength() {
        return this.sampLen;
    }

    public double getForgetFactor() {
        return this.forgetFactor;
    }

    public double getCurrentTime() {
        return this.time[this.sampLen - 1];
    }

    public double[] getTime() {
        return this.time;
    }

    public double getCurrentInputT() {
        return this.inputT[this.sampLen - 1];
    }

    public double[] getInputT() {
        return this.inputT;
    }

    public Complex getInputS() {
        return this.inputS;
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public double getSampFreq() {
        return this.sampFreq;
    }

    public Complex getS() {
        return this.sValue;
    }

    public Complex getZ() {
        return this.zValue;
    }

    public int getSnumerDeg() {
        return this.sNumerDeg;
    }

    public int getSnumerPadeDeg() {
        return this.sNumerDegPade;
    }

    public int getSdenomDeg() {
        return this.sDenomDeg;
    }

    public int getSdenomPadeDeg() {
        return this.sDenomDegPade;
    }

    public ComplexPoly getSnumer() {
        return this.sNumer.times(this.sNumerWorkingFactor);
    }

    public ComplexPoly getSnumerPade() {
        return this.sNumerPade.times(this.sNumerWorkingFactor);
    }

    public ComplexPoly getSdenom() {
        return this.sDenom.times(this.sDenomWorkingFactor);
    }

    public ComplexPoly getSdenomPade() {
        return this.sDenomPade.times(this.sDenomWorkingFactor);
    }

    public int getZnumerDeg() {
        return this.zNumerDeg;
    }

    public int getZdenomDeg() {
        return this.zDenomDeg;
    }

    public ComplexPoly getZnumer() {
        return this.zNumer;
    }

    public ComplexPoly getZdenom() {
        return this.zDenom;
    }

    public Complex[] getZerosS() {
        if (this.sZeros == null) {
            this.calcPolesZerosS();
        }
        if (this.sZeros == null) {
            System.out.println("Method BlackBox.getZerosS:");
            System.out.println("There are either no s-domain zeros for this transfer function");
            System.out.println("or the s-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sZeros;
    }

    public Complex[] getZerosPadeS() {
        if (this.sZeros == null) {
            this.calcPolesZerosS();
        }
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sZerosPade == null) {
            System.out.println("Method BlackBox.getZerosPadeS:");
            System.out.println("There are either no s-domain zeros for this transfer function");
            System.out.println("or the s-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sZerosPade;
    }

    public Complex[] getPolesS() {
        if (this.sPoles == null) {
            this.calcPolesZerosS();
        }
        if (this.sPoles == null) {
            System.out.println("Method BlackBox.getPolesS:");
            System.out.println("There are either no s-domain poles for this transfer function");
            System.out.println("or the s-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sPoles;
    }

    public Complex[] getPolesPadeS() {
        if (this.sPoles == null) {
            this.calcPolesZerosS();
        }
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sPolesPade == null) {
            System.out.println("Method BlackBox.getPolesPadeS:");
            System.out.println("There are either no s-domain poles for this transfer function");
            System.out.println("or the s-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sPolesPade;
    }

    public Complex[] getZerosZ() {
        if (this.zZeros == null) {
            System.out.println("Method BlackBox.getZerosZ:");
            System.out.println("There are either no z-domain zeros for this transfer function");
            System.out.println("or the z-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.zZeros;
    }

    public Complex[] getPolesZ() {
        if (this.zPoles == null) {
            System.out.println("Method BlackBox.getPolesZ:");
            System.out.println("There are either no z-domain poles for this transfer function");
            System.out.println("or the z-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.zPoles;
    }

    public boolean getMaptozero() {
        return this.maptozero;
    }

    public String getName() {
        return this.name;
    }

    public void plotPoleZeroS() {
        if (this.sNumer == null) {
            throw new IllegalArgumentException("s domain numerator has not been set");
        }
        if (this.sDenom == null) {
            throw new IllegalArgumentException("s domain denominator has not been set");
        }
        PlotPoleZero ppz = new PlotPoleZero(this.sNumer, this.sDenom);
        ppz.setS();
        ppz.pzPlot(this.name);
    }

    public void plotPoleZeroPadeS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sNumerPade == null) {
            throw new IllegalArgumentException("s domain numerator has not been set");
        }
        if (this.sDenomPade == null) {
            throw new IllegalArgumentException("s domain denominator has not been set");
        }
        PlotPoleZero ppz = new PlotPoleZero(this.sNumerPade, this.sDenomPade);
        ppz.setS();
        ppz.pzPlot(this.name);
    }

    public void plotPoleZeroZ() {
        PlotPoleZero ppz = new PlotPoleZero(this.zNumer, this.zDenom);
        if (this.zNumer == null) {
            throw new IllegalArgumentException("z domain numerator has not been set");
        }
        if (this.zDenom == null) {
            throw new IllegalArgumentException("z domain denominator has not been set");
        }
        ppz.setZ();
        ppz.pzPlot(this.name);
    }

    public void plotBode(double lowFreq, double highFreq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        int nPoints = 100;
        double[][] cdata = new double[2][nPoints];
        double[] logFreqArray = new double[nPoints + 1];
        double logLow = Fmath.log10(Math.PI * 2 * lowFreq);
        double logHigh = Fmath.log10(Math.PI * 2 * highFreq);
        double incr = (logHigh - logLow) / ((double)nPoints - 1.0);
        double freqArray = lowFreq;
        logFreqArray[0] = logLow;
        int i = 0;
        while (i < nPoints) {
            freqArray = Math.pow(10.0, logFreqArray[i]);
            cdata[0][i] = logFreqArray[i];
            cdata[1][i] = 20.0 * Fmath.log10(this.evalMagTransFunctS(freqArray / (Math.PI * 2)));
            logFreqArray[i + 1] = logFreqArray[i] + incr;
            ++i;
        }
        PlotGraph pgmag = new PlotGraph(cdata);
        pgmag.setGraphTitle("Bode Plot = magnitude versus log10[radial frequency]");
        pgmag.setGraphTitle2(this.name);
        pgmag.setXaxisLegend("Log10[radial frequency]");
        pgmag.setYaxisLegend("Magnitude[Transfer Function]");
        pgmag.setYaxisUnitsName("dB");
        pgmag.setPoint(0);
        pgmag.setLine(3);
        pgmag.plot();
        int i2 = 0;
        while (i2 < nPoints) {
            freqArray = Math.pow(10.0, logFreqArray[i2]);
            cdata[0][i2] = logFreqArray[i2];
            cdata[1][i2] = this.evalPhaseTransFunctS(freqArray) * 180.0 / Math.PI;
            ++i2;
        }
        PlotGraph pgphase = new PlotGraph(cdata);
        pgphase.setGraphTitle("Bode Plot = phase versus log10[radial frequency]");
        pgphase.setGraphTitle2(this.name);
        pgphase.setXaxisLegend("Log10[radial frequency]");
        pgphase.setYaxisLegend("Phase[Transfer Function]");
        pgphase.setYaxisUnitsName("degrees");
        pgphase.setPoint(0);
        pgmag.setLine(3);
        pgphase.plot();
    }

    public double getCurrentOutputT(double ttime, double inp) {
        this.setInputT(ttime, inp);
        return this.getCurrentOutputT();
    }

    public double getCurrentOutputT() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly numerI = this.sNumerPade.times(new Complex(this.inputT[this.sampLen - 1], 0.0));
        Complex[] polyC = new Complex[]{Complex.zero(), Complex.plusOne()};
        ComplexPoly polyH = new ComplexPoly(polyC);
        ComplexPoly denomI = this.sDenomPade.times(polyH);
        Complex[][] coeffT = BlackBox.inverseTransform(numerI, denomI, this.sNumerWorkingFactor, this.sDenomScaleFactor);
        Complex tempc = Complex.zero();
        int j = 0;
        while (j < coeffT[0].length) {
            tempc.plusEquals(BlackBox.timeTerm(this.time[this.sampLen - 1], coeffT[0][j], coeffT[1][j], coeffT[2][j]));
            ++j;
        }
        double outReal = tempc.getReal();
        double outImag = tempc.getImag();
        boolean outTest = true;
        if (outImag == 0.0) {
            outTest = false;
        }
        if (outTest) {
            double temp = Math.max(Math.abs(outReal), Math.abs(outImag));
            if (Math.abs((outReal - outImag) / temp) > 1.0E-5) {
                outTest = false;
            } else {
                System.out.println("output in Blackbox.getCurrentOutputT() has a significant imaginary part");
                System.out.println("time = " + this.time[this.sampLen - 1] + "    real = " + outReal + "   imag = " + outImag);
                System.out.println("Output equated to the real part");
            }
        }
        this.outputT[this.sampLen - 1] = outReal;
        return this.outputT[this.sampLen - 1];
    }

    public double[] getOutputT() {
        return this.outputT;
    }

    public Complex getOutputS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        this.outputS = num.over(den).times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public Complex getOutputS(Complex svalue, Complex inputs) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.inputS = inputs;
        this.sValue = svalue;
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        this.outputS = num.over(den).times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void setNplotPoints(int nPoints) {
        this.nPlotPoints = nPoints;
    }

    public int getNplotPoints() {
        return this.nPlotPoints;
    }

    public void impulseInput(double impulseMag, double finalTime) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly impulseN = new ComplexPoly(0);
        impulseN.resetCoeff(0, Complex.plusOne().times(impulseMag));
        ComplexPoly numerT = this.sNumerPade.times(impulseN);
        ComplexPoly denomT = this.sDenomPade.copy();
        String graphtitle1 = "Impulse Input Transient:   Impulse magnitude = " + impulseMag;
        String graphtitle2 = this.getName();
        BlackBox.transientResponse(this.nPlotPoints, finalTime, this.deadTime, numerT, denomT, graphtitle1, graphtitle2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
    }

    public void impulseInput(double finalTime) {
        this.impulseInput(1.0, finalTime);
    }

    public void stepInput(double stepMag, double finalTime) {
        Complex sNumer0 = this.sNumerPade.coeffCopy(0);
        Complex sDenom0 = this.sDenomPade.coeffCopy(0);
        boolean test0 = false;
        if (Complex.isReal(sNumer0) && Complex.isReal(sDenom0)) {
            test0 = true;
        }
        if (this.sNumerDeg == 0 && this.sDenomDeg == 0 && test0) {
            int n = 51;
            double incrT = finalTime / (double)(n - 2);
            double[][] cdata = new double[2][n];
            cdata[0][0] = 0.0;
            cdata[0][1] = 0.0;
            int i = 2;
            while (i < n) {
                cdata[0][i] = cdata[0][i - 1] + incrT;
                ++i;
            }
            double kpterm = sNumer0.getReal() * stepMag / sDenom0.getReal();
            cdata[1][0] = 0.0;
            int i2 = 1;
            while (i2 < n) {
                cdata[1][i2] = kpterm;
                ++i2;
            }
            if (this.deadTime != 0.0) {
                i2 = 0;
                while (i2 < n) {
                    double[] dArray = cdata[0];
                    int n2 = i2++;
                    dArray[n2] = dArray[n2] + this.deadTime;
                }
            }
            PlotGraph pg = new PlotGraph(cdata);
            pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
            pg.setGraphTitle2(this.getName());
            pg.setXaxisLegend("Time");
            pg.setXaxisUnitsName("s");
            pg.setYaxisLegend("Output");
            pg.setPoint(0);
            pg.setLine(3);
            pg.plot();
        } else {
            if (!this.padeAdded) {
                this.transferPolesZeros();
            }
            ComplexPoly numerT = this.sNumer.times(stepMag);
            Complex[] polyC = new Complex[]{Complex.zero(), Complex.plusOne()};
            ComplexPoly polyH = new ComplexPoly(polyC);
            ComplexPoly denomT = this.sDenom.times(polyH);
            String graphtitle1 = "Step Input Transient:   Step magnitude = " + stepMag;
            String graphtitle2 = this.getName();
            BlackBox.transientResponse(this.nPlotPoints, finalTime, this.deadTime, numerT, denomT, graphtitle1, graphtitle2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
        }
    }

    public void stepInput(double finalTime) {
        this.stepInput(1.0, finalTime);
    }

    public void rampInput(double rampGradient, int rampOrder, double finalTime) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly numerT = this.sNumer.times(rampGradient * (double)Fmath.factorial(rampOrder));
        Complex[] polyC = Complex.oneDarray(rampOrder + 1);
        int i = 0;
        while (i < rampOrder) {
            polyC[i] = Complex.zero();
            ++i;
        }
        polyC[rampOrder] = Complex.plusOne();
        ComplexPoly polyH = new ComplexPoly(polyC);
        ComplexPoly denomT = this.sDenom.times(polyH);
        String graphtitle1 = "";
        graphtitle1 = rampGradient != 1.0 ? (rampOrder != 1 ? String.valueOf(graphtitle1) + "nth order ramp (at^n) input transient:   a = " + rampGradient + "    n = " + rampOrder : String.valueOf(graphtitle1) + "First order ramp (at) input transient:   a = " + rampGradient) : (rampOrder != 1 ? String.valueOf(graphtitle1) + "Unit ramp (t) input transient" : String.valueOf(graphtitle1) + "nth order ramp (t^n) input transient:   n = " + rampOrder);
        String graphtitle2 = this.getName();
        BlackBox.transientResponse(this.nPlotPoints, finalTime, this.deadTime, numerT, denomT, graphtitle1, graphtitle2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
    }

    public void rampInput(int rampOrder, double finalTime) {
        double rampGradient = 1.0;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    public void rampInput(double rampGradient, double finalTime) {
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    public void rampInput(double finalTime) {
        double rampGradient = 1.0;
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    public static void transientResponse(int nPoints, double finalTime, double deadTime, ComplexPoly numerT, ComplexPoly denomT, String graphtitle1, String graphtitle2) {
        Complex[] roots = denomT.rootsNoMessages();
        Complex magDenom = BlackBox.scaleFactor(denomT, roots);
        Complex magNumer = Complex.plusOne();
        BlackBox.transientResponse(nPoints, finalTime, deadTime, numerT, denomT, graphtitle1, graphtitle2, magNumer, magDenom);
    }

    public static void transientResponse(int nPoints, double finalTime, double deadTime, ComplexPoly numerT, ComplexPoly denomT, String graphtitle1, String graphtitle2, Complex magN, Complex magD) {
        Complex[][] coeffT = BlackBox.inverseTransform(numerT, denomT, magN, magD);
        int m = denomT.getDeg();
        double incrT = finalTime / (double)(nPoints - 1);
        double[][] cdata = new double[2][nPoints];
        double temp = 0.0;
        Complex tempc = new Complex();
        double outReal = 0.0;
        double outImag = 0.0;
        boolean outTest = true;
        cdata[0][0] = 0.0;
        int i = 1;
        while (i < nPoints) {
            cdata[0][i] = cdata[0][i - 1] + incrT;
            ++i;
        }
        i = 0;
        while (i < nPoints) {
            outTest = true;
            tempc = Complex.zero();
            int j = 0;
            while (j < m) {
                tempc.plusEquals(BlackBox.timeTerm(cdata[0][i], coeffT[0][j], coeffT[1][j], coeffT[2][j]));
                ++j;
            }
            outReal = tempc.getReal();
            outImag = tempc.getImag();
            if (outImag == 0.0) {
                outTest = false;
            }
            if (outTest) {
                temp = Math.max(Math.abs(outReal), Math.abs(outImag));
                if (Math.abs((outReal - outImag) / temp) > 1.0E-5) {
                    outTest = false;
                } else {
                    System.out.println("output in Blackbox.stepInput has a significant imaginary part");
                    System.out.println("time = " + cdata[0][i] + "    real = " + outReal + "   imag = " + outImag);
                    System.out.println("Output equated to the real part");
                }
            }
            cdata[1][i] = outReal;
            double[] dArray = cdata[0];
            int n = i++;
            dArray[n] = dArray[n] + deadTime;
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle(graphtitle1);
        pg.setGraphTitle2(graphtitle2);
        pg.setXaxisLegend("Time");
        pg.setXaxisUnitsName("s");
        pg.setYaxisLegend("Output");
        pg.setPoint(0);
        pg.setLine(3);
        pg.setNoYoffset(true);
        if (deadTime < cdata[0][nPoints - 1] - cdata[0][0]) {
            pg.setNoXoffset(true);
        }
        pg.setXlowFac(0.0);
        pg.setYlowFac(0.0);
        pg.plot();
    }

    public static Complex timeTerm(double ttime, Complex coeff, Complex constant, Complex power) {
        Complex ret = new Complex();
        int n = (int)power.getReal() - 1;
        ret = coeff.times(Math.pow(ttime, n));
        ret = ret.over(Fmath.factorial(n));
        ret = ret.times(Complex.exp(constant.times(ttime)));
        return ret;
    }

    public static double timeTerm(double ttime, double coeff, double constant, int power) {
        int n = power - 1;
        double ret = coeff * Math.pow(ttime, n);
        ret /= (double)Fmath.factorial(n);
        return ret *= Math.exp(constant * ttime);
    }

    public static double timeTerm(double ttime, double coeff, double constant, double power) {
        double n = power - 1.0;
        double ret = coeff * Math.pow(ttime, n);
        ret /= Fmath.factorial(n);
        return ret *= Math.exp(constant * ttime);
    }

    public static double[][] inverseTransformToReal(ComplexPoly numer, ComplexPoly denom) {
        Complex[][] com = BlackBox.inverseTransform(numer, denom);
        int n = com[0].length;
        double[][] ret = new double[3][n];
        int i = 0;
        while (i < n) {
            ret[0][i] = com[0][i].getReal();
            if (Math.abs((ret[0][i] - com[0][i].getImag()) / ret[0][i]) > 1.0E-5) {
                System.out.println("BlackBox inverseTransformToReal coefficient A[" + i + "] has a significant imaginary part: " + com[0][i]);
                System.out.println("A equated to the real part");
                System.out.println("inverseTransform method may be more appropriate");
            }
            ret[1][i] = com[1][i].getReal();
            if (Math.abs((ret[1][i] - com[1][i].getImag()) / ret[1][i]) > 1.0E-5) {
                System.out.println("BlackBox inverseTransformToReal coefficient a[" + i + "] has a significant imaginary part: " + com[1][i]);
                System.out.println("a equated to the real part");
                System.out.println("inverseTransform method may be more appropriate");
            }
            ret[2][i] = com[2][i].getReal();
            ++i;
        }
        return ret;
    }

    public static Complex[][] inverseTransform(ComplexPoly numer, ComplexPoly denom) {
        Complex[] roots = denom.rootsNoMessages();
        Complex magDenom = BlackBox.scaleFactor(denom, roots);
        Complex magNumer = Complex.plusOne();
        return BlackBox.inverseTransform(numer, denom, magNumer, magDenom);
    }

    public static Complex[][] inverseTransform(ComplexPoly numer, ComplexPoly denom, Complex magNumer, Complex magDenom) {
        int polesN = denom.getDeg();
        int zerosN = numer.getDeg();
        if (zerosN >= polesN) {
            throw new IllegalArgumentException("The degree of the numerator is equal to or greater than the degree of the denominator");
        }
        Complex[][] ret = Complex.twoDarray(3, polesN);
        if (polesN == 1 && zerosN == 0) {
            Complex num = numer.coeffCopy(0);
            Complex den0 = denom.coeffCopy(0);
            Complex den1 = denom.coeffCopy(1);
            ret[0][0] = num.over(den1);
            ret[1][0] = Complex.minusOne().times(den0.over(den1));
            ret[2][0] = new Complex(1.0, 0.0);
            return ret;
        }
        int nDifferentRoots = polesN;
        int nSetsIdenticalRoots = 0;
        Complex[] poles = denom.rootsNoMessages();
        int[] polePower = new int[polesN];
        boolean[] poleSet = new boolean[polesN];
        int[] poleIdent = new int[polesN];
        int[] poleHighestPower = new int[polesN];
        boolean[] termSet = new boolean[polesN];
        double identicalRootLimit = 0.01;
        int[] numberInSet = new int[polesN];
        int power = 0;
        Complex identPoleAverage = new Complex();
        int lastPowerIndex = 0;
        int i = 0;
        while (i < polesN) {
            poleSet[i] = false;
            ++i;
        }
        i = 0;
        while (i < polesN) {
            termSet[i] = true;
            ++i;
        }
        i = 0;
        while (i < polesN) {
            int j;
            if (!poleSet[i]) {
                power = 1;
                polePower[i] = 1;
                poleHighestPower[i] = 1;
                poleIdent[i] = i;
                numberInSet[i] = 1;
                identPoleAverage = poles[i];
                j = i + 1;
                while (j < polesN) {
                    if (!poleSet[j]) {
                        if (poles[i].isEqualWithinLimits(poles[j], identicalRootLimit)) {
                            poleIdent[j] = i;
                            polePower[j] = ++power;
                            poleSet[j] = true;
                            poleSet[i] = true;
                            termSet[j] = false;
                            termSet[i] = false;
                            lastPowerIndex = j;
                            --nDifferentRoots;
                            identPoleAverage = identPoleAverage.plus(poles[j]);
                        } else {
                            poleIdent[j] = j;
                            polePower[j] = 1;
                        }
                    }
                    ++j;
                }
            }
            if (poleSet[i]) {
                --nDifferentRoots;
                ++nSetsIdenticalRoots;
                termSet[lastPowerIndex] = true;
                identPoleAverage = identPoleAverage.over(power);
                j = 0;
                while (j < polesN) {
                    if (poleSet[j] && poleIdent[j] == i) {
                        poles[j] = identPoleAverage;
                        poleHighestPower[i] = power;
                        numberInSet[j] = power;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Complex poleAverage = Complex.zero();
        Complex absPoleAverage = Complex.zero();
        int i2 = 0;
        while (i2 < polesN) {
            poleAverage = poleAverage.plus(poles[i2]);
            absPoleAverage = absPoleAverage.plus(poles[i2].abs());
            ++i2;
        }
        poleAverage = poleAverage.over(polesN);
        absPoleAverage = absPoleAverage.over(polesN);
        Complex poleSubstitute = poleAverage;
        if (poleSubstitute.isZero()) {
            poleSubstitute = absPoleAverage;
        }
        if (poleSubstitute.isZero()) {
            poleSubstitute = Complex.plusOne();
        }
        Complex[] subValues = Complex.oneDarray(polesN);
        boolean[] subSet = new boolean[polesN];
        int i3 = 0;
        while (i3 < polesN) {
            subSet[i3] = false;
            ++i3;
        }
        Complex[] shifts = null;
        Complex delta = new Complex(1.7, 0.0);
        int i4 = 0;
        while (i4 < polesN) {
            subValues[i4] = poles[i4].copy();
            ++i4;
        }
        int currentNumberInSet = 0;
        if (nSetsIdenticalRoots > 0) {
            int i5 = 0;
            while (i5 < polesN) {
                if (numberInSet[i5] > 1 && !subSet[i5]) {
                    int j;
                    currentNumberInSet = numberInSet[i5];
                    shifts = Complex.oneDarray(numberInSet[i5]);
                    int centre = numberInSet[i5] / 2;
                    if (Fmath.isEven(numberInSet[i5])) {
                        j = 0;
                        while (j < centre) {
                            shifts[centre + j] = delta.times(j + 1);
                            shifts[centre - 1 - j] = shifts[centre + j].times(-1.0);
                            ++j;
                        }
                    } else {
                        shifts[centre] = Complex.zero();
                        j = 0;
                        while (j < centre) {
                            shifts[centre + 1 + j] = delta.times(j + 1);
                            shifts[centre - 1 - j] = shifts[centre + j].times(-1.0);
                            ++j;
                        }
                    }
                    int kk = 0;
                    int j2 = 0;
                    while (j2 < polesN) {
                        if (!subSet[j2] && numberInSet[j2] == currentNumberInSet) {
                            Complex incr = poles[j2];
                            if (incr.isZero()) {
                                incr = poleSubstitute;
                            }
                            subValues[j2] = shifts[kk].times(incr);
                            subSet[j2] = true;
                            ++kk;
                        }
                        ++j2;
                    }
                }
                ++i5;
            }
        }
        boolean testii = true;
        int ii = 0;
        int nAttempts = 0;
        while (testii) {
            int jj = ii + 1;
            boolean testjj = true;
            while (testjj) {
                if (subValues[ii].isEqualWithinLimits(subValues[jj], identicalRootLimit)) {
                    subValues[ii] = subValues[ii].plus(poleSubstitute.times(nAttempts));
                    ii = 0;
                    testjj = false;
                    if (++nAttempts > 1000000) {
                        throw new IllegalArgumentException("a non repeating set of substitution values could not be foumd");
                    }
                } else {
                    ++jj;
                }
                if (jj < polesN) continue;
                testjj = false;
            }
            if (++ii < polesN - 1) continue;
            testii = false;
        }
        Complex[][] mat = Complex.twoDarray(polesN, polesN);
        Complex[] vec = Complex.oneDarray(polesN);
        int i6 = 0;
        while (i6 < polesN) {
            vec[i6] = zerosN > 0 ? numer.evaluate(subValues[i6]) : numer.coeffCopy(0);
            ++i6;
        }
        i6 = 0;
        while (i6 < polesN) {
            int j = 0;
            while (j < polesN) {
                Complex denomTerm = Complex.plusOne();
                int powerD = 0;
                int k = 0;
                while (k < polesN) {
                    if (termSet[k]) {
                        if (j != k) {
                            denomTerm = polePower[k] == 1 ? denomTerm.times(subValues[i6].minus(poles[k])) : denomTerm.times(Complex.pow(subValues[i6].minus(poles[k]), polePower[k]));
                        } else if (polePower[j] < poleHighestPower[j]) {
                            powerD = poleHighestPower[j] - polePower[j];
                            if (powerD == 1) {
                                denomTerm = denomTerm.times(subValues[i6].minus(poles[k]));
                            } else if (powerD != 0) {
                                denomTerm = denomTerm.times(Complex.pow(subValues[i6].minus(poles[k]), powerD));
                            }
                        }
                    }
                    ++k;
                }
                mat[i6][j] = denomTerm;
                ++j;
            }
            ++i6;
        }
        ComplexMatrix cmat = new ComplexMatrix(mat);
        Complex[] terms = cmat.solveLinearSet(vec);
        int i7 = 0;
        while (i7 < polesN) {
            ret[0][i7] = terms[i7].times(magNumer).over(magDenom);
            ret[1][i7] = poles[i7];
            ret[2][i7].reset(polePower[i7], 0.0);
            ++i7;
        }
        return ret;
    }

    public BlackBox copy() {
        if (this == null) {
            return null;
        }
        BlackBox bb = new BlackBox();
        this.copyBBvariables(bb);
        return bb;
    }

    public void copyBBvariables(BlackBox bb) {
        bb.sampLen = this.sampLen;
        bb.inputT = Conv.copy(this.inputT);
        bb.outputT = Conv.copy(this.outputT);
        bb.time = Conv.copy(this.time);
        bb.forgetFactor = this.forgetFactor;
        bb.deltaT = this.deltaT;
        bb.sampFreq = this.sampFreq;
        bb.inputS = this.inputS.copy();
        bb.outputS = this.outputS.copy();
        bb.sValue = this.sValue.copy();
        bb.zValue = this.zValue.copy();
        bb.sNumer = this.sNumer.copy();
        bb.sDenom = this.sDenom.copy();
        bb.zNumer = this.zNumer.copy();
        bb.zDenom = this.zDenom.copy();
        bb.sNumerSet = this.sNumerSet;
        bb.sDenomSet = this.sDenomSet;
        bb.sNumerScaleFactor = this.sNumerScaleFactor;
        bb.sDenomScaleFactor = this.sDenomScaleFactor;
        bb.sPoles = Complex.copy(this.sPoles);
        bb.sZeros = Complex.copy(this.sZeros);
        bb.zPoles = Complex.copy(this.zPoles);
        bb.zZeros = Complex.copy(this.zZeros);
        bb.sNumerDeg = this.sNumerDeg;
        bb.sDenomDeg = this.sDenomDeg;
        bb.zNumerDeg = this.zNumerDeg;
        bb.zDenomDeg = this.zDenomDeg;
        bb.deadTime = this.deadTime;
        bb.orderPade = this.orderPade;
        bb.sNumerPade = this.sNumerPade.copy();
        bb.sDenomPade = this.sDenomPade.copy();
        bb.sPolesPade = Complex.copy(this.sPolesPade);
        bb.sZerosPade = Complex.copy(this.sZerosPade);
        bb.sNumerDegPade = this.sNumerDegPade;
        bb.sDenomDegPade = this.sDenomDegPade;
        bb.maptozero = this.maptozero;
        bb.padeAdded = this.padeAdded;
        bb.integrationSum = this.integrationSum;
        bb.integMethod = this.integMethod;
        bb.ztransMethod = this.ztransMethod;
        bb.name = this.name;
        bb.fixedName = this.fixedName;
        bb.nPlotPoints = this.nPlotPoints;
    }

    public Object clone() {
        return this.copy();
    }
}

