/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.complex.Complex;
import flanagan.math.Fmath;
import flanagan.math.Matrix;

public class ComplexMatrix {
    private int nrow = 0;
    private int ncol = 0;
    private Complex[][] matrix = null;
    private int[] index = null;
    private double dswap = 1.0;
    private static final double TINY = 1.0E-30;

    public ComplexMatrix(int nrow, int ncol) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Complex.twoDarray(nrow, ncol);
        this.index = new int[nrow];
        int i = 0;
        while (i < nrow) {
            this.index[i] = i;
            ++i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(int nrow, int ncol, Complex constant) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Complex.twoDarray(nrow, ncol, constant);
        this.index = new int[nrow];
        int i = 0;
        while (i < nrow) {
            this.index[i] = i;
            ++i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(Complex[][] twoD) {
        this.nrow = twoD.length;
        this.ncol = twoD[0].length;
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        int i = 0;
        while (i < this.nrow) {
            if (twoD[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j] = Complex.copy(twoD[i][j]);
                ++j;
            }
            ++i;
        }
        this.index = new int[this.nrow];
        i = 0;
        while (i < this.nrow) {
            this.index[i] = i;
            ++i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(double[][] twoD) {
        this.nrow = twoD.length;
        this.ncol = twoD[0].length;
        int i = 0;
        while (i < this.nrow) {
            if (twoD[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j] = new Complex(twoD[i][j], 0.0);
                ++j;
            }
            ++i;
        }
        this.index = new int[this.nrow];
        i = 0;
        while (i < this.nrow) {
            this.index[i] = i;
            ++i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(ComplexMatrix bb) {
        this.nrow = bb.nrow;
        this.ncol = bb.ncol;
        this.matrix = bb.copy().matrix;
        this.index = bb.index;
        this.dswap = bb.dswap;
    }

    public ComplexMatrix(Matrix bb) {
        this.nrow = bb.getNrow();
        this.ncol = bb.getNcol();
        double[][] array = bb.getArrayCopy();
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j] = new Complex(array[i][j], 0.0);
                ++j;
            }
            ++i;
        }
        this.index = bb.getIndexCopy();
        this.dswap = bb.getSwap();
    }

    public void setTwoDarray(Complex[][] aarray) {
        if (this.nrow != aarray.length) {
            throw new IllegalArgumentException("row length of this ComplexMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != aarray[0].length) {
            throw new IllegalArgumentException("column length of this ComplexMatrix differs from that of the 2D array argument");
        }
        int i = 0;
        while (i < this.nrow) {
            if (aarray[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j] = Complex.copy(aarray[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void setTwoDarray(double[][] aarray) {
        if (this.nrow != aarray.length) {
            throw new IllegalArgumentException("row length of this ComplexMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != aarray[0].length) {
            throw new IllegalArgumentException("column length of this ComplexMatrix differs from that of the 2D array argument");
        }
        int i = 0;
        while (i < this.nrow) {
            if (aarray[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j] = new Complex(aarray[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void setElement(int i, int j, Complex aa) {
        this.matrix[i][j] = Complex.copy(aa);
    }

    public void setElement(int i, int j, double aa, double bb) {
        this.matrix[i][j].reset(aa, bb);
    }

    public void setSubMatrix(int i, int j, int k, int l, Complex[][] subMatrix) {
        this.setSubMatrix(i, j, subMatrix);
    }

    public void setSubMatrix(int i, int j, Complex[][] subMatrix) {
        int k = subMatrix.length;
        int l = subMatrix[0].length;
        if (i + k - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int m = 0;
        int n = 0;
        int p = 0;
        while (p < k) {
            n = 0;
            int q = 0;
            while (q < l) {
                this.matrix[i + p][j + q] = Complex.copy(subMatrix[m][n]);
                ++n;
                ++q;
            }
            ++m;
            ++p;
        }
    }

    public void setSubMatrix(int[] row, int[] col, Complex[][] subMatrix) {
        int n = row.length;
        int m = col.length;
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                this.matrix[row[p]][col[q]] = Complex.copy(subMatrix[p][q]);
                ++q;
            }
            ++p;
        }
    }

    public static ComplexMatrix identityMatrix(int nrow) {
        ComplexMatrix u = new ComplexMatrix(nrow, nrow);
        int i = 0;
        while (i < nrow) {
            u.matrix[i][i] = Complex.plusOne();
            ++i;
        }
        return u;
    }

    public static ComplexMatrix scalarMatrix(int nrow, Complex diagconst) {
        ComplexMatrix u = new ComplexMatrix(nrow, nrow);
        Complex[][] uarray = u.getArrayReference();
        int i = 0;
        while (i < nrow) {
            int j = i;
            while (j < nrow) {
                if (i == j) {
                    uarray[i][j] = Complex.copy(diagconst);
                }
                ++j;
            }
            ++i;
        }
        return u;
    }

    public static ComplexMatrix diagonalMatrix(int nrow, Complex[] diag) {
        if (diag.length != nrow) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        ComplexMatrix u = new ComplexMatrix(nrow, nrow);
        Complex[][] uarray = u.getArrayReference();
        int i = 0;
        while (i < nrow) {
            int j = i;
            while (j < nrow) {
                if (i == j) {
                    uarray[i][j] = Complex.copy(diag[i]);
                }
                ++j;
            }
            ++i;
        }
        return u;
    }

    public static ComplexMatrix columnMatrix(Complex[] darray) {
        int nr = darray.length;
        ComplexMatrix pp = new ComplexMatrix(nr, 1);
        int i = 0;
        while (i < nr) {
            pp.matrix[i][0] = darray[i];
            ++i;
        }
        return pp;
    }

    public static ComplexMatrix rowMatrix(Complex[] darray) {
        int nc = darray.length;
        ComplexMatrix pp = new ComplexMatrix(1, nc);
        int i = 0;
        while (i < nc) {
            pp.matrix[0][i] = darray[i];
            ++i;
        }
        return pp;
    }

    public static ComplexMatrix toComplexColumnMatrix(Complex[] carray) {
        int nr = carray.length;
        ComplexMatrix cc = new ComplexMatrix(nr, 1);
        int i = 0;
        while (i < nr) {
            cc.matrix[i][0] = carray[i].copy();
            ++i;
        }
        return cc;
    }

    public static ComplexMatrix toComplexColumnMatrix(double[] darray) {
        int nr = darray.length;
        ComplexMatrix cc = new ComplexMatrix(nr, 1);
        int i = 0;
        while (i < nr) {
            cc.matrix[i][0].reset(darray[i], 0.0);
            ++i;
        }
        return cc;
    }

    public static ComplexMatrix toComplexRowMatrix(Complex[] carray) {
        int nc = carray.length;
        ComplexMatrix cc = new ComplexMatrix(1, nc);
        int i = 0;
        while (i < nc) {
            cc.matrix[0][i] = carray[i].copy();
            ++i;
        }
        return cc;
    }

    public static ComplexMatrix toComplexRowMatrix(double[] darray) {
        int nc = darray.length;
        ComplexMatrix cc = new ComplexMatrix(1, nc);
        int i = 0;
        while (i < nc) {
            cc.matrix[0][i].reset(darray[i], 0.0);
            ++i;
        }
        return cc;
    }

    public static ComplexMatrix toComplexMatrix(Matrix marray) {
        int nr = marray.getNrow();
        int nc = marray.getNcol();
        ComplexMatrix pp = new ComplexMatrix(nr, nc);
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                pp.matrix[i][j].reset(marray.getElementCopy(i, j), 0.0);
                ++j;
            }
            ++i;
        }
        return pp;
    }

    public static ComplexMatrix toComplexMatrix(double[][] darray) {
        int nr = darray.length;
        int nc = darray[0].length;
        int i = 1;
        while (i < nr) {
            if (darray[i].length != nc) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        ComplexMatrix pp = new ComplexMatrix(nr, nc);
        int i2 = 0;
        while (i2 < pp.nrow) {
            int j = 0;
            while (j < pp.ncol) {
                pp.matrix[i2][j].reset(darray[i2][j], 0.0);
                ++j;
            }
            ++i2;
        }
        return pp;
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.ncol;
    }

    public Complex[][] getArrayReference() {
        return this.matrix;
    }

    public Complex[][] getArray() {
        return this.matrix;
    }

    public Complex[][] getArrayPointer() {
        return this.matrix;
    }

    public Complex[][] getArrayCopy() {
        Complex[][] c = new Complex[this.nrow][this.ncol];
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                c[i][j] = Complex.copy(this.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return c;
    }

    public Complex getElementReference(int i, int j) {
        return this.matrix[i][j];
    }

    public Complex getElementPointer(int i, int j) {
        return this.matrix[i][j];
    }

    public Complex getElementCopy(int i, int j) {
        return Complex.copy(this.matrix[i][j]);
    }

    public ComplexMatrix getSubMatrix(int i, int j, int k, int l) {
        if (i > k) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (j > l) {
            throw new IllegalArgumentException("column indices inverted");
        }
        if (k >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (l >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix" + i + " " + l);
        }
        int n = k - i + 1;
        int m = l - j + 1;
        ComplexMatrix subMatrix = new ComplexMatrix(n, m);
        Complex[][] sarray = subMatrix.getArrayReference();
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                sarray[p][q] = Complex.copy(this.matrix[i + p][j + q]);
                ++q;
            }
            ++p;
        }
        return subMatrix;
    }

    public ComplexMatrix getSubMatrix(int[] row, int[] col) {
        int n = row.length;
        int m = col.length;
        ComplexMatrix subMatrix = new ComplexMatrix(n, m);
        Complex[][] sarray = subMatrix.getArrayReference();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                sarray[i][j] = Complex.copy(this.matrix[row[i]][col[j]]);
                ++j;
            }
            ++i;
        }
        return subMatrix;
    }

    public int[] getIndexReference() {
        return this.index;
    }

    public int[] getIndexPointer() {
        return this.index;
    }

    public int[] getIndexCopy() {
        int[] indcopy = new int[this.nrow];
        int i = 0;
        while (i < this.nrow) {
            indcopy[i] = this.index[i];
            ++i;
        }
        return indcopy;
    }

    public double getSwap() {
        return this.dswap;
    }

    public static ComplexMatrix copy(ComplexMatrix a) {
        if (a == null) {
            return null;
        }
        int nr = a.getNrow();
        int nc = a.getNcol();
        Complex[][] aarray = a.getArrayReference();
        ComplexMatrix b = new ComplexMatrix(nr, nc);
        b.nrow = nr;
        b.ncol = nc;
        Complex[][] barray = b.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = Complex.copy(aarray[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.index[i] = a.index[i];
            ++i;
        }
        return b;
    }

    public ComplexMatrix copy() {
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        ComplexMatrix b = new ComplexMatrix(nr, nc);
        Complex[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = Complex.copy(this.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.index[i] = this.index[i];
            ++i;
        }
        return b;
    }

    public Object clone() {
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        ComplexMatrix b = new ComplexMatrix(nr, nc);
        Complex[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = Complex.copy(this.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.index[i] = this.index[i];
            ++i;
        }
        return b;
    }

    public ComplexMatrix plus(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].plus(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix plus(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].plus(bmat[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix plus(Matrix bmat) {
        int nr = bmat.getNrow();
        int nc = bmat.getNcol();
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].plus(bmat.getElement(i, j));
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix plus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].plus(bmat[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static ComplexMatrix plus(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.nrow != bmat.nrow || amat.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.nrow;
        int nc = amat.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = amat.matrix[i][j].plus(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public void plusEquals(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                this.matrix[i][j].plusEquals(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public ComplexMatrix minus(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = this.nrow;
        int nc = this.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].minus(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix minus(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].minus(bmat[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix minus(Matrix bmat) {
        int nr = bmat.getNrow();
        int nc = bmat.getNcol();
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].minus(bmat.getElement(i, j));
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix minus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].minus(bmat[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static ComplexMatrix minus(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.nrow != bmat.nrow || amat.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.nrow;
        int nc = amat.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = amat.matrix[i][j].minus(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public void minusEquals(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                this.matrix[i][j].minusEquals(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public ComplexMatrix times(ComplexMatrix bmat) {
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, bmat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum2 = new Complex();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < bmat.ncol) {
                sum2 = Complex.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                    ++k;
                }
                carray[i][j] = Complex.copy(sum2);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix times(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, nc);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum2 = new Complex();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < nc) {
                sum2 = Complex.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat[k][j]));
                    ++k;
                }
                carray[i][j] = Complex.copy(sum2);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix times(Matrix bmat) {
        int nr = bmat.getNrow();
        int nc = bmat.getNcol();
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, nc);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum2 = new Complex();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < nc) {
                sum2 = Complex.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat.getElement(k, j)));
                    ++k;
                }
                carray[i][j] = Complex.copy(sum2);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix times(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, nc);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum2 = new Complex();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < nc) {
                sum2 = Complex.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat[k][j]));
                    ++k;
                }
                carray[i][j] = Complex.copy(sum2);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix times(Complex constant) {
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, this.ncol);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                carray[i][j] = this.matrix[i][j].times(constant);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public ComplexMatrix times(double constant) {
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, this.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex cconstant = new Complex(constant, 0.0);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                carray[i][j] = this.matrix[i][j].times(cconstant);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static ComplexMatrix times(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(amat.nrow, bmat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum2 = new Complex();
        int i = 0;
        while (i < amat.nrow) {
            int j = 0;
            while (j < bmat.ncol) {
                sum2 = Complex.zero();
                int k = 0;
                while (k < amat.ncol) {
                    sum2.plusEquals(amat.matrix[i][k].times(bmat.matrix[k][j]));
                    ++k;
                }
                carray[i][j] = Complex.copy(sum2);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static ComplexMatrix times(ComplexMatrix amat, Complex constant) {
        ComplexMatrix cmat = new ComplexMatrix(amat.nrow, amat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < amat.nrow) {
            int j = 0;
            while (j < amat.ncol) {
                carray[i][j] = amat.matrix[i][j].times(constant);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static ComplexMatrix times(ComplexMatrix amat, double constant) {
        ComplexMatrix cmat = new ComplexMatrix(amat.nrow, amat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex cconstant = new Complex(constant, 0.0);
        int i = 0;
        while (i < amat.nrow) {
            int j = 0;
            while (j < amat.ncol) {
                carray[i][j] = amat.matrix[i][j].times(cconstant);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public void timesEquals(ComplexMatrix bmat) {
        int j;
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, bmat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum2 = new Complex();
        int i = 0;
        while (i < this.nrow) {
            j = 0;
            while (j < bmat.ncol) {
                sum2 = Complex.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                    ++k;
                }
                carray[i][j] = Complex.copy(sum2);
                ++j;
            }
            ++i;
        }
        this.nrow = cmat.nrow;
        this.ncol = cmat.ncol;
        i = 0;
        while (i < this.nrow) {
            j = 0;
            while (j < this.ncol) {
                this.matrix[i][j] = cmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void timesEquals(Complex constant) {
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j].timesEquals(constant);
                ++j;
            }
            ++i;
        }
    }

    public void timesEquals(double constant) {
        Complex cconstant = new Complex(constant, 0.0);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j].timesEquals(cconstant);
                ++j;
            }
            ++i;
        }
    }

    public ComplexMatrix over(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(bmat.inverse());
    }

    public ComplexMatrix over(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(bmat);
        return this.times(cmat.inverse());
    }

    public ComplexMatrix over(Matrix bmat) {
        ComplexMatrix pmat = ComplexMatrix.toComplexMatrix(bmat);
        return this.over(pmat);
    }

    public ComplexMatrix over(double[][] bmat) {
        ComplexMatrix pmat = ComplexMatrix.toComplexMatrix(bmat);
        return this.over(pmat);
    }

    public ComplexMatrix over(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.nrow != bmat.nrow || amat.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return amat.times(bmat.inverse());
    }

    public void overEquals(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(bmat);
        this.timesEquals(cmat.inverse());
    }

    public ComplexMatrix inverse() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        ComplexMatrix invmat = new ComplexMatrix(n, n);
        if (n == 1) {
            Complex[][] hold = this.getArrayCopy();
            if (hold[0][0].isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = Complex.plusOne().over(hold[0][0]);
            invmat = new ComplexMatrix(hold);
        } else if (n == 2) {
            Complex[][] hold = this.getArrayCopy();
            Complex det = hold[0][0].times(hold[1][1]).minus(hold[0][1].times(hold[1][0]));
            if (det.isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            Complex[][] hold2 = Complex.twoDarray(2, 2);
            hold2[0][0] = hold[1][1].over(det);
            hold2[1][1] = hold[0][0].over(det);
            hold2[1][0] = hold[1][0].negate().over(det);
            hold2[0][1] = hold[0][1].negate().over(det);
            invmat = new ComplexMatrix(hold2);
        } else {
            Complex[] col = new Complex[n];
            Complex[] xvec = new Complex[n];
            Complex[][] invarray = invmat.getArrayReference();
            ComplexMatrix ludmat = this.luDecomp();
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    col[i] = Complex.zero();
                    ++i;
                }
                col[j] = Complex.plusOne();
                xvec = ludmat.luBackSub(col);
                i = 0;
                while (i < n) {
                    invarray[i][j] = Complex.copy(xvec[i]);
                    ++i;
                }
                ++j;
            }
        }
        return invmat;
    }

    public static ComplexMatrix inverse(ComplexMatrix amat) {
        int n = amat.nrow;
        if (n != amat.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        ComplexMatrix invmat = new ComplexMatrix(n, n);
        if (n == 1) {
            Complex[][] hold = amat.getArrayCopy();
            if (hold[0][0].isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = Complex.plusOne().over(hold[0][0]);
            invmat = new ComplexMatrix(hold);
        } else if (n == 2) {
            Complex[][] hold = amat.getArrayCopy();
            Complex det = hold[0][0].times(hold[1][1]).minus(hold[0][1].times(hold[1][0]));
            if (det.isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            Complex[][] hold2 = Complex.twoDarray(2, 2);
            hold2[0][0] = hold[1][1].over(det);
            hold2[1][1] = hold[0][0].over(det);
            hold2[1][0] = hold[1][0].negate().over(det);
            hold2[0][1] = hold[0][1].negate().over(det);
            invmat = new ComplexMatrix(hold2);
        } else {
            Complex[] col = new Complex[n];
            Complex[] xvec = new Complex[n];
            Complex[][] invarray = invmat.getArrayReference();
            ComplexMatrix ludmat = amat.luDecomp();
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    col[i] = Complex.zero();
                    ++i;
                }
                col[j] = Complex.plusOne();
                xvec = ludmat.luBackSub(col);
                i = 0;
                while (i < n) {
                    invarray[i][j] = Complex.copy(xvec[i]);
                    ++i;
                }
                ++j;
            }
        }
        return invmat;
    }

    public ComplexMatrix transpose() {
        ComplexMatrix tmat = new ComplexMatrix(this.ncol, this.nrow);
        Complex[][] tarray = tmat.getArrayReference();
        int i = 0;
        while (i < this.ncol) {
            int j = 0;
            while (j < this.nrow) {
                tarray[i][j] = Complex.copy(this.matrix[j][i]);
                ++j;
            }
            ++i;
        }
        return tmat;
    }

    public static ComplexMatrix transpose(ComplexMatrix amat) {
        ComplexMatrix tmat = new ComplexMatrix(amat.ncol, amat.nrow);
        Complex[][] tarray = tmat.getArrayReference();
        int i = 0;
        while (i < amat.ncol) {
            int j = 0;
            while (j < amat.nrow) {
                tarray[i][j] = Complex.copy(amat.matrix[j][i]);
                ++j;
            }
            ++i;
        }
        return tmat;
    }

    public ComplexMatrix conjugate() {
        ComplexMatrix conj = ComplexMatrix.copy(this);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                conj.matrix[i][j] = this.matrix[i][j].conjugate();
                ++j;
            }
            ++i;
        }
        return conj;
    }

    public static ComplexMatrix conjugate(ComplexMatrix amat) {
        ComplexMatrix conj = ComplexMatrix.copy(amat);
        int i = 0;
        while (i < amat.nrow) {
            int j = 0;
            while (j < amat.ncol) {
                conj.matrix[i][j] = amat.matrix[i][j].conjugate();
                ++j;
            }
            ++i;
        }
        return conj;
    }

    public ComplexMatrix adjoin() {
        ComplexMatrix adj = ComplexMatrix.copy(this);
        adj = adj.transpose();
        adj = adj.conjugate();
        return adj;
    }

    public ComplexMatrix adjoin(ComplexMatrix amat) {
        ComplexMatrix adj = ComplexMatrix.copy(amat);
        adj = adj.transpose();
        adj = adj.conjugate();
        return adj;
    }

    public ComplexMatrix opposite() {
        ComplexMatrix opp = ComplexMatrix.copy(this);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                opp.matrix[i][j] = this.matrix[i][j].times(Complex.minusOne());
                ++j;
            }
            ++i;
        }
        return opp;
    }

    public static ComplexMatrix opposite(ComplexMatrix amat) {
        ComplexMatrix opp = ComplexMatrix.copy(amat);
        int i = 0;
        while (i < amat.nrow) {
            int j = 0;
            while (j < amat.ncol) {
                opp.matrix[i][j] = amat.matrix[i][j].times(Complex.minusOne());
                ++j;
            }
            ++i;
        }
        return opp;
    }

    public Complex trace() {
        Complex trac = new Complex(0.0, 0.0);
        int i = 0;
        while (i < Math.min(this.ncol, this.ncol)) {
            trac.plusEquals(this.matrix[i][i]);
            ++i;
        }
        return trac;
    }

    public static Complex trace(ComplexMatrix amat) {
        Complex trac = new Complex(0.0, 0.0);
        int i = 0;
        while (i < Math.min(amat.ncol, amat.ncol)) {
            trac.plusEquals(amat.matrix[i][i]);
            ++i;
        }
        return trac;
    }

    public Complex determinant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        int j = 0;
        while (j < n) {
            det.timesEquals(ludmat.matrix[j][j]);
            ++j;
        }
        return det;
    }

    public static Complex determinant(ComplexMatrix amat) {
        int n = amat.nrow;
        if (n != amat.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = amat.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        int j = 0;
        while (j < n) {
            det.timesEquals(ludmat.matrix[j][j]);
            ++j;
        }
        return det;
    }

    public Complex logDeterminant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        det = Complex.log(det);
        int j = 0;
        while (j < n) {
            det.plusEquals(Complex.log(ludmat.matrix[j][j]));
            ++j;
        }
        return det;
    }

    public static Complex logDeterminant(ComplexMatrix amat) {
        int n = amat.nrow;
        if (n != amat.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = amat.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        det = Complex.log(det);
        int j = 0;
        while (j < n) {
            det.plusEquals(Complex.log(ludmat.matrix[j][j]));
            ++j;
        }
        return det;
    }

    public ComplexMatrix cofactor() {
        Complex[][] cof = Complex.twoDarray(this.nrow, this.ncol);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                cof[i][j] = this.cofactor(i, j);
                ++j;
            }
            ++i;
        }
        return new ComplexMatrix(cof);
    }

    public Complex cofactor(int ii, int jj) {
        if (ii < 0 || ii >= this.nrow) {
            throw new IllegalArgumentException("The entered row index, " + ii + " must lie between 0 and " + (this.nrow - 1) + " inclusive");
        }
        if (jj < 0 || jj >= this.ncol) {
            throw new IllegalArgumentException("The entered column index, " + jj + " must lie between 0 and " + (this.ncol - 1) + " inclusive");
        }
        int[] rowi = new int[this.nrow - 1];
        int[] colj = new int[this.ncol - 1];
        int kk = 0;
        int i = 0;
        while (i < this.nrow) {
            if (i != ii) {
                rowi[kk] = i;
                ++kk;
            }
            ++i;
        }
        kk = 0;
        i = 0;
        while (i < this.ncol) {
            if (i != jj) {
                colj[kk] = i;
                ++kk;
            }
            ++i;
        }
        ComplexMatrix aa = this.getSubMatrix(rowi, colj);
        Complex aadet = aa.determinant();
        return aadet.times(Math.pow(-1.0, ii + jj));
    }

    public ComplexMatrix reducedRowEchelonForm() {
        Complex[][] mat = Complex.twoDarray(this.nrow, this.ncol);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                mat[i][j] = this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        int leadingCoeff = 0;
        int rowPointer = 0;
        boolean testOuter = true;
        while (testOuter) {
            int counter = rowPointer;
            boolean testInner = true;
            while (testInner && mat[counter][leadingCoeff].equals(Complex.zero())) {
                if (++counter != this.nrow) continue;
                counter = rowPointer;
                if (++leadingCoeff != this.ncol) continue;
                testInner = false;
            }
            if (testInner) {
                Complex[] temp = mat[rowPointer];
                mat[rowPointer] = mat[counter];
                mat[counter] = temp;
                Complex pivot = mat[rowPointer][leadingCoeff];
                int j = 0;
                while (j < this.ncol) {
                    mat[rowPointer][j] = mat[rowPointer][j].over(pivot);
                    ++j;
                }
                int i2 = 0;
                while (i2 < this.nrow) {
                    if (i2 != rowPointer) {
                        pivot = mat[i2][leadingCoeff];
                        int j2 = 0;
                        while (j2 < this.ncol) {
                            mat[i2][j2] = mat[i2][j2].minus(pivot.times(mat[rowPointer][j2]));
                            ++j2;
                        }
                    }
                    ++i2;
                }
                if (++leadingCoeff >= this.ncol) {
                    testOuter = false;
                }
            }
            if (++rowPointer < this.nrow && testInner) continue;
            testOuter = false;
        }
        int i3 = 0;
        while (i3 < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                if (mat[i3][j].getReal() == -0.0) {
                    mat[i3][j].reset(0.0, mat[i3][j].getImag());
                }
                if (mat[i3][j].getImag() == -0.0) {
                    mat[i3][j].reset(mat[i3][j].getReal(), 0.0);
                }
                ++j;
            }
            ++i3;
        }
        return new ComplexMatrix(mat);
    }

    public double frobeniusNorm() {
        double norm = 0.0;
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                norm = Fmath.hypot(norm, Complex.abs(this.matrix[i][j]));
                ++j;
            }
            ++i;
        }
        return norm;
    }

    public double oneNorm() {
        double norm = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.nrow) {
            sum2 = 0.0;
            int j = 0;
            while (j < this.ncol) {
                sum2 += Complex.abs(this.matrix[i][j]);
                ++j;
            }
            norm = Math.max(norm, sum2);
            ++i;
        }
        return norm;
    }

    public double infinityNorm() {
        double norm = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.nrow) {
            sum2 = 0.0;
            int j = 0;
            while (j < this.ncol) {
                sum2 += Complex.abs(this.matrix[i][j]);
                ++j;
            }
            norm = Math.max(norm, sum2);
            ++i;
        }
        return norm;
    }

    public ComplexMatrix luDecomp() {
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n = this.nrow;
        int imax = 0;
        double dum = 0.0;
        double temp = 0.0;
        double big = 0.0;
        double[] vv = new double[n];
        Complex sum2 = new Complex();
        Complex dumm = new Complex();
        ComplexMatrix ludmat = ComplexMatrix.copy(this);
        Complex[][] ludarray = ludmat.getArrayReference();
        ludmat.dswap = 1.0;
        int i = 0;
        while (i < n) {
            big = 0.0;
            int j = 0;
            while (j < n) {
                double d;
                temp = Complex.abs(ludarray[i][j]);
                if (d > big) {
                    big = temp;
                }
                ++j;
            }
            if (big == 0.0) {
                throw new ArithmeticException("Singular matrix");
            }
            vv[i] = 1.0 / big;
            ++i;
        }
        int j = 0;
        while (j < n) {
            int k;
            int i2 = 0;
            while (i2 < j) {
                sum2 = Complex.copy(ludarray[i2][j]);
                k = 0;
                while (k < i2) {
                    sum2.minusEquals(ludarray[i2][k].times(ludarray[k][j]));
                    ++k;
                }
                ludarray[i2][j] = Complex.copy(sum2);
                ++i2;
            }
            big = 0.0;
            i2 = j;
            while (i2 < n) {
                double d;
                sum2 = Complex.copy(ludarray[i2][j]);
                k = 0;
                while (k < j) {
                    sum2.minusEquals(ludarray[i2][k].times(ludarray[k][j]));
                    ++k;
                }
                ludarray[i2][j] = Complex.copy(sum2);
                dum = vv[i2] * Complex.abs(sum2);
                if (d >= big) {
                    big = dum;
                    imax = i2;
                }
                ++i2;
            }
            if (j != imax) {
                int k2 = 0;
                while (k2 < n) {
                    dumm = Complex.copy(ludarray[imax][k2]);
                    ludarray[imax][k2] = Complex.copy(ludarray[j][k2]);
                    ludarray[j][k2] = Complex.copy(dumm);
                    ++k2;
                }
                ludmat.dswap = -ludmat.dswap;
                vv[imax] = vv[j];
            }
            ludmat.index[j] = imax;
            if (ludarray[j][j].isZero()) {
                ludarray[j][j].reset(1.0E-30, 1.0E-30);
            }
            if (j != n - 1) {
                dumm = Complex.over(1.0, ludarray[j][j]);
                i2 = j + 1;
                while (i2 < n) {
                    ludarray[i2][j].timesEquals(dumm);
                    ++i2;
                }
            }
            ++j;
        }
        return ludmat;
    }

    public Complex[] luBackSub(Complex[] bvec) {
        int j;
        int ii = 0;
        int ip = 0;
        int n = bvec.length;
        if (n != this.ncol) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.ncol != this.nrow) {
            throw new IllegalArgumentException("matrix is not square");
        }
        Complex sum2 = new Complex();
        Complex[] xvec = new Complex[n];
        int i = 0;
        while (i < n) {
            xvec[i] = Complex.copy(bvec[i]);
            ++i;
        }
        i = 0;
        while (i < n) {
            ip = this.index[i];
            sum2 = Complex.copy(xvec[ip]);
            xvec[ip] = Complex.copy(xvec[i]);
            if (ii == 0) {
                j = ii;
                while (j <= i - 1) {
                    sum2.minusEquals(this.matrix[i][j].times(xvec[j]));
                    ++j;
                }
            } else if (sum2.isZero()) {
                ii = i;
            }
            xvec[i] = Complex.copy(sum2);
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            sum2 = Complex.copy(xvec[i]);
            j = i + 1;
            while (j < n) {
                sum2.minusEquals(this.matrix[i][j].times(xvec[j]));
                ++j;
            }
            xvec[i] = sum2.over(this.matrix[i][i]);
            --i;
        }
        return xvec;
    }

    public Complex[] solveLinearSet(Complex[] bvec) {
        ComplexMatrix ludmat = this.luDecomp();
        return ludmat.luBackSub(bvec);
    }
}

