/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.math.Fmath;
import java.io.IOException;

public class Complex {
    private double real = 0.0;
    private double imag = 0.0;
    private static char jori = (char)106;
    private static boolean infOption = true;

    public Complex() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public Complex(double real) {
        this.real = real;
        this.imag = 0.0;
    }

    public Complex(Complex c) {
        this.real = c.real;
        this.imag = c.imag;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public void setImag(double imag) {
        this.imag = imag;
    }

    public void reset(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public void polarRad(double mod, double arg) {
        this.real = mod * Math.cos(arg);
        this.imag = mod * Math.sin(arg);
    }

    public void polar(double mod, double arg) {
        this.real = mod * Math.cos(arg);
        this.imag = mod * Math.sin(arg);
    }

    public void polarDeg(double mod, double arg) {
        arg = Math.toRadians(arg);
        this.real = mod * Math.cos(arg);
        this.imag = mod * Math.sin(arg);
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public static final synchronized Complex readComplex(String prompt) {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(String.valueOf(prompt) + " ");
        System.out.flush();
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                cstring = String.valueOf(cstring) + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public static final synchronized Complex readComplex(String prompt, String dflt) {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(String.valueOf(prompt) + " [default value = " + dflt + "]  ");
        System.out.flush();
        int i = 0;
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n' || (char)ch == '\r') {
                    if (i == 0) {
                        cstring = dflt;
                        if ((char)ch == '\r') {
                            ch = System.in.read();
                        }
                    }
                    done = true;
                    continue;
                }
                cstring = String.valueOf(cstring) + (char)ch;
                ++i;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public static final synchronized Complex readComplex(String prompt, Complex dflt) {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(String.valueOf(prompt) + " [default value = " + dflt + "]  ");
        System.out.flush();
        int i = 0;
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n' || (char)ch == '\r') {
                    if (i == 0) {
                        if ((char)ch == '\r') {
                            ch = System.in.read();
                        }
                        return dflt;
                    }
                    done = true;
                    continue;
                }
                cstring = String.valueOf(cstring) + (char)ch;
                ++i;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public static final synchronized Complex readComplex() {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(" ");
        System.out.flush();
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                cstring = String.valueOf(cstring) + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public void println(String message) {
        System.out.println(String.valueOf(message) + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String message) {
        System.out.print(String.valueOf(message) + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }

    public static void println(String message, Complex[] aa) {
        System.out.println(message);
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i].toString()) + "  ");
            ++i;
        }
    }

    public static void println(Complex[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i].toString()) + "  ");
            ++i;
        }
    }

    public static void print(String message, Complex[] aa) {
        System.out.print(String.valueOf(message) + " ");
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i].toString()) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void print(Complex[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i].toString()) + "  ");
            ++i;
        }
        System.out.println();
    }

    public static Complex truncate(Complex x2, int prec) {
        if (prec < 0) {
            return x2;
        }
        double xR = x2.getReal();
        double xI = x2.getImag();
        Complex y = new Complex();
        xR = Fmath.truncate(xR, prec);
        xI = Fmath.truncate(xI, prec);
        y.reset(xR, xI);
        return y;
    }

    public Complex truncate(int prec) {
        if (prec < 0) {
            return this;
        }
        double xR = this.getReal();
        double xI = this.getImag();
        Complex y = new Complex();
        xR = Fmath.truncate(xR, prec);
        xI = Fmath.truncate(xI, prec);
        y.reset(xR, xI);
        return y;
    }

    public String toString() {
        char ch = '+';
        if (this.imag < 0.0) {
            ch = '-';
        }
        return String.valueOf(this.real) + " " + ch + " " + jori + Math.abs(this.imag);
    }

    public static String toString(Complex aa) {
        char ch = '+';
        if (aa.imag < 0.0) {
            ch = '-';
        }
        return String.valueOf(aa.real) + " " + ch + jori + Math.abs(aa.imag);
    }

    public static void setj() {
        jori = (char)106;
    }

    public static void seti() {
        jori = (char)105;
    }

    public static char getjori() {
        return jori;
    }

    public static Complex parseComplex(String ss) {
        int i;
        Complex aa = new Complex();
        ss = ss.trim();
        double first = 1.0;
        if (ss.charAt(0) == '-') {
            first = -1.0;
            ss = ss.substring(1);
        }
        if ((i = ss.indexOf(106)) == -1) {
            i = ss.indexOf(105);
        }
        if (i == -1) {
            throw new NumberFormatException("no i or j found");
        }
        int imagSign = 1;
        int j = ss.indexOf(43);
        if (j == -1 && (j = ss.indexOf(45)) > -1) {
            imagSign = -1;
        }
        if (j == -1) {
            throw new NumberFormatException("no + or - found");
        }
        int r0 = 0;
        int r1 = j;
        int i0 = i + 1;
        int i1 = ss.length();
        String sreal = ss.substring(r0, r1);
        String simag = ss.substring(i0, i1);
        aa.real = first * Double.parseDouble(sreal);
        aa.imag = (double)imagSign * Double.parseDouble(simag);
        return aa;
    }

    public static Complex valueOf(String ss) {
        return Complex.parseComplex(ss);
    }

    public int hashCode() {
        long lreal = Double.doubleToLongBits(this.real);
        long limag = Double.doubleToLongBits(this.imag);
        int hreal = (int)(lreal ^ lreal >>> 32);
        int himag = (int)(limag ^ limag >>> 32);
        return 7 * (hreal / 10) + 3 * (himag / 10);
    }

    public static void swap(Complex aa, Complex bb) {
        double holdAreal = aa.real;
        double holdAimag = aa.imag;
        aa.reset(bb.real, bb.imag);
        bb.reset(holdAreal, holdAimag);
    }

    public static Complex[] oneDarray(int n) {
        Complex[] a = new Complex[n];
        int i = 0;
        while (i < n) {
            a[i] = Complex.zero();
            ++i;
        }
        return a;
    }

    public static Complex[] oneDarray(int n, double a, double b) {
        Complex[] c = new Complex[n];
        int i = 0;
        while (i < n) {
            c[i] = Complex.zero();
            c[i].reset(a, b);
            ++i;
        }
        return c;
    }

    public static Complex mean(Complex[] aa) {
        int n = aa.length;
        Complex sum2 = new Complex(0.0, 0.0);
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(aa[i]);
            ++i;
        }
        return sum2.over(n);
    }

    public static Complex[] oneDarray(int n, Complex constant) {
        Complex[] c = new Complex[n];
        int i = 0;
        while (i < n) {
            c[i] = Complex.copy(constant);
            ++i;
        }
        return c;
    }

    public static Complex[][] twoDarray(int n, int m) {
        Complex[][] a = new Complex[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                a[i][j] = Complex.zero();
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static Complex[][] twoDarray(int n, int m, double a, double b) {
        Complex[][] c = new Complex[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                c[i][j] = Complex.zero();
                c[i][j].reset(a, b);
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static Complex[][] twoDarray(int n, int m, Complex constant) {
        Complex[][] c = new Complex[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                c[i][j] = Complex.copy(constant);
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static Complex[][][] threeDarray(int n, int m, int l) {
        Complex[][][] a = new Complex[n][m][l];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                int k = 0;
                while (k < l) {
                    a[i][j][k] = Complex.zero();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static Complex[][][] threeDarray(int n, int m, int l, double a, double b) {
        Complex[][][] c = new Complex[n][m][l];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                int k = 0;
                while (k < l) {
                    c[i][j][k] = Complex.zero();
                    c[i][j][k].reset(a, b);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static Complex[][][] threeDarray(int n, int m, int l, Complex constant) {
        Complex[][][] c = new Complex[n][m][l];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                int k = 0;
                while (k < l) {
                    c[i][j][k] = Complex.copy(constant);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static Complex copy(Complex a) {
        if (a == null) {
            return null;
        }
        Complex b = new Complex();
        b.real = a.real;
        b.imag = a.imag;
        return b;
    }

    public Complex copy() {
        if (this == null) {
            return null;
        }
        Complex b = new Complex();
        b.real = this.real;
        b.imag = this.imag;
        return b;
    }

    public static Complex[] copy(Complex[] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        Complex[] b = Complex.oneDarray(n);
        int i = 0;
        while (i < n) {
            b[i] = Complex.copy(a[i]);
            ++i;
        }
        return b;
    }

    public static Complex[][] copy(Complex[][] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        int m = a[0].length;
        Complex[][] b = Complex.twoDarray(n, m);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                b[i][j] = Complex.copy(a[i][j]);
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static Complex[][][] copy(Complex[][][] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        int m = a[0].length;
        int l = a[0][0].length;
        Complex[][][] b = Complex.threeDarray(n, m, l);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                int k = 0;
                while (k < l) {
                    b[i][j][k] = Complex.copy(a[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return b;
    }

    public Object clone() {
        Complex ret = null;
        if (this != null) {
            Complex b = new Complex();
            b.real = this.real;
            b.imag = this.imag;
            ret = b;
        }
        return ret;
    }

    public static Complex plus(Complex a, Complex b) {
        Complex c = new Complex();
        c.real = a.real + b.real;
        c.imag = a.imag + b.imag;
        return c;
    }

    public static Complex plus(Complex a, double b) {
        Complex c = new Complex();
        c.real = a.real + b;
        c.imag = a.imag;
        return c;
    }

    public static Complex plus(double a, Complex b) {
        Complex c = new Complex();
        c.real = a + b.real;
        c.imag = b.imag;
        return c;
    }

    public static Complex plus(double a, double b) {
        Complex c = new Complex();
        c.real = a + b;
        c.imag = 0.0;
        return c;
    }

    public Complex plus(Complex a) {
        Complex b = new Complex();
        b.real = this.real + a.real;
        b.imag = this.imag + a.imag;
        return b;
    }

    public Complex plus(double a) {
        Complex b = new Complex();
        b.real = this.real + a;
        b.imag = this.imag;
        return b;
    }

    public void plusEquals(Complex a) {
        this.real += a.real;
        this.imag += a.imag;
    }

    public void plusEquals(double a) {
        this.real += a;
        this.imag = this.imag;
    }

    public static Complex minus(Complex a, Complex b) {
        Complex c = new Complex();
        c.real = a.real - b.real;
        c.imag = a.imag - b.imag;
        return c;
    }

    public static Complex minus(Complex a, double b) {
        Complex c = new Complex();
        c.real = a.real - b;
        c.imag = a.imag;
        return c;
    }

    public static Complex minus(double a, Complex b) {
        Complex c = new Complex();
        c.real = a - b.real;
        c.imag = -b.imag;
        return c;
    }

    public static Complex minus(double a, double b) {
        Complex c = new Complex();
        c.real = a - b;
        c.imag = 0.0;
        return c;
    }

    public Complex minus(Complex a) {
        Complex b = new Complex();
        b.real = this.real - a.real;
        b.imag = this.imag - a.imag;
        return b;
    }

    public Complex minus(double a) {
        Complex b = new Complex();
        b.real = this.real - a;
        b.imag = this.imag;
        return b;
    }

    public Complex transposedMinus(double a) {
        Complex b = new Complex();
        b.real = a - this.real;
        b.imag = this.imag;
        return b;
    }

    public void minusEquals(Complex a) {
        this.real -= a.real;
        this.imag -= a.imag;
    }

    public void minusEquals(double a) {
        this.real -= a;
        this.imag = this.imag;
    }

    public static void setInfOption(boolean infOpt) {
        infOption = infOpt;
    }

    public static void setInfOption(int opt2) {
        if (opt2 < 0 || opt2 > 1) {
            throw new IllegalArgumentException("opt must be 0 or 1");
        }
        infOption = true;
        if (opt2 == 1) {
            infOption = false;
        }
    }

    public static boolean getInfOption() {
        return infOption;
    }

    public static Complex times(Complex a, Complex b) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption) {
            if (a.isInfinite() && !b.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
            if (b.isInfinite() && !a.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
        }
        c.real = a.real * b.real - a.imag * b.imag;
        c.imag = a.real * b.imag + a.imag * b.real;
        return c;
    }

    public static Complex times(Complex a, double b) {
        Complex c = new Complex();
        if (infOption) {
            if (a.isInfinite() && b != 0.0) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
            if (Fmath.isInfinity(b) && !a.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
        }
        c.real = a.real * b;
        c.imag = a.imag * b;
        return c;
    }

    public static Complex times(double a, Complex b) {
        Complex c = new Complex();
        if (infOption) {
            if (b.isInfinite() && a != 0.0) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
            if (Fmath.isInfinity(a) && !b.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
        }
        c.real = a * b.real;
        c.imag = a * b.imag;
        return c;
    }

    public static Complex times(double a, double b) {
        Complex c = new Complex();
        c.real = a * b;
        c.imag = 0.0;
        return c;
    }

    public Complex times(Complex a) {
        Complex b = new Complex();
        if (infOption) {
            if (this.isInfinite() && !a.isZero()) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
            if (a.isInfinite() && !this.isZero()) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
        }
        b.real = this.real * a.real - this.imag * a.imag;
        b.imag = this.real * a.imag + this.imag * a.real;
        return b;
    }

    public Complex times(double a) {
        Complex b = new Complex();
        if (infOption) {
            if (this.isInfinite() && a != 0.0) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
            if (Fmath.isInfinity(a) && !this.isZero()) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
        }
        b.real = this.real * a;
        b.imag = this.imag * a;
        return b;
    }

    public void timesEquals(Complex a) {
        Complex b = new Complex();
        boolean test2 = true;
        if (infOption && (this.isInfinite() && !a.isZero() || a.isInfinite() && !this.isZero())) {
            this.real = Double.POSITIVE_INFINITY;
            this.imag = Double.POSITIVE_INFINITY;
            test2 = false;
        }
        if (test2) {
            b.real = a.real * this.real - a.imag * this.imag;
            b.imag = a.real * this.imag + a.imag * this.real;
            this.real = b.real;
            this.imag = b.imag;
        }
    }

    public void timesEquals(double a) {
        boolean test2 = true;
        if (infOption && (this.isInfinite() && a != 0.0 || Fmath.isInfinity(a) && !this.isZero())) {
            this.real = Double.POSITIVE_INFINITY;
            this.imag = Double.POSITIVE_INFINITY;
            test2 = false;
        }
        if (test2) {
            this.real *= a;
            this.imag *= a;
        }
    }

    public static Complex over(Complex a, Complex b) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption && !a.isInfinite() && b.isInfinite()) {
            return c;
        }
        double denom = 0.0;
        double ratio = 0.0;
        if (a.isZero()) {
            if (b.isZero()) {
                c.real = Double.NaN;
                c.imag = Double.NaN;
            } else {
                c.real = 0.0;
                c.imag = 0.0;
            }
        } else if (Math.abs(b.real) >= Math.abs(b.imag)) {
            ratio = b.imag / b.real;
            denom = b.real + b.imag * ratio;
            c.real = (a.real + a.imag * ratio) / denom;
            c.imag = (a.imag - a.real * ratio) / denom;
        } else {
            ratio = b.real / b.imag;
            denom = b.real * ratio + b.imag;
            c.real = (a.real * ratio + a.imag) / denom;
            c.imag = (a.imag * ratio - a.real) / denom;
        }
        return c;
    }

    public static Complex over(Complex a, double b) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption && Fmath.isInfinity(b)) {
            return c;
        }
        c.real = a.real / b;
        c.imag = a.imag / b;
        return c;
    }

    public static Complex over(double a, Complex b) {
        Complex c = new Complex();
        if (infOption && !Fmath.isInfinity(a) && b.isInfinite()) {
            return c;
        }
        if (a == 0.0) {
            if (b.isZero()) {
                c.real = Double.NaN;
                c.imag = Double.NaN;
            } else {
                c.real = 0.0;
                c.imag = 0.0;
            }
        } else if (Math.abs(b.real) >= Math.abs(b.imag)) {
            double ratio = b.imag / b.real;
            double denom = b.real + b.imag * ratio;
            c.real = a / denom;
            c.imag = -a * ratio / denom;
        } else {
            double ratio = b.real / b.imag;
            double denom = b.real * ratio + b.imag;
            c.real = a * ratio / denom;
            c.imag = -a / denom;
        }
        return c;
    }

    public static Complex over(double a, double b) {
        Complex c = new Complex();
        c.real = a / b;
        c.imag = 0.0;
        return c;
    }

    public Complex over(Complex a) {
        Complex b = new Complex(0.0, 0.0);
        if (infOption && !this.isInfinite() && a.isInfinite()) {
            return b;
        }
        double denom = 0.0;
        double ratio = 0.0;
        if (Math.abs(a.real) >= Math.abs(a.imag)) {
            ratio = a.imag / a.real;
            denom = a.real + a.imag * ratio;
            b.real = (this.real + this.imag * ratio) / denom;
            b.imag = (this.imag - this.real * ratio) / denom;
        } else {
            ratio = a.real / a.imag;
            denom = a.real * ratio + a.imag;
            b.real = (this.real * ratio + this.imag) / denom;
            b.imag = (this.imag * ratio - this.real) / denom;
        }
        return b;
    }

    public Complex over(double a) {
        Complex b = new Complex(0.0, 0.0);
        b.real = this.real / a;
        b.imag = this.imag / a;
        return b;
    }

    public Complex transposedOver(double a) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption && !Fmath.isInfinity(a) && this.isInfinite()) {
            return c;
        }
        double denom = 0.0;
        double ratio = 0.0;
        if (Math.abs(this.real) >= Math.abs(this.imag)) {
            ratio = this.imag / this.real;
            denom = this.real + this.imag * ratio;
            c.real = a / denom;
            c.imag = -a * ratio / denom;
        } else {
            ratio = this.real / this.imag;
            denom = this.real * ratio + this.imag;
            c.real = a * ratio / denom;
            c.imag = -a / denom;
        }
        return c;
    }

    public void overEquals(Complex b) {
        Complex c = new Complex(0.0, 0.0);
        boolean test2 = true;
        if (infOption && !this.isInfinite() && b.isInfinite()) {
            this.real = 0.0;
            this.imag = 0.0;
            test2 = false;
        }
        if (test2) {
            double denom = 0.0;
            double ratio = 0.0;
            if (Math.abs(b.real) >= Math.abs(b.imag)) {
                ratio = b.imag / b.real;
                denom = b.real + b.imag * ratio;
                c.real = (this.real + this.imag * ratio) / denom;
                c.imag = (this.imag - this.real * ratio) / denom;
            } else {
                ratio = b.real / b.imag;
                denom = b.real * ratio + b.imag;
                c.real = (this.real * ratio + this.imag) / denom;
                c.imag = (this.imag * ratio - this.real) / denom;
            }
            this.real = c.real;
            this.imag = c.imag;
        }
    }

    public void overEquals(double a) {
        this.real /= a;
        this.imag /= a;
    }

    public static Complex inverse(Complex a) {
        Complex b = new Complex(0.0, 0.0);
        if (infOption && a.isInfinite()) {
            return b;
        }
        b = Complex.over(1.0, a);
        return b;
    }

    public Complex inverse() {
        Complex b = new Complex(0.0, 0.0);
        b = Complex.over(1.0, this);
        return b;
    }

    public static Complex negate(Complex a) {
        Complex c = new Complex();
        c.real = -a.real;
        c.imag = -a.imag;
        return c;
    }

    public Complex negate() {
        Complex c = new Complex();
        c.real = -this.real;
        c.imag = -this.imag;
        return c;
    }

    public static double abs(Complex a) {
        double rmod = Math.abs(a.real);
        double imod = Math.abs(a.imag);
        double ratio = 0.0;
        double res = 0.0;
        if (rmod == 0.0) {
            res = imod;
        } else {
            if (imod == 0.0) {
                res = rmod;
            }
            if (rmod >= imod) {
                ratio = a.imag / a.real;
                res = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = a.real / a.imag;
                res = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        return res;
    }

    public double abs() {
        double rmod = Math.abs(this.real);
        double imod = Math.abs(this.imag);
        double ratio = 0.0;
        double res = 0.0;
        if (rmod == 0.0) {
            res = imod;
        } else {
            if (imod == 0.0) {
                res = rmod;
            }
            if (rmod >= imod) {
                ratio = this.imag / this.real;
                res = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = this.real / this.imag;
                res = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        return res;
    }

    public static double squareAbs(Complex a) {
        return a.real * a.real + a.imag * a.imag;
    }

    public double squareAbs() {
        return this.real * this.real + this.imag * this.imag;
    }

    public static double arg(Complex a) {
        return Math.atan2(a.imag, a.real);
    }

    public double arg() {
        return Math.atan2(this.imag, this.real);
    }

    public static double argRad(Complex a) {
        return Math.atan2(a.imag, a.real);
    }

    public double argRad() {
        return Math.atan2(this.imag, this.real);
    }

    public static double argDeg(Complex a) {
        return Math.toDegrees(Math.atan2(a.imag, a.real));
    }

    public double argDeg() {
        return Math.toDegrees(Math.atan2(this.imag, this.real));
    }

    public static Complex conjugate(Complex a) {
        Complex c = new Complex();
        c.real = a.real;
        c.imag = -a.imag;
        return c;
    }

    public Complex conjugate() {
        Complex c = new Complex();
        c.real = this.real;
        c.imag = -this.imag;
        return c;
    }

    public static double hypot(Complex aa, Complex bb) {
        double amod = Complex.abs(aa);
        double bmod = Complex.abs(bb);
        double cc = 0.0;
        double ratio = 0.0;
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod >= bmod) {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }

    public Complex exp() {
        return Complex.exp(this);
    }

    public static Complex exp(Complex aa) {
        Complex z = new Complex();
        double a = aa.real;
        double b = aa.imag;
        if (b == 0.0) {
            z.real = Math.exp(a);
            z.imag = 0.0;
        } else if (a == 0.0) {
            z.real = Math.cos(b);
            z.imag = Math.sin(b);
        } else {
            double c = Math.exp(a);
            z.real = c * Math.cos(b);
            z.imag = c * Math.sin(b);
        }
        return z;
    }

    public static Complex exp(double aa) {
        Complex bb = new Complex(aa, 0.0);
        return Complex.exp(bb);
    }

    public static Complex expPlusJayArg(double arg) {
        Complex argc = new Complex(0.0, arg);
        return Complex.exp(argc);
    }

    public static Complex expMinusJayArg(double arg) {
        Complex argc = new Complex(0.0, -arg);
        return Complex.exp(argc);
    }

    public Complex log() {
        double a = this.real;
        double b = this.imag;
        Complex c = new Complex();
        c.real = Math.log(Complex.abs(this));
        c.imag = Math.atan2(b, a);
        return c;
    }

    public static Complex log(Complex aa) {
        double a = aa.real;
        double b = aa.imag;
        Complex c = new Complex();
        c.real = Math.log(Complex.abs(aa));
        c.imag = Math.atan2(b, a);
        return c;
    }

    public Complex sqrt() {
        return Complex.sqrt(this);
    }

    public static Complex sqrt(Complex aa) {
        double a = aa.real;
        double b = aa.imag;
        Complex c = new Complex();
        if (b == 0.0) {
            if (a >= 0.0) {
                c.real = Math.sqrt(a);
                c.imag = 0.0;
            } else {
                c.real = 0.0;
                c.imag = Math.sqrt(-a);
            }
        } else {
            double w;
            double bmod;
            double amod = Math.abs(a);
            if (amod >= (bmod = Math.abs(b))) {
                double ratio = b / a;
                w = Math.sqrt(amod) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + ratio * ratio)));
            } else {
                double ratio = a / b;
                w = Math.sqrt(bmod) * Math.sqrt(0.5 * (Math.abs(ratio) + Math.sqrt(1.0 + ratio * ratio)));
            }
            if (a >= 0.0) {
                c.real = w;
                c.imag = b / (2.0 * w);
            } else if (b >= 0.0) {
                c.imag = w;
                c.real = b / (2.0 * c.imag);
            } else {
                c.imag = -w;
                c.real = b / (2.0 * c.imag);
            }
        }
        return c;
    }

    public Complex nthRoot(int n) {
        return Complex.nthRoot(this, n);
    }

    public static Complex nthRoot(Complex aa, int n) {
        Complex c = new Complex();
        c = n == 0 ? new Complex(Double.POSITIVE_INFINITY, 0.0) : (n == 1 ? aa : Complex.exp(Complex.log(aa).over(n)));
        return c;
    }

    public static Complex square(Complex aa) {
        Complex c = new Complex();
        c.real = aa.real * aa.real - aa.imag * aa.imag;
        c.imag = 2.0 * aa.real * aa.imag;
        return c;
    }

    public Complex square() {
        return this.times(this);
    }

    public Complex pow(Complex b) {
        Complex c = new Complex();
        if (this.isZero()) {
            if (b.imag == 0.0) {
                if (b.real == 0.0) {
                    c = new Complex(1.0, 0.0);
                } else if (b.real > 0.0) {
                    c = new Complex(0.0, 0.0);
                } else if (b.real < 0.0) {
                    c = new Complex(Double.POSITIVE_INFINITY, 0.0);
                }
            } else {
                c = Complex.exp(b.times(Complex.log(this)));
            }
        } else {
            c = Complex.exp(b.times(Complex.log(this)));
        }
        return c;
    }

    public static Complex pow(Complex a, Complex b) {
        Complex c = new Complex();
        if (a.isZero()) {
            if (b.imag == 0.0) {
                if (b.real == 0.0) {
                    c = new Complex(1.0, 0.0);
                } else if (a.real > 0.0) {
                    c = new Complex(0.0, 0.0);
                } else if (a.real < 0.0) {
                    c = new Complex(Double.POSITIVE_INFINITY, 0.0);
                }
            } else {
                c = Complex.exp(b.times(Complex.log(a)));
            }
        } else {
            c = Complex.exp(b.times(Complex.log(a)));
        }
        return c;
    }

    public Complex pow(double b) {
        return Complex.powDouble(this, b);
    }

    public static Complex pow(Complex a, double b) {
        return Complex.powDouble(a, b);
    }

    public Complex pow(int n) {
        double b = n;
        return Complex.powDouble(this, b);
    }

    public static Complex pow(Complex a, int n) {
        double b = n;
        return Complex.powDouble(a, b);
    }

    public static Complex pow(double a, Complex b) {
        Complex c = new Complex();
        if (a == 0.0) {
            if (b.imag == 0.0) {
                if (b.real == 0.0) {
                    c = new Complex(1.0, 0.0);
                } else if (b.real > 0.0) {
                    c = new Complex(0.0, 0.0);
                } else if (b.real < 0.0) {
                    c = new Complex(Double.POSITIVE_INFINITY, 0.0);
                }
            } else {
                double z = Math.pow(a, b.real);
                c = Complex.exp(Complex.times(Complex.plusJay(), b.imag * Math.log(a)));
                c = Complex.times(z, c);
            }
        } else {
            double z = Math.pow(a, b.real);
            c = Complex.exp(Complex.times(Complex.plusJay(), b.imag * Math.log(a)));
            c = Complex.times(z, c);
        }
        return c;
    }

    public Complex sin() {
        return Complex.sin(this);
    }

    public static Complex sin(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.sin(a) * Fmath.cosh(b);
        c.imag = Math.cos(a) * Fmath.sinh(b);
        return c;
    }

    public Complex cos() {
        return Complex.cos(this);
    }

    public static Complex cos(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.cos(a) * Fmath.cosh(b);
        c.imag = -Math.sin(a) * Fmath.sinh(b);
        return c;
    }

    public Complex sec() {
        return Complex.sec(this);
    }

    public static Complex sec(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.cos(a) * Fmath.cosh(b);
        c.imag = -Math.sin(a) * Fmath.sinh(b);
        return c.inverse();
    }

    public Complex csc() {
        return Complex.csc(this);
    }

    public static Complex csc(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.sin(a) * Fmath.cosh(b);
        c.imag = Math.cos(a) * Fmath.sinh(b);
        return c.inverse();
    }

    public Complex tan() {
        return Complex.tan(this);
    }

    public static Complex tan(Complex aa) {
        Complex c = new Complex();
        double denom = 0.0;
        double a = aa.real;
        double b = aa.imag;
        Complex x2 = new Complex(Math.sin(a) * Fmath.cosh(b), Math.cos(a) * Fmath.sinh(b));
        Complex y = new Complex(Math.cos(a) * Fmath.cosh(b), -Math.sin(a) * Fmath.sinh(b));
        c = Complex.over(x2, y);
        return c;
    }

    public Complex cot() {
        return Complex.cot(this);
    }

    public static Complex cot(Complex aa) {
        Complex c = new Complex();
        double denom = 0.0;
        double a = aa.real;
        double b = aa.imag;
        Complex x2 = new Complex(Math.sin(a) * Fmath.cosh(b), Math.cos(a) * Fmath.sinh(b));
        Complex y = new Complex(Math.cos(a) * Fmath.cosh(b), -Math.sin(a) * Fmath.sinh(b));
        c = Complex.over(y, x2);
        return c;
    }

    public Complex exsec() {
        return Complex.exsec(this);
    }

    public static Complex exsec(Complex aa) {
        return Complex.sec(aa).minus(1.0);
    }

    public Complex vers() {
        return Complex.vers(this);
    }

    public static Complex vers(Complex aa) {
        return Complex.plusOne().minus(Complex.cos(aa));
    }

    public Complex covers() {
        return Complex.covers(this);
    }

    public static Complex covers(Complex aa) {
        return Complex.plusOne().minus(Complex.sin(aa));
    }

    public Complex hav() {
        return Complex.hav(this);
    }

    public static Complex hav(Complex aa) {
        return Complex.vers(aa).over(2.0);
    }

    public Complex sinh() {
        return Complex.sinh(this);
    }

    public static Complex sinh(Complex a) {
        Complex c = new Complex();
        c = a.times(Complex.plusJay());
        c = Complex.minusJay().times(Complex.sin(c));
        return c;
    }

    public Complex cosh() {
        return Complex.cosh(this);
    }

    public static Complex cosh(Complex a) {
        Complex c = new Complex();
        c = a.times(Complex.plusJay());
        c = Complex.cos(c);
        return c;
    }

    public Complex tanh() {
        return Complex.tanh(this);
    }

    public static Complex tanh(Complex a) {
        Complex c = new Complex();
        c = Complex.sinh(a).over(Complex.cosh(a));
        return c;
    }

    public Complex coth() {
        return Complex.coth(this);
    }

    public static Complex coth(Complex a) {
        Complex c = new Complex();
        c = Complex.cosh(a).over(Complex.sinh(a));
        return c;
    }

    public Complex sech() {
        return Complex.sech(this);
    }

    public static Complex sech(Complex a) {
        Complex c = new Complex();
        c = Complex.cosh(a).inverse();
        return c;
    }

    public Complex csch() {
        return Complex.csch(this);
    }

    public static Complex csch(Complex a) {
        Complex c = new Complex();
        c = Complex.sinh(a).inverse();
        return c;
    }

    public Complex asin() {
        return Complex.asin(this);
    }

    public static Complex asin(Complex a) {
        Complex c = new Complex();
        c = Complex.sqrt(Complex.minus(1.0, Complex.square(a)));
        c = Complex.plusJay().times(a).plus(c);
        c = Complex.minusJay().times(Complex.log(c));
        return c;
    }

    public Complex acos() {
        return Complex.acos(this);
    }

    public static Complex acos(Complex a) {
        Complex c = new Complex();
        c = Complex.sqrt(Complex.minus(Complex.square(a), 1.0));
        c = a.plus(c);
        c = Complex.minusJay().times(Complex.log(c));
        return c;
    }

    public Complex atan() {
        return Complex.atan(this);
    }

    public static Complex atan(Complex a) {
        Complex c = new Complex();
        Complex d = new Complex();
        c = Complex.plusJay().plus(a);
        d = Complex.plusJay().minus(a);
        c = c.over(d);
        c = Complex.log(c);
        c = Complex.plusJay().times(c);
        c = c.over(2.0);
        return c;
    }

    public Complex acot() {
        return Complex.acot(this);
    }

    public static Complex acot(Complex a) {
        return Complex.atan(a.inverse());
    }

    public Complex asec() {
        return Complex.asec(this);
    }

    public static Complex asec(Complex a) {
        return Complex.acos(a.inverse());
    }

    public Complex acsc() {
        return Complex.acsc(this);
    }

    public static Complex acsc(Complex a) {
        return Complex.asin(a.inverse());
    }

    public Complex aexsec() {
        return Complex.aexsec(this);
    }

    public static Complex aexsec(Complex a) {
        Complex c = a.plus(1.0);
        return Complex.asin(c.inverse());
    }

    public Complex avers() {
        return Complex.avers(this);
    }

    public static Complex avers(Complex a) {
        Complex c = Complex.plusOne().plus(a);
        return Complex.acos(c);
    }

    public Complex acovers() {
        return Complex.acovers(this);
    }

    public static Complex acovers(Complex a) {
        Complex c = Complex.plusOne().plus(a);
        return Complex.asin(c);
    }

    public Complex ahav() {
        return Complex.ahav(this);
    }

    public static Complex ahav(Complex a) {
        Complex c = Complex.plusOne().minus(a.times(2.0));
        return Complex.acos(c);
    }

    public Complex asinh() {
        return Complex.asinh(this);
    }

    public static Complex asinh(Complex a) {
        Complex c = new Complex(0.0, 0.0);
        c = Complex.sqrt(Complex.square(a).plus(1.0));
        c = a.plus(c);
        c = Complex.log(c);
        return c;
    }

    public Complex acosh() {
        return Complex.acosh(this);
    }

    public static Complex acosh(Complex a) {
        Complex c = new Complex();
        c = Complex.sqrt(Complex.square(a).minus(1.0));
        c = a.plus(c);
        c = Complex.log(c);
        return c;
    }

    public Complex atanh() {
        return Complex.atanh(this);
    }

    public static Complex atanh(Complex a) {
        Complex c = new Complex();
        Complex d = new Complex();
        c = Complex.plusOne().plus(a);
        d = Complex.plusOne().minus(a);
        c = c.over(d);
        c = Complex.log(c);
        c = c.over(2.0);
        return c;
    }

    public Complex acoth() {
        return Complex.acoth(this);
    }

    public static Complex acoth(Complex a) {
        Complex c = new Complex();
        Complex d = new Complex();
        c = Complex.plusOne().plus(a);
        d = a.plus(1.0);
        c = c.over(d);
        c = Complex.log(c);
        c = c.over(2.0);
        return c;
    }

    public Complex asech() {
        return Complex.asech(this);
    }

    public static Complex asech(Complex a) {
        Complex c = a.inverse();
        Complex d = Complex.square(a).minus(1.0);
        return Complex.log(c.plus(Complex.sqrt(d)));
    }

    public Complex acsch() {
        return Complex.acsch(this);
    }

    public static Complex acsch(Complex a) {
        Complex c = a.inverse();
        Complex d = Complex.square(a).plus(1.0);
        return Complex.log(c.plus(Complex.sqrt(d)));
    }

    public static boolean isReal(Complex a) {
        boolean test2 = false;
        if (Math.abs(a.imag) == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isReal(Complex[] a) {
        boolean test2 = true;
        int n = a.length;
        int i = 0;
        while (i < n) {
            if (Math.abs(a[i].imag) != 0.0) {
                test2 = false;
            }
            ++i;
        }
        return test2;
    }

    public boolean isReal() {
        boolean test2 = false;
        if (Math.abs(this.imag) == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isReal(Complex a, double lim) {
        boolean test2 = false;
        if (Math.abs(a.imag) <= Math.abs(lim)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isReal(Complex[] a, double lim) {
        boolean test2 = true;
        int n = a.length;
        int i = 0;
        while (i < n) {
            if (Math.abs(a[i].imag) > Math.abs(lim)) {
                test2 = false;
            }
            ++i;
        }
        return test2;
    }

    public boolean isReal(double lim) {
        boolean test2 = false;
        if (Math.abs(this.imag) <= Math.abs(lim)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isRealPerCent(Complex a, double percent2) {
        boolean test2 = false;
        if (Math.abs(a.imag * 100.0 / a.real) <= Math.abs(percent2)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isRealPerCent(Complex[] a, double percent2) {
        boolean test2 = true;
        int n = a.length;
        int i = 0;
        while (i < n) {
            if (Math.abs(a[i].imag * 100.0 / a[i].real) > Math.abs(percent2)) {
                test2 = false;
            }
            ++i;
        }
        return test2;
    }

    public boolean isRealperCent(double percent2) {
        boolean test2 = false;
        if (Math.abs(this.imag * 100.0 / this.real) <= Math.abs(percent2)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isZero(Complex a) {
        boolean test2 = false;
        if (Math.abs(a.real) == 0.0 && Math.abs(a.imag) == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public boolean isZero() {
        boolean test2 = false;
        if (Math.abs(this.real) == 0.0 && Math.abs(this.imag) == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public boolean isPlusInfinity() {
        boolean test2 = false;
        if (this.real == Double.POSITIVE_INFINITY || this.imag == Double.POSITIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isPlusInfinity(Complex a) {
        boolean test2 = false;
        if (a.real == Double.POSITIVE_INFINITY || a.imag == Double.POSITIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public boolean isMinusInfinity() {
        boolean test2 = false;
        if (this.real == Double.NEGATIVE_INFINITY || this.imag == Double.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isMinusInfinity(Complex a) {
        boolean test2 = false;
        if (a.real == Double.NEGATIVE_INFINITY || a.imag == Double.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isInfinite(Complex a) {
        boolean test2 = false;
        if (a.real == Double.POSITIVE_INFINITY || a.imag == Double.POSITIVE_INFINITY) {
            test2 = true;
        }
        if (a.real == Double.NEGATIVE_INFINITY || a.imag == Double.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public boolean isInfinite() {
        boolean test2 = false;
        if (this.real == Double.POSITIVE_INFINITY || this.imag == Double.POSITIVE_INFINITY) {
            test2 = true;
        }
        if (this.real == Double.NEGATIVE_INFINITY || this.imag == Double.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isNaN(Complex a) {
        boolean test2 = false;
        if (a.real != a.real || a.imag != a.imag) {
            test2 = true;
        }
        return test2;
    }

    public boolean isNaN() {
        boolean test2 = false;
        if (this.real != this.real || this.imag != this.imag) {
            test2 = true;
        }
        return test2;
    }

    public boolean equals(Complex a) {
        boolean test2 = false;
        if (this.isNaN() && a.isNaN()) {
            test2 = true;
        } else if (this.real == a.real && this.imag == a.imag) {
            test2 = true;
        }
        return test2;
    }

    public boolean isEqual(Complex a) {
        boolean test2 = false;
        if (this.isNaN() && a.isNaN()) {
            test2 = true;
        } else if (this.real == a.real && this.imag == a.imag) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqual(Complex a, Complex b) {
        boolean test2 = false;
        if (Complex.isNaN(a) && Complex.isNaN(b)) {
            test2 = true;
        } else if (a.real == b.real && a.imag == b.imag) {
            test2 = true;
        }
        return test2;
    }

    public boolean equalsWithinLimits(Complex a, double fract) {
        return this.isEqualWithinLimits(a, fract);
    }

    public boolean isEqualWithinLimits(Complex a, double fract) {
        boolean test2 = false;
        double rt = this.getReal();
        double ra = a.getReal();
        double it = this.getImag();
        double ia = a.getImag();
        double rdn = 0.0;
        double idn = 0.0;
        double rtest = 0.0;
        double itest = 0.0;
        if (rt == 0.0 && it == 0.0 && ra == 0.0 && ia == 0.0) {
            test2 = true;
        }
        if (!test2) {
            rdn = Math.abs(rt);
            if (Math.abs(ra) > rdn) {
                rdn = Math.abs(ra);
            }
            rtest = rdn == 0.0 ? 0.0 : Math.abs(ra - rt) / rdn;
            idn = Math.abs(it);
            if (Math.abs(ia) > idn) {
                idn = Math.abs(ia);
            }
            itest = idn == 0.0 ? 0.0 : Math.abs(ia - it) / idn;
            if (rtest < fract && itest < fract) {
                test2 = true;
            }
        }
        return test2;
    }

    public static boolean isEqualWithinLimits(Complex a, Complex b, double fract) {
        boolean test2 = false;
        double rb = b.getReal();
        double ra = a.getReal();
        double ib = b.getImag();
        double ia = a.getImag();
        double rdn = 0.0;
        double idn = 0.0;
        if (ra == 0.0 && ia == 0.0 && rb == 0.0 && ib == 0.0) {
            test2 = true;
        }
        if (!test2) {
            rdn = Math.abs(rb);
            if (Math.abs(ra) > rdn) {
                rdn = Math.abs(ra);
            }
            idn = Math.abs(ib);
            if (Math.abs(ia) > idn) {
                idn = Math.abs(ia);
            }
            if (Math.abs(ra - rb) / rdn < fract && Math.abs(ia - ia) / idn < fract) {
                test2 = true;
            }
        }
        return test2;
    }

    public static Complex zero() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = 0.0;
        return c;
    }

    public static Complex plusOne() {
        Complex c = new Complex();
        c.real = 1.0;
        c.imag = 0.0;
        return c;
    }

    public static Complex minusOne() {
        Complex c = new Complex();
        c.real = -1.0;
        c.imag = 0.0;
        return c;
    }

    public static Complex plusJay() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = 1.0;
        return c;
    }

    public static Complex minusJay() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = -1.0;
        return c;
    }

    public static Complex pi() {
        Complex c = new Complex();
        c.real = Math.PI;
        c.imag = 0.0;
        return c;
    }

    public static Complex twoPiJay() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = Math.PI * 2;
        return c;
    }

    public static Complex plusInfinity() {
        Complex c = new Complex();
        c.real = Double.POSITIVE_INFINITY;
        c.imag = Double.POSITIVE_INFINITY;
        return c;
    }

    public static Complex minusInfinity() {
        Complex c = new Complex();
        c.real = Double.NEGATIVE_INFINITY;
        c.imag = Double.NEGATIVE_INFINITY;
        return c;
    }

    private static Complex powDouble(Complex a, double b) {
        Complex z = new Complex();
        double re = a.real;
        double im = a.imag;
        if (a.isZero()) {
            if (b == 0.0) {
                z = new Complex(1.0, 0.0);
            } else if (b > 0.0) {
                z = new Complex(0.0, 0.0);
            } else if (b < 0.0) {
                z = new Complex(Double.POSITIVE_INFINITY, 0.0);
            }
        } else if (im == 0.0 && re > 0.0) {
            z.real = Math.pow(re, b);
            z.imag = 0.0;
        } else if (re == 0.0) {
            z = Complex.exp(Complex.times(b, Complex.log(a)));
        } else {
            double c = Math.pow(re * re + im * im, b / 2.0);
            double th = Math.atan2(im, re);
            z.real = c * Math.cos(b * th);
            z.imag = c * Math.sin(b * th);
        }
        return z;
    }
}

