/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.math.Fmath;
import flanagan.math.Matrix;

public class PhasorMatrix {
    private int nrow = 0;
    private int ncol = 0;
    private Phasor[][] matrix = null;
    private int[] index = null;
    private double dswap = 1.0;
    private static final double TINY = 1.0E-30;

    public PhasorMatrix(int nrow, int ncol) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Phasor.twoDarray(nrow, ncol);
        this.index = new int[nrow];
        int i = 0;
        while (i < nrow) {
            this.index[i] = i;
            ++i;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(int nrow, int ncol, Phasor constant) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Phasor.twoDarray(nrow, ncol, constant);
        this.index = new int[nrow];
        int i = 0;
        while (i < nrow) {
            this.index[i] = i;
            ++i;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(Phasor[][] twoD) {
        this.nrow = twoD.length;
        this.ncol = twoD[0].length;
        int i = 0;
        while (i < this.nrow) {
            if (twoD[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        this.matrix = twoD;
        this.index = new int[this.nrow];
        i = 0;
        while (i < this.nrow) {
            this.index[i] = i;
            ++i;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(PhasorMatrix bb) {
        this.nrow = bb.nrow;
        this.ncol = bb.ncol;
        this.matrix = bb.matrix;
        this.index = bb.index;
        this.dswap = bb.dswap;
    }

    public void setTwoDarray(Phasor[][] aarray) {
        if (this.nrow != aarray.length) {
            throw new IllegalArgumentException("row length of this PhasorMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != aarray[0].length) {
            throw new IllegalArgumentException("column length of this PhasorMatrix differs from that of the 2D array argument");
        }
        int i = 0;
        while (i < this.nrow) {
            if (aarray[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j] = Phasor.copy(aarray[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void setElement(int i, int j, Phasor aa) {
        this.matrix[i][j] = Phasor.copy(aa);
    }

    public void setElement(int i, int j, double aa, double bb) {
        this.matrix[i][j].reset(aa, bb);
    }

    public void setSubMatrix(int i, int j, Phasor[][] subMatrix) {
        int k = subMatrix.length;
        int l = subMatrix[0].length;
        if (i > k) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (j > l) {
            throw new IllegalArgumentException("column indices inverted");
        }
        int n = k - i + 1;
        int m = l - j + 1;
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                this.matrix[i + p][j + q] = Phasor.copy(subMatrix[p][q]);
                ++q;
            }
            ++p;
        }
    }

    public void setSubMatrix(int i, int j, int k, int l, Phasor[][] subMatrix) {
        if (i + k - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n = k - i + 1;
        int m = l - j + 1;
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                this.matrix[i + p][j + q] = Phasor.copy(subMatrix[p][q]);
                ++q;
            }
            ++p;
        }
    }

    public void setSubMatrix(int[] row, int[] col, Phasor[][] subMatrix) {
        int n = row.length;
        int m = col.length;
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                this.matrix[row[p]][col[q]] = Phasor.copy(subMatrix[p][q]);
                ++q;
            }
            ++p;
        }
    }

    public static PhasorMatrix identityMatrix(int nrow) {
        PhasorMatrix u = new PhasorMatrix(nrow, nrow);
        int i = 0;
        while (i < nrow) {
            u.matrix[i][i] = Phasor.plusOne();
            ++i;
        }
        return u;
    }

    public static PhasorMatrix scalarMatrix(int nrow, Phasor diagconst) {
        PhasorMatrix u = new PhasorMatrix(nrow, nrow);
        Phasor[][] uarray = u.getArrayReference();
        int i = 0;
        while (i < nrow) {
            int j = i;
            while (j < nrow) {
                if (i == j) {
                    uarray[i][j] = Phasor.copy(diagconst);
                }
                ++j;
            }
            ++i;
        }
        return u;
    }

    public static PhasorMatrix diagonalMatrix(int nrow, Phasor[] diag) {
        if (diag.length != nrow) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        PhasorMatrix u = new PhasorMatrix(nrow, nrow);
        Phasor[][] uarray = u.getArrayReference();
        int i = 0;
        while (i < nrow) {
            int j = i;
            while (j < nrow) {
                if (i == j) {
                    uarray[i][j] = Phasor.copy(diag[i]);
                }
                ++j;
            }
            ++i;
        }
        return u;
    }

    public static PhasorMatrix columnMatrix(Phasor[] darray) {
        int nr = darray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        int i = 0;
        while (i < nr) {
            pp.matrix[i][0] = darray[i];
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix rowMatrix(Phasor[] darray) {
        int nc = darray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        int i = 0;
        while (i < nc) {
            pp.matrix[0][i] = darray[i];
            ++i;
        }
        return pp;
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.ncol;
    }

    public Phasor[][] getArrayReference() {
        return this.matrix;
    }

    public Phasor[][] getArray() {
        return this.matrix;
    }

    public Phasor[][] getArrayPointer() {
        return this.matrix;
    }

    public Phasor[][] getArrayCopy() {
        Phasor[][] c = new Phasor[this.nrow][this.ncol];
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                c[i][j] = Phasor.copy(this.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return c;
    }

    public Phasor getElementReference(int i, int j) {
        return this.matrix[i][j];
    }

    public Phasor getElementPointer(int i, int j) {
        return this.matrix[i][j];
    }

    public Phasor getElementCopy(int i, int j) {
        return Phasor.copy(this.matrix[i][j]);
    }

    public PhasorMatrix getSubMatrix(int i, int j, int k, int l) {
        if (i + k - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n = k - i + 1;
        int m = l - j + 1;
        PhasorMatrix subMatrix = new PhasorMatrix(n, m);
        Phasor[][] sarray = subMatrix.getArrayReference();
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                sarray[p][q] = Phasor.copy(this.matrix[i + p][j + q]);
                ++q;
            }
            ++p;
        }
        return subMatrix;
    }

    public PhasorMatrix getSubMatrix(int[] row, int[] col) {
        int n = row.length;
        int m = col.length;
        PhasorMatrix subMatrix = new PhasorMatrix(n, m);
        Phasor[][] sarray = subMatrix.getArrayReference();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                sarray[i][j] = Phasor.copy(this.matrix[row[i]][col[j]]);
                ++j;
            }
            ++i;
        }
        return subMatrix;
    }

    public int[] getIndexReference() {
        return this.index;
    }

    public int[] getIndexPointer() {
        return this.index;
    }

    public int[] getIndexCopy() {
        int[] indcopy = new int[this.nrow];
        int i = 0;
        while (i < this.nrow) {
            indcopy[i] = this.index[i];
            ++i;
        }
        return indcopy;
    }

    public double getSwap() {
        return this.dswap;
    }

    public static PhasorMatrix copy(PhasorMatrix a) {
        if (a == null) {
            return null;
        }
        int nr = a.getNrow();
        int nc = a.getNcol();
        Phasor[][] aarray = a.getArrayReference();
        PhasorMatrix b = new PhasorMatrix(nr, nc);
        b.nrow = nr;
        b.ncol = nc;
        Phasor[][] barray = b.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = Phasor.copy(aarray[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.index[i] = a.index[i];
            ++i;
        }
        return b;
    }

    public PhasorMatrix copy() {
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        PhasorMatrix b = new PhasorMatrix(nr, nc);
        Phasor[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = Phasor.copy(this.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.index[i] = this.index[i];
            ++i;
        }
        return b;
    }

    public Object clone() {
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        PhasorMatrix b = new PhasorMatrix(nr, nc);
        Phasor[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = Phasor.copy(this.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.index[i] = this.index[i];
            ++i;
        }
        return b;
    }

    public static PhasorMatrix toPhasorRowMatrix(Phasor[] parray) {
        int nc = parray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        int i = 0;
        while (i < nc) {
            pp.matrix[0][i] = parray[i].copy();
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorRowMatrix(Complex[] carray) {
        int nc = carray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        int i = 0;
        while (i < nc) {
            pp.matrix[0][i] = Phasor.toPhasor(carray[i]).copy();
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorRowMatrix(double[] darray) {
        int nc = darray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        int i = 0;
        while (i < nc) {
            pp.matrix[0][i] = new Phasor(darray[i], 0.0);
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorColumnMatrix(Phasor[] parray) {
        int nr = parray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        int i = 0;
        while (i < nr) {
            pp.matrix[i][0] = parray[i].copy();
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorColumnMatrix(Complex[] carray) {
        int nr = carray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        int i = 0;
        while (i < nr) {
            pp.matrix[i][0] = Phasor.toPhasor(carray[i]).copy();
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorColumnMatrix(double[] darray) {
        int nr = darray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        int i = 0;
        while (i < nr) {
            pp.matrix[i][0] = new Phasor(darray[i], 0.0);
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(ComplexMatrix cc) {
        PhasorMatrix pp = new PhasorMatrix(cc.getNrow(), cc.getNcol());
        pp.index = cc.getIndexCopy();
        pp.dswap = cc.getSwap();
        int i = 0;
        while (i < pp.nrow) {
            int j = 0;
            while (j < pp.ncol) {
                pp.matrix[i][j] = Phasor.toPhasor(cc.getElementCopy(i, j));
                ++i;
            }
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(Complex[][] carray) {
        ComplexMatrix cc = new ComplexMatrix(carray);
        PhasorMatrix pp = new PhasorMatrix(cc.getNrow(), cc.getNcol());
        int i = 0;
        while (i < pp.nrow) {
            int j = 0;
            while (j < pp.ncol) {
                pp.matrix[i][j] = Phasor.toPhasor(cc.getElementCopy(i, j));
                ++i;
            }
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(Matrix marray) {
        int nr = marray.getNrow();
        int nc = marray.getNcol();
        PhasorMatrix pp = new PhasorMatrix(nr, nc);
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                pp.matrix[i][j].reset(marray.getElementCopy(i, j), 0.0);
                ++j;
            }
            ++i;
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(double[][] darray) {
        int nr = darray.length;
        int nc = darray[0].length;
        int i = 1;
        while (i < nr) {
            if (darray[i].length != nc) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        PhasorMatrix pp = new PhasorMatrix(nr, nc);
        int i2 = 0;
        while (i2 < pp.nrow) {
            int j = 0;
            while (j < pp.ncol) {
                pp.matrix[i2][j].reset(darray[i2][j], 0.0);
                ++j;
            }
            ++i2;
        }
        return pp;
    }

    public ComplexMatrix toComplexMatrix() {
        int nr = this.getNrow();
        int nc = this.getNcol();
        ComplexMatrix cc = new ComplexMatrix(nr, nc);
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                cc.setElement(i, j, this.matrix[i][j].toRectangular());
                ++i;
            }
            ++i;
        }
        return cc;
    }

    public static ComplexMatrix toComplexMatrix(PhasorMatrix pp) {
        int nr = pp.getNrow();
        int nc = pp.getNcol();
        ComplexMatrix cc = new ComplexMatrix(nr, nc);
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                cc.setElement(i, j, pp.matrix[i][j].toRectangular());
                ++i;
            }
            ++i;
        }
        return cc;
    }

    public PhasorMatrix plus(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].plus(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public PhasorMatrix plus(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].plus(bmat[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public PhasorMatrix plus(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public PhasorMatrix plus(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public PhasorMatrix plus(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public PhasorMatrix plus(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public void plusEquals(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                this.matrix[i][j].plusEquals(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void plusEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public PhasorMatrix minus(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = this.nrow;
        int nc = this.ncol;
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].minus(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public PhasorMatrix minus(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j].minus(bmat[i][j]);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public PhasorMatrix minus(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public PhasorMatrix minus(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public PhasorMatrix minus(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public PhasorMatrix minus(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public void minusEquals(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                this.matrix[i][j].minusEquals(bmat.matrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void minusEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public PhasorMatrix times(PhasorMatrix bmat) {
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, bmat.ncol);
        Phasor[][] carray = cmat.getArrayReference();
        Phasor sum2 = new Phasor();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < bmat.ncol) {
                sum2 = Phasor.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                    ++k;
                }
                carray[i][j] = Phasor.copy(sum2);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public PhasorMatrix times(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, nc);
        Phasor[][] carray = cmat.getArrayReference();
        Phasor sum2 = new Phasor();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < nc) {
                sum2 = Phasor.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat[k][j]));
                    ++k;
                }
                carray[i][j] = Phasor.copy(sum2);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public PhasorMatrix times(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(Phasor constant) {
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, this.ncol);
        Phasor[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                carray[i][j] = this.matrix[i][j].times(constant);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public PhasorMatrix times(double constant) {
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, this.ncol);
        Phasor[][] carray = cmat.getArrayReference();
        Phasor cconstant = new Phasor(constant, 0.0);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                carray[i][j] = this.matrix[i][j].times(cconstant);
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public void timesEquals(PhasorMatrix bmat) {
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Phasor sum2 = new Phasor();
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < bmat.ncol) {
                sum2 = Phasor.zero();
                int k = 0;
                while (k < this.ncol) {
                    sum2.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                    ++k;
                }
                this.matrix[i][j] = Phasor.copy(sum2);
                ++j;
            }
            ++i;
        }
    }

    public void timesEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(Phasor constant) {
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j].timesEquals(constant);
                ++j;
            }
            ++i;
        }
    }

    public void timesEquals(Complex constant) {
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j].timesEquals(constant);
                ++j;
            }
            ++i;
        }
    }

    public void timesEquals(double constant) {
        Phasor cconstant = new Phasor(constant, 0.0);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j].timesEquals(cconstant);
                ++j;
            }
            ++i;
        }
    }

    public void timesEquals(int constant) {
        Phasor cconstant = new Phasor(constant, 0.0);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.matrix[i][j].timesEquals(cconstant);
                ++j;
            }
            ++i;
        }
    }

    public PhasorMatrix over(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(bmat.inverse());
    }

    public PhasorMatrix over(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(bmat);
        return this.times(cmat.inverse());
    }

    public PhasorMatrix over(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public PhasorMatrix over(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public PhasorMatrix over(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public PhasorMatrix over(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public void overEquals(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(bmat);
        this.timesEquals(cmat.inverse());
    }

    public void overEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public PhasorMatrix inverse() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor[] col = new Phasor[n];
        Phasor[] xvec = new Phasor[n];
        PhasorMatrix invmat = new PhasorMatrix(n, n);
        Phasor[][] invarray = invmat.getArrayReference();
        PhasorMatrix ludmat = this.luDecomp();
        int j = 0;
        while (j < n) {
            int i = 0;
            while (i < n) {
                col[i] = Phasor.zero();
                ++i;
            }
            col[j] = Phasor.plusOne();
            xvec = ludmat.luBackSub(col);
            i = 0;
            while (i < n) {
                invarray[i][j] = Phasor.copy(xvec[i]);
                ++i;
            }
            ++j;
        }
        return invmat;
    }

    public PhasorMatrix transpose() {
        PhasorMatrix tmat = new PhasorMatrix(this.ncol, this.nrow);
        Phasor[][] tarray = tmat.getArrayReference();
        int i = 0;
        while (i < this.ncol) {
            int j = 0;
            while (j < this.nrow) {
                tarray[i][j] = Phasor.copy(this.matrix[j][i]);
                ++j;
            }
            ++i;
        }
        return tmat;
    }

    public PhasorMatrix conjugate() {
        PhasorMatrix conj = PhasorMatrix.copy(this);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                conj.matrix[i][j] = this.matrix[i][j].conjugate();
                ++j;
            }
            ++i;
        }
        return conj;
    }

    public PhasorMatrix adjoin() {
        PhasorMatrix adj = PhasorMatrix.copy(this);
        adj = adj.transpose();
        adj = adj.conjugate();
        return adj;
    }

    public PhasorMatrix opposite() {
        PhasorMatrix opp = PhasorMatrix.copy(this);
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                opp.matrix[i][j] = this.matrix[i][j].times(Phasor.minusOne());
                ++j;
            }
            ++i;
        }
        return opp;
    }

    public Phasor trace() {
        Phasor trac = new Phasor(0.0, 0.0);
        int i = 0;
        while (i < Math.min(this.ncol, this.ncol)) {
            trac.plusEquals(this.matrix[i][i]);
            ++i;
        }
        return trac;
    }

    public Phasor determinant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor det = new Phasor();
        PhasorMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        int j = 0;
        while (j < n) {
            det.timesEquals(ludmat.matrix[j][j]);
            ++j;
        }
        return det;
    }

    public Phasor logDeterminant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor det = new Phasor();
        PhasorMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        det = Phasor.log(det);
        int j = 0;
        while (j < n) {
            det.plusEquals(Phasor.log(ludmat.matrix[j][j]));
            ++j;
        }
        return det;
    }

    public double frobeniusNorm() {
        double norm = 0.0;
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                norm = Fmath.hypot(norm, this.matrix[i][j].abs());
                ++j;
            }
            ++i;
        }
        return norm;
    }

    public double oneNorm() {
        double norm = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.nrow) {
            sum2 = 0.0;
            int j = 0;
            while (j < this.ncol) {
                sum2 += this.matrix[i][j].abs();
                ++j;
            }
            norm = Math.max(norm, sum2);
            ++i;
        }
        return norm;
    }

    public double infinityNorm() {
        double norm = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.nrow) {
            sum2 = 0.0;
            int j = 0;
            while (j < this.ncol) {
                sum2 += this.matrix[i][j].abs();
                ++j;
            }
            norm = Math.max(norm, sum2);
            ++i;
        }
        return norm;
    }

    public PhasorMatrix luDecomp() {
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n = this.nrow;
        int imax = 0;
        double dum = 0.0;
        double temp = 0.0;
        double big = 0.0;
        double[] vv = new double[n];
        Phasor sum2 = new Phasor();
        Phasor dumm = new Phasor();
        PhasorMatrix ludmat = PhasorMatrix.copy(this);
        Phasor[][] ludarray = ludmat.getArrayReference();
        ludmat.dswap = 1.0;
        int i = 0;
        while (i < n) {
            big = 0.0;
            int j = 0;
            while (j < n) {
                double d;
                temp = ludarray[i][j].abs();
                if (d > big) {
                    big = temp;
                }
                ++j;
            }
            if (big == 0.0) {
                throw new ArithmeticException("Singular matrix");
            }
            vv[i] = 1.0 / big;
            ++i;
        }
        int j = 0;
        while (j < n) {
            int k;
            int i2 = 0;
            while (i2 < j) {
                sum2 = Phasor.copy(ludarray[i2][j]);
                k = 0;
                while (k < i2) {
                    sum2.minusEquals(ludarray[i2][k].times(ludarray[k][j]));
                    ++k;
                }
                ludarray[i2][j] = Phasor.copy(sum2);
                ++i2;
            }
            big = 0.0;
            i2 = j;
            while (i2 < n) {
                double d;
                sum2 = Phasor.copy(ludarray[i2][j]);
                k = 0;
                while (k < j) {
                    sum2.minusEquals(ludarray[i2][k].times(ludarray[k][j]));
                    ++k;
                }
                ludarray[i2][j] = Phasor.copy(sum2);
                dum = vv[i2] * sum2.abs();
                if (d >= big) {
                    big = dum;
                    imax = i2;
                }
                ++i2;
            }
            if (j != imax) {
                int k2 = 0;
                while (k2 < n) {
                    dumm = Phasor.copy(ludarray[imax][k2]);
                    ludarray[imax][k2] = Phasor.copy(ludarray[j][k2]);
                    ludarray[j][k2] = Phasor.copy(dumm);
                    ++k2;
                }
                ludmat.dswap = -ludmat.dswap;
                vv[imax] = vv[j];
            }
            ludmat.index[j] = imax;
            if (ludarray[j][j].isZero()) {
                ludarray[j][j].reset(1.0E-30, 0.0);
            }
            if (j != n - 1) {
                dumm = ludarray[j][j].inverse();
                i2 = j + 1;
                while (i2 < n) {
                    ludarray[i2][j].timesEquals(dumm);
                    ++i2;
                }
            }
            ++j;
        }
        return ludmat;
    }

    public Phasor[] luBackSub(Phasor[] bvec) {
        int j;
        int ii = 0;
        int ip = 0;
        int n = bvec.length;
        if (n != this.ncol) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.ncol != this.nrow) {
            throw new IllegalArgumentException("matrix is not square");
        }
        Phasor sum2 = new Phasor();
        Phasor[] xvec = new Phasor[n];
        int i = 0;
        while (i < n) {
            xvec[i] = Phasor.copy(bvec[i]);
            ++i;
        }
        i = 0;
        while (i < n) {
            ip = this.index[i];
            sum2 = Phasor.copy(xvec[ip]);
            xvec[ip] = Phasor.copy(xvec[i]);
            if (ii == 0) {
                j = ii;
                while (j <= i - 1) {
                    sum2.minusEquals(this.matrix[i][j].times(xvec[j]));
                    ++j;
                }
            } else if (sum2.isZero()) {
                ii = i;
            }
            xvec[i] = Phasor.copy(sum2);
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            sum2 = Phasor.copy(xvec[i]);
            j = i + 1;
            while (j < n) {
                sum2.minusEquals(this.matrix[i][j].times(xvec[j]));
                ++j;
            }
            xvec[i] = sum2.over(this.matrix[i][i]);
            --i;
        }
        return xvec;
    }

    public Phasor[] solveLinearSet(Phasor[] bvec) {
        PhasorMatrix ludmat = this.luDecomp();
        return ludmat.luBackSub(bvec);
    }
}

