/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.ChiSquareFunct;
import flanagan.analysis.CorrCoeff;
import flanagan.analysis.CrigFunct;
import flanagan.analysis.EngsetLoad;
import flanagan.analysis.EngsetProb;
import flanagan.analysis.ErlangBfunct;
import flanagan.analysis.ErlangCfunct;
import flanagan.analysis.FdistribtionFunct;
import flanagan.analysis.GaussianFunct;
import flanagan.analysis.InverseGammaFunct;
import flanagan.analysis.LogNormalThreeParFunct;
import flanagan.analysis.Regression;
import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.integration.Integration;
import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.PsRandom;
import flanagan.plot.Plot;
import flanagan.plot.PlotGraph;
import flanagan.roots.RealRoot;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;

public class Stat
extends ArrayMaths {
    private boolean nFactorOptionI = false;
    private boolean nFactorReset = false;
    private boolean nEffOptionI = true;
    private boolean nEffReset = false;
    private boolean weightingOptionI = true;
    private boolean weightingReset = false;
    private ArrayMaths amWeights = null;
    private boolean weightsSupplied = false;
    private ArrayList<Object> upperOutlierDetails = new ArrayList();
    private boolean upperDone = false;
    private ArrayList<Object> lowerOutlierDetails = new ArrayList();
    private boolean lowerDone = false;
    private static boolean nFactorOptionS = false;
    private static boolean nEffOptionS = true;
    private static boolean weightingOptionS = true;
    private static int cfMaxIter = 500;
    private static double cfTol = 1.0E-8;
    public static final double FPMIN = 1.0E-300;
    private static boolean igSupress = false;
    private static int lgfN = 6;
    private static double[] lgfCoeff = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double lgfGamma = 5.0;
    private static int igfiter = 1000;
    private static double igfeps = 1.0E-8;
    private static double histTol = 1.0001;

    public static double beta(double z, double w) {
        return Math.exp(Stat.logGamma(z) + Stat.logGamma(w) - Stat.logGamma(z + w));
    }

    public static double betaCDF(double alpha, double beta2, double limit) {
        return Stat.betaCDF(0.0, 1.0, alpha, beta2, limit);
    }

    public static double betaCDF(double min2, double max2, double alpha, double beta2, double limit) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta2 + "must be greater than zero");
        }
        if (limit < min2) {
            throw new IllegalArgumentException("limit, " + limit + ", must be greater than or equal to the minimum value, " + min2);
        }
        if (limit > max2) {
            throw new IllegalArgumentException("limit, " + limit + ", must be less than or equal to the maximum value, " + max2);
        }
        return Stat.regularisedBetaFunction(alpha, beta2, (limit - min2) / (max2 - min2));
    }

    public static double betaFunction(double z, double w) {
        return Math.exp(Stat.logGamma(z) + Stat.logGamma(w) - Stat.logGamma(z + w));
    }

    public static double betaMean(double alpha, double beta2) {
        return Stat.betaMean(0.0, 1.0, alpha, beta2);
    }

    public static double betaMean(double min2, double max2, double alpha, double beta2) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta2 + "must be greater than zero");
        }
        return min2 + alpha * (max2 - min2) / (alpha + beta2);
    }

    public static double betaMode(double alpha, double beta2) {
        return Stat.betaMode(0.0, 1.0, alpha, beta2);
    }

    public static double betaMode(double min2, double max2, double alpha, double beta2) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta2 + "must be greater than zero");
        }
        double mode = Double.NaN;
        if (alpha > 1.0) {
            mode = beta2 > 1.0 ? min2 + (alpha + beta2) * (max2 - min2) / (alpha + beta2 - 2.0) : max2;
        } else if (alpha == 1.0) {
            mode = beta2 > 1.0 ? min2 : (beta2 == 1.0 ? Double.NaN : max2);
        } else if (beta2 >= 1.0) {
            mode = min2;
        } else {
            System.out.println("Class Stat; method betaMode; distribution is bimodal wirh modes at " + min2 + " and " + max2);
            System.out.println("NaN returned");
        }
        return mode;
    }

    public static double betaPDF(double alpha, double beta2, double x2) {
        return Stat.betaPDF(0.0, 1.0, alpha, beta2, x2);
    }

    public static double betaPDF(double min2, double max2, double alpha, double beta2, double x2) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta2 + "must be greater than zero");
        }
        if (x2 < min2) {
            throw new IllegalArgumentException("x, " + x2 + ", must be greater than or equal to the minimum value, " + min2);
        }
        if (x2 > max2) {
            throw new IllegalArgumentException("x, " + x2 + ", must be less than or equal to the maximum value, " + max2);
        }
        double pdf = Math.pow(x2 - min2, alpha - 1.0) * Math.pow(max2 - x2, beta2 - 1.0) / Math.pow(max2 - min2, alpha + beta2 - 1.0);
        return pdf / Stat.betaFunction(alpha, beta2);
    }

    public static double[] betaRand(double min2, double max2, double alpha, double beta2, int n) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta2 + "must be greater than zero");
        }
        PsRandom psr = new PsRandom();
        return psr.betaArray(min2, max2, alpha, beta2, n);
    }

    public static double[] betaRand(double min2, double max2, double alpha, double beta2, int n, long seed) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter,  beta, " + beta2 + "must be greater than zero");
        }
        PsRandom psr = new PsRandom(seed);
        return psr.betaArray(min2, max2, alpha, beta2, n);
    }

    public static double[] betaRand(double alpha, double beta2, int n) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta2 + "must be greater than zero");
        }
        PsRandom psr = new PsRandom();
        return psr.betaArray(alpha, beta2, n);
    }

    public static double[] betaRand(double alpha, double beta2, int n, long seed) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter,  beta, " + beta2 + "must be greater than zero");
        }
        PsRandom psr = new PsRandom(seed);
        return psr.betaArray(alpha, beta2, n);
    }

    public static double betaStandardDeviation(double alpha, double beta2) {
        return Stat.betaStandDev(alpha, beta2);
    }

    public static double betaStandardDeviation(double min2, double max2, double alpha, double beta2) {
        return Stat.betaStandDev(min2, max2, alpha, beta2);
    }

    public static double betaStandDev(double alpha, double beta2) {
        return Stat.betaStandDev(0.0, 1.0, alpha, beta2);
    }

    public static double betaStandDev(double min2, double max2, double alpha, double beta2) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta2 + "must be greater than zero");
        }
        return (max2 - min2) / (alpha + beta2) * Math.sqrt(alpha * beta2 / (alpha + beta2 + 1.0));
    }

    public static double binaryShannonEntropy(double p) {
        if (p > 1.0) {
            throw new IllegalArgumentException("The probabiliy, " + p + ",  must be less than or equal to 1");
        }
        if (p < 0.0) {
            throw new IllegalArgumentException("The probabiliy, " + p + ",  must be greater than or equal to 0");
        }
        double entropy = 0.0;
        if (p > 0.0 && p < 1.0) {
            entropy = -p * Fmath.log2(p) - (1.0 - p) * Fmath.log2(1.0 - p);
        }
        return entropy;
    }

    public static double binaryShannonEntropyBit(double p) {
        return Stat.binaryShannonEntropy(p);
    }

    public static double binaryShannonEntropyDit(double p) {
        if (p > 1.0) {
            throw new IllegalArgumentException("The probabiliy, " + p + ",  must be less than or equal to 1");
        }
        if (p < 0.0) {
            throw new IllegalArgumentException("The probabiliy, " + p + ",  must be greater than or equal to 0");
        }
        double entropy = 0.0;
        if (p > 0.0 && p < 1.0) {
            entropy = -p * Math.log10(p) - (1.0 - p) * Math.log10(1.0 - p);
        }
        return entropy;
    }

    public static double binaryShannonEntropyNat(double p) {
        if (p > 1.0) {
            throw new IllegalArgumentException("The probabiliy, " + p + ",  must be less than or equal to 1");
        }
        if (p < 0.0) {
            throw new IllegalArgumentException("The probabiliy, " + p + ",  must be greater than or equal to 0");
        }
        double entropy = 0.0;
        if (p > 0.0 && p < 1.0) {
            entropy = -p * Math.log(p) - (1.0 - p) * Math.log(1.0 - p);
        }
        return entropy;
    }

    public static double binomial(double p, int n, int k) {
        if (k < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (k > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Math.floor(0.5 + Math.exp(Stat.logFactorial(n) - Stat.logFactorial(k) - Stat.logFactorial(n - k))) * Math.pow(p, k) * Math.pow(1.0 - p, n - k);
    }

    public static double binomialCDF(double p, int n, int k) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("\np must lie between 0 and 1");
        }
        if (k < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (k > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Stat.regularisedBetaFunction(k, n - k + 1, p);
    }

    public static double binomialCoeff(int n, int k) {
        if (k < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (k > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Math.floor(0.5 + Math.exp(Stat.logFactorial(n) - Stat.logFactorial(k) - Stat.logFactorial(n - k)));
    }

    public static double binomialPDF(double p, int n, int k) {
        if (k < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (k > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Math.floor(0.5 + Math.exp(Stat.logFactorial(n) - Stat.logFactorial(k) - Stat.logFactorial(n - k))) * Math.pow(p, k) * Math.pow(1.0 - p, n - k);
    }

    public static double binomialProb(double p, int n, int k) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("\np must lie between 0 and 1");
        }
        if (k < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (k > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Stat.regularisedBetaFunction(k, n - k + 1, p);
    }

    public static double chiSquare(double[] observed, double[] expected, double[] variance) {
        int nObs = observed.length;
        int nExp = expected.length;
        int nVar = variance.length;
        if (nObs != nExp) {
            throw new IllegalArgumentException("observed array length does not equal the expected array length");
        }
        if (nObs != nVar) {
            throw new IllegalArgumentException("observed array length does not equal the variance array length");
        }
        double chi = 0.0;
        int i = 0;
        while (i < nObs) {
            chi += Fmath.square(observed[i] - expected[i]) / variance[i];
            ++i;
        }
        return chi;
    }

    public static double chiSquareCDF(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return Stat.incompleteGamma((double)nu / 2.0, chiSquare / 2.0);
    }

    public static double chiSquareFreq(double[] observedFreq, double[] expectedFreq) {
        int nObs = observedFreq.length;
        int nExp = expectedFreq.length;
        if (nObs != nExp) {
            throw new IllegalArgumentException("observed array length does not equal the expected array length");
        }
        double chi = 0.0;
        int i = 0;
        while (i < nObs) {
            chi += Fmath.square(observedFreq[i] - expectedFreq[i]) / expectedFreq[i];
            ++i;
        }
        return chi;
    }

    public static double chiSquareFreq(int[] observedFreq, int[] expectedFreq) {
        int nObs = observedFreq.length;
        int nExp = expectedFreq.length;
        if (nObs != nExp) {
            throw new IllegalArgumentException("observed array length does not equal the expected array length");
        }
        double[] observ = new double[nObs];
        double[] expect = new double[nObs];
        int i = 0;
        while (i < nObs) {
            observ[i] = observedFreq[i];
            expect[i] = expectedFreq[i];
            ++i;
        }
        return Stat.chiSquareFreq(observ, expect);
    }

    public static double chiSquareInverseCDF(int nu, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        if (prob == 0.0) {
            icdf = 0.0;
        } else if (prob == 1.0) {
            icdf = Double.POSITIVE_INFINITY;
        } else {
            ChiSquareFunct chi = new ChiSquareFunct();
            chi.nu = nu;
            double tolerance = 1.0E-12;
            double lowerBound = 0.0;
            double upperBound = (double)nu + 10.0 * Math.sqrt(2.0 * (double)nu);
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            chi.cfd = prob;
            icdf = realR.bisect(chi, lowerBound, upperBound);
        }
        return icdf;
    }

    public static double chiSquareMean(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return nu;
    }

    public static double chiSquareMode(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        double mode = 0.0;
        if (nu >= 2) {
            mode = (double)nu - 2.0;
        }
        return mode;
    }

    public static double chiSquarePDF(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        double dnu = nu;
        return Math.pow(0.5, dnu / 2.0) * Math.pow(chiSquare, dnu / 2.0 - 1.0) * Math.exp(-chiSquare / 2.0) / Stat.gammaFunction(dnu / 2.0);
    }

    public static double chiSquareProb(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return Stat.incompleteGamma((double)nu / 2.0, chiSquare / 2.0);
    }

    public static double[] chiSquareRand(int nu, int n) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        PsRandom psr = new PsRandom();
        return psr.chiSquareArray(nu, n);
    }

    public static double[] chiSquareRand(int nu, int n, long seed) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        PsRandom psr = new PsRandom(seed);
        return psr.chiSquareArray(nu, n);
    }

    public static double chiSquareStandardDeviation(int nu) {
        return Stat.chiSquareStandDev(nu);
    }

    public static double chiSquareStandDev(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        double dnu = nu;
        return Math.sqrt(2.0 * dnu);
    }

    public static double coefficientOfVariation(BigDecimal[] array) {
        return 100.0 * Stat.standardDeviation(array) / Math.abs(Stat.mean(array).doubleValue());
    }

    public static double coefficientOfVariation(BigDecimal[] array, BigDecimal[] weight) {
        int n = array.length;
        if (n != weight.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + weight.length + " are different");
        }
        return 100.0 * Stat.standardDeviation(array, weight) / Math.abs(Stat.mean(array, weight).doubleValue());
    }

    public static double coefficientOfVariation(BigInteger[] array) {
        return 100.0 * Stat.standardDeviation(array) / Math.abs(Stat.mean(array).doubleValue());
    }

    public static double coefficientOfVariation(BigInteger[] array, BigInteger[] weight) {
        int n = array.length;
        if (n != weight.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + weight.length + " are different");
        }
        return 100.0 * Stat.standardDeviation(array, weight) / Math.abs(Stat.mean(array, weight).doubleValue());
    }

    public static double coefficientOfVariation(double[] array) {
        return 100.0 * Stat.standardDeviation(array) / Math.abs(Stat.mean(array));
    }

    public static double coefficientOfVariation(double[] array, double[] weight) {
        int n = array.length;
        if (n != weight.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + weight.length + " are different");
        }
        return 100.0 * Stat.standardDeviation(array, weight) / Math.abs(Stat.mean(array, weight));
    }

    public static float coefficientOfVariation(float[] array) {
        return 100.0f * Stat.standardDeviation(array) / Math.abs(Stat.mean(array));
    }

    public static float coefficientOfVariation(float[] array, float[] weight) {
        int n = array.length;
        if (n != weight.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + weight.length + " are different");
        }
        return 100.0f * Stat.standardDeviation(array, weight) / Math.abs(Stat.mean(array, weight));
    }

    public static double complementaryRegularisedGammaFunction(double a, double x2) {
        if (a < 0.0 || x2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        boolean oldIgSupress = igSupress;
        igSupress = true;
        double igf = 1.0;
        if (x2 != 0.0) {
            igf = x2 == Double.POSITIVE_INFINITY ? 0.0 : (x2 < a + 1.0 ? 1.0 - Stat.incompleteGammaSer(a, x2) : 1.0 - Stat.incompleteGammaFract(a, x2));
        }
        if (igf > 1.0) {
            igf = 1.0;
        }
        igSupress = oldIgSupress;
        return igf;
    }

    public static double complementaryRegularizedGammaFunction(double a, double x2) {
        return Stat.complementaryRegularisedGammaFunction(a, x2);
    }

    public static double contFract(double a, double b, double x2) {
        double aplusb = a + b;
        double aplus1 = a + 1.0;
        double aminus1 = a - 1.0;
        double c = 1.0;
        double d = 1.0 - aplusb * x2 / aplus1;
        if (Math.abs(d) < 1.0E-300) {
            d = 1.0E-300;
        }
        double h = d = 1.0 / d;
        double aa = 0.0;
        double del = 0.0;
        int i = 1;
        int i2 = 0;
        boolean test2 = true;
        while (test2) {
            i2 = 2 * i;
            aa = (double)i * (b - (double)i) * x2 / ((aminus1 + (double)i2) * (a + (double)i2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-300) {
                d = 1.0E-300;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-300) {
                c = 1.0E-300;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(a + (double)i) * (aplusb + (double)i) * x2 / ((a + (double)i2) * (aplus1 + (double)i2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-300) {
                d = 1.0E-300;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-300) {
                c = 1.0E-300;
            }
            d = 1.0 / d;
            del = d * c;
            h *= del;
            ++i;
            if (Math.abs(del - 1.0) < cfTol) {
                test2 = false;
            }
            if (i <= cfMaxIter) continue;
            test2 = false;
            System.out.println("Maximum number of iterations (" + cfMaxIter + ") exceeded in Stat.contFract in Stat.incompleteBeta");
        }
        return h;
    }

    public static double[] convertBigWtoLittleW(BigDecimal[] bigW) {
        ArrayMaths am1 = new ArrayMaths(bigW);
        ArrayMaths am2 = am1.oneOverSqrt();
        return am2.getArray_as_double();
    }

    public static double[] convertBigWtoLittleW(BigInteger[] bigW) {
        ArrayMaths am1 = new ArrayMaths(bigW);
        ArrayMaths am2 = am1.oneOverSqrt();
        return am2.getArray_as_double();
    }

    public static Complex[] convertBigWtoLittleW(Complex[] bigW) {
        ArrayMaths am1 = new ArrayMaths(bigW);
        ArrayMaths am2 = am1.oneOverSqrt();
        return am2.getArray_as_Complex();
    }

    public static double[] convertBigWtoLittleW(double[] bigW) {
        ArrayMaths am1 = new ArrayMaths(bigW);
        ArrayMaths am2 = am1.oneOverSqrt();
        return am2.getArray_as_double();
    }

    public static float[] convertBigWtoLittleW(float[] bigW) {
        ArrayMaths am1 = new ArrayMaths(bigW);
        ArrayMaths am2 = am1.oneOverSqrt();
        return am2.getArray_as_float();
    }

    public static double corrCoeff(double[] xx, double[] yy) {
        int nData = xx.length;
        if (yy.length != nData) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        double mx = 0.0;
        double my = 0.0;
        int i = 0;
        while (i < nData) {
            mx += xx[i];
            my += yy[i];
            ++i;
        }
        mx /= (double)nData;
        my /= (double)nData;
        double s2xx = 0.0;
        double s2yy = 0.0;
        double s2xy = 0.0;
        int i2 = 0;
        while (i2 < nData) {
            s2xx += Fmath.square(xx[i2] - mx);
            s2yy += Fmath.square(yy[i2] - my);
            s2xy += (xx[i2] - mx) * (yy[i2] - my);
            ++i2;
        }
        double sampleR = s2xy / Math.sqrt(s2xx * s2yy);
        if (sampleR > 1.0 && Fmath.isEqualWithinLimits(sampleR, 1.0, 0.001)) {
            sampleR = 1.0;
        }
        if (sampleR < -1.0 && Fmath.isEqualWithinLimits(Math.abs(sampleR), 1.0, 0.001)) {
            sampleR = -1.0;
        }
        return sampleR;
    }

    public static double corrCoeff(double[] x2, double[] y, double[] w) {
        double sy;
        double sx;
        int n = x2.length;
        if (y.length != n) {
            throw new IllegalArgumentException("x and y array lengths must be equal");
        }
        if (w.length != n) {
            throw new IllegalArgumentException("x and weight array lengths must be equal");
        }
        double sxy = Stat.covariance(x2, y, w);
        double sampleR = sxy / Math.sqrt((sx = Stat.variance(x2, w)) * (sy = Stat.variance(y, w)));
        if (sampleR > 1.0 && Fmath.isEqualWithinLimits(sampleR, 1.0, 0.001)) {
            sampleR = 1.0;
        }
        if (sampleR < -1.0 && Fmath.isEqualWithinLimits(Math.abs(sampleR), 1.0, 0.001)) {
            sampleR = -1.0;
        }
        return sampleR;
    }

    public static float corrCoeff(float[] x2, float[] y) {
        int nData = x2.length;
        if (y.length != nData) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        int n = x2.length;
        double[] xx = new double[n];
        double[] yy = new double[n];
        int i = 0;
        while (i < n) {
            xx[i] = x2[i];
            yy[i] = y[i];
            ++i;
        }
        return (float)Stat.corrCoeff(xx, yy);
    }

    public static double corrCoeff(int element00, int element01, int element10, int element11) {
        double sampleR = (double)(element00 * element11 - element01 * element10) / Math.sqrt((element00 + element01) * (element10 + element11) * (element00 + element10) * (element01 + element11));
        if (sampleR > 1.0 && Fmath.isEqualWithinLimits(sampleR, 1.0, 0.001)) {
            sampleR = 1.0;
        }
        if (sampleR < -1.0 && Fmath.isEqualWithinLimits(Math.abs(sampleR), 1.0, 0.001)) {
            sampleR = -1.0;
        }
        return sampleR;
    }

    public static double corrCoeff(int[] x2, int[] y) {
        int n = x2.length;
        if (y.length != n) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        double[] xx = new double[n];
        double[] yy = new double[n];
        int i = 0;
        while (i < n) {
            xx[i] = x2[i];
            yy[i] = y[i];
            ++i;
        }
        return Stat.corrCoeff(xx, yy);
    }

    public static double corrCoeff(int[][] freqMatrix) {
        double element00 = freqMatrix[0][0];
        double element11 = freqMatrix[1][1];
        double element01 = freqMatrix[0][1];
        double element10 = freqMatrix[1][0];
        double sampleR = (element00 * element11 - element01 * element10) / Math.sqrt((element00 + element01) * (element10 + element11) * (element00 + element10) * (element01 + element11));
        if (sampleR > 1.0 && Fmath.isEqualWithinLimits(sampleR, 1.0, 0.001)) {
            sampleR = 1.0;
        }
        if (sampleR < -1.0 && Fmath.isEqualWithinLimits(Math.abs(sampleR), 1.0, 0.001)) {
            sampleR = -1.0;
        }
        return sampleR;
    }

    public static double corrCoeffPdf(double rCoeff, int nu) {
        if (Math.abs(rCoeff) > 1.0) {
            throw new IllegalArgumentException("|Correlation coefficient| > 1 :  " + rCoeff);
        }
        double a = ((double)nu - 2.0) / 2.0;
        double y = Math.pow(1.0 - Fmath.square(rCoeff), a);
        double preterm = Math.exp(Stat.logGamma(((double)nu + 1.0) / 2.0) - Stat.logGamma((double)nu / 2.0)) / Math.sqrt(Math.PI);
        return preterm * y;
    }

    public static double corrCoeffPDF(double rCoeff, int nu) {
        if (Math.abs(rCoeff) > 1.0) {
            throw new IllegalArgumentException("|Correlation coefficient| > 1 :  " + rCoeff);
        }
        double a = ((double)nu - 2.0) / 2.0;
        double y = Math.pow(1.0 - Fmath.square(rCoeff), a);
        double preterm = Math.exp(Stat.logGamma(((double)nu + 1.0) / 2.0) - Stat.logGamma((double)nu / 2.0)) / Math.sqrt(Math.PI);
        return preterm * y;
    }

    public static double corrCoeffProb(double rCoeff, int nu) {
        if (Math.abs(rCoeff) > 1.0) {
            throw new IllegalArgumentException("|Correlation coefficient| > 1 :  " + rCoeff);
        }
        CorrCoeff cc = new CorrCoeff();
        cc.a = ((double)nu - 2.0) / 2.0;
        double integral = Integration.gaussQuad(cc, Math.abs(rCoeff), 1.0, 128);
        double preterm = Math.exp(Stat.logGamma(((double)nu + 1.0) / 2.0) - Stat.logGamma((double)nu / 2.0)) / Math.sqrt(Math.PI);
        return preterm * integral;
    }

    public static double covariance(double[] xx, double[] yy) {
        int n = xx.length;
        if (n != yy.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + yy.length + " are different");
        }
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sumx = 0.0;
        double meanx = 0.0;
        double sumy = 0.0;
        double meany = 0.0;
        int i = 0;
        while (i < n) {
            sumx += xx[i];
            sumy += yy[i];
            ++i;
        }
        meanx = sumx / (double)n;
        meany = sumy / (double)n;
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < n) {
            sum2 += (xx[i2] - meanx) * (yy[i2] - meany);
            ++i2;
        }
        return sum2 / denom;
    }

    public static double covariance(double[] xx, double[] yy, double[] ww) {
        int n = xx.length;
        if (n != yy.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + yy.length + " are different");
        }
        if (n != ww.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of weight array, " + yy.length + " are different");
        }
        double nn = Stat.effectiveSampleNumber(ww);
        double nterm = nn / (nn - 1.0);
        if (nFactorOptionS) {
            nterm = 1.0;
        }
        double sumx = 0.0;
        double sumy = 0.0;
        double sumw = 0.0;
        double meanx = 0.0;
        double meany = 0.0;
        double[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumx += xx[i] * weight[i];
            sumy += yy[i] * weight[i];
            sumw += weight[i];
            ++i;
        }
        meanx = sumx / sumw;
        meany = sumy / sumw;
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < n) {
            sum2 += weight[i2] * (xx[i2] - meanx) * (yy[i2] - meany);
            ++i2;
        }
        return sum2 * nterm / sumw;
    }

    public static float covariance(float[] xx, float[] yy) {
        int n = xx.length;
        if (n != yy.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + yy.length + " are different");
        }
        float denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        float sumx = 0.0f;
        float meanx = 0.0f;
        float sumy = 0.0f;
        float meany = 0.0f;
        int i = 0;
        while (i < n) {
            sumx += xx[i];
            sumy += yy[i];
            ++i;
        }
        meanx = sumx / (float)n;
        meany = sumy / (float)n;
        float sum2 = 0.0f;
        int i2 = 0;
        while (i2 < n) {
            sum2 += (xx[i2] - meanx) * (yy[i2] - meany);
            ++i2;
        }
        return sum2 / denom;
    }

    public static double covariance(int[] xx, int[] yy) {
        int n = xx.length;
        if (n != yy.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + yy.length + " are different");
        }
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sumx = 0.0;
        double meanx = 0.0;
        double sumy = 0.0;
        double meany = 0.0;
        int i = 0;
        while (i < n) {
            sumx += (double)xx[i];
            sumy += (double)yy[i];
            ++i;
        }
        meanx = sumx / (double)n;
        meany = sumy / (double)n;
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < n) {
            sum2 += ((double)xx[i2] - meanx) * ((double)yy[i2] - meany);
            ++i2;
        }
        return sum2 / denom;
    }

    public static double covariance(long[] xx, long[] yy) {
        int n = xx.length;
        if (n != yy.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + yy.length + " are different");
        }
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sumx = 0.0;
        double meanx = 0.0;
        double sumy = 0.0;
        double meany = 0.0;
        int i = 0;
        while (i < n) {
            sumx += (double)xx[i];
            sumy += (double)yy[i];
            ++i;
        }
        meanx = sumx / (double)n;
        meany = sumy / (double)n;
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < n) {
            sum2 += ((double)xx[i2] - meanx) * ((double)yy[i2] - meany);
            ++i2;
        }
        return sum2 / denom;
    }

    private static double crigfGaussQuad(double a, double x2) {
        double sum2 = 0.0;
        double upper = 100.0 * a;
        double range2 = upper - x2;
        double incr = 0.0;
        if (upper > x2 && range2 > 100.0) {
            incr = range2 / 1000.0;
        } else {
            upper = x2 + 100.0;
            range2 = 100.0;
            incr = 0.1;
        }
        int nIncr = (int)Math.round(range2 / incr);
        incr = range2 / (double)nIncr;
        CrigFunct f1 = new CrigFunct();
        f1.setA(a);
        f1.setB(Stat.logGammaFunction(a));
        Integration intgn1 = new Integration(f1);
        double xx = x2;
        double yy = x2 + incr;
        intgn1.setLimits(xx, yy);
        sum2 = intgn1.gaussQuad(64);
        int i = 1;
        while (i < nIncr) {
            xx = yy;
            yy = xx + incr;
            intgn1.setLimits(xx, yy);
            sum2 += intgn1.gaussQuad(64);
            ++i;
        }
        return sum2;
    }

    public static BigDecimal curtosis(BigDecimal[] aa) {
        return Stat.kurtosis(aa);
    }

    public static BigDecimal curtosis(BigInteger[] aa) {
        return Stat.kurtosis(aa);
    }

    public static double curtosis(double[] aa) {
        return Stat.kurtosis(aa);
    }

    public static float curtosis(float[] aa) {
        return Stat.kurtosis(aa);
    }

    public static double curtosis(int[] aa) {
        return Stat.kurtosis(aa);
    }

    public static double curtosis(long[] aa) {
        return Stat.kurtosis(aa);
    }

    public static BigDecimal curtosisExcess(BigDecimal[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static BigDecimal curtosisExcess(BigInteger[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double curtosisExcess(double[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static float curtosisExcess(float[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double curtosisExcess(int[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double curtosisExcess(long[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static BigDecimal effectiveSampleNumber(BigDecimal[] ww) {
        BigDecimal[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_BigDecimal();
        }
        int n = weight.length;
        BigDecimal nEff = new BigDecimal(new Integer(n).toString());
        if (nEffOptionS) {
            BigDecimal sumw2 = BigDecimal.ZERO;
            BigDecimal sum2w = BigDecimal.ZERO;
            int i = 0;
            while (i < n) {
                sum2w = sum2w.add(weight[i]);
                sumw2 = sumw2.add(weight[i].multiply(weight[i]));
                ++i;
            }
            sum2w = sum2w.multiply(sum2w);
            nEff = sum2w.divide(sumw2, 4);
            sumw2 = null;
            sum2w = null;
            weight = null;
        }
        return nEff;
    }

    public static BigDecimal effectiveSampleNumber(BigInteger[] ww) {
        ArrayMaths am = new ArrayMaths(ww);
        BigDecimal[] www = am.array_as_BigDecimal();
        return Stat.effectiveSampleNumber(www);
    }

    public static Complex effectiveSampleNumber(Complex[] ww) {
        Complex[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_Complex();
        }
        int n = weight.length;
        Complex nEff = new Complex(n, 0.0);
        if (nEffOptionS) {
            Complex sumw2 = Complex.zero();
            Complex sum2w = Complex.zero();
            int i = 0;
            while (i < n) {
                sum2w = sum2w.plus(weight[i]);
                sumw2 = sumw2.plus(weight[i].times(weight[i]));
                ++i;
            }
            sum2w = sum2w.times(sum2w);
            nEff = sum2w.over(sumw2);
        }
        return nEff;
    }

    public static double effectiveSampleNumber(double[] ww) {
        double[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array();
        }
        int n = weight.length;
        double nEff = n;
        if (nEffOptionS) {
            double sum2w = 0.0;
            double sumw2 = 0.0;
            int i = 0;
            while (i < n) {
                sum2w += weight[i];
                sumw2 += weight[i] * weight[i];
                ++i;
            }
            sum2w *= sum2w;
            nEff = sum2w / sumw2;
        }
        return nEff;
    }

    public static float effectiveSampleNumber(float[] ww) {
        float[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_float();
        }
        int n = weight.length;
        float nEff = n;
        if (nEffOptionS) {
            float sum2w = 0.0f;
            float sumw2 = 0.0f;
            int i = 0;
            while (i < n) {
                sum2w += weight[i];
                sumw2 += weight[i] * weight[i];
                ++i;
            }
            sum2w *= sum2w;
            nEff = sum2w / sumw2;
        }
        return nEff;
    }

    public static double effectiveSampleNumberConjugateCalcn(Complex[] ww) {
        Complex[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_Complex();
        }
        int n = weight.length;
        double nEff = Double.NaN;
        if (nEffOptionS) {
            Complex sumw2 = Complex.zero();
            Complex sum2w = Complex.zero();
            int i = 0;
            while (i < n) {
                sum2w = sum2w.plus(weight[i]);
                sumw2 = sumw2.plus(weight[i].times(weight[i].conjugate()));
                ++i;
            }
            sum2w = sum2w.times(sum2w.conjugate());
            nEff = sum2w.getReal() / sumw2.getReal();
        }
        return nEff;
    }

    public static double engsetLoad(double blockingProbability, double totalResources, double numberOfSources) {
        if (totalResources < 1.0) {
            throw new IllegalArgumentException("Total resources, " + totalResources + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(totalResources)) {
            throw new IllegalArgumentException("Total resources, " + totalResources + ", must be, arithmetically, an integer");
        }
        if (numberOfSources < 1.0) {
            throw new IllegalArgumentException("number of sources, " + numberOfSources + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(numberOfSources)) {
            throw new IllegalArgumentException("number of sources, " + numberOfSources + ", must be, arithmetically, an integer");
        }
        if (totalResources > numberOfSources - 1.0) {
            throw new IllegalArgumentException("total resources, " + totalResources + ", must be less than or  equal to the number of sources minus one, " + (numberOfSources - 1.0));
        }
        EngsetLoad eLfunc = new EngsetLoad();
        eLfunc.blockingProbability = blockingProbability;
        eLfunc.totalResources = totalResources;
        eLfunc.numberOfSources = numberOfSources;
        double lowerBound = 0.0;
        double upperBound = numberOfSources * 0.999999999;
        double tolerance = 1.0E-6;
        RealRoot realR = new RealRoot();
        realR.setTolerance(tolerance);
        realR.noLowerBoundExtension();
        realR.noUpperBoundExtension();
        realR.supressLimitReachedMessage();
        double root2 = realR.bisect(eLfunc, lowerBound, upperBound);
        return root2;
    }

    public static double engsetLoad(double blockingProbability, int totalResources, int numberOfSources) {
        return Stat.engsetLoad(blockingProbability, (double)totalResources, (double)numberOfSources);
    }

    public static double engsetLoad(double blockingProbability, long totalResources, long numberOfSources) {
        return Stat.engsetLoad(blockingProbability, (double)totalResources, (double)numberOfSources);
    }

    public static double engsetProbability(double offeredTraffic, double totalResources, double numberOfSources) {
        if (totalResources < 1.0) {
            throw new IllegalArgumentException("Total resources, " + totalResources + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(totalResources)) {
            throw new IllegalArgumentException("Total resources, " + totalResources + ", must be, arithmetically, an integer");
        }
        if (numberOfSources < 1.0) {
            throw new IllegalArgumentException("number of sources, " + numberOfSources + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(numberOfSources)) {
            throw new IllegalArgumentException("number of sources, " + numberOfSources + ", must be, arithmetically, an integer");
        }
        if (totalResources > numberOfSources - 1.0) {
            throw new IllegalArgumentException("total resources, " + totalResources + ", must be less than or  equal to the number of sources minus one, " + (numberOfSources - 1.0));
        }
        if (offeredTraffic >= numberOfSources) {
            throw new IllegalArgumentException("Number of sources, " + numberOfSources + ", must be greater than the offered traffic, " + offeredTraffic);
        }
        double prob = 0.0;
        if (totalResources == 0.0) {
            prob = 1.0;
        } else if (offeredTraffic == 0.0) {
            prob = 0.0;
        } else {
            double lowerBound = 0.0;
            double upperBound = 1.0;
            EngsetProb engProb = new EngsetProb();
            engProb.offeredTraffic = offeredTraffic;
            engProb.totalResources = totalResources;
            engProb.numberOfSources = numberOfSources;
            RealRoot eprt = new RealRoot();
            eprt.supressLimitReachedMessage();
            prob = eprt.bisect(engProb, lowerBound, upperBound);
        }
        return prob;
    }

    public static double engsetProbability(double offeredTraffic, int totalResources, int numberOfSources) {
        return Stat.engsetProbability(offeredTraffic, (double)totalResources, (double)numberOfSources);
    }

    public static double engsetProbability(double offeredTraffic, long totalResources, long numberOfSources) {
        return Stat.engsetProbability(offeredTraffic, (double)totalResources, (double)numberOfSources);
    }

    public static double[] engsetResources(double blockingProbability, double offeredTraffic, double numberOfSources) {
        if (numberOfSources < 1.0) {
            throw new IllegalArgumentException("number of sources, " + numberOfSources + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(numberOfSources)) {
            throw new IllegalArgumentException("number of sources, " + numberOfSources + ", must be, arithmetically, an integer");
        }
        double[] ret = new double[9];
        long counter = 1L;
        double lastProb = Double.NaN;
        double prob = Double.NaN;
        boolean test2 = true;
        while (test2) {
            prob = Stat.engsetProbability(offeredTraffic, (double)counter, numberOfSources);
            if (prob <= blockingProbability) {
                ret[0] = counter;
                ret[1] = prob;
                ret[2] = Stat.engsetLoad(blockingProbability, (double)counter, numberOfSources);
                ret[3] = counter - 1L;
                ret[4] = lastProb;
                ret[5] = Stat.engsetLoad(blockingProbability, (double)(counter - 1L), numberOfSources);
                ret[6] = blockingProbability;
                ret[7] = offeredTraffic;
                ret[8] = numberOfSources;
                test2 = false;
                continue;
            }
            lastProb = prob;
            if (++counter <= (long)numberOfSources - 1L) continue;
            System.out.println("Method engsetResources: no solution found below the (sources-1), " + (numberOfSources - 1.0));
            int i = 0;
            while (i < 8) {
                ret[i] = Double.NaN;
                ++i;
            }
            test2 = false;
        }
        return ret;
    }

    public static double[] engsetResources(double blockingProbability, double totalTraffic, int numberOfSources) {
        return Stat.engsetResources(blockingProbability, totalTraffic, (double)numberOfSources);
    }

    public static double[] engsetResources(double blockingProbability, double totalTraffic, long numberOfSources) {
        return Stat.engsetResources(blockingProbability, totalTraffic, (double)numberOfSources);
    }

    public static double[] engsetSources(double blockingProbability, double offeredTraffic, double resources) {
        if (resources < 1.0) {
            throw new IllegalArgumentException("resources, " + resources + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(resources)) {
            throw new IllegalArgumentException("resources, " + resources + ", must be, arithmetically, an integer");
        }
        double[] ret = new double[9];
        long counter = (long)resources + 1L;
        double lastProb = Double.NaN;
        double prob = Double.NaN;
        boolean test2 = true;
        while (test2) {
            prob = Stat.engsetProbability(offeredTraffic, resources, (double)counter);
            if (prob >= blockingProbability) {
                ret[0] = counter;
                ret[1] = prob;
                ret[2] = Stat.engsetLoad(blockingProbability, resources, (double)counter);
                ret[3] = counter - 1L;
                ret[4] = lastProb;
                ret[5] = counter - 1L >= (long)(resources + 1.0) ? Stat.engsetLoad(blockingProbability, resources, (double)(counter - 1L)) : Double.NaN;
                ret[6] = blockingProbability;
                ret[7] = offeredTraffic;
                ret[8] = resources;
                test2 = false;
                continue;
            }
            lastProb = prob;
            if (++counter < Long.MAX_VALUE) continue;
            System.out.println("Method engsetResources: no solution found below 9223372036854775807sources");
            int i = 0;
            while (i < 8) {
                ret[i] = Double.NaN;
                ++i;
            }
            test2 = false;
        }
        return ret;
    }

    public static double[] engsetSources(double blockingProbability, double totalTraffic, int resources) {
        return Stat.engsetSources(blockingProbability, totalTraffic, (double)resources);
    }

    public static double[] engsetSources(double blockingProbability, double totalTraffic, long resources) {
        return Stat.engsetSources(blockingProbability, totalTraffic, (double)resources);
    }

    public static double erf(double x2) {
        double erf = 0.0;
        if (x2 != 0.0) {
            erf = x2 == Double.POSITIVE_INFINITY ? 1.0 : (x2 >= 0.0 ? Stat.incompleteGamma(0.5, x2 * x2) : -Stat.incompleteGamma(0.5, x2 * x2));
        }
        return erf;
    }

    public static double erfc(double x2) {
        double erfc = 1.0;
        if (x2 != 0.0) {
            erfc = x2 == Double.POSITIVE_INFINITY ? 0.0 : (x2 >= 0.0 ? 1.0 - Stat.incompleteGamma(0.5, x2 * x2) : 1.0 + Stat.incompleteGamma(0.5, x2 * x2));
        }
        return erfc;
    }

    public static double erlangBload(double blockingProbability, double totalResources) {
        ErlangBfunct eBfunc = new ErlangBfunct();
        eBfunc.blockingProbability = blockingProbability;
        eBfunc.totalResources = totalResources;
        double lowerBound = 0.0;
        double upperBound = 20.0;
        double tolerance = 1.0E-6;
        RealRoot realR = new RealRoot();
        realR.setTolerance(tolerance);
        realR.noLowerBoundExtension();
        realR.supressLimitReachedMessage();
        double root2 = realR.bisect(eBfunc, lowerBound, upperBound);
        return root2;
    }

    public static double erlangBload(double blockingProbability, int totalResources) {
        return Stat.erlangBload(blockingProbability, (double)totalResources);
    }

    public static double erlangBload(double blockingProbability, long totalResources) {
        return Stat.erlangBload(blockingProbability, (double)totalResources);
    }

    public static double erlangBprobability(double totalTraffic, double totalResources) {
        if (totalTraffic < 0.0) {
            throw new IllegalArgumentException("Total traffic, " + totalTraffic + ", must be greater than or equal to zero");
        }
        if (totalResources < 0.0) {
            throw new IllegalArgumentException("Total resources, " + totalResources + ", must be greater than or equal to zero");
        }
        double prob = 0.0;
        if (totalResources == 0.0) {
            prob = 1.0;
        } else if (totalTraffic == 0.0) {
            prob = 0.0;
        } else if (Fmath.isInteger(totalResources)) {
            double iCount = 1.0;
            prob = 1.0;
            double hold = 0.0;
            while (iCount <= totalResources) {
                hold = prob * totalTraffic;
                prob = hold / (iCount + hold);
                iCount += 1.0;
            }
        } else {
            prob = Stat.erlangBprobabilityNIR(totalTraffic, totalResources);
        }
        return prob;
    }

    public static double erlangBprobability(double totalTraffic, int totalResources) {
        return Stat.erlangBprobability(totalTraffic, (double)totalResources);
    }

    public static double erlangBprobability(double totalTraffic, long totalResources) {
        return Stat.erlangBprobability(totalTraffic, (double)totalResources);
    }

    public static double erlangBprobabilityNIR(double totalTraffic, double totalResources) {
        double prob = 0.0;
        double lognumer = totalResources * Math.log(totalTraffic) - totalTraffic;
        double oneplustr = 1.0 + totalResources;
        double crigf = Stat.complementaryRegularisedGammaFunction(oneplustr, totalTraffic);
        if (crigf != crigf || crigf == 0.0) {
            int low = (int)Math.floor(totalResources) - 2;
            if (low < 0) {
                low = 0;
            }
            int ni = 6;
            int[] tr = new int[ni];
            double[] trd = new double[ni];
            double[] pp = new double[ni];
            int i = 0;
            while (i < ni) {
                tr[i] = low + i;
                trd[i] = tr[i];
                pp[i] = Stat.erlangBprobability(totalTraffic, tr[i]);
                ++i;
            }
            CubicSpline cs = new CubicSpline(trd, pp);
            prob = cs.interpolate(totalResources);
        } else {
            double logdenom = Math.log(crigf) + Stat.logGammaFunction(oneplustr);
            prob = Math.exp(lognumer - logdenom);
        }
        return prob;
    }

    public static double erlangBprobabilityNonIntRes(double totalTraffic, double totalResources) {
        return Stat.erlangBprobability(totalTraffic, totalResources);
    }

    public static double[] erlangBresources(double blockingProbability, double totalTraffic) {
        double[] ret = new double[8];
        long counter = 1L;
        double lastProb = Double.NaN;
        double prob = Double.NaN;
        boolean test2 = true;
        while (test2) {
            prob = Stat.erlangBprobability(totalTraffic, counter);
            if (prob <= blockingProbability) {
                ret[0] = counter;
                ret[1] = prob;
                ret[2] = Stat.erlangBload(blockingProbability, counter);
                ret[3] = counter - 1L;
                ret[4] = lastProb;
                ret[5] = Stat.erlangBload(blockingProbability, counter - 1L);
                ret[6] = blockingProbability;
                ret[7] = totalTraffic;
                test2 = false;
                continue;
            }
            lastProb = prob;
            if (++counter != Integer.MAX_VALUE) continue;
            System.out.println("Method erlangBresources: no solution found below 9223372036854775807resources");
            int i = 0;
            while (i < 8) {
                ret[i] = Double.NaN;
                ++i;
            }
            test2 = false;
        }
        return ret;
    }

    public static double erlangCDF(double lambda, double kay, double upperLimit) {
        if (kay - (double)Math.round(kay) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaCDF(0.0, 1.0 / lambda, kay, upperLimit);
    }

    public static double erlangCDF(double lambda, int kay, double upperLimit) {
        return Stat.gammaCDF(0.0, 1.0 / lambda, kay, upperLimit);
    }

    public static double erlangCDF(double lambda, long kay, double upperLimit) {
        return Stat.gammaCDF(0.0, 1.0 / lambda, kay, upperLimit);
    }

    public static double erlangCload(double nonZeroDelayProbability, double totalResources) {
        ErlangCfunct eCfunc = new ErlangCfunct();
        eCfunc.nonZeroDelayProbability = nonZeroDelayProbability;
        eCfunc.totalResources = totalResources;
        double lowerBound = 0.0;
        double upperBound = 10.0;
        double tolerance = 1.0E-6;
        RealRoot realR = new RealRoot();
        realR.setTolerance(tolerance);
        realR.supressLimitReachedMessage();
        realR.noLowerBoundExtension();
        double root2 = realR.bisect(eCfunc, lowerBound, upperBound);
        return root2;
    }

    public static double erlangCload(double nonZeroDelayProbability, int totalResources) {
        return Stat.erlangCload(nonZeroDelayProbability, (double)totalResources);
    }

    public static double erlangCload(double nonZeroDelayProbability, long totalResources) {
        return Stat.erlangCload(nonZeroDelayProbability, (double)totalResources);
    }

    public static double erlangCprobability(double totalTraffic, double totalResources) {
        double prob = 0.0;
        if (totalTraffic > 0.0) {
            double probB = Stat.erlangBprobability(totalTraffic, totalResources);
            prob = 1.0 + (1.0 / probB - 1.0) * (totalResources - totalTraffic) / totalResources;
            prob = 1.0 / prob;
        }
        return prob;
    }

    public static double erlangCprobability(double totalTraffic, int totalResources) {
        return Stat.erlangCprobability(totalTraffic, (double)totalResources);
    }

    public static double erlangCprobability(double totalTraffic, long totalResources) {
        return Stat.erlangCprobability(totalTraffic, (double)totalResources);
    }

    public static double[] erlangCresources(double nonZeroDelayProbability, double totalTraffic) {
        double[] ret = new double[8];
        long counter = 1L;
        double lastProb = Double.NaN;
        double prob = Double.NaN;
        boolean test2 = true;
        while (test2) {
            prob = Stat.erlangCprobability(totalTraffic, counter);
            if (prob <= nonZeroDelayProbability) {
                ret[0] = counter;
                ret[1] = prob;
                ret[2] = Stat.erlangCload(nonZeroDelayProbability, counter);
                ret[3] = counter - 1L;
                ret[4] = lastProb;
                ret[5] = Stat.erlangCload(nonZeroDelayProbability, counter - 1L);
                ret[6] = nonZeroDelayProbability;
                ret[7] = totalTraffic;
                test2 = false;
                continue;
            }
            lastProb = prob;
            if (++counter != Integer.MAX_VALUE) continue;
            System.out.println("Method erlangCresources: no solution found below 9223372036854775807resources");
            int i = 0;
            while (i < 8) {
                ret[i] = Double.NaN;
                ++i;
            }
            test2 = false;
        }
        return ret;
    }

    public static double erlangMean(double lambda, double kay) {
        if (kay - (double)Math.round(kay) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        if (kay < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return kay / lambda;
    }

    public static double erlangMean(double lambda, int kay) {
        if (kay < 1) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return (double)kay / lambda;
    }

    public static double erlangMean(double lambda, long kay) {
        if (kay < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return (double)kay / lambda;
    }

    public static double erlangMode(double lambda, double kay) {
        if (kay < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        if (kay - (double)Math.round(kay) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        double mode = Double.NaN;
        if (kay >= 1.0) {
            mode = (kay - 1.0) / lambda;
        }
        return mode;
    }

    public static double erlangMode(double lambda, int kay) {
        if (kay < 1) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        double mode = Double.NaN;
        if (kay >= 1) {
            mode = ((double)kay - 1.0) / lambda;
        }
        return mode;
    }

    public static double erlangMode(double lambda, long kay) {
        if (kay < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        double mode = Double.NaN;
        if (kay >= 1L) {
            mode = ((double)kay - 1.0) / lambda;
        }
        return mode;
    }

    public static double erlangMprobability(double totalTraffic, double totalResources, double em) {
        double prob = 0.0;
        if (totalTraffic > 0.0) {
            double numer = totalResources * Math.log(em) - Fmath.logFactorial(em);
            double denom = 1.0;
            double lastTerm = 1.0;
            int i = 1;
            while ((double)i <= totalResources) {
                lastTerm = lastTerm * totalTraffic / (double)i;
                denom += lastTerm;
                ++i;
            }
            denom = Math.log(denom);
            prob = numer - denom;
            prob = Math.exp(prob);
        }
        return prob;
    }

    public static double erlangMprobability(double totalTraffic, int totalResources, int em) {
        return Stat.erlangMprobability(totalTraffic, (double)totalResources, (double)em);
    }

    public static double erlangMprobability(double totalTraffic, long totalResources, long em) {
        return Stat.erlangMprobability(totalTraffic, (double)totalResources, (double)em);
    }

    public static double erlangPDF(double lambda, double kay, double x2) {
        if (kay - (double)Math.round(kay) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaPDF(0.0, 1.0 / lambda, kay, x2);
    }

    public static double erlangPDF(double lambda, int kay, double x2) {
        return Stat.gammaPDF(0.0, 1.0 / lambda, kay, x2);
    }

    public static double erlangPDF(double lambda, long kay, double x2) {
        return Stat.gammaPDF(0.0, 1.0 / lambda, kay, x2);
    }

    public static double[] erlangRand(double lambda, double kay, int n) {
        if (kay < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        if (kay - (double)Math.round(kay) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaRand(0.0, 1.0 / lambda, kay, n);
    }

    public static double[] erlangRand(double lambda, double kay, int n, long seed) {
        if (kay < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        if (kay - (double)Math.round(kay) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaRand(0.0, 1.0 / lambda, kay, n, seed);
    }

    public static double[] erlangRand(double lambda, int kay, int n) {
        if (kay < 1) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / lambda, kay, n);
    }

    public static double[] erlangRand(double lambda, int kay, int n, long seed) {
        if (kay < 1) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / lambda, kay, n, seed);
    }

    public static double[] erlangRand(double lambda, long kay, int n) {
        if (kay < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / lambda, kay, n);
    }

    public static double[] erlangRand(double lambda, long kay, int n, long seed) {
        if (kay < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / lambda, kay, n, seed);
    }

    public static double erlangStandardDeviation(double lambda, double kay) {
        return Stat.erlangStandDev(lambda, kay);
    }

    public static double erlangStandardDeviation(double lambda, int kay) {
        return Stat.erlangStandDev(lambda, kay);
    }

    public static double erlangStandardDeviation(double lambda, long kay) {
        return Stat.erlangStandDev(lambda, kay);
    }

    public static double erlangStandDev(double lambda, double kay) {
        if (kay < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        if (kay - (double)Math.round(kay) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Math.sqrt(kay) / lambda;
    }

    public static double erlangStandDev(double lambda, int kay) {
        if (kay < 1) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return Math.sqrt(kay) / lambda;
    }

    public static double erlangStandDev(double lambda, long kay) {
        if (kay < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + kay + "must be equal to or greater than one");
        }
        return Math.sqrt(kay) / lambda;
    }

    public static BigDecimal excessCurtosis(BigDecimal[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static BigDecimal excessCurtosis(BigInteger[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double excessCurtosis(double[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static float excessCurtosis(float[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double excessCurtosis(int[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double excessCurtosis(long[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static BigDecimal excessKurtosis(BigDecimal[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static BigDecimal excessKurtosis(BigInteger[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double excessKurtosis(double[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static float excessKurtosis(float[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double excessKurtosis(int[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double excessKurtosis(long[] aa) {
        return Stat.kurtosisExcess(aa);
    }

    public static double exponential(double mu, double sigma, double x2) {
        double arg = (x2 - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = Math.exp(-arg) / sigma;
        }
        return y;
    }

    public static double exponentialCDF(double mu, double sigma, double upperlimit) {
        double arg = (upperlimit - mu) / sigma;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-arg);
        }
        return y;
    }

    public static double exponentialCDF(double mu, double sigma, double lowerlimit, double upperlimit) {
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = -Math.exp(-arg1);
        }
        if (arg2 >= 0.0) {
            term2 = -Math.exp(-arg2);
        }
        return term2 - term1;
    }

    public static double exponentialInverseCDF(double mu, double sigma, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? mu : (prob == 1.0 ? Double.POSITIVE_INFINITY : mu - sigma * Math.log(1.0 - prob));
        return icdf;
    }

    public static double exponentialMean(double mu, double sigma) {
        return mu + sigma;
    }

    public static double exponentialMedian(double mu, double sigma) {
        return mu + sigma * Math.log(2.0);
    }

    public static double exponentialMode(double mu) {
        return mu;
    }

    public static double[] exponentialOrderStatisticMedians(double mu, double sigma, int n) {
        double[] eosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            eosm[i] = Stat.inverseExponentialCDF(mu, sigma, uosm[i]);
            ++i;
        }
        return eosm;
    }

    public static double exponentialPDF(double mu, double sigma, double x2) {
        double arg = (x2 - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = Math.exp(-arg) / sigma;
        }
        return y;
    }

    public static double exponentialProb(double mu, double sigma, double upperlimit) {
        double arg = (upperlimit - mu) / sigma;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-arg);
        }
        return y;
    }

    public static double exponentialProb(double mu, double sigma, double lowerlimit, double upperlimit) {
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = -Math.exp(-arg1);
        }
        if (arg2 >= 0.0) {
            term2 = -Math.exp(-arg2);
        }
        return term2 - term1;
    }

    public static double[] exponentialRand(double mu, double sigma, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = mu - Math.log(1.0 - rr.nextDouble()) * sigma;
            ++i;
        }
        return ran;
    }

    public static double[] exponentialRand(double mu, double sigma, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = mu - Math.log(1.0 - rr.nextDouble()) * sigma;
            ++i;
        }
        return ran;
    }

    public static double exponentialStandardDeviation(double sigma) {
        return sigma;
    }

    public static double exponentialStandDev(double sigma) {
        return sigma;
    }

    public static BigDecimal factorial(BigDecimal n) {
        BigDecimal one;
        if (n.compareTo(BigDecimal.ZERO) == -1 || !Fmath.isInteger(n)) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigDecimal f2 = one = BigDecimal.ONE;
        BigDecimal iCount = new BigDecimal(2.0);
        while (iCount.compareTo(n) != 1) {
            f2 = f2.multiply(iCount);
            iCount = iCount.add(one);
        }
        one = null;
        iCount = null;
        return f2;
    }

    public static BigInteger factorial(BigInteger n) {
        BigInteger one;
        if (n.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigInteger f2 = one = BigInteger.ONE;
        BigInteger iCount = new BigInteger("2");
        while (iCount.compareTo(n) != 1) {
            f2 = f2.multiply(iCount);
            iCount = iCount.add(one);
        }
        one = null;
        iCount = null;
        return f2;
    }

    public static double factorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 1.0;
        double iCount = 2.0;
        while (iCount <= n) {
            f2 *= iCount;
            iCount += 1.0;
        }
        return f2;
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 12) {
            throw new IllegalArgumentException("n must less than 13 to avoid integer overflow\nTry long or double argument");
        }
        int f2 = 1;
        int i = 2;
        while (i <= n) {
            f2 *= i;
            ++i;
        }
        return f2;
    }

    public static long factorial(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 20L) {
            throw new IllegalArgumentException("n must less than 21 to avoid long integer overflow\nTry double argument");
        }
        long f2 = 1L;
        long iCount = 2L;
        while (iCount <= n) {
            f2 *= iCount;
            ++iCount;
        }
        return f2;
    }

    public static double fCompCDF(double var1, int df1, double var2, int df2) {
        if (df1 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + df1 + ", must be greater than zero");
        }
        if (df2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + df2 + ", must be greater than zero");
        }
        if (var1 < 0.0) {
            throw new IllegalArgumentException("the variance, var1" + var1 + ", must be greater than or equal to zero");
        }
        if (var1 <= 0.0) {
            throw new IllegalArgumentException("the variance, var2" + var2 + ", must be greater than zero");
        }
        double fValue = var1 / var2;
        double ddf1 = df1;
        double ddf2 = df2;
        double x2 = ddf2 / (ddf2 + ddf1 * fValue);
        return Stat.regularisedBetaFunction((double)df2 / 2.0, (double)df1 / 2.0, x2);
    }

    public static double fCompCDF(double fValue, int df1, int df2) {
        if (df1 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + df1 + ", must be greater than zero");
        }
        if (df2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + df2 + ", must be greater than zero");
        }
        if (fValue < 0.0) {
            throw new IllegalArgumentException("the F-ratio, " + fValue + ", must be greater than or equal to zero");
        }
        double ddf1 = df1;
        double ddf2 = df2;
        double x2 = ddf2 / (ddf2 + ddf1 * fValue);
        return Stat.regularisedBetaFunction((double)df2 / 2.0, (double)df1 / 2.0, x2);
    }

    public static double fDistributionInverseCDF(int nu1, int nu2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        if (prob == 0.0) {
            icdf = 0.0;
        } else if (prob == 1.0) {
            icdf = Double.POSITIVE_INFINITY;
        } else {
            FdistribtionFunct fdistn = new FdistribtionFunct();
            fdistn.nu1 = nu1;
            fdistn.nu2 = nu2;
            double tolerance = 1.0E-12;
            double lowerBound = 0.0;
            double upperBound = 2.0;
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            fdistn.cfd = prob;
            icdf = realR.bisect(fdistn, lowerBound, upperBound);
        }
        return icdf;
    }

    public static double[] fDistributionOrderStatisticMedians(int nu1, int nu2, int n) {
        double[] gosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            gosm[i] = Stat.fDistributionInverseCDF(nu1, nu2, uosm[i]);
            ++i;
        }
        Stat st = new Stat(gosm);
        double mean = st.mean();
        double sigma = st.standardDeviation();
        gosm = Stat.scale(gosm, mean, sigma);
        return gosm;
    }

    public static void fitOneOrSeveralDistributions(double[] array) {
        Regression.fitOneOrSeveralDistributions(array);
    }

    public static double[] fRand(int nu1, int nu2, int n) {
        if (nu1 <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu1], " + nu1 + ", must be greater than zero");
        }
        if (nu2 <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu2], " + nu2 + ", must be greater than zero");
        }
        PsRandom psr = new PsRandom();
        return psr.fArray(nu1, nu2, n);
    }

    public static double[] fRand(int nu1, int nu2, int n, long seed) {
        if (nu1 <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu1], " + nu1 + ", must be greater than zero");
        }
        if (nu2 <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu2], " + nu2 + ", must be greater than zero");
        }
        PsRandom psr = new PsRandom(seed);
        return psr.fArray(nu1, nu2, n);
    }

    public static double frechet(double mu, double sigma, double gamma2, double x2) {
        double arg = (x2 - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = gamma2 / sigma * Math.pow(arg, -gamma2 - 1.0) * Math.exp(-Math.pow(arg, -gamma2));
        }
        return y;
    }

    public static double frechetCDF(double mu, double sigma, double gamma2, double lowerlimit, double upperlimit) {
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = Math.exp(-Math.pow(arg1, -gamma2));
        }
        if (arg2 >= 0.0) {
            term2 = Math.exp(-Math.pow(arg2, -gamma2));
        }
        return term2 - term1;
    }

    public static double frechetInverseCDF(double gamma2, double prob) {
        return Stat.frechetInverseCDF(0.0, 1.0, gamma2, prob);
    }

    public static double frechetInverseCDF(double sigma, double gamma2, double prob) {
        return Stat.frechetInverseCDF(0.0, sigma, gamma2, prob);
    }

    public static double frechetInverseCDF(double mu, double sigma, double gamma2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? Double.NEGATIVE_INFINITY : (prob == 1.0 ? Double.POSITIVE_INFINITY : mu + sigma * Math.pow(Math.log(1.0 / prob), -1.0 / gamma2));
        return icdf;
    }

    public static double frechetMean(double mu, double sigma, double gamma2) {
        double y = Double.NaN;
        if (gamma2 > 1.0) {
            y = mu + sigma * Stat.gamma(1.0 - 1.0 / gamma2);
        }
        return y;
    }

    public static double frechetMode(double mu, double sigma, double gamma2) {
        return mu + sigma * Math.pow(gamma2 / (1.0 + gamma2), 1.0 / gamma2);
    }

    public static double[] frechetOrderStatisticMedians(double mu, double sigma, double gamma2, int n) {
        double[] fosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            fosm[i] = Stat.frechetInverseCDF(mu, sigma, gamma2, uosm[i]);
            ++i;
        }
        return fosm;
    }

    public static double[] frechetOrderStatisticMedians(double sigma, double gamma2, int n) {
        return Stat.frechetOrderStatisticMedians(0.0, sigma, gamma2, n);
    }

    public static double[] frechetOrderStatisticMedians(double gamma2, int n) {
        return Stat.frechetOrderStatisticMedians(0.0, 1.0, gamma2, n);
    }

    public static double frechetPDF(double mu, double sigma, double gamma2, double x2) {
        double arg = (x2 - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = gamma2 / sigma * Math.pow(arg, -gamma2 - 1.0) * Math.exp(-Math.pow(arg, -gamma2));
        }
        return y;
    }

    public static double frechetProb(double mu, double sigma, double gamma2, double upperlimit) {
        double arg = (upperlimit - mu) / sigma;
        double y = 0.0;
        if (arg > 0.0) {
            y = Math.exp(-Math.pow(arg, -gamma2));
        }
        return y;
    }

    public static double frechetProb(double mu, double sigma, double gamma2, double lowerlimit, double upperlimit) {
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = Math.exp(-Math.pow(arg1, -gamma2));
        }
        if (arg2 >= 0.0) {
            term2 = Math.exp(-Math.pow(arg2, -gamma2));
        }
        return term2 - term1;
    }

    public static double[] frechetRand(double mu, double sigma, double gamma2, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = Math.pow(1.0 / Math.log(1.0 / rr.nextDouble()), 1.0 / gamma2) * sigma + mu;
            ++i;
        }
        return ran;
    }

    public static double[] frechetRand(double mu, double sigma, double gamma2, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = Math.pow(1.0 / Math.log(1.0 / rr.nextDouble()), 1.0 / gamma2) * sigma + mu;
            ++i;
        }
        return ran;
    }

    public static double frechetStandardDeviation(double sigma, double gamma2) {
        return Stat.frechetStandDev(sigma, gamma2);
    }

    public static double frechetStandDev(double sigma, double gamma2) {
        double y = Double.NaN;
        if (gamma2 > 2.0) {
            y = Stat.gamma(1.0 - 2.0 / gamma2) - Fmath.square(Stat.gamma(1.0 - 1.0 / gamma2));
            y = sigma * Math.sqrt(y);
        }
        return y;
    }

    private static double fTestBisect(double fProb, double fTestLow, double fTestHigh, int df1, int df2, int endTest) {
        double funcLow = fProb - Stat.fTestProb(fTestLow, df1, df2);
        double funcHigh = fProb - Stat.fTestProb(fTestHigh, df1, df2);
        double fTestMid = 0.0;
        double funcMid = 0.0;
        int nExtensions = 0;
        int nIter = 1000;
        double check2 = fProb * 1.0E-6;
        boolean test0 = true;
        boolean test1 = true;
        while (test0) {
            if (funcLow * funcHigh > 0.0) {
                if (endTest < 0) {
                    if (++nExtensions > 100) {
                        System.out.println("Class: Stats\nMethod: fTestBisect\nProbability higher than range covered\nF-test value is less than " + fTestLow);
                        System.out.println("This value was returned");
                        fTestMid = fTestLow;
                        test0 = false;
                        test1 = false;
                    }
                    funcLow = fProb - Stat.fTestProb(fTestLow /= 10.0, df1, df2);
                } else {
                    if (++nExtensions > 100) {
                        System.out.println("Class: Stats\nMethod: fTestBisect\nProbability lower than range covered\nF-test value is greater than " + fTestHigh);
                        System.out.println("This value was returned");
                        fTestMid = fTestHigh;
                        test0 = false;
                        test1 = false;
                    }
                    funcHigh = fProb - Stat.fTestProb(fTestHigh *= 10.0, df1, df2);
                }
            } else {
                test0 = false;
            }
            int i = 0;
            while (test1) {
                fTestMid = (fTestLow + fTestHigh) / 2.0;
                funcMid = fProb - Stat.fTestProb(fTestMid, df1, df2);
                if (Math.abs(funcMid) < check2) {
                    test1 = false;
                    continue;
                }
                if (++i > nIter) {
                    System.out.println("Class: Stats\nMethod: fTestBisect\nmaximum number of iterations exceeded\ncurrent value of F-test value returned");
                    test1 = false;
                }
                if (funcMid * funcHigh > 0.0) {
                    funcHigh = funcMid;
                    fTestHigh = fTestMid;
                    continue;
                }
                funcLow = funcMid;
                fTestLow = fTestMid;
            }
        }
        return fTestMid;
    }

    public static double fTestProb(double var1, int df1, double var2, int df2) {
        if (df1 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + df1 + ", must be greater than zero");
        }
        if (df2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + df2 + ", must be greater than zero");
        }
        if (var1 < 0.0) {
            throw new IllegalArgumentException("the variance, var1" + var1 + ", must be greater than or equal to zero");
        }
        if (var1 <= 0.0) {
            throw new IllegalArgumentException("the variance, var2" + var2 + ", must be greater than zero");
        }
        double fValue = var1 / var2;
        double ddf1 = df1;
        double ddf2 = df2;
        double x2 = ddf2 / (ddf2 + ddf1 * fValue);
        return Stat.regularisedBetaFunction((double)df2 / 2.0, (double)df1 / 2.0, x2);
    }

    public static double fTestProb(double fValue, int df1, int df2) {
        if (df1 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + df1 + ", must be greater than zero");
        }
        if (df2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + df2 + ", must be greater than zero");
        }
        if (fValue < 0.0) {
            throw new IllegalArgumentException("the F-ratio, " + fValue + ", must be greater than or equal to zero");
        }
        double ddf1 = df1;
        double ddf2 = df2;
        double x2 = ddf2 / (ddf2 + ddf1 * fValue);
        return Stat.regularisedBetaFunction((double)df2 / 2.0, (double)df1 / 2.0, x2);
    }

    public static double fTestValueGivenFprob(double fProb, int df1, int df2) {
        int fTestsNum = 100;
        double[] fTestValues = new double[fTestsNum];
        fTestValues[0] = 1.0E-4;
        fTestValues[fTestsNum - 1] = 10000.0;
        double diff2 = (Fmath.log10(fTestValues[fTestsNum - 1]) - Fmath.log10(fTestValues[0])) / (double)(fTestsNum - 1);
        int i = 1;
        while (i < fTestsNum - 1) {
            fTestValues[i] = Math.pow(10.0, Fmath.log10(fTestValues[i - 1]) + diff2);
            ++i;
        }
        double[] fTestProb = new double[fTestsNum];
        int i2 = 0;
        while (i2 < fTestsNum) {
            fTestProb[i2] = Stat.fTestProb(fTestValues[i2], df1, df2);
            ++i2;
        }
        double fTest0 = 0.0;
        double fTest1 = 0.0;
        double fTest2 = 0.0;
        boolean test0 = true;
        boolean test1 = true;
        int i3 = 0;
        int endTest = 0;
        while (test0) {
            if (fProb == fTestProb[i3]) {
                fTest0 = fTestValues[i3];
                test0 = false;
                test1 = false;
                continue;
            }
            if (fProb > fTestProb[i3]) {
                test0 = false;
                if (i3 > 0) {
                    fTest1 = fTestValues[i3 - 1];
                    fTest2 = fTestValues[i3];
                    endTest = -1;
                    continue;
                }
                fTest1 = fTestValues[i3] / 10.0;
                fTest2 = fTestValues[i3];
                continue;
            }
            if (++i3 <= fTestsNum - 1) continue;
            test0 = false;
            fTest1 = fTestValues[i3 - 1];
            fTest2 = 10.0 * fTestValues[i3 - 1];
            endTest = 1;
        }
        if (test1) {
            fTest0 = Stat.fTestBisect(fProb, fTest1, fTest2, df1, df2, endTest);
        }
        return fTest0;
    }

    public static double gamma(double x2) {
        double xcopy = x2;
        double first = x2 + lgfGamma + 0.5;
        double second = lgfCoeff[0];
        double fg = 0.0;
        if (x2 >= 0.0) {
            first = Math.pow(first, x2 + 0.5) * Math.exp(-first);
            int i = 1;
            while (i <= lgfN) {
                second += lgfCoeff[i] / (xcopy += 1.0);
                ++i;
            }
            fg = first * Math.sqrt(Math.PI * 2) * second / x2;
        } else {
            fg = -Math.PI / (x2 * Stat.gamma(-x2) * Math.sin(Math.PI * x2));
        }
        return fg;
    }

    public static double gammaCDF(double gamma2, double upperLimit) {
        if (upperLimit < 0.0) {
            throw new IllegalArgumentException("The upper limit, " + upperLimit + "must be equal to or greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        return Stat.regularisedGammaFunction(gamma2, upperLimit);
    }

    public static double gammaCDF(double mu, double beta2, double gamma2, double upperLimit) {
        if (upperLimit < mu) {
            throw new IllegalArgumentException("The upper limit, " + upperLimit + "must be equal to or greater than the location parameter, " + mu);
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + beta2 + "must be greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        double xx = (upperLimit - mu) / beta2;
        return Stat.regularisedGammaFunction(gamma2, xx);
    }

    public static double gammaFunction(double x2) {
        double xcopy = x2;
        double first = x2 + lgfGamma + 0.5;
        double second = lgfCoeff[0];
        double fg = 0.0;
        if (x2 >= 0.0) {
            first = Math.pow(first, x2 + 0.5) * Math.exp(-first);
            int i = 1;
            while (i <= lgfN) {
                second += lgfCoeff[i] / (xcopy += 1.0);
                ++i;
            }
            fg = first * Math.sqrt(Math.PI * 2) * second / x2;
        } else {
            fg = -Math.PI / (x2 * Stat.gamma(-x2) * Math.sin(Math.PI * x2));
        }
        return fg;
    }

    public static double[] gammaFunctionMinimum() {
        double[] ret = new double[]{0.8856031944108839, 1.4616321399961483};
        return ret;
    }

    public static double gammaMean(double mu, double beta2, double gamma2) {
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + beta2 + "must be greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        return gamma2 * beta2 - mu;
    }

    public static double gammaMode(double mu, double beta2, double gamma2) {
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + beta2 + "must be greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        double mode = Double.NaN;
        if (gamma2 >= 1.0) {
            mode = (gamma2 - 1.0) * beta2 - mu;
        }
        return mode;
    }

    public static double gammaPDF(double gamma2, double x2) {
        if (x2 < 0.0) {
            throw new IllegalArgumentException("The variable, x, " + x2 + "must be equal to or greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        return Math.pow(x2, gamma2 - 1.0) * Math.exp(-x2) / Stat.gammaFunction(gamma2);
    }

    public static double gammaPDF(double mu, double beta2, double gamma2, double x2) {
        if (x2 < mu) {
            throw new IllegalArgumentException("The variable, x, " + x2 + "must be equal to or greater than the location parameter, " + mu);
        }
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + beta2 + "must be greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        double xx = (x2 - mu) / beta2;
        return Math.pow(xx, gamma2 - 1.0) * Math.exp(-xx) / (beta2 * Stat.gammaFunction(gamma2));
    }

    public static double[] gammaRand(double mu, double beta2, double gamma2, int n) {
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + beta2 + "must be greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        PsRandom psr = new PsRandom();
        return psr.gammaArray(mu, beta2, gamma2, n);
    }

    public static double[] gammaRand(double mu, double beta2, double gamma2, int n, long seed) {
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + beta2 + "must be greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        PsRandom psr = new PsRandom(seed);
        return psr.gammaArray(mu, beta2, gamma2, n);
    }

    public static double gammaStandardDeviation(double mu, double beta2, double gamma2) {
        return Stat.gammaStandDev(mu, beta2, gamma2);
    }

    public static double gammaStandDev(double mu, double beta2, double gamma2) {
        if (beta2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + beta2 + "must be greater than zero");
        }
        if (gamma2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma2 + "must be greater than zero");
        }
        return Math.sqrt(gamma2) * beta2;
    }

    public static double gaussian(double mean, double sd, double x2) {
        return Math.exp(-Fmath.square((x2 - mean) / sd) / 2.0) / (sd * Math.sqrt(Math.PI * 2));
    }

    public static double gaussianCDF(double mean, double sd, double upperlimit) {
        return Stat.normalCDF(mean, sd, upperlimit);
    }

    public static double gaussianCDF(double mean, double sd, double lowerlimit, double upperlimit) {
        return Stat.normalCDF(mean, sd, upperlimit) - Stat.normalCDF(mean, sd, lowerlimit);
    }

    public static double gaussianInverseCDF(double prob) {
        return Stat.gaussianInverseCDF(0.0, 1.0, prob);
    }

    public static double gaussianInverseCDF(double mean, double sd, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        if (prob == 0.0) {
            icdf = Double.NEGATIVE_INFINITY;
        } else if (prob == 1.0) {
            icdf = Double.POSITIVE_INFINITY;
        } else {
            GaussianFunct gauss = new GaussianFunct();
            gauss.mean = mean;
            gauss.sd = sd;
            double tolerance = 1.0E-12;
            double lowerBound = mean - 10.0 * sd;
            double upperBound = mean + 10.0 * sd;
            RealRoot realR = new RealRoot();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            gauss.cfd = prob;
            icdf = realR.bisect(gauss, lowerBound, upperBound);
        }
        return icdf;
    }

    public static double[] gaussianOrderStatisticMedians(double mean, double sigma, int n) {
        double[] gosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            gosm[i] = Stat.inverseGaussianCDF(mean, sigma, uosm[i]);
            ++i;
        }
        gosm = Stat.scale(gosm, mean, sigma);
        return gosm;
    }

    public static double[] gaussianOrderStatisticMedians(int n) {
        return Stat.gaussianOrderStatisticMedians(0.0, 1.0, n);
    }

    public static double gaussianPDF(double mean, double sd, double x2) {
        return Math.exp(-Fmath.square((x2 - mean) / sd) / 2.0) / (sd * Math.sqrt(Math.PI * 2));
    }

    public static double gaussianProb(double mean, double sd, double upperlimit) {
        return Stat.normalCDF(mean, sd, upperlimit);
    }

    public static double gaussianProb(double mean, double sd, double lowerlimit, double upperlimit) {
        return Stat.normalCDF(mean, sd, upperlimit) - Stat.normalCDF(mean, sd, lowerlimit);
    }

    public static double[] gaussianRand(double mean, double sd, int n) {
        return Stat.normalRand(mean, sd, n);
    }

    public static double[] gaussianRand(double mean, double sd, int n, long seed) {
        return Stat.normalRand(mean, sd, n, seed);
    }

    public static double generalisedEntropyOneNat(double[] p, double q, double r) {
        return Stat.generalizedEntropyOneNat(p, q, r);
    }

    public static double generalisedMean(BigDecimal[] aa, BigDecimal m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalisedMean(dd, m.doubleValue());
    }

    public static double generalisedMean(BigDecimal[] aa, BigDecimal[] ww, BigDecimal m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am1 = new ArrayMaths(aa);
        double[] dd = am1.getArray_as_double();
        ArrayMaths am2 = new ArrayMaths(ww);
        double[] wd = am2.getArray_as_double();
        return Stat.generalisedMean(dd, wd, m.doubleValue());
    }

    public static double generalisedMean(BigDecimal[] aa, BigDecimal[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am1 = new ArrayMaths(aa);
        double[] dd = am1.getArray_as_double();
        ArrayMaths am2 = new ArrayMaths(ww);
        double[] wd = am2.getArray_as_double();
        return Stat.generalisedMean(dd, wd, m);
    }

    public static double generalisedMean(BigDecimal[] aa, double m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalisedMean(dd, m);
    }

    public static double generalisedMean(BigInteger[] aa, BigInteger m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalisedMean(dd, m.doubleValue());
    }

    public static double generalisedMean(BigInteger[] aa, BigInteger[] ww, BigInteger m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am1 = new ArrayMaths(aa);
        double[] dd = am1.getArray_as_double();
        ArrayMaths am2 = new ArrayMaths(ww);
        double[] wd = am2.getArray_as_double();
        return Stat.generalisedMean(dd, wd, m.doubleValue());
    }

    public static double generalisedMean(BigInteger[] aa, BigInteger[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am1 = new ArrayMaths(aa);
        double[] dd = am1.getArray_as_double();
        ArrayMaths am2 = new ArrayMaths(ww);
        double[] wd = am2.getArray_as_double();
        return Stat.generalisedMean(dd, wd, m);
    }

    public static double generalisedMean(BigInteger[] aa, double m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalisedMean(dd, m);
    }

    public static Complex generalisedMean(Complex[] aa, Complex m) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        if (m.equals(Complex.zero())) {
            int i = 0;
            while (i < n) {
                sum2 = sum2.plus(Complex.log(aa[i]));
                ++i;
            }
            return Complex.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(Complex.pow(aa[i], m));
            ++i;
        }
        return Complex.pow(sum2.over(n), Complex.plusOne().over(m));
    }

    public static Complex generalisedMean(Complex[] aa, Complex[] ww, Complex m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        Complex sum2 = Complex.zero();
        Complex sumw = Complex.zero();
        Complex[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumw = sumw.plus(weight[i]);
            ++i;
        }
        if (m.equals(Complex.zero())) {
            i = 0;
            while (i < n) {
                sum2 = sum2.plus(Complex.log(weight[i].times(aa[i])).over(sumw));
                ++i;
            }
            return Complex.exp(sum2);
        }
        i = 0;
        while (i < n) {
            sum2 = sum2.plus(weight[i].times(Complex.pow(aa[i], m)));
            ++i;
        }
        return Complex.pow(sum2.over(sumw), Complex.plusOne().over(m));
    }

    public static Complex generalisedMean(Complex[] aa, Complex[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        Complex sum2 = Complex.zero();
        Complex sumw = Complex.zero();
        Complex[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumw = sumw.plus(weight[i]);
            ++i;
        }
        if (m == 0.0) {
            i = 0;
            while (i < n) {
                sum2 = sum2.plus(Complex.log(weight[i].times(aa[i])).over(sumw));
                ++i;
            }
            return Complex.exp(sum2);
        }
        i = 0;
        while (i < n) {
            sum2 = sum2.plus(weight[i].times(Complex.pow(aa[i], m)));
            ++i;
        }
        return Complex.pow(sum2.over(sumw), 1.0 / m);
    }

    public static Complex generalisedMean(Complex[] aa, double m) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        if (m == 0.0) {
            int i = 0;
            while (i < n) {
                sum2 = sum2.plus(Complex.log(aa[i]));
                ++i;
            }
            return Complex.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(Complex.pow(aa[i], m));
            ++i;
        }
        return Complex.pow(sum2.over(n), 1.0 / m);
    }

    public static double generalisedMean(double[] aa, double m) {
        int n = aa.length;
        double sum2 = 0.0;
        if (m == 0.0) {
            int i = 0;
            while (i < n) {
                sum2 += Math.log(aa[i]);
                ++i;
            }
            return Math.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 += Math.pow(aa[i], m);
            ++i;
        }
        return Math.pow(sum2 / (double)n, 1.0 / m);
    }

    public static double generalisedMean(double[] aa, double[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double sum2 = 0.0;
        double sumw = 0.0;
        double[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumw += weight[i];
            ++i;
        }
        if (m == 0.0) {
            i = 0;
            while (i < n) {
                sum2 += Math.log(aa[i] * weight[i] / sumw);
                ++i;
            }
            return Math.exp(sum2);
        }
        i = 0;
        while (i < n) {
            sum2 += weight[i] * Math.pow(aa[i], m);
            ++i;
        }
        return Math.pow(sum2 / sumw, 1.0 / m);
    }

    public static float generalisedMean(float[] aa, float m) {
        int n = aa.length;
        float sum2 = 0.0f;
        if (m == 0.0f) {
            int i = 0;
            while (i < n) {
                sum2 += (float)Math.log(aa[i]);
                ++i;
            }
            return (float)Math.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 = (float)((double)sum2 + Math.pow(aa[i], m));
            ++i;
        }
        return (float)Math.pow(sum2 / (float)n, 1.0f / m);
    }

    public static float generalisedMean(float[] aa, float[] ww, float m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        float sum2 = 0.0f;
        float sumw = 0.0f;
        float[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumw += weight[i];
            ++i;
        }
        if (m == 0.0f) {
            i = 0;
            while (i < n) {
                sum2 += (float)Math.log(aa[i]);
                ++i;
            }
            return (float)Math.exp(sum2);
        }
        i = 0;
        while (i < n) {
            sum2 = (float)((double)sum2 + Math.pow(aa[i], m));
            ++i;
        }
        return (float)Math.pow(sum2 / sumw, 1.0f / m);
    }

    public static double generalizedEntropyOneNat(double[] p, double q, double r) {
        ArrayMaths am = new ArrayMaths(p);
        double max2 = am.getMaximum_as_double();
        if (max2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max2);
        }
        double min2 = am.getMinimum_as_double();
        if (min2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min2);
        }
        double total = am.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
        }
        if (r == 0.0) {
            return Stat.renyiEntropyNat(p, q);
        }
        if (r == 1.0) {
            return Stat.tsallisEntropyNat(p, q);
        }
        if (q == 1.0) {
            ArrayMaths am1;
            double[] tsen = new double[10];
            double[] tsqq = new double[10];
            double qq = 0.995;
            int i = 0;
            while (i < 5) {
                am1 = am.pow(qq);
                tsen[i] = (1.0 - Math.pow(am1.getSum_as_double(), r)) / (r * (qq - 1.0));
                tsqq[i] = qq;
                qq += 0.001;
                ++i;
            }
            qq = 1.001;
            i = 5;
            while (i < 10) {
                am1 = am.pow(qq);
                tsen[i] = (1.0 - Math.pow(am1.getSum_as_double(), r)) / (r * (qq - 1.0));
                tsqq[i] = qq;
                qq += 0.001;
                ++i;
            }
            Regression reg = new Regression(tsqq, tsen);
            reg.polynomial(2);
            double[] param2 = reg.getCoeff();
            return param2[0] + param2[1] + param2[2];
        }
        am = am.pow(q);
        return (1.0 - Math.pow(am.getSum_as_double(), r)) / (r * (q - 1.0));
    }

    public static double generalizedMean(BigDecimal[] aa, BigDecimal m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalizedMean(dd, m.doubleValue());
    }

    public static double generalizedMean(BigDecimal[] aa, double m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalizedMean(dd, m);
    }

    public static double generalizedMean(BigInteger[] aa, BigInteger m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalizedMean(dd, m.doubleValue());
    }

    public static double generalizedMean(BigInteger[] aa, double m) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] dd = am.getArray_as_double();
        return Stat.generalizedMean(dd, m);
    }

    public static Complex generalizedMean(Complex[] aa, Complex m) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        if (m.equals(Complex.zero())) {
            int i = 0;
            while (i < n) {
                sum2 = sum2.plus(Complex.log(aa[i]));
                ++i;
            }
            return Complex.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(Complex.pow(aa[i], m));
            ++i;
        }
        return Complex.pow(sum2.over(n), Complex.plusOne().over(m));
    }

    public static Complex generalizedMean(Complex[] aa, double m) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        if (m == 0.0) {
            int i = 0;
            while (i < n) {
                sum2 = sum2.plus(Complex.log(aa[i]));
                ++i;
            }
            return Complex.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(Complex.pow(aa[i], m));
            ++i;
        }
        return Complex.pow(sum2.over(n), 1.0 / m);
    }

    public static double generalizedMean(double[] aa, double m) {
        int n = aa.length;
        double sum2 = 0.0;
        if (m == 0.0) {
            int i = 0;
            while (i < n) {
                sum2 += Math.log(aa[i]);
                ++i;
            }
            return Math.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 += Math.pow(aa[i], m);
            ++i;
        }
        return Math.pow(sum2 / (double)n, 1.0 / m);
    }

    public static float generalizedMean(float[] aa, float m) {
        int n = aa.length;
        float sum2 = 0.0f;
        if (m == 0.0f) {
            int i = 0;
            while (i < n) {
                sum2 += (float)Math.log(aa[i]);
                ++i;
            }
            return (float)Math.exp(sum2);
        }
        int i = 0;
        while (i < n) {
            sum2 = (float)((double)sum2 + Math.pow(aa[i], m));
            ++i;
        }
        return (float)Math.pow(sum2 / (float)n, 1.0f / m);
    }

    public static double geometricMean(BigDecimal[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += Math.log(aa[i].doubleValue());
            ++i;
        }
        return Math.exp(sum2 / (double)n);
    }

    public static double geometricMean(BigDecimal[] aa, BigDecimal[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths weighting = new ArrayMaths(Stat.invertAndSquare(ww));
        double[] weight = weighting.array();
        double sumW = 0.0;
        int i = 0;
        while (i < n) {
            sumW += weight[i];
            ++i;
        }
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < n) {
            sum2 += Math.log(aa[i2].doubleValue()) * weight[i2];
            ++i2;
        }
        return Math.exp(sum2 / sumW);
    }

    public static double geometricMean(BigInteger[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += Math.log(aa[i].doubleValue());
            ++i;
        }
        return Math.exp(sum2 / (double)n);
    }

    public static double geometricMean(BigInteger[] aa, BigInteger[] ww) {
        ArrayMaths amaa = new ArrayMaths(aa);
        ArrayMaths amww = new ArrayMaths(ww);
        return Stat.geometricMean(amaa.array_as_BigDecimal(), amww.array_as_BigDecimal());
    }

    public static Complex geometricMean(Complex[] aa) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(Complex.log(aa[i]));
            ++i;
        }
        return Complex.exp(sum2.over(n));
    }

    public static Complex geometricMean(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        Complex sumW = Complex.zero();
        Complex[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumW = sumW.plus(weight[i]);
            ++i;
        }
        Complex sum2 = Complex.zero();
        int i2 = 0;
        while (i2 < n) {
            sum2 = sum2.plus(Complex.log(aa[i2]).times(weight[i2]));
            ++i2;
        }
        return Complex.exp(sum2.over(sumW));
    }

    public static double geometricMean(double[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += Math.log(aa[i]);
            ++i;
        }
        return Math.exp(sum2 / (double)n);
    }

    public static double geometricMean(double[] aa, double[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double sumW = 0.0;
        double[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumW += weight[i];
            ++i;
        }
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < n) {
            sum2 += Math.log(aa[i2]) * weight[i2];
            ++i2;
        }
        return Math.exp(sum2 / sumW);
    }

    public static float geometricMean(float[] aa) {
        int n = aa.length;
        float sum2 = 0.0f;
        int i = 0;
        while (i < n) {
            sum2 += (float)Math.log(aa[i]);
            ++i;
        }
        return (float)Math.exp(sum2 / (float)n);
    }

    public static float geometricMean(float[] aa, float[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        float sumW = 0.0f;
        float[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumW += weight[i];
            ++i;
        }
        float sum2 = 0.0f;
        int i2 = 0;
        while (i2 < n) {
            sum2 += (float)Math.log(aa[i2]) * weight[i2];
            ++i2;
        }
        return (float)Math.exp(sum2 / sumW);
    }

    public static int getCFmaxIter() {
        return cfMaxIter;
    }

    public static double getCFtolerance() {
        return cfTol;
    }

    public static double getFpmin() {
        return 1.0E-300;
    }

    public static int getIncGammaMaxIter() {
        return igfiter;
    }

    public static double getIncGammaTol() {
        return igfeps;
    }

    public static double[] getLanczosCoeff() {
        int n = Stat.getLanczosN() + 1;
        double[] coef = new double[n];
        int i = 0;
        while (i < n) {
            coef[i] = lgfCoeff[i];
            ++i;
        }
        return coef;
    }

    public static double getLanczosGamma() {
        return lgfGamma;
    }

    public static int getLanczosN() {
        return lgfN;
    }

    public static double gumbelMax(double mu, double sigma, double x2) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = -(x2 - mu) / sigma;
        return 1.0 / sigma * Math.exp(arg) * Math.exp(-Math.exp(arg));
    }

    public static double gumbelMaxCDF(double mu, double sigma, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = -(upperlimit - mu) / sigma;
        return 1.0 - Math.exp(-Math.exp(arg));
    }

    public static double gumbelMaxCDF(double mu, double sigma, double lowerlimit, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = -Math.exp(-Math.exp(arg1));
        double term2 = -Math.exp(-Math.exp(arg2));
        return term2 - term1;
    }

    public static double gumbelMaxInverseCDF(double mu, double sigma, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? Double.NEGATIVE_INFINITY : (prob == 1.0 ? Double.POSITIVE_INFINITY : mu - sigma * Math.log(Math.log(1.0 / prob)));
        return icdf;
    }

    public static double gumbelMaxMean(double mu, double sigma) {
        return mu + sigma * 0.5772156649015627;
    }

    public static double gumbelMaxMedian(double mu, double sigma) {
        return mu - sigma * Math.log(Math.log(2.0));
    }

    public static double gumbelMaxMode(double mu, double sigma) {
        return mu;
    }

    public static double[] gumbelMaxOrderStatisticMedians(double mu, double sigma, int n) {
        double[] gmosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            gmosm[i] = Stat.gumbelMaxInverseCDF(mu, sigma, uosm[i]);
            ++i;
        }
        return gmosm;
    }

    public static double gumbelMaxPDF(double mu, double sigma, double x2) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = -(x2 - mu) / sigma;
        return 1.0 / sigma * Math.exp(arg) * Math.exp(-Math.exp(arg));
    }

    public static double gumbelMaxProb(double mu, double sigma, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = -(upperlimit - mu) / sigma;
        return 1.0 - Math.exp(-Math.exp(arg));
    }

    public static double gumbelMaxProb(double mu, double sigma, double lowerlimit, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = -Math.exp(-Math.exp(arg1));
        double term2 = -Math.exp(-Math.exp(arg2));
        return term2 - term1;
    }

    public static double[] gumbelMaxRand(double mu, double sigma, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = mu - Math.log(Math.log(1.0 / (1.0 - rr.nextDouble()))) * sigma;
            ++i;
        }
        return ran;
    }

    public static double[] gumbelMaxRand(double mu, double sigma, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = mu - Math.log(Math.log(1.0 / (1.0 - rr.nextDouble()))) * sigma;
            ++i;
        }
        return ran;
    }

    public static double gumbelMaxStandardDeviation(double sigma) {
        return sigma * Math.PI / Math.sqrt(6.0);
    }

    public static double gumbelMaxStandDev(double sigma) {
        return sigma * Math.PI / Math.sqrt(6.0);
    }

    public static double gumbelMin(double mu, double sigma, double x2) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = (x2 - mu) / sigma;
        return 1.0 / sigma * Math.exp(arg) * Math.exp(-Math.exp(arg));
    }

    public static double gumbelMinCDF(double mu, double sigma, double lowerlimit, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg1 = -(lowerlimit - mu) / sigma;
        double arg2 = -(upperlimit - mu) / sigma;
        double term1 = Math.exp(-Math.exp(arg1));
        double term2 = Math.exp(-Math.exp(arg2));
        return term2 - term1;
    }

    public static double gumbelMinInverseCDF(double mu, double sigma, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? Double.NEGATIVE_INFINITY : (prob == 1.0 ? Double.POSITIVE_INFINITY : mu + sigma * Math.log(Math.log(1.0 / (1.0 - prob))));
        return icdf;
    }

    public static double gumbelMinMean(double mu, double sigma) {
        return mu - sigma * 0.5772156649015627;
    }

    public static double gumbelMinMedian(double mu, double sigma) {
        return mu + sigma * Math.log(Math.log(2.0));
    }

    public static double gumbelMinMode(double mu, double sigma) {
        return mu;
    }

    public static double[] gumbelMinOrderStatisticMedians(double mu, double sigma, int n) {
        double[] gmosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            gmosm[i] = Stat.gumbelMinInverseCDF(mu, sigma, uosm[i]);
            ++i;
        }
        return gmosm;
    }

    public static double gumbelMinPDF(double mu, double sigma, double x2) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = (x2 - mu) / sigma;
        return 1.0 / sigma * Math.exp(arg) * Math.exp(-Math.exp(arg));
    }

    public static double gumbelMinProb(double mu, double sigma, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = -(upperlimit - mu) / sigma;
        return Math.exp(-Math.exp(arg));
    }

    public static double gumbelMinProb(double mu, double sigma, double lowerlimit, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg1 = -(lowerlimit - mu) / sigma;
        double arg2 = -(upperlimit - mu) / sigma;
        double term1 = Math.exp(-Math.exp(arg1));
        double term2 = Math.exp(-Math.exp(arg2));
        return term2 - term1;
    }

    public static double gumbelMinProbCDF(double mu, double sigma, double upperlimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double arg = -(upperlimit - mu) / sigma;
        return Math.exp(-Math.exp(arg));
    }

    public static double[] gumbelMinRand(double mu, double sigma, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = Math.log(Math.log(1.0 / (1.0 - rr.nextDouble()))) * sigma + mu;
            ++i;
        }
        return ran;
    }

    public static double[] gumbelMinRand(double mu, double sigma, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = Math.log(Math.log(1.0 / (1.0 - rr.nextDouble()))) * sigma + mu;
            ++i;
        }
        return ran;
    }

    public static double gumbelMinStandardDeviation(double sigma) {
        return sigma * Math.PI / Math.sqrt(6.0);
    }

    public static double gumbelMinStandDev(double sigma) {
        return sigma * Math.PI / Math.sqrt(6.0);
    }

    public static BigDecimal harmonicMean(BigDecimal[] aa) {
        int n = aa.length;
        BigDecimal sum2 = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            sum2 = sum2.add(BigDecimal.ONE.divide(aa[i], 4));
            ++i;
        }
        sum2 = new BigDecimal((double)n).divide(sum2, 4);
        return sum2;
    }

    public static BigDecimal harmonicMean(BigDecimal[] aa, BigDecimal[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        BigDecimal sum2 = BigDecimal.ZERO;
        BigDecimal sumW = BigDecimal.ZERO;
        BigDecimal[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumW = sumW.add(weight[i]);
            ++i;
        }
        i = 0;
        while (i < n) {
            sum2 = sum2.add(weight[i].divide(aa[i], 4));
            ++i;
        }
        sum2 = sumW.divide(sum2, 4);
        sumW = null;
        weight = null;
        return sum2;
    }

    public static BigDecimal harmonicMean(BigInteger[] aa) {
        int n = aa.length;
        ArrayMaths am = new ArrayMaths(aa);
        BigDecimal[] bd = am.getArray_as_BigDecimal();
        BigDecimal sum2 = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            sum2 = sum2.add(BigDecimal.ONE.divide(bd[i], 4));
            ++i;
        }
        sum2 = new BigDecimal((double)n).divide(sum2, 4);
        bd = null;
        return sum2;
    }

    public static BigDecimal harmonicMean(BigInteger[] aa, BigInteger[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        ArrayMaths wm = new ArrayMaths(ww);
        return Stat.harmonicMean(am.getArray_as_BigDecimal(), wm.getArray_as_BigDecimal());
    }

    public static Complex harmonicMean(Complex[] aa) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(Complex.plusOne().over(aa[i]));
            ++i;
        }
        sum2 = new Complex(n).over(sum2);
        return sum2;
    }

    public static Complex harmonicMean(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        Complex sum2 = Complex.zero();
        Complex sumW = Complex.zero();
        Complex[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumW = sumW.plus(weight[i]);
            ++i;
        }
        i = 0;
        while (i < n) {
            sum2 = sum2.plus(weight[i].over(aa[i]));
            ++i;
        }
        return sumW.over(sum2);
    }

    public static double harmonicMean(double[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += 1.0 / aa[i];
            ++i;
        }
        return (double)n / sum2;
    }

    public static double harmonicMean(double[] aa, double[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double sum2 = 0.0;
        double sumW = 0.0;
        double[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumW += weight[i];
            ++i;
        }
        i = 0;
        while (i < n) {
            sum2 += weight[i] / aa[i];
            ++i;
        }
        return sumW / sum2;
    }

    public static float harmonicMean(float[] aa) {
        int n = aa.length;
        float sum2 = 0.0f;
        int i = 0;
        while (i < n) {
            sum2 += 1.0f / aa[i];
            ++i;
        }
        return (float)n / sum2;
    }

    public static float harmonicMean(float[] aa, float[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        float sum2 = 0.0f;
        float sumW = 0.0f;
        float[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumW += weight[i];
            ++i;
        }
        i = 0;
        while (i < n) {
            sum2 += weight[i] / aa[i];
            ++i;
        }
        return sumW / sum2;
    }

    public static double[][] histogramBins(double[] data2, double binWidth) {
        double dmin = Fmath.minimum(data2);
        double dmax = Fmath.maximum(data2);
        double span2 = dmax - dmin;
        double binZero = dmin;
        int nBins = (int)Math.ceil(span2 / binWidth);
        double histoSpan = (double)nBins * binWidth;
        double rem = histoSpan - span2;
        if (rem >= 0.0) {
            binZero -= rem / 2.0;
        } else if (Math.abs(rem) / span2 > histTol) {
            boolean testBw = true;
            double incr = histTol / (double)nBins;
            int iTest = 0;
            while (testBw) {
                histoSpan = (double)nBins * (binWidth += incr);
                rem = histoSpan - span2;
                if (rem < 0.0) {
                    if (++iTest <= 1000) continue;
                    testBw = false;
                    System.out.println("histogram method could not encompass all data within histogram\nContact Michael thomas Flanagan");
                    continue;
                }
                testBw = false;
            }
        }
        return Stat.histogramBins(data2, binWidth, binZero);
    }

    public static double[][] histogramBins(double[] data2, double binWidth, double binZero) {
        double dmax = Fmath.maximum(data2);
        int nBins = (int)Math.ceil((dmax - binZero) / binWidth);
        if (binZero + (double)nBins * binWidth > dmax) {
            ++nBins;
        }
        int nPoints = data2.length;
        int[] dataCheck = new int[nPoints];
        int i = 0;
        while (i < nPoints) {
            dataCheck[i] = 0;
            ++i;
        }
        double[] binWall = new double[nBins + 1];
        binWall[0] = binZero;
        int i2 = 1;
        while (i2 <= nBins) {
            binWall[i2] = binWall[i2 - 1] + binWidth;
            ++i2;
        }
        double[][] binFreq = new double[2][nBins];
        int i3 = 0;
        while (i3 < nBins) {
            binFreq[0][i3] = (binWall[i3] + binWall[i3 + 1]) / 2.0;
            binFreq[1][i3] = 0.0;
            ++i3;
        }
        boolean test2 = true;
        int i4 = 0;
        while (i4 < nPoints) {
            test2 = true;
            int j = 0;
            while (test2) {
                if (j == nBins - 1) {
                    if (data2[i4] >= binWall[j] && data2[i4] <= binWall[j + 1] * (1.0 + histTol)) {
                        double[] dArray = binFreq[1];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0;
                        dataCheck[i4] = 1;
                        test2 = false;
                    }
                } else if (data2[i4] >= binWall[j] && data2[i4] < binWall[j + 1]) {
                    double[] dArray = binFreq[1];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                    dataCheck[i4] = 1;
                    test2 = false;
                }
                if (!test2) continue;
                if (j == nBins - 1) {
                    test2 = false;
                    continue;
                }
                ++j;
            }
            ++i4;
        }
        int nMissed = 0;
        int i5 = 0;
        while (i5 < nPoints) {
            if (dataCheck[i5] == 0) {
                ++nMissed;
                System.out.println("p " + i5 + " " + data2[i5] + " " + binWall[0] + " " + binWall[nBins]);
            }
            ++i5;
        }
        if (nMissed > 0) {
            System.out.println(String.valueOf(nMissed) + " data points, outside histogram limits, excluded in Stat.histogramBins");
        }
        return binFreq;
    }

    public static double[][] histogramBins(double[] data2, double binWidth, double binZero, double binUpper) {
        int n = 0;
        int m = data2.length;
        int i = 0;
        while (i < m) {
            if (data2[i] <= binUpper) {
                ++n;
            }
            ++i;
        }
        if (n != m) {
            double[] newData = new double[n];
            int j = 0;
            int i2 = 0;
            while (i2 < m) {
                if (data2[i2] <= binUpper) {
                    newData[j] = data2[i2];
                    ++j;
                }
                ++i2;
            }
            System.out.println(String.valueOf(m - n) + " data points, above histogram upper limit, excluded in Stat.histogramBins");
            return Stat.histogramBins(newData, binWidth, binZero);
        }
        return Stat.histogramBins(data2, binWidth, binZero);
    }

    public static double[][] histogramBinsPlot(double[] data2, double binWidth) {
        String xLegend = null;
        return Stat.histogramBinsPlot(data2, binWidth, xLegend);
    }

    public static double[][] histogramBinsPlot(double[] data2, double binWidth, double binZero) {
        String xLegend = null;
        return Stat.histogramBinsPlot(data2, binWidth, binZero, xLegend);
    }

    public static double[][] histogramBinsPlot(double[] data2, double binWidth, double binZero, double binUpper) {
        String xLegend = null;
        return Stat.histogramBinsPlot(data2, binWidth, binZero, binUpper, xLegend);
    }

    public static double[][] histogramBinsPlot(double[] data2, double binWidth, double binZero, double binUpper, String xLegend) {
        int n = 0;
        int m = data2.length;
        int i = 0;
        while (i < m) {
            if (data2[i] <= binUpper) {
                ++n;
            }
            ++i;
        }
        if (n != m) {
            double[] newData = new double[n];
            int j = 0;
            int i2 = 0;
            while (i2 < m) {
                if (data2[i2] <= binUpper) {
                    newData[j] = data2[i2];
                    ++j;
                }
                ++i2;
            }
            System.out.println(String.valueOf(m - n) + " data points, above histogram upper limit, excluded in Stat.histogramBins");
            return Stat.histogramBinsPlot(newData, binWidth, binZero, xLegend);
        }
        return Stat.histogramBinsPlot(data2, binWidth, binZero, xLegend);
    }

    public static double[][] histogramBinsPlot(double[] data2, double binWidth, double binZero, String xLegend) {
        double[][] results = Stat.histogramBins(data2, binWidth, binZero);
        int nBins = results[0].length;
        int nPoints = nBins * 3 + 1;
        double[][] cdata = Plot.data(1, nPoints);
        cdata[0][0] = binZero;
        cdata[1][0] = 0.0;
        int k = 1;
        int i = 0;
        while (i < nBins) {
            cdata[0][k] = cdata[0][k - 1];
            cdata[1][k] = results[1][i];
            cdata[0][++k] = cdata[0][k - 1] + binWidth;
            cdata[1][k] = results[1][i];
            cdata[0][++k] = cdata[0][k - 1];
            cdata[1][k] = 0.0;
            ++k;
            ++i;
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle("Histogram:  Bin Width = " + binWidth);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setYaxisLegend("Frequency");
        if (xLegend != null) {
            pg.setXaxisLegend(xLegend);
        }
        pg.plot();
        return results;
    }

    public static double[][] histogramBinsPlot(double[] data2, double binWidth, String xLegend) {
        double dmin = Fmath.minimum(data2);
        double dmax = Fmath.maximum(data2);
        double span2 = dmax - dmin;
        int nBins = (int)Math.ceil(span2 / binWidth);
        double rem = (double)nBins * binWidth - span2;
        double binZero = dmin - rem / 2.0;
        return Stat.histogramBinsPlot(data2, binWidth, binZero, xLegend);
    }

    public static void igSupress() {
        igSupress = true;
    }

    public static double incompleteBeta(double z, double w, double x2) {
        return Stat.regularisedBetaFunction(z, w, x2);
    }

    public static double incompleteGamma(double a, double x2) {
        return Stat.regularisedGammaFunction(a, x2);
    }

    public static double incompleteGammaComplementary(double a, double x2) {
        return Stat.complementaryRegularisedGammaFunction(a, x2);
    }

    public static double incompleteGammaFract(double a, double x2) {
        if (a < 0.0 || x2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        if (x2 < a + 1.0) {
            throw new IllegalArgumentException("\nx < a+1   Use Series Representation");
        }
        double igf = 0.0;
        if (x2 != 0.0) {
            int i = 0;
            double ii = 0.0;
            boolean check2 = true;
            double loggamma = Stat.logGamma(a);
            double numer = 0.0;
            double incr = 0.0;
            double denom = x2 - a + 1.0;
            double first = 1.0 / denom;
            double term = 9.999999999999999E299;
            double prod = first;
            while (check2) {
                if (Math.abs(first = (numer = -(ii = (double)(++i)) * (ii - a)) * first + (denom += 2.0)) < 1.0E-300) {
                    first = 1.0E-300;
                }
                if (Math.abs(term = denom + numer / term) < 1.0E-300) {
                    term = 1.0E-300;
                }
                first = 1.0 / first;
                incr = first * term;
                prod *= incr;
                if (Math.abs(incr - 1.0) < igfeps) {
                    check2 = false;
                }
                if (i < igfiter) continue;
                check2 = false;
                igf = Double.NaN;
                if (igSupress) continue;
                System.out.println("\nMaximum number of iterations were exceeded in Stat.incompleteGammaFract().");
                System.out.println("NaN returned.\nIncrement - 1 = " + String.valueOf(incr - 1.0) + ".");
                System.out.println("Tolerance =  " + String.valueOf(igfeps));
            }
            igf = 1.0 - Math.exp(-x2 + a * Math.log(x2) - loggamma) * prod;
        }
        return igf;
    }

    public static double incompleteGammaSer(double a, double x2) {
        if (a < 0.0 || x2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        if (x2 >= a + 1.0) {
            throw new IllegalArgumentException("\nx >= a+1   use Continued Fraction Representation");
        }
        double igf = 0.0;
        if (x2 != 0.0) {
            double sum2;
            int i = 0;
            boolean check2 = true;
            double acopy = a;
            double incr = sum2 = 1.0 / a;
            double loggamma = Stat.logGamma(a);
            while (check2) {
                ++i;
                sum2 += (incr *= x2 / (a += 1.0));
                if (Math.abs(incr) < Math.abs(sum2) * igfeps) {
                    igf = sum2 * Math.exp(-x2 + acopy * Math.log(x2) - loggamma);
                    check2 = false;
                }
                if (i < igfiter) continue;
                check2 = false;
                igf = Double.NaN;
                if (igSupress) continue;
                System.out.println("\nMaximum number of iterations were exceeded in Stat.incompleteGammaSer().");
                System.out.println("NaN returned.\nIncrement = " + String.valueOf(incr) + ".");
                System.out.println("Sum = " + String.valueOf(sum2) + ".\nTolerance =  " + String.valueOf(igfeps));
            }
        }
        return igf;
    }

    public static BigDecimal interQuartileMean(BigDecimal[] aa) {
        int n = aa.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        ArrayMaths am = new ArrayMaths(aa);
        ArrayMaths as = am.sort();
        BigDecimal[] bb = as.getArray_as_BigDecimal();
        BigDecimal sum2 = BigDecimal.ZERO;
        int i = n / 4;
        while (i < 3 * n / 4) {
            sum2 = sum2.add(bb[i]);
            ++i;
        }
        sum2 = sum2.multiply(new BigDecimal(2.0 / (double)n));
        bb = null;
        return sum2;
    }

    public static BigDecimal interQuartileMean(BigInteger[] aa) {
        int n = aa.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        ArrayMaths am = new ArrayMaths(aa);
        ArrayMaths as = am.sort();
        BigDecimal[] bb = as.getArray_as_BigDecimal();
        BigDecimal sum2 = BigDecimal.ZERO;
        int i = n / 4;
        while (i < 3 * n / 4) {
            sum2 = sum2.add(bb[i]);
            ++i;
        }
        sum2 = sum2.multiply(new BigDecimal(2.0 / (double)n));
        bb = null;
        return sum2;
    }

    public static double interQuartileMean(double[] aa) {
        int n = aa.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        double[] bb = Fmath.selectionSort(aa);
        double sum2 = 0.0;
        int i = n / 4;
        while (i < 3 * n / 4) {
            sum2 += bb[i];
            ++i;
        }
        return 2.0 * sum2 / (double)n;
    }

    public static float interQuartileMean(float[] aa) {
        int n = aa.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        float[] bb = Fmath.selectionSort(aa);
        float sum2 = 0.0f;
        int i = n / 4;
        while (i < 3 * n / 4) {
            sum2 += bb[i];
            ++i;
        }
        return 2.0f * sum2 / (float)n;
    }

    public static double inverseChiSquareCDF(int nu, double prob) {
        return Stat.chiSquareInverseCDF(nu, prob);
    }

    public static double inverseExponentialCDF(double mu, double sigma, double prob) {
        return Stat.exponentialInverseCDF(mu, sigma, prob);
    }

    public static double[] inverseGammaFunction(double gamma2) {
        double gammaMinimum = 0.8856031944108839;
        double iGammaMinimum = 1.4616321399961483;
        if (gamma2 < gammaMinimum) {
            throw new IllegalArgumentException("Entered argument (gamma) value, " + gamma2 + ", must be equal to or greater than 0.8856031944108839 - this method does not handle the negative domain");
        }
        double[] igamma = new double[2];
        double tolerance = 1.0E-12;
        if (gamma2 == 1.0) {
            igamma[0] = 1.0;
        } else if (gamma2 == gammaMinimum) {
            igamma[0] = iGammaMinimum;
        } else {
            InverseGammaFunct gif1 = new InverseGammaFunct();
            gif1.gamma = gamma2;
            double lowerBound1 = 0.0;
            double upperBound1 = iGammaMinimum;
            RealRoot realR1 = new RealRoot();
            realR1.noBoundsExtensions();
            realR1.setTolerance(tolerance);
            realR1.resetNaNexceptionToTrue();
            realR1.supressLimitReachedMessage();
            realR1.supressNaNmessage();
            igamma[0] = realR1.bisect(gif1, lowerBound1, upperBound1);
        }
        if (gamma2 == 1.0) {
            igamma[1] = 2.0;
        } else if (gamma2 == gammaMinimum) {
            igamma[1] = iGammaMinimum;
        } else {
            InverseGammaFunct gif2 = new InverseGammaFunct();
            gif2.gamma = gamma2;
            double lowerBound2 = iGammaMinimum;
            double upperBound2 = 2.0;
            double ii = 2.0;
            double gii = Stat.gamma(ii);
            if (gamma2 > gii) {
                boolean test2 = true;
                while (test2) {
                    gii = Stat.gamma(ii += 1.0);
                    if (!(gamma2 <= gii)) continue;
                    upperBound2 = ii;
                    lowerBound2 = ii - 1.0;
                    test2 = false;
                }
            }
            RealRoot realR2 = new RealRoot();
            realR2.noBoundsExtensions();
            realR2.setTolerance(tolerance);
            realR2.resetNaNexceptionToTrue();
            realR2.supressLimitReachedMessage();
            realR2.supressNaNmessage();
            igamma[1] = realR2.bisect(gif2, lowerBound2, upperBound2);
        }
        return igamma;
    }

    public static double inverseGaussianCDF(double prob) {
        return Stat.gaussianInverseCDF(0.0, 1.0, prob);
    }

    public static double inverseGaussianCDF(double mean, double sd, double prob) {
        return Stat.gaussianInverseCDF(mean, sd, prob);
    }

    public static double inverseNormalCDF(double prob) {
        return Stat.gaussianInverseCDF(0.0, 1.0, prob);
    }

    public static double inverseNormalCDF(double mean, double sd, double prob) {
        return Stat.gaussianInverseCDF(mean, sd, prob);
    }

    public static double inverseParetoCDF(double alpha, double beta2, double prob) {
        return Stat.paretoInverseCDF(alpha, beta2, prob);
    }

    public static double inverseRayleighCDF(double beta2, double prob) {
        return Stat.rayleighInverseCDF(beta2, prob);
    }

    public static double inverseWeibullCDF(double gamma2, double prob) {
        return Stat.weibullInverseCDF(0.0, 1.0, gamma2, prob);
    }

    public static double inverseWeibullCDF(double sigma, double gamma2, double prob) {
        return Stat.weibullInverseCDF(0.0, sigma, gamma2, prob);
    }

    public static double inverseWeibullCDF(double mu, double sigma, double gamma2, double prob) {
        return Stat.weibullInverseCDF(mu, sigma, gamma2, prob);
    }

    private static BigDecimal[] invertAndSquare(BigDecimal[] ww) {
        BigDecimal[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_BigDecimal();
        }
        return weight;
    }

    private static Complex[] invertAndSquare(Complex[] ww) {
        Complex[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_Complex();
        }
        return weight;
    }

    private static double[] invertAndSquare(double[] ww) {
        double[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array();
        }
        return weight;
    }

    private static float[] invertAndSquare(float[] ww) {
        float[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_float();
        }
        return weight;
    }

    public static BigDecimal kurtosis(BigDecimal[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        BigDecimal sum2 = BigDecimal.ZERO;
        BigDecimal mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            BigDecimal hold = aa[i].subtract(mean);
            sum2 = sum2.add(hold.multiply(hold.multiply(hold.multiply(hold))));
            ++i;
        }
        sum2 = sum2.divide(new BigDecimal(denom), 4);
        mean = Stat.variance(aa);
        sum2 = mean.doubleValue() == 0.0 ? new BigDecimal(2.0 / denom) : sum2.divide(mean.multiply(mean), 4);
        mean = null;
        return sum2;
    }

    public static BigDecimal kurtosis(BigInteger[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        BigDecimal[] bd = am.array_as_BigDecimal();
        return Stat.kurtosis(bd);
    }

    public static double kurtosis(double[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Math.pow(aa[i] - mean, 4.0);
            ++i;
        }
        double ret = (sum2 /= denom) / Fmath.square(Stat.variance(aa));
        if (Fmath.isNaN(ret)) {
            ret = 2.0 / denom;
        }
        return ret;
    }

    public static float kurtosis(float[] aa) {
        int n = aa.length;
        float denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        float sum2 = 0.0f;
        float mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 = (float)((double)sum2 + Math.pow(aa[i] - mean, 4.0));
            ++i;
        }
        float ret = (sum2 /= denom) / Fmath.square(Stat.variance(aa));
        if (Fmath.isNaN(ret)) {
            ret = 2.0f / denom;
        }
        return ret;
    }

    public static double kurtosis(int[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Math.pow((double)aa[i] - mean, 4.0);
            ++i;
        }
        double ret = (sum2 /= denom) / Fmath.square(Stat.variance(aa));
        if (Fmath.isNaN(ret)) {
            ret = 2.0 / denom;
        }
        return ret;
    }

    public static double kurtosis(long[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Math.pow((double)aa[i] - mean, 4.0);
            ++i;
        }
        double ret = (sum2 /= denom) / Fmath.square(Stat.variance(aa));
        if (Fmath.isNaN(ret)) {
            ret = 2.0 / denom;
        }
        return ret;
    }

    public static BigDecimal kurtosisExcess(BigDecimal[] aa) {
        return Stat.kurtosis(aa).subtract(new BigDecimal("3.0"));
    }

    public static BigDecimal kurtosisExcess(BigInteger[] aa) {
        return Stat.kurtosis(aa).subtract(new BigDecimal("3.0"));
    }

    public static double kurtosisExcess(double[] aa) {
        return Stat.kurtosis(aa) - 3.0;
    }

    public static float kurtosisExcess(float[] aa) {
        return Stat.kurtosis(aa) - 3.0f;
    }

    public static double kurtosisExcess(int[] aa) {
        return Stat.kurtosis(aa) - 3.0;
    }

    public static double kurtosisExcess(long[] aa) {
        return Stat.kurtosis(aa) - 3.0;
    }

    public static double linearCorrCoeff(double rCoeff, int nu) {
        return Stat.corrCoeffPDF(rCoeff, nu);
    }

    public static double linearCorrCoeffProb(double rCoeff, int nu) {
        return Stat.corrCoeffProb(rCoeff, nu);
    }

    public static double logFactorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 0.0;
        double iCount = 2.0;
        while (iCount <= n) {
            f2 += Math.log(iCount);
            iCount += 1.0;
        }
        return f2;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\nn, " + n + ", must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 0.0;
        int i = 2;
        while (i <= n) {
            f2 += Math.log(i);
            ++i;
        }
        return f2;
    }

    public static double logFactorial(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("\nn, " + n + ", must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 0.0;
        long iCount = 2L;
        while (iCount <= n) {
            f2 += Math.log(iCount);
            ++iCount;
        }
        return f2;
    }

    public static double logGamma(double x2) {
        double xcopy = x2;
        double fg = 0.0;
        double first = x2 + lgfGamma + 0.5;
        double second = lgfCoeff[0];
        if (x2 >= 0.0) {
            first -= (x2 + 0.5) * Math.log(first);
            int i = 1;
            while (i <= lgfN) {
                second += lgfCoeff[i] / (xcopy += 1.0);
                ++i;
            }
            fg = Math.log(Math.sqrt(Math.PI * 2) * second / x2) - first;
        } else {
            fg = Math.PI / (Stat.gamma(1.0 - x2) * Math.sin(Math.PI * x2));
            if (fg != Double.POSITIVE_INFINITY && fg != Double.NEGATIVE_INFINITY) {
                if (fg < 0.0) {
                    throw new IllegalArgumentException("\nThe gamma function is negative");
                }
                fg = Math.log(fg);
            }
        }
        return fg;
    }

    public static double logGammaFunction(double x2) {
        double xcopy = x2;
        double fg = 0.0;
        double first = x2 + lgfGamma + 0.5;
        double second = lgfCoeff[0];
        if (x2 >= 0.0) {
            first -= (x2 + 0.5) * Math.log(first);
            int i = 1;
            while (i <= lgfN) {
                second += lgfCoeff[i] / (xcopy += 1.0);
                ++i;
            }
            fg = Math.log(Math.sqrt(Math.PI * 2) * second / x2) - first;
        } else {
            fg = Math.PI / (Stat.gamma(1.0 - x2) * Math.sin(Math.PI * x2));
            if (fg != Double.POSITIVE_INFINITY && fg != Double.NEGATIVE_INFINITY) {
                if (fg < 0.0) {
                    throw new IllegalArgumentException("\nThe gamma function is negative");
                }
                fg = Math.log(fg);
            }
        }
        return fg;
    }

    public static double logistic(double mu, double beta2, double x2) {
        return Fmath.square(Fmath.sech((x2 - mu) / (2.0 * beta2))) / (4.0 * beta2);
    }

    public static double logisticCDF(double mu, double beta2, double upperlimit) {
        return 0.5 * (1.0 + Math.tanh((upperlimit - mu) / (2.0 * beta2)));
    }

    public static double logisticCDF(double mu, double beta2, double lowerlimit, double upperlimit) {
        double arg1 = 0.5 * (1.0 + Math.tanh((lowerlimit - mu) / (2.0 * beta2)));
        double arg2 = 0.5 * (1.0 + Math.tanh((upperlimit - mu) / (2.0 * beta2)));
        return arg2 - arg1;
    }

    public static double logisticInverseCDF(double mu, double beta2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? Double.NEGATIVE_INFINITY : (prob == 1.0 ? Double.POSITIVE_INFINITY : mu - beta2 * Math.log(1.0 / prob - 1.0));
        return icdf;
    }

    public static double logisticMean(double mu) {
        return mu;
    }

    public static double logisticMedian(double mu) {
        return mu;
    }

    public static double logisticMode(double mu) {
        return mu;
    }

    public static double[] logisticOrderStatisticMedians(double mu, double beta2, int n) {
        double[] losm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            losm[i] = Stat.logisticInverseCDF(mu, beta2, uosm[i]);
            ++i;
        }
        return losm;
    }

    public static double logisticPDF(double mu, double beta2, double x2) {
        return Fmath.square(Fmath.sech((x2 - mu) / (2.0 * beta2))) / (4.0 * beta2);
    }

    public static double logisticProb(double mu, double beta2, double upperlimit) {
        return 0.5 * (1.0 + Math.tanh((upperlimit - mu) / (2.0 * beta2)));
    }

    public static double logisticProb(double mu, double beta2, double lowerlimit, double upperlimit) {
        double arg1 = 0.5 * (1.0 + Math.tanh((lowerlimit - mu) / (2.0 * beta2)));
        double arg2 = 0.5 * (1.0 + Math.tanh((upperlimit - mu) / (2.0 * beta2)));
        return arg2 - arg1;
    }

    public static double[] logisticRand(double mu, double beta2, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = 2.0 * beta2 * Fmath.atanh(2.0 * rr.nextDouble() - 1.0) + mu;
            ++i;
        }
        return ran;
    }

    public static double[] logisticRand(double mu, double beta2, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = 2.0 * beta2 * Fmath.atanh(2.0 * rr.nextDouble() - 1.0) + mu;
            ++i;
        }
        return ran;
    }

    public static double logisticStandardDeviation(double beta2) {
        return Stat.logisticStandDev(beta2);
    }

    public static double logisticStandDev(double beta2) {
        return Math.sqrt(Fmath.square(Math.PI * beta2) / 3.0);
    }

    public static double logisticTwoParCDF(double mu, double beta2, double upperlimit) {
        return 0.5 * (1.0 + Math.tanh((upperlimit - mu) / (2.0 * beta2)));
    }

    public static double logisticTwoParCDF(double mu, double beta2, double lowerlimit, double upperlimit) {
        double arg1 = 0.5 * (1.0 + Math.tanh((lowerlimit - mu) / (2.0 * beta2)));
        double arg2 = 0.5 * (1.0 + Math.tanh((upperlimit - mu) / (2.0 * beta2)));
        return arg2 - arg1;
    }

    public static double logisticTwoParInverseCDF(double mu, double beta2, double prob) {
        return Stat.logisticInverseCDF(mu, beta2, prob);
    }

    public static double logisticTwoParMean(double mu) {
        return mu;
    }

    public static double logisticTwoParMedian(double mu) {
        return mu;
    }

    public static double logisticTwoParMode(double mu) {
        return mu;
    }

    public static double[] logisticTwoParOrderStatisticMedians(double mu, double beta2, int n) {
        double[] losm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            losm[i] = Stat.logisticInverseCDF(mu, beta2, uosm[i]);
            ++i;
        }
        return losm;
    }

    public static double logisticTwoParPDF(double mu, double beta2, double x2) {
        return Fmath.square(Fmath.sech((x2 - mu) / (2.0 * beta2))) / (4.0 * beta2);
    }

    public static double[] logisticTwoParRand(double mu, double beta2, int n) {
        return Stat.logisticRand(mu, beta2, n);
    }

    public static double[] logisticTwoParRand(double mu, double beta2, int n, long seed) {
        return Stat.logisticRand(mu, beta2, n, seed);
    }

    public static double logisticTwoParStandardDeviation(double beta2) {
        return Math.sqrt(Fmath.square(Math.PI * beta2) / 3.0);
    }

    public static double logNormalCDF(double mu, double sigma, double upperLimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + sigma + ", must be greater than or equal to zero");
        }
        if (upperLimit <= 0.0) {
            return 0.0;
        }
        return 0.5 * (1.0 + Stat.erf((Math.log(upperLimit) - mu) / (sigma * Math.sqrt(2.0))));
    }

    public static double logNormalCDF(double mu, double sigma, double lowerLimit, double upperLimit) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + sigma + ", must be greater than or equal to zero");
        }
        if (upperLimit < lowerLimit) {
            throw new IllegalArgumentException("The upper limit, " + upperLimit + ", must be greater than the " + lowerLimit);
        }
        double arg1 = 0.0;
        double arg2 = 0.0;
        double cdf = 0.0;
        if (lowerLimit != upperLimit) {
            if (upperLimit > 0.0) {
                arg1 = 0.5 * (1.0 + Stat.erf((Math.log(upperLimit) - mu) / (sigma * Math.sqrt(2.0))));
            }
            if (lowerLimit > 0.0) {
                arg2 = 0.5 * (1.0 + Stat.erf((Math.log(lowerLimit) - mu) / (sigma * Math.sqrt(2.0))));
            }
            cdf = arg1 - arg2;
        }
        return cdf;
    }

    public static double logNormalInverseCDF(double mu, double sigma, double prob) {
        double alpha = 0.0;
        double beta2 = sigma;
        double gamma2 = Math.exp(mu);
        return Stat.logNormalInverseCDF(alpha, beta2, gamma2, prob);
    }

    public static double logNormalInverseCDF(double alpha, double beta2, double gamma2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        if (prob == 0.0) {
            icdf = alpha;
        } else if (prob == 1.0) {
            icdf = Double.POSITIVE_INFINITY;
        } else {
            LogNormalThreeParFunct lognorm = new LogNormalThreeParFunct();
            lognorm.alpha = alpha;
            lognorm.beta = beta2;
            lognorm.gamma = gamma2;
            double tolerance = 1.0E-12;
            double lowerBound = alpha;
            double upperBound = Stat.logNormalThreeParMean(alpha, beta2, gamma2) + 5.0 * Stat.logNormalThreeParStandardDeviation(alpha, beta2, gamma2);
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            lognorm.cfd = prob;
            icdf = realR.bisect(lognorm, lowerBound, upperBound);
        }
        return icdf;
    }

    public static double logNormalMean(double mu, double sigma) {
        return Math.exp(mu + sigma * sigma / 2.0);
    }

    public static double logNormalMedian(double mu) {
        return Math.exp(mu);
    }

    public static double logNormalMode(double mu, double sigma) {
        return Math.exp(mu - sigma * sigma);
    }

    public static double[] logNormalOrderStatisticMedians(double alpha, double beta2, double gamma2, int n) {
        double[] lnosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            lnosm[i] = Stat.logNormalThreeParInverseCDF(alpha, beta2, gamma2, uosm[i]);
            ++i;
        }
        lnosm = Stat.scale(lnosm, Stat.logNormalThreeParMean(alpha, beta2, gamma2), Stat.logNormalThreeParStandardDeviation(alpha, beta2, gamma2));
        return lnosm;
    }

    public static double[] logNormalOrderStatisticMedians(double mu, double sigma, int n) {
        double alpha = 0.0;
        double beta2 = sigma;
        double gamma2 = Math.exp(mu);
        return Stat.logNormalOrderStatisticMedians(alpha, beta2, gamma2, n);
    }

    public static double logNormalPDF(double mu, double sigma, double x2) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + sigma + ", must be greater than or equal to zero");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        return Math.exp(-0.5 * Fmath.square((Math.log(x2) - mu) / sigma)) / (x2 * sigma * Math.sqrt(Math.PI * 2));
    }

    public static double[] logNormalRand(double mu, double sigma, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (sigma < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + sigma + ", must be greater than or equal to zero");
        }
        PsRandom psr = new PsRandom();
        return psr.logNormalArray(mu, sigma, n);
    }

    public static double[] logNormalRand(double mu, double sigma, int n, long seed) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (sigma < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + sigma + ", must be greater than or equal to zero");
        }
        PsRandom psr = new PsRandom(seed);
        return psr.logNormalArray(mu, sigma, n);
    }

    public static double logNormalStandardDeviation(double mu, double sigma) {
        return Stat.logNormalStandDev(mu, sigma);
    }

    public static double logNormalStandDev(double mu, double sigma) {
        double sigma2 = sigma * sigma;
        return Math.sqrt((Math.exp(sigma2) - 1.0) * Math.exp(2.0 * mu + sigma2));
    }

    public static double logNormalThreeParCDF(double alpha, double beta2, double gamma2, double upperLimit) {
        if (beta2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + beta2 + ", must be greater than or equal to zero");
        }
        if (upperLimit <= alpha) {
            return 0.0;
        }
        return 0.5 * (1.0 + Stat.erf(Math.log((upperLimit - alpha) / gamma2) / (beta2 * Math.sqrt(2.0))));
    }

    public static double logNormalThreeParCDF(double alpha, double beta2, double gamma2, double lowerLimit, double upperLimit) {
        if (beta2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + beta2 + ", must be greater than or equal to zero");
        }
        if (upperLimit < lowerLimit) {
            throw new IllegalArgumentException("The upper limit, " + upperLimit + ", must be greater than the " + lowerLimit);
        }
        double arg1 = 0.0;
        double arg2 = 0.0;
        double cdf = 0.0;
        if (lowerLimit != upperLimit) {
            if (upperLimit > alpha) {
                arg1 = 0.5 * (1.0 + Stat.erf(Math.log((upperLimit - alpha) / gamma2) / (beta2 * Math.sqrt(2.0))));
            }
            if (lowerLimit > alpha) {
                arg2 = 0.5 * (1.0 + Stat.erf(Math.log((lowerLimit - alpha) / gamma2) / (beta2 * Math.sqrt(2.0))));
            }
            cdf = arg1 - arg2;
        }
        return cdf;
    }

    public static double logNormalThreeParInverseCDF(double alpha, double beta2, double gamma2, double prob) {
        return Stat.logNormalInverseCDF(alpha, beta2, gamma2, prob);
    }

    public static double logNormalThreeParMean(double alpha, double beta2, double gamma2) {
        return gamma2 * Math.exp(beta2 * beta2 / 2.0) + alpha;
    }

    public static double logNormalThreeParMedian(double alpha, double gamma2) {
        return gamma2 + alpha;
    }

    public static double logNormalThreeParMode(double alpha, double beta2, double gamma2) {
        return gamma2 * Math.exp(-beta2 * beta2) + alpha;
    }

    public static double[] logNormalThreeParOrderStatisticMedians(double alpha, double beta2, double gamma2, int n) {
        return Stat.logNormalOrderStatisticMedians(alpha, beta2, gamma2, n);
    }

    public static double logNormalThreeParPDF(double alpha, double beta2, double gamma2, double x2) {
        if (beta2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + beta2 + ", must be greater than or equal to zero");
        }
        if (x2 <= alpha) {
            return 0.0;
        }
        return Math.exp(-0.5 * Fmath.square(Math.log((x2 - alpha) / gamma2) / beta2)) / ((x2 - gamma2) * beta2 * Math.sqrt(Math.PI * 2));
    }

    public static double[] logNormalThreeParRand(double alpha, double beta2, double gamma2, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (beta2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + beta2 + ", must be greater than or equal to zero");
        }
        PsRandom psr = new PsRandom();
        return psr.logNormalThreeParArray(alpha, beta2, gamma2, n);
    }

    public static double[] logNormalThreeParRand(double alpha, double beta2, double gamma2, int n, long seed) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (beta2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + beta2 + ", must be greater than or equal to zero");
        }
        PsRandom psr = new PsRandom(seed);
        return psr.logNormalThreeParArray(alpha, beta2, gamma2, n);
    }

    public static double logNormalThreeParStandardDeviation(double alpha, double beta2, double gamma2) {
        return Stat.logNormalThreeParStandDev(alpha, beta2, gamma2);
    }

    public static double logNormalThreeParStandDev(double alpha, double beta2, double gamma2) {
        double beta22 = beta2 * beta2;
        return Math.sqrt((Math.exp(beta22) - 1.0) * Math.exp(2.0 * Math.log(gamma2) + beta22));
    }

    public static double logNormalTwoParCDF(double mu, double sigma, double upperLimit) {
        return Stat.logNormalCDF(mu, sigma, upperLimit);
    }

    public static double logNormalTwoParCDF(double mu, double sigma, double lowerLimit, double upperLimit) {
        return Stat.logNormalCDF(mu, sigma, lowerLimit, upperLimit);
    }

    public static double logNormaltwoParInverseCDF(double mu, double sigma, double prob) {
        double alpha = 0.0;
        double beta2 = sigma;
        double gamma2 = Math.exp(mu);
        return Stat.logNormalInverseCDF(alpha, beta2, gamma2, prob);
    }

    public static double logNormalTwoParMean(double mu, double sigma) {
        return Math.exp(mu + sigma * sigma / 2.0);
    }

    public static double logNormalTwoParMedian(double mu) {
        return Math.exp(mu);
    }

    public static double logNormalTwoParMode(double mu, double sigma) {
        return Math.exp(mu - sigma * sigma);
    }

    public static double[] logNormalTwoParOrderStatisticMedians(double mu, double sigma, int n) {
        return Stat.logNormalOrderStatisticMedians(mu, sigma, n);
    }

    public static double logNormalTwoParPDF(double mu, double sigma, double x2) {
        return Stat.logNormalPDF(mu, sigma, x2);
    }

    public static double[] logNormalTwoParRand(double mu, double sigma, int n) {
        return Stat.logNormalRand(mu, sigma, n);
    }

    public static double[] logNormalTwoParRand(double mu, double sigma, int n, long seed) {
        return Stat.logNormalRand(mu, sigma, n, seed);
    }

    public static double logNormalTwoParStandardDeviation(double mu, double sigma) {
        return Stat.logNormalTwoParStandDev(mu, sigma);
    }

    public static double logNormalTwoParStandDev(double mu, double sigma) {
        double sigma2 = sigma * sigma;
        return Math.sqrt((Math.exp(sigma2) - 1.0) * Math.exp(2.0 * mu + sigma2));
    }

    public static double lorentzian(double mu, double gamma2, double x2) {
        double arg = gamma2 / 2.0;
        return 0.3183098861837907 * arg / (Fmath.square(mu - x2) + arg * arg);
    }

    public static double lorentzianCDF(double mu, double gamma2, double lowerlimit, double upperlimit) {
        double arg1 = (upperlimit - mu) / (gamma2 / 2.0);
        double arg2 = (lowerlimit - mu) / (gamma2 / 2.0);
        return 0.3183098861837907 * (Math.atan(arg1) - Math.atan(arg2));
    }

    public static double lorentzianInverseCDF(double mu, double gamma2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? Double.NEGATIVE_INFINITY : (prob == 1.0 ? Double.POSITIVE_INFINITY : mu + gamma2 * Math.tan(Math.PI * (prob - 0.5)) / 2.0);
        return icdf;
    }

    public static double[] lorentzianOrderStatisticMedians(double mu, double gamma2, int n) {
        double[] losm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            losm[i] = Stat.lorentzianInverseCDF(mu, gamma2, uosm[i]);
            ++i;
        }
        return losm;
    }

    public static double lorentzianPDF(double mu, double gamma2, double x2) {
        double arg = gamma2 / 2.0;
        return 0.3183098861837907 * arg / (Fmath.square(mu - x2) + arg * arg);
    }

    public static double lorentzianProb(double mu, double gamma2, double upperlimit) {
        double arg = (upperlimit - mu) / (gamma2 / 2.0);
        return 0.3183098861837907 * (Math.atan(arg) + 1.5707963267948966);
    }

    public static double lorentzianProb(double mu, double gamma2, double lowerlimit, double upperlimit) {
        double arg1 = (upperlimit - mu) / (gamma2 / 2.0);
        double arg2 = (lowerlimit - mu) / (gamma2 / 2.0);
        return 0.3183098861837907 * (Math.atan(arg1) - Math.atan(arg2));
    }

    public static double[] lorentzianRand(double mu, double gamma2, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = Math.tan((rr.nextDouble() - 0.5) * Math.PI);
            ran[i] = ran[i] * gamma2 / 2.0 + mu;
            ++i;
        }
        return ran;
    }

    public static double[] lorentzianRand(double mu, double gamma2, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = Math.tan((rr.nextDouble() - 0.5) * Math.PI);
            ran[i] = ran[i] * gamma2 / 2.0 + mu;
            ++i;
        }
        return ran;
    }

    public static Vector<Object> lowerOutliersAnscombe(BigDecimal[] values2, BigDecimal constant) {
        return Stat.upperOutliersAnscombeAsVector(values2, constant);
    }

    public static Vector<Object> lowerOutliersAnscombe(BigInteger[] values2, BigInteger constant) {
        return Stat.upperOutliersAnscombeAsVector(values2, constant);
    }

    public static Vector<Object> lowerOutliersAnscombe(double[] values2, double constant) {
        return Stat.upperOutliersAnscombeAsVector(values2, constant);
    }

    public static ArrayList<Object> lowerOutliersAnscombeAsArrayList(BigDecimal[] values2, BigDecimal constant) {
        Stat am = new Stat(values2);
        BigDecimal[] copy0 = am.getArray_as_BigDecimal();
        BigDecimal[] copy1 = am.getArray_as_BigDecimal();
        int nValues = values2.length;
        ArrayList<Number> outers = new ArrayList<Number>();
        int nOutliers = 0;
        boolean test2 = true;
        while (test2) {
            BigDecimal mean = am.mean_as_BigDecimal();
            BigDecimal variance = am.variance_as_BigDecimal();
            BigDecimal min2 = am.getMinimum_as_BigDecimal();
            int minIndex = am.getMinimumIndex();
            BigDecimal statistic = mean.subtract(min2).divide(variance, 4);
            if (statistic.compareTo(constant.multiply(constant)) == 1) {
                outers.add(min2);
                outers.add(new Integer(minIndex));
                ++nOutliers;
                copy1 = new BigDecimal[nValues - 1];
                int i = minIndex;
                while (i < nValues - 1) {
                    copy1[i] = copy0[i + 1];
                    ++i;
                }
                --nValues;
                am = new Stat(Conv.copy(copy1));
                continue;
            }
            mean = null;
            variance = null;
            statistic = null;
            copy0 = null;
            test2 = false;
        }
        BigDecimal[] outliers = null;
        int[] outIndices = null;
        if (nOutliers > 0) {
            outliers = new BigDecimal[nOutliers];
            outIndices = new int[nOutliers];
            int i = 0;
            while (i < nOutliers) {
                outliers[i] = (BigDecimal)outers.get(2 * i);
                outIndices[i] = (Integer)outers.get(2 * i + 1);
                ++i;
            }
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(new Integer(nOutliers));
        ret.add(outliers);
        ret.add(outIndices);
        ret.add(copy1);
        return ret;
    }

    public static ArrayList<Object> lowerOutliersAnscombeAsArrayList(BigInteger[] values2, BigInteger constant) {
        ArrayMaths am = new ArrayMaths(values2);
        BigDecimal[] bd = am.getArray_as_BigDecimal();
        BigDecimal cd = new BigDecimal(constant);
        return Stat.lowerOutliersAnscombeAsArrayList(bd, cd);
    }

    public static ArrayList<Object> lowerOutliersAnscombeAsArrayList(double[] values2, double constant) {
        Stat am = new Stat(values2);
        double[] copy0 = am.getArray_as_double();
        double[] copy1 = am.getArray_as_double();
        int nValues = values2.length;
        ArrayList<Number> outers = new ArrayList<Number>();
        int nOutliers = 0;
        boolean test2 = true;
        while (test2) {
            double mean = am.mean_as_double();
            double standDev = am.standardDeviation_as_double();
            double min2 = am.getMinimum_as_double();
            int minIndex = am.getMinimumIndex();
            double statistic = (mean - min2) / standDev;
            if (statistic > constant) {
                outers.add(new Double(min2));
                outers.add(new Integer(minIndex));
                ++nOutliers;
                copy1 = new double[nValues - 1];
                int i = minIndex;
                while (i < nValues - 1) {
                    copy1[i] = copy0[i + 1];
                    ++i;
                }
                --nValues;
                am = new Stat(Conv.copy(copy1));
                continue;
            }
            test2 = false;
        }
        double[] outliers = null;
        int[] outIndices = null;
        if (nOutliers > 0) {
            outliers = new double[nOutliers];
            outIndices = new int[nOutliers];
            int i = 0;
            while (i < nOutliers) {
                outliers[i] = (Double)outers.get(2 * i);
                outIndices[i] = (Integer)outers.get(2 * i + 1);
                ++i;
            }
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(new Integer(nOutliers));
        ret.add(outliers);
        ret.add(outIndices);
        ret.add(copy1);
        return ret;
    }

    public static Vector<Object> lowerOutliersAnscombeAsVector(BigDecimal[] values2, BigDecimal constant) {
        ArrayList<Object> res = Stat.lowerOutliersAnscombeAsArrayList(values2, constant);
        Vector<Object> ret = null;
        if (res != null) {
            int n = res.size();
            ret = new Vector<Object>(n);
            int i = 0;
            while (i < n) {
                ret.add(res.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static Vector<Object> lowerOutliersAnscombeAsVector(BigInteger[] values2, BigInteger constant) {
        ArrayList<Object> res = Stat.lowerOutliersAnscombeAsArrayList(values2, constant);
        Vector<Object> ret = null;
        if (res != null) {
            int n = res.size();
            ret = new Vector<Object>(n);
            int i = 0;
            while (i < n) {
                ret.add(res.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static Vector<Object> lowerOutliersAnscombeAsVector(double[] values2, double constant) {
        ArrayList<Object> res = Stat.lowerOutliersAnscombeAsArrayList(values2, constant);
        Vector<Object> ret = null;
        if (res != null) {
            int n = res.size();
            ret = new Vector<Object>(n);
            int i = 0;
            while (i < n) {
                ret.add(res.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static BigDecimal mean(BigDecimal[] aa) {
        int n = aa.length;
        BigDecimal sum2 = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            sum2 = sum2.add(aa[i]);
            ++i;
        }
        return sum2.divide(new BigDecimal((double)n), 4);
    }

    public static BigDecimal mean(BigDecimal[] aa, BigDecimal[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        BigDecimal[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_BigDecimal();
        }
        BigDecimal sumx = BigDecimal.ZERO;
        BigDecimal sumw = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            sumx = sumx.add(aa[i].multiply(weight[i]));
            sumw = sumw.add(weight[i]);
            ++i;
        }
        sumx = sumx.divide(sumw, 4);
        sumw = null;
        weight = null;
        return sumx;
    }

    public static BigDecimal mean(BigInteger[] aa) {
        int n = aa.length;
        BigDecimal sum2 = BigDecimal.ZERO;
        BigDecimal bi = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            bi = new BigDecimal(aa[i]);
            sum2 = sum2.add(bi);
            ++i;
        }
        bi = null;
        return sum2.divide(new BigDecimal((double)n), 4);
    }

    public static BigDecimal mean(BigInteger[] aa, BigInteger[] ww) {
        ArrayMaths amaa = new ArrayMaths(aa);
        ArrayMaths amww = new ArrayMaths(ww);
        return Stat.mean(amaa.array_as_BigDecimal(), amww.array_as_BigDecimal());
    }

    public static double mean(byte[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += (double)aa[i];
            ++i;
        }
        return sum2 / (double)n;
    }

    public static Complex mean(Complex[] aa) {
        int n = aa.length;
        Complex sum2 = new Complex(0.0, 0.0);
        int i = 0;
        while (i < n) {
            sum2 = sum2.plus(aa[i]);
            ++i;
        }
        return sum2.over(n);
    }

    public static Complex mean(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        Complex[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_Complex();
        }
        Complex sumx = Complex.zero();
        Complex sumw = Complex.zero();
        int i = 0;
        while (i < n) {
            sumx = sumx.plus(aa[i].times(weight[i]));
            sumw = sumw.plus(weight[i]);
            ++i;
        }
        return sumx.over(sumw);
    }

    public static double mean(double[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += aa[i];
            ++i;
        }
        return sum2 / (double)n;
    }

    public static double mean(double[] aa, double[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array();
        }
        double sumx = 0.0;
        double sumw = 0.0;
        int i = 0;
        while (i < n) {
            sumx += aa[i] * weight[i];
            sumw += weight[i];
            ++i;
        }
        return sumx / sumw;
    }

    public static float mean(float[] aa) {
        int n = aa.length;
        float sum2 = 0.0f;
        int i = 0;
        while (i < n) {
            sum2 += aa[i];
            ++i;
        }
        return sum2 / (float)n;
    }

    public static float mean(float[] aa, float[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        float[] weight = Conv.copy(ww);
        if (weightingOptionS) {
            ArrayMaths am = new ArrayMaths(ww);
            am = am.pow(2);
            am = am.invert();
            weight = am.array_as_float();
        }
        float sumx = 0.0f;
        float sumw = 0.0f;
        int i = 0;
        while (i < n) {
            sumx += aa[i] * weight[i];
            sumw += weight[i];
            ++i;
        }
        return sumx / sumw;
    }

    public static double mean(int[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += (double)aa[i];
            ++i;
        }
        return sum2 / (double)n;
    }

    public static double mean(long[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += (double)aa[i];
            ++i;
        }
        return sum2 / (double)n;
    }

    public static double mean(short[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += (double)aa[i];
            ++i;
        }
        return sum2 / (double)n;
    }

    public static double[] meanConfidenceLimits(double mean, double sd, double prob) {
        double[] cl = new double[2];
        double probn = prob / 2.0 + 0.5;
        double z = Stat.gaussianInverseCDF(mean, sd, probn);
        cl[0] = 2.0 * mean - z;
        cl[1] = z;
        return cl;
    }

    public static BigDecimal median(BigDecimal[] aa) {
        int n = aa.length;
        int nOverTwo = n / 2;
        BigDecimal med = BigDecimal.ZERO;
        ArrayMaths bm = new ArrayMaths(aa);
        bm.sort();
        BigDecimal[] bb = bm.getArray_as_BigDecimal();
        med = Fmath.isOdd(n) ? bb[nOverTwo] : bb[nOverTwo - 1].add(bb[nOverTwo]).divide(new BigDecimal(2.0), 4);
        bb = null;
        return med;
    }

    public static BigInteger median(BigInteger[] aa) {
        int n = aa.length;
        int nOverTwo = n / 2;
        BigInteger med = BigInteger.ZERO;
        ArrayMaths bm = new ArrayMaths(aa);
        bm.sort();
        BigInteger[] bb = bm.getArray_as_BigInteger();
        med = Fmath.isOdd(n) ? bb[nOverTwo] : bb[nOverTwo - 1].add(bb[nOverTwo]).divide(new BigInteger("2"));
        bb = null;
        return med;
    }

    public static double median(double[] aa) {
        int n = aa.length;
        int nOverTwo = n / 2;
        double med = 0.0;
        double[] bb = Fmath.selectionSort(aa);
        med = Fmath.isOdd(n) ? bb[nOverTwo] : (bb[nOverTwo - 1] + bb[nOverTwo]) / 2.0;
        return med;
    }

    public static float median(float[] aa) {
        int n = aa.length;
        int nOverTwo = n / 2;
        float med = 0.0f;
        float[] bb = Fmath.selectionSort(aa);
        med = Fmath.isOdd(n) ? bb[nOverTwo] : (bb[nOverTwo - 1] + bb[nOverTwo]) / 2.0f;
        return med;
    }

    public static double median(int[] aa) {
        int n = aa.length;
        int nOverTwo = n / 2;
        double med = 0.0;
        int[] bb = Fmath.selectionSort(aa);
        med = Fmath.isOdd(n) ? (double)bb[nOverTwo] : (double)(bb[nOverTwo - 1] + bb[nOverTwo]) / 2.0;
        return med;
    }

    public static double median(long[] aa) {
        int n = aa.length;
        int nOverTwo = n / 2;
        double med = 0.0;
        long[] bb = Fmath.selectionSort(aa);
        med = Fmath.isOdd(n) ? (double)bb[nOverTwo] : (double)(bb[nOverTwo - 1] + bb[nOverTwo]) / 2.0;
        return med;
    }

    public static double medianSkewness(BigDecimal[] aa) {
        BigDecimal mean = Stat.mean(aa);
        BigDecimal median = Stat.median(aa);
        double sd = Stat.standardDeviation(aa);
        return 3.0 * mean.subtract(median).doubleValue() / sd;
    }

    public static double medianSkewness(double[] aa) {
        double mean = Stat.mean(aa);
        double median = Stat.median(aa);
        double sd = Stat.standardDeviation(aa);
        return 3.0 * (mean - median) / sd;
    }

    public static float medianSkewness(float[] aa) {
        float mean = Stat.mean(aa);
        float median = Stat.median(aa);
        float sd = Stat.standardDeviation(aa);
        return 3.0f * (mean - median) / sd;
    }

    public static double medianSkewness(int[] aa) {
        double mean = Stat.mean(aa);
        double median = Stat.median(aa);
        double sd = Stat.standardDeviation(aa);
        return 3.0 * (mean - median) / sd;
    }

    public static double medianSkewness(long[] aa) {
        double mean = Stat.mean(aa);
        double median = Stat.median(aa);
        double sd = Stat.standardDeviation(aa);
        return 3.0 * (mean - median) / sd;
    }

    public static double momentSkewness(BigDecimal[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        BigDecimal sum2 = BigDecimal.ZERO;
        BigDecimal mean = Stat.mean(aa);
        double sd = Stat.standardDeviation(aa);
        int i = 0;
        while (i < n) {
            BigDecimal hold = aa[i].subtract(mean);
            sum2 = sum2.add(hold.multiply(hold.multiply(hold)));
            ++i;
        }
        sum2 = sum2.multiply(new BigDecimal(1.0 / denom));
        return sum2.doubleValue() / Math.pow(sd, 3.0);
    }

    public static double momentSkewness(double[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Math.pow(aa[i] - mean, 3.0);
            ++i;
        }
        return (sum2 /= denom) / Math.pow(Stat.standardDeviation(aa), 3.0);
    }

    public static float momentSkewness(float[] aa) {
        int n = aa.length;
        float denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        float sum2 = 0.0f;
        float mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 = (float)((double)sum2 + Math.pow(aa[i] - mean, 3.0));
            ++i;
        }
        return (sum2 /= denom) / (float)Math.pow(Stat.standardDeviation(aa), 3.0);
    }

    public static double momentSkewness(int[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Math.pow((double)aa[i] - mean, 3.0);
            ++i;
        }
        return (sum2 /= denom) / Math.pow(Stat.standardDeviation(aa), 3.0);
    }

    public static double momentSkewness(long[] aa) {
        int n = aa.length;
        double denom = n - 1;
        if (nFactorOptionS) {
            denom = n;
        }
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Math.pow((double)aa[i] - mean, 3.0);
            ++i;
        }
        return (sum2 /= denom) / Math.pow(Stat.standardDeviation(aa), 3.0);
    }

    public static double normal(double mean, double sd, double x2) {
        return Math.exp(-Fmath.square((x2 - mean) / sd) / 2.0) / (sd * Math.sqrt(Math.PI * 2));
    }

    public static double normalCDF(double mean, double sd, double upperlimit) {
        double prob = Double.NaN;
        if (upperlimit == Double.POSITIVE_INFINITY) {
            prob = 1.0;
        } else if (upperlimit == Double.NEGATIVE_INFINITY) {
            prob = 0.0;
        } else {
            double arg = (upperlimit - mean) / (sd * Math.sqrt(2.0));
            prob = (1.0 + Stat.erf(arg)) / 2.0;
        }
        if (Fmath.isNaN(prob)) {
            prob = upperlimit > mean ? 1.0 : 0.0;
        }
        return prob;
    }

    public static double normalCDF(double mean, double sd, double lowerlimit, double upperlimit) {
        return Stat.normalCDF(mean, sd, upperlimit) - Stat.normalCDF(mean, sd, lowerlimit);
    }

    public static double normalInverseCDF(double prob) {
        return Stat.gaussianInverseCDF(0.0, 1.0, prob);
    }

    public static double normalInverseCDF(double mean, double sd, double prob) {
        return Stat.gaussianInverseCDF(mean, sd, prob);
    }

    public static double[] normalOrderStatisticMedians(double mean, double sigma, int n) {
        return Stat.gaussianOrderStatisticMedians(mean, sigma, n);
    }

    public static double[] normalOrderStatisticMedians(int n) {
        return Stat.gaussianOrderStatisticMedians(0.0, 1.0, n);
    }

    public static double normalPDF(double mean, double sd, double x2) {
        return Math.exp(-Fmath.square((x2 - mean) / sd) / 2.0) / (sd * Math.sqrt(Math.PI * 2));
    }

    public static double normalProb(double mean, double sd, double upperlimit) {
        if (upperlimit == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (upperlimit == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double arg = (upperlimit - mean) / (sd * Math.sqrt(2.0));
        return (1.0 + Stat.erf(arg)) / 2.0;
    }

    public static double normalProb(double mean, double sd, double lowerlimit, double upperlimit) {
        return Stat.normalCDF(mean, sd, upperlimit) - Stat.normalCDF(mean, sd, lowerlimit);
    }

    public static double[] normalRand(double mean, double sd, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = rr.nextGaussian();
            ++i;
        }
        ran = Stat.standardize(ran);
        i = 0;
        while (i < n) {
            ran[i] = ran[i] * sd + mean;
            ++i;
        }
        return ran;
    }

    public static double[] normalRand(double mean, double sd, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = rr.nextGaussian();
            ++i;
        }
        ran = Stat.standardize(ran);
        i = 0;
        while (i < n) {
            ran[i] = ran[i] * sd + mean;
            ++i;
        }
        return ran;
    }

    public static double pareto(double alpha, double beta2, double x2) {
        double y = 0.0;
        if (x2 >= beta2) {
            y = alpha * Math.pow(beta2, alpha) / Math.pow(x2, alpha + 1.0);
        }
        return y;
    }

    public static double paretoCDF(double alpha, double beta2, double upperlimit) {
        double y = 0.0;
        if (upperlimit >= beta2) {
            y = 1.0 - Math.pow(beta2 / upperlimit, alpha);
        }
        return y;
    }

    public static double paretoCDF(double alpha, double beta2, double lowerlimit, double upperlimit) {
        double term1 = 0.0;
        double term2 = 0.0;
        if (lowerlimit >= beta2) {
            term1 = -Math.pow(beta2 / lowerlimit, alpha);
        }
        if (upperlimit >= beta2) {
            term2 = -Math.pow(beta2 / upperlimit, alpha);
        }
        return term2 - term1;
    }

    public static double paretoInverseCDF(double alpha, double beta2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? beta2 : (prob == 1.0 ? Double.POSITIVE_INFINITY : beta2 / Math.pow(1.0 - prob, 1.0 / alpha));
        return icdf;
    }

    public static double paretoMean(double alpha, double beta2) {
        double y = Double.NaN;
        if (alpha > 1.0) {
            y = alpha * beta2 / (alpha - 1.0);
        }
        return y;
    }

    public static double paretoMode(double beta2) {
        return beta2;
    }

    public static double[] paretoOrderStatisticMedians(double alpha, double beta2, int n) {
        double[] posm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            posm[i] = Stat.inverseParetoCDF(alpha, beta2, uosm[i]);
            ++i;
        }
        return posm;
    }

    public static double paretoPDF(double alpha, double beta2, double x2) {
        double y = 0.0;
        if (x2 >= beta2) {
            y = alpha * Math.pow(beta2, alpha) / Math.pow(x2, alpha + 1.0);
        }
        return y;
    }

    public static double paretoProb(double alpha, double beta2, double upperlimit) {
        double y = 0.0;
        if (upperlimit >= beta2) {
            y = 1.0 - Math.pow(beta2 / upperlimit, alpha);
        }
        return y;
    }

    public static double paretoProb(double alpha, double beta2, double lowerlimit, double upperlimit) {
        double term1 = 0.0;
        double term2 = 0.0;
        if (lowerlimit >= beta2) {
            term1 = -Math.pow(beta2 / lowerlimit, alpha);
        }
        if (upperlimit >= beta2) {
            term2 = -Math.pow(beta2 / upperlimit, alpha);
        }
        return term2 - term1;
    }

    public static double[] paretoRand(double alpha, double beta2, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = Math.pow(1.0 - rr.nextDouble(), -1.0 / alpha) * beta2;
            ++i;
        }
        return ran;
    }

    public static double[] paretoRand(double alpha, double beta2, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = Math.pow(1.0 - rr.nextDouble(), -1.0 / alpha) * beta2;
            ++i;
        }
        return ran;
    }

    public static double paretoStandardDeviation(double alpha, double beta2) {
        double y = Double.NaN;
        if (alpha > 1.0) {
            y = alpha * Fmath.square(beta2) / (Fmath.square(alpha - 1.0) * (alpha - 2.0));
        }
        return y;
    }

    public static double paretoStandDev(double alpha, double beta2) {
        double y = Double.NaN;
        if (alpha > 1.0) {
            y = alpha * Fmath.square(beta2) / (Fmath.square(alpha - 1.0) * (alpha - 2.0));
        }
        return y;
    }

    public static double poisson(int k, double mean) {
        if (k < 0) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 0");
        }
        return Math.pow(mean, k) * Math.exp(-mean) / Stat.factorial((double)k);
    }

    public static double poissonCDF(int k, double mean) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 1");
        }
        return Stat.incompleteGammaComplementary(k, mean);
    }

    public static double poissonPDF(int k, double mean) {
        if (k < 0) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 0");
        }
        return Math.pow(mean, k) * Math.exp(-mean) / Stat.factorial((double)k);
    }

    public static double poissonProb(int k, double mean) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 1");
        }
        return Stat.incompleteGammaComplementary(k, mean);
    }

    public static double[] poissonRand(double mean, int n) {
        Random rr = new Random();
        double[] ran = Stat.poissonRandCalc(rr, mean, n);
        return ran;
    }

    public static double[] poissonRand(double mean, int n, long seed) {
        Random rr = new Random(seed);
        double[] ran = Stat.poissonRandCalc(rr, mean, n);
        return ran;
    }

    private static double[] poissonRandCalc(Random rr, double mean, int n) {
        double[] ran = new double[n];
        double oldm = -1.0;
        double expt = 0.0;
        double em = 0.0;
        double term = 0.0;
        double sq = 0.0;
        double lnMean = 0.0;
        double yDev = 0.0;
        if (mean < 12.0) {
            int i = 0;
            while (i < n) {
                if (mean != oldm) {
                    oldm = mean;
                    expt = Math.exp(-mean);
                }
                em = -1.0;
                term = 1.0;
                do {
                    em += 1.0;
                } while ((term *= rr.nextDouble()) > expt);
                ran[i] = em;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                if (mean != oldm) {
                    oldm = mean;
                    sq = Math.sqrt(2.0 * mean);
                    lnMean = Math.log(mean);
                    expt = lnMean - Stat.logGamma(mean + 1.0);
                }
                while (true) {
                    if ((em = sq * (yDev = Math.tan(Math.PI * rr.nextDouble())) + mean) < 0.0) {
                        continue;
                    }
                    em = Math.floor(em);
                    term = 0.9 * (1.0 + yDev * yDev) * Math.exp(em * lnMean - Stat.logGamma(em + 1.0) - expt);
                    if (!(rr.nextDouble() > term)) break;
                }
                ran[i] = em;
                ++i;
            }
        }
        return ran;
    }

    public static double probAtn(double tValue, int df) {
        double ddf = df;
        double x2 = ddf / (ddf + tValue * tValue);
        return 1.0 - Stat.regularisedBetaFunction(ddf / 2.0, 0.5, x2);
    }

    public static double pValue(double tValue, int df) {
        if (tValue != tValue) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double abst = Math.abs(tValue);
        return 1.0 - Stat.studentTcdf(-abst, abst, df);
    }

    public static BigDecimal quartileSkewness(BigDecimal[] aa) {
        BigDecimal ret2;
        int n = aa.length;
        BigDecimal median50 = Stat.median(aa);
        int start1 = 0;
        int start2 = 0;
        int end1 = n / 2 - 1;
        int end2 = n - 1;
        start2 = Fmath.isOdd(n) ? end1 + 2 : end1 + 1;
        ArrayMaths am = new ArrayMaths(aa);
        BigDecimal[] first = am.subarray_as_BigDecimal(start1, end1);
        BigDecimal[] last2 = am.subarray_as_BigDecimal(start2, end2);
        BigDecimal median25 = Stat.median(first);
        BigDecimal median75 = Stat.median(last2);
        BigDecimal ret1 = median25.subtract(median50.multiply(new BigDecimal(2.0))).add(median75);
        BigDecimal ret = ret1.divide(ret2 = median75.subtract(median25), 4);
        if (Fmath.isNaN(ret.doubleValue())) {
            ret = new BigDecimal(1.0);
        }
        first = null;
        last2 = null;
        median25 = null;
        median50 = null;
        median75 = null;
        ret1 = null;
        ret2 = null;
        return ret;
    }

    public static BigDecimal quartileSkewness(BigInteger[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        BigDecimal[] bd = am.array_as_BigDecimal();
        return Stat.quartileSkewness(bd);
    }

    public static double quartileSkewness(double[] aa) {
        double median75;
        int n = aa.length;
        double median50 = Stat.median(aa);
        int start1 = 0;
        int start2 = 0;
        int end1 = n / 2 - 1;
        int end2 = n - 1;
        start2 = Fmath.isOdd(n) ? end1 + 2 : end1 + 1;
        ArrayMaths am = new ArrayMaths(aa);
        double[] first = am.subarray_as_double(start1, end1);
        double[] last2 = am.subarray_as_double(start2, end2);
        double median25 = Stat.median(first);
        double ret = (median25 - 2.0 * median50 + (median75 = Stat.median(last2))) / (median75 - median25);
        if (Fmath.isNaN(ret)) {
            ret = 1.0;
        }
        return ret;
    }

    public static float quartileSkewness(float[] aa) {
        float median75;
        int n = aa.length;
        float median50 = Stat.median(aa);
        int start1 = 0;
        int start2 = 0;
        int end1 = n / 2 - 1;
        int end2 = n - 1;
        start2 = Fmath.isOdd(n) ? end1 + 2 : end1 + 1;
        ArrayMaths am = new ArrayMaths(aa);
        float[] first = am.subarray_as_float(start1, end1);
        float[] last2 = am.subarray_as_float(start2, end2);
        float median25 = Stat.median(first);
        float ret = (median25 - 2.0f * median50 + (median75 = Stat.median(last2))) / (median75 - median25);
        if (Fmath.isNaN(ret)) {
            ret = 1.0f;
        }
        return ret;
    }

    public static double quartileSkewness(int[] aa) {
        double median75;
        int n = aa.length;
        double median50 = Stat.median(aa);
        int start1 = 0;
        int start2 = 0;
        int end1 = n / 2 - 1;
        int end2 = n - 1;
        start2 = Fmath.isOdd(n) ? end1 + 2 : end1 + 1;
        ArrayMaths am = new ArrayMaths(aa);
        double[] first = am.subarray_as_double(start1, end1);
        double[] last2 = am.subarray_as_double(start2, end2);
        double median25 = Stat.median(first);
        double ret = (median25 - 2.0 * median50 + (median75 = Stat.median(last2))) / (median75 - median25);
        if (Fmath.isNaN(ret)) {
            ret = 1.0;
        }
        return ret;
    }

    public static double quartileSkewness(long[] aa) {
        double median75;
        int n = aa.length;
        double median50 = Stat.median(aa);
        int start1 = 0;
        int start2 = 0;
        int end1 = n / 2 - 1;
        int end2 = n - 1;
        start2 = Fmath.isOdd(n) ? end1 + 2 : end1 + 1;
        ArrayMaths am = new ArrayMaths(aa);
        double[] first = am.subarray_as_double(start1, end1);
        double[] last2 = am.subarray_as_double(start2, end2);
        double median25 = Stat.median(first);
        double ret = (median25 - 2.0 * median50 + (median75 = Stat.median(last2))) / (median75 - median25);
        if (Fmath.isNaN(ret)) {
            ret = 1.0;
        }
        return ret;
    }

    public static double rayleigh(double beta2, double x2) {
        double arg = x2 / beta2;
        double y = 0.0;
        if (arg >= 0.0) {
            y = arg / beta2 * Math.exp(-arg * arg / 2.0) / beta2;
        }
        return y;
    }

    public static double rayleighCDF(double beta2, double upperlimit) {
        double arg = upperlimit / beta2;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-arg * arg / 2.0);
        }
        return y;
    }

    public static double rayleighCDF(double beta2, double lowerlimit, double upperlimit) {
        double arg1 = lowerlimit / beta2;
        double arg2 = upperlimit / beta2;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = -Math.exp(-arg1 * arg1 / 2.0);
        }
        if (arg2 >= 0.0) {
            term2 = -Math.exp(-arg2 * arg2 / 2.0);
        }
        return term2 - term1;
    }

    public static double rayleighInverseCDF(double beta2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? 0.0 : (prob == 1.0 ? Double.POSITIVE_INFINITY : beta2 * Math.sqrt(-Math.log(1.0 - prob)));
        return icdf;
    }

    public static double rayleighMean(double beta2) {
        return beta2 * Math.sqrt(1.5707963267948966);
    }

    public static double rayleighMedian(double beta2) {
        return beta2 * Math.sqrt(Math.log(2.0));
    }

    public static double rayleighMode(double beta2) {
        return beta2;
    }

    public static double[] rayleighOrderStatisticMedians(double beta2, int n) {
        double[] rosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            rosm[i] = Stat.inverseRayleighCDF(beta2, uosm[i]);
            ++i;
        }
        return rosm;
    }

    public static double rayleighPDF(double beta2, double x2) {
        double arg = x2 / beta2;
        double y = 0.0;
        if (arg >= 0.0) {
            y = arg / beta2 * Math.exp(-arg * arg / 2.0) / beta2;
        }
        return y;
    }

    public static double rayleighProb(double beta2, double upperlimit) {
        double arg = upperlimit / beta2;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-arg * arg / 2.0);
        }
        return y;
    }

    public static double rayleighProb(double beta2, double lowerlimit, double upperlimit) {
        double arg1 = lowerlimit / beta2;
        double arg2 = upperlimit / beta2;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = -Math.exp(-arg1 * arg1 / 2.0);
        }
        if (arg2 >= 0.0) {
            term2 = -Math.exp(-arg2 * arg2 / 2.0);
        }
        return term2 - term1;
    }

    public static double[] rayleighRand(double beta2, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = Math.sqrt(-2.0 * Math.log(1.0 - rr.nextDouble())) * beta2;
            ++i;
        }
        return ran;
    }

    public static double[] rayleighRand(double beta2, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = Math.sqrt(-2.0 * Math.log(1.0 - rr.nextDouble())) * beta2;
            ++i;
        }
        return ran;
    }

    public static double rayleighStandardDeviation(double beta2) {
        return beta2 * Math.sqrt(0.42920367320510344);
    }

    public static double rayleighStandDev(double beta2) {
        return beta2 * Math.sqrt(0.42920367320510344);
    }

    public static double regIncompleteGamma(double a, double x2) {
        return Stat.regularisedGammaFunction(a, x2);
    }

    public static double regIncompleteGammaComplementary(double a, double x2) {
        return Stat.complementaryRegularisedGammaFunction(a, x2);
    }

    public static double regularisedBetaFunction(double z, double w, double x2) {
        if (x2 < 0.0 || x2 > 1.0) {
            throw new IllegalArgumentException("Argument x, " + x2 + ", must be lie between 0 and 1 (inclusive)");
        }
        double ibeta = 0.0;
        if (x2 == 0.0) {
            ibeta = 0.0;
        } else if (x2 == 1.0) {
            ibeta = 1.0;
        } else {
            ibeta = Math.exp(Stat.logGamma(z + w) - Stat.logGamma(z) - Stat.logGamma(w) + z * Math.log(x2) + w * Math.log(1.0 - x2));
            ibeta = x2 < (z + 1.0) / (z + w + 2.0) ? ibeta * Stat.contFract(z, w, x2) / z : 1.0 - ibeta * Stat.contFract(w, z, 1.0 - x2) / w;
        }
        return ibeta;
    }

    public static double regularisedGammaFunction(double a, double x2) {
        if (a < 0.0 || x2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        boolean oldIgSupress = igSupress;
        igSupress = true;
        double igf = 0.0;
        if (x2 != 0.0 && (igf = x2 < a + 1.0 ? Stat.incompleteGammaSer(a, x2) : Stat.incompleteGammaFract(a, x2)) != igf) {
            igf = 1.0 - Stat.crigfGaussQuad(a, x2);
        }
        if (igf < 0.0) {
            igf = 0.0;
        }
        igSupress = oldIgSupress;
        return igf;
    }

    public static double regularizedBetaFunction(double z, double w, double x2) {
        return Stat.regularisedBetaFunction(z, w, x2);
    }

    public static double regularizedGammaFunction(double a, double x2) {
        return Stat.regularisedGammaFunction(a, x2);
    }

    /*
     * Unable to fully structure code
     */
    public static double renyiEntropy(double[] p, double alpha) {
        block15: {
            block18: {
                block17: {
                    block16: {
                        block14: {
                            am = new ArrayMaths(p);
                            max = am.getMaximum_as_double();
                            if (max > 1.0) {
                                throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max);
                            }
                            min = am.getMinimum_as_double();
                            if (min < 0.0) {
                                throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min);
                            }
                            total = am.getSum_as_double();
                            if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
                                throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
                            }
                            if (alpha < 0.0) {
                                throw new IllegalArgumentException("alpha, " + alpha + ", must be greater than or equal to 0");
                            }
                            entropy = 0.0;
                            if (alpha != 0.0) break block14;
                            entropy = Fmath.log2(p.length);
                            break block15;
                        }
                        if (alpha != 1.0) break block16;
                        entropy = Stat.shannonEntropy(p);
                        break block15;
                    }
                    if (!Fmath.isPlusInfinity(alpha)) break block17;
                    entropy = -Fmath.log2(max);
                    break block15;
                }
                if (!(alpha <= 3000.0)) break block18;
                am = am.pow(alpha);
                testUnderFlow = false;
                if (am.getMaximum_as_double() == 4.9E-324) {
                    testUnderFlow = true;
                }
                if (!Fmath.isPlusInfinity(entropy = Fmath.log2(am.getSum_as_double()) / (1.0 - alpha)) && !testUnderFlow) break block15;
                entropyMin = entropy = -Fmath.log2(max);
                System.out.println("Stat: renyiEntropy/renyiEntopyBit: underflow or overflow in calculating the entropy");
                test1 = true;
                test2 = true;
                test3 = true;
                iter = 0;
                alpha2 = alpha / 2.0;
                entropy2 = 0.0;
                ** GOTO lbl59
                {
                    am2 = new ArrayMaths(p);
                    entropy2 = Fmath.log2((am2 = am2.pow(alpha2)).getSum_as_double()) / (1.0 - alpha2);
                    if (Fmath.isPlusInfinity(entropy2)) {
                        alpha2 /= 2.0;
                        if (++iter == 100000) {
                            test1 = false;
                            test2 = false;
                        }
                    } else {
                        test1 = false;
                    }
                    do {
                        if (test1) continue block0;
                        alphaTest = alpha2 + 40.0 * alpha / 1000.0;
                        am3 = new ArrayMaths(p);
                        entropy3 = Fmath.log2((am3 = am3.pow(alphaTest)).getSum_as_double()) / (1.0 - alphaTest);
                        if (!Fmath.isPlusInfinity(entropy3)) {
                            test3 = false;
                            continue;
                        }
                        alpha2 /= 2.0;
lbl59:
                        // 3 sources

                    } while (test3);
                }
                entropyLast = entropy2;
                alphaLast = alpha2;
                extrap = new ArrayList<Double>();
                if (test2) {
                    diff = alpha2 / 1000.0;
                    test1 = true;
                    while (test1) {
                        extrap.add(new Double(alpha2));
                        extrap.add(new Double(entropy2));
                        entropyLast = entropy2;
                        alphaLast = alpha2;
                        am2 = new ArrayMaths(p);
                        am2 = am2.pow(alpha2 += diff);
                        entropy2 = Fmath.log2(am2.getSum_as_double()) / (1.0 - alpha2);
                        if (!Fmath.isPlusInfinity(entropy2)) continue;
                        test1 = false;
                        entropy2 = entropyLast;
                        alpha2 = alphaLast;
                    }
                }
                nex = extrap.size() / 2 - 20;
                alphaex = new double[nex];
                entroex = new double[nex];
                ii = -1;
                i = 0;
                while (i < nex) {
                    alphaex[i] = (Double)extrap.get(++ii);
                    entroex[i] = Math.log((Double)extrap.get(++ii) - entropyMin);
                    ++i;
                }
                reg = new Regression(alphaex, entroex);
                reg.linear();
                param = reg.getCoeff();
                entropy = Math.exp(param[0] + param[1] * alpha) + entropyMin;
                System.out.println("An interpolated entropy of " + entropy + " returned (see documentation for exponential interpolation)");
                System.out.println("Lowest calculable value =  " + (Math.exp(entroex[nex - 1]) + entropyMin) + ", alpha = " + alphaex[nex - 1]);
                System.out.println("Minimum entropy value =  " + entropyMin + ", alpha = infinity");
                break block15;
            }
            entropy = -Fmath.log2(max);
            System.out.println("Stat: renyiEntropy/renyiEntropyBit: underflow or overflow in calculating the entropy");
            System.out.println("An interpolated entropy of " + entropy + " returned (see documentation for exponential interpolation)");
        }
        return entropy;
    }

    public static double renyiEntropyBit(double[] p, double alpha) {
        return Stat.renyiEntropy(p, alpha);
    }

    /*
     * Unable to fully structure code
     */
    public static double renyiEntropyDit(double[] p, double alpha) {
        block15: {
            block18: {
                block17: {
                    block16: {
                        block14: {
                            am = new ArrayMaths(p);
                            max = am.getMaximum_as_double();
                            if (max > 1.0) {
                                throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max);
                            }
                            min = am.getMinimum_as_double();
                            if (min < 0.0) {
                                throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min);
                            }
                            total = am.getSum_as_double();
                            if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
                                throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
                            }
                            if (alpha < 0.0) {
                                throw new IllegalArgumentException("alpha, " + alpha + ", must be greater than or equal to 0");
                            }
                            entropy = 0.0;
                            if (alpha != 0.0) break block14;
                            entropy = Math.log10(p.length);
                            break block15;
                        }
                        if (alpha != 1.0) break block16;
                        entropy = Stat.shannonEntropy(p);
                        break block15;
                    }
                    if (!Fmath.isPlusInfinity(alpha)) break block17;
                    entropy = -Math.log10(max);
                    break block15;
                }
                if (!(alpha <= 3000.0)) break block18;
                am = am.pow(alpha);
                testUnderFlow = false;
                if (am.getMaximum_as_double() == 4.9E-324) {
                    testUnderFlow = true;
                }
                if (!Fmath.isPlusInfinity(entropy = Math.log10(am.getSum_as_double()) / (1.0 - alpha)) && !testUnderFlow) break block15;
                entropyMin = entropy = -Math.log10(max);
                System.out.println("Stat: renyiEntropyDit: underflow or overflow in calculating the entropy");
                test1 = true;
                test2 = true;
                test3 = true;
                iter = 0;
                alpha2 = alpha / 2.0;
                entropy2 = 0.0;
                ** GOTO lbl59
                {
                    am2 = new ArrayMaths(p);
                    entropy2 = Math.log10((am2 = am2.pow(alpha2)).getSum_as_double()) / (1.0 - alpha2);
                    if (Fmath.isPlusInfinity(entropy2)) {
                        alpha2 /= 2.0;
                        if (++iter == 100000) {
                            test1 = false;
                            test2 = false;
                        }
                    } else {
                        test1 = false;
                    }
                    do {
                        if (test1) continue block0;
                        alphaTest = alpha2 + 40.0 * alpha / 1000.0;
                        am3 = new ArrayMaths(p);
                        entropy3 = Math.log10((am3 = am3.pow(alphaTest)).getSum_as_double()) / (1.0 - alphaTest);
                        if (!Fmath.isPlusInfinity(entropy3)) {
                            test3 = false;
                            continue;
                        }
                        alpha2 /= 2.0;
lbl59:
                        // 3 sources

                    } while (test3);
                }
                entropyLast = entropy2;
                alphaLast = alpha2;
                extrap = new ArrayList<Double>();
                if (test2) {
                    diff = alpha2 / 1000.0;
                    test1 = true;
                    while (test1) {
                        extrap.add(new Double(alpha2));
                        extrap.add(new Double(entropy2));
                        entropyLast = entropy2;
                        alphaLast = alpha2;
                        am2 = new ArrayMaths(p);
                        am2 = am2.pow(alpha2 += diff);
                        entropy2 = Math.log10(am2.getSum_as_double()) / (1.0 - alpha2);
                        if (!Fmath.isPlusInfinity(entropy2)) continue;
                        test1 = false;
                        entropy2 = entropyLast;
                        alpha2 = alphaLast;
                    }
                }
                nex = extrap.size() / 2 - 20;
                alphaex = new double[nex];
                entroex = new double[nex];
                ii = -1;
                i = 0;
                while (i < nex) {
                    alphaex[i] = (Double)extrap.get(++ii);
                    entroex[i] = Math.log10((Double)extrap.get(++ii) - entropyMin);
                    ++i;
                }
                reg = new Regression(alphaex, entroex);
                reg.linear();
                param = reg.getCoeff();
                entropy = Math.exp(param[0] + param[1] * alpha) + entropyMin;
                System.out.println("An interpolated entropy of " + entropy + " returned (see documentation for exponential interpolation)");
                System.out.println("Lowest calculable value =  " + (Math.exp(entroex[nex - 1]) + entropyMin) + ", alpha = " + alphaex[nex - 1]);
                System.out.println("Minimum entropy value =  " + entropyMin + ", alpha = infinity");
                break block15;
            }
            entropy = -Math.log10(max);
            System.out.println("Stat: renyiEntropyDit: underflow or overflow in calculating the entropy");
            System.out.println("An interpolated entropy of " + entropy + " returned (see documentation for exponential interpolation)");
        }
        return entropy;
    }

    /*
     * Unable to fully structure code
     */
    public static double renyiEntropyNat(double[] p, double alpha) {
        block15: {
            block18: {
                block17: {
                    block16: {
                        block14: {
                            am = new ArrayMaths(p);
                            max = am.getMaximum_as_double();
                            if (max > 1.0) {
                                throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max);
                            }
                            min = am.getMinimum_as_double();
                            if (min < 0.0) {
                                throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min);
                            }
                            total = am.getSum_as_double();
                            if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
                                throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
                            }
                            if (alpha < 0.0) {
                                throw new IllegalArgumentException("alpha, " + alpha + ", must be greater than or equal to 0");
                            }
                            entropy = 0.0;
                            if (alpha != 0.0) break block14;
                            entropy = Math.log(p.length);
                            break block15;
                        }
                        if (alpha != 1.0) break block16;
                        entropy = Stat.shannonEntropy(p);
                        break block15;
                    }
                    if (!Fmath.isPlusInfinity(alpha)) break block17;
                    entropy = -Math.log(max);
                    break block15;
                }
                if (!(alpha <= 3000.0)) break block18;
                am = am.pow(alpha);
                testUnderFlow = false;
                if (am.getMaximum_as_double() == 4.9E-324) {
                    testUnderFlow = true;
                }
                if (!Fmath.isPlusInfinity(entropy = Math.log(am.getSum_as_double()) / (1.0 - alpha)) && !testUnderFlow) break block15;
                entropyMin = entropy = -Math.log(max);
                System.out.println("Stat: renyiEntropyNat: underflow or overflow in calculating the entropy");
                test1 = true;
                test2 = true;
                test3 = true;
                iter = 0;
                alpha2 = alpha / 2.0;
                entropy2 = 0.0;
                ** GOTO lbl59
                {
                    am2 = new ArrayMaths(p);
                    entropy2 = Math.log((am2 = am2.pow(alpha2)).getSum_as_double()) / (1.0 - alpha2);
                    if (Fmath.isPlusInfinity(entropy2)) {
                        alpha2 /= 2.0;
                        if (++iter == 100000) {
                            test1 = false;
                            test2 = false;
                        }
                    } else {
                        test1 = false;
                    }
                    do {
                        if (test1) continue block0;
                        alphaTest = alpha2 + 40.0 * alpha / 1000.0;
                        am3 = new ArrayMaths(p);
                        entropy3 = Math.log((am3 = am3.pow(alphaTest)).getSum_as_double()) / (1.0 - alphaTest);
                        if (!Fmath.isPlusInfinity(entropy3)) {
                            test3 = false;
                            continue;
                        }
                        alpha2 /= 2.0;
lbl59:
                        // 3 sources

                    } while (test3);
                }
                entropyLast = entropy2;
                alphaLast = alpha2;
                extrap = new ArrayList<Double>();
                if (test2) {
                    diff = alpha2 / 1000.0;
                    test1 = true;
                    while (test1) {
                        extrap.add(new Double(alpha2));
                        extrap.add(new Double(entropy2));
                        entropyLast = entropy2;
                        alphaLast = alpha2;
                        am2 = new ArrayMaths(p);
                        am2 = am2.pow(alpha2 += diff);
                        entropy2 = Math.log(am2.getSum_as_double()) / (1.0 - alpha2);
                        if (!Fmath.isPlusInfinity(entropy2)) continue;
                        test1 = false;
                        entropy2 = entropyLast;
                        alpha2 = alphaLast;
                    }
                }
                nex = extrap.size() / 2 - 20;
                alphaex = new double[nex];
                entroex = new double[nex];
                ii = -1;
                i = 0;
                while (i < nex) {
                    alphaex[i] = (Double)extrap.get(++ii);
                    entroex[i] = Math.log((Double)extrap.get(++ii) - entropyMin);
                    ++i;
                }
                reg = new Regression(alphaex, entroex);
                reg.linear();
                param = reg.getCoeff();
                entropy = Math.exp(param[0] + param[1] * alpha) + entropyMin;
                System.out.println("An interpolated entropy of " + entropy + " returned (see documentation for exponential interpolation)");
                System.out.println("Lowest calculable value =  " + (Math.exp(entroex[nex - 1]) + entropyMin) + ", alpha = " + alphaex[nex - 1]);
                System.out.println("Minimum entropy value =  " + entropyMin + ", alpha = infinity");
                break block15;
            }
            entropy = -Math.log(max);
            System.out.println("Stat: renyiEntropyNat: underflow or overflow in calculating the entropy");
            System.out.println("An interpolated entropy of " + entropy + " returned (see documentation for exponential interpolation)");
        }
        return entropy;
    }

    public static void resetCFmaxIter(int cfMaxIter) {
        Stat.cfMaxIter = cfMaxIter;
    }

    public static void resetCFtolerance(double cfTol) {
        Stat.cfTol = cfTol;
    }

    public static double rms(BigDecimal[] aa) {
        int n = aa.length;
        BigDecimal sum2 = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            sum2 = sum2.add(aa[i].multiply(aa[i]));
            ++i;
        }
        sum2 = sum2.divide(new BigDecimal(n), 4);
        double ret = Math.sqrt(sum2.doubleValue());
        sum2 = null;
        return ret;
    }

    public static double rms(BigDecimal[] aa, BigDecimal[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        BigDecimal sumw = BigDecimal.ZERO;
        BigDecimal[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumw = sumw.add(weight[i]);
            ++i;
        }
        BigDecimal sum2 = BigDecimal.ZERO;
        int i2 = 0;
        while (i2 < n) {
            sum2 = sum2.add(aa[i2].multiply(aa[i2]).multiply(weight[i2]));
            ++i2;
        }
        sum2 = sum2.divide(sumw, 4);
        double ret = Math.sqrt(sum2.doubleValue());
        sum2 = null;
        weight = null;
        return ret;
    }

    public static double rms(BigInteger[] aa) {
        int n = aa.length;
        BigDecimal sum2 = BigDecimal.ZERO;
        BigDecimal bd = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            bd = new BigDecimal(aa[i]);
            sum2 = sum2.add(bd.multiply(bd));
            ++i;
        }
        sum2 = sum2.divide(new BigDecimal(n), 4);
        double ret = Math.sqrt(sum2.doubleValue());
        bd = null;
        sum2 = null;
        return ret;
    }

    public static double rms(BigInteger[] aa, BigInteger[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths amaa = new ArrayMaths(aa);
        ArrayMaths amww = new ArrayMaths(ww);
        return Stat.rms(amaa.array_as_BigDecimal(), amww.array_as_BigDecimal());
    }

    public static double rms(double[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += aa[i] * aa[i];
            ++i;
        }
        return Math.sqrt(sum2 / (double)n);
    }

    public static double rms(double[] aa, double[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double sumw = 0.0;
        double[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumw += weight[i];
            ++i;
        }
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < n) {
            sum2 += weight[i2] * aa[i2] * aa[i2];
            ++i2;
        }
        return Math.sqrt(sum2 / sumw);
    }

    public static float rms(float[] aa) {
        int n = aa.length;
        float sum2 = 0.0f;
        int i = 0;
        while (i < n) {
            sum2 += aa[i] * aa[i];
            ++i;
        }
        return (float)Math.sqrt(sum2 /= (float)n);
    }

    public static float rms(float[] aa, float[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double sumw = 0.0;
        float[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumw += (double)weight[i];
            ++i;
        }
        float sum2 = 0.0f;
        int i2 = 0;
        while (i2 < n) {
            sum2 += weight[i2] * aa[i2] * aa[i2];
            ++i2;
        }
        return (float)Math.sqrt((double)sum2 / sumw);
    }

    public static double[] scale(BigDecimal[] aa, double mean, double sd) {
        double[] bb = Stat.standardize(aa);
        int n = aa.length;
        int i = 0;
        while (i < n) {
            bb[i] = bb[i] * sd + mean;
            ++i;
        }
        return bb;
    }

    public static double[] scale(BigInteger[] aa, double mean, double sd) {
        ArrayMaths am = new ArrayMaths(aa);
        BigDecimal[] bd = am.getArray_as_BigDecimal();
        return Stat.scale(bd, mean, sd);
    }

    public static double[] scale(double[] aa, double mean, double sd) {
        double[] bb = Stat.standardize(aa);
        int n = aa.length;
        int i = 0;
        while (i < n) {
            bb[i] = bb[i] * sd + mean;
            ++i;
        }
        return bb;
    }

    public static float[] scale(float[] aa, float mean, float sd) {
        float[] bb = Stat.standardize(aa);
        int n = aa.length;
        int i = 0;
        while (i < n) {
            bb[i] = bb[i] * sd + mean;
            ++i;
        }
        return bb;
    }

    public static double[] scale(int[] aa, double mean, double sd) {
        double[] bb = Stat.standardize(aa);
        int n = aa.length;
        int i = 0;
        while (i < n) {
            bb[i] = bb[i] * sd + mean;
            ++i;
        }
        return bb;
    }

    public static double[] scale(long[] aa, double mean, double sd) {
        double[] bb = Stat.standardize(aa);
        int n = aa.length;
        int i = 0;
        while (i < n) {
            bb[i] = bb[i] * sd + mean;
            ++i;
        }
        return bb;
    }

    public static BigDecimal secondQuartile(BigDecimal[] aa) {
        return Stat.median(aa);
    }

    public static BigInteger secondQuartile(BigInteger[] aa) {
        return Stat.median(aa);
    }

    public static double secondQuartile(double[] aa) {
        return Stat.median(aa);
    }

    public static float secondQuartile(float[] aa) {
        return Stat.median(aa);
    }

    public static double secondQuartile(int[] aa) {
        return Stat.median(aa);
    }

    public static double secondQuartile(long[] aa) {
        return Stat.median(aa);
    }

    public static void setIncGammaMaxIter(int igfiter) {
        Stat.igfiter = igfiter;
    }

    public static void setIncGammaTol(double igfeps) {
        Stat.igfeps = igfeps;
    }

    public static void setStaticDenominatorToN() {
        nFactorOptionS = true;
    }

    public static void setStaticDenominatorToNminusOne() {
        nFactorOptionS = false;
    }

    public static void setStaticWeightsToBigW() {
        weightingOptionS = false;
    }

    public static void setStaticWeightsToLittleW() {
        weightingOptionS = true;
    }

    public static double shannonEntropy(double[] p) {
        ArrayMaths am = new ArrayMaths(p);
        double max2 = am.getMaximum_as_double();
        if (max2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max2);
        }
        double min2 = am.getMinimum_as_double();
        if (min2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min2);
        }
        double total = am.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
        }
        return am.minusxLog2x().getSum_as_double();
    }

    public static double shannonEntropyBit(double[] p) {
        return Stat.shannonEntropy(p);
    }

    public static double shannonEntropyDit(double[] p) {
        ArrayMaths am = new ArrayMaths(p);
        double max2 = am.getMaximum_as_double();
        if (max2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max2);
        }
        double min2 = am.getMinimum_as_double();
        if (min2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min2);
        }
        double total = am.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
        }
        return am.minusxLog10x().getSum_as_double();
    }

    public static double shannonEntropyNat(double[] p) {
        ArrayMaths am = new ArrayMaths(p);
        double max2 = am.getMaximum_as_double();
        if (max2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max2);
        }
        double min2 = am.getMinimum_as_double();
        if (min2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min2);
        }
        double total = am.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
        }
        return am.minusxLogEx().getSum_as_double();
    }

    public static double standardDeviation(BigDecimal[] aa) {
        return Math.sqrt(Stat.variance(aa).doubleValue());
    }

    public static double standardDeviation(BigDecimal[] aa, BigDecimal[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        return Math.sqrt(Stat.variance(aa, ww).doubleValue());
    }

    public static double standardDeviation(BigInteger[] aa) {
        return Math.sqrt(Stat.variance(aa).doubleValue());
    }

    public static double standardDeviation(BigInteger[] aa, BigInteger[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        return Math.sqrt(Stat.variance(aa, ww).doubleValue());
    }

    public static Complex standardDeviation(Complex[] aa) {
        return Complex.sqrt(Stat.variance(aa));
    }

    public static Complex standardDeviation(Complex[] aa, Complex[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        return Complex.sqrt(Stat.variance(aa, ww));
    }

    public static double standardDeviation(double[] aa) {
        return Math.sqrt(Stat.variance(aa));
    }

    public static double standardDeviation(double[] aa, double[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        return Math.sqrt(Stat.variance(aa, ww));
    }

    public static float standardDeviation(float[] aa) {
        return (float)Math.sqrt(Stat.variance(aa));
    }

    public static float standardDeviation(float[] aa, float[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        return (float)Math.sqrt(Stat.variance(aa, ww));
    }

    public static double standardDeviation(int[] aa) {
        return Math.sqrt(Stat.variance(aa));
    }

    public static double standardDeviation(long[] aa) {
        return Math.sqrt(Stat.variance(aa));
    }

    public static double standardDeviationConjugateCalcn(Complex[] aa) {
        return Math.sqrt(Stat.varianceConjugateCalcn(aa));
    }

    public static double standardDeviationConjugateCalcn(Complex[] aa, Complex[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        return Math.sqrt(Stat.varianceConjugateCalcn(aa, ww));
    }

    public static double standardDeviationImaginaryParts(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] im = am.array_as_imaginary_part_of_Complex();
        double standardDeviation = Stat.standardDeviation(im);
        return standardDeviation;
    }

    public static double standardDeviationImaginaryParts(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] im = am.array_as_imaginary_part_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_imaginary_part_of_Complex();
        double standardDeviation = Stat.standardDeviation(im, wt);
        return standardDeviation;
    }

    public static double standardDeviationModuli(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_modulus_of_Complex();
        double standardDeviation = Stat.standardDeviation(rl);
        return standardDeviation;
    }

    public static double standardDeviationModuli(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_modulus_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_modulus_of_Complex();
        double standardDeviation = Stat.standardDeviation(rl, wt);
        return standardDeviation;
    }

    public static double standardDeviationRealParts(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_real_part_of_Complex();
        double standardDeviation = Stat.standardDeviation(rl);
        return standardDeviation;
    }

    public static double standardDeviationRealParts(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_real_part_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_real_part_of_Complex();
        double standardDeviation = Stat.standardDeviation(rl, wt);
        return standardDeviation;
    }

    public static double standardError(BigDecimal[] aa) {
        return Math.sqrt(Stat.variance(aa).doubleValue() / (double)aa.length);
    }

    public static double standardError(BigDecimal[] aa, BigDecimal[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        double effectiveNumber = Stat.effectiveSampleNumber(ww).doubleValue();
        return Math.sqrt(Stat.variance(aa, ww).doubleValue() / effectiveNumber);
    }

    public static double standardError(BigInteger[] aa) {
        return Math.sqrt(Stat.variance(aa).doubleValue() / (double)aa.length);
    }

    public static double standardError(BigInteger[] aa, BigInteger[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        double effectiveNumber = Stat.effectiveSampleNumber(ww).doubleValue();
        return Math.sqrt(Stat.variance(aa, ww).doubleValue() / effectiveNumber);
    }

    public static Complex standardError(Complex[] aa) {
        return Complex.sqrt(Stat.variance(aa).over(aa.length));
    }

    public static Complex standardError(Complex[] aa, Complex[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        Complex effectiveNumber = Stat.effectiveSampleNumber(ww);
        return Complex.sqrt(Stat.variance(aa, ww).over(effectiveNumber));
    }

    public static double standardError(double[] aa) {
        return Math.sqrt(Stat.variance(aa) / (double)aa.length);
    }

    public static double standardError(double[] aa, double[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        double effectiveNumber = Stat.effectiveSampleNumber(ww);
        return Math.sqrt(Stat.variance(aa, ww) / effectiveNumber);
    }

    public static float standardError(float[] aa) {
        return (float)Math.sqrt(Stat.variance(aa) / (float)aa.length);
    }

    public static float standardError(float[] aa, float[] ww) {
        float effectiveNumber = Stat.effectiveSampleNumber(ww);
        return (float)Math.sqrt(Stat.variance(aa, ww) / effectiveNumber);
    }

    public static double standardError(int[] aa) {
        return Math.sqrt(Stat.variance(aa) / (double)aa.length);
    }

    public static double standardError(long[] aa) {
        return Math.sqrt(Stat.variance(aa) / (double)aa.length);
    }

    public static double standardErrorConjugateCalcn(Complex[] aa) {
        return Math.sqrt(Stat.varianceConjugateCalcn(aa) / (double)aa.length);
    }

    public static double standardErrorConjugateCalcn(Complex[] aa, Complex[] ww) {
        if (aa.length != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + aa.length + " and length of weight array, " + ww.length + " are different");
        }
        double effectiveNumber = Stat.effectiveSampleNumberConjugateCalcn(ww);
        return Math.sqrt(Stat.varianceConjugateCalcn(aa, ww) / effectiveNumber);
    }

    public static double standardErrorImaginaryParts(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] im = am.array_as_imaginary_part_of_Complex();
        return Stat.standardError(im);
    }

    public static double standardErrorImaginaryParts(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] im = am.array_as_imaginary_part_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_imaginary_part_of_Complex();
        return Stat.standardError(im, wt);
    }

    public static double standardErrorModuli(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_modulus_of_Complex();
        return Stat.standardError(rl);
    }

    public static double standardErrorModuli(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_modulus_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_modulus_of_Complex();
        return Stat.standardError(rl, wt);
    }

    public static double standardErrorRealParts(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_real_part_of_Complex();
        return Stat.standardError(rl);
    }

    public static double standardErrorRealParts(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_real_part_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_real_part_of_Complex();
        return Stat.standardError(rl, wt);
    }

    public static double[] standardise(BigDecimal[] aa) {
        return Stat.standardize(aa);
    }

    public static double[] standardise(BigInteger[] aa) {
        return Stat.standardize(aa);
    }

    public static double[] standardise(double[] aa) {
        return Stat.standardize(aa);
    }

    public static float[] standardise(float[] aa) {
        return Stat.standardize(aa);
    }

    public static double[] standardise(int[] aa) {
        return Stat.standardize(aa);
    }

    public static double[] standardise(long[] aa) {
        return Stat.standardize(aa);
    }

    public static double[] standardize(BigDecimal[] aa) {
        double mean0 = Stat.mean(aa).doubleValue();
        double sd0 = Stat.standardDeviation(aa);
        int n = aa.length;
        double[] bb = new double[n];
        if (sd0 == 0.0) {
            int i = 0;
            while (i < n) {
                bb[i] = 1.0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                bb[i] = (aa[i].doubleValue() - mean0) / sd0;
                ++i;
            }
        }
        return bb;
    }

    public static double[] standardize(BigInteger[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        BigDecimal[] bd = am.getArray_as_BigDecimal();
        return Stat.standardize(bd);
    }

    public static double[] standardize(double[] aa) {
        double mean0 = Stat.mean(aa);
        double sd0 = Stat.standardDeviation(aa);
        int n = aa.length;
        double[] bb = new double[n];
        if (sd0 == 0.0) {
            int i = 0;
            while (i < n) {
                bb[i] = 1.0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                bb[i] = (aa[i] - mean0) / sd0;
                ++i;
            }
        }
        return bb;
    }

    public static float[] standardize(float[] aa) {
        float mean0 = Stat.mean(aa);
        float sd0 = Stat.standardDeviation(aa);
        int n = aa.length;
        float[] bb = new float[n];
        if ((double)sd0 == 0.0) {
            int i = 0;
            while (i < n) {
                bb[i] = 1.0f;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                bb[i] = (aa[i] - mean0) / sd0;
                ++i;
            }
        }
        return bb;
    }

    public static double[] standardize(int[] aa) {
        double mean0 = Stat.mean(aa);
        double sd0 = Stat.standardDeviation(aa);
        int n = aa.length;
        double[] bb = new double[n];
        if (sd0 == 0.0) {
            int i = 0;
            while (i < n) {
                bb[i] = 1.0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                bb[i] = ((double)aa[i] - mean0) / sd0;
                ++i;
            }
        }
        return bb;
    }

    public static double[] standardize(long[] aa) {
        double mean0 = Stat.mean(aa);
        double sd0 = Stat.standardDeviation(aa);
        int n = aa.length;
        double[] bb = new double[n];
        if (sd0 == 0.0) {
            int i = 0;
            while (i < n) {
                bb[i] = 1.0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                bb[i] = ((double)aa[i] - mean0) / sd0;
                ++i;
            }
        }
        return bb;
    }

    public static double studentst(double tValue, int df) {
        return Stat.studentT(tValue, df);
    }

    public static double studentstCDF(double tValue, int df) {
        return Stat.studentTcdf(tValue, df);
    }

    public static double studentstMean(int df) {
        return Stat.studentTmean(df);
    }

    public static double studentstMedian() {
        return 0.0;
    }

    public static double studentstMode() {
        return 0.0;
    }

    public static double studentstPDF(double tValue, int df) {
        return Stat.studentTpdf(tValue, df);
    }

    public static double[] studentstRand(int nu, int n) {
        return Stat.studentTRand(nu, n);
    }

    public static double[] studentstRand(int nu, int n, long seed) {
        return Stat.studentTrand(nu, n, seed);
    }

    public static double studentstStandardDeviation(int df) {
        return Stat.studentTstandDev(df);
    }

    public static double studentT(double tValue, int df) {
        if (tValue != tValue) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double ddf = df;
        double dfterm = (ddf + 1.0) / 2.0;
        return Stat.gamma(dfterm) / Stat.gamma(ddf / 2.0) / Math.sqrt(ddf * Math.PI) * Math.pow(1.0 + tValue * tValue / ddf, -dfterm);
    }

    public static double studentTcdf(double tValueLower, double tValueUpper, int df) {
        if (tValueLower != tValueLower) {
            throw new IllegalArgumentException("argument tLowerValue is not a number (NaN)");
        }
        if (tValueUpper != tValueUpper) {
            throw new IllegalArgumentException("argument tUpperValue is not a number (NaN)");
        }
        if (tValueUpper == Double.POSITIVE_INFINITY) {
            if (tValueLower == Double.NEGATIVE_INFINITY) {
                return 1.0;
            }
            if (tValueLower == Double.POSITIVE_INFINITY) {
                return 0.0;
            }
            return 1.0 - Stat.studentTcdf(tValueLower, df);
        }
        if (tValueLower == Double.NEGATIVE_INFINITY) {
            if (tValueUpper == Double.NEGATIVE_INFINITY) {
                return 0.0;
            }
            return Stat.studentTcdf(tValueUpper, df);
        }
        return Stat.studentTcdf(tValueUpper, df) - Stat.studentTcdf(tValueLower, df);
    }

    public static double studentTcdf(double tValue, int df) {
        if (tValue != tValue) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        if (tValue == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (tValue == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double ddf = df;
        double x2 = ddf / (ddf + tValue * tValue);
        return 0.5 * (1.0 + (Stat.regularisedBetaFunction(ddf / 2.0, 0.5, 1.0) - Stat.regularisedBetaFunction(ddf / 2.0, 0.5, x2)) * Fmath.sign(tValue));
    }

    public static double studentTCDF(double tValue, int df) {
        if (tValue != tValue) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        if (tValue == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (tValue == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double ddf = df;
        double x2 = ddf / (ddf + tValue * tValue);
        return 0.5 * (1.0 + (Stat.regularisedBetaFunction(ddf / 2.0, 0.5, 1.0) - Stat.regularisedBetaFunction(ddf / 2.0, 0.5, x2)) * Fmath.sign(tValue));
    }

    public static double studentTmean(int df) {
        double mean = Double.NaN;
        if (df > 1) {
            mean = 0.0;
        }
        return mean;
    }

    public static double studentTmedian() {
        return 0.0;
    }

    public static double studentTmode() {
        return 0.0;
    }

    public static double studentTpdf(double tValue, int df) {
        if (tValue != tValue) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double ddf = df;
        double dfterm = (ddf + 1.0) / 2.0;
        return Stat.gamma(dfterm) / Stat.gamma(ddf / 2.0) / Math.sqrt(ddf * Math.PI) * Math.pow(1.0 + tValue * tValue / ddf, -dfterm);
    }

    public static double studentTPDF(double tValue, int df) {
        if (tValue != tValue) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double ddf = df;
        double dfterm = (ddf + 1.0) / 2.0;
        return Stat.gamma(dfterm) / Stat.gamma(ddf / 2.0) / Math.sqrt(ddf * Math.PI) * Math.pow(1.0 + tValue * tValue / ddf, -dfterm);
    }

    public static double studentTProb(double tValue, int df) {
        if (tValue != tValue) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        if (tValue == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (tValue == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double ddf = df;
        double x2 = ddf / (ddf + tValue * tValue);
        return 0.5 * (1.0 + (Stat.regularisedBetaFunction(ddf / 2.0, 0.5, 1.0) - Stat.regularisedBetaFunction(ddf / 2.0, 0.5, x2)) * Fmath.sign(tValue));
    }

    public static double[] studentTrand(int nu, int n) {
        PsRandom psr = new PsRandom();
        return psr.studentTarray(nu, n);
    }

    public static double[] studentTrand(int nu, int n, long seed) {
        PsRandom psr = new PsRandom(seed);
        return psr.studentTarray(nu, n);
    }

    public static double[] studentTRand(int nu, int n) {
        PsRandom psr = new PsRandom();
        return psr.studentTarray(nu, n);
    }

    public static double[] studentTRand(int nu, int n, long seed) {
        PsRandom psr = new PsRandom(seed);
        return psr.studentTarray(nu, n);
    }

    public static double studentTstandDev(int df) {
        double standDev = Double.POSITIVE_INFINITY;
        if (df > 2) {
            standDev = Math.sqrt(df / (1 - df));
        }
        return standDev;
    }

    public static BigDecimal[] subtractMean(BigDecimal[] array) {
        int n = array.length;
        BigDecimal mean = Stat.mean(array);
        BigDecimal[] arrayMinusMean = new BigDecimal[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i].subtract(mean);
            ++i;
        }
        mean = null;
        return arrayMinusMean;
    }

    public static BigDecimal[] subtractMean(BigDecimal[] array, BigDecimal[] weights) {
        int n = array.length;
        BigDecimal mean = Stat.mean(array, weights);
        BigDecimal[] arrayMinusMean = new BigDecimal[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i].subtract(mean);
            ++i;
        }
        mean = null;
        return arrayMinusMean;
    }

    public static BigDecimal[] subtractMean(BigInteger[] array) {
        int n = array.length;
        BigDecimal mean = Stat.mean(array);
        BigDecimal[] arrayMinusMean = new BigDecimal[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = new BigDecimal(array[i]).subtract(mean);
            ++i;
        }
        mean = null;
        return arrayMinusMean;
    }

    public static BigDecimal[] subtractMean(BigInteger[] array, BigInteger[] weights) {
        int n = array.length;
        BigDecimal mean = Stat.mean(array, weights);
        BigDecimal[] arrayMinusMean = new BigDecimal[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = new BigDecimal(array[i]).subtract(mean);
            ++i;
        }
        mean = null;
        return arrayMinusMean;
    }

    public static Complex[] subtractMean(Complex[] array) {
        int n = array.length;
        Complex mean = Stat.mean(array);
        Complex[] arrayMinusMean = new Complex[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i].minus(mean);
            ++i;
        }
        return arrayMinusMean;
    }

    public static Complex[] subtractMean(Complex[] array, Complex[] weights) {
        int n = array.length;
        Complex mean = Stat.mean(array, weights);
        Complex[] arrayMinusMean = new Complex[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i].minus(mean);
            ++i;
        }
        return arrayMinusMean;
    }

    public static double[] subtractMean(double[] array) {
        int n = array.length;
        double mean = Stat.mean(array);
        double[] arrayMinusMean = new double[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i] - mean;
            ++i;
        }
        return arrayMinusMean;
    }

    public static double[] subtractMean(double[] array, double[] weights) {
        int n = array.length;
        double mean = Stat.mean(array, weights);
        double[] arrayMinusMean = new double[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i] - mean;
            ++i;
        }
        return arrayMinusMean;
    }

    public static float[] subtractMean(float[] array) {
        int n = array.length;
        float mean = Stat.mean(array);
        float[] arrayMinusMean = new float[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i] - mean;
            ++i;
        }
        return arrayMinusMean;
    }

    public static float[] subtractMean(float[] array, float[] weights) {
        int n = array.length;
        float mean = Stat.mean(array, weights);
        float[] arrayMinusMean = new float[n];
        int i = 0;
        while (i < n) {
            arrayMinusMean[i] = array[i] - mean;
            ++i;
        }
        return arrayMinusMean;
    }

    public static double tsallisEntropyNat(double[] p, double q) {
        ArrayMaths am = new ArrayMaths(p);
        double max2 = am.getMaximum_as_double();
        if (max2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + max2);
        }
        double min2 = am.getMinimum_as_double();
        if (min2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + min2);
        }
        double total = am.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(total, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + total);
        }
        if (q == 1.0) {
            return Stat.shannonEntropyNat(p);
        }
        am = am.pow(q);
        return (1.0 - am.getSum_as_double()) / (q - 1.0);
    }

    public static double[] uniformOrderStatisticMedians(int n) {
        double nn = n;
        double[] uosm = new double[n];
        uosm[n - 1] = Math.pow(0.5, 1.0 / nn);
        uosm[0] = 1.0 - uosm[n - 1];
        int i = 1;
        while (i < n - 1) {
            uosm[i] = ((double)(i + 1) - 0.3175) / (nn + 0.365);
            ++i;
        }
        return uosm;
    }

    public static Vector<Object> upperOutliersAnscombe(BigDecimal[] values2, BigDecimal constant) {
        return Stat.upperOutliersAnscombeAsVector(values2, constant);
    }

    public static Vector<Object> upperOutliersAnscombe(BigInteger[] values2, BigInteger constant) {
        return Stat.upperOutliersAnscombeAsVector(values2, constant);
    }

    public static Vector<Object> upperOutliersAnscombe(double[] values2, double constant) {
        return Stat.upperOutliersAnscombeAsVector(values2, constant);
    }

    public static ArrayList<Object> upperOutliersAnscombeAsArrayList(BigDecimal[] values2, BigDecimal constant) {
        Stat am = new Stat(values2);
        BigDecimal[] copy0 = am.getArray_as_BigDecimal();
        BigDecimal[] copy1 = am.getArray_as_BigDecimal();
        int nValues = values2.length;
        ArrayList<Number> outers = new ArrayList<Number>();
        int nOutliers = 0;
        boolean test2 = true;
        while (test2) {
            BigDecimal mean = am.mean_as_BigDecimal();
            BigDecimal variance = am.variance_as_BigDecimal();
            BigDecimal max2 = am.getMaximum_as_BigDecimal();
            int maxIndex = am.getMaximumIndex();
            BigDecimal statistic = max2.subtract(mean).divide(variance, 4);
            if (statistic.compareTo(constant.multiply(constant)) == 1) {
                outers.add(max2);
                outers.add(new Integer(maxIndex));
                ++nOutliers;
                copy1 = new BigDecimal[nValues - 1];
                int i = maxIndex;
                while (i < nValues - 1) {
                    copy1[i] = copy0[i + 1];
                    ++i;
                }
                --nValues;
                am = new Stat(Conv.copy(copy1));
                continue;
            }
            mean = null;
            variance = null;
            statistic = null;
            copy0 = null;
            test2 = false;
        }
        BigDecimal[] outliers = null;
        int[] outIndices = null;
        if (nOutliers > 0) {
            outliers = new BigDecimal[nOutliers];
            outIndices = new int[nOutliers];
            int i = 0;
            while (i < nOutliers) {
                outliers[i] = (BigDecimal)outers.get(2 * i);
                outIndices[i] = (Integer)outers.get(2 * i + 1);
                ++i;
            }
        }
        ArrayList<Object> ret = new ArrayList<Object>(4);
        ret.add(new Integer(nOutliers));
        ret.add(outliers);
        ret.add(outIndices);
        ret.add(copy1);
        return ret;
    }

    public static ArrayList<Object> upperOutliersAnscombeAsArrayList(BigInteger[] values2, BigInteger constant) {
        ArrayMaths am = new ArrayMaths(values2);
        BigDecimal[] bd = am.getArray_as_BigDecimal();
        BigDecimal cd = new BigDecimal(constant);
        return Stat.upperOutliersAnscombeAsArrayList(bd, cd);
    }

    public static ArrayList<Object> upperOutliersAnscombeAsArrayList(double[] values2, double constant) {
        Stat am = new Stat(values2);
        double[] copy0 = am.getArray_as_double();
        double[] copy1 = am.getArray_as_double();
        int nValues = values2.length;
        ArrayList<Number> outers = new ArrayList<Number>();
        int nOutliers = 0;
        boolean test2 = true;
        while (test2) {
            double mean = am.mean_as_double();
            double standDev = am.standardDeviation_as_double();
            double max2 = am.getMaximum_as_double();
            int maxIndex = am.getMaximumIndex();
            double statistic = (max2 - mean) / standDev;
            if (statistic > constant) {
                outers.add(new Double(max2));
                outers.add(new Integer(maxIndex));
                ++nOutliers;
                copy1 = new double[nValues - 1];
                int i = maxIndex;
                while (i < nValues - 1) {
                    copy1[i] = copy0[i + 1];
                    ++i;
                }
                --nValues;
                am = new Stat(Conv.copy(copy1));
                continue;
            }
            test2 = false;
        }
        double[] outliers = null;
        int[] outIndices = null;
        if (nOutliers > 0) {
            outliers = new double[nOutliers];
            outIndices = new int[nOutliers];
            int i = 0;
            while (i < nOutliers) {
                outliers[i] = (Double)outers.get(2 * i);
                outIndices[i] = (Integer)outers.get(2 * i + 1);
                ++i;
            }
        }
        ArrayList<Object> ret = new ArrayList<Object>(4);
        ret.add(new Integer(nOutliers));
        ret.add(outliers);
        ret.add(outIndices);
        ret.add(copy1);
        return ret;
    }

    public static Vector<Object> upperOutliersAnscombeAsVector(BigDecimal[] values2, BigDecimal constant) {
        ArrayList<Object> res = Stat.upperOutliersAnscombeAsArrayList(values2, constant);
        Vector<Object> ret = null;
        if (res != null) {
            int n = res.size();
            ret = new Vector<Object>(n);
            int i = 0;
            while (i < n) {
                ret.add(res.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static Vector<Object> upperOutliersAnscombeAsVector(BigInteger[] values2, BigInteger constant) {
        ArrayList<Object> res = Stat.upperOutliersAnscombeAsArrayList(values2, constant);
        Vector<Object> ret = null;
        if (res != null) {
            int n = res.size();
            ret = new Vector<Object>(n);
            int i = 0;
            while (i < n) {
                ret.add(res.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static Vector<Object> upperOutliersAnscombeAsVector(double[] values2, double constant) {
        ArrayList<Object> res = Stat.upperOutliersAnscombeAsArrayList(values2, constant);
        Vector<Object> ret = null;
        if (res != null) {
            int n = res.size();
            ret = new Vector<Object>(n);
            int i = 0;
            while (i < n) {
                ret.add(res.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static void useStaticEffectiveN() {
        nEffOptionS = true;
    }

    public static void useStaticTrueN() {
        nEffOptionS = false;
    }

    public static BigDecimal variance(BigDecimal[] aa) {
        int n = aa.length;
        BigDecimal sum2 = BigDecimal.ZERO;
        BigDecimal mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            BigDecimal hold = aa[i].subtract(mean);
            sum2 = sum2.add(hold.multiply(hold));
            ++i;
        }
        BigDecimal ret = sum2.divide(new BigDecimal((double)(n - 1)), 4);
        if (nFactorOptionS) {
            ret = sum2.divide(new BigDecimal((double)n), 4);
        }
        sum2 = null;
        mean = null;
        return ret;
    }

    public static BigDecimal variance(BigDecimal[] aa, BigDecimal[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        BigDecimal nn = Stat.effectiveSampleNumber(ww);
        BigDecimal nterm = nn.divide(nn.subtract(BigDecimal.ONE), 4);
        if (nFactorOptionS) {
            nterm = BigDecimal.ONE;
        }
        BigDecimal sumx = BigDecimal.ZERO;
        BigDecimal sumw = BigDecimal.ZERO;
        BigDecimal mean = BigDecimal.ZERO;
        BigDecimal[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumx = sumx.add(aa[i].multiply(weight[i]));
            sumw = sumw.add(weight[i]);
            ++i;
        }
        mean = sumx.divide(sumw, 4);
        sumx = BigDecimal.ZERO;
        i = 0;
        while (i < n) {
            sumx = sumx.add(weight[i].multiply(aa[i].subtract(mean)).multiply(aa[i].subtract(mean)));
            ++i;
        }
        sumx = sumx.multiply(nterm).divide(sumw, 4);
        sumw = null;
        mean = null;
        weight = null;
        nn = null;
        nterm = null;
        return sumx;
    }

    public static BigDecimal variance(BigInteger[] aa) {
        int n = aa.length;
        BigDecimal sum2 = BigDecimal.ZERO;
        BigDecimal mean = BigDecimal.ZERO;
        int i = 0;
        while (i < n) {
            sum2 = sum2.add(new BigDecimal(aa[i]));
            ++i;
        }
        mean = sum2.divide(new BigDecimal((double)n), 4);
        sum2 = BigDecimal.ZERO;
        i = 0;
        while (i < n) {
            BigDecimal hold = new BigDecimal(aa[i]).subtract(mean);
            sum2 = sum2.add(hold.multiply(hold));
            ++i;
        }
        BigDecimal ret = sum2.divide(new BigDecimal((double)(n - 1)), 4);
        if (nFactorOptionS) {
            ret = sum2.divide(new BigDecimal((double)n), 4);
        }
        sum2 = null;
        mean = null;
        return ret;
    }

    public static BigDecimal variance(BigInteger[] aa, BigInteger[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths aab = new ArrayMaths(aa);
        ArrayMaths wwb = new ArrayMaths(ww);
        return Stat.variance(aab.array_as_BigDecimal(), wwb.array_as_BigDecimal());
    }

    public static Complex variance(Complex[] aa) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        Complex mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            Complex hold = new Complex(aa[i]).minus(mean);
            sum2 = sum2.plus(hold.times(hold));
            ++i;
        }
        Complex ret = sum2.over(new Complex(n - 1));
        if (nFactorOptionS) {
            ret = sum2.over(new Complex(n));
        }
        return ret;
    }

    public static Complex variance(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        Complex nn = Stat.effectiveSampleNumber(ww);
        Complex nterm = nn.over(nn.minus(1.0));
        if (nFactorOptionS) {
            nterm = Complex.plusOne();
        }
        Complex sumx = Complex.zero();
        Complex sumw = Complex.zero();
        Complex mean = Complex.zero();
        Complex[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumx = sumx.plus(aa[i].times(weight[i]));
            sumw = sumw.plus(weight[i]);
            ++i;
        }
        mean = sumx.over(sumw);
        sumx = Complex.zero();
        i = 0;
        while (i < n) {
            Complex hold = aa[i].minus(mean);
            sumx = sumx.plus(weight[i].times(hold).times(hold));
            ++i;
        }
        return sumx.times(nterm).over(sumw);
    }

    public static double variance(double[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum2 += Fmath.square(aa[i] - mean);
            ++i;
        }
        double ret = sum2 / (double)(n - 1);
        if (nFactorOptionS) {
            ret = sum2 / (double)n;
        }
        return ret;
    }

    public static double variance(double[] aa, double[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double nn = Stat.effectiveSampleNumber(ww);
        double nterm = nn / (nn - 1.0);
        if (nFactorOptionS) {
            nterm = 1.0;
        }
        double sumx = 0.0;
        double sumw = 0.0;
        double mean = 0.0;
        double[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumx += aa[i] * weight[i];
            sumw += weight[i];
            ++i;
        }
        mean = sumx / sumw;
        sumx = 0.0;
        i = 0;
        while (i < n) {
            sumx += weight[i] * Fmath.square(aa[i] - mean);
            ++i;
        }
        return sumx * nterm / sumw;
    }

    public static float variance(float[] aa) {
        int n = aa.length;
        float sum2 = 0.0f;
        float mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Fmath.square(aa[i] - mean);
            ++i;
        }
        float ret = sum2 / (float)(n - 1);
        if (nFactorOptionS) {
            ret = sum2 / (float)n;
        }
        return ret;
    }

    public static float variance(float[] aa, float[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        float nn = Stat.effectiveSampleNumber(ww);
        float nterm = nn / (nn - 1.0f);
        if (nFactorOptionS) {
            nterm = 1.0f;
        }
        float sumx = 0.0f;
        float sumw = 0.0f;
        float mean = 0.0f;
        float[] weight = Stat.invertAndSquare(ww);
        int i = 0;
        while (i < n) {
            sumx += aa[i] * weight[i];
            sumw += weight[i];
            ++i;
        }
        mean = sumx / sumw;
        sumx = 0.0f;
        i = 0;
        while (i < n) {
            sumx += weight[i] * Fmath.square(aa[i] - mean);
            ++i;
        }
        return sumx * nterm / sumw;
    }

    public static double variance(int[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Fmath.square((double)aa[i] - mean);
            ++i;
        }
        double ret = sum2 / (double)(n - 1);
        if (nFactorOptionS) {
            ret = sum2 / (double)n;
        }
        return ret;
    }

    public static double variance(long[] aa) {
        int n = aa.length;
        double sum2 = 0.0;
        double mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            sum2 += Fmath.square((double)aa[i] - mean);
            ++i;
        }
        double ret = sum2 / (double)(n - 1);
        if (nFactorOptionS) {
            ret = sum2 / (double)n;
        }
        return ret;
    }

    public static double varianceConjugateCalcn(Complex[] aa) {
        int n = aa.length;
        Complex sum2 = Complex.zero();
        Complex mean = Stat.mean(aa);
        int i = 0;
        while (i < n) {
            Complex hold = new Complex(aa[i]).minus(mean);
            sum2 = sum2.plus(hold.times(hold.conjugate()));
            ++i;
        }
        double ret = sum2.getReal() / (double)(n - 1);
        if (nFactorOptionS) {
            ret = sum2.getReal() / (double)n;
        }
        return ret;
    }

    public static double varianceConjugateCalcn(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        double nn = Stat.effectiveSampleNumberConjugateCalcn(ww);
        double nterm = nn / (nn - 1.0);
        if (nFactorOptionS) {
            nterm = 1.0;
        }
        Complex sumx = Complex.zero();
        Complex sumw = Complex.zero();
        Complex sumwc = Complex.zero();
        Complex mean = Complex.zero();
        ArrayMaths st = new ArrayMaths(ww);
        st = st.invert();
        Complex[] weight = st.array_as_Complex();
        int i = 0;
        while (i < n) {
            sumx = sumx.plus(aa[i].times(weight[i].times(weight[i])));
            sumw = sumw.plus(weight[i].times(weight[i]));
            sumwc = sumwc.plus(weight[i].times(weight[i].conjugate()));
            ++i;
        }
        mean = sumx.over(sumw);
        sumx = Complex.zero();
        i = 0;
        while (i < n) {
            Complex hold = aa[i].minus(mean);
            sumx = sumx.plus(weight[i].times(weight[i].conjugate()).times(hold).times(hold.conjugate()));
            ++i;
        }
        return nterm * sumx.times(nterm).over(sumwc).getReal();
    }

    public static double varianceImaginaryParts(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] im = am.array_as_imaginary_part_of_Complex();
        double variance = Stat.variance(im);
        return variance;
    }

    public static double varianceImaginaryParts(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] im = am.array_as_imaginary_part_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_imaginary_part_of_Complex();
        double variance = Stat.variance(im, wt);
        return variance;
    }

    public static double varianceModuli(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_modulus_of_Complex();
        double variance = Stat.variance(rl);
        return variance;
    }

    public static double varianceModuli(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_modulus_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_modulus_of_Complex();
        double variance = Stat.variance(rl, wt);
        return variance;
    }

    public static double varianceRealParts(Complex[] aa) {
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_real_part_of_Complex();
        double variance = Stat.variance(rl);
        return variance;
    }

    public static double varianceRealParts(Complex[] aa, Complex[] ww) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        ArrayMaths am = new ArrayMaths(aa);
        double[] rl = am.array_as_real_part_of_Complex();
        ArrayMaths wm = new ArrayMaths(ww);
        double[] wt = wm.array_as_real_part_of_Complex();
        double variance = Stat.variance(rl, wt);
        return variance;
    }

    public static double volatilityLogChange(BigDecimal[] array) {
        int n = array.length - 1;
        double[] change = new double[n];
        int i = 0;
        while (i < n) {
            change[i] = Math.log(array[i + 1].divide(array[i], 4).doubleValue());
            ++i;
        }
        return Stat.standardDeviation(change);
    }

    public static double volatilityLogChange(BigInteger[] array) {
        int n = array.length - 1;
        double[] change = new double[n];
        int i = 0;
        while (i < n) {
            change[i] = Math.log(new BigDecimal(array[i + 1]).divide(new BigDecimal(array[i]), 4).doubleValue());
            ++i;
        }
        return Stat.standardDeviation(change);
    }

    public static double volatilityLogChange(double[] array) {
        int n = array.length - 1;
        double[] change = new double[n];
        int i = 0;
        while (i < n) {
            change[i] = Math.log(array[i + 1] / array[i]);
            ++i;
        }
        return Stat.standardDeviation(change);
    }

    public static float volatilityLogChange(float[] array) {
        int n = array.length - 1;
        float[] change = new float[n];
        int i = 0;
        while (i < n) {
            change[i] = (float)Math.log(array[i + 1] / array[i]);
            ++i;
        }
        return Stat.standardDeviation(change);
    }

    public static double volatilityPerCentChange(BigDecimal[] array) {
        int n = array.length - 1;
        double[] change = new double[n];
        int i = 0;
        while (i < n) {
            change[i] = array[i + 1].add(array[i]).multiply(new BigDecimal(100.0).divide(array[i], 4)).doubleValue();
            ++i;
        }
        return Stat.standardDeviation(change);
    }

    public static double volatilityPerCentChange(BigInteger[] array) {
        int n = array.length - 1;
        double[] change = new double[n];
        ArrayMaths am = new ArrayMaths(array);
        BigDecimal[] bd = am.getArray_as_BigDecimal();
        int i = 0;
        while (i < n) {
            change[i] = bd[i + 1].add(bd[i]).multiply(new BigDecimal(100.0).divide(bd[i], 4)).doubleValue();
            ++i;
        }
        bd = null;
        return Stat.standardDeviation(change);
    }

    public static double volatilityPerCentChange(double[] array) {
        int n = array.length - 1;
        double[] change = new double[n];
        int i = 0;
        while (i < n) {
            change[i] = (array[i + 1] - array[i]) * 100.0 / array[i];
            ++i;
        }
        return Stat.standardDeviation(change);
    }

    public static double volatilityPerCentChange(float[] array) {
        int n = array.length - 1;
        float[] change = new float[n];
        int i = 0;
        while (i < n) {
            change[i] = (array[i + 1] - array[i]) * 100.0f / array[i];
            ++i;
        }
        return Stat.standardDeviation(change);
    }

    public static double weibull(double mu, double sigma, double gamma2, double x2) {
        double arg = (x2 - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = gamma2 / sigma * Math.pow(arg, gamma2 - 1.0) * Math.exp(-Math.pow(arg, gamma2));
        }
        return y;
    }

    public static double weibullCDF(double mu, double sigma, double gamma2, double upperlimit) {
        double arg = (upperlimit - mu) / sigma;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-Math.pow(arg, gamma2));
        }
        return y;
    }

    public static double weibullCDF(double mu, double sigma, double gamma2, double lowerlimit, double upperlimit) {
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = -Math.exp(-Math.pow(arg1, gamma2));
        }
        if (arg2 >= 0.0) {
            term2 = -Math.exp(-Math.pow(arg2, gamma2));
        }
        return term2 - term1;
    }

    public static double weibullInverseCDF(double gamma2, double prob) {
        return Stat.weibullInverseCDF(0.0, 1.0, gamma2, prob);
    }

    public static double weibullInverseCDF(double sigma, double gamma2, double prob) {
        return Stat.weibullInverseCDF(0.0, sigma, gamma2, prob);
    }

    public static double weibullInverseCDF(double mu, double sigma, double gamma2, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + prob + ", must lie between 0 and 1 inclusive");
        }
        double icdf = 0.0;
        icdf = prob == 0.0 ? mu : (prob == 1.0 ? Double.POSITIVE_INFINITY : mu + sigma * Math.pow(-Math.log(1.0 - prob), 1.0 / gamma2));
        return icdf;
    }

    public static double weibullMean(double mu, double sigma, double gamma2) {
        return mu + sigma * Stat.gamma(1.0 / gamma2 + 1.0);
    }

    public static double weibullMedian(double mu, double sigma, double gamma2) {
        return mu + sigma * Math.pow(Math.log(2.0), 1.0 / gamma2);
    }

    public static double weibullMode(double mu, double sigma, double gamma2) {
        double y = mu;
        if (gamma2 > 1.0) {
            y = mu + sigma * Math.pow((gamma2 - 1.0) / gamma2, 1.0 / gamma2);
        }
        return y;
    }

    public static double[] weibullOrderStatisticMedians(double mu, double sigma, double gamma2, int n) {
        double[] wosm = new double[n];
        double[] uosm = Stat.uniformOrderStatisticMedians(n);
        int i = 0;
        while (i < n) {
            wosm[i] = Stat.inverseWeibullCDF(mu, sigma, gamma2, uosm[i]);
            ++i;
        }
        return wosm;
    }

    public static double[] weibullOrderStatisticMedians(double sigma, double gamma2, int n) {
        return Stat.weibullOrderStatisticMedians(0.0, sigma, gamma2, n);
    }

    public static double[] weibullOrderStatisticMedians(double gamma2, int n) {
        return Stat.weibullOrderStatisticMedians(0.0, 1.0, gamma2, n);
    }

    public static double weibullPDF(double mu, double sigma, double gamma2, double x2) {
        double arg = (x2 - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = gamma2 / sigma * Math.pow(arg, gamma2 - 1.0) * Math.exp(-Math.pow(arg, gamma2));
        }
        return y;
    }

    public static double weibullProb(double mu, double sigma, double gamma2, double upperlimit) {
        double arg = (upperlimit - mu) / sigma;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-Math.pow(arg, gamma2));
        }
        return y;
    }

    public static double weibullProb(double mu, double sigma, double gamma2, double lowerlimit, double upperlimit) {
        double arg1 = (lowerlimit - mu) / sigma;
        double arg2 = (upperlimit - mu) / sigma;
        double term1 = 0.0;
        double term2 = 0.0;
        if (arg1 >= 0.0) {
            term1 = -Math.exp(-Math.pow(arg1, gamma2));
        }
        if (arg2 >= 0.0) {
            term2 = -Math.exp(-Math.pow(arg2, gamma2));
        }
        return term2 - term1;
    }

    public static double[] weibullRand(double mu, double sigma, double gamma2, int n) {
        double[] ran = new double[n];
        Random rr = new Random();
        int i = 0;
        while (i < n) {
            ran[i] = Math.pow(-Math.log(1.0 - rr.nextDouble()), 1.0 / gamma2) * sigma + mu;
            ++i;
        }
        return ran;
    }

    public static double[] weibullRand(double mu, double sigma, double gamma2, int n, long seed) {
        double[] ran = new double[n];
        Random rr = new Random(seed);
        int i = 0;
        while (i < n) {
            ran[i] = Math.pow(-Math.log(1.0 - rr.nextDouble()), 1.0 / gamma2) * sigma + mu;
            ++i;
        }
        return ran;
    }

    public static double weibullStandardDeviation(double sigma, double gamma2) {
        return Stat.weibullStandDev(sigma, gamma2);
    }

    public static double weibullStandDev(double sigma, double gamma2) {
        double y = Stat.gamma(2.0 / gamma2 + 1.0) - Fmath.square(Stat.gamma(1.0 / gamma2 + 1.0));
        return sigma * Math.sqrt(y);
    }

    public static double weightedGeneralisedMean(BigDecimal[] aa, BigDecimal[] ww, BigDecimal m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public static double weightedGeneralisedMean(BigDecimal[] aa, BigDecimal[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public static double weightedGeneralisedMean(BigInteger[] aa, BigInteger[] ww, BigInteger m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public static double weightedGeneralisedMean(BigInteger[] aa, BigInteger[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public static Complex weightedGeneralisedMean(Complex[] aa, Complex[] ww, Complex m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public static Complex weightedGeneralisedMean(Complex[] aa, Complex[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public static double weightedGeneralisedMean(double[] aa, double[] ww, double m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public static float weightedGeneralisedMean(float[] aa, float[] ww, float m) {
        int n = aa.length;
        if (n != ww.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + ww.length + " are different");
        }
        return Stat.generalisedMean(aa, ww, m);
    }

    public Stat() {
    }

    public Stat(ArrayList<Object> xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(BigDecimal[] xx) {
        super(xx);
    }

    public Stat(BigInteger[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(byte[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Byte[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Complex[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(double[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Double[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(float[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Float[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(int[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Integer[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(long[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Long[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Object[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Phasor[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(short[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Short[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(String[] xx) {
        super(xx);
        this.convertToHighest();
    }

    public Stat(Vector<Object> xx) {
        super(xx);
        this.convertToHighest();
    }

    public double[] binomialRand(double prob, int nTrials, int n) {
        if (nTrials < n) {
            throw new IllegalArgumentException("Number of deviates requested, " + n + ", must be less than the number of trials, " + nTrials);
        }
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + prob + ", must lie between 0 and 1)");
        }
        double[] ran = new double[n];
        Random rr = new Random();
        double binomialDeviate = 0.0;
        double deviateMean = 0.0;
        double testDeviate = 0.0;
        double workingProb = 0.0;
        double logProb = 0.0;
        double probOld = -1.0;
        double probC = -1.0;
        double logProbC = -1.0;
        int nOld = -1;
        double enTrials = 0.0;
        double oldGamma = 0.0;
        double tanW = 0.0;
        double hold0 = 0.0;
        double probOriginalValue = prob;
        int i = 0;
        while (i < n) {
            int jj;
            prob = probOriginalValue;
            workingProb = prob <= 0.5 ? prob : 1.0 - prob;
            deviateMean = (double)nTrials * workingProb;
            if (nTrials < 25) {
                binomialDeviate = 0.0;
                jj = 1;
                while (jj <= nTrials) {
                    if (rr.nextDouble() < workingProb) {
                        binomialDeviate += 1.0;
                    }
                    ++jj;
                }
            } else if (deviateMean < 1.0) {
                double expOfMean = Math.exp(-deviateMean);
                testDeviate = 1.0;
                jj = 0;
                while (jj <= nTrials) {
                    if ((testDeviate *= rr.nextDouble()) < expOfMean) break;
                    ++jj;
                }
                binomialDeviate = jj <= nTrials ? jj : nTrials;
            } else {
                if (nTrials != nOld) {
                    enTrials = nTrials;
                    oldGamma = Stat.logGamma(enTrials + 1.0);
                    nOld = nTrials;
                }
                if (workingProb != probOld) {
                    probC = 1.0 - workingProb;
                    logProb = Math.log(workingProb);
                    logProbC = Math.log(probC);
                    probOld = workingProb;
                }
                double sq = Math.sqrt(2.0 * deviateMean * probC);
                while (true) {
                    double angle;
                    if ((hold0 = sq * (tanW = Math.tan(angle = Math.PI * rr.nextDouble())) + deviateMean) < 0.0 || hold0 >= enTrials + 1.0) {
                        continue;
                    }
                    hold0 = Math.floor(hold0);
                    testDeviate = 1.2 * sq * (1.0 + tanW * tanW) * Math.exp(oldGamma - Stat.logGamma(hold0 + 1.0) - Stat.logGamma(enTrials - hold0 + 1.0) + hold0 * logProb + (enTrials - hold0) * logProbC);
                    if (!(rr.nextDouble() > testDeviate)) break;
                }
                binomialDeviate = hold0;
            }
            if (workingProb != prob) {
                binomialDeviate = (double)nTrials - binomialDeviate;
            }
            ran[i] = binomialDeviate;
            ++i;
        }
        return ran;
    }

    public double[] binomialRand(double prob, int nTrials, int n, long seed) {
        if (nTrials < n) {
            throw new IllegalArgumentException("Number of deviates requested, " + n + ", must be less than the number of trials, " + nTrials);
        }
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + prob + ", must lie between 0 and 1)");
        }
        double[] ran = new double[n];
        Random rr = new Random(seed);
        double binomialDeviate = 0.0;
        double deviateMean = 0.0;
        double testDeviate = 0.0;
        double workingProb = 0.0;
        double logProb = 0.0;
        double probOld = -1.0;
        double probC = -1.0;
        double logProbC = -1.0;
        int nOld = -1;
        double enTrials = 0.0;
        double oldGamma = 0.0;
        double tanW = 0.0;
        double hold0 = 0.0;
        double probOriginalValue = prob;
        int i = 0;
        while (i < n) {
            int jj;
            prob = probOriginalValue;
            workingProb = prob <= 0.5 ? prob : 1.0 - prob;
            deviateMean = (double)nTrials * workingProb;
            if (nTrials < 25) {
                binomialDeviate = 0.0;
                jj = 1;
                while (jj <= nTrials) {
                    if (rr.nextDouble() < workingProb) {
                        binomialDeviate += 1.0;
                    }
                    ++jj;
                }
            } else if (deviateMean < 1.0) {
                double expOfMean = Math.exp(-deviateMean);
                testDeviate = 1.0;
                jj = 0;
                while (jj <= nTrials) {
                    if ((testDeviate *= rr.nextDouble()) < expOfMean) break;
                    ++jj;
                }
                binomialDeviate = jj <= nTrials ? jj : nTrials;
            } else {
                if (nTrials != nOld) {
                    enTrials = nTrials;
                    oldGamma = Stat.logGamma(enTrials + 1.0);
                    nOld = nTrials;
                }
                if (workingProb != probOld) {
                    probC = 1.0 - workingProb;
                    logProb = Math.log(workingProb);
                    logProbC = Math.log(probC);
                    probOld = workingProb;
                }
                double sq = Math.sqrt(2.0 * deviateMean * probC);
                while (true) {
                    double angle;
                    if ((hold0 = sq * (tanW = Math.tan(angle = Math.PI * rr.nextDouble())) + deviateMean) < 0.0 || hold0 >= enTrials + 1.0) {
                        continue;
                    }
                    hold0 = Math.floor(hold0);
                    testDeviate = 1.2 * sq * (1.0 + tanW * tanW) * Math.exp(oldGamma - Stat.logGamma(hold0 + 1.0) - Stat.logGamma(enTrials - hold0 + 1.0) + hold0 * logProb + (enTrials - hold0) * logProbC);
                    if (!(rr.nextDouble() > testDeviate)) break;
                }
                binomialDeviate = hold0;
            }
            if (workingProb != prob) {
                binomialDeviate = (double)nTrials - binomialDeviate;
            }
            ran[i] = binomialDeviate;
            ++i;
        }
        return ran;
    }

    public double coefficientOfVariation() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double coefficientOfVariation = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                coefficientOfVariation = Stat.coefficientOfVariation(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                coefficientOfVariation = Stat.coefficientOfVariation(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex coefficient of variation is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return coefficientOfVariation;
    }

    public void convertBigWtoLittleW() {
        if (!this.weightsSupplied) {
            System.out.println("convertBigWtoLittleW: no weights have been supplied - all weights set to unity");
        } else {
            this.amWeights = this.amWeights.oneOverSqrt();
        }
    }

    @Override
    public void convertToHighest() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                Double[] dd = this.getArray_as_Double();
                this.array.clear();
                int i = 0;
                while (i < this.length) {
                    this.array.add(dd[i]);
                    ++i;
                }
                double[] ww = new double[this.length];
                int i2 = 0;
                while (i2 < this.length) {
                    ww[i2] = 1.0;
                    ++i2;
                }
                this.amWeights = new ArrayMaths(ww);
                this.type = 1;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                this.array.clear();
                int i = 0;
                while (i < this.length) {
                    this.array.add(bd[i]);
                    ++i;
                }
                BigDecimal[] wd = new BigDecimal[this.length];
                int i3 = 0;
                while (i3 < this.length) {
                    wd[i3] = BigDecimal.ONE;
                    ++i3;
                }
                this.amWeights = new ArrayMaths(wd);
                this.type = 12;
                bd = null;
                break;
            }
            case 14: 
            case 15: {
                Complex[] cc = this.getArray_as_Complex();
                this.array.clear();
                int i = 0;
                while (i < this.length) {
                    this.array.add(cc[i]);
                    ++i;
                }
                Complex[] wc = new Complex[this.length];
                int i4 = 0;
                while (i4 < this.length) {
                    wc[i4] = Complex.plusOne();
                    ++i4;
                }
                this.amWeights = new ArrayMaths(wc);
                this.type = 14;
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
    }

    private void convertWeights(ArrayMaths wm) {
        block0 : switch (this.type) {
            case 1: {
                switch (wm.typeIndex()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        Double[] w1 = wm.getArray_as_Double();
                        this.amWeights = new ArrayMaths(w1);
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        BigDecimal[] a2 = this.getArray_as_BigDecimal();
                        int i = 0;
                        while (i < this.length) {
                            this.array.add(a2[i]);
                            ++i;
                        }
                        BigDecimal[] w2 = wm.getArray_as_BigDecimal();
                        this.amWeights = new ArrayMaths(w2);
                        a2 = null;
                        w2 = null;
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        Complex[] a3 = this.getArray_as_Complex();
                        int i = 0;
                        while (i < this.length) {
                            this.array.add(a3[i]);
                            ++i;
                        }
                        Complex[] w3 = wm.getArray_as_Complex();
                        this.amWeights = new ArrayMaths(w3);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
            case 12: {
                switch (wm.typeIndex()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        BigDecimal[] w4 = wm.getArray_as_BigDecimal();
                        this.amWeights = new ArrayMaths(w4);
                        w4 = null;
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        BigDecimal[] w5 = wm.getArray_as_BigDecimal();
                        this.amWeights = new ArrayMaths(w5);
                        w5 = null;
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        Complex[] a6 = this.getArray_as_Complex();
                        int i = 0;
                        while (i < this.length) {
                            this.array.add(a6[i]);
                            ++i;
                        }
                        Complex[] w6 = wm.getArray_as_Complex();
                        this.amWeights = new ArrayMaths(w6);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
            case 14: {
                Complex[] a7 = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    this.array.add(a7[i]);
                    ++i;
                }
                Complex[] w7 = wm.getArray_as_Complex();
                this.amWeights = new ArrayMaths(w7);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
    }

    @Override
    public Stat copy() {
        BigInteger bi;
        long ll;
        int[] hold2;
        Integer hold0;
        Stat am = new Stat();
        am.amWeights = this.amWeights == null ? null : this.amWeights;
        am.weightsSupplied = this.weightsSupplied;
        am.upperOutlierDetails = new ArrayList();
        if (this.upperOutlierDetails.size() != 0) {
            hold0 = (Integer)this.upperOutlierDetails.get(0);
            am.upperOutlierDetails.add(hold0);
            am.upperOutlierDetails.add(this.upperOutlierDetails.get(1));
            hold2 = (int[])this.upperOutlierDetails.get(2);
            am.upperOutlierDetails.add(hold2);
            am.upperOutlierDetails.add(this.upperOutlierDetails.get(3));
        }
        am.upperDone = this.upperDone;
        am.lowerOutlierDetails = new ArrayList();
        if (this.lowerOutlierDetails.size() != 0) {
            hold0 = (Integer)this.lowerOutlierDetails.get(0);
            am.lowerOutlierDetails.add(hold0);
            am.lowerOutlierDetails.add(this.lowerOutlierDetails.get(1));
            hold2 = (int[])this.lowerOutlierDetails.get(2);
            am.lowerOutlierDetails.add(hold2);
            am.lowerOutlierDetails.add(this.lowerOutlierDetails.get(3));
        }
        am.lowerDone = this.lowerDone;
        am.length = this.length;
        am.maxIndex = this.maxIndex;
        am.minIndex = this.minIndex;
        am.sumDone = this.sumDone;
        am.productDone = this.productDone;
        am.sumlongToDouble = this.sumlongToDouble;
        am.productlongToDouble = this.productlongToDouble;
        am.type = this.type;
        am.originalTypes = (int[])(this.originalTypes == null ? null : Conv.copy(this.originalTypes));
        am.sortedIndices = (int[])(this.sortedIndices == null ? null : Conv.copy(this.sortedIndices));
        am.suppressMessages = this.suppressMessages;
        am.minmax = new ArrayList();
        if (this.minmax.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: {
                    double dd = (Double)this.minmax.get(0);
                    am.minmax.add(new Double(dd));
                    dd = (Double)this.minmax.get(1);
                    am.minmax.add(new Double(dd));
                    break;
                }
                case 4: 
                case 5: {
                    ll = (Long)this.minmax.get(0);
                    am.minmax.add(new Double(ll));
                    ll = (Long)this.minmax.get(1);
                    am.minmax.add(new Long(ll));
                    break;
                }
                case 2: 
                case 3: {
                    float ff = ((Float)this.minmax.get(0)).floatValue();
                    am.minmax.add(new Double(ff));
                    ff = ((Float)this.minmax.get(1)).floatValue();
                    am.minmax.add(new Double(ff));
                    break;
                }
                case 6: 
                case 7: {
                    int ii = (Integer)this.minmax.get(0);
                    am.minmax.add(new Integer(ii));
                    ii = ((Double)this.minmax.get(1)).intValue();
                    am.minmax.add(new Integer(ii));
                    break;
                }
                case 8: 
                case 9: {
                    short ss = (Short)this.minmax.get(0);
                    am.minmax.add(new Short(ss));
                    ss = ((Double)this.minmax.get(1)).shortValue();
                    am.minmax.add(new Short(ss));
                    break;
                }
                case 10: 
                case 11: {
                    byte bb = (Byte)this.minmax.get(0);
                    am.minmax.add(new Byte(bb));
                    short ss = ((Byte)this.minmax.get(1)).byteValue();
                    am.minmax.add(new Byte(bb));
                    break;
                }
                case 12: {
                    BigDecimal bd = (BigDecimal)this.minmax.get(0);
                    am.minmax.add(bd);
                    bd = (BigDecimal)this.minmax.get(1);
                    am.minmax.add(bd);
                    bd = null;
                    break;
                }
                case 13: {
                    BigInteger bi2 = (BigInteger)this.minmax.get(0);
                    am.minmax.add(bi2);
                    bi2 = (BigInteger)this.minmax.get(1);
                    am.minmax.add(bi2);
                    bi2 = null;
                    break;
                }
                case 16: 
                case 17: {
                    int iii = (Integer)this.minmax.get(0);
                    am.minmax.add(new Integer(iii));
                    iii = ((Double)this.minmax.get(1)).intValue();
                    am.minmax.add(new Integer(iii));
                }
            }
        }
        am.summ = new ArrayList();
        if (this.summ.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    double dd = (Double)this.summ.get(0);
                    am.summ.add(new Double(dd));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double dd2 = (Double)this.summ.get(0);
                        am.summ.add(new Double(dd2));
                        break;
                    }
                    ll = (Long)this.summ.get(0);
                    am.summ.add(new Long(ll));
                    break;
                }
                case 12: {
                    BigDecimal bd = (BigDecimal)this.summ.get(0);
                    am.summ.add(bd);
                    break;
                }
                case 13: {
                    bi = (BigInteger)this.summ.get(0);
                    am.summ.add(bi);
                    break;
                }
                case 14: {
                    Complex cc = (Complex)this.summ.get(0);
                    am.summ.add(cc);
                    break;
                }
                case 15: {
                    Phasor pp = (Phasor)this.summ.get(0);
                    am.summ.add(pp);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        am.productt = new ArrayList();
        if (this.productt.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    double dd = (Double)this.productt.get(0);
                    am.productt.add(new Double(dd));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double dd2 = (Double)this.productt.get(0);
                        am.productt.add(new Double(dd2));
                        break;
                    }
                    long ll2 = (Long)this.productt.get(0);
                    am.productt.add(new Long(ll2));
                    break;
                }
                case 12: {
                    BigDecimal bd = (BigDecimal)this.productt.get(0);
                    am.productt.add(bd);
                    break;
                }
                case 13: {
                    bi = (BigInteger)this.productt.get(0);
                    am.productt.add(bi);
                    break;
                }
                case 14: {
                    Complex cc = (Complex)this.productt.get(0);
                    am.productt.add(cc);
                    break;
                }
                case 15: {
                    Phasor pp = (Phasor)this.productt.get(0);
                    am.productt.add(pp);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dd = Conv.copy(this.getArray_as_double());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Double(dd[i]));
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                float[] ff = Conv.copy(this.getArray_as_float());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Float(ff[i]));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                long[] ll3 = Conv.copy(this.getArray_as_long());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Long(ll3[i]));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                int[] ii = Conv.copy(this.getArray_as_int());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Integer(ii[i]));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                short[] ss = Conv.copy(this.getArray_as_short());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Short(ss[i]));
                    ++i;
                }
                break;
            }
            case 10: 
            case 11: {
                byte[] bb = Conv.copy(this.getArray_as_byte());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Byte(bb[i]));
                    ++i;
                }
                break;
            }
            case 12: {
                BigDecimal[] bd = Conv.copy(this.getArray_as_BigDecimal());
                int i = 0;
                while (i < this.length) {
                    am.array.add(bd[i]);
                    ++i;
                }
                break;
            }
            case 13: {
                BigInteger[] bi3 = Conv.copy(this.getArray_as_BigInteger());
                int i = 0;
                while (i < this.length) {
                    am.array.add(bi3[i]);
                    ++i;
                }
                break;
            }
            case 14: {
                Complex[] ccc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    am.array.add(ccc[i].copy());
                    ++i;
                }
                break;
            }
            case 15: {
                Phasor[] ppp = this.getArray_as_Phasor();
                int i = 0;
                while (i < this.length) {
                    am.array.add(ppp[i].copy());
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: {
                char[] cc = Conv.copy(this.getArray_as_char());
                int i = 0;
                while (i < this.length) {
                    am.array.add(new Character(cc[i]));
                    ++i;
                }
                break;
            }
            case 18: {
                String[] sss = Conv.copy(this.getArray_as_String());
                int i = 0;
                while (i < this.length) {
                    am.array.add(sss[i]);
                    ++i;
                }
                break;
            }
        }
        return am;
    }

    public double curtosis() {
        return this.kurtosis_as_double();
    }

    public BigDecimal curtosis_as_BigDecimal() {
        return this.kurtosis_as_BigDecimal();
    }

    public double curtosis_as_double() {
        return this.kurtosis_as_double();
    }

    public double curtosisExcess() {
        return this.kurtosisExcess_as_double();
    }

    public BigDecimal curtosisExcess_as_BigDecimal() {
        return this.kurtosisExcess_as_BigDecimal();
    }

    public double curtosisExcess_as_double() {
        return this.kurtosisExcess_as_double();
    }

    public double effectiveSampleNumber() {
        return this.effectiveSampleNumber_as_double();
    }

    public BigDecimal effectiveSampleNumber_as_BigDecimal() {
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal nEff = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                nEff = Stat.effectiveSampleNumber(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return nEff;
    }

    public Complex effectiveSampleNumber_as_Complex() {
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex nEff = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                nEff = Stat.effectiveSampleNumber(cc);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return nEff;
    }

    public double effectiveSampleNumber_as_double() {
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double nEff = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                nEff = Stat.effectiveSampleNumber(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                nEff = Stat.effectiveSampleNumber(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return nEff;
    }

    public double excessCurtosis() {
        return this.kurtosisExcess_as_double();
    }

    public BigDecimal excessCurtosis_as_BigDecimal() {
        return this.kurtosisExcess_as_BigDecimal();
    }

    public double excessCurtosis_as_double() {
        return this.kurtosisExcess_as_double();
    }

    public double excessKurtosis() {
        return this.kurtosisExcess_as_double();
    }

    public BigDecimal excessKurtosis_as_BigDecimal() {
        return this.kurtosisExcess_as_BigDecimal();
    }

    public double excessKurtosis_as_double() {
        return this.kurtosisExcess_as_double();
    }

    public void fitOneOrSeveralDistributions() {
        double[] dd = this.getArray_as_double();
        Regression.fitOneOrSeveralDistributions(dd);
    }

    public double fPDF(double var1, int nu1, double var2, int nu2) {
        return this.fPDF(var1 / var2, nu1, nu2);
    }

    public double fPDF(double fValue, int nu1, int nu2) {
        double numer = Math.pow((double)nu1 * fValue, nu1) * Math.pow(nu2, nu2);
        double dnu1 = nu1;
        double dnu2 = nu2;
        numer /= Math.pow(dnu1 * fValue + dnu2, dnu1 + dnu2);
        numer = Math.sqrt(numer);
        double denom = fValue * Stat.betaFunction(dnu1 / 2.0, dnu2 / 2.0);
        return numer / denom;
    }

    public double generalisedEntropyOneNat(double q, double r) {
        return this.generalizedEntropyOneNat(q, r);
    }

    public double generalisedMean(BigDecimal m) {
        return this.generalisedMean_as_double(m);
    }

    public double generalisedMean(double m) {
        return this.generalisedMean_as_double(m);
    }

    public Complex generalisedMean_as_Complex(Complex m) {
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                mean = Stat.generalisedMean(cc, m);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public Complex generalisedMean_as_Complex(double m) {
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                mean = new Complex(Stat.generalisedMean(dd, m));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = new Complex(Stat.generalisedMean(bd, m));
                bd = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                mean = Stat.generalisedMean(cc, m);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double generalisedMean_as_double(BigDecimal m) {
        double mean = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.generalisedMean(bd, m);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double generalisedMean_as_double(double m) {
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                mean = Stat.generalisedMean(dd, m);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.generalisedMean(bd, m);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double generalizedEntropyOneNat(double q, double r) {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.generalizedEntropyOneNat(dd, q, r);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Generalized Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double generalizedMean(BigDecimal m) {
        return this.generalizedMean_as_double(m);
    }

    public double generalizedMean(double m) {
        return this.generalizedMean_as_double(m);
    }

    public Complex generalizedMean_as_Complex(Complex m) {
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                mean = Stat.generalizedMean(cc, m);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public Complex generalizedMean_as_Complex(double m) {
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                mean = new Complex(Stat.generalizedMean(dd, m));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = new Complex(Stat.generalizedMean(bd, m));
                bd = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                mean = Stat.generalizedMean(cc, m);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double generalizedMean_as_double(BigDecimal m) {
        double mean = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.generalizedMean(bd, m);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double generalizedMean_as_double(double m) {
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                mean = Stat.generalizedMean(dd, m);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.generalizedMean(bd, m);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double geometricMean() {
        return this.geometricMean_as_double();
    }

    public Complex geometricMean_as_Complex() {
        Complex gmean = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                gmean = Stat.geometricMean(cc);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return gmean;
    }

    public double geometricMean_as_double() {
        double gmean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                gmean = Stat.geometricMean(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                gmean = Stat.geometricMean(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot  be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return gmean;
    }

    public double harmonicMean() {
        return this.harmonicMean_as_double();
    }

    public BigDecimal harmonicMean_as_BigDecimal() {
        BigDecimal mean = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.harmonicMean(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public Complex harmonicMean_as_Complex() {
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                mean = new Complex(Stat.harmonicMean(dd));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = new Complex(Stat.harmonicMean(bd).doubleValue());
                bd = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                mean = Stat.harmonicMean(cc);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double harmonicMean_as_double() {
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                mean = Stat.harmonicMean(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.harmonicMean(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double interQuartileMean() {
        return this.interQuartileMean_as_double();
    }

    public BigDecimal interQuartileMean_as_BigDecimal() {
        BigDecimal mean = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.interQuartileMean(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex interquartile mean is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double interQuartileMean_as_double() {
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                mean = Stat.interQuartileMean(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                mean = Stat.interQuartileMean(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex interquartile mean is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double kurtosis() {
        return this.kurtosis_as_double();
    }

    public BigDecimal kurtosis_as_BigDecimal() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal kurtosis = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                kurtosis = Stat.kurtosis(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return kurtosis;
    }

    public double kurtosis_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double kurtosis = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                kurtosis = Stat.kurtosis(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                kurtosis = Stat.kurtosis(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return kurtosis;
    }

    public double kurtosisExcess() {
        return this.kurtosisExcess_as_double();
    }

    public BigDecimal kurtosisExcess_as_BigDecimal() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal kurtosis = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                kurtosis = Stat.kurtosisExcess(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return kurtosis;
    }

    public double kurtosisExcess_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double kurtosis = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                kurtosis = Stat.kurtosisExcess(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                kurtosis = Stat.kurtosisExcess(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return kurtosis;
    }

    public ArrayList<Object> lowerOutliersAnscombe(BigDecimal constant) {
        return this.lowerOutliersAnscombe_as_BigDecimal(constant);
    }

    public ArrayList<Object> lowerOutliersAnscombe(BigInteger constant) {
        return this.lowerOutliersAnscombe_as_BigDecimal(new BigDecimal(constant));
    }

    public ArrayList<Object> lowerOutliersAnscombe(double constant) {
        return this.lowerOutliersAnscombe_as_double(constant);
    }

    public ArrayList<Object> lowerOutliersAnscombe_as_BigDecimal(BigDecimal constant) {
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                ArrayList<Object> ret = new ArrayList();
                ret = Stat.lowerOutliersAnscombeAsArrayList(dd, constant.doubleValue());
                this.lowerOutlierDetails.add(ret.get(0));
                Double[] dd1 = (Double[])ret.get(1);
                ArrayMaths am1 = new ArrayMaths(dd1);
                this.lowerOutlierDetails.add(am1.getArray_as_BigDecimal());
                this.lowerOutlierDetails.add(ret.get(2));
                Double[] dd2 = (Double[])ret.get(3);
                ArrayMaths am2 = new ArrayMaths(dd2);
                this.lowerOutlierDetails.add(am2.getArray_as_BigDecimal());
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                this.lowerOutlierDetails = Stat.lowerOutliersAnscombeAsArrayList(bd, constant);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.lowerDone = true;
        return this.lowerOutlierDetails;
    }

    public ArrayList<Object> lowerOutliersAnscombe_as_BigDecimal(BigInteger constant) {
        return this.lowerOutliersAnscombe_as_BigDecimal(new BigDecimal(constant));
    }

    public ArrayList<Object> lowerOutliersAnscombe_as_double(double constant) {
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                this.lowerOutlierDetails = Stat.lowerOutliersAnscombeAsArrayList(dd, constant);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                ArrayList<Object> ret = new ArrayList();
                ret = Stat.lowerOutliersAnscombeAsArrayList(bd, new BigDecimal(constant));
                this.lowerOutlierDetails.add(ret.get(0));
                BigDecimal[] bd1 = (BigDecimal[])ret.get(1);
                ArrayMaths am1 = new ArrayMaths(bd1);
                this.lowerOutlierDetails.add(am1.getArray_as_Double());
                this.lowerOutlierDetails.add(ret.get(2));
                BigDecimal[] bd2 = (BigDecimal[])ret.get(3);
                ArrayMaths am2 = new ArrayMaths(bd2);
                this.lowerOutlierDetails.add(am2.getArray_as_Double());
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.lowerDone = true;
        return this.lowerOutlierDetails;
    }

    public double mean() {
        return this.mean_as_double();
    }

    public BigDecimal mean_as_BigDecimal() {
        BigDecimal mean = BigDecimal.ZERO;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double meand = 0.0;
                int i = 0;
                while (i < this.length) {
                    meand += dd[i];
                    ++i;
                }
                mean = new BigDecimal(meand /= (double)this.length);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                int i = 0;
                while (i < this.length) {
                    mean = mean.add(bd[i]);
                    ++i;
                }
                mean = mean.divide(new BigDecimal((double)this.length), 4);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public Complex mean_as_Complex() {
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double meand = 0.0;
                int i = 0;
                while (i < this.length) {
                    meand += dd[i];
                    ++i;
                }
                mean = new Complex(meand /= (double)this.length);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal meanbd = BigDecimal.ZERO;
                int i = 0;
                while (i < this.length) {
                    meanbd = meanbd.add(bd[i]);
                    ++i;
                }
                meanbd = meanbd.divide(new BigDecimal((double)this.length), 4);
                mean = new Complex(meanbd.doubleValue());
                bd = null;
                meanbd = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                int i = 0;
                while (i < this.length) {
                    mean = mean.plus(cc[i]);
                    ++i;
                }
                mean = mean.over(new Complex(this.length));
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double mean_as_double() {
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                int i = 0;
                while (i < this.length) {
                    mean += dd[i];
                    ++i;
                }
                mean /= (double)this.length;
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal meanbd = BigDecimal.ZERO;
                int i = 0;
                while (i < this.length) {
                    meanbd = meanbd.add(bd[i]);
                    ++i;
                }
                meanbd = meanbd.divide(new BigDecimal((double)this.length), 4);
                mean = meanbd.doubleValue();
                bd = null;
                meanbd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return mean;
    }

    public double[] meanConfidenceLimits(double prob) {
        double[] cl = new double[2];
        double probn = prob / 2.0 + 0.5;
        double mean = this.mean();
        double sd = this.standardDeviation();
        double z = Stat.gaussianInverseCDF(mean, sd, probn);
        cl[0] = 2.0 * mean - z;
        cl[1] = z;
        return cl;
    }

    public double median() {
        return this.median_as_double();
    }

    public BigDecimal median_as_BigDecimal() {
        BigDecimal median = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                median = Stat.median(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex median value not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return median;
    }

    public double median_as_double() {
        double median = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                median = Stat.median(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                median = Stat.median(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex median value not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return median;
    }

    public double medianSkewness() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double skewness = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                skewness = Stat.medianSkewness(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                skewness = Stat.medianSkewness(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return skewness;
    }

    public double medianSkewness_as_double() {
        return this.medianSkewness();
    }

    public double momentSkewness() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double skewness = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                skewness = Stat.momentSkewness(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                skewness = Stat.momentSkewness(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return skewness;
    }

    public double momentSkewness_as_double() {
        return this.momentSkewness();
    }

    public double quartileSkewness() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double skewness = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                skewness = Stat.quartileSkewness(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                skewness = Stat.quartileSkewness(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return skewness;
    }

    public BigDecimal quartileSkewness_as_BigDecimal() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal skewness = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                skewness = Stat.quartileSkewness(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return skewness;
    }

    public double quartileSkewness_as_double() {
        return this.quartileSkewness();
    }

    public double renyiEntropy(double alpha) {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.renyiEntropy(dd, alpha);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double renyiEntropyBit(double alpha) {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.renyiEntropy(dd, alpha);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double renyiEntropyDit(double alpha) {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.renyiEntropyDit(dd, alpha);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double renyiEntropyNat(double alpha) {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.renyiEntropyNat(dd, alpha);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double rms() {
        double rms = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                rms = Stat.rms(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                rms = Stat.rms(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex root mean square is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return rms;
    }

    public double[] scale(double mean, double sd) {
        double[] bb = null;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                bb = Stat.scale(dd, mean, sd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Scaling of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return bb;
    }

    public void setDenominatorToN() {
        this.nFactorOptionI = true;
        this.nFactorReset = true;
    }

    public void setDenominatorToNminusOne() {
        this.nFactorOptionI = false;
        this.nFactorReset = true;
    }

    public void setWeights(ArrayList<Object> xx) {
        if (this.length != xx.size()) {
            throw new IllegalArgumentException("Length of weights array, " + xx.size() + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(BigDecimal[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(BigInteger[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(byte[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Byte[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Complex[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(double[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Double[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(float[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Float[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(int[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Integer[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(long[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Long[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Object[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Phasor[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(short[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Short[] xx) {
        if (this.length != xx.length) {
            throw new IllegalArgumentException("Length of weights array, " + xx.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeights(Vector<Object> xx) {
        if (this.length != xx.size()) {
            throw new IllegalArgumentException("Length of weights array, " + xx.size() + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths wm = new ArrayMaths(xx);
        this.convertWeights(wm);
        this.weightsSupplied = true;
    }

    public void setWeightsToBigW() {
        this.weightingOptionI = false;
        this.weightingReset = true;
    }

    public void setWeightsToLittleW() {
        this.weightingOptionI = true;
        this.weightingReset = true;
    }

    public double shannonEntropy() {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.shannonEntropy(dd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double shannonEntropyBit() {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.shannonEntropy(dd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double shannonEntropyDit() {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.shannonEntropyDit(dd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double shannonEntropyNat() {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.shannonEntropyNat(dd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public double standardDeviation() {
        return this.standardDeviation_as_double();
    }

    public Complex standardDeviation_as_Complex() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex variance = Complex.zero();
        Complex[] cc = this.getArray_as_Complex();
        variance = Stat.variance(cc);
        nFactorOptionS = hold;
        return Complex.sqrt(variance);
    }

    public double standardDeviation_as_Complex_ConjugateCalcn() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex[] cc = this.getArray_as_Complex();
        double variance = Stat.varianceConjugateCalcn(cc);
        nFactorOptionS = hold;
        return Math.sqrt(variance);
    }

    public double standardDeviation_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double variance = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                variance = Stat.variance(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                variance = Stat.variance(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return Math.sqrt(variance);
    }

    public double standardDeviation_of_ComplexImaginaryParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] im = this.array_as_imaginary_part_of_Complex();
        double standardDeviation = Stat.standardDeviation(im);
        nFactorOptionS = hold;
        return standardDeviation;
    }

    public double standardDeviation_of_ComplexModuli() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] re = this.array_as_modulus_of_Complex();
        double standardDeviation = Stat.standardDeviation(re);
        nFactorOptionS = hold;
        return standardDeviation;
    }

    public double standardDeviation_of_ComplexRealParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] re = this.array_as_real_part_of_Complex();
        double standardDeviation = Stat.standardDeviation(re);
        nFactorOptionS = hold;
        return standardDeviation;
    }

    public double standardError() {
        return this.standardError_as_double();
    }

    public Complex standardError_as_Complex() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex standardError = Complex.zero();
        Complex[] cc = this.getArray_as_Complex();
        standardError = Stat.standardError(cc);
        nFactorOptionS = hold;
        return standardError;
    }

    public double standardError_as_Complex_ConjugateCalcn() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex[] cc = this.getArray_as_Complex();
        double standardError = Stat.standardErrorConjugateCalcn(cc);
        nFactorOptionS = hold;
        return standardError;
    }

    public double standardError_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double standardError = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                standardError = Stat.standardError(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                standardError = Stat.standardError(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return standardError;
    }

    public double standardError_of_ComplexImaginaryParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] re = this.array_as_imaginary_part_of_Complex();
        double standardError = Stat.standardError(re);
        nFactorOptionS = hold;
        return standardError;
    }

    public double standardError_of_ComplexModuli() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] re = this.array_as_modulus_of_Complex();
        double standardError = Stat.standardError(re);
        nFactorOptionS = hold;
        return standardError;
    }

    public double standardError_of_ComplexRealParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] re = this.array_as_real_part_of_Complex();
        double standardError = Stat.standardError(re);
        nFactorOptionS = hold;
        return standardError;
    }

    public double[] standardise() {
        return this.standardize();
    }

    public double[] standardize() {
        double[] bb = null;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                bb = Stat.standardize(dd);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Standardization of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return bb;
    }

    public double[] subtractMean() {
        return this.subtractMean_as_double();
    }

    public BigDecimal[] subtractMean_as_BigDecimal() {
        BigDecimal[] arrayminus = new BigDecimal[this.length];
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal meanb = this.mean_as_BigDecimal();
                ArrayMaths amb = this.minus(meanb);
                arrayminus = amb.getArray_as_BigDecimal();
                meanb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return arrayminus;
    }

    public Complex[] subtractMean_as_Complex() {
        Complex[] arrayminus = new Complex[this.length];
        switch (this.type) {
            case 1: {
                double meand = this.mean_as_double();
                ArrayMaths amd = this.minus(meand);
                arrayminus = amd.getArray_as_Complex();
                break;
            }
            case 12: {
                BigDecimal meanb = this.mean_as_BigDecimal();
                ArrayMaths amb = this.minus(meanb);
                arrayminus = amb.getArray_as_Complex();
                meanb = null;
                break;
            }
            case 14: {
                Complex meanc = this.mean_as_Complex();
                ArrayMaths amc = this.minus(meanc);
                arrayminus = amc.getArray_as_Complex();
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return arrayminus;
    }

    public double[] subtractMean_as_double() {
        double[] arrayminus = new double[this.length];
        switch (this.type) {
            case 1: {
                double meand = this.mean_as_double();
                ArrayMaths amd = this.minus(meand);
                arrayminus = amd.getArray_as_double();
                break;
            }
            case 12: {
                BigDecimal meanb = this.mean_as_BigDecimal();
                ArrayMaths amb = this.minus(meanb);
                arrayminus = amb.getArray_as_double();
                meanb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return arrayminus;
    }

    public double[] subtractWeightedMean() {
        return this.subtractWeightedMean_as_double();
    }

    public BigDecimal[] subtractWeightedMean_as_BigDecimal() {
        if (!this.weightsSupplied) {
            System.out.println("subtractWeightedMean_as_BigDecimal: no weights supplied - unweighted values returned");
            return this.subtractMean_as_BigDecimal();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal[] arrayminus = new BigDecimal[this.length];
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal meanb = this.weightedMean_as_BigDecimal();
                ArrayMaths amb = this.minus(meanb);
                arrayminus = amb.getArray_as_BigDecimal();
                meanb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return arrayminus;
    }

    public Complex[] subtractWeightedMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("subtractWeightedMean_as_Complex: no weights supplied - unweighted values returned");
            return this.subtractMean_as_Complex();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex[] arrayminus = new Complex[this.length];
        switch (this.type) {
            case 1: {
                double meand = this.weightedMean_as_double();
                ArrayMaths amd = this.minus(meand);
                arrayminus = amd.getArray_as_Complex();
                break;
            }
            case 12: {
                BigDecimal meanb = this.weightedMean_as_BigDecimal();
                ArrayMaths amb = this.minus(meanb);
                arrayminus = amb.getArray_as_Complex();
                meanb = null;
                break;
            }
            case 14: {
                Complex meanc = this.weightedMean_as_Complex();
                ArrayMaths amc = this.minus(meanc);
                arrayminus = amc.getArray_as_Complex();
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return arrayminus;
    }

    public double[] subtractWeightedMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("subtractWeightedMean_as_double: no weights supplied - unweighted values returned");
            return this.subtractMean_as_double();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double[] arrayminus = new double[this.length];
        switch (this.type) {
            case 1: {
                double meand = this.weightedMean_as_double();
                ArrayMaths amd = this.minus(meand);
                arrayminus = amd.getArray_as_double();
                break;
            }
            case 12: {
                BigDecimal meanb = this.weightedMean_as_BigDecimal();
                ArrayMaths amb = this.minus(meanb);
                arrayminus = amb.getArray_as_double();
                meanb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return arrayminus;
    }

    public int trueSampleNumber() {
        return this.length;
    }

    public BigDecimal trueSampleNumber_as_BigDecimal() {
        return new BigDecimal(new Integer(this.length).toString());
    }

    public Complex trueSampleNumber_as_Complex() {
        return new Complex(this.length, 0.0);
    }

    public double trueSampleNumber_as_double() {
        return this.length;
    }

    public int trueSampleNumber_as_int() {
        return this.length;
    }

    public double tsallisEntropyNat(double q) {
        double entropy = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dd = this.getArray_as_double();
                entropy = Stat.tsallisEntropyNat(dd, q);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Tsallis Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return entropy;
    }

    public ArrayList<Object> upperOutliersAnscombe(BigDecimal constant) {
        return this.upperOutliersAnscombe_as_BigDecimal(constant);
    }

    public ArrayList<Object> upperOutliersAnscombe(BigInteger constant) {
        return this.upperOutliersAnscombe_as_BigDecimal(new BigDecimal(constant));
    }

    public ArrayList<Object> upperOutliersAnscombe(double constant) {
        return this.upperOutliersAnscombe_as_double(constant);
    }

    public ArrayList<Object> upperOutliersAnscombe_as_BigDecimal(BigDecimal constant) {
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                ArrayList<Object> ret = new ArrayList();
                ret = Stat.upperOutliersAnscombeAsArrayList(dd, constant.doubleValue());
                this.upperOutlierDetails.add(ret.get(0));
                Double[] dd1 = (Double[])ret.get(1);
                ArrayMaths am1 = new ArrayMaths(dd1);
                this.upperOutlierDetails.add(am1.getArray_as_BigDecimal());
                this.upperOutlierDetails.add(ret.get(2));
                Double[] dd2 = (Double[])ret.get(3);
                ArrayMaths am2 = new ArrayMaths(dd2);
                this.upperOutlierDetails.add(am2.getArray_as_BigDecimal());
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                this.upperOutlierDetails = Stat.upperOutliersAnscombeAsArrayList(bd, constant);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.upperDone = true;
        return this.upperOutlierDetails;
    }

    public ArrayList<Object> upperOutliersAnscombe_as_BigDecimal(BigInteger constant) {
        return this.upperOutliersAnscombe_as_BigDecimal(new BigDecimal(constant));
    }

    public ArrayList<Object> upperOutliersAnscombe_as_double(double constant) {
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                this.upperOutlierDetails = Stat.upperOutliersAnscombeAsArrayList(dd, constant);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                ArrayList<Object> ret = new ArrayList();
                ret = Stat.upperOutliersAnscombeAsArrayList(bd, new BigDecimal(constant));
                this.upperOutlierDetails.add(ret.get(0));
                BigDecimal[] bd1 = (BigDecimal[])ret.get(1);
                ArrayMaths am1 = new ArrayMaths(bd1);
                this.upperOutlierDetails.add(am1.getArray_as_Double());
                this.upperOutlierDetails.add(ret.get(2));
                BigDecimal[] bd2 = (BigDecimal[])ret.get(3);
                ArrayMaths am2 = new ArrayMaths(bd2);
                this.upperOutlierDetails.add(am2.getArray_as_Double());
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.upperDone = true;
        return this.upperOutlierDetails;
    }

    public void useEffectiveN() {
        this.nEffOptionI = true;
        this.nEffReset = true;
    }

    public void useTrueN() {
        this.nEffOptionI = false;
        this.nEffReset = true;
    }

    public double variance() {
        return this.variance_as_double();
    }

    public BigDecimal variance_as_BigDecimal() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal variance = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                variance = Stat.variance(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return variance;
    }

    public Complex variance_as_Complex() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex variance = Complex.zero();
        Complex[] cc = this.getArray_as_Complex();
        variance = Stat.variance(cc);
        nFactorOptionS = hold;
        return variance;
    }

    public double variance_as_Complex_ConjugateCalcn() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex[] cc = this.getArray_as_Complex();
        double variance = Stat.varianceConjugateCalcn(cc);
        nFactorOptionS = hold;
        return variance;
    }

    public double variance_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double variance = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                variance = Stat.variance(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                variance = Stat.variance(bd).doubleValue();
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        return variance;
    }

    public double variance_of_ComplexImaginaryParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] im = this.array_as_imaginary_part_of_Complex();
        double variance = Stat.variance(im);
        nFactorOptionS = hold;
        return variance;
    }

    public double variance_of_ComplexModuli() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] re = this.array_as_modulus_of_Complex();
        double variance = Stat.variance(re);
        nFactorOptionS = hold;
        return variance;
    }

    public double variance_of_ComplexRealParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] re = this.array_as_real_part_of_Complex();
        double variance = Stat.variance(re);
        nFactorOptionS = hold;
        return variance;
    }

    public double volatilityLogChange() {
        double volatilityLogChange = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                volatilityLogChange = Stat.volatilityLogChange(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                volatilityLogChange = Stat.volatilityLogChange(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex volatilty is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return volatilityLogChange;
    }

    public double volatilityPerCentChange() {
        double volatilityPerCentChange = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                volatilityPerCentChange = Stat.volatilityPerCentChange(dd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                volatilityPerCentChange = Stat.volatilityPerCentChange(bd);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex volatilty is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return volatilityPerCentChange;
    }

    public double weightedCoefficientOfVariation() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double coefficientOfVariation = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] wd = this.amWeights.getArray_as_double();
                coefficientOfVariation = Stat.coefficientOfVariation(dd, wd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] bw = this.amWeights.getArray_as_BigDecimal();
                coefficientOfVariation = Stat.coefficientOfVariation(bd, bw);
                bd = null;
                bw = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex coefficient of variation is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = hold;
        weightingOptionS = holdW;
        return coefficientOfVariation;
    }

    public double weightedGeneralisedMean(BigDecimal m) {
        return this.weightedGeneralizedMean_as_double(m);
    }

    public double weightedGeneralisedMean(double m) {
        return this.weightedGeneralizedMean_as_double(m);
    }

    public Complex weightedGeneralisedMean_as_Complex(Complex m) {
        return this.weightedGeneralizedMean_as_Complex(m);
    }

    public Complex weightedGeneralisedMean_as_Complex(double m) {
        return this.weightedGeneralizedMean_as_Complex(m);
    }

    public double weightedGeneralisedMean_as_double(BigDecimal m) {
        return this.weightedGeneralizedMean_as_double(m);
    }

    public double weightedGeneralisedMean_as_double(double m) {
        return this.weightedGeneralizedMean_as_double(m);
    }

    public double weightedGeneralizedMean(BigDecimal m) {
        return this.weightedGeneralizedMean_as_double(m);
    }

    public double weightedGeneralizedMean(double m) {
        return this.weightedGeneralizedMean_as_double(m);
    }

    public Complex weightedGeneralizedMean_as_Complex(Complex m) {
        Complex mean = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_dComplex: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_Complex(m);
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                Complex[] cw = this.amWeights.getArray_as_Complex();
                mean = Stat.generalisedMean(cc, cw, m);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public Complex weightedGeneralizedMean_as_Complex(double m) {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_Complex: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_Complex(m);
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] ww = this.amWeights.getArray_as_double();
                mean = new Complex(Stat.generalisedMean(dd, ww, m));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                mean = new Complex(Stat.generalisedMean(bd, wd, m));
                bd = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                Complex[] cw = this.amWeights.getArray_as_Complex();
                mean = Stat.generalisedMean(cc, cw, m);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public double weightedGeneralizedMean_as_double(BigDecimal m) {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_double: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_double(m);
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double mean = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                mean = Stat.generalisedMean(bd, wd, m);
                bd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public double weightedGeneralizedMean_as_double(double m) {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_double: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_double(m);
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] ww = this.amWeights.getArray_as_double();
                mean = Stat.generalisedMean(dd, ww, m);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                mean = Stat.generalisedMean(bd, wd, m);
                bd = null;
                wd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public double weightedGeometricMean() {
        return this.weightedGeometricMean_as_double();
    }

    public Complex weightedGeometricMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeometricMean_as_Complex: no weights supplied - unweighted value returned");
            return this.geometricMean_as_Complex();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex gmean = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                Complex[] ww = this.getArray_as_Complex();
                gmean = Stat.geometricMean(cc, ww);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return gmean;
    }

    public double weightedGeometricMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeometricMean_as_double: no weights supplied - unweighted value returned");
            return this.geometricMean_as_double();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double gmean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] ww = this.getArray_as_double();
                gmean = Stat.geometricMean(dd, ww);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wd = this.getArray_as_BigDecimal();
                gmean = Stat.geometricMean(bd, wd);
                bd = null;
                wd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot  be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return gmean;
    }

    public double weightedHarmonicMean() {
        return this.weightedHarmonicMean_as_double();
    }

    public BigDecimal weightedHarmonicMean_as_BigDecimal() {
        if (!this.weightsSupplied) {
            System.out.println("weightedHarmonicMean_as_BigDecimal: no weights supplied - unweighted mean returned");
            return this.harmonicMean_as_BigDecimal();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal mean = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wwb = this.amWeights.getArray_as_BigDecimal();
                mean = Stat.harmonicMean(bd, wwb);
                bd = null;
                wwb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public Complex weightedHarmonicMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("weightedHarmonicMean_as_Complex: no weights supplied - unweighted mean returned");
            return this.harmonicMean_as_Complex();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] wwd = this.amWeights.getArray_as_double();
                mean = new Complex(Stat.harmonicMean(dd, wwd));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wwb = this.amWeights.getArray_as_BigDecimal();
                mean = new Complex(Stat.harmonicMean(bd, wwb).doubleValue());
                bd = null;
                wwb = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                Complex[] wwc = this.amWeights.getArray_as_Complex();
                mean = Stat.harmonicMean(cc, wwc);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public double weightedHarmonicMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("weightedHarmonicMean_as_double: no weights supplied - unweighted mean returned");
            return this.harmonicMean_as_double();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] wwd = this.amWeights.getArray_as_double();
                mean = Stat.harmonicMean(dd, wwd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wwb = this.amWeights.getArray_as_BigDecimal();
                mean = Stat.harmonicMean(bd, wwb).doubleValue();
                bd = null;
                wwb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public double weightedMean() {
        return this.weightedMean_as_double();
    }

    public BigDecimal weightedMean_as_BigDecimal() {
        if (!this.weightsSupplied) {
            System.out.println("weightedMean_as_BigDecimal: no weights supplied - unweighted mean returned");
            return this.mean_as_BigDecimal();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal mean = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wwb = this.amWeights.getArray_as_BigDecimal();
                mean = Stat.mean(bd, wwb);
                bd = null;
                wwb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public Complex weightedMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("weightedMean_as_Complex: no weights supplied - unweighted mean returned");
            return this.mean_as_Complex();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex mean = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] wwd = this.amWeights.getArray_as_double();
                mean = new Complex(Stat.mean(dd, wwd));
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wwb = this.amWeights.getArray_as_BigDecimal();
                mean = new Complex(Stat.mean(bd, wwb).doubleValue());
                bd = null;
                wwb = null;
                break;
            }
            case 14: {
                Complex[] cc = this.getArray_as_Complex();
                Complex[] wwc = this.amWeights.getArray_as_Complex();
                mean = Stat.mean(cc, wwc);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public double weightedMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("weightedMean_as_double: no weights supplied - unweighted mean returned");
            return this.mean_as_double();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double mean = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] wwd = this.amWeights.getArray_as_double();
                mean = Stat.mean(dd, wwd);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wwb = this.amWeights.getArray_as_BigDecimal();
                mean = Stat.mean(bd, wwb).doubleValue();
                bd = null;
                wwb = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return mean;
    }

    public double weightedRms() {
        if (!this.weightsSupplied) {
            System.out.println("weightedRms: no weights supplied - unweighted rms returned");
            return this.rms();
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double rms = 0.0;
        switch (this.type) {
            case 1: {
                double[] dd = this.getArray_as_double();
                double[] ww = this.amWeights.getArray_as_double();
                rms = Stat.rms(dd, ww);
                break;
            }
            case 12: {
                BigDecimal[] bd = this.getArray_as_BigDecimal();
                BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                rms = Stat.rms(bd, wd);
                bd = null;
                wd = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex root mean square is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = holdW;
        return rms;
    }

    public double weightedStandardDeviation() {
        return this.weightedStandardDeviation_as_double();
    }

    public Complex weightedStandardDeviation_as_Complex() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex varr = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedtandardDeviationS_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardDeviation_as_Complex();
        } else {
            Complex variance = Complex.zero();
            Complex[] cc = this.getArray_as_Complex();
            Complex[] wc = this.amWeights.getArray_as_Complex();
            variance = Stat.variance(cc, wc);
            varr = Complex.sqrt(variance);
        }
        nFactorOptionS = hold;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardDeviation_as_Complex_ConjugateCalcn() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedtandardDeviationS_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardDeviation_as_Complex_ConjugateCalcn();
        } else {
            double variance = Double.NaN;
            Complex[] cc = this.getArray_as_Complex();
            Complex[] wc = this.amWeights.getArray_as_Complex();
            variance = Stat.varianceConjugateCalcn(cc, wc);
            varr = Math.sqrt(variance);
        }
        nFactorOptionS = hold;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardDeviation_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = 0.0;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_double: no weights supplied - unweighted value returned");
            varr = this.standardDeviation_as_double();
        } else {
            double variance = 0.0;
            switch (this.type) {
                case 1: {
                    double[] dd = this.getArray_as_double();
                    double[] ww = this.amWeights.getArray_as_double();
                    variance = Stat.variance(dd, ww);
                    break;
                }
                case 12: {
                    BigDecimal[] bd = this.getArray_as_BigDecimal();
                    BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                    variance = Stat.variance(bd, wd).doubleValue();
                    bd = null;
                    wd = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to double");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            varr = Math.sqrt(variance);
        }
        nFactorOptionS = hold;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardDeviation_of_ComplexImaginaryParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardDeviation_of_ComplexImaginaryParts();
        } else {
            double[] cc = this.array_as_imaginary_part_of_Complex();
            double[] wc = this.amWeights.array_as_imaginary_part_of_Complex();
            varr = Stat.standardDeviation(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardDeviation_of_ComplexModuli() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardDeviation_of_ComplexModuli();
        } else {
            double[] cc = this.array_as_modulus_of_Complex();
            double[] wc = this.amWeights.array_as_modulus_of_Complex();
            varr = Stat.standardDeviation(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardDeviation_of_ComplexRealParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardDeviation_of_ComplexRealParts();
        } else {
            double[] cc = this.array_as_real_part_of_Complex();
            double[] wc = this.amWeights.array_as_real_part_of_Complex();
            varr = Stat.standardDeviation(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardError() {
        return this.weightedStandardError_as_double();
    }

    public double weightedStandardError_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double standardError = 0.0;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_double: no weights supplied - unweighted value returned");
            standardError = this.standardError_as_double();
        } else {
            switch (this.type) {
                case 1: {
                    double[] dd = this.getArray_as_double();
                    double[] ww = this.amWeights.getArray_as_double();
                    standardError = Stat.standardError(dd, ww);
                    break;
                }
                case 12: {
                    BigDecimal[] bd = this.getArray_as_BigDecimal();
                    BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                    standardError = Stat.standardError(bd, wd);
                    bd = null;
                    wd = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to double");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            standardError = Math.sqrt(standardError);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return standardError;
    }

    public double weightedStandardError_of_ComplexImaginaryParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardError_of_ComplexImaginaryParts();
        } else {
            double[] cc = this.array_as_imaginary_part_of_Complex();
            double[] wc = this.amWeights.array_as_imaginary_part_of_Complex();
            varr = Stat.standardError(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardError_of_ComplexModuli() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardError_of_ComplexModuli();
        } else {
            double[] cc = this.array_as_modulus_of_Complex();
            double[] wc = this.amWeights.array_as_modulus_of_Complex();
            varr = Stat.standardError(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedStandardError_of_ComplexRealParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            varr = this.standardError_of_ComplexRealParts();
        } else {
            double[] cc = this.array_as_real_part_of_Complex();
            double[] wc = this.amWeights.array_as_real_part_of_Complex();
            varr = Stat.standardError(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public Complex weightedStandarError_as_Complex() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex standardError = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            standardError = this.standardError_as_Complex();
        } else {
            Complex[] cc = this.getArray_as_Complex();
            Complex[] wc = this.amWeights.getArray_as_Complex();
            standardError = Stat.standardError(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return standardError;
    }

    public double weightedStandarError_as_Complex_ConjugateCalcn() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double standardError = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            standardError = this.standardError_as_Complex_ConjugateCalcn();
        } else {
            Complex[] cc = this.getArray_as_Complex();
            Complex[] wc = this.amWeights.getArray_as_Complex();
            standardError = Stat.standardErrorConjugateCalcn(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return standardError;
    }

    public double weightedVariance() {
        return this.weightedVariance_as_double();
    }

    public BigDecimal weightedVariance_as_BigDecimal() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal varr = BigDecimal.ZERO;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_BigDecimal: no weights supplied - unweighted value returned");
            varr = this.variance_as_BigDecimal();
        } else {
            BigDecimal weightedVariance = BigDecimal.ZERO;
            switch (this.type) {
                case 1: 
                case 12: {
                    BigDecimal[] bd = this.getArray_as_BigDecimal();
                    BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                    weightedVariance = Stat.variance(bd, wd);
                    bd = null;
                    wd = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            varr = weightedVariance;
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public Complex weightedVariance_as_Complex() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex varr = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            varr = this.variance_as_Complex();
        } else {
            Complex weightedVariance = Complex.zero();
            Complex[] cc = this.getArray_as_Complex();
            Complex[] wc = this.amWeights.getArray_as_Complex();
            varr = weightedVariance = Stat.variance(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedVariance_as_Complex_ConjugateCalcn() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            varr = this.variance_as_Complex_ConjugateCalcn();
        } else {
            Complex[] cc = this.getArray_as_Complex();
            Complex[] wc = this.amWeights.getArray_as_Complex();
            varr = Stat.varianceConjugateCalcn(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedVariance_as_double() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_double: no weights supplied - unweighted value returned");
            varr = this.variance_as_double();
        } else {
            double weightedVariance = 0.0;
            switch (this.type) {
                case 1: {
                    double[] dd = this.getArray_as_double();
                    double[] ww = this.amWeights.getArray_as_double();
                    weightedVariance = Stat.variance(dd, ww);
                    break;
                }
                case 12: {
                    BigDecimal[] bd = this.getArray_as_BigDecimal();
                    BigDecimal[] wd = this.amWeights.getArray_as_BigDecimal();
                    weightedVariance = Stat.variance(bd, wd).doubleValue();
                    bd = null;
                    wd = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to double");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            varr = weightedVariance;
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedVariance_of_ComplexImaginaryParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            varr = this.variance_of_ComplexImaginaryParts();
        } else {
            double[] cc = this.array_as_imaginary_part_of_Complex();
            double[] wc = this.amWeights.array_as_imaginary_part_of_Complex();
            varr = Stat.variance(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedVariance_of_ComplexModuli() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            varr = this.variance_of_ComplexModuli();
        } else {
            double[] cc = this.array_as_modulus_of_Complex();
            double[] wc = this.amWeights.array_as_modulus_of_Complex();
            varr = Stat.variance(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }

    public double weightedVariance_of_ComplexRealParts() {
        boolean hold = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean hold2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean holdW = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double varr = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            varr = this.variance_of_ComplexRealParts();
        } else {
            double[] cc = this.array_as_real_part_of_Complex();
            double[] wc = this.amWeights.array_as_real_part_of_Complex();
            varr = Stat.variance(cc, wc);
        }
        nFactorOptionS = hold;
        nEffOptionS = hold2;
        weightingOptionS = holdW;
        return varr;
    }
}

