/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.ProbabilityPlot;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ANOVA {
    private String[] title = new String[3];
    private int nTitle = 0;
    private boolean titleCheck = false;
    private String inputFilename = null;
    private String outputFilename = null;
    private int fileOption = 1;
    private boolean fileOptionSet = false;
    private int trunc = 6;
    private int fieldD = 13;
    private boolean truncAll = false;
    private int originalDataType = -1;
    private Object originalData = null;
    private double[][] responses0 = null;
    private BigDecimal[][] responsesBD = null;
    private boolean dataEntered = false;
    private boolean bigDecimal = false;
    private int nGroups = 0;
    private String[] groupNames = null;
    private boolean groupNamesSet = false;
    private int nTotalResponses = 0;
    private int[] nResponsesPerGroup = null;
    private int[] typePerGroup = null;
    private String[] dichotomousS = new String[]{"yes", "no", "y", "n", "true", "false"};
    private char[] dichotomousC = new char[]{'y', 'n'};
    private double dichotTrue = 1.0;
    private double dichotFalse = -1.0;
    private double[] dichotomousDoubleS = new double[]{this.dichotTrue, this.dichotFalse, this.dichotTrue, this.dichotFalse, this.dichotTrue, this.dichotFalse};
    private double[] dichotomousDoubleC = new double[]{this.dichotTrue, this.dichotFalse};
    private int nDichotomousS = 6;
    private int nDichotomousC = 2;
    private boolean nFactorOption = false;
    private double[] groupMeans = null;
    private BigDecimal[] groupMeansBD = null;
    private double[] groupSD = null;
    private double[] groupSE = null;
    private double[] groupClb = null;
    private double[] groupCub = null;
    private double[] groupMinimum = null;
    private BigDecimal[] groupMinimumBD = null;
    private double[] groupMaximum = null;
    private BigDecimal[] groupMaximumBD = null;
    private double[] groupSS = null;
    private BigDecimal[] groupSSBD = null;
    private double[] groupMedians = null;
    private BigDecimal[] groupMediansBD = null;
    private double[] groupMomentSkewness = null;
    private double[] groupMedianSkewness = null;
    private double[] groupQuartileSkewness = null;
    private BigDecimal[] groupQuartileSkewnessBD = null;
    private double[] groupKurtosis = null;
    private BigDecimal[] groupKurtosisBD = null;
    private double[] groupExcessKurtosis = null;
    private BigDecimal[] groupExcessKurtosisBD = null;
    private double[] groupProbPlotR = null;
    private double[] groupProbPlotGradient = null;
    private double[] groupProbPlotIntercept = null;
    private double[] groupProbPlotMu = null;
    private double[] groupProbPlotSigma = null;
    private boolean groupStatsDone = false;
    private double totalMean = 0.0;
    private BigDecimal totalMeanBD = new BigDecimal(0.0);
    private double totalSD = 0.0;
    private double totalSE = 0.0;
    private double totalClb = 0.0;
    private double totalCub = 0.0;
    private double totalMinimum = 0.0;
    private BigDecimal totalMinimumBD = new BigDecimal("0.0");
    private double totalMaximum = 0.0;
    private BigDecimal totalMaximumBD = new BigDecimal("0.0");
    private double totalSS = 0.0;
    private BigDecimal totalSSBD = new BigDecimal("0.0");
    private double totalMedian = 0.0;
    private BigDecimal totalMedianBD = new BigDecimal("0.0");
    private double totalMomentSkewness = 0.0;
    private double totalMedianSkewness = 0.0;
    private double totalQuartileSkewness = 0.0;
    private BigDecimal totalQuartileSkewnessBD = new BigDecimal("0.0");
    private double totalKurtosis = 0.0;
    private BigDecimal totalKurtosisBD = new BigDecimal("0.0");
    private double totalExcessKurtosis = 0.0;
    private BigDecimal totalExcessKurtosisBD = new BigDecimal("0.0");
    private double totalProbPlotR = 0.0;
    private double totalProbPlotGradient = 0.0;
    private double totalProbPlotIntercept = 0.0;
    private double totalProbPlotMu = 0.0;
    private double totalProbPlotSigma = 0.0;
    private int dofTotal = 0;
    private int dofWithinGroups = 0;
    private int dofBetweenGroups = 0;
    private double ssTotal = 0.0;
    private double ssWithin = 0.0;
    private double ssBetween = 0.0;
    private BigDecimal ssTotalBD = new BigDecimal("0.0");
    private BigDecimal ssWithinBD = new BigDecimal("0.0");
    private BigDecimal ssBetweenBD = new BigDecimal("0.0");
    private double meanSquareTotal = 0.0;
    private double meanSquareWithin = 0.0;
    private double meanSquareBetween = 0.0;
    private BigDecimal meanSquareTotalBD = new BigDecimal("0.0");
    private BigDecimal meanSquareWithinBD = new BigDecimal("0.0");
    private BigDecimal meanSquareBetweenBD = new BigDecimal("0.0");
    private double fRatio = 0.0;
    private BigDecimal fRatioBD = new BigDecimal("0.0");
    private double fRatioP = 0.0;
    private boolean oneWayDone = false;
    private double criticalSignificance = 0.95;
    private String criticalSignificanceS = "95%";
    private String criticalSignificanceF = "5%";
    private double criticalFratio = 0.0;
    private boolean[] compGroups = null;
    private boolean comparison = false;
    private int nComparisons = 0;
    private int[][] pairIndices = null;
    private double[] meanSquareTotalG = null;
    private double[] meanSquareWithinG = null;
    private double[] meanSquareBetweenG = null;
    private BigDecimal[] meanSquareTotalBDG = null;
    private BigDecimal[] meanSquareWithinBDG = null;
    private BigDecimal[] meanSquareBetweenBDG = null;
    private double[] fRatioG = null;
    private BigDecimal[] fRatioBDG = null;
    private double[] fRatioPG = null;
    private double[] criticalFratioG = null;
    private double[] ssTotalG = null;
    private double[] ssWithinG = null;
    private double[] ssBetweenG = null;
    private BigDecimal[] ssTotalBDG = null;
    private BigDecimal[] ssWithinBDG = null;
    private BigDecimal[] ssBetweenBDG = null;
    private int[] dofTotalG = null;
    private int[] dofBetweenG = null;
    private int[] dofWithinG = null;
    private boolean allCalcn = true;

    public ANOVA() {
        this.setTitle("Untitled data", false);
    }

    public ANOVA(String dataTitle) {
        this.setTitle(dataTitle, true);
    }

    public void enterTitle(String title) {
        this.setTitle(title, true);
    }

    private void setTitle(String title, boolean check2) {
        if (!check2) {
            this.title[0] = title;
            ++this.nTitle;
            this.titleCheck = check2;
        } else if (!this.titleCheck) {
            this.title[0] = title;
            ++this.nTitle;
            this.titleCheck = check2;
        } else {
            this.titleCheck = check2;
            this.title[this.nTitle] = title;
            ++this.nTitle;
        }
    }

    public void setCriticalSignificance(double critProb) {
        this.criticalSignificance = 1.0 - critProb;
        this.criticalSignificanceF = String.valueOf(Double.toString(100.0 * critProb)) + "%";
        this.criticalSignificanceS = String.valueOf(Double.toString(100.0 * (1.0 - critProb))) + "%";
    }

    public double getCriticalSignificance() {
        return 1.0 - this.criticalSignificance;
    }

    public void addDichotomousPair(String trueSign, String falseSign) {
        String[] holdS = (String[])this.dichotomousS.clone();
        double[] holdD = (double[])this.dichotomousDoubleS.clone();
        this.dichotomousS = new String[this.nDichotomousS + 2];
        this.dichotomousDoubleS = new double[this.nDichotomousS + 2];
        int i = 0;
        while (i < this.nDichotomousS) {
            this.dichotomousS[i] = holdS[i];
            this.dichotomousDoubleS[i] = holdD[i];
            ++i;
        }
        this.dichotomousS[this.nDichotomousS] = trueSign;
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotTrue;
        ++this.nDichotomousS;
        this.dichotomousS[this.nDichotomousS] = falseSign;
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotFalse;
        ++this.nDichotomousS;
        if (trueSign.length() == 1 && falseSign.length() == 1) {
            char[] holdC = (char[])this.dichotomousC.clone();
            holdD = (double[])this.dichotomousDoubleC.clone();
            this.dichotomousC = new char[this.nDichotomousC + 2];
            this.dichotomousDoubleC = new double[this.nDichotomousC + 2];
            int i2 = 0;
            while (i2 < this.nDichotomousC) {
                this.dichotomousC[i2] = holdC[i2];
                this.dichotomousDoubleC[i2] = holdD[i2];
                ++i2;
            }
            this.dichotomousC[this.nDichotomousC] = trueSign.charAt(0);
            this.dichotomousDoubleC[this.nDichotomousC] = this.dichotTrue;
            ++this.nDichotomousC;
            this.dichotomousC[this.nDichotomousC] = falseSign.charAt(0);
            this.dichotomousDoubleC[this.nDichotomousC] = this.dichotFalse;
            ++this.nDichotomousC;
        }
    }

    public void addDichotomousPair(char trueSign, char falseSign) {
        char[] holdC = (char[])this.dichotomousC.clone();
        double[] holdD = (double[])this.dichotomousDoubleC.clone();
        this.dichotomousC = new char[this.nDichotomousC + 2];
        this.dichotomousDoubleC = new double[this.nDichotomousC + 2];
        int i = 0;
        while (i < this.nDichotomousC) {
            this.dichotomousC[i] = holdC[i];
            this.dichotomousDoubleC[i] = holdD[i];
            ++i;
        }
        this.dichotomousC[this.nDichotomousC] = trueSign;
        this.dichotomousDoubleC[this.nDichotomousC] = this.dichotTrue;
        ++this.nDichotomousC;
        this.dichotomousC[this.nDichotomousC] = falseSign;
        this.dichotomousDoubleC[this.nDichotomousC] = this.dichotFalse;
        ++this.nDichotomousC;
        String[] holdS = (String[])this.dichotomousS.clone();
        holdD = (double[])this.dichotomousDoubleS.clone();
        this.dichotomousS = new String[this.nDichotomousS + 2];
        this.dichotomousDoubleS = new double[this.nDichotomousS + 2];
        int i2 = 0;
        while (i2 < this.nDichotomousS) {
            this.dichotomousS[i2] = holdS[i2];
            this.dichotomousDoubleS[i2] = holdD[i2];
            ++i2;
        }
        this.dichotomousS[this.nDichotomousS] = String.valueOf(trueSign);
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotTrue;
        ++this.nDichotomousS;
        this.dichotomousS[this.nDichotomousS] = String.valueOf(falseSign);
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotFalse;
        ++this.nDichotomousS;
    }

    public void setDichotomousPairValues(double first, double second) {
        this.dichotTrue = first;
        this.dichotFalse = second;
    }

    public double[] getDichotomousPairValues() {
        double[] ret = new double[]{this.dichotTrue, this.dichotFalse};
        return ret;
    }

    private void setAllCalcn(boolean check2) {
        this.allCalcn = check2;
    }

    public void readResponseData() {
        FileChooser fin = new FileChooser();
        String filename = fin.selectFile();
        fin.close();
        this.readResponseData(filename);
    }

    public void readResponseData(String filename) {
        this.inputFilename = filename;
        FileInput fin = new FileInput(filename);
        String hold0 = fin.readLine();
        this.setTitle(hold0, true);
        this.nGroups = fin.readInt();
        this.groupNames = new String[this.nGroups + 1];
        int i = 0;
        while (i < this.nGroups) {
            this.groupNames[i] = fin.readWord();
            ++i;
        }
        this.groupNames[this.nGroups] = "total";
        this.groupNamesSet = true;
        this.nResponsesPerGroup = new int[this.nGroups];
        i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = fin.readInt();
            ++i;
        }
        String[][] responses = new String[this.nGroups][];
        String[] hold = null;
        int i2 = 0;
        while (i2 < this.nGroups) {
            hold = new String[this.nResponsesPerGroup[i2]];
            int j = 0;
            while (j < this.nResponsesPerGroup[i2]) {
                hold[j] = fin.readWord();
                ++j;
            }
            responses[i2] = Conv.copy(hold);
            ++i2;
        }
        fin.close();
        this.originalDataType = 1;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(String[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 1;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(double[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 2;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(Matrix responses) {
        double[][] responsesdd = responses.getArrayCopy();
        this.nGroups = responsesdd.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responsesdd[i].length;
            ++i;
        }
        this.originalDataType = 3;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(BigDecimal[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 9;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(float[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 4;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(long[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 8;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(int[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 5;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(char[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 6;
        this.setVariables(responses, this.originalDataType);
    }

    public void enterResponseData(boolean[][] responses) {
        this.nGroups = responses.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.nResponsesPerGroup[i] = responses[i].length;
            ++i;
        }
        this.originalDataType = 7;
        this.setVariables(responses, this.originalDataType);
    }

    private void setVariables(Object responses, int type) {
        if (!this.groupNamesSet) {
            this.groupNames = new String[this.nGroups];
            int i = 0;
            while (i < this.nGroups) {
                this.groupNames[i] = "group " + (i + 1);
                ++i;
            }
        }
        this.originalData = Conv.copy(responses);
        this.originalDataType = type;
        this.dataEntered = true;
        this.convertDataType(type);
    }

    private void convertDataType(int type) {
        this.bigDecimal = false;
        switch (type) {
            case 1: {
                this.responses0 = new double[this.nGroups][];
                String[][] responses = (String[][])this.originalData;
                responses = this.trimResponses(responses);
                int i = 0;
                while (i < this.nGroups) {
                    boolean testAlphaBetic;
                    boolean testDichot = this.testIfDichotomous(responses[i]);
                    this.responses0[i] = testDichot ? this.dichotStringToDouble(responses[i]) : ((testAlphaBetic = this.testIfAlphabetic(responses[i])) ? this.alphabeticToDouble(responses[i]) : this.stringToDouble(responses[i]));
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 2: {
                this.responses0 = new double[this.nGroups][];
                double[][] responsesD = (double[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    this.responses0[i] = (double[])responsesD[i].clone();
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 3: {
                this.responses0 = new double[this.nGroups][];
                double[][] responsesDD = ((Matrix)this.originalData).getArrayCopy();
                int i = 0;
                while (i < this.nGroups) {
                    this.responses0[i] = (double[])responsesDD[i].clone();
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 4: {
                this.responses0 = new double[this.nGroups][];
                float[][] responsesF = (float[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    int j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.responses0[i][j] = responsesF[i][j];
                        ++j;
                    }
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 5: {
                this.responses0 = new double[this.nGroups][];
                int[][] responsesI = (int[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    int j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.responses0[i][j] = responsesI[i][j];
                        ++j;
                    }
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 6: {
                this.responses0 = new double[this.nGroups][];
                char[][] responsesC = (char[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    boolean testAlphaBetic;
                    boolean testDichotC = this.testIfDichotomous(responsesC[i]);
                    this.responses0[i] = testDichotC ? this.dichotCharToDouble(responsesC[i]) : ((testAlphaBetic = this.testIfAlphabetic(responsesC[i])) ? this.alphabeticToDouble(responsesC[i]) : this.charToDouble(responsesC[i]));
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 7: {
                this.responses0 = new double[this.nGroups][];
                boolean[][] responsesB = (boolean[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    int j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.responses0[i][j] = responsesB[i][j] ? 1.0 : -1.0;
                        ++j;
                    }
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 8: {
                this.responses0 = new double[this.nGroups][];
                long[][] responsesL = (long[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    int j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.responses0[i][j] = responsesL[i][j];
                        ++j;
                    }
                    ++i;
                }
                this.doubleToBD();
                break;
            }
            case 9: {
                this.responsesBD = new BigDecimal[this.nGroups][];
                BigDecimal[][] responsesBDH = (BigDecimal[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    this.responsesBD[i] = (BigDecimal[])responsesBDH[i].clone();
                    ++i;
                }
                this.bDtodouble();
                this.bigDecimal = true;
                break;
            }
            case 10: {
                this.responsesBD = new BigDecimal[this.nGroups][];
                BigInteger[][] responsesBI = (BigInteger[][])this.originalData;
                int i = 0;
                while (i < this.nGroups) {
                    this.responsesBD[i] = new BigDecimal[this.nResponsesPerGroup[i]];
                    int j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.responsesBD[i][j] = new BigDecimal(responsesBI[i][j]);
                        ++j;
                    }
                    ++i;
                }
                this.bDtodouble();
                this.bigDecimal = true;
            }
        }
        this.nTotalResponses = 0;
        int i = 0;
        while (i < this.nGroups) {
            this.nTotalResponses += this.nResponsesPerGroup[i];
            ++i;
        }
    }

    private void doubleToBD() {
        this.responsesBD = new BigDecimal[this.nGroups][];
        int i = 0;
        while (i < this.nGroups) {
            this.responsesBD[i] = new BigDecimal[this.nResponsesPerGroup[i]];
            int j = 0;
            while (j < this.nResponsesPerGroup[i]) {
                this.responsesBD[i][j] = new BigDecimal(this.responses0[i][j]);
                ++j;
            }
            ++i;
        }
    }

    private void bDtodouble() {
        this.responses0 = new double[this.nGroups][];
        int i = 0;
        while (i < this.nGroups) {
            this.responses0[i] = new double[this.nResponsesPerGroup[i]];
            int j = 0;
            while (j < this.nResponsesPerGroup[i]) {
                this.responses0[i][j] = this.responsesBD[i][j].doubleValue();
                ++j;
            }
            ++i;
        }
    }

    private boolean testIfDichotomous(String[] responses) {
        boolean test0 = false;
        int n = responses.length;
        int nD = 0;
        int i = 0;
        while (i < n) {
            boolean test1 = false;
            int j = 0;
            while (j < this.nDichotomousS) {
                if (responses[i].equalsIgnoreCase(this.dichotomousS[j])) {
                    test1 = true;
                }
                ++j;
            }
            if (test1) {
                ++nD;
            }
            ++i;
        }
        if (nD == n) {
            test0 = true;
        }
        return test0;
    }

    private boolean testIfDichotomous(char[] responses) {
        boolean test0 = false;
        int n = responses.length;
        int nD = 0;
        int i = 0;
        while (i < n) {
            boolean test1 = false;
            int j = 0;
            while (j < this.nDichotomousC) {
                if (responses[i] == this.dichotomousC[j]) {
                    test1 = true;
                }
                ++j;
            }
            if (test1) {
                ++nD;
            }
            ++i;
        }
        if (nD == n) {
            test0 = true;
        }
        return test0;
    }

    private boolean testIfAlphabetic(String[] responses) {
        boolean test0 = false;
        int n = responses.length;
        int nA = 0;
        int i = 0;
        while (i < n) {
            boolean test1 = false;
            if (responses[i].length() == 1) {
                char iC = responses[i].charAt(0);
                if (iC > '@' && iC < '[') {
                    test1 = true;
                } else if (iC > '`' && iC < '{') {
                    test1 = true;
                }
            }
            if (test1) {
                ++nA;
            }
            ++i;
        }
        if (nA == n) {
            test0 = true;
        }
        return test0;
    }

    private boolean testIfAlphabetic(char[] responses) {
        boolean test0 = false;
        int n = responses.length;
        int nA = 0;
        int i = 0;
        while (i < n) {
            boolean test1 = false;
            char iC = responses[i];
            if (iC > '@' && iC < '[') {
                test1 = true;
            } else if (iC > '`' && iC < '{') {
                test1 = true;
            }
            if (test1) {
                ++nA;
            }
            ++i;
        }
        if (nA == n) {
            test0 = true;
        }
        return test0;
    }

    private double[] dichotStringToDouble(String[] responses) {
        boolean test0 = false;
        int n = responses.length;
        double[] converted = new double[n];
        int i = 0;
        while (i < n) {
            boolean test1 = false;
            int j = 0;
            while (j < this.nDichotomousS) {
                if (responses[i].equalsIgnoreCase(this.dichotomousS[j])) {
                    test1 = true;
                }
                j += 2;
            }
            converted[i] = test1 ? 1.0 : -1.0;
            ++i;
        }
        return converted;
    }

    private double[] dichotCharToDouble(char[] responses) {
        boolean test0 = false;
        int n = responses.length;
        double[] converted = new double[n];
        int i = 0;
        while (i < n) {
            boolean test1 = false;
            int j = 0;
            while (j < this.nDichotomousC) {
                if (responses[i] == this.dichotomousC[j]) {
                    test1 = true;
                }
                j += 2;
            }
            converted[i] = test1 ? 1.0 : -1.0;
            ++i;
        }
        return converted;
    }

    private double[] alphabeticToDouble(String[] responses) {
        int n = responses.length;
        double[] converted = new double[n];
        int i = 0;
        while (i < n) {
            double holdi = responses[i].charAt(0);
            converted[i] = holdi > 96.0 ? holdi - 96.0 : holdi - 64.0;
            ++i;
        }
        return converted;
    }

    private double[] alphabeticToDouble(char[] responses) {
        int n = responses.length;
        double[] converted = new double[n];
        int i = 0;
        while (i < n) {
            double holdi = responses[i];
            converted[i] = holdi > 96.0 ? holdi - 96.0 : holdi - 64.0;
            ++i;
        }
        return converted;
    }

    private double[] stringToDouble(String[] responses) {
        int n = responses.length;
        double[] converted = new double[n];
        int i = 0;
        while (i < n) {
            converted[i] = Double.parseDouble(responses[i]);
            ++i;
        }
        return converted;
    }

    private double[] charToDouble(char[] responses) {
        int n = responses.length;
        double[] converted = new double[n];
        int i = 0;
        while (i < n) {
            double holdi = responses[i];
            converted[i] = holdi > 96.0 ? holdi - 96.0 : holdi - 64.0;
            ++i;
        }
        return converted;
    }

    private String[][] trimResponses(String[][] responses) {
        String[][] responsesT = (String[][])responses.clone();
        int n = responses.length;
        int m = responses[0].length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                responsesT[i][j].trim();
                ++j;
            }
            ++i;
        }
        return responsesT;
    }

    public Object getResponsesAsEntered() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.originalData);
    }

    public double[][] getResponses() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.responses0);
    }

    public double[][] getResponsesAsdouble() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.responses0);
    }

    public BigDecimal[][] getResponsesAsBigDecimal() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.responsesBD);
    }

    public String[] getTitle() {
        String[] ret = new String[this.nTitle];
        int i = 0;
        while (i < this.nTitle) {
            ret[i] = this.title[i];
            ++i;
        }
        return ret;
    }

    public String getInputFileName() {
        return this.inputFilename;
    }

    public void enterGroupNames(String[] groupNames) {
        int len = groupNames.length;
        this.groupNames = new String[len + 1];
        int i = 0;
        while (i < len) {
            this.groupNames[i] = groupNames[i];
            ++i;
        }
        this.groupNames[len] = "total";
        this.groupNamesSet = true;
    }

    public int getNumberOfGroups() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return this.nGroups;
    }

    public String[] getGroupNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] ret = new String[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            ret[i] = this.groupNames[i];
            ++i;
        }
        return ret;
    }

    public String getGroupName(int index2) {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        return this.groupNames[index2 - 1];
    }

    private void groupStatistics() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        this.groupMeansBD = new BigDecimal[this.nGroups];
        this.groupMeans = new double[this.nGroups];
        this.groupSD = new double[this.nGroups];
        this.groupSE = new double[this.nGroups];
        this.groupClb = new double[this.nGroups];
        this.groupCub = new double[this.nGroups];
        this.groupMinimumBD = new BigDecimal[this.nGroups];
        this.groupMinimum = new double[this.nGroups];
        this.groupMaximumBD = new BigDecimal[this.nGroups];
        this.groupMaximum = new double[this.nGroups];
        this.groupSSBD = new BigDecimal[this.nGroups];
        this.groupSS = new double[this.nGroups];
        this.groupMedians = new double[this.nGroups];
        this.groupMediansBD = new BigDecimal[this.nGroups];
        this.groupMomentSkewness = new double[this.nGroups];
        this.groupMedianSkewness = new double[this.nGroups];
        this.groupQuartileSkewness = new double[this.nGroups];
        this.groupQuartileSkewnessBD = new BigDecimal[this.nGroups];
        this.groupKurtosis = new double[this.nGroups];
        this.groupKurtosisBD = new BigDecimal[this.nGroups];
        this.groupExcessKurtosis = new double[this.nGroups];
        this.groupExcessKurtosisBD = new BigDecimal[this.nGroups];
        this.groupProbPlotR = new double[this.nGroups];
        this.groupProbPlotGradient = new double[this.nGroups];
        this.groupProbPlotIntercept = new double[this.nGroups];
        this.groupProbPlotMu = new double[this.nGroups];
        this.groupProbPlotSigma = new double[this.nGroups];
        Stat st = null;
        ProbabilityPlot pp = null;
        int i = 0;
        while (i < this.nGroups) {
            st = new Stat(this.responses0[i]);
            this.groupMeans[i] = st.mean();
            this.groupMeansBD[i] = new BigDecimal(this.groupMeans[i]);
            this.groupSD[i] = st.standardDeviation();
            this.groupSE[i] = st.standardError();
            double[] limits = st.meanConfidenceLimits(this.criticalSignificance);
            this.groupClb[i] = limits[0];
            this.groupCub[i] = limits[1];
            this.groupMinimum[i] = st.minimum();
            this.groupMinimumBD[i] = new BigDecimal(this.groupMinimum[i]);
            this.groupMaximum[i] = st.maximum();
            this.groupMaximumBD[i] = new BigDecimal(this.groupMaximum[i]);
            double ss = 0.0;
            int j = 0;
            while (j < this.nResponsesPerGroup[i]) {
                double hold = this.responses0[i][j] - this.groupMeans[i];
                ss += hold * hold;
                ++j;
            }
            this.groupSS[i] = ss;
            this.groupSSBD[i] = new BigDecimal(ss);
            this.groupMedians[i] = st.median_as_double();
            this.groupMediansBD[i] = new BigDecimal(this.groupMedians[i]);
            this.groupMomentSkewness[i] = st.momentSkewness_as_double();
            this.groupMedianSkewness[i] = st.medianSkewness_as_double();
            this.groupQuartileSkewness[i] = st.quartileSkewness_as_double();
            this.groupQuartileSkewnessBD[i] = new BigDecimal(this.groupQuartileSkewness[i]);
            this.groupKurtosis[i] = st.kurtosis_as_double();
            this.groupKurtosisBD[i] = new BigDecimal(this.groupKurtosis[i]);
            this.groupExcessKurtosis[i] = st.excessKurtosis_as_double();
            this.groupExcessKurtosisBD[i] = new BigDecimal(this.groupExcessKurtosis[i]);
            pp = new ProbabilityPlot(this.responses0[i]);
            pp.supressDisplay();
            pp.gaussianProbabilityPlot();
            this.groupProbPlotR[i] = pp.gaussianCorrelationCoefficient();
            this.groupProbPlotGradient[i] = pp.gaussianGradient();
            this.groupProbPlotIntercept[i] = pp.gaussianIntercept();
            this.groupProbPlotMu[i] = pp.gaussianMu();
            this.groupProbPlotSigma[i] = pp.gaussianSigma();
            ++i;
        }
        double[] allAsOne = new double[this.nTotalResponses];
        int k = 0;
        int i2 = 0;
        while (i2 < this.nGroups) {
            int j = 0;
            while (j < this.nResponsesPerGroup[i2]) {
                allAsOne[k++] = this.responses0[i2][j];
                ++j;
            }
            ++i2;
        }
        Stat st1 = new Stat(allAsOne);
        this.totalMean = st1.mean();
        this.totalMeanBD = new BigDecimal(this.totalMean);
        this.totalSD = st1.standardDeviation();
        this.totalSE = st1.standardError();
        double[] limits = st1.meanConfidenceLimits(this.criticalSignificance);
        this.totalClb = limits[0];
        this.totalCub = limits[1];
        this.totalMinimum = st1.minimum();
        this.totalMinimumBD = new BigDecimal(this.totalMinimum);
        this.totalMaximum = st1.maximum();
        this.totalMaximumBD = new BigDecimal(this.totalMaximum);
        double ss = 0.0;
        int j = 0;
        while (j < this.nTotalResponses) {
            double hold = allAsOne[j] - this.totalMean;
            ss += hold * hold;
            ++j;
        }
        this.totalSS = ss;
        this.totalSSBD = new BigDecimal(ss);
        this.totalMedian = st1.median_as_double();
        this.totalMedianBD = new BigDecimal(this.totalMedian);
        this.totalMomentSkewness = st1.momentSkewness_as_double();
        this.totalMedianSkewness = st1.medianSkewness_as_double();
        this.totalQuartileSkewness = st1.quartileSkewness_as_double();
        this.totalQuartileSkewnessBD = new BigDecimal(this.totalQuartileSkewness);
        this.totalKurtosis = st1.kurtosis_as_double();
        this.totalKurtosisBD = new BigDecimal(this.totalKurtosis);
        this.totalExcessKurtosis = st1.excessKurtosis_as_double();
        this.totalExcessKurtosisBD = new BigDecimal(this.totalExcessKurtosis);
        ProbabilityPlot pp1 = new ProbabilityPlot(allAsOne);
        pp1.supressDisplay();
        pp1.gaussianProbabilityPlot();
        this.totalProbPlotR = pp1.gaussianCorrelationCoefficient();
        this.totalProbPlotGradient = pp1.gaussianGradient();
        this.totalProbPlotIntercept = pp1.gaussianIntercept();
        this.totalProbPlotMu = pp1.gaussianMu();
        this.totalProbPlotSigma = pp1.gaussianSigma();
        this.groupStatsDone = true;
    }

    private void groupStatisticsBD() {
        int j;
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        this.groupMeansBD = new BigDecimal[this.nGroups];
        this.groupMeans = new double[this.nGroups];
        this.groupSD = new double[this.nGroups];
        this.groupSE = new double[this.nGroups];
        this.groupClb = new double[this.nGroups];
        this.groupCub = new double[this.nGroups];
        this.groupMinimumBD = new BigDecimal[this.nGroups];
        this.groupMinimum = new double[this.nGroups];
        this.groupMaximumBD = new BigDecimal[this.nGroups];
        this.groupMaximum = new double[this.nGroups];
        this.groupSSBD = new BigDecimal[this.nGroups];
        this.groupSS = new double[this.nGroups];
        this.groupMedians = new double[this.nGroups];
        this.groupMediansBD = new BigDecimal[this.nGroups];
        this.groupMomentSkewness = new double[this.nGroups];
        this.groupMedianSkewness = new double[this.nGroups];
        this.groupQuartileSkewness = new double[this.nGroups];
        this.groupQuartileSkewnessBD = new BigDecimal[this.nGroups];
        this.groupKurtosis = new double[this.nGroups];
        this.groupKurtosisBD = new BigDecimal[this.nGroups];
        this.groupExcessKurtosis = new double[this.nGroups];
        this.groupExcessKurtosisBD = new BigDecimal[this.nGroups];
        this.groupProbPlotR = new double[this.nGroups];
        this.groupProbPlotGradient = new double[this.nGroups];
        this.groupProbPlotIntercept = new double[this.nGroups];
        this.groupProbPlotMu = new double[this.nGroups];
        this.groupProbPlotSigma = new double[this.nGroups];
        Stat st = null;
        ProbabilityPlot pp = null;
        int i = 0;
        while (i < this.nGroups) {
            st = new Stat(this.responsesBD[i]);
            this.groupMeansBD[i] = st.mean_as_BigDecimal();
            this.groupMeans[i] = this.groupMeansBD[i].doubleValue();
            this.groupSD[i] = st.standardDeviation();
            this.groupSE[i] = st.standardError();
            double[] limits = st.meanConfidenceLimits(this.criticalSignificance);
            this.groupClb[i] = limits[0];
            this.groupCub[i] = limits[1];
            this.groupMinimumBD[i] = st.minimum_as_BigDecimal();
            this.groupMinimum[i] = st.minimum_as_double();
            this.groupMaximumBD[i] = st.maximum_as_BigDecimal();
            this.groupMaximum[i] = st.maximum_as_double();
            BigDecimal ss = new BigDecimal("0.0");
            j = 0;
            while (j < this.nResponsesPerGroup[i]) {
                BigDecimal hold = this.responsesBD[i][j].subtract(this.groupMeansBD[i]);
                ss = ss.add(hold.multiply(hold));
                ++j;
            }
            this.groupSSBD[i] = ss;
            this.groupSS[i] = ss.doubleValue();
            this.groupMediansBD[i] = st.median_as_BigDecimal();
            this.groupMedians[i] = this.groupMediansBD[i].doubleValue();
            this.groupMomentSkewness[i] = st.momentSkewness_as_double();
            this.groupMedianSkewness[i] = st.medianSkewness_as_double();
            this.groupQuartileSkewnessBD[i] = st.quartileSkewness_as_BigDecimal();
            this.groupQuartileSkewness[i] = this.groupQuartileSkewnessBD[i].doubleValue();
            this.groupKurtosis[i] = st.kurtosis_as_double();
            this.groupKurtosisBD[i] = new BigDecimal(this.groupKurtosis[i]);
            this.groupExcessKurtosisBD[i] = st.excessKurtosis_as_BigDecimal();
            this.groupExcessKurtosis[i] = this.groupExcessKurtosisBD[i].doubleValue();
            pp = new ProbabilityPlot(this.responses0[i]);
            pp.supressDisplay();
            pp.gaussianProbabilityPlot();
            this.groupProbPlotR[i] = pp.gaussianCorrelationCoefficient();
            this.groupProbPlotGradient[i] = pp.gaussianGradient();
            this.groupProbPlotIntercept[i] = pp.gaussianIntercept();
            this.groupProbPlotMu[i] = pp.gaussianMu();
            this.groupProbPlotSigma[i] = pp.gaussianSigma();
            ++i;
        }
        BigDecimal[] allAsOne = new BigDecimal[this.nTotalResponses];
        int k = 0;
        int i2 = 0;
        while (i2 < this.nGroups) {
            j = 0;
            while (j < this.nResponsesPerGroup[i2]) {
                allAsOne[k++] = this.responsesBD[i2][j];
                ++j;
            }
            ++i2;
        }
        Stat st1 = new Stat(allAsOne);
        this.totalMeanBD = st1.mean_as_BigDecimal();
        this.totalMean = this.totalMeanBD.doubleValue();
        this.totalSD = st1.standardDeviation();
        this.totalSE = st1.standardError();
        double[] limits = st1.meanConfidenceLimits(this.criticalSignificance);
        this.totalClb = limits[0];
        this.totalCub = limits[1];
        this.totalMinimumBD = st1.minimum_as_BigDecimal();
        this.totalMinimum = this.totalMinimumBD.doubleValue();
        this.totalMaximumBD = st1.maximum_as_BigDecimal();
        this.totalMaximum = this.totalMaximumBD.doubleValue();
        BigDecimal ss = new BigDecimal("0.0");
        int j2 = 0;
        while (j2 < this.nTotalResponses) {
            BigDecimal hold = allAsOne[j2].subtract(this.totalMeanBD);
            ss = ss.add(hold.multiply(hold));
            ++j2;
        }
        this.totalSSBD = ss;
        this.totalSS = this.totalSSBD.doubleValue();
        this.totalMedianBD = st1.median_as_BigDecimal();
        this.totalMedian = this.totalMedianBD.doubleValue();
        this.totalMomentSkewness = st1.momentSkewness_as_double();
        this.totalMedianSkewness = st1.medianSkewness_as_double();
        this.totalQuartileSkewnessBD = st1.quartileSkewness_as_BigDecimal();
        this.totalQuartileSkewness = this.totalQuartileSkewnessBD.doubleValue();
        this.totalKurtosis = st1.kurtosis_as_double();
        this.totalKurtosisBD = new BigDecimal(this.totalKurtosis);
        this.totalExcessKurtosisBD = st1.excessKurtosis_as_BigDecimal();
        this.totalExcessKurtosis = this.totalExcessKurtosisBD.doubleValue();
        ProbabilityPlot pp1 = new ProbabilityPlot(allAsOne);
        pp1.supressDisplay();
        pp1.gaussianProbabilityPlot();
        this.totalProbPlotR = pp1.gaussianCorrelationCoefficient();
        this.totalProbPlotGradient = pp1.gaussianGradient();
        this.totalProbPlotIntercept = pp1.gaussianIntercept();
        this.totalProbPlotMu = pp1.gaussianMu();
        this.totalProbPlotSigma = pp1.gaussianSigma();
        this.groupStatsDone = true;
    }

    public int[] numberOfResponsesPerGroup() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return this.nResponsesPerGroup;
    }

    public double[] groupMeans() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMeans);
    }

    public BigDecimal[] groupMeans_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMeansBD);
    }

    public double[] groupStandardDeviations() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupSD);
    }

    public double[] groupStandardErrors() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupSE);
    }

    public double[] groupMeanLowerConfidenceLimits() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupClb);
    }

    public double[] groupMeanUpperConfidenceLimits() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupCub);
    }

    public double[] groupMaxima() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMaximum);
    }

    public BigDecimal[] groupMaxima_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMaximumBD);
    }

    public double[] groupMinima() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMinimum);
    }

    public BigDecimal[] groupMinima_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMinimumBD);
    }

    public double[] groupMedians() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMedians);
    }

    public BigDecimal[] groupMedians_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMediansBD);
    }

    public double[] groupMomentSkewnesses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMomentSkewness);
    }

    public double[] groupMedianSkewnesses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMedianSkewness);
    }

    public double[] groupQuartileSkewnesses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupQuartileSkewness);
    }

    public BigDecimal[] groupQuartileSkewnesses_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupQuartileSkewnessBD);
    }

    public double[] groupKurtoses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupKurtosis);
    }

    public BigDecimal[] groupKurtoses_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupKurtosisBD);
    }

    public double[] groupExcessKurtoses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupExcessKurtosis);
    }

    public BigDecimal[] groupExcessKurtoses_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupExcessKurtosisBD);
    }

    public double[] groupGPPcorrelationCoefficient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotR);
    }

    public double[] groupGPPgradient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotGradient);
    }

    public double[] groupGPPintercept() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotIntercept);
    }

    public double[] groupGPPmu() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotMu);
    }

    public double[] groupGPPsigma() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotSigma);
    }

    public double[] groupSumOfSquares() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupSS);
    }

    public BigDecimal[] groupSumOfSquares_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupSSBD);
    }

    public double totalMean() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMean;
    }

    public BigDecimal totalMean_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMeanBD;
    }

    public double totalStandardDeviation() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalSD;
    }

    public double totalStandardError() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalSE;
    }

    public double totalMeanLowerConfidenceLimit() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalClb;
    }

    public double totalMeanUpperConfidenceLimit() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalCub;
    }

    public double totalMaximum() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMaximum;
    }

    public BigDecimal totalMaxima_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMaximumBD;
    }

    public double totalMinimum() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMinimum;
    }

    public BigDecimal totalMinimum_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMinimumBD;
    }

    public double totalMedian() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMedian;
    }

    public BigDecimal totalMedian_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMedianBD;
    }

    public double totalMomentSkewness() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMomentSkewness;
    }

    public double totalMedianSkewness() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMedianSkewness;
    }

    public double totalQuartileSkewness() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalQuartileSkewness;
    }

    public BigDecimal totalQuartileSkewness_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalQuartileSkewnessBD;
    }

    public double totalKurtosis() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalKurtosis;
    }

    public BigDecimal totalKurtosis_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalKurtosisBD;
    }

    public double totalExcessKurtosis() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalExcessKurtosis;
    }

    public BigDecimal totalExcessKurtosis_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalExcessKurtosisBD;
    }

    public double totalGPPcorrelationCoefficient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotR;
    }

    public double totalGPPgradient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotGradient;
    }

    public double totalGPPintercept() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotIntercept;
    }

    public double totalGPPmu() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotMu;
    }

    public double totalGPPsigma() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotSigma;
    }

    public double totalSumOfSquares() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalSS;
    }

    public BigDecimal totalSumOfSquares_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalSSBD;
    }

    public void oneWayAnalysis() {
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d();
        } else {
            this.oneWayAnalysis_BD();
        }
    }

    public void oneWayAnalysisWithPairComparison() {
        this.comparison = true;
        this.nComparisons = this.nGroups * (this.nGroups - 1) / 2;
        this.compGroups = new boolean[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.compGroups[i] = true;
            ++i;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d();
        } else {
            this.oneWayAnalysis_BD();
        }
    }

    public void oneWayAnalysisWithPairComparison(int ii, int jj) {
        if (ii == jj) {
            throw new IllegalArgumentException("the two groups must be different");
        }
        if (ii < 1 || ii > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + ii + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        if (jj < 1 || jj > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + jj + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        this.comparison = true;
        this.compGroups = new boolean[this.nGroups];
        this.nComparisons = 1;
        --ii;
        --jj;
        int i = 0;
        while (i < this.nGroups) {
            this.compGroups[i] = false;
            if (i == ii) {
                this.compGroups[i] = true;
            }
            if (i == jj) {
                this.compGroups[i] = true;
            }
            ++i;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d();
        } else {
            this.oneWayAnalysis_BD();
        }
    }

    private void oneWayAnalysis_d() {
        this.oneWayANOVA_d();
        this.outputAnalysis();
    }

    private void oneWayAnalysis_BD() {
        this.oneWayANOVA_d();
        this.outputAnalysis();
    }

    public void oneWayAnalysis(String filename) {
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d(filename);
        } else {
            this.oneWayAnalysis_BD(filename);
        }
    }

    public void oneWayAnalysisWithPairComparison(String filename) {
        this.comparison = true;
        this.nComparisons = this.nGroups * (this.nGroups - 1) / 2;
        this.compGroups = new boolean[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.compGroups[i] = true;
            ++i;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d(filename);
        } else {
            this.oneWayAnalysis_BD(filename);
        }
    }

    public void oneWayAnalysisWithPairComparison(int ii, int jj, String filename) {
        if (ii == jj) {
            throw new IllegalArgumentException("the two groups must be different");
        }
        if (ii < 1 || ii > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + ii + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        if (jj < 1 || jj > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + jj + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        this.comparison = true;
        this.compGroups = new boolean[this.nGroups];
        this.nComparisons = 1;
        --ii;
        --jj;
        int i = 0;
        while (i < this.nGroups) {
            this.compGroups[i] = false;
            if (i == ii) {
                this.compGroups[i] = true;
            }
            if (i == jj) {
                this.compGroups[i] = true;
            }
            ++i;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d(filename);
        } else {
            this.oneWayAnalysis_BD(filename);
        }
    }

    private void oneWayAnalysis_d(String filename) {
        this.oneWayANOVA_d();
        this.outputAnalysis(filename);
    }

    private void oneWayAnalysis_BD(String filename) {
        this.oneWayANOVA_BD();
        this.outputAnalysis(filename);
    }

    public void oneWayANOVA() {
        if (!this.bigDecimal) {
            this.oneWayANOVA_d();
        } else {
            this.oneWayANOVA_BD();
        }
    }

    public void oneWayANOVAwithPairComparison() {
        this.comparison = true;
        this.nComparisons = this.nGroups * (this.nGroups - 1) / 2;
        this.compGroups = new boolean[this.nGroups];
        int i = 0;
        while (i < this.nGroups) {
            this.compGroups[i] = true;
            ++i;
        }
        if (!this.bigDecimal) {
            this.oneWayANOVA_d();
        } else {
            this.oneWayANOVA_BD();
        }
    }

    public void oneWayANOVAwithPairComparison(int ii, int jj) {
        if (ii == jj) {
            throw new IllegalArgumentException("the two groups must be different");
        }
        if (ii < 1 || ii > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + ii + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        if (jj < 1 || jj > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + jj + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        this.comparison = true;
        this.compGroups = new boolean[this.nGroups];
        this.nComparisons = 1;
        --ii;
        --jj;
        int i = 0;
        while (i < this.nGroups) {
            this.compGroups[i] = false;
            if (i == ii) {
                this.compGroups[i] = true;
            }
            if (i == jj) {
                this.compGroups[i] = true;
            }
            ++i;
        }
        if (!this.bigDecimal) {
            this.oneWayANOVA_d();
        } else {
            this.oneWayANOVA_BD();
        }
    }

    private void oneWayANOVA_d() {
        if (!this.groupStatsDone) {
            if (this.allCalcn) {
                this.groupStatistics();
            } else {
                int j;
                this.totalMean = 0.0;
                int i = 0;
                while (i < this.nGroups) {
                    j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.totalMean += this.responses0[i][j];
                        ++j;
                    }
                    ++i;
                }
                this.totalMean /= (double)this.nTotalResponses;
                this.totalMeanBD = new BigDecimal(this.totalMean);
                this.groupMeans = new double[this.nGroups];
                this.groupMeansBD = new BigDecimal[this.nGroups];
                i = 0;
                while (i < this.nGroups) {
                    this.groupMeans[i] = 0.0;
                    j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        int n = i;
                        this.groupMeans[n] = this.groupMeans[n] + this.responses0[i][j];
                        ++j;
                    }
                    int n = i;
                    this.groupMeans[n] = this.groupMeans[n] / (double)this.nResponsesPerGroup[i];
                    this.groupMeansBD[i] = new BigDecimal(this.groupMeans[i]);
                    ++i;
                }
            }
        }
        this.dofTotal = this.nTotalResponses - 1;
        this.dofBetweenGroups = this.nGroups - 1;
        this.dofWithinGroups = this.nTotalResponses - this.nGroups;
        double sst = 0.0;
        double ssb = 0.0;
        double ssw = 0.0;
        double hold = 0.0;
        int i = 0;
        while (i < this.nGroups) {
            int j = 0;
            while (j < this.nResponsesPerGroup[i]) {
                hold = this.responses0[i][j] - this.totalMean;
                sst += hold * hold;
                hold = this.groupMeans[i] - this.totalMean;
                ssb += hold * hold;
                hold = this.responses0[i][j] - this.groupMeans[i];
                ssw += hold * hold;
                ++j;
            }
            ++i;
        }
        this.ssTotal = sst;
        this.ssTotalBD = new BigDecimal(sst);
        this.meanSquareTotal = sst / (double)this.dofTotal;
        this.meanSquareTotalBD = new BigDecimal(this.meanSquareTotal);
        this.ssBetween = ssb;
        this.ssBetweenBD = new BigDecimal(ssb);
        this.meanSquareBetween = ssb / (double)this.dofBetweenGroups;
        this.meanSquareBetweenBD = new BigDecimal(this.meanSquareBetween);
        this.ssWithin = ssw;
        this.ssWithinBD = new BigDecimal(ssw);
        this.meanSquareWithin = ssw / (double)this.dofWithinGroups;
        this.meanSquareWithinBD = new BigDecimal(this.meanSquareWithin);
        this.fRatio = this.meanSquareBetween / this.meanSquareWithin;
        this.fRatioBD = new BigDecimal(this.fRatio);
        this.fRatioP = Stat.fCompCDF(this.fRatio, this.dofBetweenGroups, this.dofWithinGroups);
        this.criticalFratio = Stat.fDistributionInverseCDF(this.dofBetweenGroups, this.dofWithinGroups, this.criticalSignificance);
        if (this.nGroups > 2 && this.comparison) {
            this.meanSquareTotalG = new double[this.nComparisons];
            this.meanSquareWithinG = new double[this.nComparisons];
            this.meanSquareBetweenG = new double[this.nComparisons];
            this.meanSquareTotalBDG = new BigDecimal[this.nComparisons];
            this.meanSquareWithinBDG = new BigDecimal[this.nComparisons];
            this.meanSquareBetweenBDG = new BigDecimal[this.nComparisons];
            this.fRatioG = new double[this.nComparisons];
            this.fRatioBDG = new BigDecimal[this.nComparisons];
            this.fRatioPG = new double[this.nComparisons];
            this.criticalFratioG = new double[this.nComparisons];
            this.ssTotalG = new double[this.nComparisons];
            this.ssWithinG = new double[this.nComparisons];
            this.ssBetweenG = new double[this.nComparisons];
            this.ssTotalBDG = new BigDecimal[this.nComparisons];
            this.ssWithinBDG = new BigDecimal[this.nComparisons];
            this.ssBetweenBDG = new BigDecimal[this.nComparisons];
            this.dofTotalG = new int[this.nComparisons];
            this.dofBetweenG = new int[this.nComparisons];
            this.dofWithinG = new int[this.nComparisons];
            this.pairIndices = new int[this.nComparisons][2];
            double[][] comp = new double[2][];
            int counter = 0;
            int i2 = 0;
            while (i2 < this.nGroups - 1) {
                int j = i2 + 1;
                while (j < this.nGroups) {
                    if (this.compGroups[i2] && this.compGroups[j]) {
                        comp[0] = this.responses0[i2];
                        comp[1] = this.responses0[j];
                        this.pairIndices[counter][0] = i2;
                        this.pairIndices[counter][1] = j;
                        ANOVA av = new ANOVA();
                        av.setAllCalcn(false);
                        av.enterResponseData(comp);
                        av.oneWayANOVA();
                        this.ssTotalG[counter] = av.totalSumOfSquares();
                        this.ssWithinG[counter] = av.withinGroupsSumOfSquares();
                        this.ssBetweenG[counter] = av.betweenGroupsSumOfSquares();
                        this.ssTotalBDG[counter] = new BigDecimal(this.ssTotalG[counter]);
                        this.ssWithinBDG[counter] = new BigDecimal(this.ssWithinG[counter]);
                        this.ssBetweenBDG[counter] = new BigDecimal(this.ssBetweenG[counter]);
                        this.meanSquareTotalG[counter] = av.totalMeanSquare();
                        this.meanSquareWithinG[counter] = av.withinGroupsMeanSquare();
                        this.meanSquareBetweenG[counter] = av.betweenGroupsMeanSquare();
                        this.meanSquareTotalBDG[counter] = new BigDecimal(this.meanSquareTotalG[counter]);
                        this.meanSquareWithinBDG[counter] = new BigDecimal(this.meanSquareWithinG[counter]);
                        this.meanSquareBetweenBDG[counter] = new BigDecimal(this.meanSquareBetweenG[counter]);
                        this.fRatioG[counter] = av.oneWayFratio();
                        this.fRatioBDG[counter] = new BigDecimal(this.fRatioG[counter]);
                        this.fRatioPG[counter] = av.oneWaySignificance();
                        this.criticalFratioG[counter] = av.criticalFratio();
                        this.dofTotalG[counter] = av.totalDoF();
                        this.dofBetweenG[counter] = av.betweenGroupsDoF();
                        this.dofWithinG[counter] = av.withinGroupsDoF();
                        ++counter;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        this.oneWayDone = true;
    }

    private void oneWayANOVA_BD() {
        if (!this.groupStatsDone) {
            if (this.allCalcn) {
                this.groupStatisticsBD();
            } else {
                int j;
                this.totalMeanBD = new BigDecimal("0.0");
                int i = 0;
                while (i < this.nGroups) {
                    j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.totalMeanBD = this.totalMeanBD.add(this.responsesBD[i][j]);
                        ++j;
                    }
                    ++i;
                }
                this.totalMeanBD = this.totalMeanBD.divide(new BigDecimal(this.nTotalResponses), 4);
                this.totalMean = this.totalMeanBD.doubleValue();
                this.groupMeans = new double[this.nGroups];
                this.groupMeansBD = new BigDecimal[this.nGroups];
                i = 0;
                while (i < this.nGroups) {
                    this.groupMeansBD[i] = new BigDecimal("0.0");
                    j = 0;
                    while (j < this.nResponsesPerGroup[i]) {
                        this.groupMeansBD[i] = this.groupMeansBD[i].add(this.responsesBD[i][j]);
                        ++j;
                    }
                    this.groupMeansBD[i] = this.groupMeansBD[i].divide(new BigDecimal(this.nResponsesPerGroup[i]), 4);
                    this.groupMeans[i] = this.groupMeansBD[i].doubleValue();
                    ++i;
                }
            }
        }
        this.dofTotal = this.nTotalResponses - 1;
        this.dofBetweenGroups = this.nGroups - 1;
        this.dofWithinGroups = this.nTotalResponses - this.nGroups;
        BigDecimal sst = new BigDecimal("0.0");
        BigDecimal ssb = new BigDecimal("0.0");
        BigDecimal ssw = new BigDecimal("0.0");
        BigDecimal hold = new BigDecimal("0.0");
        int i = 0;
        while (i < this.nGroups) {
            int j = 0;
            while (j < this.nResponsesPerGroup[i]) {
                hold = this.responsesBD[i][j].subtract(this.totalMeanBD);
                sst = sst.add(hold.multiply(hold));
                hold = this.groupMeansBD[i].subtract(this.totalMeanBD);
                ssb = ssb.add(hold.multiply(hold));
                hold = this.responsesBD[i][j].subtract(this.groupMeansBD[i]);
                ssw = ssw.add(hold.multiply(hold));
                ++j;
            }
            ++i;
        }
        this.ssTotalBD = sst;
        this.ssTotal = sst.doubleValue();
        this.meanSquareTotalBD = sst.divide(new BigDecimal((double)this.dofTotal), 4);
        this.meanSquareTotal = this.meanSquareTotalBD.doubleValue();
        this.totalSD = Math.sqrt(this.meanSquareTotalBD.doubleValue());
        this.ssBetweenBD = ssb;
        this.ssBetween = ssb.doubleValue();
        this.meanSquareBetweenBD = ssb.divide(new BigDecimal((double)this.dofBetweenGroups), 4);
        this.meanSquareBetween = this.meanSquareBetweenBD.doubleValue();
        this.ssWithinBD = ssw;
        this.ssWithin = ssw.doubleValue();
        this.meanSquareWithinBD = ssw.divide(new BigDecimal((double)this.dofWithinGroups), 4);
        this.meanSquareWithin = this.meanSquareWithinBD.doubleValue();
        this.fRatioBD = this.meanSquareBetweenBD.divide(this.meanSquareWithinBD, 4);
        this.fRatio = this.fRatioBD.doubleValue();
        this.fRatioP = Stat.fCompCDF(this.fRatio, this.dofBetweenGroups, this.dofWithinGroups);
        this.criticalFratio = Stat.fDistributionInverseCDF(this.dofBetweenGroups, this.dofWithinGroups, this.criticalSignificance);
        if (this.nGroups > 2 && this.comparison) {
            this.meanSquareTotalG = new double[this.nComparisons];
            this.meanSquareWithinG = new double[this.nComparisons];
            this.meanSquareBetweenG = new double[this.nComparisons];
            this.meanSquareTotalBDG = new BigDecimal[this.nComparisons];
            this.meanSquareWithinBDG = new BigDecimal[this.nComparisons];
            this.meanSquareBetweenBDG = new BigDecimal[this.nComparisons];
            this.fRatioG = new double[this.nComparisons];
            this.fRatioBDG = new BigDecimal[this.nComparisons];
            this.fRatioPG = new double[this.nComparisons];
            this.criticalFratioG = new double[this.nComparisons];
            this.ssTotalG = new double[this.nComparisons];
            this.ssWithinG = new double[this.nComparisons];
            this.ssBetweenG = new double[this.nComparisons];
            this.ssTotalBDG = new BigDecimal[this.nComparisons];
            this.ssWithinBDG = new BigDecimal[this.nComparisons];
            this.ssBetweenBDG = new BigDecimal[this.nComparisons];
            this.dofTotalG = new int[this.nComparisons];
            this.dofBetweenG = new int[this.nComparisons];
            this.dofWithinG = new int[this.nComparisons];
            this.pairIndices = new int[this.nComparisons][2];
            BigDecimal[][] comp = new BigDecimal[2][];
            int counter = 0;
            int i2 = 0;
            while (i2 < this.nGroups - 1) {
                int j = i2 + 1;
                while (j < this.nGroups) {
                    if (this.compGroups[i2] && this.compGroups[j]) {
                        comp[0] = this.responsesBD[i2];
                        comp[1] = this.responsesBD[j];
                        this.pairIndices[counter][0] = i2;
                        this.pairIndices[counter][1] = j;
                        ANOVA av = new ANOVA();
                        av.setAllCalcn(false);
                        av.enterResponseData(comp);
                        av.oneWayANOVA();
                        this.ssTotalBDG[counter] = av.totalSumOfSquares_as_BD();
                        this.ssWithinBDG[counter] = av.withinGroupsSumOfSquares_as_BD();
                        this.ssBetweenBDG[counter] = av.betweenGroupsSumOfSquares_as_BD();
                        this.ssTotalG[counter] = this.ssTotalBDG[counter].doubleValue();
                        this.ssWithinG[counter] = this.ssWithinBDG[counter].doubleValue();
                        this.ssBetweenG[counter] = this.ssBetweenBDG[counter].doubleValue();
                        this.meanSquareTotalBDG[counter] = av.totalMeanSquare_as_BD();
                        this.meanSquareWithinBDG[counter] = av.withinGroupsMeanSquare_as_BD();
                        this.meanSquareBetweenBDG[counter] = av.betweenGroupsMeanSquare_as_BD();
                        this.meanSquareTotalG[counter] = this.meanSquareTotalBDG[counter].doubleValue();
                        this.meanSquareWithinG[counter] = this.meanSquareWithinBDG[counter].doubleValue();
                        this.meanSquareBetweenG[counter] = this.meanSquareBetweenBDG[counter].doubleValue();
                        this.fRatioBDG[counter] = av.oneWayFratio_as_BD();
                        this.fRatioG[counter] = this.fRatioBDG[counter].doubleValue();
                        this.fRatioPG[counter] = av.oneWaySignificance();
                        this.criticalFratioG[counter] = av.criticalFratio();
                        this.dofTotalG[counter] = av.totalDoF();
                        this.dofBetweenG[counter] = av.betweenGroupsDoF();
                        this.dofWithinG[counter] = av.withinGroupsDoF();
                        ++counter;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        this.oneWayDone = true;
    }

    public double oneWayFratio() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.fRatio;
    }

    public double oneWayFratio(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.fRatioG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.fRatioG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.fRatioG[0];
        }
        return ret;
    }

    public BigDecimal oneWayFratio_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.fRatioBD;
    }

    public BigDecimal oneWayFratio_as_BD(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        BigDecimal ret = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.fRatioBDG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.fRatioBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.fRatioBDG[0];
        }
        return ret;
    }

    public double oneWaySignificance() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.fRatioP;
    }

    public double oneWaySignificance(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.fRatioPG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.fRatioPG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.fRatioPG[0];
        }
        return ret;
    }

    public double criticalFratio() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.criticalFratio;
    }

    public double criticalFratio(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.criticalFratioG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.criticalFratioG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.criticalFratioG[0];
        }
        return ret;
    }

    public double totalMeanSquare() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.meanSquareTotal;
    }

    public double totalMeanSquare(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.meanSquareTotalG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.meanSquareTotalG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.meanSquareTotalG[0];
        }
        return ret;
    }

    public BigDecimal totalMeanSquare_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.meanSquareTotalBD;
    }

    public BigDecimal totalMeanSquare_as_BD(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        BigDecimal ret = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.meanSquareTotalBDG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.meanSquareTotalBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.meanSquareTotalBDG[0];
        }
        return ret;
    }

    public double betweenGroupsMeanSquare() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.meanSquareBetween;
    }

    public double betweenGroupsMeanSquare(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.meanSquareBetweenG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.meanSquareBetweenG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.meanSquareBetweenG[0];
        }
        return ret;
    }

    public BigDecimal betweenGroupsMeanSquare_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.meanSquareBetweenBD;
    }

    public BigDecimal betweenGroupsMeanSquare_as_BD(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        BigDecimal ret = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.meanSquareBetweenBDG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.meanSquareBetweenBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.meanSquareBetweenBDG[0];
        }
        return ret;
    }

    public double withinGroupsMeanSquare() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.meanSquareWithin;
    }

    public double withinGroupsMeanSquare(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.meanSquareWithinG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.meanSquareWithinG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.meanSquareWithinG[0];
        }
        return ret;
    }

    public BigDecimal withinGroupsMeanSquare_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.meanSquareWithinBD;
    }

    public BigDecimal withinGroupsMeanSquare_as_BD(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        BigDecimal ret = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.meanSquareWithinBDG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.meanSquareWithinBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.meanSquareWithinBDG[0];
        }
        return ret;
    }

    public double betweenGroupsSumOfSquares() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.ssBetween;
    }

    public double betweenGroupsSumOfSquares(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.ssBetweenG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.ssBetweenG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.ssBetweenG[0];
        }
        return ret;
    }

    public BigDecimal betweenGroupsSumOfSquares_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.ssBetweenBD;
    }

    public BigDecimal betweenGroupsSumOfSquares_as_BD(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        BigDecimal ret = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.ssBetweenBDG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.ssBetweenBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.ssBetweenBDG[0];
        }
        return ret;
    }

    public double withinGroupsSumOfSquares() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.ssWithin;
    }

    public double withinGroupsSumOfSquares(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.ssWithinG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.ssWithinG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.ssWithinG[0];
        }
        return ret;
    }

    public BigDecimal withinGroupsSumOfSquares_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.ssWithinBD;
    }

    public BigDecimal withinGroupsSumOfSquares_as_BD(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        BigDecimal ret = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.ssWithinBDG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.ssWithinBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.ssWithinBDG[0];
        }
        return ret;
    }

    public double totalSumOfSquares(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        double ret = 0.0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.ssTotalG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.ssTotalG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.ssTotalG[0];
        }
        return ret;
    }

    public BigDecimal totalSumOfSquares_as_BD(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        BigDecimal ret = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.ssTotalBDG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.ssTotalBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.ssTotalBDG[0];
        }
        return ret;
    }

    public int totalDoF() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.dofTotal;
    }

    public int totalDoF(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        int ret = 0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.dofTotalG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.dofTotalG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.dofTotalG[0];
        }
        return ret;
    }

    public int withinGroupsDoF() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.dofWithinGroups;
    }

    public int withinGroupsDoF(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        int ret = 0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.dofWithinG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.dofWithinG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.dofWithinG[0];
        }
        return ret;
    }

    public int betweenGroupsDoF() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.dofBetweenGroups;
    }

    public int betweenGroupsDoF(int ii, int jj) {
        int iii = ii - 1;
        int jjj = jj - 1;
        int index2 = 0;
        int ret = 0;
        if (this.comparison) {
            if (this.compGroups[iii] && this.compGroups[jjj]) {
                index2 = this.pairIndex(iii, jjj);
                ret = this.dofBetweenG[index2];
            } else {
                ANOVA av = new ANOVA();
                av.enterResponseData(this.responses0);
                av.oneWayANOVAwithPairComparison(ii, jj);
                ret = av.dofBetweenG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(ii, jj);
            ret = this.dofBetweenG[0];
        }
        return ret;
    }

    private int pairIndex(int ii, int jj) {
        int ret = -1;
        int i = 0;
        boolean test2 = true;
        while (test2) {
            if (this.pairIndices[i][0] == ii && this.pairIndices[i][1] == jj) {
                ret = i;
                test2 = false;
                continue;
            }
            if (this.pairIndices[i][0] == jj && this.pairIndices[i][1] == ii) {
                ret = i;
                test2 = false;
                continue;
            }
            if (++i < this.nComparisons) continue;
            throw new IllegalArgumentException("No index found " + ii + " and " + jj);
        }
        return ret;
    }

    public void outputAnalysis() {
        if (!this.oneWayDone) {
            System.out.println("Method outputAnalysis: As no ANOVA peforming method had been called a ANOVA of all groups, withour pair comparison, has now been performed");
            this.oneWayANOVA();
        }
        this.outputFilename = "OneWayANOVAoutput";
        switch (this.fileOption) {
            case 1: {
                this.outputFilename = String.valueOf(this.outputFilename) + ".txt";
                break;
            }
            case 2: {
                this.outputFilename = String.valueOf(this.outputFilename) + ".xls";
            }
        }
        String message1 = "Output file name for the one way ANOVA:";
        String message2 = "\nEnter the required name (as a single word) and click OK ";
        String message3 = "\nor simply click OK for default value";
        String message = String.valueOf(message1) + message2 + message3;
        String defaultName = this.outputFilename;
        this.outputFilename = Db.readLine(message, defaultName);
        this.outputAnalysis(this.outputFilename);
    }

    public void outputAnalysis(String filename) {
        if (!this.oneWayDone) {
            System.out.println("Method outputAnalysis: As no ANOVA peforming method had been called a ANOVA of all groups, withour pair comparison, has now been performed");
            this.oneWayANOVA();
        }
        this.outputFilename = filename;
        String outputFilenameWithoutExtension = null;
        String extension = null;
        int pos = filename.indexOf(46);
        if (pos == -1) {
            outputFilenameWithoutExtension = filename;
            switch (this.fileOption) {
                case 1: {
                    this.outputFilename = String.valueOf(this.outputFilename) + ".txt";
                    break;
                }
                case 2: {
                    this.outputFilename = String.valueOf(this.outputFilename) + ".xls";
                }
            }
        } else {
            int opt2;
            int defaultBox;
            String[] boxTitles;
            String[] comments;
            String message;
            String headerComment;
            String message2;
            String message1;
            extension = filename.substring(pos).trim();
            outputFilenameWithoutExtension = filename.substring(0, pos).trim();
            if (extension.equalsIgnoreCase(".xlsx")) {
                extension = ".xls";
                this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + extension;
            }
            if (extension.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is " + extension;
                    message2 = "\nbut you have chosen a .txt output";
                    headerComment = "Your output file name extension";
                    message = String.valueOf(message1) + message2;
                    comments = new String[]{message, "replace it with .txt [text file]"};
                    opt2 = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".txt"}, defaultBox = 1);
                    if (opt2 == 2) {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (extension.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is .txt";
                    message2 = "\nbut you have chosen a .xls output";
                    headerComment = "Your output file name extension";
                    message = String.valueOf(message1) + message2;
                    comments = new String[]{message, "replace it with .xls [Excel file]"};
                    opt2 = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".xls"}, defaultBox = 1);
                    if (opt2 == 2) {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!extension.equalsIgnoreCase(".txt") && !extension.equalsIgnoreCase(".xls")) {
                message1 = "Your extension is " + extension;
                message2 = "\n    Do you wish to retain it:";
                message = String.valueOf(message1) + message2;
                headerComment = "Your output file name extension";
                comments = new String[]{message, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                boxTitles = new String[]{"Retain", ".txt", ".xls"};
                defaultBox = 1;
                opt2 = Db.optionBox(headerComment, comments, boxTitles, defaultBox);
                switch (opt2) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        if (!this.truncAll) {
            this.setOutputPrecision();
        }
        if (this.fileOption == 1) {
            this.outputText();
        } else {
            this.outputExcel();
        }
        System.out.println("The ANOVA summary has been written to the file " + this.outputFilename);
    }

    private void setOutputPrecision() {
        int maxPrec;
        int prech = maxPrec = Fmath.checkPrecision(this.responses0[0][0]);
        int i = 0;
        while (i < this.nGroups) {
            int j = 0;
            while (j < this.nResponsesPerGroup[i]) {
                prech = Fmath.checkPrecision(this.responses0[i][j]);
                if (prech > maxPrec) {
                    maxPrec = prech;
                }
                ++j;
            }
            ++i;
        }
        if (!this.truncAll && maxPrec > this.trunc) {
            this.trunc = maxPrec;
        }
    }

    private void outputText() {
        FileOutput fout = new FileOutput(this.outputFilename);
        fout.println("PROGRAM ANOVA");
        int i = 0;
        while (i < this.nTitle) {
            fout.println(this.title[i]);
            ++i;
        }
        if (this.inputFilename != null) {
            fout.println("Input file name: " + this.inputFilename);
        }
        fout.println("This output file name: " + this.outputFilename);
        fout.println();
        fout.println("ALL GROUPS: One-Way Analysis of Variance");
        fout.print(" ", 16);
        fout.print(" ", this.fieldD);
        fout.print("  ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print("F-ratio at", this.fieldD);
        fout.println(" ");
        fout.print(" ", 16);
        fout.print("Sum of", this.fieldD);
        fout.print("Degrees of ", this.fieldD);
        fout.print("Mean ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(String.valueOf(this.criticalSignificanceF) + " critical", this.fieldD);
        fout.println(" ");
        fout.print(" ", 16);
        fout.print("squares", this.fieldD);
        fout.print("freedom ", this.fieldD);
        fout.print("square ", this.fieldD);
        fout.print("F-ratio ", this.fieldD);
        fout.print("level", this.fieldD);
        fout.println("Significance");
        fout.print("Between groups", 16);
        fout.print(Fmath.truncate(this.ssBetween, this.trunc), this.fieldD);
        fout.print(this.dofBetweenGroups, this.fieldD);
        fout.print(Fmath.truncate(this.meanSquareBetween, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.fRatio, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.criticalFratio, this.trunc), this.fieldD);
        fout.println(Fmath.truncate(this.fRatioP, this.trunc));
        fout.print("Within groups", 16);
        fout.print(Fmath.truncate(this.ssWithin, this.trunc), this.fieldD);
        fout.print(this.dofWithinGroups, this.fieldD);
        fout.println(Fmath.truncate(this.meanSquareWithin, this.trunc));
        fout.print("Total", 16);
        fout.print(Fmath.truncate(this.ssTotal, this.trunc), this.fieldD);
        fout.print(this.dofTotal, this.fieldD);
        fout.println(Fmath.truncate(this.meanSquareTotal, this.trunc));
        fout.println();
        fout.println();
        fout.println("ALL GROUPS: Individual Group Statistics");
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.println(String.valueOf(this.criticalSignificanceS) + " confidence interval");
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.println("of the mean");
        fout.print(" ", this.fieldD);
        fout.print("Number of", this.fieldD);
        fout.print(" ", this.fieldD);
        fout.print("Standard", this.fieldD);
        fout.print("Standard", this.fieldD);
        fout.print("lower", this.fieldD);
        fout.println("upper");
        fout.print(" ", this.fieldD);
        fout.print("responses", this.fieldD);
        fout.print("Mean", this.fieldD);
        fout.print("deviation", this.fieldD);
        fout.print("error", this.fieldD);
        fout.print("bound ", this.fieldD);
        fout.println("bound ");
        i = 0;
        while (i < this.nGroups) {
            fout.print(this.groupNames[i], this.fieldD);
            fout.print(this.nResponsesPerGroup[i], this.fieldD);
            fout.print(Fmath.truncate(this.groupMeans[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupSD[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupSE[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupClb[i], this.trunc), this.fieldD);
            fout.println(Fmath.truncate(this.groupCub[i], this.trunc));
            ++i;
        }
        fout.println(" ");
        fout.print("Total", this.fieldD);
        fout.print(this.nTotalResponses, this.fieldD);
        fout.print(Fmath.truncate(this.totalMean, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalSD, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalSE, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalClb, this.trunc), this.fieldD);
        fout.println(Fmath.truncate(this.totalCub, this.trunc));
        fout.println();
        fout.print("       ", this.fieldD);
        fout.print("minimum", this.fieldD);
        fout.print("median ", this.fieldD);
        fout.print("maximum ", this.fieldD);
        fout.print("moment ", this.fieldD);
        fout.print("median ", this.fieldD);
        fout.print("quartile ", this.fieldD);
        fout.print("kurtosis ", this.fieldD);
        fout.println("excess ");
        fout.print("       ", this.fieldD);
        fout.print("       ", this.fieldD);
        fout.print("       ", this.fieldD);
        fout.print("       ", this.fieldD);
        fout.print("skewness", this.fieldD);
        fout.print("skewness", this.fieldD);
        fout.print("skewness", this.fieldD);
        fout.print("        ", this.fieldD);
        fout.println("kurtosis");
        i = 0;
        while (i < this.nGroups) {
            fout.print(this.groupNames[i], this.fieldD);
            fout.print(Fmath.truncate(this.groupMinimum[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupMedians[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupMaximum[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupMomentSkewness[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupMedianSkewness[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupQuartileSkewness[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupKurtosis[i], this.trunc), this.fieldD);
            fout.println(Fmath.truncate(this.groupExcessKurtosis[i], this.trunc));
            ++i;
        }
        fout.println(" ");
        fout.print("Total", this.fieldD);
        fout.print(Fmath.truncate(this.totalMinimum, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalMedian, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalMaximum, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalMomentSkewness, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalMedianSkewness, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalQuartileSkewness, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalKurtosis, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalExcessKurtosis, this.trunc), this.fieldD);
        fout.println(Fmath.truncate(this.totalProbPlotR, this.trunc));
        fout.println();
        fout.println("Gaussian Probability Plot");
        fout.print("       ", this.fieldD);
        fout.print("Correlation", this.fieldD);
        fout.print("Gradient", this.fieldD);
        fout.print("Intercept", this.fieldD);
        fout.print("mu", this.fieldD);
        fout.println("sigma");
        fout.print("       ", this.fieldD);
        fout.print("coefficient", this.fieldD);
        fout.print("       ", this.fieldD);
        fout.print("       ", this.fieldD);
        fout.print("       ", this.fieldD);
        fout.println("     ");
        i = 0;
        while (i < this.nGroups) {
            fout.print(this.groupNames[i], this.fieldD);
            fout.print(Fmath.truncate(this.groupProbPlotR[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupProbPlotGradient[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupProbPlotIntercept[i], this.trunc), this.fieldD);
            fout.print(Fmath.truncate(this.groupProbPlotMu[i], this.trunc), this.fieldD);
            fout.println(Fmath.truncate(this.groupProbPlotSigma[i], this.trunc));
            ++i;
        }
        fout.println(" ");
        fout.print("total", this.fieldD);
        fout.print(Fmath.truncate(this.totalProbPlotR, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalProbPlotGradient, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalProbPlotIntercept, this.trunc), this.fieldD);
        fout.print(Fmath.truncate(this.totalProbPlotMu, this.trunc), this.fieldD);
        fout.println(Fmath.truncate(this.totalProbPlotSigma, this.trunc));
        if (this.nGroups > 2 && this.comparison) {
            fout.println(" ");
            fout.println(" ");
            fout.println("COMPARISON OF PAIRS OF GROUPS: One-Way Analysis of Variance");
            int counter = 0;
            int i2 = 0;
            while (i2 < this.nGroups - 1) {
                int j = i2 + 1;
                while (j < this.nGroups) {
                    if (this.compGroups[i2] && this.compGroups[j]) {
                        fout.println("Group" + (i2 + 1) + " and Group" + (j + 1));
                        fout.print(" ", 16);
                        fout.print(" ", this.fieldD);
                        fout.print("  ", this.fieldD);
                        fout.print(" ", this.fieldD);
                        fout.print(" ", this.fieldD);
                        fout.print("F-ratio at", this.fieldD);
                        fout.println(" ");
                        fout.print(" ", 16);
                        fout.print("Sum of", this.fieldD);
                        fout.print("Degrees of ", this.fieldD);
                        fout.print("Mean ", this.fieldD);
                        fout.print(" ", this.fieldD);
                        fout.print(String.valueOf(this.criticalSignificanceF) + " critical", this.fieldD);
                        fout.println(" ");
                        fout.print(" ", 16);
                        fout.print("squares", this.fieldD);
                        fout.print("freedom ", this.fieldD);
                        fout.print("square ", this.fieldD);
                        fout.print("F-ratio ", this.fieldD);
                        fout.print("level", this.fieldD);
                        fout.println("Significance");
                        fout.print("Between groups", 16);
                        fout.print(Fmath.truncate(this.ssBetweenG[counter], this.trunc), this.fieldD);
                        fout.print(this.dofBetweenG[counter], this.fieldD);
                        fout.print(Fmath.truncate(this.meanSquareBetweenG[counter], this.trunc), this.fieldD);
                        fout.print(Fmath.truncate(this.fRatioG[counter], this.trunc), this.fieldD);
                        fout.print(Fmath.truncate(this.criticalFratioG[counter], this.trunc), this.fieldD);
                        fout.println(Fmath.truncate(this.fRatioPG[counter], this.trunc));
                        fout.print("Within groups", 16);
                        fout.print(Fmath.truncate(this.ssWithinG[counter], this.trunc), this.fieldD);
                        fout.print(this.dofWithinG[counter], this.fieldD);
                        fout.println(Fmath.truncate(this.meanSquareWithinG[counter], this.trunc));
                        fout.print("Total", 16);
                        fout.print(Fmath.truncate(this.ssTotalG[counter], this.trunc), this.fieldD);
                        fout.print(this.dofTotalG[counter], this.fieldD);
                        fout.println(Fmath.truncate(this.meanSquareTotalG[counter], this.trunc));
                        ++counter;
                        fout.println();
                        fout.println();
                    }
                    ++j;
                }
                ++i2;
            }
        }
        fout.close();
    }

    private void outputExcel() {
        FileOutput fout = new FileOutput(this.outputFilename);
        fout.println("PROGRAM ANOVA");
        int i = 0;
        while (i < this.nTitle) {
            fout.println(this.title[i]);
            ++i;
        }
        if (this.inputFilename != null) {
            fout.println("Input file name: " + this.inputFilename);
        }
        fout.println("This output file name: " + this.outputFilename);
        fout.println();
        fout.println("ALL GROUPS: One-Way Analysis of Variance");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab("  ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab("F-ratio at");
        fout.println(" ");
        fout.printtab(" ");
        fout.printtab("Sum of");
        fout.printtab("Degrees of ");
        fout.printtab("Mean ");
        fout.printtab(" ");
        fout.printtab(String.valueOf(this.criticalSignificanceF) + " critical");
        fout.println(" ");
        fout.printtab(" ");
        fout.printtab("squares");
        fout.printtab("freedom ");
        fout.printtab("square ");
        fout.printtab("F-ratio ");
        fout.printtab("level");
        fout.println("Significance");
        fout.printtab("Between groups");
        fout.printtab(Fmath.truncate(this.ssBetween, this.trunc));
        fout.printtab(this.dofBetweenGroups);
        fout.printtab(Fmath.truncate(this.meanSquareBetween, this.trunc));
        fout.printtab(Fmath.truncate(this.fRatio, this.trunc));
        fout.printtab(Fmath.truncate(this.criticalFratio, this.trunc));
        fout.println(Fmath.truncate(this.fRatioP, this.trunc));
        fout.printtab("Within groups");
        fout.printtab(Fmath.truncate(this.ssWithin, this.trunc));
        fout.printtab(this.dofWithinGroups);
        fout.println(Fmath.truncate(this.meanSquareWithin, this.trunc));
        fout.printtab("Total");
        fout.printtab(Fmath.truncate(this.ssTotal, this.trunc));
        fout.printtab(this.dofTotal);
        fout.println(Fmath.truncate(this.meanSquareTotal, this.trunc));
        fout.println();
        fout.println();
        fout.println("ALL GROUPS: Individual Group Statistics");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.println(String.valueOf(this.criticalSignificanceS) + " confidence interval");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.println("of the mean");
        fout.printtab(" ");
        fout.printtab("Number of");
        fout.printtab(" ");
        fout.printtab("Standard");
        fout.printtab("Standard");
        fout.printtab("lower");
        fout.println("upper");
        fout.printtab(" ");
        fout.printtab("responses");
        fout.printtab("Mean");
        fout.printtab("deviation");
        fout.printtab("error");
        fout.printtab("bound ");
        fout.println("bound ");
        i = 0;
        while (i < this.nGroups) {
            fout.printtab(this.groupNames[i]);
            fout.printtab(this.nResponsesPerGroup[i]);
            fout.printtab(Fmath.truncate(this.groupMeans[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupSD[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupSE[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupClb[i], this.trunc));
            fout.println(Fmath.truncate(this.groupCub[i], this.trunc));
            ++i;
        }
        fout.println(" ");
        fout.printtab("Total");
        fout.printtab(this.nTotalResponses);
        fout.printtab(Fmath.truncate(this.totalMean, this.trunc));
        fout.printtab(Fmath.truncate(this.totalSD, this.trunc));
        fout.printtab(Fmath.truncate(this.totalSE, this.trunc));
        fout.printtab(Fmath.truncate(this.totalClb, this.trunc));
        fout.println(Fmath.truncate(this.totalCub, this.trunc));
        fout.println();
        fout.printtab("       ");
        fout.printtab("minimum");
        fout.printtab("median ");
        fout.printtab("maximum ");
        fout.printtab("moment ");
        fout.printtab("median ");
        fout.printtab("quartile ");
        fout.printtab("kurtosis ");
        fout.println("excess ");
        fout.printtab("       ");
        fout.printtab("       ");
        fout.printtab("       ");
        fout.printtab("       ");
        fout.printtab("skewness");
        fout.printtab("skewness");
        fout.printtab("skewness");
        fout.printtab("        ");
        fout.println("kurtosis");
        i = 0;
        while (i < this.nGroups) {
            fout.printtab(this.groupNames[i]);
            fout.printtab(Fmath.truncate(this.groupMinimum[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupMedians[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupMaximum[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupMomentSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupMedianSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupQuartileSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupKurtosis[i], this.trunc));
            fout.println(Fmath.truncate(this.groupExcessKurtosis[i], this.trunc));
            ++i;
        }
        fout.println(" ");
        fout.printtab("Total");
        fout.printtab(Fmath.truncate(this.totalMinimum, this.trunc));
        fout.printtab(Fmath.truncate(this.totalMedian, this.trunc));
        fout.printtab(Fmath.truncate(this.totalMaximum, this.trunc));
        fout.printtab(Fmath.truncate(this.totalMomentSkewness, this.trunc));
        fout.printtab(Fmath.truncate(this.totalMedianSkewness, this.trunc));
        fout.printtab(Fmath.truncate(this.totalQuartileSkewness, this.trunc));
        fout.printtab(Fmath.truncate(this.totalKurtosis, this.trunc));
        fout.printtab(Fmath.truncate(this.totalExcessKurtosis, this.trunc));
        fout.println(Fmath.truncate(this.totalProbPlotR, this.trunc));
        fout.println();
        fout.println("Gaussian Probability Plot");
        fout.printtab("       ");
        fout.printtab("Correlation");
        fout.printtab("Gradient");
        fout.printtab("Intercept");
        fout.printtab("mu");
        fout.println("sigma");
        fout.printtab("       ");
        fout.printtab("coefficient");
        fout.printtab("       ");
        fout.printtab("       ");
        fout.printtab("       ");
        fout.println("     ");
        i = 0;
        while (i < this.nGroups) {
            fout.printtab(this.groupNames[i]);
            fout.printtab(Fmath.truncate(this.groupProbPlotR[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupProbPlotGradient[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupProbPlotIntercept[i], this.trunc));
            fout.printtab(Fmath.truncate(this.groupProbPlotMu[i], this.trunc));
            fout.println(Fmath.truncate(this.groupProbPlotSigma[i], this.trunc));
            ++i;
        }
        fout.println(" ");
        fout.printtab("total");
        fout.printtab(Fmath.truncate(this.totalProbPlotR, this.trunc));
        fout.printtab(Fmath.truncate(this.totalProbPlotGradient, this.trunc));
        fout.printtab(Fmath.truncate(this.totalProbPlotIntercept, this.trunc));
        fout.printtab(Fmath.truncate(this.totalProbPlotMu, this.trunc));
        fout.println(Fmath.truncate(this.totalProbPlotSigma, this.trunc));
        if (this.nGroups > 2 && this.comparison) {
            fout.println(" ");
            fout.println(" ");
            fout.println("COMPARISON OF PAIRS OF GROUPS: One-Way Analysis of Variance");
            int counter = 0;
            int i2 = 0;
            while (i2 < this.nGroups - 1) {
                int j = i2 + 1;
                while (j < this.nGroups) {
                    if (this.compGroups[i2] && this.compGroups[j]) {
                        fout.println("Group" + (i2 + 1) + " and Group" + (j + 1));
                        fout.printtab(" ");
                        fout.printtab(" ");
                        fout.printtab("  ");
                        fout.printtab(" ");
                        fout.printtab(" ");
                        fout.printtab("F-ratio at");
                        fout.println(" ");
                        fout.printtab(" ");
                        fout.printtab("Sum of");
                        fout.printtab("Degrees of ");
                        fout.printtab("Mean ");
                        fout.printtab(" ");
                        fout.printtab(String.valueOf(this.criticalSignificanceF) + " critical");
                        fout.println(" ");
                        fout.printtab(" ");
                        fout.printtab("squares");
                        fout.printtab("freedom ");
                        fout.printtab("square ");
                        fout.printtab("F-ratio ");
                        fout.printtab("level");
                        fout.println("Significance");
                        fout.printtab("Between groups");
                        fout.printtab(Fmath.truncate(this.ssBetweenG[counter], this.trunc));
                        fout.printtab(this.dofBetweenG[counter]);
                        fout.printtab(Fmath.truncate(this.meanSquareBetweenG[counter], this.trunc));
                        fout.printtab(Fmath.truncate(this.fRatioG[counter], this.trunc));
                        fout.printtab(Fmath.truncate(this.criticalFratioG[counter], this.trunc));
                        fout.println(Fmath.truncate(this.fRatioPG[counter], this.trunc));
                        fout.printtab("Within groups");
                        fout.printtab(Fmath.truncate(this.ssWithinG[counter], this.trunc));
                        fout.printtab(this.dofWithinG[counter]);
                        fout.println(Fmath.truncate(this.meanSquareWithinG[counter], this.trunc));
                        fout.printtab("Total");
                        fout.printtab(Fmath.truncate(this.ssTotalG[counter], this.trunc));
                        fout.printtab(this.dofTotalG[counter], this.fieldD);
                        fout.println(Fmath.truncate(this.meanSquareTotalG[counter], this.trunc));
                        ++counter;
                        fout.println();
                        fout.println();
                    }
                    ++j;
                }
                ++i2;
            }
        }
        fout.close();
    }

    public void numberOfDecimalPlaces(int trunc) {
        this.trunc = trunc;
    }

    public void numberOfDecimalPlacesAll(int trunc) {
        this.trunc = trunc;
        this.truncAll = true;
    }
}

