/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigParseable;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Parser;
import com.typesafe.config.impl.PropertiesParser;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public abstract class Parseable
implements ConfigParseable {
    private ConfigIncludeContext includeContext;
    private ConfigParseOptions initialOptions;
    private ConfigOrigin initialOrigin;

    protected Parseable() {
    }

    private ConfigParseOptions fixupOptions(ConfigParseOptions configParseOptions) {
        ConfigSyntax configSyntax = configParseOptions.getSyntax();
        if (configSyntax == null) {
            configSyntax = this.guessSyntax();
        }
        if (configSyntax == null) {
            configSyntax = ConfigSyntax.CONF;
        }
        ConfigParseOptions configParseOptions2 = configParseOptions.setSyntax(configSyntax);
        configParseOptions2 = configParseOptions2.appendIncluder(ConfigImpl.defaultIncluder());
        return configParseOptions2;
    }

    protected void postConstruct(ConfigParseOptions configParseOptions) {
        this.initialOptions = this.fixupOptions(configParseOptions);
        this.includeContext = new ConfigIncludeContext(){

            @Override
            public ConfigParseable relativeTo(String string2) {
                return Parseable.this.relativeTo(string2);
            }
        };
        this.initialOrigin = this.initialOptions.getOriginDescription() != null ? SimpleConfigOrigin.newSimple(this.initialOptions.getOriginDescription()) : this.createOrigin();
    }

    protected abstract Reader reader() throws IOException;

    ConfigSyntax guessSyntax() {
        return null;
    }

    ConfigParseable relativeTo(String string2) {
        return null;
    }

    ConfigIncludeContext includeContext() {
        return this.includeContext;
    }

    static AbstractConfigObject forceParsedToObject(ConfigValue configValue) {
        if (configValue instanceof AbstractConfigObject) {
            return (AbstractConfigObject)configValue;
        }
        throw new ConfigException.WrongType(configValue.origin(), "", "object at file root", configValue.valueType().name());
    }

    @Override
    public ConfigObject parse(ConfigParseOptions configParseOptions) {
        return Parseable.forceParsedToObject(this.parseValue(configParseOptions));
    }

    final AbstractConfigValue parseValue(ConfigParseOptions configParseOptions) {
        ConfigParseOptions configParseOptions2 = this.fixupOptions(configParseOptions);
        ConfigOrigin configOrigin = configParseOptions2.getOriginDescription() != null ? SimpleConfigOrigin.newSimple(configParseOptions2.getOriginDescription()) : this.initialOrigin;
        return this.parseValue(configOrigin, configParseOptions2);
    }

    private final AbstractConfigValue parseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) {
        try {
            return this.rawParseValue(configOrigin, configParseOptions);
        }
        catch (IOException iOException) {
            if (configParseOptions.getAllowMissing()) {
                return SimpleConfigObject.emptyMissing(configOrigin);
            }
            throw new ConfigException.IO(configOrigin, iOException.getMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractConfigValue rawParseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) throws IOException {
        Reader reader = this.reader();
        try {
            AbstractConfigValue abstractConfigValue = this.rawParseValue(reader, configOrigin, configParseOptions);
            return abstractConfigValue;
        }
        finally {
            reader.close();
        }
    }

    protected AbstractConfigValue rawParseValue(Reader reader, ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) throws IOException {
        if (configParseOptions.getSyntax() == ConfigSyntax.PROPERTIES) {
            return PropertiesParser.parse(reader, configOrigin);
        }
        Iterator<Token> iterator2 = Tokenizer.tokenize(configOrigin, reader, configParseOptions.getSyntax());
        return Parser.parse(iterator2, configOrigin, configParseOptions, this.includeContext());
    }

    public ConfigObject parse() {
        return Parseable.forceParsedToObject(this.parseValue(this.options()));
    }

    AbstractConfigValue parseValue() {
        return this.parseValue(this.options());
    }

    @Override
    public final ConfigOrigin origin() {
        return this.initialOrigin;
    }

    protected abstract ConfigOrigin createOrigin();

    @Override
    public ConfigParseOptions options() {
        return this.initialOptions;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static ConfigSyntax syntaxFromExtension(String string2) {
        if (string2.endsWith(".json")) {
            return ConfigSyntax.JSON;
        }
        if (string2.endsWith(".conf")) {
            return ConfigSyntax.CONF;
        }
        if (string2.endsWith(".properties")) {
            return ConfigSyntax.PROPERTIES;
        }
        return null;
    }

    private static Reader readerFromStream(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            return new BufferedReader(inputStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ConfigException.BugOrBroken("Java runtime does not support UTF-8", unsupportedEncodingException);
        }
    }

    private static Reader doNotClose(Reader reader) {
        return new FilterReader(reader){

            @Override
            public void close() {
            }
        };
    }

    static URL relativeTo(URL uRL, String string2) {
        if (new File(string2).isAbsolute()) {
            return null;
        }
        try {
            URI uRI = uRL.toURI();
            URI uRI2 = new URI(string2);
            URL uRL2 = uRI.resolve(uRI2).toURL();
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static File relativeTo(File file, String string2) {
        File file2 = new File(string2);
        if (file2.isAbsolute()) {
            return null;
        }
        File file3 = file.getParentFile();
        if (file3 == null) {
            return null;
        }
        return new File(file3, string2);
    }

    public static Parseable newNotFound(String string2, String string3, ConfigParseOptions configParseOptions) {
        return new ParseableNotFound(string2, string3, configParseOptions);
    }

    public static Parseable newReader(Reader reader, ConfigParseOptions configParseOptions) {
        return new ParseableReader(Parseable.doNotClose(reader), configParseOptions);
    }

    public static Parseable newString(String string2, ConfigParseOptions configParseOptions) {
        return new ParseableString(string2, configParseOptions);
    }

    public static Parseable newURL(URL uRL, ConfigParseOptions configParseOptions) {
        if (uRL.getProtocol().equals("file")) {
            return Parseable.newFile(ConfigImplUtil.urlToFile(uRL), configParseOptions);
        }
        return new ParseableURL(uRL, configParseOptions);
    }

    public static Parseable newFile(File file, ConfigParseOptions configParseOptions) {
        return new ParseableFile(file, configParseOptions);
    }

    public static Parseable newResources(Class<?> clazz, String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(clazz.getClassLoader(), Parseable.convertResourceName(clazz, string2), configParseOptions);
    }

    private static String convertResourceName(Class<?> clazz, String string2) {
        if (string2.startsWith("/")) {
            return string2.substring(1);
        }
        String string3 = clazz.getName();
        int n = string3.lastIndexOf(46);
        if (n < 0) {
            return string2;
        }
        String string4 = string3.substring(0, n);
        String string5 = string4.replace('.', '/');
        return string5 + "/" + string2;
    }

    public static Parseable newResources(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions) {
        return new ParseableResources(classLoader, string2, configParseOptions);
    }

    public static Parseable newProperties(Properties properties, ConfigParseOptions configParseOptions) {
        return new ParseableProperties(properties, configParseOptions);
    }

    private static final class ParseableProperties
    extends Parseable {
        private final Properties props;

        ParseableProperties(Properties properties, ConfigParseOptions configParseOptions) {
            this.props = properties;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            throw new ConfigException.BugOrBroken("reader() should not be called on props");
        }

        @Override
        protected AbstractConfigObject rawParseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) {
            return PropertiesParser.fromProperties(configOrigin, this.props);
        }

        @Override
        ConfigSyntax guessSyntax() {
            return ConfigSyntax.PROPERTIES;
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newSimple("properties");
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.props.size() + " props)";
        }
    }

    private static final class ParseableResources
    extends Parseable {
        private final ClassLoader loader;
        private final String resource;

        ParseableResources(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions) {
            this.loader = classLoader;
            this.resource = string2;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            throw new ConfigException.BugOrBroken("reader() should not be called on resources");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractConfigObject rawParseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) throws IOException {
            Enumeration<URL> enumeration = this.loader.getResources(this.resource);
            if (!enumeration.hasMoreElements()) {
                throw new IOException("resource not found on classpath: " + this.resource);
            }
            AbstractConfigObject abstractConfigObject = SimpleConfigObject.empty(configOrigin);
            while (enumeration.hasMoreElements()) {
                AbstractConfigValue abstractConfigValue;
                URL uRL = enumeration.nextElement();
                SimpleConfigOrigin simpleConfigOrigin = ((SimpleConfigOrigin)configOrigin).addURL(uRL);
                InputStream inputStream = uRL.openStream();
                try {
                    Reader reader = Parseable.readerFromStream(inputStream);
                    inputStream = null;
                    try {
                        abstractConfigValue = this.rawParseValue(reader, simpleConfigOrigin, configParseOptions);
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                abstractConfigObject = abstractConfigObject.withFallback(abstractConfigValue);
            }
            return abstractConfigObject;
        }

        @Override
        ConfigSyntax guessSyntax() {
            return Parseable.syntaxFromExtension(this.resource);
        }

        static String parent(String string2) {
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                return null;
            }
            return string2.substring(0, n);
        }

        @Override
        ConfigParseable relativeTo(String string2) {
            if (string2.startsWith("/")) {
                return ParseableResources.newResources(this.loader, string2.substring(1), this.options().setOriginDescription(null));
            }
            String string3 = ParseableResources.parent(this.resource);
            if (string3 == null) {
                return ParseableResources.newResources(this.loader, string2, this.options().setOriginDescription(null));
            }
            return ParseableResources.newResources(this.loader, string3 + "/" + string2, this.options().setOriginDescription(null));
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newResource(this.resource);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.resource + "," + this.loader.getClass().getSimpleName() + ")";
        }
    }

    private static final class ParseableFile
    extends Parseable {
        private final File input;

        ParseableFile(File file, ConfigParseOptions configParseOptions) {
            this.input = file;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            FileInputStream fileInputStream = new FileInputStream(this.input);
            return Parseable.readerFromStream(fileInputStream);
        }

        @Override
        ConfigSyntax guessSyntax() {
            return Parseable.syntaxFromExtension(this.input.getName());
        }

        @Override
        ConfigParseable relativeTo(String string2) {
            File file = new File(string2).isAbsolute() ? new File(string2) : ParseableFile.relativeTo(this.input, string2);
            if (file == null) {
                return null;
            }
            if (file.exists()) {
                return ParseableFile.newFile(file, this.options().setOriginDescription(null));
            }
            String string3 = string2;
            if (string2.startsWith("/")) {
                string3 = string2.substring(1);
            }
            return ParseableFile.newResources(this.getClass().getClassLoader(), string3, this.options().setOriginDescription(null));
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newFile(this.input.getPath());
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.input.getPath() + ")";
        }
    }

    private static final class ParseableURL
    extends Parseable {
        private final URL input;

        ParseableURL(URL uRL, ConfigParseOptions configParseOptions) {
            this.input = uRL;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            InputStream inputStream = this.input.openStream();
            return Parseable.readerFromStream(inputStream);
        }

        @Override
        ConfigSyntax guessSyntax() {
            return Parseable.syntaxFromExtension(this.input.getPath());
        }

        @Override
        ConfigParseable relativeTo(String string2) {
            URL uRL = ParseableURL.relativeTo(this.input, string2);
            if (uRL == null) {
                return null;
            }
            return ParseableURL.newURL(uRL, this.options().setOriginDescription(null));
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newURL(this.input);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.input.toExternalForm() + ")";
        }
    }

    private static final class ParseableString
    extends Parseable {
        private final String input;

        ParseableString(String string2, ConfigParseOptions configParseOptions) {
            this.input = string2;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() {
            return new StringReader(this.input);
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newSimple("String");
        }
    }

    private static final class ParseableReader
    extends Parseable {
        private final Reader reader;

        ParseableReader(Reader reader, ConfigParseOptions configParseOptions) {
            this.reader = reader;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() {
            return this.reader;
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newSimple("Reader");
        }
    }

    private static final class ParseableNotFound
    extends Parseable {
        private final String what;
        private final String message;

        ParseableNotFound(String string2, String string3, ConfigParseOptions configParseOptions) {
            this.what = string2;
            this.message = string3;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            throw new FileNotFoundException(this.message);
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newSimple(this.what);
        }
    }
}

