/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigString;

final class DefaultTransformer {
    DefaultTransformer() {
    }

    static AbstractConfigValue transform(AbstractConfigValue abstractConfigValue, ConfigValueType configValueType) {
        if (abstractConfigValue.valueType() == ConfigValueType.STRING) {
            String string2 = (String)abstractConfigValue.unwrapped();
            switch (configValueType) {
                case NUMBER: {
                    try {
                        Long l = Long.parseLong(string2);
                        return new ConfigLong(abstractConfigValue.origin(), l, string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            Double d = Double.parseDouble(string2);
                            return new ConfigDouble(abstractConfigValue.origin(), d, string2);
                        }
                        catch (NumberFormatException numberFormatException2) {
                            break;
                        }
                    }
                }
                case NULL: {
                    if (!string2.equals("null")) break;
                    return new ConfigNull(abstractConfigValue.origin());
                }
                case BOOLEAN: {
                    if (string2.equals("true") || string2.equals("yes") || string2.equals("on")) {
                        return new ConfigBoolean(abstractConfigValue.origin(), true);
                    }
                    if (!string2.equals("false") && !string2.equals("no") && !string2.equals("off")) break;
                    return new ConfigBoolean(abstractConfigValue.origin(), false);
                }
                case LIST: {
                    break;
                }
                case OBJECT: {
                    break;
                }
            }
        } else if (configValueType == ConfigValueType.STRING) {
            switch (abstractConfigValue.valueType()) {
                case NUMBER: 
                case BOOLEAN: {
                    return new ConfigString(abstractConfigValue.origin(), abstractConfigValue.transformToString());
                }
                case NULL: {
                    break;
                }
                case OBJECT: {
                    break;
                }
                case LIST: {
                    break;
                }
            }
        }
        return abstractConfigValue;
    }
}

