/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.MergeableValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SubstitutionResolver;
import com.typesafe.config.impl.Unmergeable;
import java.io.Serializable;

abstract class AbstractConfigValue
implements ConfigValue,
MergeableValue,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SimpleConfigOrigin origin;

    AbstractConfigValue(ConfigOrigin configOrigin) {
        this.origin = (SimpleConfigOrigin)configOrigin;
    }

    @Override
    public SimpleConfigOrigin origin() {
        return this.origin;
    }

    AbstractConfigValue resolveSubstitutions(SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        return this;
    }

    ResolveStatus resolveStatus() {
        return ResolveStatus.RESOLVED;
    }

    AbstractConfigValue relativized(Path path) {
        return this;
    }

    @Override
    public AbstractConfigValue toFallbackValue() {
        return this;
    }

    protected abstract AbstractConfigValue newCopy(boolean var1, ConfigOrigin var2);

    protected boolean ignoresFallbacks() {
        return true;
    }

    private ConfigException badMergeException() {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("method should not have been called with ignoresFallbacks=true" + this.getClass().getSimpleName());
        }
        throw new ConfigException.BugOrBroken("should override this in " + this.getClass().getSimpleName());
    }

    protected AbstractConfigValue mergedWithTheUnmergeable(Unmergeable unmergeable) {
        throw this.badMergeException();
    }

    protected AbstractConfigValue mergedWithObject(AbstractConfigObject abstractConfigObject) {
        throw this.badMergeException();
    }

    protected AbstractConfigValue mergedWithNonObject(AbstractConfigValue abstractConfigValue) {
        return this.newCopy(true, this.origin);
    }

    public AbstractConfigValue withOrigin(ConfigOrigin configOrigin) {
        if (this.origin == configOrigin) {
            return this;
        }
        return this.newCopy(this.ignoresFallbacks(), configOrigin);
    }

    @Override
    public AbstractConfigValue withFallback(ConfigMergeable configMergeable) {
        if (this.ignoresFallbacks()) {
            return this;
        }
        ConfigValue configValue = ((MergeableValue)configMergeable).toFallbackValue();
        if (configValue instanceof Unmergeable) {
            return this.mergedWithTheUnmergeable((Unmergeable)((Object)configValue));
        }
        if (configValue instanceof AbstractConfigObject) {
            AbstractConfigObject abstractConfigObject = (AbstractConfigObject)configValue;
            if (abstractConfigObject.resolveStatus() == ResolveStatus.RESOLVED && abstractConfigObject.isEmpty()) {
                if (abstractConfigObject.ignoresFallbacks()) {
                    return this.newCopy(true, this.origin);
                }
                return this;
            }
            return this.mergedWithObject((AbstractConfigObject)configValue);
        }
        return this.mergedWithNonObject((AbstractConfigValue)configValue);
    }

    protected boolean canEqual(Object object) {
        return object instanceof ConfigValue;
    }

    public boolean equals(Object object) {
        if (object instanceof ConfigValue) {
            return this.canEqual(object) && this.valueType() == ((ConfigValue)object).valueType() && ConfigImplUtil.equalsHandlingNull(this.unwrapped(), ((ConfigValue)object).unwrapped());
        }
        return false;
    }

    public int hashCode() {
        Object object = this.unwrapped();
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.render(stringBuilder, 0, null, false);
        return this.getClass().getSimpleName() + "(" + stringBuilder.toString() + ")";
    }

    protected static void indent(StringBuilder stringBuilder, int n) {
        for (int i = n; i > 0; --i) {
            stringBuilder.append("    ");
        }
    }

    protected void render(StringBuilder stringBuilder, int n, String string2, boolean bl) {
        if (string2 != null) {
            stringBuilder.append(ConfigImplUtil.renderJsonString(string2));
            stringBuilder.append(" : ");
        }
        this.render(stringBuilder, n, bl);
    }

    protected void render(StringBuilder stringBuilder, int n, boolean bl) {
        Object object = this.unwrapped();
        stringBuilder.append(object.toString());
    }

    @Override
    public final String render() {
        StringBuilder stringBuilder = new StringBuilder();
        this.render(stringBuilder, 0, null, true);
        return stringBuilder.toString();
    }

    String transformToString() {
        return null;
    }

    protected static interface Modifier {
        public AbstractConfigValue modifyChild(AbstractConfigValue var1);
    }
}

