/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j.parameters;

import com.googlecode.charts4j.LineStyle;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.parameters.AbstractParameter;
import java.util.List;

final class LineChartLineStylesParameter
extends AbstractParameter {
    private static final String URL_PARAMETER_KEY = "chls";
    private final List<LineStyleWrapper> lineStyles = Lists.newLinkedList();

    LineChartLineStylesParameter() {
    }

    void addLineStyle(LineStyle lineStyle) {
        this.lineStyles.add(new LineStyleWrapper(lineStyle));
    }

    public String getKey() {
        return URL_PARAMETER_KEY;
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (LineStyleWrapper l : this.lineStyles) {
            sb.append(cnt++ > 0 ? "|" : "").append(l);
        }
        return !this.lineStyles.isEmpty() ? sb.toString() : "";
    }

    private static final class LineStyleWrapper {
        private final LineStyle lineStyle;

        LineStyleWrapper(LineStyle lineStyle) {
            this.lineStyle = lineStyle;
        }

        public String toString() {
            return this.lineStyle.getLineThickness() + "," + this.lineStyle.getLengthOfLineSegment() + "," + this.lineStyle.getLengthOfBlankSegment();
        }
    }
}

