/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.AxisLabels;
import com.googlecode.charts4j.AxisLabelsImpl;
import com.googlecode.charts4j.RadialAxisLabels;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import com.googlecode.charts4j.collect.PrimitiveArrays;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AxisLabelsFactory {
    private AxisLabelsFactory() {
        throw new AssertionError();
    }

    public static AxisLabels newAxisLabels(List<? extends String> labels, List<? extends Number> positions) {
        Preconditions.checkContentsNotNull(labels, "labels list is null or contains a null value");
        Preconditions.checkContentsNotNull(positions, "positions list is null or contains a null value");
        if (!labels.isEmpty() && !positions.isEmpty()) {
            Preconditions.checkArgument(labels.size() == positions.size(), "There must be the same number of labels as positions.");
            for (Number number2 : positions) {
                Preconditions.checkArgument(number2.doubleValue() >= 0.0 && number2.doubleValue() <= 100.0, "position does not fall between 0.0 and 100.0 range");
            }
        }
        return new AxisLabelsImpl(labels, positions);
    }

    public static AxisLabels newAxisLabels(List<? extends String> labels) {
        Preconditions.checkContentsNotNull(labels, "labels list is null or contains a null value");
        return AxisLabelsFactory.newAxisLabels(labels, Collections.emptyList());
    }

    public static AxisLabels newAxisLabels(String ... labels) {
        Preconditions.checkContentsNotNull(Arrays.asList(labels), "labels list is null or contains a null value");
        return AxisLabelsFactory.newAxisLabels(Arrays.asList(labels), Collections.emptyList());
    }

    public static RadialAxisLabels newRadialAxisLabels(List<? extends String> labels) {
        return (RadialAxisLabels)((Object)AxisLabelsFactory.newAxisLabels(labels, Collections.emptyList()));
    }

    public static RadialAxisLabels newRadialAxisLabels(String ... labels) {
        return (RadialAxisLabels)((Object)AxisLabelsFactory.newAxisLabels(Arrays.asList(labels), Collections.emptyList()));
    }

    public static AxisLabels newAxisLabels(String label, double position) {
        Preconditions.checkNotNull(label, "label cannot be null.");
        return AxisLabelsFactory.newAxisLabels(Lists.of(label), Lists.of(position));
    }

    public static AxisLabels newNumericAxisLabels(List<? extends Number> values2) {
        return AxisLabelsFactory.newAxisLabels(Collections.emptyList(), values2);
    }

    public static AxisLabels newNumericAxisLabels(double ... values2) {
        Preconditions.checkNotNull(values2, "values cannot be null.");
        return AxisLabelsFactory.newNumericAxisLabels(PrimitiveArrays.asList(values2));
    }

    public static AxisLabels newNumericRangeAxisLabels(double minRange, double maxRange) {
        return new AxisLabelsImpl(minRange, maxRange, Double.NaN);
    }

    public static AxisLabels newNumericRangeAxisLabels(double minRange, double maxRange, double interval) {
        return new AxisLabelsImpl(minRange, maxRange, interval);
    }
}

