/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class VcfFileIndexIntervals {
    public static boolean debug = false;
    public static final int POS_OFFSET = 1;
    private static final long PAGE_SIZE = Integer.MAX_VALUE;
    private static final int BUFF_SIZE = 0x100000;
    boolean verbose = false;
    String fileName;
    long size = 0L;
    FileChannel fileChannel;
    ArrayList<MappedByteBuffer> maps = new ArrayList();
    ArrayList<ByteBuffer> buffers = new ArrayList();
    HashMap<String, FileRegion> fileRegions = new HashMap();

    public VcfFileIndexIntervals(String fileName) {
        this.fileName = fileName;
    }

    String chromo(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        return line.split("\\t")[0];
    }

    public void close() {
        try {
            this.fileChannel.close();
            this.fileChannel = null;
            this.maps = null;
            this.buffers = null;
        }
        catch (IOException e) {
            System.err.println("I/O problem while closing file '" + this.fileName + "'");
            throw new RuntimeException(e);
        }
    }

    void dump(long start, long end) {
        int pageStart = (int)(start / Integer.MAX_VALUE);
        int indexStart = (int)(start % Integer.MAX_VALUE);
        int pageEnd = (int)(end / Integer.MAX_VALUE);
        int indexEnd = (int)(end % Integer.MAX_VALUE);
        byte[] buff = new byte[0x100000];
        int page = pageStart;
        while (page <= pageEnd) {
            long max2 = Integer.MAX_VALUE;
            if (page == pageEnd) {
                max2 = indexEnd;
            }
            ByteBuffer bf = this.buffers.get(page);
            bf.position(indexStart);
            long pos = indexStart;
            while (pos < max2) {
                int len = (int)Math.min(max2 - pos, (long)buff.length);
                bf.get(buff, 0, len);
                String out = new String(buff, 0, len);
                System.out.print(out);
                pos += (long)buff.length;
            }
            indexStart = 0;
            ++page;
        }
    }

    public void dump(String chr, int posStart, int posEnd) {
        long fileStart = this.find(chr, posStart, false);
        long fileEnd = this.find(chr, posEnd, true);
        this.dump(fileStart, fileEnd);
    }

    long find(int chrPos, long start, String lineStart, long end, String lineEnd, boolean lessEq) {
        int posStart = this.pos(lineStart);
        if (chrPos == posStart) {
            return start;
        }
        int posEnd = this.pos(lineEnd);
        if (chrPos == posEnd) {
            return end + (long)lineEnd.length() + 1L;
        }
        if (debug) {
            Gpr.debug("Find:\t" + chrPos + "\t[" + posStart + ", " + posEnd + "]\tFile: [" + start + " , " + end + "]\tsize: " + (end - start));
        }
        if (lessEq) {
            if (posStart >= chrPos) {
                return start;
            }
            if (start + (long)lineStart.length() + 1L >= end) {
                return start;
            }
        } else {
            if (posEnd <= chrPos) {
                return end + (long)lineEnd.length() + 1L;
            }
            if (start + (long)lineStart.length() + 1L >= end) {
                return end + (long)lineEnd.length() + 1L;
            }
        }
        if (posStart >= posEnd) {
            throw new RuntimeException("This should never happen! Is the file sorted by position?");
        }
        long mid = (start + end) / 2L;
        String lineMid = this.getLine((long)mid).line;
        long posMid = this.pos(lineMid);
        if (lessEq ? (long)chrPos <= posMid : (long)chrPos < posMid) {
            return this.find(chrPos, start, lineStart, mid, lineMid, lessEq);
        }
        return this.find(chrPos, mid, lineMid, end, lineEnd, lessEq);
    }

    long find(String chr, int pos, boolean lessEq) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            throw new RuntimeException("No such chromosome: '" + chr + "'");
        }
        long posFound = this.find(pos, fr.start, fr.lineStart, fr.end, fr.lineEnd, lessEq);
        return this.getLine((long)posFound).position;
    }

    public byte get(long bytePosition) {
        int page = (int)(bytePosition / Integer.MAX_VALUE);
        int index2 = (int)(bytePosition % Integer.MAX_VALUE);
        return this.buffers.get(page).get(index2);
    }

    public Set<String> getChromos() {
        return this.fileRegions.keySet();
    }

    public long getEnd(String chr) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            return -1L;
        }
        return fr.end;
    }

    FileRegion getFileRegion(String chr) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            fr = new FileRegion();
            this.fileRegions.put(chr, fr);
        }
        return fr;
    }

    public LineAndPos getLine(long pos) {
        byte b;
        long position;
        long size2 = this.size();
        if (pos >= size2 || pos < 0L) {
            return null;
        }
        LineAndPos linePos = new LineAndPos();
        StringBuffer sb = new StringBuffer();
        long p = position = pos - 1L;
        while (p >= 0L) {
            b = this.get(p);
            if (b == 10) break;
            sb.insert(0, (char)b);
            --p;
            --position;
        }
        linePos.position = position + 1L;
        p = pos;
        while (p < size2) {
            b = this.get(p);
            if (b == 10) break;
            sb.append((char)b);
            ++p;
        }
        linePos.line = sb.toString();
        return linePos;
    }

    public long getStart(String chr) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            return -1L;
        }
        return fr.start;
    }

    public void index() {
        long end = this.size() - 1L;
        String lineEnd = this.getLine((long)end).line;
        String chrEnd = this.chromo(lineEnd);
        FileRegion fr = this.getFileRegion(chrEnd);
        fr.end = end;
        fr.lineEnd = lineEnd;
        if (this.verbose) {
            System.err.println("\tindex:\t" + chrEnd + "\t" + end);
        }
        long start = 0L;
        String lineStart = "";
        start = 0L;
        while (start < this.size) {
            lineStart = this.getLine((long)start).line;
            if (this.chromo(lineStart) != null) break;
            start += (long)(lineStart.length() + 1);
        }
        String chrStart = this.chromo(lineStart);
        fr = this.getFileRegion(chrStart);
        fr.start = start;
        fr.lineStart = lineStart;
        if (this.verbose) {
            System.err.println("\tindex:\t" + chrStart + "\t" + start);
        }
        this.indexChromos(start, lineStart, end, lineEnd);
    }

    void indexChromos(long start, String lineStart, long end, String lineEnd) {
        String chrEnd;
        String chrStart;
        if (debug) {
            Gpr.debug("Index:\n\t" + start + " :\t" + this.s(lineStart) + "\n\t" + end + " :\t" + this.s(lineEnd));
        }
        if ((chrStart = this.chromo(lineStart)).equals(chrEnd = this.chromo(lineEnd))) {
            return;
        }
        if (start + (long)lineStart.length() + 1L >= end) {
            if (this.verbose) {
                System.err.println("\tindex:\t" + chrStart + " / " + chrEnd + "\t" + start + " / " + end);
            }
            this.getFileRegion((String)chrEnd).start = this.getLine((long)end).position;
            this.getFileRegion((String)chrEnd).lineStart = lineEnd;
            this.getFileRegion((String)chrStart).end = this.getLine((long)start).position;
            this.getFileRegion((String)chrStart).lineEnd = lineStart;
            return;
        }
        long mid = (start + end) / 2L;
        String lineMid = this.getLine((long)mid).line;
        this.indexChromos(start, lineStart, mid, lineMid);
        this.indexChromos(mid, lineMid, end, lineEnd);
    }

    void init(FileChannel channel) throws IOException {
    }

    public void open() {
        try {
            this.fileChannel = new FileInputStream(this.fileName).getChannel();
            this.size = this.fileChannel.size();
            long start = 0L;
            long length = 0L;
            int index2 = 0;
            while (start + length < this.fileChannel.size()) {
                length = this.fileChannel.size() / Integer.MAX_VALUE == (long)index2 ? this.fileChannel.size() - (long)index2 * Integer.MAX_VALUE : Integer.MAX_VALUE;
                start = (long)index2 * Integer.MAX_VALUE;
                MappedByteBuffer map2 = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, start, length);
                this.maps.add(index2, map2);
                ByteBuffer buff = map2.asReadOnlyBuffer();
                this.buffers.add(index2, buff);
                ++index2;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found '" + this.fileName + "'");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            System.err.println("I/O problem while mapping file '" + this.fileName + "'");
            throw new RuntimeException(e);
        }
    }

    int pos(String line) {
        if (line.startsWith("#")) {
            return 0;
        }
        return Gpr.parseIntSafe(line.split("\\t")[1]) - 1;
    }

    String s(String s) {
        if (s == null) {
            return "null";
        }
        return s.length() <= 50 ? s : s.substring(0, 50);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public long size() {
        return this.size;
    }

    class FileRegion {
        long start;
        long end;
        String lineStart;
        String lineEnd;

        FileRegion() {
        }
    }

    class LineAndPos {
        String line;
        long position;

        LineAndPos() {
        }
    }
}

