/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.List;

public class TsTvStats
implements SamplingStats<VcfEntry> {
    static int[] GENOTYPE_SINGLE_ALT_CHANGE = new int[]{1};
    List<String> sampleNames;
    Boolean homozygous;
    long[] countTs;
    long[] countTv;

    public TsTvStats() {
        this.homozygous = null;
    }

    public TsTvStats(Boolean homozygous) {
        this.homozygous = homozygous;
    }

    @Override
    public boolean hasData() {
        return this.countTs != null;
    }

    public boolean isTransition(String ref, String alt) {
        if (ref.equals("A") && alt.equals("G")) {
            return true;
        }
        if (ref.equals("G") && alt.equals("A")) {
            return true;
        }
        if (ref.equals("C") && alt.equals("T")) {
            return true;
        }
        return ref.equals("T") && alt.equals("C");
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        block15: {
            boolean homo;
            block14: {
                if (this.sampleNames == null) {
                    this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
                }
                if (!vcfEntry.isVariant() || !vcfEntry.isSnp()) {
                    return;
                }
                int genotypes = vcfEntry.getVcfGenotypes().size();
                if (this.countTs == null) {
                    int size2 = Math.max(genotypes, 1);
                    this.countTs = new long[size2];
                    this.countTv = new long[size2];
                }
                if (genotypes <= 0) break block14;
                int sampleNum = 0;
                for (VcfGenotype vcfGenotype : vcfEntry) {
                    if (vcfGenotype.isVariant() && (this.homozygous == null || vcfGenotype.isHomozygous() == this.homozygous.booleanValue())) {
                        String[] alts = vcfEntry.getAlts();
                        int[] gens = vcfGenotype.getGenotype();
                        if (gens == null) {
                            gens = GENOTYPE_SINGLE_ALT_CHANGE;
                        }
                        int[] nArray = gens;
                        int n = gens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int gen = nArray[n2];
                            if (gen > 0) {
                                String alt;
                                String ref = vcfEntry.getRef();
                                if (this.isTransition(ref, alt = alts[gen - 1])) {
                                    int n3 = sampleNum;
                                    this.countTs[n3] = this.countTs[n3] + 1L;
                                } else {
                                    int n4 = sampleNum;
                                    this.countTv[n4] = this.countTv[n4] + 1L;
                                }
                            }
                            ++n2;
                        }
                    }
                    ++sampleNum;
                }
                break block15;
            }
            boolean bl = homo = vcfEntry.getAlts().length <= 1;
            if (this.homozygous != null && homo != this.homozygous) break block15;
            String ref = vcfEntry.getRef();
            String[] stringArray = vcfEntry.getAlts();
            int n = stringArray.length;
            int n5 = 0;
            while (n5 < n) {
                String alt = stringArray[n5];
                if (!ref.equals(alt)) {
                    if (this.isTransition(ref, alt)) {
                        this.countTs[0] = this.countTs[0] + 1L;
                    } else {
                        this.countTv[0] = this.countTv[0] + 1L;
                    }
                }
                ++n5;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            sb.append("Sample        :\t");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(String.valueOf(sname) + "\t");
                }
            }
            sb.append("Total");
            sb.append("\n");
            long sumTs = 0L;
            sb.append("Transitions   :\t");
            int i = 0;
            while (i < this.countTs.length) {
                sb.append(String.valueOf(this.countTs[i]) + "\t");
                sumTs += this.countTs[i];
                ++i;
            }
            sb.append(sumTs);
            sb.append("\n");
            long sumTv = 0L;
            sb.append("Transversions :\t");
            int i2 = 0;
            while (i2 < this.countTv.length) {
                sb.append(String.valueOf(this.countTv[i2]) + "\t");
                sumTv += this.countTv[i2];
                ++i2;
            }
            sb.append(sumTv);
            sb.append("\n");
            sb.append("Ts/Tv         :\t");
            i2 = 0;
            while (i2 < this.countTv.length) {
                double tstv = (double)this.countTs[i2] / (double)this.countTv[i2];
                sb.append(String.format("%.3f\t", tstv));
                ++i2;
            }
            double tstv = (double)sumTs / (double)sumTv;
            sb.append(String.format("%.3f\t", tstv));
            sb.append("\n");
        }
        return sb.toString();
    }
}

