/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.util.GprHtml;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class CountByType
implements Serializable {
    public static final String TOTAL_TYPE = "Total";
    HashMap<String, Long> countByType = new HashMap();
    HashMap<String, Double> pValueByType = new HashMap();
    HashMap<String, Double> scoreByType = new HashMap();

    public void addScore(String type, double score) {
        Double currScore = this.scoreByType.get(type);
        if (currScore == null) {
            currScore = 0.0;
        }
        this.scoreByType.put(type, currScore + score);
    }

    public long get(String type) {
        return this.getCount(this.countByType, type);
    }

    public String getColorHtml(String type) {
        if (this.countByType.get(type) == null) {
            return "ffffff";
        }
        long count2 = this.get(type);
        Long max2 = Long.MIN_VALUE;
        Long min2 = Long.MAX_VALUE;
        for (String key : this.countByType.keySet()) {
            long v = this.get(key);
            max2 = Math.max(max2, v);
            min2 = Math.min(min2, v);
        }
        return GprHtml.heatMapColor(count2, max2, min2, 0xFF0000, 65280);
    }

    long getCount(HashMap<String, Long> hash2, String type) {
        if (type.equalsIgnoreCase(TOTAL_TYPE)) {
            long total = 0L;
            for (Long count2 : hash2.values()) {
                total += count2 != null ? count2 : 0L;
            }
            return total;
        }
        Long count3 = hash2.get(type);
        return count3 != null ? count3 : 0L;
    }

    public double getScore(String type) {
        Double score = this.scoreByType.get(type);
        return score != null ? score : 0.0;
    }

    public List<String> getTypeList() {
        ArrayList<String> list2 = new ArrayList<String>();
        list2.addAll(this.countByType.keySet());
        Collections.sort(list2);
        return list2;
    }

    public boolean hasData() {
        return !this.countByType.isEmpty();
    }

    void inc(HashMap<String, Long> hash2, String type, int toAdd) {
        Long count2 = hash2.get(type);
        if (count2 == null) {
            count2 = 0L;
        }
        count2 = count2 + (long)toAdd;
        hash2.put(type, count2);
    }

    public void inc(String type) {
        this.inc(this.countByType, type, 1);
    }

    public void inc(String type, int increment) {
        this.inc(this.countByType, type, increment);
    }

    public long max() {
        long max2 = Long.MIN_VALUE;
        for (Long count2 : this.countByType.values()) {
            max2 = Math.max(max2, count2);
        }
        return max2;
    }

    public long min() {
        long min2 = Long.MAX_VALUE;
        for (Long count2 : this.countByType.values()) {
            min2 = Math.min(min2, count2);
        }
        return min2;
    }

    public double percent(String type) {
        long total = this.get(TOTAL_TYPE);
        long meth = this.get(type);
        return this.toProb(meth, total);
    }

    public long sum() {
        return this.get(TOTAL_TYPE);
    }

    double toProb(long num, long total) {
        double p = 0.0;
        if (total > 0L) {
            p = (double)num / (double)total;
        }
        return p;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (String type : this.getTypeList()) {
            out.append(String.valueOf(type) + "\t" + this.get(type) + "\n");
        }
        return out.toString();
    }

    public String toStringLine() {
        StringBuffer out = new StringBuffer();
        for (String type : this.getTypeList()) {
            out.append(String.valueOf(type) + ":" + this.get(type) + "\t");
        }
        return out.toString();
    }

    public String toStringSort() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.countByType.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return (int)(CountByType.this.get(arg1) - CountByType.this.get(arg0));
            }
        });
        StringBuffer out = new StringBuffer();
        for (String type : keys) {
            out.append(String.valueOf(type) + "\t" + this.get(type) + "\n");
        }
        return out.toString();
    }
}

