/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.plot.GooglePlotInt;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class ChrPosStats {
    public static int MAX_BINS = 300;
    String chrName;
    int chrLength;
    int factor = 1;
    int[] count;
    int total;

    public ChrPosStats(String chrName, int chrLength) {
        this.chrName = chrName;
        this.chrLength = chrLength;
        this.total = 0;
        this.factor = 1;
        this.factor = 1;
        while (chrLength / this.factor > MAX_BINS) {
            this.factor *= 10;
        }
        int len = chrLength / this.factor + 1;
        this.count = new int[len];
        int i = 0;
        while (i < this.count.length) {
            this.count[i] = 0;
            ++i;
        }
    }

    String factorStr() {
        if (this.factor > 1000000000) {
            return String.valueOf(this.factor / 1000000000) + "Gb";
        }
        if (this.factor > 1000000) {
            return String.valueOf(this.factor / 1000000) + "Mb";
        }
        if (this.factor > 1000) {
            return String.valueOf(this.factor / 1000) + "Kb";
        }
        return String.valueOf(this.factor) + "b";
    }

    public int getTotal() {
        return this.total;
    }

    int[] posArray() {
        int[] pos = new int[this.count.length];
        int i = 0;
        while (i < pos.length) {
            pos[i] = i * this.factor;
            ++i;
        }
        return pos;
    }

    public void sample(int position) {
        if (this.chrLength <= 1) {
            Gpr.debug("Warning: Chromosome '" + this.chrName + "' has length " + this.chrLength);
            return;
        }
        int i = position / this.factor;
        if (i >= 0 && i < this.count.length) {
            int n = i;
            this.count[n] = this.count[n] + 1;
            ++this.total;
        } else {
            Gpr.debug("Error counting samples on chromosome '" + this.chrName + "'. Position '" + position + "' => count[" + i + "]  (count.length: " + this.count.length + ", factor: " + this.factor + ", chrLength: " + this.chrLength + ").");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Chromosome: " + this.chrName + "\n");
        sb.append("\tPosition :\t");
        int[] pos = this.posArray();
        int i = 0;
        while (i < this.count.length) {
            sb.append(String.valueOf(pos[i]) + "\t");
            ++i;
        }
        sb.append("\n");
        sb.append("\tCount    :\t");
        i = 0;
        while (i < this.count.length) {
            sb.append(String.valueOf(this.count[i]) + "\t");
            ++i;
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toStringHistoPlot(String title, String xAxisLabel, String yAxisLabel) {
        int[] pos = this.posArray();
        GooglePlotInt gghisto = new GooglePlotInt(pos, this.count, title, xAxisLabel, String.valueOf(yAxisLabel) + "/" + this.factorStr());
        return gghisto.toURLString();
    }
}

