/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesVcf
extends TestCase {
    boolean verbose = false;
    boolean createOutputFile = false;
    Random rand;
    Config config;
    Genome genome;

    public TestCasesVcf() {
        this.initRand();
        this.config = new Config("testCase", "snpEff.config");
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    void initSnpEffPredictor() {
        this.initSnpEffPredictor("testCase");
    }

    void initSnpEffPredictor(String genomeName) {
        this.config = new Config(genomeName, "snpEff.config");
        this.config.loadSnpEffectPredictor();
        this.genome = this.config.getGenome();
        this.config.getSnpEffectPredictor().buildForest();
    }

    public void test_01() {
        this.initSnpEffPredictor("testCase");
        String fileName = "./tests/vcf.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName, this.genome);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (SeqChange seqChange : vcfEntry.seqChanges()) {
                System.out.println(seqChange);
                String seqChangeStr = "chr" + seqChange.getChromosomeName() + ":" + seqChange.getStart() + "_" + seqChange.getReference() + "/" + seqChange.getChange();
                Assert.assertEquals(seqChange.getId(), seqChangeStr);
            }
        }
    }

    public void test_02_hetero() {
        this.initSnpEffPredictor("testCase");
        String fileName = "./tests/vcf_hetero.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName, this.genome);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (SeqChange seqChange : vcfEntry.seqChanges()) {
                if (seqChange.isHeterozygous()) continue;
                throw new RuntimeException("All VCF entries in this file should be heterozygous!\n\t" + seqChange);
            }
        }
    }

    public void test_02_homhet() {
        this.initSnpEffPredictor("testCase");
        String fileName = "./tests/vcf_homhet.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName, this.genome);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (SeqChange seqChange : vcfEntry.seqChanges()) {
                if (seqChange.isHomozygous()) {
                    throw new RuntimeException("NO multi-sample VCF entry should be homozygous!\n\t" + seqChange);
                }
                if (!seqChange.isHeterozygous()) continue;
                throw new RuntimeException("NO multi-sample VCF entry should be heterozygous!\n\t" + seqChange);
            }
        }
    }

    public void test_03_homo() {
        this.initSnpEffPredictor("testCase");
        String fileName = "./tests/vcf_homo.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName, this.genome);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (SeqChange seqChange : vcfEntry.seqChanges()) {
                Gpr.debug(String.valueOf(seqChange.isHeterozygous()) + "\t" + seqChange);
                if (seqChange.isHomozygous()) continue;
                throw new RuntimeException("All VCF entries in this file should be homozygous!\n\t" + seqChange);
            }
        }
    }

    public void test_04_del() {
        this.initSnpEffPredictor("testCase");
        String fileName = "./tests/vcf_04_del.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName, this.genome);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (SeqChange seqChange : vcfEntry.seqChanges()) {
                if (seqChange.isDel()) continue;
                throw new RuntimeException("All VCF entries in this file should be deletions!\n\t" + seqChange);
            }
        }
    }

    public void test_05_choking_on_dot_slash_dot() {
        this.initSnpEffPredictor("testCase");
        String fileName = "./tests/choking_on_dot_slash_dot.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName, this.genome);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (VcfGenotype gen : vcfEntry) {
                boolean var = gen.isVariant();
                System.out.println("\t" + var + "\t" + gen);
            }
        }
        System.out.println("");
    }

    public void test_06_mixed_change() {
        this.initSnpEffPredictor("testCase");
        String file = "./tests/array_out_of_bounds.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        vcf.setCreateChromos(true);
        Iterator iterator2 = vcf.iterator();
        if (iterator2.hasNext()) {
            VcfEntry vcfEntry = (VcfEntry)iterator2.next();
            System.out.println(vcfEntry);
            List<SeqChange> seqChanges = vcfEntry.seqChanges();
            if (Math.random() < 2.0) {
                throw new RuntimeException("Unimplemented functionality: Mixed changes are not fully supported!!!");
            }
            Assert.assertEquals("chr1:223919_?????", seqChanges.get(0).toString());
            Assert.assertEquals("chr1:223919_TC/AT", seqChanges.get(1).toString());
            throw new RuntimeException("REVIEW WHAT A SeqChange SHOULD LOOK LIKE!!!");
        }
    }

    public void test_07_long_lines() {
        this.initSnpEffPredictor("testCase");
        String file = "./tests/long.vcf";
        Timer t2 = new Timer();
        t2.start();
        VcfFileIterator vcf = new VcfFileIterator(file);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            System.out.println(String.valueOf(vcfEntry.getChromosomeName()) + ":" + vcfEntry.getStart());
            for (VcfGenotype vg : vcfEntry) {
                System.out.println("\t" + vg);
            }
        }
        if (t2.elapsed() > 1000L) {
            throw new RuntimeException("It should not take this long to process a few lines!!!");
        }
    }

    public void test_08_alt_del() {
        this.initSnpEffPredictor("testCase");
        String file = "./tests/alt_del.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            System.out.println(vcfEntry);
            boolean hasDel = false;
            for (SeqChange sc : vcfEntry.seqChanges()) {
                hasDel |= sc.isDel();
                System.out.println("\t" + sc + "\t" + sc.isDel());
            }
            Assert.assertEquals(true, hasDel);
        }
    }

    public void test_09_empty_ALT() {
        String file = "./tests/empty.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry vcfEntry : vcf) {
            System.out.println(vcfEntry);
            Assert.assertEquals(false, vcfEntry.isVariant());
        }
    }

    public void test_10_empty_QUAL() {
        String file = "./tests/empty.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry vcfEntry : vcf) {
            System.out.println(vcfEntry);
            Assert.assertEquals(0.0, vcfEntry.getQuality());
        }
    }

    public void test_11_empty() {
        String file = "./tests/empty.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry vcfEntry : vcf) {
            System.out.println(vcfEntry);
            Assert.assertEquals("1\t11169327\t.\tT\t.\t.\tPASS\tAC=0;AF=0.00;AN=176;DP=7756;MQ0=0;set=ReferenceInAll\tGT:DP\t0/0:115", vcfEntry.toString());
        }
    }

    public void test_12_readHeader() {
        String file = "./tests/test.chr1.1line.vcf";
        VcfFileIterator vcfFile = new VcfFileIterator(file);
        vcfFile.readHeader();
        int numLines = 0;
        for (VcfEntry vcfEntry : vcfFile) {
            System.out.println(vcfEntry);
            ++numLines;
        }
        Assert.assertEquals(1, numLines);
    }

    public void test_12_readHeader_NL() {
        String file = "./tests/test.chr1.1line.vcf";
        VcfFileIterator vcfFile = new VcfFileIterator(file);
        String header = vcfFile.readHeader();
        Assert.assertEquals(false, header.charAt(header.length() - 1) == '\n');
    }

    public void test_13_chrOri() {
        String file = "./tests/test.chr1.1line.vcf";
        VcfFileIterator vcfFile = new VcfFileIterator(file);
        vcfFile.readHeader();
        String chr = null;
        for (VcfEntry vcfEntry : vcfFile) {
            chr = vcfEntry.getChromosomeNameOri();
        }
        Assert.assertEquals("chr1", chr);
    }
}

