/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesIntervalSeqChange
extends TestCase {
    boolean debug = false;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    char[] chromoBases;

    public TestCasesIntervalSeqChange() {
        this.init();
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20120426L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, maxGeneLen, maxTranscripts, maxExons);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    public void test_01() {
        int N = 1000;
        int i = 0;
        while (i < N) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("INTERVAL (seqChange) Test iteration: " + i + "\n" + this.transcript);
            } else {
                System.out.println("INTERVAL (seqChange) Test iteration: " + i);
            }
            int pos = 0;
            while (pos < this.chromosome.size()) {
                int intLen = this.rand.nextInt(100) + 1;
                int start = pos;
                int end = Math.min(pos + intLen, this.chromosome.getEnd());
                SeqChange seqChange = new SeqChange(this.chromosome, start, end, "");
                Assert.assertEquals(true, seqChange.isInterval());
                String expectedEffect = "INTERGENIC";
                if (this.transcript.intersects(seqChange)) {
                    for (Exon ex : this.transcript) {
                        if (!ex.intersects(seqChange)) continue;
                        expectedEffect = "EXON";
                    }
                    if (!expectedEffect.equals("EXON")) {
                        expectedEffect = "INTRON";
                    }
                }
                List<ChangeEffect> effectsAll = this.snpEffectPredictor.seqChangeEffect(seqChange);
                ArrayList<ChangeEffect> effects = new ArrayList<ChangeEffect>();
                for (ChangeEffect eff : effectsAll) {
                    boolean copy = true;
                    if (eff.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR) {
                        copy = false;
                    }
                    if (eff.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_DONOR) {
                        copy = false;
                    }
                    if (!copy) continue;
                    effects.add(eff);
                }
                Assert.assertEquals(false, effects.isEmpty());
                if (this.debug && effects.size() > 1) {
                    System.out.println("Found more than one effect: " + effects.size() + "\n" + this.transcript);
                    for (ChangeEffect eff : effects) {
                        System.out.println("\t" + eff);
                    }
                }
                ChangeEffect effect = (ChangeEffect)effects.get(0);
                String effStr = effect.effect(true, true, true);
                if (this.debug) {
                    System.out.println("\t" + seqChange + "\t\tEffect: " + effStr);
                }
                Assert.assertEquals(expectedEffect, effStr);
                ++pos;
            }
            ++i;
        }
    }
}

