/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff3;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesGff3
extends TestCase {
    public SnpEffectPredictor buildAndCompare(String genome, String gff3File, String resultFile, boolean readSeqs) {
        int inOffset = 1;
        String expectedResult = Gpr.readFile(resultFile).trim();
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGff3 fgff3 = new SnpEffPredictorFactoryGff3(config, inOffset);
        fgff3.setFileName(gff3File);
        fgff3.setReadSequences(readSeqs);
        SnpEffectPredictor sep = fgff3.create();
        String result2 = this.show(sep.getGenome()).trim();
        System.out.println(result2);
        Assert.assertEquals(Gpr.noSpaces(expectedResult), Gpr.noSpaces(result2));
        return sep;
    }

    String show(Genome genome) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(genome.getVersion()) + "\n");
        for (Chromosome chr : genome) {
            sb.append(chr + "\n");
        }
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (Gene gene : genome.getGenes()) {
            genes.add(gene);
        }
        for (Gene gene : genes) {
            sb.append(gene);
            for (Transcript tr : gene.sortedStrand()) {
                sb.append("\t\tCDS '" + tr.getId() + "': " + tr.cds() + "\n");
            }
        }
        return sb.toString();
    }

    public void testCase_Exon_Simple() {
        String genome = "testCase";
        String gff3File = "tests/exonSimple.gff3";
        String resultFile = "tests/exonSimple.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true);
    }

    public void testCase_ExonIn() {
        String genome = "testCase";
        String gff3File = "tests/exonIn.gff3";
        String resultFile = "tests/exonIn.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true);
    }

    public void testCase_ExonOut() {
        String genome = "testCase";
        String gff3File = "tests/exonOut.gff3";
        String resultFile = "tests/exonOut.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true);
    }

    public void testCaseAthalianaTair10_AT5G66790() {
        String genome = "athalianaTair10";
        String gff3File = "tests/AT5G66790.gff3";
        String resultFile = "tests/AT5G66790.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true);
    }

    public void testCasePaeruPA14muccA() {
        String genome = "paeru.PA14";
        String gff3File = "tests/paeru.PA14.muccA.gff";
        String resultFile = "tests/paeru.PA14.muccA.txt";
        SnpEffectPredictor sep = this.buildAndCompare(genome, gff3File, resultFile, true);
        Gene gene = sep.getGenome().getGenes().iterator().next();
        Transcript tr = (Transcript)gene.iterator().next();
        List<SpliceSite> spliceSites = tr.findSpliceSites(true);
        Assert.assertEquals(0, spliceSites.size());
    }

    public void testCasePpersica() {
        String genome = "ppersica139";
        String gff3File = "tests/ppersica_139.gff";
        String resultFile = "tests/ppersica_139.txt";
        this.buildAndCompare(genome, gff3File, resultFile, false);
    }

    public void testCaseRice5() {
        String genome = "rice5";
        String gff3File = "tests/Os03t0150600.gff";
        String resultFile = "tests/Os03t0150600.txt";
        this.buildAndCompare(genome, gff3File, resultFile, false);
    }

    public void testCaseVibrio() {
        String genome = "vibrio";
        String gff3File = "tests/vibrio.gff3";
        String resultFile = "tests/vibrio.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true);
    }
}

