/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.CommandLine;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.Assert;
import junit.framework.TestCase;

public class IntegrationTest
extends TestCase {
    public final int BUFFER_SIZE = 0x100000;
    public static final int MAX_LINES_DIFF = 10;
    boolean verbose = false;

    public String command(CommandLine command, String[] args) {
        PrintStream oldOut = System.out;
        String standardOutput = "";
        ByteArrayOutputStream output2 = new ByteArrayOutputStream(0x100000);
        try {
            try {
                System.setOut(new PrintStream(output2));
                command.parseArgs(args);
                command.run();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                standardOutput = output2.toString();
                System.setOut(oldOut);
            }
        }
        finally {
            standardOutput = output2.toString();
            System.setOut(oldOut);
        }
        return standardOutput;
    }

    public void command(CommandLine command, String[] args, String expectedOutputFile) {
        System.err.println("Executing command '" + this.showCommand(command, args) + "'");
        String actualOutput = this.command(command, args);
        System.err.println("Reading results file '" + expectedOutputFile + "'");
        String expectedOutput = Gpr.readFile(expectedOutputFile);
        int expectedOutputCountLines = expectedOutput.split("\n").length;
        int actualOutputCountLines = actualOutput.split("\n").length;
        System.err.println("Comparing outputs\t\tExpected size: " + expectedOutput.length() + " (" + expectedOutputCountLines + " lines)\t\tActual size: " + actualOutput.length() + " (" + actualOutputCountLines + " lines)");
        int maxSize = Math.max(expectedOutput.length(), actualOutput.length());
        if (maxSize < 0x100000) {
            Assert.assertEquals(expectedOutput, actualOutput);
        } else if (!expectedOutput.equals(actualOutput)) {
            String msg = "Outputs differ!\n\tFile    : '" + expectedOutputFile + "'\n\tCommand : '" + this.showCommand(command, args) + "'";
            System.err.println(msg);
            System.err.println(this.showDiff(expectedOutput, actualOutput));
            throw new RuntimeException(msg);
        }
    }

    public String showCommand(CommandLine command, String[] args) {
        StringBuilder cmd = new StringBuilder();
        cmd.append(String.valueOf(command.getClass().getSimpleName()) + " ");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            cmd.append(String.valueOf(arg) + " ");
            ++n2;
        }
        return cmd.toString();
    }

    public String showDiff(String s1, String s2) {
        StringBuilder diff2 = new StringBuilder();
        String[] lines1 = s1.split("\n");
        String[] lines2 = s2.split("\n");
        diff2.append("Number of lines: " + lines1.length + " vs " + lines2.length + "\n");
        int min2 = Math.min(lines1.length, lines2.length);
        int countLinesDiff = 0;
        int i = 0;
        while (i < min2) {
            if (!lines1[i].equals(lines2[i])) {
                ++countLinesDiff;
                diff2.append(String.format("%10d\t|%s|\n", i + 1, lines1[i]));
                diff2.append(String.format("          \t|%s|\n", lines2[i]));
                diff2.append(String.format("          \t|%s|\n\n", this.showDiffLine(lines1[i], lines2[i])));
            }
            if (countLinesDiff > 10) break;
            ++i;
        }
        return diff2.toString();
    }

    public String showDiffLine(String l1, String l2) {
        int max2 = Math.max(l1.length(), l2.length());
        char[] d = new char[max2];
        int i = 0;
        while (i < max2) {
            d[i] = i >= l1.length() || i >= l2.length() ? 124 : (l1.charAt(i) != l2.charAt(i) ? 124 : (l1.charAt(i) == '\t' ? 9 : 32));
            ++i;
        }
        return new String(d);
    }
}

