/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.IntergenicConserved;
import ca.mcgill.mcb.pcingola.interval.IntronConserved;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnpEffPredictorFactoryGtf22
extends SnpEffPredictorFactoryGff {
    static final String ATTRIBUTE_PATTERN_REGEX = "\\s*(\\S+)\\s+\"(.*?)\"\\s*;";
    static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\s*(\\S+)\\s+\"(.*?)\"\\s*;");

    public SnpEffPredictorFactoryGtf22(Config config, int inOffset) {
        super(config, inOffset);
        this.version = "GTF22";
        this.fileName = String.valueOf(config.getBaseFileNameGenes()) + ".gtf";
    }

    void addInterval(String id, String type, String chromo, int start, int end, int strand, String geneId, String geneName, String transcriptId, boolean proteinCoding, String geneBioType, String trBioType, int frame) {
        Chromosome chromosome = this.getOrCreateChromosome(chromo);
        Gene gene = this.findGene(geneId);
        if (gene == null) {
            if (geneName == null) {
                geneName = geneId;
            }
            if (geneBioType == null || geneBioType.isEmpty()) {
                geneBioType = "mRNA";
            }
            gene = new Gene(chromosome, start, end, strand, geneId, geneName, geneBioType);
            this.add(gene);
        }
        Transcript tr = null;
        if (!transcriptId.isEmpty()) {
            tr = this.findTranscript(transcriptId);
            if (tr == null) {
                tr = new Transcript(gene, start, end, strand, transcriptId);
                if (trBioType == null || trBioType.isEmpty()) {
                    trBioType = "mRNA";
                }
                tr.setBioType(trBioType);
                this.add(tr);
            }
            if (proteinCoding) {
                tr.setProteinCoding(proteinCoding);
            }
        }
        if (this.is(type, EXON)) {
            if (type.equals("exon")) {
                int rank = 0;
                Exon exon = new Exon(tr, start, end, strand, id, rank);
                exon.setFrame(frame);
                this.add(exon);
            } else if (type.equals("CDS")) {
                Cds cds = new Cds(tr, start, end, strand, id);
                cds.setFrame(frame);
                this.add(cds);
            } else if (type.equals("stop_codon")) {
                Cds cds = new Cds(tr, start, end, strand, id);
                cds.setFrame(frame);
                this.add(cds);
            } else if (!type.equals("start_codon") && type.equals("intron_CNS")) {
                IntronConserved intronConserved = new IntronConserved(gene, start, end, strand, id);
                this.add(intronConserved);
                this.snpEffectPredictor.add(intronConserved);
            }
        } else if (this.is(type, UTR5) || this.is(type, UTR3)) {
            Marker utr = new Marker(tr, start, end, strand, id);
            Exon exon = tr.intersectingExon(utr);
            if (exon == null) {
                int rank = 0;
                String exonId = "Exon_" + chromo + "_" + (start + 1) + "_" + (end + 1);
                exon = new Exon(tr, start, end, strand, exonId, rank);
                exon.setFrame(frame);
                this.add(exon);
            }
            if (this.is(type, UTR5)) {
                Utr5prime u5int = new Utr5prime(exon, start, end, strand, id);
                tr.add(u5int);
                this.add(u5int);
            } else if (this.is(type, UTR3)) {
                Utr3prime u3int = new Utr3prime(exon, start, end, strand, id);
                tr.add(u3int);
                this.add(u3int);
            }
        } else if (this.is(type, INTERGENIC_CONSERVED)) {
            IntergenicConserved intergenicConserved = new IntergenicConserved(chromosome, start, end, strand, id);
            this.snpEffectPredictor.add(intergenicConserved);
            this.add(intergenicConserved);
        }
    }

    @Override
    protected boolean parse(String line, String typeToRead) {
        String[] fields = line.split("\t");
        if (fields.length <= 6) {
            return false;
        }
        String type = fields[2];
        if (!this.is(type, typeToRead)) {
            return false;
        }
        String chromo = fields[0];
        String source = fields[1];
        int start = this.parsePosition(fields[3]);
        int end = this.parsePosition(fields[4]);
        int strand = fields[6].equals("-") ? -1 : 1;
        int frame = fields[7].equals(".") ? -1 : Gpr.parseIntSafe(fields[7]);
        String geneId = "";
        String transcriptId = "";
        String geneName = null;
        boolean proteinCoding = this.isProteingCoding(source);
        String geneBioType = "";
        if (fields.length >= 8) {
            HashMap<String, String> attrMap = this.parseAttributes(fields[8]);
            geneId = attrMap.get("gene_id");
            transcriptId = attrMap.get("transcript_id");
            geneName = attrMap.get("gene_name");
            geneBioType = attrMap.get("gene_biotype");
        }
        String trBioType = source;
        if (geneId == null) {
            geneId = "";
        }
        if (transcriptId == null) {
            transcriptId = "";
        }
        String id = String.valueOf(type) + "_" + chromo + "_" + (start + 1) + "_" + (end + 1);
        if (geneId.isEmpty()) {
            this.warning("Empty gene_id. This should never happen (see norm");
        } else {
            this.addInterval(id, type, chromo, start, end, strand, geneId, geneName, transcriptId, proteinCoding, geneBioType, trBioType, frame);
        }
        return true;
    }

    HashMap<String, String> parseAttributes(String attrStr) {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        if (attrStr.length() > 0) {
            Matcher matcher = ATTRIBUTE_PATTERN.matcher(attrStr);
            while (matcher.find()) {
                if (matcher.groupCount() < 2) continue;
                String key = matcher.group(1).toLowerCase();
                String value2 = matcher.group(2);
                keyValues.put(key, value2);
            }
        }
        return keyValues;
    }
}

