/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.IntergenicConserved;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.util.HashMap;

public abstract class SnpEffPredictorFactoryGff
extends SnpEffPredictorFactory {
    public static boolean debug = false;
    public static final HashMap<String, String> typeMap;
    public static final String GENE;
    public static final String TRANSCRIPT;
    public static final String EXON;
    public static final String UTR5;
    public static final String UTR3;
    public static final String INTERGENIC_CONSERVED;
    public static final String FASTA_DELIMITER = "##FASTA";
    String version = "";
    boolean readSequences = true;
    boolean mainFileHasFasta = false;

    static {
        GENE = Gene.class.getSimpleName();
        TRANSCRIPT = Transcript.class.getSimpleName();
        EXON = Exon.class.getSimpleName();
        UTR5 = Utr5prime.class.getSimpleName();
        UTR3 = Utr3prime.class.getSimpleName();
        INTERGENIC_CONSERVED = IntergenicConserved.class.getSimpleName();
        typeMap = new HashMap();
        SnpEffPredictorFactoryGff.addTypeMap("gene", GENE);
        SnpEffPredictorFactoryGff.addTypeMap("pseudogene", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("mRNA", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("tRNA", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("snoRNA", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("rRNA", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("ncRNA", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("miRNA", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("snRNA", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("pseudogenic_transcript", TRANSCRIPT);
        SnpEffPredictorFactoryGff.addTypeMap("exon", EXON);
        SnpEffPredictorFactoryGff.addTypeMap("pseudogenic_exon", EXON);
        SnpEffPredictorFactoryGff.addTypeMap("CDS", EXON);
        SnpEffPredictorFactoryGff.addTypeMap("start_codon", EXON);
        SnpEffPredictorFactoryGff.addTypeMap("stop_codon", EXON);
        SnpEffPredictorFactoryGff.addTypeMap("intron_CNS", EXON);
        SnpEffPredictorFactoryGff.addTypeMap("five_prime_UTR", UTR5);
        SnpEffPredictorFactoryGff.addTypeMap("5'-UTR", UTR5);
        SnpEffPredictorFactoryGff.addTypeMap("5UTR", UTR5);
        SnpEffPredictorFactoryGff.addTypeMap("three_prime_UTR", UTR3);
        SnpEffPredictorFactoryGff.addTypeMap("3'-UTR", UTR3);
        SnpEffPredictorFactoryGff.addTypeMap("3UTR", UTR3);
        SnpEffPredictorFactoryGff.addTypeMap("inter_CNS", INTERGENIC_CONSERVED);
    }

    static void addTypeMap(String typeAliasStr, String type) {
        typeMap.put(typeAliasStr.toUpperCase(), type);
    }

    public SnpEffPredictorFactoryGff(Config config, int inOffset) {
        super(config, inOffset);
        this.markersById = new HashMap();
        this.genesById = new HashMap();
        this.transcriptsById = new HashMap();
        this.fileName = String.valueOf(config.getBaseFileNameGenes()) + ".gff";
    }

    @Override
    public SnpEffectPredictor create() {
        System.out.println("Reading " + this.version + " data file  : '" + this.fileName + "'");
        try {
            System.out.print("\tReading genes       : ");
            this.readGff(GENE);
            System.out.print("\tReading transcripts : ");
            this.readGff(TRANSCRIPT);
            System.out.print("\tReading exons       : ");
            this.readGff(EXON);
            if (!this.version.equals("GFF2")) {
                System.out.print("\tReading UTRs (5)    : ");
                this.readGff(UTR5);
                System.out.print("\tReading UTRs (3)    : ");
                this.readGff(UTR3);
            }
            this.beforeExonSequences();
            if (this.readSequences) {
                System.out.print("\tReading sequences   :\n");
                if (this.mainFileHasFasta) {
                    this.readExonSequencesGff(this.fileName);
                } else {
                    this.readExonSequences();
                }
            }
            System.out.println("Total: " + this.totalSeqsAdded + " sequences added, " + this.totalSeqsIgnored + " sequences ignored.");
            this.finishUp(false);
            boolean error = this.config.getGenome().showStats();
            if (error && this.readSequences) {
                throw new RuntimeException("Most Exons do not have sequences!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    boolean is(String term, String type) {
        String inType = typeMap.get(term.toUpperCase());
        if (inType == null) {
            return false;
        }
        return inType.equals(type);
    }

    protected boolean isProteingCoding(String source) {
        return source.equals("protein_coding");
    }

    protected abstract boolean parse(String var1, String var2);

    protected void readExonSequencesGff(String gffFileName) {
        try {
            BufferedReader reader = Gpr.reader(gffFileName);
            this.lineNum = 1;
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line.equals(FASTA_DELIMITER)) {
                    this.mainFileHasFasta = true;
                    break;
                }
                ++this.lineNum;
            }
            String chromoName = null;
            StringBuffer chromoSb = new StringBuffer();
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line.startsWith(">")) {
                    if (chromoName != null) {
                        this.chromoLen(chromoName, chromoSb.length());
                        this.addExonSequences(chromoName, chromoSb.toString());
                    }
                    chromoName = Chromosome.simpleName(this.line.substring(1).trim());
                    chromoSb = new StringBuffer();
                    System.out.println("\t\tReading sequence '" + chromoName + "'");
                } else {
                    chromoSb.append(this.line.trim());
                }
                ++this.lineNum;
            }
            if (chromoName != null) {
                this.chromoLen(chromoName, chromoSb.length());
                this.addExonSequences(chromoName, chromoSb.toString());
            } else {
                System.err.println("WARNING: Ignoring sequences for '" + chromoName + "'. Cannot find chromosome");
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void readGff(String typeToRead) throws Exception {
        int count2 = 0;
        BufferedReader reader = Gpr.reader(this.fileName);
        if (reader == null) {
            return;
        }
        try {
            this.lineNum = 1;
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line.equals(FASTA_DELIMITER)) {
                    this.mainFileHasFasta = true;
                    break;
                }
                if (this.parse(this.line, typeToRead)) {
                    Gpr.showMark(++count2, 1000);
                }
                ++this.lineNum;
            }
        }
        catch (Exception e) {
            Gpr.debug("Offending line (lineNum: " + this.lineNum + "): '" + this.line + "'");
            throw new RuntimeException(e);
        }
        reader.close();
        System.out.println(String.valueOf(count2 > 0 ? "\n" : "") + "\tTotal: " + count2 + " " + typeToRead + "s added.");
    }

    public void setReadSequences(boolean readSequences) {
        this.readSequences = readSequences;
    }
}

