/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalTree;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;

public class SnpEffCmdDump
extends SnpEff {
    DumpFormat dumpFormat = DumpFormat.Simple;
    String chrStr = "";

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                    } else {
                        this.usage("Option '-c' without config file argument");
                    }
                } else if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                    this.quiet = false;
                } else if (args[i].equals("-q") || args[i].equalsIgnoreCase("-quiet")) {
                    this.quiet = true;
                    this.verbose = false;
                } else if (args[i].equalsIgnoreCase("-chr")) {
                    this.chrStr = args[++i];
                } else if (args[i].equals("-if") || args[i].equalsIgnoreCase("-inOffset")) {
                    if (i + 1 < args.length) {
                        this.inOffset = Gpr.parseIntSafe(args[++i]);
                    }
                } else if (args[i].equals("-1")) {
                    this.outOffset = 1;
                    this.inOffset = 1;
                } else if (args[i].equals("-0")) {
                    this.outOffset = 0;
                    this.inOffset = 0;
                } else if (args[i].equals("-bed")) {
                    this.dumpFormat = DumpFormat.Bed;
                    this.outOffset = 0;
                    this.inOffset = 0;
                } else if (args[i].equals("-h") || args[i].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    System.exit(0);
                } else {
                    this.usage("Unknow option '" + args[i] + "'");
                }
            } else if (this.genomeVer.length() <= 0) {
                this.genomeVer = args[i];
            } else {
                this.usage("Unknow parameter '" + args[i] + "'");
            }
            ++i;
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    void printBed() {
        for (IntervalTree tree : this.config.getSnpEffectPredictor().getIntervalForest()) {
            for (Marker i : tree) {
                this.printBed(i);
                if (!(i instanceof Gene)) continue;
                Gene g = (Gene)i;
                for (Transcript t2 : g) {
                    this.printBed(t2);
                    for (Cds c : t2.getCds()) {
                        this.printBed(c);
                    }
                    for (Utr u : t2.getUtrs()) {
                        this.printBed(u);
                    }
                    for (Exon e : t2) {
                        this.printBed(e);
                    }
                }
            }
        }
    }

    void printBed(Marker marker) {
        String chr = String.valueOf(this.chrStr) + marker.getChromosome().getId();
        int start = marker.getStart() + this.outOffset;
        int end = marker.getEnd() + this.outOffset + 1;
        String name = String.valueOf(marker.getClass().getSimpleName()) + "_" + marker.getId();
        System.out.println(String.valueOf(chr) + "\t" + start + "\t" + end + "\t" + name);
    }

    @Override
    public boolean run() {
        this.config = new Config(this.genomeVer, this.configFile);
        if (this.verbose) {
            Timer.showStdErr("Reading database for genome '" + this.genomeVer + "' (this might take a while)");
        }
        this.config.loadSnpEffectPredictor();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        this.config.getSnpEffectPredictor().buildForest();
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
        if (this.dumpFormat == DumpFormat.Simple) {
            this.config.getSnpEffectPredictor().print();
        } else if (this.dumpFormat == DumpFormat.Bed) {
            this.printBed();
        } else {
            throw new RuntimeException("Unimplemented format '" + (Object)((Object)this.dumpFormat) + "'");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        System.err.println("Usage: snpEff dump [options] genome_version");
        System.err.println("\t-bed                    : Dump in BED format (implies -0)");
        System.err.println("\t-chr <string>           : Prepend 'string' to chromosome name (e.g. 'chr1' instead of '1')");
        System.err.println("\nGeneric options:");
        System.err.println("\t-0                      : File positions are zero-based");
        System.err.println("\t-1                      : File positions are one-based");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-h , -help              : Show this help and exit");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.err.println("\t-q , -quiet             : Quiet mode (do not show any messages or errors)");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.exit(-1);
    }

    public static enum DumpFormat {
        Simple,
        Bed;

    }
}

