/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Intergenic;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SnpEffectPredictor
implements Serializable {
    private static final long serialVersionUID = 4519418862303325081L;
    public static final int DEFAULT_UP_DOWN_LENGTH = 5000;
    boolean useChromosomes = true;
    int upDownStreamLength = 5000;
    Genome genome;
    Markers markers;
    IntervalForest intervalForest;

    public static SnpEffectPredictor load(Config config) {
        String snpEffPredFile = config.getFileSnpEffectPredictor();
        if (!Gpr.canRead(snpEffPredFile)) {
            throw new RuntimeException("\tERROR: Cannot read file '" + snpEffPredFile + "'.\n\tYou can try to download the database by running the following command:\n\t\tjava -jar snpEff.jar download " + config.getGenome().getVersion() + "\n");
        }
        MarkerSerializer ms = new MarkerSerializer();
        Markers markers = ms.load(snpEffPredFile);
        Genome genome = null;
        for (Marker m : markers) {
            if (!(m instanceof Genome)) continue;
            genome = (Genome)m;
        }
        if (genome == null) {
            throw new RuntimeException("Genome not found. This should never happen!");
        }
        SnpEffectPredictor snpEffectPredictor = new SnpEffectPredictor(genome);
        for (Marker m : markers) {
            if (!(m instanceof Gene)) continue;
            Gene gene = (Gene)m;
            snpEffectPredictor.add(gene);
        }
        for (Marker m : markers) {
            if (m instanceof Genome || m instanceof Chromosome || m instanceof Gene || m instanceof Transcript || m instanceof Exon || m instanceof Cds || m instanceof Utr || m instanceof SpliceSite) continue;
            snpEffectPredictor.add(m);
        }
        return snpEffectPredictor;
    }

    public SnpEffectPredictor(Genome genome) {
        this.genome = genome;
        this.markers = new Markers();
    }

    public void add(Gene gene) {
        this.genome.getGenes().add(gene);
    }

    public void add(Marker marker) {
        this.markers.add(marker);
    }

    public void buildForest() {
        this.intervalForest = new IntervalForest();
        if (this.useChromosomes) {
            for (Chromosome chr : this.genome) {
                this.intervalForest.add(chr);
            }
        }
        for (Gene gene : this.genome.getGenes()) {
            this.intervalForest.add(gene);
        }
        for (Marker m : this.genome.getGenes().createUpDownStream(this.upDownStreamLength)) {
            this.add(m);
        }
        for (Marker m : this.genome.getGenes().findSpliceSites(true)) {
            this.add(m);
        }
        this.intervalForest.add(this.markers);
        this.intervalForest.build();
    }

    public Gene getGene(String geneIntervalId) {
        return this.genome.getGenes().get(geneIntervalId);
    }

    public Genome getGenome() {
        return this.genome;
    }

    public IntervalForest getIntervalForest() {
        return this.intervalForest;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public int getUpDownStreamLength() {
        return this.upDownStreamLength;
    }

    public Markers intersects(Marker marker) {
        return this.intervalForest.query(marker);
    }

    public void print() {
        this.genome.showStats();
        System.out.println("Genome: " + this.genome.getVersion());
        for (Chromosome chr : this.genome) {
            System.out.println("Chromosome: \t" + chr.getId() + "\t" + chr.getStart() + "\t" + chr.getEnd());
        }
        for (Gene gene : this.genome.getGenes().sorted()) {
            System.out.println(gene);
        }
        for (Marker marker : this.markers) {
            System.out.println(marker);
        }
    }

    public Set<String> regions(Marker marker, boolean showGeneDetails, boolean compareTemplate) {
        return this.regions(marker, showGeneDetails, compareTemplate, null);
    }

    public Set<String> regions(Marker marker, boolean showGeneDetails, boolean compareTemplate, String id) {
        boolean hitChromo = false;
        boolean hitGene = false;
        HashSet<String> hits = new HashSet<String>();
        Markers intersects = this.intersects(marker);
        if (intersects.size() > 0) {
            for (Marker markerInt : intersects) {
                if (markerInt instanceof Chromosome) {
                    hitChromo = true;
                    hits.add(markerInt.getClass().getSimpleName());
                    continue;
                }
                if (markerInt instanceof Gene) {
                    Gene gene = (Gene)markerInt;
                    hitGene = true;
                    this.regionsAddHit(hits, gene, marker, showGeneDetails, compareTemplate);
                    for (Transcript tr : gene) {
                        if (id != null && !gene.getId().equals(id) && !tr.getId().equals(id) || !tr.intersects(marker)) continue;
                        boolean hitExon = false;
                        this.regionsAddHit(hits, tr, marker, showGeneDetails, compareTemplate);
                        for (Utr utr : tr.getUtrs()) {
                            if (!utr.intersects(marker)) continue;
                            this.regionsAddHit(hits, utr, marker, showGeneDetails, compareTemplate);
                        }
                        for (Exon ex : tr) {
                            if (!ex.intersects(marker)) continue;
                            this.regionsAddHit(hits, ex, marker, showGeneDetails, compareTemplate);
                            hitExon = true;
                        }
                        if (hitExon) continue;
                        Intron intron = new Intron(tr, marker.getStart(), marker.getEnd(), tr.getStrand(), "");
                        this.regionsAddHit(hits, intron, marker, showGeneDetails, compareTemplate);
                    }
                    continue;
                }
                if (id == null) {
                    this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
                    continue;
                }
                Transcript tr = (Transcript)markerInt.findParent(Transcript.class);
                if (tr != null && tr.getId().equals(id)) {
                    this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
                    continue;
                }
                Gene gene = (Gene)markerInt.findParent(Gene.class);
                if (gene == null || !gene.getId().equals(id)) continue;
                this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
            }
        }
        if (!hitChromo) {
            throw new RuntimeException("ERROR: Out of chromosome range. " + marker);
        }
        if (!hitGene) {
            hits.add(Intergenic.class.getSimpleName());
        }
        return hits;
    }

    void regionsAddHit(HashSet<String> hits, Marker hit2add, Marker marker, boolean showGeneDetails, boolean compareTemplate) {
        Gene gene;
        String hitStr = hit2add.getClass().getSimpleName();
        if (compareTemplate && (gene = (Gene)hit2add.findParent(Gene.class)) != null) {
            hitStr = String.valueOf(hitStr) + (hit2add.isStrandPlus() == marker.isStrandPlus() ? "_TEMPLATE_STRAND" : "_NON_TEMPLATE_STRAND");
        }
        if (showGeneDetails && hit2add instanceof Gene) {
            gene = (Gene)hit2add;
            hitStr = String.valueOf(hitStr) + "[" + gene.getBioType() + ", " + gene.getGeneName() + ", " + (gene.isProteinCoding() ? "protein" : "not-protein") + "]";
        }
        hits.add(hitStr);
    }

    public void removeNonCanonical() {
        for (Gene g : this.genome.getGenes()) {
            g.removeNonCanonical();
        }
    }

    public void save(Config config) {
        String databaseFile = config.getFileSnpEffectPredictor();
        MarkerSerializer markerSerializer = new MarkerSerializer();
        markerSerializer.save(databaseFile, this);
    }

    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange) {
        if (!seqChange.isChange() && !seqChange.isInterval()) {
            return ChangeEffect.emptyResults();
        }
        ChangeEffect results = new ChangeEffect(seqChange);
        if (Config.get().isErrorOnMissingChromo() && !this.intervalForest.hasTree(seqChange.getChromosomeName())) {
            results.addError("ERROR_CHROMOSOME_NOT_FOUND");
            return results.newList();
        }
        Markers intersects = this.intersects(seqChange);
        boolean hitChromo = false;
        boolean hitSomething = false;
        ArrayList<ChangeEffect> resultsList = new ArrayList<ChangeEffect>();
        if (intersects.size() > 0) {
            for (Marker marker : intersects) {
                if (marker instanceof Chromosome) {
                    hitChromo = true;
                    continue;
                }
                Marker mint = marker;
                results = new ChangeEffect(seqChange);
                List<ChangeEffect> resList = mint.seqChangeEffect(seqChange, results);
                if (!resList.isEmpty()) {
                    resultsList.addAll(resList);
                }
                hitSomething = true;
            }
        }
        if (!hitChromo) {
            if (Config.get().isErrorChromoHit()) {
                results.addError("ERROR_OUT_OF_CHROMOSOME_RANGE");
                return results.newList();
            }
        } else if (!hitSomething) {
            if (Config.get().isOnlyRegulation()) {
                results.effectType = ChangeEffect.EffectType.NONE;
                return results.newList();
            }
            results.effectType = ChangeEffect.EffectType.INTERGENIC;
            return results.newList();
        }
        return resultsList;
    }

    public void setUpDownStreamLength(int upDownStreamLength) {
        this.upDownStreamLength = upDownStreamLength;
    }

    public void setUseChromosomes(boolean useChromosomes) {
        this.useChromosomes = useChromosomes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.genome.getVersion()) + "\n");
        for (Chromosome chr : this.genome) {
            sb.append(chr + "\n");
        }
        sb.append(this.genome.getGenes());
        return sb.toString();
    }
}

