/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility.bootstrap;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import java.util.Random;

public class ReSampleInt {
    static int SHOW_EVERY = 10000;
    static int SHOW_EVERY_LINE = 1000000;
    boolean verbose = false;
    int sampleSize;
    int[] scores;
    TIntIntHashMap pdf;
    Random rand = new Random();
    int total = Integer.MIN_VALUE;

    public ReSampleInt(int[] scores, int sampleSize) {
        this.sampleSize = sampleSize;
        this.scores = scores;
    }

    public double cdf(int number2) {
        int sum2 = 0;
        int[] nArray = this.sortKeys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            sum2 += this.pdf.get(k);
            if (k >= number2) {
                return (double)sum2 / (double)this.total();
            }
            ++n2;
        }
        return 1.0;
    }

    protected void clearStats() {
        this.pdf = new TIntIntHashMap();
    }

    protected int evaluate() {
        int sum2 = 0;
        int i = 0;
        while (i < this.sampleSize) {
            sum2 += this.scores[this.rand.nextInt(this.scores.length)];
            ++i;
        }
        return sum2;
    }

    public int max() {
        int[] skeys = this.sortKeys();
        return skeys[skeys.length - 1];
    }

    public int min() {
        return this.sortKeys()[0];
    }

    public int quantile(double quantile) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new RuntimeException("Quantile out of range. Should be in [0, 1] range, value: " + quantile);
        }
        int[] keys = this.sortKeys();
        int total = this.total();
        int sum2 = 0;
        int[] nArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            double p = (double)(sum2 += this.pdf.get(k)) / (double)total;
            if (p >= quantile) {
                return k;
            }
            ++n2;
        }
        return Integer.MAX_VALUE;
    }

    public void resample(int iterations) {
        this.clearStats();
        int i = 1;
        while (i <= iterations) {
            int score = this.evaluate();
            int count2 = this.pdf.get(score) + 1;
            this.pdf.put(score, count2);
            if (this.verbose && i % SHOW_EVERY == 0) {
                if (i % SHOW_EVERY_LINE == 0) {
                    System.err.println('.');
                } else {
                    System.err.print('.');
                }
            }
            ++i;
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    int[] sortKeys() {
        int[] keys = this.pdf.keys();
        Arrays.sort(keys);
        return keys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total: " + this.pdf.size() + " entries:\n");
        int sum2 = 0;
        int[] nArray = this.sortKeys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            sb.append("\t" + k + "\t:\t" + this.pdf.get(k) + "\n");
            sum2 += this.pdf.get(k);
            ++n2;
        }
        sb.append("\tSum\t:\t" + sum2 + "\n");
        return sb.toString();
    }

    int total() {
        if (this.total > Integer.MIN_VALUE) {
            return this.total;
        }
        this.total = 0;
        int[] nArray = this.sortKeys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            this.total += this.pdf.get(k);
            ++n2;
        }
        return this.total;
    }
}

