/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.Collection;
import java.util.HashMap;

public class PlinkMap {
    public static boolean debug = false;
    HashMap<String, Integer> genotypeNames = new HashMap();
    String[] chrNames;
    int[] positions;
    String[] ids;

    public String getChrName(int idx) {
        return this.chrNames[idx];
    }

    public String getId(int idx) {
        return this.ids[idx];
    }

    public Collection<String> getGenotypeNames() {
        return this.genotypeNames.keySet();
    }

    public Integer getGenotypeNames(String idStr) {
        return this.genotypeNames.get(idStr);
    }

    public int getPosition(int idx) {
        return this.positions[idx];
    }

    public void read(String mapFileName) {
        String cols = Gpr.readFile(mapFileName);
        String[] lines2 = cols.split("\n");
        this.positions = new int[lines2.length];
        this.chrNames = new String[lines2.length];
        this.ids = new String[lines2.length];
        int lineNum = 0;
        String[] stringArray = lines2;
        int n = lines2.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] fields = line.split("\\s");
            this.chrNames[lineNum] = fields[0];
            this.ids[lineNum] = fields[1];
            this.positions[lineNum] = Gpr.parseIntSafe(fields[fields.length - 1]);
            if (!this.ids[lineNum].isEmpty()) {
                if (this.genotypeNames.containsKey(this.ids)) {
                    throw new RuntimeException("Duplicate ID '" + this.ids[lineNum] + "'. File '" + mapFileName + "', line '" + (lineNum + 1) + "'");
                }
                this.genotypeNames.put(this.ids[lineNum], lineNum);
                if (debug) {
                    Gpr.debug("genotypeNames.put(" + this.ids[lineNum] + ", " + lineNum + ")");
                }
            }
            ++lineNum;
            ++n2;
        }
    }

    public int size() {
        return this.positions.length;
    }
}

