/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.util.GprSeq;

public class PedGenotype {
    String[] genotypes;
    String chrName;
    int position;

    public PedGenotype(String[] genotypes) {
        this.genotypes = genotypes;
    }

    public PedGenotype(String[] genotypes, String chrName, int position) {
        this.genotypes = genotypes;
        this.chrName = chrName;
        this.position = position;
    }

    public String get(int idx) {
        return this.genotypes[idx];
    }

    public String[] getGenotypes() {
        return this.genotypes;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean has(String genotype) {
        String[] stringArray = this.genotypes;
        int n = this.genotypes.length;
        int n2 = 0;
        while (n2 < n) {
            String gen = stringArray[n2];
            if (gen.equals(genotype)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isHomozygous() {
        int i = 1;
        while (i < this.genotypes.length) {
            if (this.genotypes[i] != this.genotypes[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isValid() {
        String[] stringArray = this.genotypes;
        int n = this.genotypes.length;
        int n2 = 0;
        while (n2 < n) {
            String g = stringArray[n2];
            if (g.equalsIgnoreCase("x") || g.equalsIgnoreCase("0")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int size() {
        return this.genotypes.length;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean wcComplement) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.genotypes.length) {
            if (this.genotypes[i].isEmpty()) {
                sb.append(".");
            } else if (wcComplement) {
                sb.append(GprSeq.wc(this.genotypes[i]));
            } else {
                sb.append(this.genotypes[i]);
            }
            if (i < this.genotypes.length - 1) {
                sb.append("/");
            }
            ++i;
        }
        return sb.toString();
    }
}

