/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.overlap;

import ca.mcgill.mcb.pcingola.binseq.coder.Coder;

public class BasesChangeCounter {
    private static int CACHED_BASES = 8;
    private static int CACHED_BITS = 2 * CACHED_BASES;
    private static int MASK = (1 << CACHED_BITS) - 1;
    Coder coder;
    int[] changed;

    public BasesChangeCounter(Coder coder) {
        this.coder = coder;
        this.changed = new int[1 << CACHED_BITS];
        int i = 0;
        while (i < this.changed.length) {
            int count2 = 0;
            int ii = 0;
            while (ii < CACHED_BASES) {
                int j = i >> coder.bitsPerBase() * ii & (int)coder.mask(0);
                if (j != 0) {
                    ++count2;
                }
                ++ii;
            }
            this.changed[i] = count2;
            ++i;
        }
    }

    int changed(long xor) {
        if (xor == 0L) {
            return 0;
        }
        int changedBases = 0;
        int i = 0;
        while (i < 4) {
            long j = xor >>> i * CACHED_BITS & (long)MASK;
            changedBases += this.changed[(int)j];
            ++i;
        }
        return changedBases;
    }
}

