/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.nmer;

import ca.mcgill.mcb.pcingola.binseq.coder.Coder;
import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Nmer {
    public static final int MAX_NMER_SIZE = 32;
    static long[] MASK;
    private static final Coder coder;
    int length;
    long nmer;

    static {
        coder = DnaCoder.get();
        MASK = new long[coder.basesPerWord() + 1];
        long mask = 0L;
        int i = 0;
        while (i < MASK.length) {
            Nmer.MASK[i] = mask;
            mask |= mask << 2 | 3L;
            ++i;
        }
    }

    public Nmer(int length) {
        this.setLength(length);
        this.nmer = 0L;
    }

    public Nmer(String nmer) {
        this.set(nmer);
    }

    public long getNmer() {
        return this.nmer;
    }

    public int hashCode() {
        int low = (int)(this.nmer & 0xFFFFFFFFL);
        int high = (int)((this.nmer & 0xFFFFFFFF00000000L) >> 32);
        return high * 33 + low;
    }

    public int length() {
        return this.length;
    }

    public int read(InputStream outputStream) throws IOException {
        long l = 0L;
        int in = 0;
        int i = 0;
        while (i < 8) {
            in = outputStream.read();
            if (in < 0) {
                return in;
            }
            l = l << 8 | (long)(in & 0xFF);
            ++i;
        }
        this.nmer = l;
        return in;
    }

    public void rol(char base) {
        this.nmer <<= 2;
        this.nmer = MASK[this.length] & (this.nmer | (long)coder.baseToBits(base));
    }

    public void set(String seqStr) {
        if (seqStr == null) {
            this.length = 0;
            this.nmer = 0L;
        } else {
            this.nmer = 0L;
            this.setLength(seqStr.length());
            char[] seqChar = seqStr.toCharArray();
            int i = 0;
            while (i < this.length) {
                this.rol(seqChar[i]);
                ++i;
            }
        }
    }

    public void setLength(int length) {
        if (length < 1 || length > 32) {
            throw new RuntimeException("Nmer max length must be between 1 and " + coder.basesPerWord());
        }
        this.length = length;
    }

    public void setNmer(long nmer) {
        this.nmer = nmer;
    }

    public String toString() {
        char[] chars = new char[this.length];
        int i = this.length - 1;
        int j = 0;
        while (i >= 0) {
            chars[j] = coder.toBase(coder.decodeWord(this.nmer, i));
            --i;
            ++j;
        }
        return new String(chars);
    }

    public long wc() {
        return MASK[this.length] & (0xFFFFFFFFFFFFFFFFL ^ this.nmer);
    }

    public void write(OutputStream outputStream) throws IOException {
        int i = 56;
        while (i >= 0) {
            outputStream.write((int)(this.nmer >>> i));
            i -= 8;
        }
    }
}

